/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0014\n\u0002\b\u0006\b\u0007\u0018\u0000 32\u00020\u0001:\u000223B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\rJ\u0006\u0010#\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\nJ\u000e\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u001aJ\u000e\u0010'\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0018J\u000e\u0010(\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0018J\u000e\u0010)\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010*\u001a\u00020\u0018J\u0006\u0010+\u001a\u00020\u001aJ\u000e\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020&2\u0006\u0010\b\u001a\u00020.J\u0010\u00100\u001a\u00020\n2\b\u00101\u001a\u0004\u0018\u00010\u0000J\u000e\u0010/\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0001R\u0014\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u0010R\u001a\u0010\u001d\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Landroidx/constraintlayout/core/motion/CustomAttribute;", "", "name", "", "attributeType", "Landroidx/constraintlayout/core/motion/CustomAttribute$AttributeType;", "<init>", "(Ljava/lang/String;Landroidx/constraintlayout/core/motion/CustomAttribute$AttributeType;)V", "value", "method", "", "(Ljava/lang/String;Landroidx/constraintlayout/core/motion/CustomAttribute$AttributeType;Ljava/lang/Object;Z)V", "source", "(Landroidx/constraintlayout/core/motion/CustomAttribute;Ljava/lang/Object;)V", "mMethod", "getMMethod$annotations", "()V", "mName", "getMName", "()Ljava/lang/String;", "setMName", "(Ljava/lang/String;)V", "mType", "mIntegerValue", "", "mFloatValue", "", "mStringValue", "getMStringValue$annotations", "mBooleanValue", "getMBooleanValue", "()Z", "setMBooleanValue", "(Z)V", "mColorValue", "getType", "isContinuous", "setFloatValue", "", "setColorValue", "setIntValue", "setStringValue", "numberOfInterpolatedValues", "getValueToInterpolate", "getValuesToInterpolate", "ret", "", "setValue", "diff", "customAttribute", "AttributeType", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class CustomAttribute {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean mMethod;
    @NotNull
    private String mName;
    @NotNull
    private final AttributeType mType;
    private int mIntegerValue;
    private float mFloatValue;
    @Nullable
    private String mStringValue;
    private boolean mBooleanValue;
    private int mColorValue;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "TransitionLayout";

    private static /* synthetic */ void getMMethod$annotations() {
    }

    @NotNull
    public final String getMName() {
        return this.mName;
    }

    public final void setMName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mName = string;
    }

    private static /* synthetic */ void getMStringValue$annotations() {
    }

    public final boolean getMBooleanValue() {
        return this.mBooleanValue;
    }

    public final void setMBooleanValue(boolean bl) {
        this.mBooleanValue = bl;
    }

    @NotNull
    public final AttributeType getType() {
        return this.mType;
    }

    public final boolean isContinuous() {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.mType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public final void setFloatValue(float value) {
        this.mFloatValue = value;
    }

    public final void setColorValue(int value) {
        this.mColorValue = value;
    }

    public final void setIntValue(int value) {
        this.mIntegerValue = value;
    }

    public final void setStringValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mStringValue = value;
    }

    public final int numberOfInterpolatedValues() {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[this.mType.ordinal()]) {
            case 4: 
            case 5: {
                n = 4;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    public final float getValueToInterpolate() {
        float f;
        switch (WhenMappings.$EnumSwitchMapping$0[this.mType.ordinal()]) {
            case 6: {
                f = this.mIntegerValue;
                break;
            }
            case 7: {
                f = this.mFloatValue;
                break;
            }
            case 4: 
            case 5: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 3: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 2: {
                if (this.mBooleanValue) {
                    f = 1.0f;
                    break;
                }
                f = 0.0f;
                break;
            }
            case 8: {
                f = this.mFloatValue;
                break;
            }
            default: {
                f = Float.NaN;
            }
        }
        return f;
    }

    public final void getValuesToInterpolate(@NotNull float[] ret) {
        Intrinsics.checkNotNullParameter((Object)ret, (String)"ret");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mType.ordinal()]) {
            case 6: {
                ret[0] = this.mIntegerValue;
                break;
            }
            case 7: {
                ret[0] = this.mFloatValue;
                break;
            }
            case 4: 
            case 5: {
                int a = 0xFF & this.mColorValue >> 24;
                int r = 0xFF & this.mColorValue >> 16;
                int g = 0xFF & this.mColorValue >> 8;
                int b = 0xFF & this.mColorValue;
                float f_r = (float)Math.pow((float)r / 255.0f, 2.2f);
                float f_g = (float)Math.pow((float)g / 255.0f, 2.2f);
                float f_b = (float)Math.pow((float)b / 255.0f, 2.2f);
                ret[0] = f_r;
                ret[1] = f_g;
                ret[2] = f_b;
                ret[3] = (float)a / 255.0f;
                break;
            }
            case 3: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 2: {
                ret[0] = this.mBooleanValue ? 1 : 0;
                break;
            }
            case 8: {
                ret[0] = this.mFloatValue;
            }
        }
    }

    public final void setValue(@NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mType.ordinal()]) {
            case 1: 
            case 6: {
                this.mIntegerValue = (int)value[0];
                break;
            }
            case 7: {
                this.mFloatValue = value[0];
                break;
            }
            case 4: 
            case 5: {
                this.mColorValue = Companion.hsvToRgb(value[0], value[1], value[2]);
                this.mColorValue = this.mColorValue & 0xFFFFFF | CustomAttribute.Companion.clamp((int)((float)255 * value[3])) << 24;
                break;
            }
            case 3: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 2: {
                this.mBooleanValue = (double)value[0] > 0.5;
                break;
            }
            case 8: {
                this.mFloatValue = value[0];
            }
        }
    }

    public final boolean diff(@Nullable CustomAttribute customAttribute) {
        boolean bl;
        if (customAttribute == null || this.mType != customAttribute.mType) {
            bl = false;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.mType.ordinal()]) {
                case 1: 
                case 6: {
                    if (this.mIntegerValue == customAttribute.mIntegerValue) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 7: {
                    if (this.mFloatValue == customAttribute.mFloatValue) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: 
                case 5: {
                    if (this.mColorValue == customAttribute.mColorValue) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (this.mIntegerValue == customAttribute.mIntegerValue) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (this.mBooleanValue == customAttribute.mBooleanValue) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 8: {
                    if (this.mFloatValue == customAttribute.mFloatValue) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public CustomAttribute(@NotNull String name, @NotNull AttributeType attributeType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)attributeType), (String)"attributeType");
        this.mName = name;
        this.mType = attributeType;
    }

    public CustomAttribute(@NotNull String name, @NotNull AttributeType attributeType, @NotNull Object value, boolean method) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)attributeType), (String)"attributeType");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mName = name;
        this.mType = attributeType;
        this.mMethod = method;
        this.setValue(value);
    }

    public CustomAttribute(@NotNull CustomAttribute source, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mName = source.mName;
        this.mType = source.mType;
        this.setValue(value);
    }

    public final void setValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mType.ordinal()]) {
            case 1: 
            case 6: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case 7: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
            case 4: 
            case 5: {
                this.mColorValue = (Integer)value;
                break;
            }
            case 3: {
                this.mStringValue = (String)value;
                break;
            }
            case 2: {
                this.mBooleanValue = (Boolean)value;
                break;
            }
            case 8: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Landroidx/constraintlayout/core/motion/CustomAttribute$AttributeType;", "", "<init>", "(Ljava/lang/String;I)V", "INT_TYPE", "FLOAT_TYPE", "COLOR_TYPE", "COLOR_DRAWABLE_TYPE", "STRING_TYPE", "BOOLEAN_TYPE", "DIMENSION_TYPE", "REFERENCE_TYPE", "compose"})
    public static final class AttributeType
    extends Enum<AttributeType> {
        public static final /* enum */ AttributeType INT_TYPE = new AttributeType();
        public static final /* enum */ AttributeType FLOAT_TYPE = new AttributeType();
        public static final /* enum */ AttributeType COLOR_TYPE = new AttributeType();
        public static final /* enum */ AttributeType COLOR_DRAWABLE_TYPE = new AttributeType();
        public static final /* enum */ AttributeType STRING_TYPE = new AttributeType();
        public static final /* enum */ AttributeType BOOLEAN_TYPE = new AttributeType();
        public static final /* enum */ AttributeType DIMENSION_TYPE = new AttributeType();
        public static final /* enum */ AttributeType REFERENCE_TYPE = new AttributeType();
        private static final /* synthetic */ AttributeType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AttributeType[] values() {
            return (AttributeType[])$VALUES.clone();
        }

        public static AttributeType valueOf(String value) {
            return Enum.valueOf(AttributeType.class, value);
        }

        @NotNull
        public static EnumEntries<AttributeType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = attributeTypeArray = new AttributeType[]{AttributeType.INT_TYPE, AttributeType.FLOAT_TYPE, AttributeType.COLOR_TYPE, AttributeType.COLOR_DRAWABLE_TYPE, AttributeType.STRING_TYPE, AttributeType.BOOLEAN_TYPE, AttributeType.DIMENSION_TYPE, AttributeType.REFERENCE_TYPE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/constraintlayout/core/motion/CustomAttribute$Companion;", "", "<init>", "()V", "TAG", "", "hsvToRgb", "", "hue", "", "saturation", "value", "clamp", "c", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public final int hsvToRgb(float hue, float saturation, float value) {
            int n;
            int h = (int)(hue * (float)6);
            float f = hue * (float)6 - (float)h;
            int p = (int)(0.5f + (float)255 * value * (1.0f - saturation));
            int q = (int)(0.5f + (float)255 * value * (1.0f - f * saturation));
            int t = (int)(0.5f + (float)255 * value * (1.0f - (1.0f - f) * saturation));
            int v = (int)(0.5f + (float)255 * value);
            switch (h) {
                case 0: {
                    n = 0xFF000000 | (v << 16) + (t << 8) + p;
                    break;
                }
                case 1: {
                    n = 0xFF000000 | (q << 16) + (v << 8) + p;
                    break;
                }
                case 2: {
                    n = 0xFF000000 | (p << 16) + (v << 8) + t;
                    break;
                }
                case 3: {
                    n = 0xFF000000 | (p << 16) + (q << 8) + v;
                    break;
                }
                case 4: {
                    n = 0xFF000000 | (t << 16) + (p << 8) + v;
                    break;
                }
                case 5: {
                    n = 0xFF000000 | (v << 16) + (p << 8) + q;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }

        private final int clamp(int c) {
            int c2 = c;
            int n = 255;
            c2 &= ~(c2 >> 31);
            c2 -= n;
            c2 &= c2 >> 31;
            return c2 += n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AttributeType.values().length];
            try {
                nArray[AttributeType.REFERENCE_TYPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeType.BOOLEAN_TYPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeType.STRING_TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeType.COLOR_TYPE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeType.COLOR_DRAWABLE_TYPE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeType.INT_TYPE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeType.FLOAT_TYPE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeType.DIMENSION_TYPE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

