/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.dsl.Constraint;
import androidx.constraintlayout.core.dsl.Helper;
import androidx.constraintlayout.core.dsl.Ref;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0007J\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rj\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/constraintlayout/core/dsl/Barrier;", "Landroidx/constraintlayout/core/dsl/Helper;", "name", "", "<init>", "(Ljava/lang/String;)V", "config", "(Ljava/lang/String;Ljava/lang/String;)V", "mDirection", "Landroidx/constraintlayout/core/dsl/Constraint$Side;", "mMargin", "", "references", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/dsl/Ref;", "Lkotlin/collections/ArrayList;", "getDirection", "setDirection", "", "direction", "getMargin", "setMargin", "margin", "referencesToString", "addReference", "ref", "compose"})
@StabilityInferred(parameters=0)
public final class Barrier
extends Helper {
    @Nullable
    private Constraint.Side mDirection;
    private int mMargin;
    @NotNull
    private final ArrayList<Ref> references;
    public static final int $stable = 8;

    public Barrier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = Helper.getTypeMap().get((Object)Helper.Type.BARRIER);
        Intrinsics.checkNotNull((Object)string);
        super(name, new Helper.HelperType(string));
        this.mMargin = Integer.MIN_VALUE;
        this.references = new ArrayList();
    }

    public Barrier(@NotNull String name, @NotNull String config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = Helper.getTypeMap().get((Object)Helper.Type.BARRIER);
        Intrinsics.checkNotNull((Object)string);
        super(name, new Helper.HelperType(string), config);
        this.mMargin = Integer.MIN_VALUE;
        this.references = new ArrayList();
        Map<String, String> map = this.convertConfigToMap();
        Intrinsics.checkNotNull(map);
        this.setConfigMap(MapsKt.toMutableMap(map));
        Map<String, String> map2 = this.getConfigMap();
        Intrinsics.checkNotNull(map2);
        if (map2.containsKey("contains")) {
            Map<String, String> map3 = this.getConfigMap();
            Intrinsics.checkNotNull(map3);
            Ref.Companion.addStringToReferences(map3.get("contains"), this.references);
        }
    }

    @Nullable
    public final Constraint.Side getDirection() {
        return this.mDirection;
    }

    public final void setDirection(@NotNull Constraint.Side direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.mDirection = direction;
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        String string = Helper.getSideMap().get((Object)direction);
        Intrinsics.checkNotNull((Object)string);
        map.put("direction", string);
    }

    public final int getMargin() {
        return this.mMargin;
    }

    public final void setMargin(int margin) {
        this.mMargin = margin;
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("margin", String.valueOf(margin));
    }

    @NotNull
    public final String referencesToString() {
        if (this.references.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("[");
        Iterator<Ref> iterator = this.references.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Ref> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Ref ref = iterator2.next();
            builder.append(String.valueOf(ref));
        }
        builder.append("]");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Barrier addReference(@Nullable Ref ref) {
        this.references.add(ref);
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("contains", this.referencesToString());
        return this;
    }

    @NotNull
    public final Barrier addReference(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this.addReference(Ref.Companion.parseStringToRef(ref));
    }
}

