/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.SolverVariable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0017\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\u0012\u0010%\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010\u001eH\u0016J\u0013\u0010&\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0006\u0010+\u001a\u00020(J\b\u0010,\u001a\u00020(H\u0002J\u0018\u0010-\u001a\u00020(2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\b\u0010.\u001a\u00020(H\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u0010$\u001a\u00020\u001eH\u0002J \u00100\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001e2\u0006\u00101\u001a\u00020!H\u0002J\b\u00102\u001a\u00020\tH\u0002J \u00103\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001e2\u0006\u00101\u001a\u00020!H\u0002J\u001a\u00104\u001a\u00020(2\b\u0010$\u001a\u0004\u0018\u00010\u001e2\u0006\u00101\u001a\u00020!H\u0016J\b\u00105\u001a\u00020\tH\u0016J\u001a\u00106\u001a\u00020!2\b\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u00108\u001a\u00020#H\u0016J\"\u00109\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u00101\u001a\u00020!2\u0006\u00108\u001a\u00020#H\u0016J\u001a\u0010:\u001a\u00020!2\b\u0010;\u001a\u0004\u0018\u00010\u00032\u0006\u00108\u001a\u00020#H\u0016J\b\u0010<\u001a\u00020(H\u0016J\u0010\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020!H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006@"}, d2={"Landroidx/constraintlayout/core/SolverVariableValues;", "Landroidx/constraintlayout/core/ArrayRow$ArrayRowVariables;", "row", "Landroidx/constraintlayout/core/ArrayRow;", "cache", "Landroidx/constraintlayout/core/Cache;", "<init>", "(Landroidx/constraintlayout/core/ArrayRow;Landroidx/constraintlayout/core/Cache;)V", "mNone", "", "mSize", "mHashSize", "mKeys", "", "mNextKeys", "mVariables", "mValues", "", "mPrevious", "mNext", "mCount", "mHead", "mRow", "mCache", "getMCache", "()Landroidx/constraintlayout/core/Cache;", "currentSize", "getCurrentSize", "()I", "getVariable", "Landroidx/constraintlayout/core/SolverVariable;", "index", "getVariableValue", "", "contains", "", "variable", "indexOf", "get", "display", "", "toString", "", "clear", "increaseSize", "addToHashMap", "displayHash", "removeFromHashMap", "addVariable", "value", "findEmptySlot", "insertVariable", "put", "sizeInBytes", "remove", "v", "removeFromDefinition", "add", "use", "definition", "invert", "divideByAmount", "amount", "Companion", "compose"})
@StabilityInferred(parameters=0)
public class SolverVariableValues
implements ArrayRow.ArrayRowVariables {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int mNone;
    private int mSize;
    private final int mHashSize;
    @NotNull
    private int[] mKeys;
    @NotNull
    private int[] mNextKeys;
    @NotNull
    private int[] mVariables;
    @NotNull
    private float[] mValues;
    @NotNull
    private int[] mPrevious;
    @NotNull
    private int[] mNext;
    private int mCount;
    private int mHead;
    @Nullable
    private final ArrayRow mRow;
    @NotNull
    private final Cache mCache;
    public static final int $stable = 8;
    private static final boolean DEBUG = false;
    private static final boolean HASH = true;
    private static final float S_EPSILON = 0.001f;

    public SolverVariableValues(@Nullable ArrayRow row, @NotNull Cache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.mNone = -1;
        this.mSize = 16;
        this.mHashSize = 16;
        this.mKeys = new int[this.mSize];
        this.mNextKeys = new int[this.mSize];
        this.mVariables = new int[this.mSize];
        this.mValues = new float[this.mSize];
        this.mPrevious = new int[this.mSize];
        this.mNext = new int[this.mSize];
        this.mHead = -1;
        this.mRow = row;
        this.mCache = cache;
        this.clear();
    }

    @NotNull
    protected final Cache getMCache() {
        return this.mCache;
    }

    @Override
    public int getCurrentSize() {
        return this.mCount;
    }

    @Override
    @Nullable
    public SolverVariable getVariable(int index) {
        int count = this.mCount;
        if (count == 0) {
            return null;
        }
        int j = this.mHead;
        for (int i = 0; i < count; ++i) {
            if (i == index && j != this.mNone) {
                return this.mCache.getMIndexedVariables()[this.mVariables[j]];
            }
            if ((j = this.mNext[j]) == this.mNone) break;
        }
        return null;
    }

    @Override
    public float getVariableValue(int index) {
        int count = this.mCount;
        int j = this.mHead;
        for (int i = 0; i < count; ++i) {
            if (i == index) {
                return this.mValues[j];
            }
            if ((j = this.mNext[j]) == this.mNone) break;
        }
        return 0.0f;
    }

    @Override
    public boolean contains(@Nullable SolverVariable variable) {
        return this.indexOf(variable) != this.mNone;
    }

    @Override
    public int indexOf(@Nullable SolverVariable variable) {
        if (this.mCount == 0 || variable == null) {
            return this.mNone;
        }
        int id = variable.getId();
        int key = id % this.mHashSize;
        if ((key = this.mKeys[key]) == this.mNone) {
            return this.mNone;
        }
        if (this.mVariables[key] == id) {
            return key;
        }
        while (this.mNextKeys[key] != this.mNone && this.mVariables[this.mNextKeys[key]] != id) {
            key = this.mNextKeys[key];
        }
        if (this.mNextKeys[key] == this.mNone) {
            return this.mNone;
        }
        return this.mVariables[this.mNextKeys[key]] == id ? this.mNextKeys[key] : this.mNone;
    }

    @Override
    public float get(@Nullable SolverVariable variable) {
        int index = this.indexOf(variable);
        return index != this.mNone ? this.mValues[index] : 0.0f;
    }

    @Override
    public void display() {
        int count = this.mCount;
        System.out.print((Object)"{ ");
        for (int i = 0; i < count; ++i) {
            SolverVariable v;
            if (this.getVariable(i) == null) continue;
            System.out.print((Object)(v + " = " + this.getVariableValue(i) + " "));
        }
        System.out.println((Object)" }");
    }

    @NotNull
    public String toString() {
        String str = this.hashCode() + " { ";
        int count = this.mCount;
        for (int i = 0; i < count; ++i) {
            SolverVariable v;
            if (this.getVariable(i) == null) continue;
            str = str + v + " = " + this.getVariableValue(i) + " ";
            int index = this.indexOf(v);
            str = str + "[p: ";
            str = this.mPrevious[index] != this.mNone ? str + this.mCache.getMIndexedVariables()[this.mVariables[this.mPrevious[index]]] : str + "none";
            str = str + ", n: ";
            str = this.mNext[index] != this.mNone ? str + this.mCache.getMIndexedVariables()[this.mVariables[this.mNext[index]]] : str + "none";
            str = str + "]";
        }
        str = str + " }";
        return str;
    }

    @Override
    public final void clear() {
        int i;
        int count = this.mCount;
        for (i = 0; i < count; ++i) {
            SolverVariable v;
            SolverVariable solverVariable = v = this.getVariable(i);
            Intrinsics.checkNotNull((Object)solverVariable);
            solverVariable.removeFromRow(this.mRow);
        }
        int n = this.mSize;
        for (i = 0; i < n; ++i) {
            this.mVariables[i] = this.mNone;
            this.mNextKeys[i] = this.mNone;
        }
        n = this.mHashSize;
        for (i = 0; i < n; ++i) {
            this.mKeys[i] = this.mNone;
        }
        this.mCount = 0;
        this.mHead = -1;
    }

    private final void increaseSize() {
        int size = this.mSize * 2;
        int[] nArray = Arrays.copyOf(this.mVariables, size);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.mVariables = nArray;
        float[] fArray = Arrays.copyOf(this.mValues, size);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        this.mValues = fArray;
        int[] nArray2 = Arrays.copyOf(this.mPrevious, size);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        this.mPrevious = nArray2;
        int[] nArray3 = Arrays.copyOf(this.mNext, size);
        Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"copyOf(...)");
        this.mNext = nArray3;
        int[] nArray4 = Arrays.copyOf(this.mNextKeys, size);
        Intrinsics.checkNotNullExpressionValue((Object)nArray4, (String)"copyOf(...)");
        this.mNextKeys = nArray4;
        for (int i = this.mSize; i < size; ++i) {
            this.mVariables[i] = this.mNone;
            this.mNextKeys[i] = this.mNone;
        }
        this.mSize = size;
    }

    private final void addToHashMap(SolverVariable variable, int index) {
        int hash = variable.getId() % this.mHashSize;
        int key = this.mKeys[hash];
        if (key == this.mNone) {
            this.mKeys[hash] = index;
        } else {
            while (this.mNextKeys[key] != this.mNone) {
                key = this.mNextKeys[key];
            }
            this.mNextKeys[key] = index;
        }
        this.mNextKeys[index] = this.mNone;
    }

    private final void displayHash() {
        int n = this.mHashSize;
        for (int i = 0; i < n; ++i) {
            if (this.mKeys[i] == this.mNone) continue;
            String str = this.hashCode() + " hash [" + i + "] => ";
            int key = this.mKeys[i];
            boolean done = false;
            while (!done) {
                str = str + " " + this.mVariables[key];
                if (this.mNextKeys[key] != this.mNone) {
                    key = this.mNextKeys[key];
                    continue;
                }
                done = true;
            }
            System.out.println((Object)str);
        }
    }

    private final void removeFromHashMap(SolverVariable variable) {
        int hash = variable.getId() % this.mHashSize;
        int key = this.mKeys[hash];
        if (key == this.mNone) {
            return;
        }
        int id = variable.getId();
        if (this.mVariables[key] == id) {
            this.mKeys[hash] = this.mNextKeys[key];
            this.mNextKeys[key] = this.mNone;
        } else {
            while (this.mNextKeys[key] != this.mNone && this.mVariables[this.mNextKeys[key]] != id) {
                key = this.mNextKeys[key];
            }
            int currentKey = this.mNextKeys[key];
            if (currentKey != this.mNone && this.mVariables[currentKey] == id) {
                this.mNextKeys[key] = this.mNextKeys[currentKey];
                this.mNextKeys[currentKey] = this.mNone;
            }
        }
    }

    private final void addVariable(int index, SolverVariable variable, float value) {
        this.mVariables[index] = variable.getId();
        this.mValues[index] = value;
        this.mPrevious[index] = this.mNone;
        this.mNext[index] = this.mNone;
        variable.addToRow(this.mRow);
        int n = variable.getUsageInRowCount();
        variable.setUsageInRowCount(n + 1);
        n = this.mCount;
        this.mCount = n + 1;
    }

    private final int findEmptySlot() {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mVariables[i] != this.mNone) continue;
            return i;
        }
        return -1;
    }

    private final void insertVariable(int index, SolverVariable variable, float value) {
        int availableSlot = this.findEmptySlot();
        this.addVariable(availableSlot, variable, value);
        if (index != this.mNone) {
            this.mPrevious[availableSlot] = index;
            this.mNext[availableSlot] = this.mNext[index];
            this.mNext[index] = availableSlot;
        } else {
            this.mPrevious[availableSlot] = this.mNone;
            if (this.mCount > 0) {
                this.mNext[availableSlot] = this.mHead;
                this.mHead = availableSlot;
            } else {
                this.mNext[availableSlot] = this.mNone;
            }
        }
        if (this.mNext[availableSlot] != this.mNone) {
            this.mPrevious[this.mNext[availableSlot]] = availableSlot;
        }
        this.addToHashMap(variable, availableSlot);
    }

    @Override
    public void put(@Nullable SolverVariable variable, float value) {
        if (value > -0.001f && value < 0.001f) {
            this.remove(variable, true);
            return;
        }
        if (this.mCount == 0) {
            SolverVariable solverVariable = variable;
            Intrinsics.checkNotNull((Object)solverVariable);
            this.addVariable(0, solverVariable, value);
            this.addToHashMap(variable, 0);
            this.mHead = 0;
        } else {
            int index = this.indexOf(variable);
            if (index != this.mNone) {
                this.mValues[index] = value;
            } else {
                if (this.mCount + 1 >= this.mSize) {
                    this.increaseSize();
                }
                int count = this.mCount;
                int previousItem = -1;
                int j = this.mHead;
                for (int i = 0; i < count; ++i) {
                    int n = this.mVariables[j];
                    SolverVariable solverVariable = variable;
                    Intrinsics.checkNotNull((Object)solverVariable);
                    if (n == solverVariable.getId()) {
                        this.mValues[j] = value;
                        return;
                    }
                    if (this.mVariables[j] < variable.getId()) {
                        previousItem = j;
                    }
                    if ((j = this.mNext[j]) == this.mNone) break;
                }
                SolverVariable solverVariable = variable;
                Intrinsics.checkNotNull((Object)solverVariable);
                this.insertVariable(previousItem, solverVariable, value);
            }
        }
    }

    @Override
    public int sizeInBytes() {
        return 0;
    }

    @Override
    public float remove(@Nullable SolverVariable v, boolean removeFromDefinition) {
        int index = this.indexOf(v);
        if (index == this.mNone) {
            return 0.0f;
        }
        SolverVariable solverVariable = v;
        Intrinsics.checkNotNull((Object)solverVariable);
        this.removeFromHashMap(solverVariable);
        float value = this.mValues[index];
        if (this.mHead == index) {
            this.mHead = this.mNext[index];
        }
        this.mVariables[index] = this.mNone;
        if (this.mPrevious[index] != this.mNone) {
            this.mNext[this.mPrevious[index]] = this.mNext[index];
        }
        if (this.mNext[index] != this.mNone) {
            this.mPrevious[this.mNext[index]] = this.mPrevious[index];
        }
        int n = this.mCount;
        this.mCount = n + -1;
        n = v.getUsageInRowCount();
        v.setUsageInRowCount(n + -1);
        if (removeFromDefinition) {
            v.removeFromRow(this.mRow);
        }
        return value;
    }

    @Override
    public void add(@Nullable SolverVariable v, float value, boolean removeFromDefinition) {
        if (value > -0.001f && value < 0.001f) {
            return;
        }
        int index = this.indexOf(v);
        if (index == this.mNone) {
            this.put(v, value);
        } else {
            float[] fArray = this.mValues;
            fArray[index] = fArray[index] + value;
            if (this.mValues[index] > -0.001f && this.mValues[index] < 0.001f) {
                this.mValues[index] = 0.0f;
                this.remove(v, removeFromDefinition);
            }
        }
    }

    @Override
    public float use(@Nullable ArrayRow definition, boolean removeFromDefinition) {
        SolverVariableValues localDef;
        ArrayRow arrayRow = definition;
        Intrinsics.checkNotNull((Object)arrayRow);
        float value = this.get(arrayRow.getMVariable());
        this.remove(definition.getMVariable(), removeFromDefinition);
        SolverVariableValues solverVariableValues = localDef = (SolverVariableValues)definition.getVariables();
        Intrinsics.checkNotNull((Object)solverVariableValues);
        int definitionSize = solverVariableValues.getCurrentSize();
        int j = localDef.mHead;
        j = 0;
        int i = 0;
        while (j < definitionSize) {
            if (localDef.mVariables[i] != this.mNone) {
                SolverVariable definitionVariable;
                float definitionValue = localDef.mValues[i];
                Intrinsics.checkNotNull((Object)this.mCache.getMIndexedVariables()[localDef.mVariables[i]]);
                this.add(definitionVariable, definitionValue * value, removeFromDefinition);
                ++j;
            }
            ++i;
        }
        return value;
    }

    @Override
    public void invert() {
        int count = this.mCount;
        int j = this.mHead;
        for (int i = 0; i < count; ++i) {
            this.mValues[j] = this.mValues[j] * (float)-1;
            if ((j = this.mNext[j]) == this.mNone) break;
        }
    }

    @Override
    public void divideByAmount(float amount) {
        int count = this.mCount;
        int j = this.mHead;
        for (int i = 0; i < count; ++i) {
            float[] fArray = this.mValues;
            int n = j;
            fArray[n] = fArray[n] / amount;
            if ((j = this.mNext[j]) == this.mNone) break;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/constraintlayout/core/SolverVariableValues$Companion;", "", "<init>", "()V", "DEBUG", "", "HASH", "getHASH$annotations", "S_EPSILON", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getHASH$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

