/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ArrayLinkedVariables;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0018\n\u0002\b\f\b\u0017\u0018\u0000 w2\u00020\u0001:\u0002vwB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0006\u0010%\u001a\u00020\u0014J\b\u0010&\u001a\u00020'H\u0016J\u0006\u0010(\u001a\u00020'J\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010\bJ\u0016\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u000200J\u0018\u00101\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010\b2\u0006\u0010/\u001a\u000200J\"\u00101\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\b2\b\u00103\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u000200J\u0018\u00105\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u000200J,\u00108\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\b2\b\u00103\u001a\u0004\u0018\u00010\b2\b\u00109\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u000200J\"\u00108\u001a\u00020\u00002\b\u0010:\u001a\u0004\u0018\u00010\b2\u0006\u0010;\u001a\u0002002\b\u00109\u001a\u0004\u0018\u00010\bJ,\u0010<\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\b2\b\u00103\u001a\u0004\u0018\u00010\b2\b\u00109\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u000200JF\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u000e2\b\u0010A\u001a\u0004\u0018\u00010\b2\b\u0010B\u001a\u0004\u0018\u00010\b2\b\u0010C\u001a\u0004\u0018\u00010\b2\b\u0010D\u001a\u0004\u0018\u00010\bJf\u0010E\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u000e2\b\u0010A\u001a\u0004\u0018\u00010\b2\u0006\u0010F\u001a\u0002002\b\u0010B\u001a\u0004\u0018\u00010\b2\u0006\u0010G\u001a\u0002002\b\u0010C\u001a\u0004\u0018\u00010\b2\u0006\u0010H\u001a\u0002002\b\u0010D\u001a\u0004\u0018\u00010\b2\u0006\u0010I\u001a\u000200JB\u0010J\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\b2\u0006\u00103\u001a\u00020\b2\u0006\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020\u000e2\u0006\u0010M\u001a\u00020\b2\b\u0010N\u001a\u0004\u0018\u00010\b2\u0006\u0010O\u001a\u000200J\u0016\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u000200J\"\u0010T\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\b2\b\u0010M\u001a\u0004\u0018\u00010\b2\u0006\u0010U\u001a\u00020\u000eJ6\u0010V\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\b2\b\u00103\u001a\u0004\u0018\u00010\b2\b\u0010M\u001a\u0004\u0018\u00010\b2\b\u0010N\u001a\u0004\u0018\u00010\b2\u0006\u0010W\u001a\u00020\u000eJ6\u0010X\u001a\u00020\u00002\b\u0010Y\u001a\u0004\u0018\u00010\b2\b\u0010Z\u001a\u0004\u0018\u00010\b2\b\u0010[\u001a\u0004\u0018\u00010\b2\b\u0010\\\u001a\u0004\u0018\u00010\b2\u0006\u0010]\u001a\u00020\u000eJ\u0006\u0010^\u001a\u000200J\u0006\u0010_\u001a\u00020*J\u0010\u0010`\u001a\u00020\u00142\b\u0010Q\u001a\u0004\u0018\u00010RJ\u0012\u0010a\u001a\u0004\u0018\u00010\b2\b\u0010Q\u001a\u0004\u0018\u00010RJ\u001c\u0010b\u001a\u00020\u00142\b\u0010.\u001a\u0004\u0018\u00010\b2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0002J\u000e\u0010c\u001a\u00020*2\u0006\u0010,\u001a\u00020\bJ$\u0010e\u001a\u00020*2\b\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010f\u001a\u0004\u0018\u00010\u00002\u0006\u0010g\u001a\u00020\u0014H\u0016J$\u0010h\u001a\u00020*2\b\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010.\u001a\u0004\u0018\u00010\b2\u0006\u0010g\u001a\u00020\u0014H\u0016J \u0010i\u001a\u00020*2\u0006\u0010Q\u001a\u00020R2\b\u0010.\u001a\u0004\u0018\u00010\b2\u0006\u0010g\u001a\u00020\u0014J\u001e\u0010j\u001a\u0004\u0018\u00010\b2\b\u0010k\u001a\u0004\u0018\u00010l2\b\u0010m\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010n\u001a\u0004\u0018\u00010\b2\b\u0010m\u001a\u0004\u0018\u00010\bJ\u001e\u0010o\u001a\u0004\u0018\u00010\b2\b\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010k\u001a\u0004\u0018\u00010lH\u0016J\b\u0010p\u001a\u00020*H\u0016J\u0012\u0010q\u001a\u00020*2\b\u0010r\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010P\u001a\u00020*2\b\u00106\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010u\u001a\u00020*2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\b0\u001aj\b\u0012\u0004\u0012\u00020\b`\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u0014\u0010d\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010\u0016R\u0016\u0010s\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bt\u0010\n\u00a8\u0006x"}, d2={"Landroidx/constraintlayout/core/ArrayRow;", "Landroidx/constraintlayout/core/LinearSystem$Row;", "<init>", "()V", "cache", "Landroidx/constraintlayout/core/Cache;", "(Landroidx/constraintlayout/core/Cache;)V", "mVariable", "Landroidx/constraintlayout/core/SolverVariable;", "getMVariable", "()Landroidx/constraintlayout/core/SolverVariable;", "setMVariable", "(Landroidx/constraintlayout/core/SolverVariable;)V", "mConstantValue", "", "getMConstantValue", "()F", "setMConstantValue", "(F)V", "mUsed", "", "getMUsed", "()Z", "setMUsed", "(Z)V", "mVariablesToUpdate", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "variables", "Landroidx/constraintlayout/core/ArrayRow$ArrayRowVariables;", "getVariables", "()Landroidx/constraintlayout/core/ArrayRow$ArrayRowVariables;", "setVariables", "(Landroidx/constraintlayout/core/ArrayRow$ArrayRowVariables;)V", "mIsSimpleDefinition", "getMIsSimpleDefinition", "setMIsSimpleDefinition", "hasKeyVariable", "toString", "", "toReadableString", "reset", "", "hasVariable", "v", "createRowDefinition", "variable", "value", "", "createRowEquals", "variableA", "variableB", "margin", "addSingleError", "error", "sign", "createRowGreaterThan", "slack", "a", "b", "createRowLowerThan", "createRowEqualMatchDimensions", "currentWeight", "totalWeights", "nextWeight", "variableStartA", "variableEndA", "variableStartB", "variableEndB", "createRowEqualDimension", "marginStartA", "marginEndA", "marginStartB", "marginEndB", "createRowCentering", "marginA", "bias", "variableC", "variableD", "marginB", "addError", "system", "Landroidx/constraintlayout/core/LinearSystem;", "strength", "createRowDimensionPercent", "percent", "createRowDimensionRatio", "ratio", "createRowWithAngle", "at", "ab", "bt", "bb", "angleComponent", "sizeInBytes", "ensurePositiveConstant", "chooseSubject", "chooseSubjectInVariables", "isNew", "pivot", "isEmpty", "updateFromRow", "definition", "removeFromDefinition", "updateFromFinalVariable", "updateFromSynonymVariable", "pickPivotInVariables", "avoid", "", "exclude", "pickPivot", "getPivotCandidate", "clear", "initFromRow", "row", "key", "getKey", "updateFromSystem", "ArrayRowVariables", "Companion", "compose"})
@StabilityInferred(parameters=0)
public class ArrayRow
implements LinearSystem.Row {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SolverVariable mVariable;
    private float mConstantValue;
    private boolean mUsed;
    @NotNull
    private ArrayList<SolverVariable> mVariablesToUpdate;
    @Nullable
    private ArrayRowVariables variables;
    private boolean mIsSimpleDefinition;
    public static final int $stable = 8;
    private static final boolean DEBUG = false;
    private static final boolean FULL_NEW_CHECK = false;

    @Nullable
    public final SolverVariable getMVariable() {
        return this.mVariable;
    }

    public final void setMVariable(@Nullable SolverVariable solverVariable) {
        this.mVariable = solverVariable;
    }

    public final float getMConstantValue() {
        return this.mConstantValue;
    }

    public final void setMConstantValue(float f) {
        this.mConstantValue = f;
    }

    public final boolean getMUsed() {
        return this.mUsed;
    }

    public final void setMUsed(boolean bl) {
        this.mUsed = bl;
    }

    @Nullable
    public final ArrayRowVariables getVariables() {
        return this.variables;
    }

    public final void setVariables(@Nullable ArrayRowVariables arrayRowVariables) {
        this.variables = arrayRowVariables;
    }

    public final boolean getMIsSimpleDefinition() {
        return this.mIsSimpleDefinition;
    }

    public final void setMIsSimpleDefinition(boolean bl) {
        this.mIsSimpleDefinition = bl;
    }

    public ArrayRow() {
        this.mVariablesToUpdate = new ArrayList();
    }

    public ArrayRow(@NotNull Cache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this();
        this.variables = new ArrayLinkedVariables(this, cache);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasKeyVariable() {
        if (this.mVariable == null) return false;
        SolverVariable solverVariable = this.mVariable;
        Intrinsics.checkNotNull((Object)solverVariable);
        if (solverVariable.getMType() == SolverVariable.Type.UNRESTRICTED) return true;
        if (this.mConstantValue < 0.0f) return false;
        return true;
    }

    @NotNull
    public String toString() {
        return this.toReadableString();
    }

    @NotNull
    public final String toReadableString() {
        Object s = "";
        s = this.mVariable == null ? (String)s + "0" : (String)s + this.mVariable;
        s = (String)s + " = ";
        boolean addedVariable = false;
        if (!(this.mConstantValue == 0.0f)) {
            s = (String)s + this.mConstantValue;
            addedVariable = true;
        }
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        int count = arrayRowVariables.getCurrentSize();
        for (int i = 0; i < count; ++i) {
            SolverVariable v;
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            if (arrayRowVariables2.getVariable(i) == null) continue;
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            float amount = arrayRowVariables3.getVariableValue(i);
            if (amount == 0.0f) continue;
            String name = v.toString();
            if (!addedVariable) {
                if (amount < 0.0f) {
                    s = (String)s + "- ";
                    amount *= -1.0f;
                }
            } else if (amount > 0.0f) {
                s = (String)s + " + ";
            } else {
                s = (String)s + " - ";
                amount *= -1.0f;
            }
            s = (String)s + (String)(amount == 1.0f ? name : amount + " " + name);
            addedVariable = true;
        }
        if (!addedVariable) {
            s = (String)s + "0.0";
        }
        return s;
    }

    public final void reset() {
        this.mVariable = null;
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.clear();
        this.mConstantValue = 0.0f;
        this.mIsSimpleDefinition = false;
    }

    public final boolean hasVariable(@Nullable SolverVariable v) {
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        return arrayRowVariables.contains(v);
    }

    @NotNull
    public final ArrayRow createRowDefinition(@NotNull SolverVariable variable, int value) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.mVariable = variable;
        variable.setComputedValue(value);
        this.mConstantValue = value;
        this.mIsSimpleDefinition = true;
        return this;
    }

    @NotNull
    public final ArrayRow createRowEquals(@Nullable SolverVariable variable, int value) {
        if (value < 0) {
            this.mConstantValue = -1 * value;
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variable, 1.0f);
        } else {
            this.mConstantValue = value;
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variable, -1.0f);
        }
        return this;
    }

    @NotNull
    public final ArrayRow createRowEquals(@Nullable SolverVariable variableA, @Nullable SolverVariable variableB, int margin) {
        boolean inverse = false;
        if (margin != 0) {
            int m = margin;
            if (m < 0) {
                m *= -1;
                inverse = true;
            }
            this.mConstantValue = m;
        }
        if (!inverse) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, -1.0f);
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            arrayRowVariables2.put(variableB, 1.0f);
        } else {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, 1.0f);
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            arrayRowVariables3.put(variableB, -1.0f);
        }
        return this;
    }

    @NotNull
    public final ArrayRow addSingleError(@Nullable SolverVariable error, int sign) {
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.put(error, sign);
        return this;
    }

    @NotNull
    public final ArrayRow createRowGreaterThan(@Nullable SolverVariable variableA, @Nullable SolverVariable variableB, @Nullable SolverVariable slack, int margin) {
        boolean inverse = false;
        if (margin != 0) {
            int m = margin;
            if (m < 0) {
                m *= -1;
                inverse = true;
            }
            this.mConstantValue = m;
        }
        if (!inverse) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, -1.0f);
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            arrayRowVariables2.put(variableB, 1.0f);
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            arrayRowVariables3.put(slack, 1.0f);
        } else {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, 1.0f);
            ArrayRowVariables arrayRowVariables4 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables4);
            arrayRowVariables4.put(variableB, -1.0f);
            ArrayRowVariables arrayRowVariables5 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables5);
            arrayRowVariables5.put(slack, -1.0f);
        }
        return this;
    }

    @NotNull
    public final ArrayRow createRowGreaterThan(@Nullable SolverVariable a, int b, @Nullable SolverVariable slack) {
        this.mConstantValue = b;
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.put(a, -1.0f);
        return this;
    }

    @NotNull
    public final ArrayRow createRowLowerThan(@Nullable SolverVariable variableA, @Nullable SolverVariable variableB, @Nullable SolverVariable slack, int margin) {
        boolean inverse = false;
        if (margin != 0) {
            int m = margin;
            if (m < 0) {
                m *= -1;
                inverse = true;
            }
            this.mConstantValue = m;
        }
        if (!inverse) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, -1.0f);
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            arrayRowVariables2.put(variableB, 1.0f);
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            arrayRowVariables3.put(slack, -1.0f);
        } else {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, 1.0f);
            ArrayRowVariables arrayRowVariables4 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables4);
            arrayRowVariables4.put(variableB, -1.0f);
            ArrayRowVariables arrayRowVariables5 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables5);
            arrayRowVariables5.put(slack, 1.0f);
        }
        return this;
    }

    @NotNull
    public final ArrayRow createRowEqualMatchDimensions(float currentWeight, float totalWeights, float nextWeight, @Nullable SolverVariable variableStartA, @Nullable SolverVariable variableEndA, @Nullable SolverVariable variableStartB, @Nullable SolverVariable variableEndB) {
        this.mConstantValue = 0.0f;
        if (totalWeights == 0.0f || currentWeight == nextWeight) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableStartA, 1.0f);
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            arrayRowVariables2.put(variableEndA, -1.0f);
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            arrayRowVariables3.put(variableEndB, 1.0f);
            ArrayRowVariables arrayRowVariables4 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables4);
            arrayRowVariables4.put(variableStartB, -1.0f);
        } else if (currentWeight == 0.0f) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableStartA, 1.0f);
            ArrayRowVariables arrayRowVariables5 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables5);
            arrayRowVariables5.put(variableEndA, -1.0f);
        } else if (nextWeight == 0.0f) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableStartB, 1.0f);
            ArrayRowVariables arrayRowVariables6 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables6);
            arrayRowVariables6.put(variableEndB, -1.0f);
        } else {
            float cw = currentWeight / totalWeights;
            float nw = nextWeight / totalWeights;
            float w = cw / nw;
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableStartA, 1.0f);
            ArrayRowVariables arrayRowVariables7 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables7);
            arrayRowVariables7.put(variableEndA, -1.0f);
            ArrayRowVariables arrayRowVariables8 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables8);
            arrayRowVariables8.put(variableEndB, w);
            ArrayRowVariables arrayRowVariables9 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables9);
            arrayRowVariables9.put(variableStartB, -w);
        }
        return this;
    }

    @NotNull
    public final ArrayRow createRowEqualDimension(float currentWeight, float totalWeights, float nextWeight, @Nullable SolverVariable variableStartA, int marginStartA, @Nullable SolverVariable variableEndA, int marginEndA, @Nullable SolverVariable variableStartB, int marginStartB, @Nullable SolverVariable variableEndB, int marginEndB) {
        if (totalWeights == 0.0f || currentWeight == nextWeight) {
            this.mConstantValue = -marginStartA - marginEndA + marginStartB + marginEndB;
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableStartA, 1.0f);
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            arrayRowVariables2.put(variableEndA, -1.0f);
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            arrayRowVariables3.put(variableEndB, 1.0f);
            ArrayRowVariables arrayRowVariables4 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables4);
            arrayRowVariables4.put(variableStartB, -1.0f);
        } else {
            float cw = currentWeight / totalWeights;
            float nw = nextWeight / totalWeights;
            float w = cw / nw;
            this.mConstantValue = (float)(-marginStartA - marginEndA) + w * (float)marginStartB + w * (float)marginEndB;
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableStartA, 1.0f);
            ArrayRowVariables arrayRowVariables5 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables5);
            arrayRowVariables5.put(variableEndA, -1.0f);
            ArrayRowVariables arrayRowVariables6 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables6);
            arrayRowVariables6.put(variableEndB, w);
            ArrayRowVariables arrayRowVariables7 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables7);
            arrayRowVariables7.put(variableStartB, -w);
        }
        return this;
    }

    @NotNull
    public final ArrayRow createRowCentering(@Nullable SolverVariable variableA, @NotNull SolverVariable variableB, int marginA, float bias, @NotNull SolverVariable variableC, @Nullable SolverVariable variableD, int marginB) {
        Intrinsics.checkNotNullParameter((Object)variableB, (String)"variableB");
        Intrinsics.checkNotNullParameter((Object)variableC, (String)"variableC");
        if (Intrinsics.areEqual((Object)variableB, (Object)variableC)) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, 1.0f);
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            arrayRowVariables2.put(variableD, 1.0f);
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            arrayRowVariables3.put(variableB, -2.0f);
            return this;
        }
        if (bias == 0.5f) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, 1.0f);
            ArrayRowVariables arrayRowVariables4 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables4);
            arrayRowVariables4.put(variableB, -1.0f);
            ArrayRowVariables arrayRowVariables5 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables5);
            arrayRowVariables5.put(variableC, -1.0f);
            ArrayRowVariables arrayRowVariables6 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables6);
            arrayRowVariables6.put(variableD, 1.0f);
            if (marginA > 0 || marginB > 0) {
                this.mConstantValue = -marginA + marginB;
            }
        } else if (bias <= 0.0f) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, -1.0f);
            ArrayRowVariables arrayRowVariables7 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables7);
            arrayRowVariables7.put(variableB, 1.0f);
            this.mConstantValue = marginA;
        } else if (bias >= 1.0f) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableD, -1.0f);
            ArrayRowVariables arrayRowVariables8 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables8);
            arrayRowVariables8.put(variableC, 1.0f);
            this.mConstantValue = -((float)marginB);
        } else {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(variableA, 1.0f * (1.0f - bias));
            ArrayRowVariables arrayRowVariables9 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables9);
            arrayRowVariables9.put(variableB, (float)-1 * (1.0f - bias));
            ArrayRowVariables arrayRowVariables10 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables10);
            arrayRowVariables10.put(variableC, (float)-1 * bias);
            ArrayRowVariables arrayRowVariables11 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables11);
            arrayRowVariables11.put(variableD, 1.0f * bias);
            if (marginA > 0 || marginB > 0) {
                this.mConstantValue = (float)(-marginA) * (1.0f - bias) + (float)marginB * bias;
            }
        }
        return this;
    }

    @NotNull
    public final ArrayRow addError(@NotNull LinearSystem system, int strength) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.put(system.createErrorVariable(strength, "ep"), 1.0f);
        ArrayRowVariables arrayRowVariables2 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables2);
        arrayRowVariables2.put(system.createErrorVariable(strength, "em"), -1.0f);
        return this;
    }

    @NotNull
    public final ArrayRow createRowDimensionPercent(@Nullable SolverVariable variableA, @Nullable SolverVariable variableC, float percent) {
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.put(variableA, -1.0f);
        ArrayRowVariables arrayRowVariables2 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables2);
        arrayRowVariables2.put(variableC, percent);
        return this;
    }

    @NotNull
    public final ArrayRow createRowDimensionRatio(@Nullable SolverVariable variableA, @Nullable SolverVariable variableB, @Nullable SolverVariable variableC, @Nullable SolverVariable variableD, float ratio) {
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.put(variableA, -1.0f);
        ArrayRowVariables arrayRowVariables2 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables2);
        arrayRowVariables2.put(variableB, 1.0f);
        ArrayRowVariables arrayRowVariables3 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables3);
        arrayRowVariables3.put(variableC, ratio);
        ArrayRowVariables arrayRowVariables4 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables4);
        arrayRowVariables4.put(variableD, -ratio);
        return this;
    }

    @NotNull
    public final ArrayRow createRowWithAngle(@Nullable SolverVariable at, @Nullable SolverVariable ab, @Nullable SolverVariable bt, @Nullable SolverVariable bb, float angleComponent) {
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.put(bt, 0.5f);
        ArrayRowVariables arrayRowVariables2 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables2);
        arrayRowVariables2.put(bb, 0.5f);
        ArrayRowVariables arrayRowVariables3 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables3);
        arrayRowVariables3.put(at, -0.5f);
        ArrayRowVariables arrayRowVariables4 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables4);
        arrayRowVariables4.put(ab, -0.5f);
        this.mConstantValue = -angleComponent;
        return this;
    }

    public final int sizeInBytes() {
        int size = 0;
        if (this.mVariable != null) {
            size += 4;
        }
        size += 4;
        size += 4;
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        return size += arrayRowVariables.sizeInBytes();
    }

    public final void ensurePositiveConstant() {
        if (this.mConstantValue < 0.0f) {
            this.mConstantValue *= -1.0f;
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.invert();
        }
    }

    public final boolean chooseSubject(@Nullable LinearSystem system) {
        boolean addedExtra = false;
        SolverVariable pivotCandidate = this.chooseSubjectInVariables(system);
        if (pivotCandidate == null) {
            addedExtra = true;
        } else {
            this.pivot(pivotCandidate);
        }
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        if (arrayRowVariables.getCurrentSize() == 0) {
            this.mIsSimpleDefinition = true;
        }
        return addedExtra;
    }

    @Nullable
    public final SolverVariable chooseSubjectInVariables(@Nullable LinearSystem system) {
        SolverVariable restrictedCandidate = null;
        SolverVariable unrestrictedCandidate = null;
        float unrestrictedCandidateAmount = 0.0f;
        float restrictedCandidateAmount = 0.0f;
        boolean unrestrictedCandidateIsNew = false;
        boolean restrictedCandidateIsNew = false;
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        int currentSize = arrayRowVariables.getCurrentSize();
        for (int i = 0; i < currentSize; ++i) {
            SolverVariable variable;
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            float amount = arrayRowVariables2.getVariableValue(i);
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            SolverVariable solverVariable = variable = arrayRowVariables3.getVariable(i);
            Intrinsics.checkNotNull((Object)solverVariable);
            if (solverVariable.getMType() == SolverVariable.Type.UNRESTRICTED) {
                if (unrestrictedCandidate == null) {
                    unrestrictedCandidate = variable;
                    unrestrictedCandidateAmount = amount;
                    unrestrictedCandidateIsNew = this.isNew(variable, system);
                    continue;
                }
                if (unrestrictedCandidateAmount > amount) {
                    unrestrictedCandidate = variable;
                    unrestrictedCandidateAmount = amount;
                    unrestrictedCandidateIsNew = this.isNew(variable, system);
                    continue;
                }
                if (unrestrictedCandidateIsNew || !this.isNew(variable, system)) continue;
                unrestrictedCandidate = variable;
                unrestrictedCandidateAmount = amount;
                unrestrictedCandidateIsNew = true;
                continue;
            }
            if (unrestrictedCandidate != null || !(amount < 0.0f)) continue;
            if (restrictedCandidate == null) {
                restrictedCandidate = variable;
                restrictedCandidateAmount = amount;
                restrictedCandidateIsNew = this.isNew(variable, system);
                continue;
            }
            if (restrictedCandidateAmount > amount) {
                restrictedCandidate = variable;
                restrictedCandidateAmount = amount;
                restrictedCandidateIsNew = this.isNew(variable, system);
                continue;
            }
            if (restrictedCandidateIsNew || !this.isNew(variable, system)) continue;
            restrictedCandidate = variable;
            restrictedCandidateAmount = amount;
            restrictedCandidateIsNew = true;
        }
        SolverVariable solverVariable = unrestrictedCandidate;
        if (solverVariable == null) {
            solverVariable = restrictedCandidate;
        }
        return solverVariable;
    }

    private final boolean isNew(SolverVariable variable, LinearSystem system) {
        SolverVariable solverVariable = variable;
        Intrinsics.checkNotNull((Object)solverVariable);
        return solverVariable.getUsageInRowCount() <= 1;
    }

    public final void pivot(@NotNull SolverVariable v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (this.mVariable != null) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.put(this.mVariable, -1.0f);
            SolverVariable solverVariable = this.mVariable;
            Intrinsics.checkNotNull((Object)solverVariable);
            solverVariable.setMDefinitionId(-1);
            this.mVariable = null;
        }
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        float amount = arrayRowVariables.remove(v, true) * (float)-1;
        this.mVariable = v;
        if (amount == 1.0f) {
            return;
        }
        this.mConstantValue /= amount;
        ArrayRowVariables arrayRowVariables2 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables2);
        arrayRowVariables2.divideByAmount(amount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty() {
        if (this.mVariable != null) return false;
        if (this.mConstantValue != 0.0f) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        if (arrayRowVariables.getCurrentSize() != 0) return false;
        return true;
    }

    @Override
    public void updateFromRow(@Nullable LinearSystem system, @Nullable ArrayRow definition, boolean removeFromDefinition) {
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        float value = arrayRowVariables.use(definition, removeFromDefinition);
        ArrayRow arrayRow = definition;
        Intrinsics.checkNotNull((Object)arrayRow);
        this.mConstantValue += arrayRow.mConstantValue * value;
        if (removeFromDefinition) {
            SolverVariable solverVariable = definition.mVariable;
            Intrinsics.checkNotNull((Object)solverVariable);
            solverVariable.removeFromRow(this);
        }
        if (LinearSystem.Companion.getSIMPLIFY_SYNONYMS() && this.mVariable != null) {
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            if (arrayRowVariables2.getCurrentSize() == 0) {
                this.mIsSimpleDefinition = true;
                LinearSystem linearSystem = system;
                Intrinsics.checkNotNull((Object)linearSystem);
                linearSystem.setHasSimpleDefinition(true);
            }
        }
    }

    @Override
    public void updateFromFinalVariable(@Nullable LinearSystem system, @Nullable SolverVariable variable, boolean removeFromDefinition) {
        if (variable == null || !variable.isFinalValue()) {
            return;
        }
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        float value = arrayRowVariables.get(variable);
        this.mConstantValue += variable.getComputedValue() * value;
        ArrayRowVariables arrayRowVariables2 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables2);
        arrayRowVariables2.remove(variable, removeFromDefinition);
        if (removeFromDefinition) {
            variable.removeFromRow(this);
        }
        if (LinearSystem.Companion.getSIMPLIFY_SYNONYMS()) {
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            if (arrayRowVariables3.getCurrentSize() == 0) {
                this.mIsSimpleDefinition = true;
                LinearSystem linearSystem = system;
                Intrinsics.checkNotNull((Object)linearSystem);
                linearSystem.setHasSimpleDefinition(true);
            }
        }
    }

    public final void updateFromSynonymVariable(@NotNull LinearSystem system, @Nullable SolverVariable variable, boolean removeFromDefinition) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        if (variable == null || !variable.getMIsSynonym()) {
            return;
        }
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        float value = arrayRowVariables.get(variable);
        this.mConstantValue += variable.getMSynonymDelta() * value;
        ArrayRowVariables arrayRowVariables2 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables2);
        arrayRowVariables2.remove(variable, removeFromDefinition);
        if (removeFromDefinition) {
            variable.removeFromRow(this);
        }
        ArrayRowVariables arrayRowVariables3 = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables3);
        arrayRowVariables3.add(system.getMCache().getMIndexedVariables()[variable.getMSynonym()], value, removeFromDefinition);
        if (LinearSystem.Companion.getSIMPLIFY_SYNONYMS()) {
            ArrayRowVariables arrayRowVariables4 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables4);
            if (arrayRowVariables4.getCurrentSize() == 0) {
                this.mIsSimpleDefinition = true;
                system.setHasSimpleDefinition(true);
            }
        }
    }

    private final SolverVariable pickPivotInVariables(boolean[] avoid, SolverVariable exclude) {
        boolean all = true;
        float value = 0.0f;
        SolverVariable pivot = null;
        Object pivotSlack = null;
        float valueSlack = 0.0f;
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        int currentSize = arrayRowVariables.getCurrentSize();
        for (int i = 0; i < currentSize; ++i) {
            ArrayRowVariables arrayRowVariables2 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            float currentValue = arrayRowVariables2.getVariableValue(i);
            if (!(currentValue < 0.0f)) continue;
            ArrayRowVariables arrayRowVariables3 = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables3);
            SolverVariable v = arrayRowVariables3.getVariable(i);
            if (avoid != null) {
                SolverVariable solverVariable = v;
                Intrinsics.checkNotNull((Object)solverVariable);
                if (avoid[solverVariable.getId()]) continue;
            }
            if (Intrinsics.areEqual((Object)v, (Object)exclude)) continue;
            SolverVariable solverVariable = v;
            Intrinsics.checkNotNull((Object)solverVariable);
            if (solverVariable.getMType() != SolverVariable.Type.SLACK && v.getMType() != SolverVariable.Type.ERROR || !(currentValue < value)) continue;
            value = currentValue;
            pivot = v;
        }
        return pivot;
    }

    @Nullable
    public final SolverVariable pickPivot(@Nullable SolverVariable exclude) {
        SolverVariable solverVariable = exclude;
        Intrinsics.checkNotNull((Object)solverVariable);
        return this.pickPivotInVariables(null, solverVariable);
    }

    @Override
    @Nullable
    public SolverVariable getPivotCandidate(@Nullable LinearSystem system, @Nullable boolean[] avoid) {
        return this.pickPivotInVariables(avoid, null);
    }

    @Override
    public void clear() {
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.clear();
        this.mVariable = null;
        this.mConstantValue = 0.0f;
    }

    @Override
    public void initFromRow(@Nullable LinearSystem.Row row) {
        if (row instanceof ArrayRow) {
            LinearSystem.Row copiedRow = row;
            this.mVariable = null;
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            arrayRowVariables.clear();
            ArrayRowVariables arrayRowVariables2 = ((ArrayRow)copiedRow).variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables2);
            int n = arrayRowVariables2.getCurrentSize();
            for (int i = 0; i < n; ++i) {
                ArrayRowVariables arrayRowVariables3 = ((ArrayRow)copiedRow).variables;
                Intrinsics.checkNotNull((Object)arrayRowVariables3);
                SolverVariable variable = arrayRowVariables3.getVariable(i);
                ArrayRowVariables arrayRowVariables4 = ((ArrayRow)copiedRow).variables;
                Intrinsics.checkNotNull((Object)arrayRowVariables4);
                float value = arrayRowVariables4.getVariableValue(i);
                ArrayRowVariables arrayRowVariables5 = this.variables;
                Intrinsics.checkNotNull((Object)arrayRowVariables5);
                arrayRowVariables5.add(variable, value, true);
            }
        }
    }

    @Override
    public void addError(@Nullable SolverVariable error) {
        float weight = 1.0f;
        SolverVariable solverVariable = error;
        Intrinsics.checkNotNull((Object)solverVariable);
        if (solverVariable.getStrength() == 1) {
            weight = 1.0f;
        } else if (error.getStrength() == 2) {
            weight = 1000.0f;
        } else if (error.getStrength() == 3) {
            weight = 1000000.0f;
        } else if (error.getStrength() == 4) {
            weight = 1.0E9f;
        } else if (error.getStrength() == 5) {
            weight = 1.0E12f;
        }
        ArrayRowVariables arrayRowVariables = this.variables;
        Intrinsics.checkNotNull((Object)arrayRowVariables);
        arrayRowVariables.put(error, weight);
    }

    @Override
    @Nullable
    public SolverVariable getKey() {
        return this.mVariable;
    }

    @Override
    public void updateFromSystem(@Nullable LinearSystem system) {
        LinearSystem linearSystem = system;
        Intrinsics.checkNotNull((Object)linearSystem);
        ArrayRow[] arrayRowArray = linearSystem.getMRows();
        Intrinsics.checkNotNull((Object)arrayRowArray);
        if (arrayRowArray.length == 0) {
            return;
        }
        boolean done = false;
        while (!done) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            int currentSize = arrayRowVariables.getCurrentSize();
            for (int i = 0; i < currentSize; ++i) {
                SolverVariable variable;
                ArrayRowVariables arrayRowVariables2 = this.variables;
                Intrinsics.checkNotNull((Object)arrayRowVariables2);
                SolverVariable solverVariable = variable = arrayRowVariables2.getVariable(i);
                Intrinsics.checkNotNull((Object)solverVariable);
                if (solverVariable.getMDefinitionId() == -1 && !variable.isFinalValue() && !variable.getMIsSynonym()) continue;
                this.mVariablesToUpdate.add(variable);
            }
            int size = this.mVariablesToUpdate.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    SolverVariable variable;
                    Intrinsics.checkNotNullExpressionValue((Object)this.mVariablesToUpdate.get(i), (String)"get(...)");
                    if (variable.isFinalValue()) {
                        this.updateFromFinalVariable(system, variable, true);
                        continue;
                    }
                    if (variable.getMIsSynonym()) {
                        this.updateFromSynonymVariable(system, variable, true);
                        continue;
                    }
                    ArrayRow[] arrayRowArray2 = system.getMRows();
                    Intrinsics.checkNotNull((Object)arrayRowArray2);
                    this.updateFromRow(system, arrayRowArray2[variable.getMDefinitionId()], true);
                }
                this.mVariablesToUpdate.clear();
                continue;
            }
            done = true;
        }
        if (LinearSystem.Companion.getSIMPLIFY_SYNONYMS() && this.mVariable != null) {
            ArrayRowVariables arrayRowVariables = this.variables;
            Intrinsics.checkNotNull((Object)arrayRowVariables);
            if (arrayRowVariables.getCurrentSize() == 0) {
                this.mIsSimpleDefinition = true;
                system.setHasSimpleDefinition(true);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0003H&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0003H&J\u0013\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u00a6\u0002J\u0012\u0010\r\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0007H&J\b\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u000fH&J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u00a6\u0002J\u001a\u0010\u0013\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\nH&J\b\u0010\u0015\u001a\u00020\u0003H&J\b\u0010\u0016\u001a\u00020\u000fH&J\u001a\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u0012H&J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\nH&J\"\u0010\u001c\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0012H&J\u001a\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u0012H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006 "}, d2={"Landroidx/constraintlayout/core/ArrayRow$ArrayRowVariables;", "", "currentSize", "", "getCurrentSize", "()I", "getVariable", "Landroidx/constraintlayout/core/SolverVariable;", "index", "getVariableValue", "", "get", "variable", "indexOf", "display", "", "clear", "contains", "", "put", "value", "sizeInBytes", "invert", "remove", "v", "removeFromDefinition", "divideByAmount", "amount", "add", "use", "definition", "Landroidx/constraintlayout/core/ArrayRow;", "compose"})
    public static interface ArrayRowVariables {
        public int getCurrentSize();

        @Nullable
        public SolverVariable getVariable(int var1);

        public float getVariableValue(int var1);

        public float get(@Nullable SolverVariable var1);

        public int indexOf(@Nullable SolverVariable var1);

        public void display();

        public void clear();

        public boolean contains(@Nullable SolverVariable var1);

        public void put(@Nullable SolverVariable var1, float var2);

        public int sizeInBytes();

        public void invert();

        public float remove(@Nullable SolverVariable var1, boolean var2);

        public void divideByAmount(float var1);

        public void add(@Nullable SolverVariable var1, float var2, boolean var3);

        public float use(@Nullable ArrayRow var1, boolean var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/ArrayRow$Companion;", "", "<init>", "()V", "DEBUG", "", "FULL_NEW_CHECK", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

