/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.RunGroup;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b'\u0018\u00002\u00020\u0001:\u0001[B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010:\u001a\u00020;H&J\b\u0010<\u001a\u00020;H&J\b\u0010=\u001a\u00020;H&J\b\u0010>\u001a\u00020;H&J\b\u0010?\u001a\u00020&H&J\b\u0010@\u001a\u00020&H\u0016J\b\u0010A\u001a\u00020&H\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0007H\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010,2\u0006\u0010F\u001a\u00020GH\u0004J*\u0010H\u001a\u00020;2\b\u0010I\u001a\u0004\u0018\u00010\u00012\u0006\u0010J\u001a\u00020G2\u0006\u0010K\u001a\u00020G2\u0006\u0010\"\u001a\u00020\u0007H\u0014J\u0018\u0010L\u001a\u00020;2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u0007H\u0002J\u0012\u0010N\u001a\u00020;2\b\u0010I\u001a\u0004\u0018\u00010\u0001H\u0014J\u0012\u0010O\u001a\u00020;2\b\u0010I\u001a\u0004\u0018\u00010\u0001H\u0014J\u0010\u0010P\u001a\u00020;2\u0006\u0010Q\u001a\u00020\u0001H\u0016J\u0018\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0004J\u001a\u0010E\u001a\u0004\u0018\u00010,2\u0006\u0010F\u001a\u00020G2\u0006\u0010\"\u001a\u00020\u0007H\u0004J \u0010T\u001a\u00020;2\u0006\u0010Q\u001a\u00020,2\u0006\u0010U\u001a\u00020,2\u0006\u0010V\u001a\u00020\u0007H\u0004J(\u0010T\u001a\u00020;2\u0006\u0010Q\u001a\u00020,2\u0006\u0010U\u001a\u00020,2\u0006\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u001dH\u0004J\b\u0010Y\u001a\u00020CH\u0016J\b\u0010Z\u001a\u00020&H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\t\"\u0004\b$\u0010\u000bR\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010.\"\u0004\b3\u00100R\u001a\u00104\u001a\u000205X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006\\"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "<init>", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;)V", "matchConstraintsType", "", "getMatchConstraintsType", "()I", "setMatchConstraintsType", "(I)V", "mWidget", "getMWidget", "()Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "setMWidget", "mRunGroup", "Landroidx/constraintlayout/core/widgets/analyzer/RunGroup;", "getMRunGroup", "()Landroidx/constraintlayout/core/widgets/analyzer/RunGroup;", "setMRunGroup", "(Landroidx/constraintlayout/core/widgets/analyzer/RunGroup;)V", "mDimensionBehavior", "Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;", "getMDimensionBehavior", "()Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;", "setMDimensionBehavior", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;)V", "mDimension", "Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;", "getMDimension", "()Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;", "setMDimension", "(Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;)V", "orientation", "getOrientation", "setOrientation", "mResolved", "", "getMResolved", "()Z", "setMResolved", "(Z)V", "start", "Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "getStart", "()Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "setStart", "(Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;)V", "end", "getEnd", "setEnd", "mRunType", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun$RunType;", "getMRunType$compose", "()Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun$RunType;", "setMRunType$compose", "(Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun$RunType;)V", "clear", "", "apply", "applyToWidget", "reset", "supportsWrapComputation", "isDimensionResolved", "isCenterConnection", "wrapSize", "", "direction", "getTarget", "anchor", "Landroidx/constraintlayout/core/widgets/ConstraintAnchor;", "updateRunCenter", "dependency", "startAnchor", "endAnchor", "resolveDimension", "distance", "updateRunStart", "updateRunEnd", "update", "node", "getLimitedDimension", "dimension", "addTarget", "target", "margin", "marginFactor", "dimensionDependency", "getWrapDimension", "isResolved", "RunType", "compose"})
@StabilityInferred(parameters=0)
public abstract class WidgetRun
implements Dependency {
    private int matchConstraintsType;
    @Nullable
    private ConstraintWidget mWidget;
    @Nullable
    private RunGroup mRunGroup;
    @Nullable
    private ConstraintWidget.DimensionBehaviour mDimensionBehavior;
    @NotNull
    private DimensionDependency mDimension;
    private int orientation;
    private boolean mResolved;
    @NotNull
    private DependencyNode start;
    @NotNull
    private DependencyNode end;
    @NotNull
    private RunType mRunType;
    public static final int $stable = 8;

    public WidgetRun(@Nullable ConstraintWidget widget) {
        this.mWidget = widget;
        this.mDimension = new DimensionDependency(this);
        this.start = new DependencyNode(this);
        this.end = new DependencyNode(this);
        this.mRunType = RunType.NONE;
    }

    public final int getMatchConstraintsType() {
        return this.matchConstraintsType;
    }

    public final void setMatchConstraintsType(int n) {
        this.matchConstraintsType = n;
    }

    @Nullable
    public final ConstraintWidget getMWidget() {
        return this.mWidget;
    }

    public final void setMWidget(@Nullable ConstraintWidget constraintWidget) {
        this.mWidget = constraintWidget;
    }

    @Nullable
    public final RunGroup getMRunGroup() {
        return this.mRunGroup;
    }

    public final void setMRunGroup(@Nullable RunGroup runGroup) {
        this.mRunGroup = runGroup;
    }

    @Nullable
    public final ConstraintWidget.DimensionBehaviour getMDimensionBehavior() {
        return this.mDimensionBehavior;
    }

    public final void setMDimensionBehavior(@Nullable ConstraintWidget.DimensionBehaviour dimensionBehaviour) {
        this.mDimensionBehavior = dimensionBehaviour;
    }

    @NotNull
    public final DimensionDependency getMDimension() {
        return this.mDimension;
    }

    public final void setMDimension(@NotNull DimensionDependency dimensionDependency) {
        Intrinsics.checkNotNullParameter((Object)dimensionDependency, (String)"<set-?>");
        this.mDimension = dimensionDependency;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int n) {
        this.orientation = n;
    }

    public final boolean getMResolved() {
        return this.mResolved;
    }

    public final void setMResolved(boolean bl) {
        this.mResolved = bl;
    }

    @NotNull
    public final DependencyNode getStart() {
        return this.start;
    }

    public final void setStart(@NotNull DependencyNode dependencyNode) {
        Intrinsics.checkNotNullParameter((Object)dependencyNode, (String)"<set-?>");
        this.start = dependencyNode;
    }

    @NotNull
    public final DependencyNode getEnd() {
        return this.end;
    }

    public final void setEnd(@NotNull DependencyNode dependencyNode) {
        Intrinsics.checkNotNullParameter((Object)dependencyNode, (String)"<set-?>");
        this.end = dependencyNode;
    }

    @NotNull
    public final RunType getMRunType$compose() {
        return this.mRunType;
    }

    public final void setMRunType$compose(@NotNull RunType runType) {
        Intrinsics.checkNotNullParameter((Object)((Object)runType), (String)"<set-?>");
        this.mRunType = runType;
    }

    public abstract void clear();

    public abstract void apply();

    public abstract void applyToWidget();

    public abstract void reset();

    public abstract boolean supportsWrapComputation();

    public boolean isDimensionResolved() {
        return this.mDimension.getResolved();
    }

    public boolean isCenterConnection() {
        DependencyNode dependency;
        int i;
        int connections = 0;
        int count = this.start.getMTargets().size();
        int n = count;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)this.start.getMTargets().get(i), (String)"get(...)");
            if (Intrinsics.areEqual((Object)dependency.getMRun(), (Object)this)) continue;
            ++connections;
        }
        count = this.end.getMTargets().size();
        n = count;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)this.end.getMTargets().get(i), (String)"get(...)");
            if (Intrinsics.areEqual((Object)dependency.getMRun(), (Object)this)) continue;
            ++connections;
        }
        return connections >= 2;
    }

    public long wrapSize(int direction) {
        if (this.mDimension.getResolved()) {
            long size = this.mDimension.getValue();
            size = this.isCenterConnection() ? (size += (long)(this.start.getMMargin() - this.end.getMMargin())) : (direction == 0 ? (size += (long)this.start.getMMargin()) : (size -= (long)this.end.getMMargin()));
            return size;
        }
        return 0L;
    }

    @Nullable
    protected final DependencyNode getTarget(@NotNull ConstraintAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (anchor.getMTarget() == null) {
            return null;
        }
        DependencyNode target = null;
        ConstraintAnchor constraintAnchor = anchor.getMTarget();
        Intrinsics.checkNotNull((Object)constraintAnchor);
        ConstraintWidget targetWidget = constraintAnchor.getMOwner();
        ConstraintAnchor constraintAnchor2 = anchor.getMTarget();
        Intrinsics.checkNotNull((Object)constraintAnchor2);
        ConstraintAnchor.Type targetType = constraintAnchor2.getMType();
        switch (WhenMappings.$EnumSwitchMapping$0[targetType.ordinal()]) {
            case 1: {
                HorizontalWidgetRun horizontalWidgetRun = targetWidget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                HorizontalWidgetRun run = horizontalWidgetRun;
                target = run.getStart();
                break;
            }
            case 2: {
                HorizontalWidgetRun horizontalWidgetRun = targetWidget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                HorizontalWidgetRun run = horizontalWidgetRun;
                target = run.getEnd();
                break;
            }
            case 3: {
                VerticalWidgetRun verticalWidgetRun = targetWidget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                VerticalWidgetRun run = verticalWidgetRun;
                target = run.getStart();
                break;
            }
            case 4: {
                VerticalWidgetRun verticalWidgetRun = targetWidget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                VerticalWidgetRun run = verticalWidgetRun;
                target = run.getBaseline();
                break;
            }
            case 5: {
                VerticalWidgetRun verticalWidgetRun = targetWidget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                VerticalWidgetRun run = verticalWidgetRun;
                target = run.getEnd();
            }
        }
        return target;
    }

    protected void updateRunCenter(@Nullable Dependency dependency, @NotNull ConstraintAnchor startAnchor, @NotNull ConstraintAnchor endAnchor, int orientation) {
        float bias;
        float f;
        DependencyNode endTarget;
        DependencyNode startTarget;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)startAnchor, (String)"startAnchor");
                Intrinsics.checkNotNullParameter((Object)endAnchor, (String)"endAnchor");
                startTarget = this.getTarget(startAnchor);
                endTarget = this.getTarget(endAnchor);
                DependencyNode dependencyNode = startTarget;
                Intrinsics.checkNotNull((Object)dependencyNode);
                if (!dependencyNode.getResolved()) break block9;
                DependencyNode dependencyNode2 = endTarget;
                Intrinsics.checkNotNull((Object)dependencyNode2);
                if (dependencyNode2.getResolved()) break block10;
            }
            return;
        }
        int startPos = startTarget.getValue() + startAnchor.getMargin();
        int endPos = endTarget.getValue() - endAnchor.getMargin();
        int distance = endPos - startPos;
        if (!this.mDimension.getResolved() && this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            this.resolveDimension(orientation, distance);
        }
        if (!this.mDimension.getResolved()) {
            return;
        }
        if (this.mDimension.getValue() == distance) {
            this.start.resolve(startPos);
            this.end.resolve(endPos);
            return;
        }
        if (orientation == 0) {
            ConstraintWidget constraintWidget = this.mWidget;
            Intrinsics.checkNotNull((Object)constraintWidget);
            f = constraintWidget.getHorizontalBiasPercent();
        } else {
            ConstraintWidget constraintWidget = this.mWidget;
            Intrinsics.checkNotNull((Object)constraintWidget);
            f = bias = constraintWidget.getVerticalBiasPercent();
        }
        if (Intrinsics.areEqual((Object)startTarget, (Object)endTarget)) {
            startPos = startTarget.getValue();
            endPos = endTarget.getValue();
            bias = 0.5f;
        }
        int availableDistance = endPos - startPos - this.mDimension.getValue();
        this.start.resolve((int)(0.5f + (float)startPos + (float)availableDistance * bias));
        this.end.resolve(this.start.getValue() + this.mDimension.getValue());
    }

    private final void resolveDimension(int orientation, int distance) {
        switch (this.matchConstraintsType) {
            case 0: {
                this.mDimension.resolve(this.getLimitedDimension(distance, orientation));
                break;
            }
            case 2: {
                float f;
                WidgetRun run;
                WidgetRun widgetRun;
                ConstraintWidget constraintWidget = this.mWidget;
                Intrinsics.checkNotNull((Object)constraintWidget);
                ConstraintWidget parent = constraintWidget.getParent();
                if (parent == null) break;
                if (orientation == 0) {
                    HorizontalWidgetRun horizontalWidgetRun = parent.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                    widgetRun = horizontalWidgetRun;
                } else {
                    VerticalWidgetRun verticalWidgetRun = parent.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    widgetRun = run = (WidgetRun)verticalWidgetRun;
                }
                if (!run.mDimension.getResolved()) break;
                if (orientation == 0) {
                    ConstraintWidget constraintWidget2 = this.mWidget;
                    Intrinsics.checkNotNull((Object)constraintWidget2);
                    f = constraintWidget2.getMMatchConstraintPercentWidth();
                } else {
                    ConstraintWidget constraintWidget3 = this.mWidget;
                    Intrinsics.checkNotNull((Object)constraintWidget3);
                    f = constraintWidget3.getMMatchConstraintPercentHeight();
                }
                float percent = f;
                int targetDimensionValue = run.mDimension.getValue();
                int size = (int)(0.5f + (float)targetDimensionValue * percent);
                this.mDimension.resolve(this.getLimitedDimension(size, orientation));
                break;
            }
            case 1: {
                int wrapValue = this.getLimitedDimension(this.mDimension.getWrapValue(), orientation);
                this.mDimension.resolve(Math.min(wrapValue, distance));
                break;
            }
            case 3: {
                WidgetRun run;
                WidgetRun widgetRun;
                ConstraintWidget constraintWidget = this.mWidget;
                Intrinsics.checkNotNull((Object)constraintWidget);
                HorizontalWidgetRun horizontalWidgetRun = constraintWidget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                if (horizontalWidgetRun.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    ConstraintWidget constraintWidget4 = this.mWidget;
                    Intrinsics.checkNotNull((Object)constraintWidget4);
                    HorizontalWidgetRun horizontalWidgetRun2 = constraintWidget4.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                    if (horizontalWidgetRun2.getMatchConstraintsType() == 3) {
                        ConstraintWidget constraintWidget5 = this.mWidget;
                        Intrinsics.checkNotNull((Object)constraintWidget5);
                        VerticalWidgetRun verticalWidgetRun = constraintWidget5.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun);
                        if (verticalWidgetRun.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                            ConstraintWidget constraintWidget6 = this.mWidget;
                            Intrinsics.checkNotNull((Object)constraintWidget6);
                            VerticalWidgetRun verticalWidgetRun2 = constraintWidget6.getMVerticalRun();
                            Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                            if (verticalWidgetRun2.getMatchConstraintsType() == 3) break;
                        }
                    }
                }
                if (orientation == 0) {
                    ConstraintWidget constraintWidget7 = this.mWidget;
                    Intrinsics.checkNotNull((Object)constraintWidget7);
                    VerticalWidgetRun verticalWidgetRun = constraintWidget7.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    widgetRun = verticalWidgetRun;
                } else {
                    ConstraintWidget constraintWidget8 = this.mWidget;
                    Intrinsics.checkNotNull((Object)constraintWidget8);
                    HorizontalWidgetRun horizontalWidgetRun3 = constraintWidget8.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                    widgetRun = run = (WidgetRun)horizontalWidgetRun3;
                }
                if (!run.mDimension.getResolved()) break;
                ConstraintWidget constraintWidget9 = this.mWidget;
                Intrinsics.checkNotNull((Object)constraintWidget9);
                float ratio = constraintWidget9.getDimensionRatio();
                int value = orientation == 1 ? (int)(0.5f + (float)run.mDimension.getValue() / ratio) : (int)(0.5f + ratio * (float)run.mDimension.getValue());
                this.mDimension.resolve(value);
            }
        }
    }

    protected void updateRunStart(@Nullable Dependency dependency) {
    }

    protected void updateRunEnd(@Nullable Dependency dependency) {
    }

    @Override
    public void update(@NotNull Dependency node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    protected final int getLimitedDimension(int dimension, int orientation) {
        int dimension2 = dimension;
        if (orientation == 0) {
            ConstraintWidget constraintWidget = this.mWidget;
            Intrinsics.checkNotNull((Object)constraintWidget);
            int max = constraintWidget.getMMatchConstraintMaxWidth();
            ConstraintWidget constraintWidget2 = this.mWidget;
            Intrinsics.checkNotNull((Object)constraintWidget2);
            int min = constraintWidget2.getMMatchConstraintMinWidth();
            int value = Math.max(min, dimension2);
            if (max > 0) {
                value = Math.min(max, dimension2);
            }
            if (value != dimension2) {
                dimension2 = value;
            }
        } else {
            ConstraintWidget constraintWidget = this.mWidget;
            Intrinsics.checkNotNull((Object)constraintWidget);
            int max = constraintWidget.getMMatchConstraintMaxHeight();
            ConstraintWidget constraintWidget3 = this.mWidget;
            Intrinsics.checkNotNull((Object)constraintWidget3);
            int min = constraintWidget3.getMMatchConstraintMinHeight();
            int value = Math.max(min, dimension2);
            if (max > 0) {
                value = Math.min(max, dimension2);
            }
            if (value != dimension2) {
                dimension2 = value;
            }
        }
        return dimension2;
    }

    @Nullable
    protected final DependencyNode getTarget(@NotNull ConstraintAnchor anchor, int orientation) {
        WidgetRun widgetRun;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (anchor.getMTarget() == null) {
            return null;
        }
        DependencyNode target = null;
        ConstraintAnchor constraintAnchor = anchor.getMTarget();
        Intrinsics.checkNotNull((Object)constraintAnchor);
        ConstraintWidget targetWidget = constraintAnchor.getMOwner();
        if (orientation == 0) {
            HorizontalWidgetRun horizontalWidgetRun = targetWidget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            widgetRun = horizontalWidgetRun;
        } else {
            VerticalWidgetRun verticalWidgetRun = targetWidget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            widgetRun = verticalWidgetRun;
        }
        WidgetRun run = widgetRun;
        ConstraintAnchor constraintAnchor2 = anchor.getMTarget();
        Intrinsics.checkNotNull((Object)constraintAnchor2);
        ConstraintAnchor.Type targetType = constraintAnchor2.getMType();
        switch (WhenMappings.$EnumSwitchMapping$0[targetType.ordinal()]) {
            case 1: 
            case 3: {
                target = run.start;
                break;
            }
            case 2: 
            case 5: {
                target = run.end;
            }
        }
        return target;
    }

    protected final void addTarget(@NotNull DependencyNode node, @NotNull DependencyNode target, int margin) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        node.getMTargets().add(target);
        node.setMMargin(margin);
        target.getMDependencies().add(node);
    }

    protected final void addTarget(@NotNull DependencyNode node, @NotNull DependencyNode target, int marginFactor, @NotNull DimensionDependency dimensionDependency) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)dimensionDependency, (String)"dimensionDependency");
        node.getMTargets().add(target);
        node.getMTargets().add(this.mDimension);
        node.setMMarginFactor(marginFactor);
        node.setMMarginDependency(dimensionDependency);
        target.getMDependencies().add(node);
        dimensionDependency.getMDependencies().add(node);
    }

    public long getWrapDimension() {
        return this.mDimension.getResolved() ? (long)this.mDimension.getValue() : 0L;
    }

    public boolean isResolved() {
        return this.mResolved;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun$RunType;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "START", "END", "CENTER", "compose"})
    public static final class RunType
    extends Enum<RunType> {
        public static final /* enum */ RunType NONE = new RunType();
        public static final /* enum */ RunType START = new RunType();
        public static final /* enum */ RunType END = new RunType();
        public static final /* enum */ RunType CENTER = new RunType();
        private static final /* synthetic */ RunType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RunType[] values() {
            return (RunType[])$VALUES.clone();
        }

        public static RunType valueOf(String value) {
            return Enum.valueOf(RunType.class, value);
        }

        @NotNull
        public static EnumEntries<RunType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = runTypeArray = new RunType[]{RunType.NONE, RunType.START, RunType.END, RunType.CENTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintAnchor.Type.values().length];
            try {
                nArray[ConstraintAnchor.Type.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.BASELINE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.BOTTOM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

