/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020,H\u0002J\u0018\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020,H\u0002J\u0016\u00101\u001a\u00020,2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005J\u0018\u00105\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0005H\u0002J\u0016\u00106\u001a\u00020*2\u0006\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u000eR\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\fR \u0010$\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010&\u001a\u0004\b'\u0010\n\"\u0004\b(\u0010\f\u00a8\u0006:"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/RunGroup;", "", "run", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "dir", "", "<init>", "(Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;I)V", "position", "getPosition", "()I", "setPosition", "(I)V", "dual", "", "getDual", "()Z", "setDual", "(Z)V", "mFirstRun", "getMFirstRun", "()Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "setMFirstRun", "(Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;)V", "mLastRun", "getMLastRun", "setMLastRun", "mRuns", "Ljava/util/ArrayList;", "getMRuns", "()Ljava/util/ArrayList;", "setMRuns", "(Ljava/util/ArrayList;)V", "mGroupIndex", "getMGroupIndex", "setMGroupIndex", "mDirection", "getMDirection$annotations", "()V", "getMDirection", "setMDirection", "add", "", "traverseStart", "", "node", "Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "startPosition", "traverseEnd", "computeWrapSize", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "orientation", "defineTerminalWidget", "defineTerminalWidgets", "horizontalCheck", "verticalCheck", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class RunGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int position;
    private boolean dual;
    @Nullable
    private WidgetRun mFirstRun;
    @Nullable
    private WidgetRun mLastRun;
    @NotNull
    private ArrayList<WidgetRun> mRuns;
    private int mGroupIndex;
    private int mDirection;
    public static final int $stable = 8;
    public static final int START = 0;
    public static final int END = 1;
    public static final int BASELINE = 2;
    private static int index;

    public RunGroup(@NotNull WidgetRun run, int dir) {
        Intrinsics.checkNotNullParameter((Object)run, (String)"run");
        this.mLastRun = run;
        this.mRuns = new ArrayList();
        this.mDirection = dir;
        this.mGroupIndex = index;
        int n = index;
        index = n + 1;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    public final boolean getDual() {
        return this.dual;
    }

    public final void setDual(boolean bl) {
        this.dual = bl;
    }

    @Nullable
    public final WidgetRun getMFirstRun() {
        return this.mFirstRun;
    }

    public final void setMFirstRun(@Nullable WidgetRun widgetRun) {
        this.mFirstRun = widgetRun;
    }

    @Nullable
    public final WidgetRun getMLastRun() {
        return this.mLastRun;
    }

    public final void setMLastRun(@Nullable WidgetRun widgetRun) {
        this.mLastRun = widgetRun;
    }

    @NotNull
    public final ArrayList<WidgetRun> getMRuns() {
        return this.mRuns;
    }

    public final void setMRuns(@NotNull ArrayList<WidgetRun> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mRuns = arrayList;
    }

    public final int getMGroupIndex() {
        return this.mGroupIndex;
    }

    public final void setMGroupIndex(int n) {
        this.mGroupIndex = n;
    }

    public final int getMDirection() {
        return this.mDirection;
    }

    public final void setMDirection(int n) {
        this.mDirection = n;
    }

    public static /* synthetic */ void getMDirection$annotations() {
    }

    public final void add(@NotNull WidgetRun run) {
        Intrinsics.checkNotNullParameter((Object)run, (String)"run");
        this.mRuns.add(run);
        this.mLastRun = run;
    }

    private final long traverseStart(DependencyNode node, long startPosition) {
        WidgetRun run = node.getMRun();
        if (run instanceof HelperReferences) {
            return startPosition;
        }
        long position = startPosition;
        int count = node.getMDependencies().size();
        for (int i = 0; i < count; ++i) {
            Dependency nextNode;
            Dependency dependency;
            Intrinsics.checkNotNullExpressionValue((Object)node.getMDependencies().get(i), (String)"get(...)");
            if (!(dependency instanceof DependencyNode) || Intrinsics.areEqual((Object)((DependencyNode)(nextNode = dependency)).getMRun(), (Object)run)) continue;
            position = Math.max(position, this.traverseStart((DependencyNode)nextNode, startPosition + (long)((DependencyNode)nextNode).getMMargin()));
        }
        if (Intrinsics.areEqual((Object)node, (Object)run.getStart())) {
            long dimension = run.getWrapDimension();
            position = Math.max(position, this.traverseStart(run.getEnd(), startPosition + dimension));
            position = Math.max(position, startPosition + dimension - (long)run.getEnd().getMMargin());
        }
        return position;
    }

    private final long traverseEnd(DependencyNode node, long startPosition) {
        WidgetRun run = node.getMRun();
        if (run instanceof HelperReferences) {
            return startPosition;
        }
        long position = startPosition;
        int count = node.getMDependencies().size();
        for (int i = 0; i < count; ++i) {
            Dependency nextNode;
            Dependency dependency;
            Intrinsics.checkNotNullExpressionValue((Object)node.getMDependencies().get(i), (String)"get(...)");
            if (!(dependency instanceof DependencyNode) || Intrinsics.areEqual((Object)((DependencyNode)(nextNode = dependency)).getMRun(), (Object)run)) continue;
            position = Math.min(position, this.traverseEnd((DependencyNode)nextNode, startPosition + (long)((DependencyNode)nextNode).getMMargin()));
        }
        if (Intrinsics.areEqual((Object)node, (Object)run.getEnd())) {
            long dimension = run.getWrapDimension();
            position = Math.min(position, this.traverseEnd(run.getStart(), startPosition - dimension));
            position = Math.min(position, startPosition - dimension - (long)run.getStart().getMMargin());
        }
        return position;
    }

    public final long computeWrapSize(@NotNull ConstraintWidgetContainer container, int orientation) {
        DependencyNode dependencyNode;
        DependencyNode containerStart;
        DependencyNode dependencyNode2;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (this.mFirstRun instanceof ChainRun) {
            WidgetRun widgetRun = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.analyzer.ChainRun");
            ChainRun chainRun = (ChainRun)widgetRun;
            if (chainRun.getOrientation() != orientation) {
                return 0L;
            }
        } else if (orientation == 0 ? !(this.mFirstRun instanceof HorizontalWidgetRun) : !(this.mFirstRun instanceof VerticalWidgetRun)) {
            return 0L;
        }
        if (orientation == 0) {
            HorizontalWidgetRun horizontalWidgetRun = container.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            dependencyNode2 = horizontalWidgetRun.getStart();
        } else {
            VerticalWidgetRun verticalWidgetRun = container.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            dependencyNode2 = containerStart = verticalWidgetRun.getStart();
        }
        if (orientation == 0) {
            HorizontalWidgetRun horizontalWidgetRun = container.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            dependencyNode = horizontalWidgetRun.getEnd();
        } else {
            VerticalWidgetRun verticalWidgetRun = container.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            dependencyNode = verticalWidgetRun.getEnd();
        }
        DependencyNode containerEnd = dependencyNode;
        WidgetRun widgetRun = this.mFirstRun;
        Intrinsics.checkNotNull((Object)widgetRun);
        boolean runWithStartTarget = widgetRun.getStart().getMTargets().contains(containerStart);
        WidgetRun widgetRun2 = this.mFirstRun;
        Intrinsics.checkNotNull((Object)widgetRun2);
        boolean runWithEndTarget = widgetRun2.getEnd().getMTargets().contains(containerEnd);
        WidgetRun widgetRun3 = this.mFirstRun;
        Intrinsics.checkNotNull((Object)widgetRun3);
        long dimension = widgetRun3.getWrapDimension();
        if (runWithStartTarget && runWithEndTarget) {
            WidgetRun widgetRun4 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun4);
            long maxPosition = this.traverseStart(widgetRun4.getStart(), 0L);
            WidgetRun widgetRun5 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun5);
            long minPosition = this.traverseEnd(widgetRun5.getEnd(), 0L);
            long endGap = maxPosition - dimension;
            WidgetRun widgetRun6 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun6);
            if (endGap >= (long)(-widgetRun6.getEnd().getMMargin())) {
                WidgetRun widgetRun7 = this.mFirstRun;
                Intrinsics.checkNotNull((Object)widgetRun7);
                endGap += (long)widgetRun7.getEnd().getMMargin();
            }
            long l = -minPosition - dimension;
            WidgetRun widgetRun8 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun8);
            long startGap = l - (long)widgetRun8.getStart().getMMargin();
            WidgetRun widgetRun9 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun9);
            if (startGap >= (long)widgetRun9.getStart().getMMargin()) {
                WidgetRun widgetRun10 = this.mFirstRun;
                Intrinsics.checkNotNull((Object)widgetRun10);
                startGap -= (long)widgetRun10.getStart().getMMargin();
            }
            WidgetRun widgetRun11 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun11);
            ConstraintWidget constraintWidget = widgetRun11.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            float bias = constraintWidget.getBiasPercent(orientation);
            long gap = 0L;
            if (bias > 0.0f) {
                gap = (long)((float)startGap / bias + (float)endGap / (1.0f - bias));
            }
            startGap = (long)(0.5f + (float)gap * bias);
            endGap = (long)(0.5f + (float)gap * (1.0f - bias));
            long runDimension = startGap + dimension + endGap;
            WidgetRun widgetRun12 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun12);
            long l2 = (long)widgetRun12.getStart().getMMargin() + runDimension;
            WidgetRun widgetRun13 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun13);
            dimension = l2 - (long)widgetRun13.getEnd().getMMargin();
        } else if (runWithStartTarget) {
            WidgetRun widgetRun14 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun14);
            DependencyNode dependencyNode3 = widgetRun14.getStart();
            WidgetRun widgetRun15 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun15);
            long maxPosition = this.traverseStart(dependencyNode3, widgetRun15.getStart().getMMargin());
            WidgetRun widgetRun16 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun16);
            long runDimension = (long)widgetRun16.getStart().getMMargin() + dimension;
            dimension = Math.max(maxPosition, runDimension);
        } else if (runWithEndTarget) {
            WidgetRun widgetRun17 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun17);
            DependencyNode dependencyNode4 = widgetRun17.getEnd();
            WidgetRun widgetRun18 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun18);
            long minPosition = this.traverseEnd(dependencyNode4, widgetRun18.getEnd().getMMargin());
            WidgetRun widgetRun19 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun19);
            long runDimension = (long)(-widgetRun19.getEnd().getMMargin()) + dimension;
            dimension = Math.max(-minPosition, runDimension);
        } else {
            WidgetRun widgetRun20 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun20);
            dimension = widgetRun20.getStart().getMMargin();
            WidgetRun widgetRun21 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun21);
            long l = widgetRun21.getWrapDimension();
            WidgetRun widgetRun22 = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun22);
            long cfr_ignored_0 = l - (long)widgetRun22.getEnd().getMMargin();
        }
        return dimension;
    }

    private final boolean defineTerminalWidget(WidgetRun run, int orientation) {
        WidgetRun widgetChainRun;
        Iterator<WidgetRun> iterator;
        ChainRun chainRun;
        Dependency node;
        Dependency dependency;
        ConstraintWidget constraintWidget = run.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        if (!constraintWidget.isTerminalWidget()[orientation]) {
            return false;
        }
        Iterator<Dependency> iterator2 = run.getStart().getMDependencies().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Dependency> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            if (!(dependency instanceof DependencyNode) || Intrinsics.areEqual((Object)((DependencyNode)(node = dependency)).getMRun(), (Object)run) || !Intrinsics.areEqual((Object)node, (Object)((DependencyNode)node).getMRun().getStart())) continue;
            if (run instanceof ChainRun) {
                chainRun = (ChainRun)run;
                Intrinsics.checkNotNullExpressionValue(chainRun.getMWidgets().iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                    this.defineTerminalWidget(widgetChainRun, orientation);
                }
            } else if (!(run instanceof HelperReferences)) {
                ConstraintWidget constraintWidget2 = run.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget2);
                constraintWidget2.isTerminalWidget()[orientation] = false;
            }
            this.defineTerminalWidget(((DependencyNode)node).getMRun(), orientation);
        }
        Iterator<Dependency> iterator4 = run.getEnd().getMDependencies().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            if (!(dependency instanceof DependencyNode) || Intrinsics.areEqual((Object)((DependencyNode)(node = dependency)).getMRun(), (Object)run) || !Intrinsics.areEqual((Object)node, (Object)((DependencyNode)node).getMRun().getStart())) continue;
            if (run instanceof ChainRun) {
                chainRun = (ChainRun)run;
                Intrinsics.checkNotNullExpressionValue(chainRun.getMWidgets().iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                    this.defineTerminalWidget(widgetChainRun, orientation);
                }
            } else if (!(run instanceof HelperReferences)) {
                ConstraintWidget constraintWidget3 = run.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget3);
                constraintWidget3.isTerminalWidget()[orientation] = false;
            }
            this.defineTerminalWidget(((DependencyNode)node).getMRun(), orientation);
        }
        return false;
    }

    public final void defineTerminalWidgets(boolean horizontalCheck, boolean verticalCheck) {
        if (horizontalCheck && this.mFirstRun instanceof HorizontalWidgetRun) {
            WidgetRun widgetRun = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun);
            this.defineTerminalWidget(widgetRun, 0);
        }
        if (verticalCheck && this.mFirstRun instanceof VerticalWidgetRun) {
            WidgetRun widgetRun = this.mFirstRun;
            Intrinsics.checkNotNull((Object)widgetRun);
            this.defineTerminalWidget(widgetRun, 1);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/RunGroup$Companion;", "", "<init>", "()V", "START", "", "END", "BASELINE", "index", "getIndex", "()I", "setIndex", "(I)V", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public final int getIndex() {
            return index;
        }

        public final void setIndex(int n) {
            index = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

