/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Flow;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.WidgetGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/Grouping;", "", "<init>", "()V", "Companion", "compose"})
@StabilityInferred(parameters=1)
public final class Grouping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_GROUPING = false;
    private static final boolean FORCE_USE = true;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J/\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0017j\b\u0012\u0004\u0012\u00020\u0014`\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ?\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0017j\b\u0012\u0004\u0012\u00020\u0014`\u00162\b\u0010 \u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/Grouping$Companion;", "", "<init>", "()V", "DEBUG", "", "DEBUG_GROUPING", "FORCE_USE", "validInGroup", "layoutHorizontal", "Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;", "layoutVertical", "widgetHorizontal", "widgetVertical", "simpleSolvingPass", "layout", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "measurer", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measurer;", "findGroup", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup;", "horizontalDependencyLists", "Lkotlin/collections/ArrayList;", "Ljava/util/ArrayList;", "groupId", "", "(Ljava/util/ArrayList;I)Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup;", "findDependents", "constraintWidget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "orientation", "list", "group", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;ILjava/util/ArrayList;Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup;)Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup;", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean validInGroup(@NotNull ConstraintWidget.DimensionBehaviour layoutHorizontal, @NotNull ConstraintWidget.DimensionBehaviour layoutVertical, @NotNull ConstraintWidget.DimensionBehaviour widgetHorizontal, @NotNull ConstraintWidget.DimensionBehaviour widgetVertical) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutHorizontal), (String)"layoutHorizontal");
            Intrinsics.checkNotNullParameter((Object)((Object)layoutVertical), (String)"layoutVertical");
            Intrinsics.checkNotNullParameter((Object)((Object)widgetHorizontal), (String)"widgetHorizontal");
            Intrinsics.checkNotNullParameter((Object)((Object)widgetVertical), (String)"widgetVertical");
            boolean fixedHorizontal = widgetHorizontal == ConstraintWidget.DimensionBehaviour.FIXED || widgetHorizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || widgetHorizontal == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && layoutHorizontal != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            boolean fixedVertical = widgetVertical == ConstraintWidget.DimensionBehaviour.FIXED || widgetVertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || widgetVertical == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && layoutVertical != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            return fixedHorizontal || fixedVertical;
        }

        public final boolean simpleSolvingPass(@NotNull ConstraintWidgetContainer layout, @Nullable BasicMeasure.Measurer measurer) {
            WidgetGroup list;
            Iterator<WidgetGroup> iterator;
            WidgetGroup picked;
            ConstraintAnchor center;
            ConstraintAnchor bottom;
            ConstraintAnchor baseline;
            ConstraintAnchor top;
            Object first;
            ConstraintAnchor center2;
            Object first2;
            ConstraintAnchor right;
            Object first3;
            WidgetGroup group;
            Iterator<ConstraintAnchor> barrier;
            Guideline guideline;
            Object helper;
            int i2;
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            ArrayList<ConstraintWidget> children = layout.getChildren();
            int count = children.size();
            ArrayList<Guideline> verticalGuidelines = null;
            ArrayList<Guideline> horizontalGuidelines = null;
            ArrayList<Object> horizontalBarriers = null;
            ArrayList<Barrier> verticalBarriers = null;
            ArrayList<ConstraintWidget> isolatedHorizontalChildren = null;
            ArrayList<ConstraintWidget> isolatedVerticalChildren = null;
            for (i2 = 0; i2 < count; ++i2) {
                ConstraintWidget child;
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i2), (String)"get(...)");
                if (!this.validInGroup(layout.getHorizontalDimensionBehaviour(), layout.getVerticalDimensionBehaviour(), child.getHorizontalDimensionBehaviour(), child.getVerticalDimensionBehaviour())) {
                    return false;
                }
                if (!(child instanceof Flow)) continue;
                return false;
            }
            if (layout.getMMetrics() != null) {
                Metrics metrics = layout.getMMetrics();
                Intrinsics.checkNotNull((Object)metrics);
                Metrics i2 = metrics;
                long child = i2.getGrouping();
                i2.setGrouping(child + 1L);
            }
            for (i2 = 0; i2 < count; ++i2) {
                ConstraintWidget child;
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i2), (String)"get(...)");
                if (!this.validInGroup(layout.getHorizontalDimensionBehaviour(), layout.getVerticalDimensionBehaviour(), child.getHorizontalDimensionBehaviour(), child.getVerticalDimensionBehaviour())) {
                    ConstraintWidgetContainer.Companion.measure(0, child, measurer, layout.getMMeasure(), BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                }
                if (child instanceof Guideline) {
                    Guideline guideline2 = (Guideline)child;
                    if (guideline2.getOrientation() == 0) {
                        if (horizontalGuidelines == null) {
                            horizontalGuidelines = new ArrayList<Guideline>();
                        }
                        horizontalGuidelines.add(guideline2);
                    }
                    if (guideline2.getOrientation() == 1) {
                        if (verticalGuidelines == null) {
                            verticalGuidelines = new ArrayList<Guideline>();
                        }
                        verticalGuidelines.add(guideline2);
                    }
                }
                if (child instanceof HelperWidget) {
                    if (child instanceof Barrier) {
                        Barrier barrier2 = (Barrier)child;
                        if (barrier2.getOrientation() == 0) {
                            if (horizontalBarriers == null) {
                                horizontalBarriers = new ArrayList();
                            }
                            horizontalBarriers.add(barrier2);
                        }
                        if (barrier2.getOrientation() == 1) {
                            if (verticalBarriers == null) {
                                verticalBarriers = new ArrayList();
                            }
                            verticalBarriers.add(barrier2);
                        }
                    } else {
                        helper = child;
                        if (horizontalBarriers == null) {
                            horizontalBarriers = new ArrayList<Object>();
                        }
                        horizontalBarriers.add(helper);
                        if (verticalBarriers == null) {
                            verticalBarriers = new ArrayList<Barrier>();
                        }
                        verticalBarriers.add((Barrier)helper);
                    }
                }
                if (child.getMLeft().getMTarget() == null && child.getMRight().getMTarget() == null && !(child instanceof Guideline) && !(child instanceof Barrier)) {
                    if (isolatedHorizontalChildren == null) {
                        isolatedHorizontalChildren = new ArrayList<ConstraintWidget>();
                    }
                    isolatedHorizontalChildren.add(child);
                }
                if (child.getMTop().getMTarget() != null || child.getMBottom().getMTarget() != null || child.getMBaseline().getMTarget() != null || child instanceof Guideline || child instanceof Barrier) continue;
                if (isolatedVerticalChildren == null) {
                    isolatedVerticalChildren = new ArrayList<ConstraintWidget>();
                }
                isolatedVerticalChildren.add(child);
            }
            ArrayList<WidgetGroup> allDependencyLists = new ArrayList<WidgetGroup>();
            ArrayList<WidgetGroup> dependencyLists = allDependencyLists;
            if (verticalGuidelines != null) {
                Iterator iterator2 = verticalGuidelines.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                helper = iterator2;
                while (helper.hasNext()) {
                    Object e = helper.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    guideline = (Guideline)e;
                    this.findDependents(guideline, 0, dependencyLists, null);
                }
            }
            if (horizontalBarriers != null) {
                Iterator iterator3 = horizontalBarriers.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
                helper = iterator3;
                while (helper.hasNext()) {
                    Object e = helper.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    barrier = (HelperWidget)e;
                    group = this.findDependents((ConstraintWidget)((Object)barrier), 0, dependencyLists, null);
                    ((HelperWidget)((Object)barrier)).addDependents(dependencyLists, 0, group);
                    WidgetGroup widgetGroup = group;
                    Intrinsics.checkNotNull((Object)widgetGroup);
                    widgetGroup.cleanup(dependencyLists);
                }
            }
            Iterator left = layout.getAnchor(ConstraintAnchor.Type.LEFT);
            ConstraintAnchor constraintAnchor = left;
            Intrinsics.checkNotNull((Object)constraintAnchor);
            if (constraintAnchor.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = ((ConstraintAnchor)((Object)left)).getDependents();
                Intrinsics.checkNotNull(hashSet);
                Iterator<ConstraintAnchor> iterator4 = hashSet.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
                barrier = iterator4;
                while (barrier.hasNext()) {
                    Object e = barrier.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    first3 = (ConstraintAnchor)e;
                    this.findDependents(((ConstraintAnchor)first3).getMOwner(), 0, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor2 = right = layout.getAnchor(ConstraintAnchor.Type.RIGHT);
            Intrinsics.checkNotNull((Object)constraintAnchor2);
            if (constraintAnchor2.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = right.getDependents();
                Intrinsics.checkNotNull(hashSet);
                Iterator<ConstraintAnchor> iterator5 = hashSet.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
                first3 = iterator5;
                while (first3.hasNext()) {
                    Object e = first3.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    first2 = (ConstraintAnchor)e;
                    this.findDependents(((ConstraintAnchor)first2).getMOwner(), 0, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor3 = center2 = layout.getAnchor(ConstraintAnchor.Type.CENTER);
            Intrinsics.checkNotNull((Object)constraintAnchor3);
            if (constraintAnchor3.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = center2.getDependents();
                Intrinsics.checkNotNull(hashSet);
                Iterator<ConstraintAnchor> iterator6 = hashSet.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator6, (String)"iterator(...)");
                first2 = iterator6;
                while (first2.hasNext()) {
                    Object e = first2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    first = (ConstraintAnchor)e;
                    this.findDependents(((ConstraintAnchor)first).getMOwner(), 0, dependencyLists, null);
                }
            }
            if (isolatedHorizontalChildren != null) {
                Iterator iterator7 = isolatedHorizontalChildren.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator7, (String)"iterator(...)");
                first2 = iterator7;
                while (first2.hasNext()) {
                    Object e = first2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintWidget widget = (ConstraintWidget)e;
                    this.findDependents(widget, 0, dependencyLists, null);
                }
            }
            dependencyLists = allDependencyLists;
            if (horizontalGuidelines != null) {
                Iterator iterator8 = horizontalGuidelines.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator8, (String)"iterator(...)");
                left = iterator8;
                while (left.hasNext()) {
                    Guideline guideline3 = guideline = (Guideline)left.next();
                    Intrinsics.checkNotNull((Object)guideline3);
                    this.findDependents(guideline3, 1, dependencyLists, null);
                }
            }
            if (verticalBarriers != null) {
                Iterator iterator9 = verticalBarriers.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator9, (String)"iterator(...)");
                left = iterator9;
                while (left.hasNext()) {
                    Object e = left.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    barrier = (HelperWidget)e;
                    group = this.findDependents((ConstraintWidget)((Object)barrier), 1, dependencyLists, null);
                    ((HelperWidget)((Object)barrier)).addDependents(dependencyLists, 1, group);
                    WidgetGroup widgetGroup = group;
                    Intrinsics.checkNotNull((Object)widgetGroup);
                    widgetGroup.cleanup(dependencyLists);
                }
            }
            ConstraintAnchor constraintAnchor4 = top = layout.getAnchor(ConstraintAnchor.Type.TOP);
            Intrinsics.checkNotNull((Object)constraintAnchor4);
            if (constraintAnchor4.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = top.getDependents();
                Intrinsics.checkNotNull(hashSet);
                Iterator<ConstraintAnchor> iterator10 = hashSet.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator10, (String)"iterator(...)");
                barrier = iterator10;
                while (barrier.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)barrier.next(), (String)"next(...)");
                    this.findDependents(((ConstraintAnchor)first3).getMOwner(), 1, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor5 = baseline = layout.getAnchor(ConstraintAnchor.Type.BASELINE);
            Intrinsics.checkNotNull((Object)constraintAnchor5);
            if (constraintAnchor5.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = baseline.getDependents();
                Intrinsics.checkNotNull(hashSet);
                Iterator<ConstraintAnchor> iterator11 = hashSet.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator11, (String)"iterator(...)");
                first3 = iterator11;
                while (first3.hasNext()) {
                    Object e = first3.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    first2 = (ConstraintAnchor)e;
                    this.findDependents(((ConstraintAnchor)first2).getMOwner(), 1, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor6 = bottom = layout.getAnchor(ConstraintAnchor.Type.BOTTOM);
            Intrinsics.checkNotNull((Object)constraintAnchor6);
            if (constraintAnchor6.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = bottom.getDependents();
                Intrinsics.checkNotNull(hashSet);
                Iterator<ConstraintAnchor> iterator12 = hashSet.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator12, (String)"iterator(...)");
                first2 = iterator12;
                while (first2.hasNext()) {
                    Object e = first2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    first = (ConstraintAnchor)e;
                    this.findDependents(((ConstraintAnchor)first).getMOwner(), 1, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor7 = center = layout.getAnchor(ConstraintAnchor.Type.CENTER);
            Intrinsics.checkNotNull((Object)constraintAnchor7);
            if (constraintAnchor7.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = center.getDependents();
                Intrinsics.checkNotNull(hashSet);
                Iterator<ConstraintAnchor> iterator13 = hashSet.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator13, (String)"iterator(...)");
                first = iterator13;
                while (first.hasNext()) {
                    Object e = first.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintAnchor first4 = (ConstraintAnchor)e;
                    this.findDependents(first4.getMOwner(), 1, dependencyLists, null);
                }
            }
            if (isolatedVerticalChildren != null) {
                Iterator iterator14 = isolatedVerticalChildren.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator14, (String)"iterator(...)");
                first = iterator14;
                while (first.hasNext()) {
                    Object e = first.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintWidget widget = (ConstraintWidget)e;
                    this.findDependents(widget, 1, dependencyLists, null);
                }
            }
            for (int i3 = 0; i3 < count; ++i3) {
                ConstraintWidget child;
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i3), (String)"get(...)");
                if (!child.oppositeDimensionsTied()) continue;
                WidgetGroup horizontalGroup = this.findGroup(allDependencyLists, child.getHorizontalGroup());
                WidgetGroup verticalGroup = this.findGroup(allDependencyLists, child.getVerticalGroup());
                if (horizontalGroup == null || verticalGroup == null) continue;
                horizontalGroup.moveTo(0, verticalGroup);
                verticalGroup.setOrientation(2);
                allDependencyLists.remove(horizontalGroup);
            }
            if (allDependencyLists.size() <= 1) {
                return false;
            }
            WidgetGroup horizontalPick = null;
            WidgetGroup verticalPick = null;
            if (layout.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                int maxWrap = 0;
                picked = null;
                Iterator<WidgetGroup> iterator15 = allDependencyLists.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator15, (String)"iterator(...)");
                iterator = iterator15;
                while (iterator.hasNext()) {
                    WidgetGroup widgetGroup = list = iterator.next();
                    Intrinsics.checkNotNull((Object)widgetGroup);
                    if (widgetGroup.getOrientation() == 1) continue;
                    list.setAuthoritative(false);
                    int wrap = list.measureWrap(layout.getSystem(), 0);
                    if (wrap <= maxWrap) continue;
                    picked = list;
                    maxWrap = wrap;
                }
                if (picked != null) {
                    layout.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    layout.setWidth(maxWrap);
                    picked.setAuthoritative(true);
                    horizontalPick = picked;
                }
            }
            if (layout.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                int maxWrap = 0;
                picked = null;
                Iterator<WidgetGroup> iterator16 = allDependencyLists.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator16, (String)"iterator(...)");
                iterator = iterator16;
                while (iterator.hasNext()) {
                    WidgetGroup widgetGroup = list = iterator.next();
                    Intrinsics.checkNotNull((Object)widgetGroup);
                    if (widgetGroup.getOrientation() == 0) continue;
                    list.setAuthoritative(false);
                    int wrap = list.measureWrap(layout.getSystem(), 1);
                    if (wrap <= maxWrap) continue;
                    picked = list;
                    maxWrap = wrap;
                }
                if (picked != null) {
                    layout.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    layout.setHeight(maxWrap);
                    picked.setAuthoritative(true);
                    verticalPick = picked;
                }
            }
            return horizontalPick != null || verticalPick != null;
        }

        private final WidgetGroup findGroup(ArrayList<WidgetGroup> horizontalDependencyLists, int groupId) {
            int count = horizontalDependencyLists.size();
            for (int i = 0; i < count; ++i) {
                WidgetGroup group;
                Intrinsics.checkNotNullExpressionValue((Object)horizontalDependencyLists.get(i), (String)"get(...)");
                if (groupId != group.getId()) continue;
                return group;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public final WidgetGroup findDependents(@NotNull ConstraintWidget constraintWidget, int orientation, @NotNull ArrayList<WidgetGroup> list, @Nullable WidgetGroup group) {
            WidgetGroup widgetGroup;
            int i;
            int n;
            int groupId;
            WidgetGroup group2;
            block14: {
                block13: {
                    block11: {
                        block12: {
                            Intrinsics.checkNotNullParameter((Object)constraintWidget, (String)"constraintWidget");
                            Intrinsics.checkNotNullParameter(list, (String)"list");
                            group2 = group;
                            groupId = orientation == 0 ? constraintWidget.getHorizontalGroup() : constraintWidget.getVerticalGroup();
                            if (groupId == -1) break block11;
                            if (group2 == null) break block12;
                            if (groupId == group2.getId()) break block11;
                        }
                        n = ((Collection)list).size();
                        break block13;
                    }
                    if (groupId != -1) {
                        return group2;
                    }
                    break block14;
                }
                for (i = 0; i < n; ++i) {
                    Intrinsics.checkNotNullExpressionValue((Object)list.get(i), (String)"get(...)");
                    if (widgetGroup.getId() != groupId) continue;
                    if (group2 != null) {
                        group2.moveTo(orientation, widgetGroup);
                        list.remove(group2);
                    }
                    group2 = widgetGroup;
                    break;
                }
            }
            if (group2 == null) {
                if (constraintWidget instanceof HelperWidget && (groupId = ((HelperWidget)constraintWidget).findGroupInDependents(orientation)) != -1) {
                    n = ((Collection)list).size();
                    for (i = 0; i < n; ++i) {
                        Intrinsics.checkNotNullExpressionValue((Object)list.get(i), (String)"get(...)");
                        if (widgetGroup.getId() != groupId) continue;
                        group2 = widgetGroup;
                        break;
                    }
                }
                if (group2 == null) {
                    group2 = new WidgetGroup(orientation);
                }
                list.add(group2);
            }
            if (group2.add(constraintWidget)) {
                if (constraintWidget instanceof Guideline) {
                    Guideline guideline = (Guideline)constraintWidget;
                    guideline.getAnchor().findDependents(guideline.getOrientation() == 0 ? 1 : 0, list, group2);
                }
                if (orientation == 0) {
                    constraintWidget.setHorizontalGroup(group2.getId());
                    constraintWidget.getMLeft().findDependents(orientation, list, group2);
                    constraintWidget.getMRight().findDependents(orientation, list, group2);
                } else {
                    constraintWidget.setVerticalGroup(group2.getId());
                    constraintWidget.getMTop().findDependents(orientation, list, group2);
                    constraintWidget.getMBaseline().findDependents(orientation, list, group2);
                    constraintWidget.getMBottom().findDependents(orientation, list, group2);
                }
                constraintWidget.getMCenter().findDependents(orientation, list, group2);
            }
            return group2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

