/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.GuidelineReference;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.RunGroup;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 N2\u00020\u0001:\u0001NB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ\u0016\u0010#\u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aJ0\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0006\u0010+\u001a\u00020\u0017J\u0006\u0010,\u001a\u00020\u0017J\u0006\u0010-\u001a\u00020\u0017J\u0006\u00103\u001a\u00020\u0017J#\u00103\u001a\u00020\u00172\u0016\u00104\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`5\u00a2\u0006\u0002\u00102J\b\u00106\u001a\u00020\u0017H\u0002JQ\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u0002092\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u001a2\b\u0010;\u001a\u0004\u0018\u0001092\u0016\u0010<\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\fj\b\u0012\u0004\u0012\u00020\u000f`52\b\u0010=\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010>J5\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001a2\u0016\u0010<\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\fj\b\u0012\u0004\u0012\u00020\u000f`5H\u0002\u00a2\u0006\u0002\u0010AJ \u0010B\u001a\u00020C2\u0006\u00108\u001a\u0002092\u0006\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020CH\u0002J\u0010\u0010F\u001a\u00020C2\u0006\u0010@\u001a\u00020\rH\u0002J\u0018\u0010G\u001a\u00020C2\u0006\u0010H\u001a\u00020I2\u0006\u0010E\u001a\u00020CH\u0002J\u0018\u0010J\u001a\u00020\b2\u0006\u0010K\u001a\u0002092\u0006\u0010;\u001a\u000209H\u0002J\u0018\u0010L\u001a\u00020C2\u0006\u0010M\u001a\u00020\r2\u0006\u0010E\u001a\u00020CH\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006O"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/DependencyGraph;", "", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "<init>", "(Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;)V", "mWidgetcontainer", "mNeedBuildGraph", "", "mNeedRedoMeasures", "mContainer", "mRuns", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "mRunGroups", "Landroidx/constraintlayout/core/widgets/analyzer/RunGroup;", "getMRunGroups$annotations", "()V", "mMeasurer", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measurer;", "mMeasure", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measure;", "setMeasurer", "", "measurer", "computeWrap", "", "orientation", "defineTerminalWidgets", "horizontalBehavior", "Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;", "verticalBehavior", "directMeasure", "optimizeWrap", "directMeasureSetup", "directMeasureWithOrientation", "measure", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "horizontalDimension", "verticalDimension", "basicMeasureWidgets", "constraintWidgetContainer", "measureWidgets", "invalidateGraph", "invalidateMeasures", "mGroups", "getMGroups", "()Ljava/util/ArrayList;", "setMGroups", "(Ljava/util/ArrayList;)V", "buildGraph", "runs", "Lkotlin/collections/ArrayList;", "displayGraph", "applyGroup", "node", "Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "direction", "end", "groups", "group", "(Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;IILandroidx/constraintlayout/core/widgets/analyzer/DependencyNode;Ljava/util/ArrayList;Landroidx/constraintlayout/core/widgets/analyzer/RunGroup;)V", "findGroup", "run", "(Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;ILjava/util/ArrayList;)V", "generateDisplayNode", "", "centeredConnection", "content", "nodeDefinition", "generateChainDisplayGraph", "chain", "Landroidx/constraintlayout/core/widgets/analyzer/ChainRun;", "isCenteredConnection", "start", "generateDisplayGraph", "root", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class DependencyGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConstraintWidgetContainer mWidgetcontainer;
    private boolean mNeedBuildGraph;
    private boolean mNeedRedoMeasures;
    @NotNull
    private final ConstraintWidgetContainer mContainer;
    @NotNull
    private final ArrayList<WidgetRun> mRuns;
    @NotNull
    private final ArrayList<RunGroup> mRunGroups;
    @Nullable
    private BasicMeasure.Measurer mMeasurer;
    @NotNull
    private final BasicMeasure.Measure mMeasure;
    @NotNull
    private ArrayList<RunGroup> mGroups;
    public static final int $stable = 8;
    private static final boolean USE_GROUPS = true;
    private static final boolean DEBUG = false;

    public DependencyGraph(@NotNull ConstraintWidgetContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.mWidgetcontainer = container;
        this.mNeedBuildGraph = true;
        this.mNeedRedoMeasures = true;
        this.mContainer = container;
        this.mRuns = new ArrayList();
        this.mRunGroups = new ArrayList();
        this.mMeasure = new BasicMeasure.Measure();
        this.mGroups = new ArrayList();
    }

    private static /* synthetic */ void getMRunGroups$annotations() {
    }

    public final void setMeasurer(@Nullable BasicMeasure.Measurer measurer) {
        this.mMeasurer = measurer;
    }

    private final int computeWrap(ConstraintWidgetContainer container, int orientation) {
        int count = this.mGroups.size();
        long wrapSize = 0L;
        for (int i = 0; i < count; ++i) {
            RunGroup run;
            Intrinsics.checkNotNullExpressionValue((Object)this.mGroups.get(i), (String)"get(...)");
            long size = run.computeWrapSize(container, orientation);
            wrapSize = Math.max(wrapSize, size);
        }
        return (int)wrapSize;
    }

    public final void defineTerminalWidgets(@NotNull ConstraintWidget.DimensionBehaviour horizontalBehavior, @NotNull ConstraintWidget.DimensionBehaviour verticalBehavior) {
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalBehavior), (String)"horizontalBehavior");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalBehavior), (String)"verticalBehavior");
        if (this.mNeedBuildGraph) {
            this.buildGraph();
            boolean hasBarrier = false;
            Iterator<ConstraintWidget> iterator = this.mWidgetcontainer.getMChildren().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Object> iterator2 = iterator;
            while (iterator2.hasNext()) {
                ConstraintWidget widget;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                widget.isTerminalWidget()[0] = true;
                widget.isTerminalWidget()[1] = true;
                if (!(widget instanceof Barrier)) continue;
                hasBarrier = true;
            }
            if (!hasBarrier) {
                Iterator<RunGroup> iterator3 = this.mGroups.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
                iterator2 = iterator3;
                while (iterator2.hasNext()) {
                    Object object = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                    RunGroup group = (RunGroup)object;
                    group.defineTerminalWidgets(horizontalBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, verticalBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
        }
    }

    public final boolean directMeasure(boolean optimizeWrap) {
        boolean avoid;
        boolean optimizeWrap2 = optimizeWrap;
        optimizeWrap2 &= true;
        if (this.mNeedBuildGraph || this.mNeedRedoMeasures) {
            Iterator<ConstraintWidget> iterator = this.mWidgetcontainer.getMChildren().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<ConstraintWidget> iterator2 = iterator;
            while (iterator2.hasNext()) {
                ConstraintWidget widget;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                widget.ensureWidgetRuns();
                widget.setMeasured(false);
                HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                horizontalWidgetRun.reset();
                VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                verticalWidgetRun.reset();
            }
            this.mWidgetcontainer.ensureWidgetRuns();
            this.mWidgetcontainer.setMeasured(false);
            HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            horizontalWidgetRun.reset();
            VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            verticalWidgetRun.reset();
            this.mNeedRedoMeasures = false;
        }
        if (avoid = this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.mWidgetcontainer.setX(0);
        this.mWidgetcontainer.setY(0);
        ConstraintWidget.DimensionBehaviour originalHorizontalDimension = this.mWidgetcontainer.getDimensionBehaviour(0);
        ConstraintWidget.DimensionBehaviour originalVerticalDimension = this.mWidgetcontainer.getDimensionBehaviour(1);
        if (this.mNeedBuildGraph) {
            this.buildGraph();
        }
        int x1 = this.mWidgetcontainer.getX();
        int y1 = this.mWidgetcontainer.getY();
        HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        horizontalWidgetRun.getStart().resolve(x1);
        VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun);
        verticalWidgetRun.getStart().resolve(y1);
        this.measureWidgets();
        if (originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            if (optimizeWrap2) {
                Iterator<WidgetRun> iterator = this.mRuns.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<WidgetRun> iterator3 = iterator;
                while (iterator3.hasNext()) {
                    WidgetRun run;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                    if (run.supportsWrapComputation()) continue;
                    optimizeWrap2 = false;
                    break;
                }
            }
            if (optimizeWrap2 && originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setWidth(this.computeWrap(this.mWidgetcontainer, 0));
                HorizontalWidgetRun horizontalWidgetRun2 = this.mWidgetcontainer.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                horizontalWidgetRun2.getMDimension().resolve(this.mWidgetcontainer.getWidth());
            }
            if (optimizeWrap2 && originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setHeight(this.computeWrap(this.mWidgetcontainer, 1));
                VerticalWidgetRun verticalWidgetRun2 = this.mWidgetcontainer.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                verticalWidgetRun2.getMDimension().resolve(this.mWidgetcontainer.getHeight());
            }
        }
        boolean checkRoot = false;
        if (this.mWidgetcontainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int x2 = x1 + this.mWidgetcontainer.getWidth();
            HorizontalWidgetRun horizontalWidgetRun3 = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
            horizontalWidgetRun3.getEnd().resolve(x2);
            HorizontalWidgetRun horizontalWidgetRun4 = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
            horizontalWidgetRun4.getMDimension().resolve(x2 - x1);
            this.measureWidgets();
            if (this.mWidgetcontainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int y2 = y1 + this.mWidgetcontainer.getHeight();
                VerticalWidgetRun verticalWidgetRun3 = this.mWidgetcontainer.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                verticalWidgetRun3.getEnd().resolve(y2);
                VerticalWidgetRun verticalWidgetRun4 = this.mWidgetcontainer.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun4);
                verticalWidgetRun4.getMDimension().resolve(y2 - y1);
            }
            this.measureWidgets();
            checkRoot = true;
        }
        Iterator<WidgetRun> iterator = this.mRuns.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<WidgetRun> x2 = iterator;
        while (x2.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)x2.next(), (String)"next(...)");
            if (Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mWidgetcontainer) && !run.getMResolved()) continue;
            run.applyToWidget();
        }
        boolean allResolved = true;
        Iterator<WidgetRun> iterator4 = this.mRuns.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        Iterator<WidgetRun> iterator5 = iterator4;
        while (iterator5.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)iterator5.next(), (String)"next(...)");
            if (!checkRoot && Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mWidgetcontainer)) continue;
            if (!run.getStart().getResolved()) {
                allResolved = false;
                break;
            }
            if (!run.getEnd().getResolved() && !(run instanceof GuidelineReference)) {
                allResolved = false;
                break;
            }
            if (run.getMDimension().getResolved() || run instanceof ChainRun || run instanceof GuidelineReference) continue;
            allResolved = false;
            break;
        }
        ConstraintWidget.DimensionBehaviour dimensionBehaviour = originalHorizontalDimension;
        Intrinsics.checkNotNull((Object)((Object)dimensionBehaviour));
        this.mWidgetcontainer.setHorizontalDimensionBehaviour(dimensionBehaviour);
        ConstraintWidget.DimensionBehaviour dimensionBehaviour2 = originalVerticalDimension;
        Intrinsics.checkNotNull((Object)((Object)dimensionBehaviour2));
        this.mWidgetcontainer.setVerticalDimensionBehaviour(dimensionBehaviour2);
        return allResolved;
    }

    public final boolean directMeasureSetup(boolean optimizeWrap) {
        boolean avoid;
        if (this.mNeedBuildGraph) {
            Iterator<ConstraintWidget> iterator = this.mWidgetcontainer.getMChildren().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<ConstraintWidget> iterator2 = iterator;
            while (iterator2.hasNext()) {
                ConstraintWidget widget;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                widget.ensureWidgetRuns();
                widget.setMeasured(false);
                HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                horizontalWidgetRun.getMDimension().setResolved(false);
                HorizontalWidgetRun horizontalWidgetRun2 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                horizontalWidgetRun2.setMResolved(false);
                HorizontalWidgetRun horizontalWidgetRun3 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                horizontalWidgetRun3.reset();
                VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                verticalWidgetRun.getMDimension().setResolved(false);
                VerticalWidgetRun verticalWidgetRun2 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                verticalWidgetRun2.setMResolved(false);
                VerticalWidgetRun verticalWidgetRun3 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                verticalWidgetRun3.reset();
            }
            this.mWidgetcontainer.ensureWidgetRuns();
            this.mWidgetcontainer.setMeasured(false);
            HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            horizontalWidgetRun.getMDimension().setResolved(false);
            HorizontalWidgetRun horizontalWidgetRun4 = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
            horizontalWidgetRun4.setMResolved(false);
            HorizontalWidgetRun horizontalWidgetRun5 = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun5);
            horizontalWidgetRun5.reset();
            VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            verticalWidgetRun.getMDimension().setResolved(false);
            VerticalWidgetRun verticalWidgetRun4 = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun4);
            verticalWidgetRun4.setMResolved(false);
            VerticalWidgetRun verticalWidgetRun5 = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun5);
            verticalWidgetRun5.reset();
            this.buildGraph();
        }
        if (avoid = this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.mWidgetcontainer.setX(0);
        this.mWidgetcontainer.setY(0);
        HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        horizontalWidgetRun.getStart().resolve(0);
        VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun);
        verticalWidgetRun.getStart().resolve(0);
        return true;
    }

    public final boolean directMeasureWithOrientation(boolean optimizeWrap, int orientation) {
        boolean optimizeWrap2 = optimizeWrap;
        ConstraintWidget.DimensionBehaviour originalHorizontalDimension = this.mWidgetcontainer.getDimensionBehaviour(0);
        ConstraintWidget.DimensionBehaviour originalVerticalDimension = this.mWidgetcontainer.getDimensionBehaviour(1);
        int x1 = this.mWidgetcontainer.getX();
        int y1 = this.mWidgetcontainer.getY();
        if ((optimizeWrap2 &= true) && (originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
            Iterator<WidgetRun> iterator = this.mRuns.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<WidgetRun> iterator2 = iterator;
            while (iterator2.hasNext()) {
                WidgetRun run;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (run.getOrientation() != orientation || run.supportsWrapComputation()) continue;
                optimizeWrap2 = false;
                break;
            }
            if (orientation == 0) {
                if (optimizeWrap2 && originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    this.mWidgetcontainer.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    this.mWidgetcontainer.setWidth(this.computeWrap(this.mWidgetcontainer, 0));
                    HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                    horizontalWidgetRun.getMDimension().resolve(this.mWidgetcontainer.getWidth());
                }
            } else if (optimizeWrap2 && originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setHeight(this.computeWrap(this.mWidgetcontainer, 1));
                VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                verticalWidgetRun.getMDimension().resolve(this.mWidgetcontainer.getHeight());
            }
        }
        boolean checkRoot = false;
        if (orientation == 0) {
            if (this.mWidgetcontainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int x2 = x1 + this.mWidgetcontainer.getWidth();
                HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                horizontalWidgetRun.getEnd().resolve(x2);
                HorizontalWidgetRun horizontalWidgetRun2 = this.mWidgetcontainer.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                horizontalWidgetRun2.getMDimension().resolve(x2 - x1);
                checkRoot = true;
            }
        } else if (this.mWidgetcontainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int y2 = y1 + this.mWidgetcontainer.getHeight();
            VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            verticalWidgetRun.getEnd().resolve(y2);
            VerticalWidgetRun verticalWidgetRun2 = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun2);
            verticalWidgetRun2.getMDimension().resolve(y2 - y1);
            checkRoot = true;
        }
        this.measureWidgets();
        Iterator<WidgetRun> iterator = this.mRuns.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<WidgetRun> y2 = iterator;
        while (y2.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)y2.next(), (String)"next(...)");
            if (run.getOrientation() != orientation || Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mWidgetcontainer) && !run.getMResolved()) continue;
            run.applyToWidget();
        }
        boolean allResolved = true;
        Iterator<WidgetRun> iterator3 = this.mRuns.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        Iterator<WidgetRun> iterator4 = iterator3;
        while (iterator4.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)iterator4.next(), (String)"next(...)");
            if (run.getOrientation() != orientation || !checkRoot && Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mWidgetcontainer)) continue;
            if (!run.getStart().getResolved()) {
                allResolved = false;
                break;
            }
            if (!run.getEnd().getResolved()) {
                allResolved = false;
                break;
            }
            if (run instanceof ChainRun || run.getMDimension().getResolved()) continue;
            allResolved = false;
            break;
        }
        ConstraintWidget.DimensionBehaviour dimensionBehaviour = originalHorizontalDimension;
        Intrinsics.checkNotNull((Object)((Object)dimensionBehaviour));
        this.mWidgetcontainer.setHorizontalDimensionBehaviour(dimensionBehaviour);
        ConstraintWidget.DimensionBehaviour dimensionBehaviour2 = originalVerticalDimension;
        Intrinsics.checkNotNull((Object)((Object)dimensionBehaviour2));
        this.mWidgetcontainer.setVerticalDimensionBehaviour(dimensionBehaviour2);
        return allResolved;
    }

    private final void measure(ConstraintWidget widget, ConstraintWidget.DimensionBehaviour horizontalBehavior, int horizontalDimension, ConstraintWidget.DimensionBehaviour verticalBehavior, int verticalDimension) {
        this.mMeasure.setHorizontalBehavior(horizontalBehavior);
        this.mMeasure.setVerticalBehavior(verticalBehavior);
        this.mMeasure.setHorizontalDimension(horizontalDimension);
        this.mMeasure.setVerticalDimension(verticalDimension);
        BasicMeasure.Measurer measurer = this.mMeasurer;
        Intrinsics.checkNotNull((Object)measurer);
        measurer.measure(widget, this.mMeasure);
        widget.setWidth(this.mMeasure.getMeasuredWidth());
        widget.setHeight(this.mMeasure.getMeasuredHeight());
        widget.setHasBaseline(this.mMeasure.getMeasuredHasBaseline());
        widget.setBaselineDistance(this.mMeasure.getMeasuredBaseline());
    }

    private final boolean basicMeasureWidgets(ConstraintWidgetContainer constraintWidgetContainer) {
        Iterator<ConstraintWidget> iterator = constraintWidgetContainer.getMChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ConstraintWidget> iterator2 = iterator;
        while (iterator2.hasNext()) {
            int height;
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            ConstraintWidget.DimensionBehaviour horizontal = widget.getMListDimensionBehaviors()[0];
            ConstraintWidget.DimensionBehaviour vertical = widget.getMListDimensionBehaviors()[1];
            if (widget.getVisibility() == 8) {
                widget.setMeasured(true);
                continue;
            }
            if (widget.getMMatchConstraintPercentWidth() < 1.0f && horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widget.setMMatchConstraintDefaultWidth(2);
            }
            if (widget.getMMatchConstraintPercentHeight() < 1.0f && vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widget.setMMatchConstraintDefaultHeight(2);
            }
            if (widget.getDimensionRatio() > 0.0f) {
                if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    widget.setMMatchConstraintDefaultWidth(3);
                } else if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horizontal == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    widget.setMMatchConstraintDefaultHeight(3);
                } else if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (widget.getMMatchConstraintDefaultWidth() == 0) {
                        widget.setMMatchConstraintDefaultWidth(3);
                    }
                    if (widget.getMMatchConstraintDefaultHeight() == 0) {
                        widget.setMMatchConstraintDefaultHeight(3);
                    }
                }
            }
            if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getMMatchConstraintDefaultWidth() == 1 && (widget.getMLeft().getMTarget() == null || widget.getMRight().getMTarget() == null)) {
                horizontal = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getMMatchConstraintDefaultHeight() == 1 && (widget.getMTop().getMTarget() == null || widget.getMBottom().getMTarget() == null)) {
                vertical = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            horizontalWidgetRun.setMDimensionBehavior(horizontal);
            HorizontalWidgetRun horizontalWidgetRun2 = widget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
            horizontalWidgetRun2.setMatchConstraintsType(widget.getMMatchConstraintDefaultWidth());
            VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            verticalWidgetRun.setMDimensionBehavior(vertical);
            VerticalWidgetRun verticalWidgetRun2 = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun2);
            verticalWidgetRun2.setMatchConstraintsType(widget.getMMatchConstraintDefaultHeight());
            if (!(horizontal != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && horizontal != ConstraintWidget.DimensionBehaviour.FIXED && horizontal != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && vertical != ConstraintWidget.DimensionBehaviour.FIXED && vertical != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
                int width = widget.getWidth();
                if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    width = constraintWidgetContainer.getWidth() - widget.getMLeft().getMMargin() - widget.getMRight().getMMargin();
                    horizontal = ConstraintWidget.DimensionBehaviour.FIXED;
                }
                int height2 = widget.getHeight();
                if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    height2 = constraintWidgetContainer.getHeight() - widget.getMTop().getMMargin() - widget.getMBottom().getMMargin();
                    vertical = ConstraintWidget.DimensionBehaviour.FIXED;
                }
                this.measure(widget, horizontal, width, vertical, height2);
                HorizontalWidgetRun horizontalWidgetRun3 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                horizontalWidgetRun3.getMDimension().resolve(widget.getWidth());
                VerticalWidgetRun verticalWidgetRun3 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                verticalWidgetRun3.getMDimension().resolve(widget.getHeight());
                widget.setMeasured(true);
                continue;
            }
            if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical == ConstraintWidget.DimensionBehaviour.FIXED)) {
                if (widget.getMMatchConstraintDefaultWidth() == 3) {
                    if (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    }
                    int height3 = widget.getHeight();
                    int width = (int)((float)height3 * widget.getMDimensionRatio() + 0.5f);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height3);
                    HorizontalWidgetRun horizontalWidgetRun4 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
                    horizontalWidgetRun4.getMDimension().resolve(widget.getWidth());
                    VerticalWidgetRun verticalWidgetRun4 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun4);
                    verticalWidgetRun4.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                    continue;
                }
                if (widget.getMMatchConstraintDefaultWidth() == 1) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    HorizontalWidgetRun horizontalWidgetRun5 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun5);
                    horizontalWidgetRun5.getMDimension().setWrapValue(widget.getWidth());
                    continue;
                }
                if (widget.getMMatchConstraintDefaultWidth() == 2) {
                    if (constraintWidgetContainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        float percent = widget.getMMatchConstraintPercentWidth();
                        int width = (int)(0.5f + percent * (float)constraintWidgetContainer.getWidth());
                        height = widget.getHeight();
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, vertical, height);
                        HorizontalWidgetRun horizontalWidgetRun6 = widget.getMHorizontalRun();
                        Intrinsics.checkNotNull((Object)horizontalWidgetRun6);
                        horizontalWidgetRun6.getMDimension().resolve(widget.getWidth());
                        VerticalWidgetRun verticalWidgetRun5 = widget.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun5);
                        verticalWidgetRun5.getMDimension().resolve(widget.getHeight());
                        widget.setMeasured(true);
                        continue;
                    }
                } else if (widget.getMListAnchors()[0].getMTarget() == null || widget.getMListAnchors()[1].getMTarget() == null) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    HorizontalWidgetRun horizontalWidgetRun7 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun7);
                    horizontalWidgetRun7.getMDimension().resolve(widget.getWidth());
                    VerticalWidgetRun verticalWidgetRun6 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun6);
                    verticalWidgetRun6.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                    continue;
                }
            }
            if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horizontal == ConstraintWidget.DimensionBehaviour.FIXED)) {
                if (widget.getMMatchConstraintDefaultHeight() == 3) {
                    if (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    }
                    int width = widget.getWidth();
                    float ratio = widget.getMDimensionRatio();
                    if (widget.getDimensionRatioSide() == -1) {
                        ratio = 1.0f / ratio;
                    }
                    height = (int)((float)width * ratio + 0.5f);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height);
                    HorizontalWidgetRun horizontalWidgetRun8 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun8);
                    horizontalWidgetRun8.getMDimension().resolve(widget.getWidth());
                    VerticalWidgetRun verticalWidgetRun7 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun7);
                    verticalWidgetRun7.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                    continue;
                }
                if (widget.getMMatchConstraintDefaultHeight() == 1) {
                    this.measure(widget, horizontal, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    VerticalWidgetRun verticalWidgetRun8 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun8);
                    verticalWidgetRun8.getMDimension().setWrapValue(widget.getHeight());
                    continue;
                }
                if (widget.getMMatchConstraintDefaultHeight() == 2) {
                    if (constraintWidgetContainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        float percent = widget.getMMatchConstraintPercentHeight();
                        int width = widget.getWidth();
                        height = (int)(0.5f + percent * (float)constraintWidgetContainer.getHeight());
                        this.measure(widget, horizontal, width, ConstraintWidget.DimensionBehaviour.FIXED, height);
                        HorizontalWidgetRun horizontalWidgetRun9 = widget.getMHorizontalRun();
                        Intrinsics.checkNotNull((Object)horizontalWidgetRun9);
                        horizontalWidgetRun9.getMDimension().resolve(widget.getWidth());
                        VerticalWidgetRun verticalWidgetRun9 = widget.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun9);
                        verticalWidgetRun9.getMDimension().resolve(widget.getHeight());
                        widget.setMeasured(true);
                        continue;
                    }
                } else if (widget.getMListAnchors()[2].getMTarget() == null || widget.getMListAnchors()[3].getMTarget() == null) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    HorizontalWidgetRun horizontalWidgetRun10 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun10);
                    horizontalWidgetRun10.getMDimension().resolve(widget.getWidth());
                    VerticalWidgetRun verticalWidgetRun10 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun10);
                    verticalWidgetRun10.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                    continue;
                }
            }
            if (horizontal != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || vertical != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            if (widget.getMMatchConstraintDefaultWidth() == 1 || widget.getMMatchConstraintDefaultHeight() == 1) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                HorizontalWidgetRun horizontalWidgetRun11 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun11);
                horizontalWidgetRun11.getMDimension().setWrapValue(widget.getWidth());
                VerticalWidgetRun verticalWidgetRun11 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun11);
                verticalWidgetRun11.getMDimension().setWrapValue(widget.getHeight());
                continue;
            }
            if (widget.getMMatchConstraintDefaultHeight() != 2 || widget.getMMatchConstraintDefaultWidth() != 2 || constraintWidgetContainer.getMListDimensionBehaviors()[0] != ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.getMListDimensionBehaviors()[1] != ConstraintWidget.DimensionBehaviour.FIXED) continue;
            float horizPercent = widget.getMMatchConstraintPercentWidth();
            float vertPercent = widget.getMMatchConstraintPercentHeight();
            int width = (int)(0.5f + horizPercent * (float)constraintWidgetContainer.getWidth());
            int height4 = (int)(0.5f + vertPercent * (float)constraintWidgetContainer.getHeight());
            this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height4);
            HorizontalWidgetRun horizontalWidgetRun12 = widget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun12);
            horizontalWidgetRun12.getMDimension().resolve(widget.getWidth());
            VerticalWidgetRun verticalWidgetRun12 = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun12);
            verticalWidgetRun12.getMDimension().resolve(widget.getHeight());
            widget.setMeasured(true);
        }
        return false;
    }

    public final void measureWidgets() {
        Iterator<ConstraintWidget> iterator = this.mWidgetcontainer.getMChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ConstraintWidget> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (widget.getMeasured()) continue;
            ConstraintWidget.DimensionBehaviour horiz = widget.getMListDimensionBehaviors()[0];
            ConstraintWidget.DimensionBehaviour vert = widget.getMListDimensionBehaviors()[1];
            int horizMatchConstraintsType = widget.getMMatchConstraintDefaultWidth();
            int vertMatchConstraintsType = widget.getMMatchConstraintDefaultHeight();
            boolean horizWrap = horiz == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && horizMatchConstraintsType == 1;
            boolean vertWrap = vert == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && vertMatchConstraintsType == 1;
            HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            boolean horizResolved = horizontalWidgetRun.getMDimension().getResolved();
            VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            boolean vertResolved = verticalWidgetRun.getMDimension().getResolved();
            if (horizResolved && vertResolved) {
                HorizontalWidgetRun horizontalWidgetRun2 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                int n = horizontalWidgetRun2.getMDimension().getValue();
                VerticalWidgetRun verticalWidgetRun2 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, n, ConstraintWidget.DimensionBehaviour.FIXED, verticalWidgetRun2.getMDimension().getValue());
                widget.setMeasured(true);
            } else if (horizResolved && vertWrap) {
                HorizontalWidgetRun horizontalWidgetRun3 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                int n = horizontalWidgetRun3.getMDimension().getValue();
                VerticalWidgetRun verticalWidgetRun3 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, n, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, verticalWidgetRun3.getMDimension().getValue());
                if (vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    VerticalWidgetRun verticalWidgetRun4 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun4);
                    verticalWidgetRun4.getMDimension().setWrapValue(widget.getHeight());
                } else {
                    VerticalWidgetRun verticalWidgetRun5 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun5);
                    verticalWidgetRun5.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                }
            } else if (vertResolved && horizWrap) {
                HorizontalWidgetRun horizontalWidgetRun4 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
                int n = horizontalWidgetRun4.getMDimension().getValue();
                VerticalWidgetRun verticalWidgetRun6 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun6);
                this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, n, ConstraintWidget.DimensionBehaviour.FIXED, verticalWidgetRun6.getMDimension().getValue());
                if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    HorizontalWidgetRun horizontalWidgetRun5 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun5);
                    horizontalWidgetRun5.getMDimension().setWrapValue(widget.getWidth());
                } else {
                    HorizontalWidgetRun horizontalWidgetRun6 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun6);
                    horizontalWidgetRun6.getMDimension().resolve(widget.getWidth());
                    widget.setMeasured(true);
                }
            }
            if (!widget.getMeasured()) continue;
            VerticalWidgetRun verticalWidgetRun7 = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun7);
            if (verticalWidgetRun7.getMBaselineDimension() == null) continue;
            VerticalWidgetRun verticalWidgetRun8 = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun8);
            DimensionDependency dimensionDependency = verticalWidgetRun8.getMBaselineDimension();
            Intrinsics.checkNotNull((Object)dimensionDependency);
            dimensionDependency.resolve(widget.getBaselineDistance());
        }
    }

    public final void invalidateGraph() {
        this.mNeedBuildGraph = true;
    }

    public final void invalidateMeasures() {
        this.mNeedRedoMeasures = true;
    }

    @NotNull
    public final ArrayList<RunGroup> getMGroups() {
        return this.mGroups;
    }

    public final void setMGroups(@NotNull ArrayList<RunGroup> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mGroups = arrayList;
    }

    public final void buildGraph() {
        this.buildGraph(this.mRuns);
        this.mGroups.clear();
        RunGroup.Companion.setIndex(0);
        HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        this.findGroup(horizontalWidgetRun, 0, this.mGroups);
        VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun);
        this.findGroup(verticalWidgetRun, 1, this.mGroups);
        this.mNeedBuildGraph = false;
    }

    public final void buildGraph(@NotNull ArrayList<WidgetRun> runs) {
        WidgetRun run;
        Intrinsics.checkNotNullParameter(runs, (String)"runs");
        runs.clear();
        HorizontalWidgetRun horizontalWidgetRun = this.mContainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        horizontalWidgetRun.clear();
        VerticalWidgetRun verticalWidgetRun = this.mContainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun);
        verticalWidgetRun.clear();
        HorizontalWidgetRun horizontalWidgetRun2 = this.mContainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
        runs.add(horizontalWidgetRun2);
        VerticalWidgetRun verticalWidgetRun2 = this.mContainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun2);
        runs.add(verticalWidgetRun2);
        HashSet<ChainRun> chainRuns = null;
        Iterator<ConstraintWidget> iterator = this.mContainer.getMChildren().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            boolean bl;
            boolean bl2;
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (widget instanceof Guideline) {
                runs.add(new GuidelineReference(widget));
                continue;
            }
            if (widget.isInHorizontalChain()) {
                if (widget.getHorizontalChainRun() == null) {
                    widget.setHorizontalChainRun(new ChainRun(widget, 0));
                }
                if (chainRuns == null) {
                    chainRuns = new HashSet<ChainRun>();
                }
                ChainRun chainRun = widget.getHorizontalChainRun();
                Intrinsics.checkNotNull((Object)chainRun);
                bl2 = chainRuns.add(chainRun);
            } else {
                HorizontalWidgetRun horizontalWidgetRun3 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                bl2 = runs.add(horizontalWidgetRun3);
            }
            if (widget.isInVerticalChain()) {
                if (widget.getVerticalChainRun() == null) {
                    widget.setVerticalChainRun(new ChainRun(widget, 1));
                }
                if (chainRuns == null) {
                    chainRuns = new HashSet();
                }
                ChainRun chainRun = widget.getVerticalChainRun();
                Intrinsics.checkNotNull((Object)chainRun);
                bl = chainRuns.add(chainRun);
            } else {
                VerticalWidgetRun verticalWidgetRun3 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                bl = runs.add(verticalWidgetRun3);
            }
            if (!(widget instanceof HelperWidget)) continue;
            runs.add(new HelperReferences(widget));
        }
        if (chainRuns != null) {
            runs.addAll((Collection<WidgetRun>)chainRuns);
        }
        Iterator<WidgetRun> iterator3 = runs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            run = (WidgetRun)object;
            run.clear();
        }
        Iterator<WidgetRun> iterator4 = runs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator2 = iterator4;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            run = (WidgetRun)object;
            if (Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mContainer)) continue;
            run.apply();
        }
    }

    private final void displayGraph() {
        Object content = "digraph {\n";
        Iterator<WidgetRun> iterator = this.mRuns.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<WidgetRun> iterator2 = iterator;
        while (iterator2.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            content = this.generateDisplayGraph(run, (String)content);
        }
        content = (String)content + "\n}\n";
        System.out.println((Object)("content:<<\n" + (String)content + "\n>>"));
    }

    private final void applyGroup(DependencyNode node, int orientation, int direction, DependencyNode end, ArrayList<RunGroup> groups, RunGroup group) {
        DependencyNode target;
        Dependency dependent;
        RunGroup group2 = group;
        WidgetRun run = node.getMRun();
        if (run.getMRunGroup() != null || Intrinsics.areEqual((Object)run, (Object)this.mWidgetcontainer.getMHorizontalRun()) || Intrinsics.areEqual((Object)run, (Object)this.mWidgetcontainer.getMVerticalRun())) {
            return;
        }
        if (group2 == null) {
            group2 = new RunGroup(run, direction);
            groups.add(group2);
        }
        run.setMRunGroup(group2);
        group2.add(run);
        Iterator<Dependency> iterator = run.getStart().getMDependencies().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Dependency> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!(dependent instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependent, orientation, 0, end, groups, group2);
        }
        Iterator<Dependency> iterator3 = run.getEnd().getMDependencies().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!(dependent instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependent, orientation, 1, end, groups, group2);
        }
        if (orientation == 1 && run instanceof VerticalWidgetRun) {
            Iterator<Dependency> iterator4 = ((VerticalWidgetRun)run).getBaseline().getMDependencies().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            iterator2 = iterator4;
            while (iterator2.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (!(dependent instanceof DependencyNode)) continue;
                this.applyGroup((DependencyNode)dependent, orientation, 2, end, groups, group2);
            }
        }
        Iterator<DependencyNode> iterator5 = run.getStart().getMTargets().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
        iterator2 = iterator5;
        while (iterator2.hasNext()) {
            Dependency dependency = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"next(...)");
            target = (DependencyNode)dependency;
            if (Intrinsics.areEqual((Object)target, (Object)end)) {
                group2.setDual(true);
            }
            this.applyGroup(target, orientation, 0, end, groups, group2);
        }
        Iterator<DependencyNode> iterator6 = run.getEnd().getMTargets().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator6, (String)"iterator(...)");
        iterator2 = iterator6;
        while (iterator2.hasNext()) {
            Dependency dependency = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"next(...)");
            target = (DependencyNode)dependency;
            if (Intrinsics.areEqual((Object)target, (Object)end)) {
                group2.setDual(true);
            }
            this.applyGroup(target, orientation, 1, end, groups, group2);
        }
        if (orientation == 1 && run instanceof VerticalWidgetRun) {
            Iterator<DependencyNode> iterator7 = ((VerticalWidgetRun)run).getBaseline().getMTargets().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator7, (String)"iterator(...)");
            iterator2 = iterator7;
            while (iterator2.hasNext()) {
                Dependency dependency = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"next(...)");
                target = (DependencyNode)dependency;
                this.applyGroup(target, orientation, 2, end, groups, group2);
            }
        }
    }

    private final void findGroup(WidgetRun run, int orientation, ArrayList<RunGroup> groups) {
        Dependency dependent;
        Iterator<Dependency> iterator = run.getStart().getMDependencies().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Dependency> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (dependent instanceof DependencyNode) {
                this.applyGroup((DependencyNode)dependent, orientation, 0, run.getEnd(), groups, null);
                continue;
            }
            if (!(dependent instanceof WidgetRun)) continue;
            this.applyGroup(((WidgetRun)dependent).getStart(), orientation, 0, run.getEnd(), groups, null);
        }
        Iterator<Dependency> iterator3 = run.getEnd().getMDependencies().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (dependent instanceof DependencyNode) {
                this.applyGroup((DependencyNode)dependent, orientation, 1, run.getStart(), groups, null);
                continue;
            }
            if (!(dependent instanceof WidgetRun)) continue;
            this.applyGroup(((WidgetRun)dependent).getEnd(), orientation, 1, run.getStart(), groups, null);
        }
        if (orientation == 1) {
            Intrinsics.checkNotNull((Object)run, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun");
            Iterator<Dependency> iterator4 = ((VerticalWidgetRun)run).getBaseline().getMDependencies().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            iterator2 = iterator4;
            while (iterator2.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (!(dependent instanceof DependencyNode)) continue;
                this.applyGroup((DependencyNode)dependent, orientation, 2, null, groups, null);
            }
        }
    }

    private final String generateDisplayNode(DependencyNode node, boolean centeredConnection, String content) {
        String content2 = content;
        StringBuilder contentBuilder = new StringBuilder(content2);
        Iterator<DependencyNode> iterator = node.getMTargets().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<DependencyNode> iterator2 = iterator;
        while (iterator2.hasNext()) {
            DependencyNode target;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Object constraint = StringsKt.trimIndent((String)("\n            \n            " + node.name() + "\n            "));
            constraint = (String)constraint + " -> " + target.name();
            if (node.getMMargin() > 0 || centeredConnection || node.getMRun() instanceof HelperReferences) {
                constraint = (String)constraint + "[";
                if (node.getMMargin() > 0) {
                    constraint = (String)constraint + "label=\"" + node.getMMargin() + "\"";
                    if (centeredConnection) {
                        constraint = (String)constraint + ",";
                    }
                }
                if (centeredConnection) {
                    constraint = (String)constraint + " style=dashed ";
                }
                if (node.getMRun() instanceof HelperReferences) {
                    constraint = (String)constraint + " style=bold,color=gray ";
                }
                constraint = (String)constraint + "]";
            }
            constraint = (String)constraint + "\n";
            contentBuilder.append((String)constraint);
        }
        content2 = contentBuilder.toString();
        return content2;
    }

    /*
     * Unable to fully structure code
     */
    private final String nodeDefinition(WidgetRun run) {
        orientation = run instanceof VerticalWidgetRun != false;
        v0 = run.getMWidget();
        Intrinsics.checkNotNull((Object)v0);
        v1 = v0.getDebugName();
        Intrinsics.checkNotNull((Object)v1);
        name = v1;
        definition = new StringBuilder(name);
        if (!orientation) {
            v2 = run.getMWidget();
            Intrinsics.checkNotNull((Object)v2);
            v3 = v2.getHorizontalDimensionBehaviour();
        } else {
            v4 = run.getMWidget();
            Intrinsics.checkNotNull((Object)v4);
            v3 = v4.getVerticalDimensionBehaviour();
        }
        behaviour = v3;
        runGroup = run.getMRunGroup();
        v5 = orientation == false ? definition.append("_HORIZONTAL") : definition.append("_VERTICAL");
        definition.append(" [shape=none, label=<");
        definition.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\">");
        definition.append("  <TR>");
        if (!orientation) {
            definition.append("    <TD ");
            if (run.getStart().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            v6 = definition.append(" PORT=\"LEFT\" BORDER=\"1\">L</TD>");
        } else {
            definition.append("    <TD ");
            if (run.getStart().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            v6 = definition.append(" PORT=\"TOP\" BORDER=\"1\">T</TD>");
        }
        definition.append("    <TD BORDER=\"1\" ");
        if (!run.getMDimension().getResolved()) ** GOTO lbl-1000
        v7 = run.getMWidget();
        Intrinsics.checkNotNull((Object)v7);
        if (!v7.getMeasured()) {
            definition.append(" BGCOLOR=\"green\" ");
        } else if (run.getMDimension().getResolved()) {
            definition.append(" BGCOLOR=\"lightgray\" ");
        } else {
            v8 = run.getMWidget();
            Intrinsics.checkNotNull((Object)v8);
            if (v8.getMeasured()) {
                definition.append(" BGCOLOR=\"yellow\" ");
            }
        }
        if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            definition.append("style=\"dashed\"");
        }
        definition.append(">");
        definition.append(name);
        if (runGroup != null) {
            definition.append(" [");
            definition.append(runGroup.getMGroupIndex() + 1);
            definition.append("/");
            definition.append(RunGroup.Companion.getIndex());
            definition.append("]");
        }
        definition.append(" </TD>");
        if (!orientation) {
            definition.append("    <TD ");
            if (run.getEnd().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            v9 = definition.append(" PORT=\"RIGHT\" BORDER=\"1\">R</TD>");
        } else {
            definition.append("    <TD ");
            Intrinsics.checkNotNull((Object)run, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun");
            if (((VerticalWidgetRun)run).getBaseline().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"BASELINE\" BORDER=\"1\">b</TD>");
            definition.append("    <TD ");
            if (run.getEnd().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            v9 = definition.append(" PORT=\"BOTTOM\" BORDER=\"1\">B</TD>");
        }
        definition.append("  </TR></TABLE>");
        definition.append(">];\n");
        v10 = definition.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"toString(...)");
        return v10;
    }

    private final String generateChainDisplayGraph(ChainRun chain, String content) {
        int orientation = chain.getOrientation();
        StringBuilder subgroup = new StringBuilder("subgraph ");
        subgroup.append("cluster_");
        ConstraintWidget constraintWidget = chain.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        subgroup.append(constraintWidget.getDebugName());
        StringBuilder stringBuilder = orientation == 0 ? subgroup.append("_h") : subgroup.append("_v");
        subgroup.append(" {\n");
        String definitions = "";
        Iterator<WidgetRun> iterator = chain.getMWidgets().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<WidgetRun> iterator2 = iterator;
        while (iterator2.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            ConstraintWidget constraintWidget2 = run.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget2);
            subgroup.append(constraintWidget2.getDebugName());
            StringBuilder stringBuilder2 = orientation == 0 ? subgroup.append("_HORIZONTAL") : subgroup.append("_VERTICAL");
            subgroup.append(";\n");
            definitions = this.generateDisplayGraph(run, definitions);
        }
        subgroup.append("}\n");
        return content + definitions + subgroup;
    }

    private final boolean isCenteredConnection(DependencyNode start, DependencyNode end) {
        int startTargets = 0;
        int endTargets = 0;
        Iterator<DependencyNode> iterator = start.getMTargets().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<DependencyNode> iterator2 = iterator;
        while (iterator2.hasNext()) {
            DependencyNode s;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (Intrinsics.areEqual((Object)s, (Object)end)) continue;
            ++startTargets;
        }
        Iterator<DependencyNode> iterator3 = end.getMTargets().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            DependencyNode e;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (Intrinsics.areEqual((Object)e, (Object)start)) continue;
            ++endTargets;
        }
        return startTargets > 0 && endTargets > 0;
    }

    private final String generateDisplayGraph(WidgetRun root, String content) {
        String string;
        ConstraintWidget.DimensionBehaviour behaviour;
        String content2 = content;
        DependencyNode start = root.getStart();
        DependencyNode end = root.getEnd();
        StringBuilder sb = new StringBuilder(content2);
        if (!(root instanceof HelperReferences) && start.getMDependencies().isEmpty() && end.getMDependencies().isEmpty() && start.getMTargets().isEmpty() && end.getMTargets().isEmpty()) {
            return content2;
        }
        sb.append(this.nodeDefinition(root));
        boolean centeredConnection = this.isCenteredConnection(start, end);
        content2 = this.generateDisplayNode(start, centeredConnection, content2);
        content2 = this.generateDisplayNode(end, centeredConnection, content2);
        if (root instanceof VerticalWidgetRun) {
            DependencyNode baseline = ((VerticalWidgetRun)root).getBaseline();
            content2 = this.generateDisplayNode(baseline, centeredConnection, content2);
        }
        if (root instanceof HorizontalWidgetRun || root instanceof ChainRun && root.getOrientation() == 0) {
            ConstraintWidget constraintWidget = root.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            behaviour = constraintWidget.getHorizontalDimensionBehaviour();
            if (behaviour == ConstraintWidget.DimensionBehaviour.FIXED || behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (!start.getMTargets().isEmpty() && end.getMTargets().isEmpty()) {
                    sb.append("\n");
                    sb.append(end.name());
                    sb.append(" -> ");
                    sb.append(start.name());
                    sb.append("\n");
                } else if (start.getMTargets().isEmpty() && !end.getMTargets().isEmpty()) {
                    sb.append("\n");
                    sb.append(start.name());
                    sb.append(" -> ");
                    sb.append(end.name());
                    sb.append("\n");
                }
            } else if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                ConstraintWidget constraintWidget2 = root.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget2);
                if (constraintWidget2.getDimensionRatio() > 0.0f) {
                    sb.append("\n");
                    ConstraintWidget constraintWidget3 = root.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget3);
                    sb.append(constraintWidget3.getDebugName());
                    sb.append("_HORIZONTAL -> ");
                    ConstraintWidget constraintWidget4 = root.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget4);
                    sb.append(constraintWidget4.getDebugName());
                    sb.append("_VERTICAL;\n");
                }
            }
        } else if (root instanceof VerticalWidgetRun || root instanceof ChainRun && root.getOrientation() == 1) {
            ConstraintWidget constraintWidget = root.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            behaviour = constraintWidget.getVerticalDimensionBehaviour();
            if (behaviour == ConstraintWidget.DimensionBehaviour.FIXED || behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (!start.getMTargets().isEmpty() && end.getMTargets().isEmpty()) {
                    sb.append("\n");
                    sb.append(end.name());
                    sb.append(" -> ");
                    sb.append(start.name());
                    sb.append("\n");
                } else if (start.getMTargets().isEmpty() && !end.getMTargets().isEmpty()) {
                    sb.append("\n");
                    sb.append(start.name());
                    sb.append(" -> ");
                    sb.append(end.name());
                    sb.append("\n");
                }
            } else if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                ConstraintWidget constraintWidget5 = root.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget5);
                if (constraintWidget5.getDimensionRatio() > 0.0f) {
                    sb.append("\n");
                    ConstraintWidget constraintWidget6 = root.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget6);
                    sb.append(constraintWidget6.getDebugName());
                    sb.append("_VERTICAL -> ");
                    ConstraintWidget constraintWidget7 = root.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget7);
                    sb.append(constraintWidget7.getDebugName());
                    sb.append("_HORIZONTAL;\n");
                }
            }
        }
        if (root instanceof ChainRun) {
            string = this.generateChainDisplayGraph((ChainRun)root, content2);
        } else {
            String string2 = sb.toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/DependencyGraph$Companion;", "", "<init>", "()V", "USE_GROUPS", "", "DEBUG", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

