/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0016R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/ChainRun;", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "orientation", "", "<init>", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;I)V", "mWidgets", "Ljava/util/ArrayList;", "getMWidgets", "()Ljava/util/ArrayList;", "setMWidgets", "(Ljava/util/ArrayList;)V", "mChainStyle", "toString", "", "supportsWrapComputation", "", "getWrapDimension", "", "build", "", "clear", "reset", "update", "node", "Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "applyToWidget", "getFirstVisibleWidget", "getLastVisibleWidget", "apply", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChainRun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainRun.kt\nandroidx/constraintlayout/core/widgets/analyzer/ChainRun\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,553:1\n1#2:554\n*E\n"})
public final class ChainRun
extends WidgetRun {
    @NotNull
    private ArrayList<WidgetRun> mWidgets;
    private int mChainStyle;
    public static final int $stable = 8;

    public ChainRun(@NotNull ConstraintWidget widget, int orientation) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        super(widget);
        this.mWidgets = new ArrayList();
        this.setOrientation(orientation);
        this.build();
    }

    @NotNull
    public final ArrayList<WidgetRun> getMWidgets() {
        return this.mWidgets;
    }

    public final void setMWidgets(@NotNull ArrayList<WidgetRun> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mWidgets = arrayList;
    }

    @NotNull
    public String toString() {
        StringBuilder log = new StringBuilder("ChainRun ");
        log.append(this.getOrientation() == 0 ? "horizontal : " : "vertical : ");
        Iterator<WidgetRun> iterator = this.mWidgets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<WidgetRun> iterator2 = iterator;
        while (iterator2.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            log.append("<");
            log.append(run);
            log.append("> ");
        }
        String string = log.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean supportsWrapComputation() {
        int count = this.mWidgets.size();
        for (int i = 0; i < count; ++i) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i), (String)"get(...)");
            if (run.supportsWrapComputation()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getWrapDimension() {
        int count = this.mWidgets.size();
        long wrapDimension = 0L;
        for (int i = 0; i < count; ++i) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i), (String)"get(...)");
            wrapDimension += (long)run.getStart().getMMargin();
            wrapDimension += run.getWrapDimension();
            wrapDimension += (long)run.getEnd().getMMargin();
        }
        return wrapDimension;
    }

    /*
     * Unable to fully structure code
     */
    private final void build() {
        v0 = this.getMWidget();
        Intrinsics.checkNotNull((Object)v0);
        current = v0;
        previous = current.getPreviousChainMember(this.getOrientation());
        while (previous != null) {
            current = previous;
            previous = current.getPreviousChainMember(this.getOrientation());
        }
        this.setMWidget(current);
        v1 = current.getRun(this.getOrientation());
        Intrinsics.checkNotNull((Object)v1);
        this.mWidgets.add(v1);
        next = current.getNextChainMember(this.getOrientation());
        while (next != null) {
            current = next;
            v2 = current.getRun(this.getOrientation());
            Intrinsics.checkNotNull((Object)v2);
            this.mWidgets.add(v2);
            next = current.getNextChainMember(this.getOrientation());
        }
        v3 = this.mWidgets.iterator();
        Intrinsics.checkNotNullExpressionValue(v3, (String)"iterator(...)");
        var4_4 = v3;
        while (var4_4.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)var4_4.next(), (String)"next(...)");
            if (this.getOrientation() == 0) {
                v4 = run.getMWidget();
                Intrinsics.checkNotNull((Object)v4);
                v4.setHorizontalChainRun(this);
                continue;
            }
            if (this.getOrientation() != 1) continue;
            v5 = run.getMWidget();
            Intrinsics.checkNotNull((Object)v5);
            v5.setVerticalChainRun(this);
        }
        if (this.getOrientation() != 0) ** GOTO lbl-1000
        v6 = this.getMWidget();
        Intrinsics.checkNotNull((Object)v6);
        v7 = (ConstraintWidgetContainer)v6.getParent();
        Intrinsics.checkNotNull((Object)v7);
        if (v7.isRtl()) {
            v8 = true;
        } else lbl-1000:
        // 2 sources

        {
            v8 = isInRtl = false;
        }
        if (isInRtl && this.mWidgets.size() > 1) {
            this.setMWidget(this.mWidgets.get(this.mWidgets.size() - 1).getMWidget());
        }
        if (this.getOrientation() == 0) {
            v9 = this.getMWidget();
            Intrinsics.checkNotNull((Object)v9);
            v10 = v9.getHorizontalChainStyle();
        } else {
            v11 = this.getMWidget();
            Intrinsics.checkNotNull((Object)v11);
            v10 = v11.getVerticalChainStyle();
        }
        this.mChainStyle = v10;
    }

    @Override
    public void clear() {
        this.setMRunGroup(null);
        Iterator<WidgetRun> iterator = this.mWidgets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<WidgetRun> iterator2 = iterator;
        while (iterator2.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            run.clear();
        }
    }

    @Override
    public void reset() {
        this.getStart().setResolved(false);
        this.getEnd().setResolved(false);
    }

    @Override
    public void update(@NotNull Dependency node) {
        block76: {
            int gap;
            float bias;
            float f;
            int position;
            int lastVisibleWidget;
            int firstVisibleWidget;
            int count;
            int numMatchConstraints;
            int size;
            int distance;
            boolean isInRtl;
            block77: {
                int dimension;
                int i;
                int numVisibleWidgets;
                block75: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!this.getStart().getResolved() || !this.getEnd().getResolved()) {
                        return;
                    }
                    ConstraintWidget constraintWidget = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget);
                    ConstraintWidget parent = constraintWidget.getParent();
                    isInRtl = false;
                    if (parent instanceof ConstraintWidgetContainer) {
                        isInRtl = ((ConstraintWidgetContainer)parent).isRtl();
                    }
                    distance = this.getEnd().getValue() - this.getStart().getValue();
                    size = 0;
                    numMatchConstraints = 0;
                    float weights = 0.0f;
                    numVisibleWidgets = 0;
                    count = this.mWidgets.size();
                    firstVisibleWidget = -1;
                    for (int i2 = 0; i2 < count; ++i2) {
                        WidgetRun run;
                        Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i2), (String)"get(...)");
                        ConstraintWidget constraintWidget2 = run.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget2);
                        if (constraintWidget2.getVisibility() == 8) continue;
                        firstVisibleWidget = i2;
                        break;
                    }
                    lastVisibleWidget = -1;
                    for (int i3 = count - 1; -1 < i3; --i3) {
                        WidgetRun run;
                        Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i3), (String)"get(...)");
                        ConstraintWidget constraintWidget3 = run.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget3);
                        if (constraintWidget3.getVisibility() == 8) continue;
                        lastVisibleWidget = i3;
                        break;
                    }
                    for (int j = 0; j < 2; ++j) {
                        for (int i4 = 0; i4 < count; ++i4) {
                            boolean treatAsFixed;
                            WidgetRun run;
                            Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i4), (String)"get(...)");
                            ConstraintWidget constraintWidget4 = run.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget4);
                            if (constraintWidget4.getVisibility() == 8) continue;
                            ++numVisibleWidgets;
                            if (i4 > 0 && i4 >= firstVisibleWidget) {
                                size += run.getStart().getMMargin();
                            }
                            int dimension2 = run.getMDimension().getValue();
                            boolean bl = treatAsFixed = run.getMDimensionBehavior() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                            if (treatAsFixed) {
                                if (this.getOrientation() == 0) {
                                    ConstraintWidget constraintWidget5 = run.getMWidget();
                                    Intrinsics.checkNotNull((Object)constraintWidget5);
                                    HorizontalWidgetRun horizontalWidgetRun = constraintWidget5.getMHorizontalRun();
                                    Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                                    if (!horizontalWidgetRun.getMDimension().getResolved()) {
                                        return;
                                    }
                                }
                                if (this.getOrientation() == 1) {
                                    ConstraintWidget constraintWidget6 = run.getMWidget();
                                    Intrinsics.checkNotNull((Object)constraintWidget6);
                                    VerticalWidgetRun verticalWidgetRun = constraintWidget6.getMVerticalRun();
                                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                                    if (!verticalWidgetRun.getMDimension().getResolved()) {
                                        return;
                                    }
                                }
                            } else if (run.getMatchConstraintsType() == 1 && j == 0) {
                                treatAsFixed = true;
                                dimension2 = run.getMDimension().getWrapValue();
                                ++numMatchConstraints;
                            } else if (run.getMDimension().getResolved()) {
                                treatAsFixed = true;
                            }
                            if (!treatAsFixed) {
                                ++numMatchConstraints;
                                ConstraintWidget constraintWidget7 = run.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget7);
                                float weight = constraintWidget7.getMWeight()[this.getOrientation()];
                                if (weight >= 0.0f) {
                                    weights += weight;
                                }
                            } else {
                                size += dimension2;
                            }
                            if (i4 >= count - 1 || i4 >= lastVisibleWidget) continue;
                            size += -run.getEnd().getMMargin();
                        }
                        if (size < distance || numMatchConstraints == 0) break;
                        numVisibleWidgets = 0;
                        numMatchConstraints = 0;
                        size = 0;
                        weights = 0.0f;
                    }
                    position = this.getStart().getValue();
                    if (isInRtl) {
                        position = this.getEnd().getValue();
                    }
                    if (size > distance) {
                        position = isInRtl ? (position += (int)(0.5f + (float)(size - distance) / 2.0f)) : (position -= (int)(0.5f + (float)(size - distance) / 2.0f));
                    }
                    int matchConstraintsDimension = 0;
                    if (numMatchConstraints > 0) {
                        matchConstraintsDimension = (int)(0.5f + (float)(distance - size) / (float)numMatchConstraints);
                        int appliedLimits = 0;
                        for (i = 0; i < count; ++i) {
                            WidgetRun run;
                            Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i), (String)"get(...)");
                            ConstraintWidget constraintWidget8 = run.getMWidget();
                            Intrinsics.checkNotNull((Object)constraintWidget8);
                            if (constraintWidget8.getVisibility() == 8 || run.getMDimensionBehavior() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || run.getMDimension().getResolved()) continue;
                            int dimension3 = matchConstraintsDimension;
                            if (weights > 0.0f) {
                                ConstraintWidget constraintWidget9 = run.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget9);
                                float weight = constraintWidget9.getMWeight()[this.getOrientation()];
                                dimension3 = (int)(0.5f + weight * (float)(distance - size) / weights);
                            }
                            int max = 0;
                            int min = 0;
                            int value = dimension3;
                            if (this.getOrientation() == 0) {
                                ConstraintWidget constraintWidget10 = run.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget10);
                                max = constraintWidget10.getMMatchConstraintMaxWidth();
                                ConstraintWidget constraintWidget11 = run.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget11);
                                min = constraintWidget11.getMMatchConstraintMinWidth();
                            } else {
                                ConstraintWidget constraintWidget12 = run.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget12);
                                max = constraintWidget12.getMMatchConstraintMaxHeight();
                                ConstraintWidget constraintWidget13 = run.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget13);
                                min = constraintWidget13.getMMatchConstraintMinHeight();
                            }
                            if (run.getMatchConstraintsType() == 1) {
                                value = Math.min(value, run.getMDimension().getWrapValue());
                            }
                            value = Math.max(min, value);
                            if (max > 0) {
                                value = Math.min(max, value);
                            }
                            if (value != dimension3) {
                                ++appliedLimits;
                                dimension3 = value;
                            }
                            run.getMDimension().resolve(dimension3);
                        }
                        if (appliedLimits > 0) {
                            numMatchConstraints -= appliedLimits;
                            size = 0;
                            for (i = 0; i < count; ++i) {
                                WidgetRun run;
                                Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i), (String)"get(...)");
                                ConstraintWidget constraintWidget14 = run.getMWidget();
                                Intrinsics.checkNotNull((Object)constraintWidget14);
                                if (constraintWidget14.getVisibility() == 8) continue;
                                if (i > 0 && i >= firstVisibleWidget) {
                                    size += run.getStart().getMMargin();
                                }
                                size += run.getMDimension().getValue();
                                if (i >= count - 1 || i >= lastVisibleWidget) continue;
                                size += -run.getEnd().getMMargin();
                            }
                        }
                        if (this.mChainStyle == 2 && appliedLimits == 0) {
                            this.mChainStyle = 0;
                        }
                    }
                    if (size > distance) {
                        this.mChainStyle = 2;
                    }
                    if (numVisibleWidgets > 0 && numMatchConstraints == 0 && firstVisibleWidget == lastVisibleWidget) {
                        this.mChainStyle = 2;
                    }
                    if (this.mChainStyle != 1) break block75;
                    int gap2 = 0;
                    if (numVisibleWidgets > 1) {
                        gap2 = (distance - size) / (numVisibleWidgets - 1);
                    } else if (numVisibleWidgets == 1) {
                        gap2 = (distance - size) / 2;
                    }
                    if (numMatchConstraints > 0) {
                        gap2 = 0;
                    }
                    for (i = 0; i < count; ++i) {
                        WidgetRun run;
                        int index = i;
                        if (isInRtl) {
                            index = count - (i + 1);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(index), (String)"get(...)");
                        ConstraintWidget constraintWidget15 = run.getMWidget();
                        Intrinsics.checkNotNull((Object)constraintWidget15);
                        if (constraintWidget15.getVisibility() == 8) {
                            run.getStart().resolve(position);
                            run.getEnd().resolve(position);
                            continue;
                        }
                        if (i > 0) {
                            position = isInRtl ? (position -= gap2) : (position += gap2);
                        }
                        if (i > 0 && i >= firstVisibleWidget) {
                            position = isInRtl ? (position -= run.getStart().getMMargin()) : (position += run.getStart().getMMargin());
                        }
                        if (isInRtl) {
                            run.getEnd().resolve(position);
                        } else {
                            run.getStart().resolve(position);
                        }
                        dimension = run.getMDimension().getValue();
                        if (run.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.getMatchConstraintsType() == 1) {
                            dimension = run.getMDimension().getWrapValue();
                        }
                        position = isInRtl ? (position -= dimension) : (position += dimension);
                        if (isInRtl) {
                            run.getStart().resolve(position);
                        } else {
                            run.getEnd().resolve(position);
                        }
                        run.setMResolved(true);
                        if (i >= count - 1 || i >= lastVisibleWidget) continue;
                        if (isInRtl) {
                            position -= -run.getEnd().getMMargin();
                            continue;
                        }
                        position += -run.getEnd().getMMargin();
                    }
                    break block76;
                }
                if (this.mChainStyle != 0) break block77;
                int gap3 = (distance - size) / (numVisibleWidgets + 1);
                if (numMatchConstraints > 0) {
                    gap3 = 0;
                }
                for (i = 0; i < count; ++i) {
                    WidgetRun run;
                    int index = i;
                    if (isInRtl) {
                        index = count - (i + 1);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(index), (String)"get(...)");
                    ConstraintWidget constraintWidget = run.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget);
                    if (constraintWidget.getVisibility() == 8) {
                        run.getStart().resolve(position);
                        run.getEnd().resolve(position);
                        continue;
                    }
                    position = isInRtl ? (position -= gap3) : (position += gap3);
                    if (i > 0 && i >= firstVisibleWidget) {
                        position = isInRtl ? (position -= run.getStart().getMMargin()) : (position += run.getStart().getMMargin());
                    }
                    if (isInRtl) {
                        run.getEnd().resolve(position);
                    } else {
                        run.getStart().resolve(position);
                    }
                    dimension = run.getMDimension().getValue();
                    if (run.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.getMatchConstraintsType() == 1) {
                        dimension = Math.min(dimension, run.getMDimension().getWrapValue());
                    }
                    position = isInRtl ? (position -= dimension) : (position += dimension);
                    if (isInRtl) {
                        run.getStart().resolve(position);
                    } else {
                        run.getEnd().resolve(position);
                    }
                    if (i >= count - 1 || i >= lastVisibleWidget) continue;
                    if (isInRtl) {
                        position -= -run.getEnd().getMMargin();
                        continue;
                    }
                    position += -run.getEnd().getMMargin();
                }
                break block76;
            }
            if (this.mChainStyle != 2) break block76;
            if (this.getOrientation() == 0) {
                ConstraintWidget constraintWidget = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                f = constraintWidget.getHorizontalBiasPercent();
            } else {
                ConstraintWidget constraintWidget = this.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                f = bias = constraintWidget.getVerticalBiasPercent();
            }
            if (isInRtl) {
                bias = 1.0f - bias;
            }
            if ((gap = (int)(0.5f + (float)(distance - size) * bias)) < 0 || numMatchConstraints > 0) {
                gap = 0;
            }
            position = isInRtl ? (position -= gap) : (position += gap);
            for (int i = 0; i < count; ++i) {
                WidgetRun run;
                int index = i;
                if (isInRtl) {
                    index = count - (i + 1);
                }
                Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(index), (String)"get(...)");
                ConstraintWidget constraintWidget = run.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                if (constraintWidget.getVisibility() == 8) {
                    run.getStart().resolve(position);
                    run.getEnd().resolve(position);
                    continue;
                }
                if (i > 0 && i >= firstVisibleWidget) {
                    position = isInRtl ? (position -= run.getStart().getMMargin()) : (position += run.getStart().getMMargin());
                }
                if (isInRtl) {
                    run.getEnd().resolve(position);
                } else {
                    run.getStart().resolve(position);
                }
                int dimension = run.getMDimension().getValue();
                if (run.getMDimensionBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.getMatchConstraintsType() == 1) {
                    dimension = run.getMDimension().getWrapValue();
                }
                position = isInRtl ? (position -= dimension) : (position += dimension);
                if (isInRtl) {
                    run.getStart().resolve(position);
                } else {
                    run.getEnd().resolve(position);
                }
                if (i >= count - 1 || i >= lastVisibleWidget) continue;
                if (isInRtl) {
                    position -= -run.getEnd().getMMargin();
                    continue;
                }
                position += -run.getEnd().getMMargin();
            }
        }
    }

    @Override
    public void applyToWidget() {
        int n = ((Collection)this.mWidgets).size();
        for (int i = 0; i < n; ++i) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i), (String)"get(...)");
            run.applyToWidget();
        }
    }

    private final ConstraintWidget getFirstVisibleWidget() {
        int n = ((Collection)this.mWidgets).size();
        for (int i = 0; i < n; ++i) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i), (String)"get(...)");
            ConstraintWidget constraintWidget = run.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            if (constraintWidget.getVisibility() == 8) continue;
            return run.getMWidget();
        }
        return null;
    }

    private final ConstraintWidget getLastVisibleWidget() {
        int n = ((Collection)this.mWidgets).size() + -1;
        if (0 <= n) {
            do {
                WidgetRun run;
                int i = n--;
                Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i), (String)"get(...)");
                ConstraintWidget constraintWidget = run.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                if (constraintWidget.getVisibility() == 8) continue;
                return run.getMWidget();
            } while (0 <= n);
        }
        return null;
    }

    @Override
    public void apply() {
        Iterator<WidgetRun> iterator = this.mWidgets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<WidgetRun> iterator2 = iterator;
        while (iterator2.hasNext()) {
            WidgetRun run;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            run.apply();
        }
        int count = this.mWidgets.size();
        if (count < 1) {
            return;
        }
        ConstraintWidget firstWidget = this.mWidgets.get(0).getMWidget();
        ConstraintWidget lastWidget = this.mWidgets.get(count - 1).getMWidget();
        if (this.getOrientation() == 0) {
            ConstraintWidget constraintWidget = firstWidget;
            Intrinsics.checkNotNull((Object)constraintWidget);
            ConstraintAnchor startAnchor = constraintWidget.getMLeft();
            ConstraintWidget constraintWidget2 = lastWidget;
            Intrinsics.checkNotNull((Object)constraintWidget2);
            ConstraintAnchor endAnchor = constraintWidget2.getMRight();
            DependencyNode startTarget = this.getTarget(startAnchor, 0);
            int startMargin = 0;
            startMargin = startAnchor.getMargin();
            ConstraintWidget firstVisibleWidget = this.getFirstVisibleWidget();
            if (firstVisibleWidget != null) {
                startMargin = firstVisibleWidget.getMLeft().getMargin();
            }
            DependencyNode dependencyNode = startTarget;
            if (dependencyNode != null) {
                DependencyNode it = dependencyNode;
                boolean bl = false;
                this.addTarget(this.getStart(), it, startMargin);
            }
            DependencyNode endTarget = this.getTarget(endAnchor, 0);
            int endMargin = endAnchor.getMargin();
            ConstraintWidget lastVisibleWidget = this.getLastVisibleWidget();
            if (lastVisibleWidget != null) {
                endMargin = lastVisibleWidget.getMRight().getMargin();
            }
            if (endTarget != null) {
                this.addTarget(this.getEnd(), endTarget, -endMargin);
            }
        } else {
            ConstraintWidget constraintWidget = firstWidget;
            Intrinsics.checkNotNull((Object)constraintWidget);
            ConstraintAnchor startAnchor = constraintWidget.getMTop();
            ConstraintWidget constraintWidget3 = lastWidget;
            Intrinsics.checkNotNull((Object)constraintWidget3);
            ConstraintAnchor endAnchor = constraintWidget3.getMBottom();
            DependencyNode startTarget = this.getTarget(startAnchor, 1);
            int startMargin = 0;
            startMargin = startAnchor.getMargin();
            ConstraintWidget firstVisibleWidget = this.getFirstVisibleWidget();
            if (firstVisibleWidget != null) {
                startMargin = firstVisibleWidget.getMTop().getMargin();
            }
            DependencyNode dependencyNode = startTarget;
            if (dependencyNode != null) {
                DependencyNode it = dependencyNode;
                boolean bl = false;
                this.addTarget(this.getStart(), it, startMargin);
            }
            DependencyNode endTarget = this.getTarget(endAnchor, 1);
            int endMargin = endAnchor.getMargin();
            ConstraintWidget lastVisibleWidget = this.getLastVisibleWidget();
            if (lastVisibleWidget != null) {
                endMargin = lastVisibleWidget.getMBottom().getMargin();
            }
            if (endTarget != null) {
                this.addTarget(this.getEnd(), endTarget, -endMargin);
            }
        }
        this.getStart().setUpdateDelegate(this);
        this.getEnd().setUpdateDelegate(this);
    }
}

