/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Landroidx/constraintlayout/core/widgets/Optimizer;", "", "<init>", "()V", "Companion", "compose"})
@StabilityInferred(parameters=1)
public final class Optimizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    public static final int OPTIMIZATION_NONE = 0;
    public static final int OPTIMIZATION_DIRECT = 1;
    public static final int OPTIMIZATION_BARRIER = 2;
    public static final int OPTIMIZATION_CHAIN = 4;
    public static final int OPTIMIZATION_DIMENSIONS = 8;
    public static final int OPTIMIZATION_RATIO = 16;
    public static final int OPTIMIZATION_GROUPS = 32;
    public static final int OPTIMIZATION_GRAPH = 64;
    public static final int OPTIMIZATION_GRAPH_WRAP = 128;
    public static final int OPTIMIZATION_CACHE_MEASURES = 256;
    public static final int OPTIMIZATION_DEPENDENCY_ORDERING = 512;
    public static final int OPTIMIZATION_GROUPING = 1024;
    public static final int OPTIMIZATION_STANDARD = 257;
    @NotNull
    private static boolean[] sFlags;
    public static final int FLAG_USE_OPTIMIZE = 0;
    public static final int FLAG_CHAIN_DANGLING = 1;
    public static final int FLAG_RECOMPUTE_BOUNDS = 2;

    static {
        sFlags = new boolean[3];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0018\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/constraintlayout/core/widgets/Optimizer$Companion;", "", "<init>", "()V", "OPTIMIZATION_NONE", "", "OPTIMIZATION_DIRECT", "OPTIMIZATION_BARRIER", "OPTIMIZATION_CHAIN", "OPTIMIZATION_DIMENSIONS", "OPTIMIZATION_RATIO", "OPTIMIZATION_GROUPS", "OPTIMIZATION_GRAPH", "OPTIMIZATION_GRAPH_WRAP", "OPTIMIZATION_CACHE_MEASURES", "OPTIMIZATION_DEPENDENCY_ORDERING", "OPTIMIZATION_GROUPING", "OPTIMIZATION_STANDARD", "sFlags", "", "getSFlags", "()[Z", "setSFlags", "([Z)V", "FLAG_USE_OPTIMIZE", "FLAG_CHAIN_DANGLING", "FLAG_RECOMPUTE_BOUNDS", "checkMatchParent", "", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "system", "Landroidx/constraintlayout/core/LinearSystem;", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "enabled", "", "optimizationLevel", "optimization", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final boolean[] getSFlags() {
            return sFlags;
        }

        public final void setSFlags(@NotNull boolean[] blArray) {
            Intrinsics.checkNotNullParameter((Object)blArray, (String)"<set-?>");
            sFlags = blArray;
        }

        public final void checkMatchParent(@NotNull ConstraintWidgetContainer container, @NotNull LinearSystem system, @NotNull ConstraintWidget widget) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
            widget.setMHorizontalResolution(-1);
            widget.setMVerticalResolution(-1);
            if (container.getMListDimensionBehaviors()[0] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int left = widget.getMLeft().getMMargin();
                int right = container.getWidth() - widget.getMRight().getMMargin();
                widget.getMLeft().setMSolverVariable(system.createObjectVariable(widget.getMLeft()));
                widget.getMRight().setMSolverVariable(system.createObjectVariable(widget.getMRight()));
                SolverVariable solverVariable = widget.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                system.addEquality(solverVariable, left);
                SolverVariable solverVariable2 = widget.getMRight().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable2);
                system.addEquality(solverVariable2, right);
                widget.setMHorizontalResolution(2);
                widget.setHorizontalDimension(left, right);
            }
            if (container.getMListDimensionBehaviors()[1] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int top = widget.getMTop().getMMargin();
                int bottom = container.getHeight() - widget.getMBottom().getMMargin();
                widget.getMTop().setMSolverVariable(system.createObjectVariable(widget.getMTop()));
                widget.getMBottom().setMSolverVariable(system.createObjectVariable(widget.getMBottom()));
                SolverVariable solverVariable = widget.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                system.addEquality(solverVariable, top);
                SolverVariable solverVariable3 = widget.getMBottom().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable3);
                system.addEquality(solverVariable3, bottom);
                if (widget.getBaselineDistance() > 0 || widget.getVisibility() == 8) {
                    widget.getMBaseline().setMSolverVariable(system.createObjectVariable(widget.getMBaseline()));
                    SolverVariable solverVariable4 = widget.getMBaseline().getMSolverVariable();
                    Intrinsics.checkNotNull((Object)solverVariable4);
                    system.addEquality(solverVariable4, top + widget.getBaselineDistance());
                }
                widget.setMVerticalResolution(2);
                widget.setVerticalDimension(top, bottom);
            }
        }

        public final boolean enabled(int optimizationLevel, int optimization) {
            return (optimizationLevel & optimization) == optimization;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

