/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.analyzer.Grouping;
import androidx.constraintlayout.core.widgets.analyzer.WidgetGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0016JA\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00012*\u0010\u001a\u001a&\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001cj\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0013H\u0016J7\u0010\u001f\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0#j\b\u0012\u0004\u0012\u00020\"`!2\u0006\u0010$\u001a\u00020\r2\b\u0010%\u001a\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rH\u0016R$\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Landroidx/constraintlayout/core/widgets/HelperWidget;", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "Landroidx/constraintlayout/core/widgets/Helper;", "<init>", "()V", "mWidgets", "", "getMWidgets", "()[Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "setMWidgets", "([Landroidx/constraintlayout/core/widgets/ConstraintWidget;)V", "[Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "mWidgetsCount", "", "getMWidgetsCount", "()I", "setMWidgetsCount", "(I)V", "updateConstraints", "", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "add", "widget", "copy", "src", "map", "Lkotlin/collections/HashMap;", "Ljava/util/HashMap;", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;Ljava/util/HashMap;)V", "removeAllIds", "addDependents", "dependencyLists", "Lkotlin/collections/ArrayList;", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup;", "Ljava/util/ArrayList;", "orientation", "group", "(Ljava/util/ArrayList;ILandroidx/constraintlayout/core/widgets/analyzer/WidgetGroup;)V", "findGroupInDependents", "compose"})
@StabilityInferred(parameters=0)
public class HelperWidget
extends ConstraintWidget
implements Helper {
    @NotNull
    private ConstraintWidget[] mWidgets = new ConstraintWidget[4];
    private int mWidgetsCount;
    public static final int $stable = 8;

    @NotNull
    public final ConstraintWidget[] getMWidgets() {
        return this.mWidgets;
    }

    public final void setMWidgets(@NotNull ConstraintWidget[] constraintWidgetArray) {
        Intrinsics.checkNotNullParameter((Object)constraintWidgetArray, (String)"<set-?>");
        this.mWidgets = constraintWidgetArray;
    }

    public final int getMWidgetsCount() {
        return this.mWidgetsCount;
    }

    public final void setMWidgetsCount(int n) {
        this.mWidgetsCount = n;
    }

    @Override
    public void updateConstraints(@Nullable ConstraintWidgetContainer container) {
    }

    @Override
    public void add(@Nullable ConstraintWidget widget) {
        if (Intrinsics.areEqual((Object)widget, (Object)this) || widget == null) {
            return;
        }
        if (this.mWidgetsCount + 1 > this.mWidgets.length) {
            ConstraintWidget[] constraintWidgetArray = Arrays.copyOf(this.mWidgets, this.mWidgets.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)constraintWidgetArray, (String)"copyOf(...)");
            this.mWidgets = constraintWidgetArray;
        }
        this.mWidgets[this.mWidgetsCount] = widget;
        int n = this.mWidgetsCount;
        this.mWidgetsCount = n + 1;
    }

    @Override
    public void copy(@NotNull ConstraintWidget src, @NotNull HashMap<ConstraintWidget, ConstraintWidget> map) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        super.copy(src, map);
        HelperWidget srcHelper = (HelperWidget)src;
        this.mWidgetsCount = 0;
        int count = srcHelper.mWidgetsCount;
        for (int i = 0; i < count; ++i) {
            this.add(map.get(srcHelper.mWidgets[i]));
        }
    }

    @Override
    public void removeAllIds() {
        this.mWidgetsCount = 0;
        ArraysKt.fill$default((Object[])this.mWidgets, null, (int)0, (int)0, (int)6, null);
    }

    public void addDependents(@NotNull ArrayList<WidgetGroup> dependencyLists, int orientation, @Nullable WidgetGroup group) {
        ConstraintWidget widget;
        int i;
        Intrinsics.checkNotNullParameter(dependencyLists, (String)"dependencyLists");
        int n = this.mWidgetsCount;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mWidgets[i]);
            WidgetGroup widgetGroup = group;
            Intrinsics.checkNotNull((Object)widgetGroup);
            widgetGroup.add(widget);
        }
        n = this.mWidgetsCount;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mWidgets[i]);
            Grouping.Companion.findDependents(widget, orientation, dependencyLists, group);
        }
    }

    public int findGroupInDependents(int orientation) {
        int n = this.mWidgetsCount;
        for (int i = 0; i < n; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNull((Object)this.mWidgets[i]);
            if (orientation == 0 && widget.getHorizontalGroup() != -1) {
                return widget.getHorizontalGroup();
            }
            if (orientation != 1 || widget.getVerticalGroup() == -1) continue;
            return widget.getVerticalGroup();
        }
        return -1;
    }
}

