/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 K2\u00020\u0001:\u0001KB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00012*\u0010!\u001a&\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010#j\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\"H\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0014H\u0016J\u0006\u0010&\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u000bJ\u0006\u0010)\u001a\u00020\u001aJ\u000e\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u000bJ\u0006\u00103\u001a\u00020\u000bJ\u0012\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u000bJ\u000e\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u0005J\u000e\u00108\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u000bJ\u000e\u00109\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u000bJ\u0006\u0010:\u001a\u00020\u0005J\u0006\u0010;\u001a\u00020\u000bJ\u0006\u0010<\u001a\u00020\u000bJ\u000e\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\u000bJ\u0018\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0014H\u0016J\u0018\u0010E\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0014H\u0016J\u0006\u0010F\u001a\u00020\u001fJ\u0006\u0010G\u001a\u00020\u001fJ\u0006\u0010H\u001a\u00020\u001fJ\u0006\u0010I\u001a\u00020\u001fJ\u0006\u0010J\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u0010(\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\rR\u0014\u0010?\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0016R\u0014\u0010@\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0016\u00a8\u0006L"}, d2={"Landroidx/constraintlayout/core/widgets/Guideline;", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "<init>", "()V", "mRelativePercent", "", "getMRelativePercent", "()F", "setMRelativePercent", "(F)V", "mRelativeBegin", "", "getMRelativeBegin", "()I", "setMRelativeBegin", "(I)V", "mRelativeEnd", "getMRelativeEnd", "setMRelativeEnd", "mGuidelineUseRtl", "", "getMGuidelineUseRtl", "()Z", "setMGuidelineUseRtl", "(Z)V", "mAnchor", "Landroidx/constraintlayout/core/widgets/ConstraintAnchor;", "mOrientation", "mMinimumPosition", "mResolved", "copy", "", "src", "map", "Lkotlin/collections/HashMap;", "Ljava/util/HashMap;", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;Ljava/util/HashMap;)V", "allowedInBarrier", "getRelativeBehaviour", "setOrientation", "orientation", "getAnchor", "type", "", "getType", "()Ljava/lang/String;", "setType", "(Ljava/lang/String;)V", "getOrientation", "setMinimumPosition", "minimum", "getMinimumPosition", "anchorType", "Landroidx/constraintlayout/core/widgets/ConstraintAnchor$Type;", "setGuidePercent", "value", "setGuideBegin", "setGuideEnd", "getRelativePercent", "getRelativeBegin", "getRelativeEnd", "setFinalValue", "position", "isResolvedHorizontally", "isResolvedVertically", "addToSolver", "system", "Landroidx/constraintlayout/core/LinearSystem;", "optimize", "updateFromSolver", "inferRelativePercentPosition", "inferRelativeBeginPosition", "inferRelativeEndPosition", "cyclePosition", "isPercent", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class Guideline
extends ConstraintWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float mRelativePercent = -1.0f;
    private int mRelativeBegin = -1;
    private int mRelativeEnd = -1;
    private boolean mGuidelineUseRtl = true;
    @NotNull
    private ConstraintAnchor mAnchor = this.getMTop();
    private int mOrientation;
    private int mMinimumPosition;
    private boolean mResolved;
    @Nullable
    private String type = "Guideline";
    public static final int $stable = 8;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int RELATIVE_PERCENT = 0;
    public static final int RELATIVE_BEGIN = 1;
    public static final int RELATIVE_END = 2;
    public static final int RELATIVE_UNKNOWN = -1;

    protected final float getMRelativePercent() {
        return this.mRelativePercent;
    }

    protected final void setMRelativePercent(float f) {
        this.mRelativePercent = f;
    }

    protected final int getMRelativeBegin() {
        return this.mRelativeBegin;
    }

    protected final void setMRelativeBegin(int n) {
        this.mRelativeBegin = n;
    }

    protected final int getMRelativeEnd() {
        return this.mRelativeEnd;
    }

    protected final void setMRelativeEnd(int n) {
        this.mRelativeEnd = n;
    }

    protected final boolean getMGuidelineUseRtl() {
        return this.mGuidelineUseRtl;
    }

    protected final void setMGuidelineUseRtl(boolean bl) {
        this.mGuidelineUseRtl = bl;
    }

    public Guideline() {
        this.getMAnchors().clear();
        this.getMAnchors().add(this.mAnchor);
        int count = this.getMListAnchors().length;
        for (int i = 0; i < count; ++i) {
            this.getMListAnchors()[i] = this.mAnchor;
        }
    }

    @Override
    public void copy(@NotNull ConstraintWidget src, @NotNull HashMap<ConstraintWidget, ConstraintWidget> map) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        super.copy(src, map);
        Guideline srcGuideline = (Guideline)src;
        this.mRelativePercent = srcGuideline.mRelativePercent;
        this.mRelativeBegin = srcGuideline.mRelativeBegin;
        this.mRelativeEnd = srcGuideline.mRelativeEnd;
        this.mGuidelineUseRtl = srcGuideline.mGuidelineUseRtl;
        this.setOrientation(srcGuideline.mOrientation);
    }

    @Override
    public boolean allowedInBarrier() {
        return true;
    }

    public final int getRelativeBehaviour() {
        if (!(this.mRelativePercent == -1.0f)) {
            return 0;
        }
        if (this.mRelativeBegin != -1) {
            return 1;
        }
        return this.mRelativeEnd != -1 ? 2 : -1;
    }

    public final void setOrientation(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.getMAnchors().clear();
        this.mAnchor = this.mOrientation == 1 ? this.getMLeft() : this.getMTop();
        this.getMAnchors().add(this.mAnchor);
        int count = this.getMListAnchors().length;
        for (int i = 0; i < count; ++i) {
            this.getMListAnchors()[i] = this.mAnchor;
        }
    }

    @NotNull
    public final ConstraintAnchor getAnchor() {
        return this.mAnchor;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(@Nullable String string) {
        this.type = string;
    }

    public final int getOrientation() {
        return this.mOrientation;
    }

    public final void setMinimumPosition(int minimum) {
        this.mMinimumPosition = minimum;
    }

    public final int getMinimumPosition() {
        return this.mMinimumPosition;
    }

    @Override
    @Nullable
    public ConstraintAnchor getAnchor(@NotNull ConstraintAnchor.Type anchorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)anchorType), (String)"anchorType");
        switch (WhenMappings.$EnumSwitchMapping$0[anchorType.ordinal()]) {
            case 1: 
            case 2: {
                if (this.mOrientation != 1) break;
                return this.mAnchor;
            }
            case 3: 
            case 4: {
                if (this.mOrientation != 0) break;
                return this.mAnchor;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }

    public final void setGuidePercent(int value) {
        this.setGuidePercent((float)value / 100.0f);
    }

    public final void setGuidePercent(float value) {
        if (value > -1.0f) {
            this.mRelativePercent = value;
            this.mRelativeBegin = -1;
            this.mRelativeEnd = -1;
        }
    }

    public final void setGuideBegin(int value) {
        if (value > -1) {
            this.mRelativePercent = -1.0f;
            this.mRelativeBegin = value;
            this.mRelativeEnd = -1;
        }
    }

    public final void setGuideEnd(int value) {
        if (value > -1) {
            this.mRelativePercent = -1.0f;
            this.mRelativeBegin = -1;
            this.mRelativeEnd = value;
        }
    }

    public final float getRelativePercent() {
        return this.mRelativePercent;
    }

    public final int getRelativeBegin() {
        return this.mRelativeBegin;
    }

    public final int getRelativeEnd() {
        return this.mRelativeEnd;
    }

    public final void setFinalValue(int position) {
        this.mAnchor.setFinalValue(position);
        this.mResolved = true;
    }

    @Override
    public boolean isResolvedHorizontally() {
        return this.mResolved;
    }

    @Override
    public boolean isResolvedVertically() {
        return this.mResolved;
    }

    @Override
    public void addToSolver(@NotNull LinearSystem system, boolean optimize) {
        boolean parentWrapContent;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        ConstraintWidgetContainer constraintWidgetContainer = (ConstraintWidgetContainer)this.getParent();
        if (constraintWidgetContainer == null) {
            return;
        }
        ConstraintWidgetContainer parent = constraintWidgetContainer;
        ConstraintAnchor begin = parent.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor end = parent.getAnchor(ConstraintAnchor.Type.RIGHT);
        if (this.getParent() != null) {
            ConstraintWidget constraintWidget = this.getParent();
            Intrinsics.checkNotNull((Object)constraintWidget);
            bl = constraintWidget.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        } else {
            bl = parentWrapContent = false;
        }
        if (this.mOrientation == 0) {
            boolean bl2;
            begin = parent.getAnchor(ConstraintAnchor.Type.TOP);
            end = parent.getAnchor(ConstraintAnchor.Type.BOTTOM);
            if (this.getParent() != null) {
                ConstraintWidget constraintWidget = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget);
                bl2 = constraintWidget.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            } else {
                bl2 = parentWrapContent = false;
            }
        }
        if (this.mResolved && this.mAnchor.hasFinalValue()) {
            SolverVariable guide = system.createObjectVariable(this.mAnchor);
            SolverVariable solverVariable = guide;
            Intrinsics.checkNotNull((Object)solverVariable);
            system.addEquality(solverVariable, this.mAnchor.getFinalValue());
            if (this.mRelativeBegin != -1) {
                if (parentWrapContent) {
                    SolverVariable solverVariable2 = system.createObjectVariable(end);
                    Intrinsics.checkNotNull((Object)solverVariable2);
                    system.addGreaterThan(solverVariable2, guide, 0, 5);
                }
            } else if (this.mRelativeEnd != -1 && parentWrapContent) {
                SolverVariable parentRight = system.createObjectVariable(end);
                SolverVariable solverVariable3 = system.createObjectVariable(begin);
                Intrinsics.checkNotNull((Object)solverVariable3);
                system.addGreaterThan(guide, solverVariable3, 0, 5);
                SolverVariable solverVariable4 = parentRight;
                Intrinsics.checkNotNull((Object)solverVariable4);
                system.addGreaterThan(solverVariable4, guide, 0, 5);
            }
            this.mResolved = false;
            return;
        }
        if (this.mRelativeBegin != -1) {
            SolverVariable guide = system.createObjectVariable(this.mAnchor);
            SolverVariable parentLeft = system.createObjectVariable(begin);
            SolverVariable solverVariable = guide;
            Intrinsics.checkNotNull((Object)solverVariable);
            SolverVariable solverVariable5 = parentLeft;
            Intrinsics.checkNotNull((Object)solverVariable5);
            system.addEquality(solverVariable, solverVariable5, this.mRelativeBegin, 8);
            if (parentWrapContent) {
                SolverVariable solverVariable6 = system.createObjectVariable(end);
                Intrinsics.checkNotNull((Object)solverVariable6);
                system.addGreaterThan(solverVariable6, guide, 0, 5);
            }
        } else if (this.mRelativeEnd != -1) {
            SolverVariable guide = system.createObjectVariable(this.mAnchor);
            SolverVariable parentRight = system.createObjectVariable(end);
            SolverVariable solverVariable = guide;
            Intrinsics.checkNotNull((Object)solverVariable);
            SolverVariable solverVariable7 = parentRight;
            Intrinsics.checkNotNull((Object)solverVariable7);
            system.addEquality(solverVariable, solverVariable7, -this.mRelativeEnd, 8);
            if (parentWrapContent) {
                SolverVariable solverVariable8 = system.createObjectVariable(begin);
                Intrinsics.checkNotNull((Object)solverVariable8);
                system.addGreaterThan(guide, solverVariable8, 0, 5);
                system.addGreaterThan(parentRight, guide, 0, 5);
            }
        } else if (!(this.mRelativePercent == -1.0f)) {
            SolverVariable guide = system.createObjectVariable(this.mAnchor);
            SolverVariable parentRight = system.createObjectVariable(end);
            SolverVariable solverVariable = guide;
            Intrinsics.checkNotNull((Object)solverVariable);
            SolverVariable solverVariable9 = parentRight;
            Intrinsics.checkNotNull((Object)solverVariable9);
            system.addConstraint(LinearSystem.Companion.createRowDimensionPercent(system, solverVariable, solverVariable9, this.mRelativePercent));
        }
    }

    @Override
    public void updateFromSolver(@NotNull LinearSystem system, boolean optimize) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        if (this.getParent() == null) {
            return;
        }
        int value = system.getObjectVariableValue(this.mAnchor);
        if (this.mOrientation == 1) {
            this.setX(value);
            this.setY(0);
            ConstraintWidget constraintWidget = this.getParent();
            Intrinsics.checkNotNull((Object)constraintWidget);
            this.setHeight(constraintWidget.getHeight());
            this.setWidth(0);
        } else {
            this.setX(0);
            this.setY(value);
            ConstraintWidget constraintWidget = this.getParent();
            Intrinsics.checkNotNull((Object)constraintWidget);
            this.setWidth(constraintWidget.getWidth());
            this.setHeight(0);
        }
    }

    public final void inferRelativePercentPosition() {
        float f = this.getX();
        ConstraintWidget constraintWidget = this.getParent();
        Intrinsics.checkNotNull((Object)constraintWidget);
        float percent = f / (float)constraintWidget.getWidth();
        if (this.mOrientation == 0) {
            float f2 = this.getY();
            ConstraintWidget constraintWidget2 = this.getParent();
            Intrinsics.checkNotNull((Object)constraintWidget2);
            percent = f2 / (float)constraintWidget2.getHeight();
        }
        this.setGuidePercent(percent);
    }

    public final void inferRelativeBeginPosition() {
        int position = this.getX();
        if (this.mOrientation == 0) {
            position = this.getY();
        }
        this.setGuideBegin(position);
    }

    public final void inferRelativeEndPosition() {
        ConstraintWidget constraintWidget = this.getParent();
        Intrinsics.checkNotNull((Object)constraintWidget);
        int position = constraintWidget.getWidth() - this.getX();
        if (this.mOrientation == 0) {
            ConstraintWidget constraintWidget2 = this.getParent();
            Intrinsics.checkNotNull((Object)constraintWidget2);
            position = constraintWidget2.getHeight() - this.getY();
        }
        this.setGuideEnd(position);
    }

    public final void cyclePosition() {
        if (this.mRelativeBegin != -1) {
            this.inferRelativePercentPosition();
        } else if (!(this.mRelativePercent == -1.0f)) {
            this.inferRelativeEndPosition();
        } else if (this.mRelativeEnd != -1) {
            this.inferRelativeBeginPosition();
        }
    }

    public final boolean isPercent() {
        return !(this.mRelativePercent == -1.0f) && this.mRelativeBegin == -1 && this.mRelativeEnd == -1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/constraintlayout/core/widgets/Guideline$Companion;", "", "<init>", "()V", "HORIZONTAL", "", "VERTICAL", "RELATIVE_PERCENT", "RELATIVE_BEGIN", "RELATIVE_END", "RELATIVE_UNKNOWN", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintAnchor.Type.values().length];
            try {
                nArray[ConstraintAnchor.Type.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.BASELINE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.CENTER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.CENTER_X.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.CENTER_Y.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintAnchor.Type.NONE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

