/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.Dimension;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.Reference;
import androidx.constraintlayout.core.state.helpers.AlignHorizontallyReference;
import androidx.constraintlayout.core.state.helpers.AlignVerticallyReference;
import androidx.constraintlayout.core.state.helpers.BarrierReference;
import androidx.constraintlayout.core.state.helpers.FlowReference;
import androidx.constraintlayout.core.state.helpers.GridReference;
import androidx.constraintlayout.core.state.helpers.GuidelineReference;
import androidx.constraintlayout.core.state.helpers.HorizontalChainReference;
import androidx.constraintlayout.core.state.helpers.VerticalChainReference;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.HelperWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0017\u0018\u0000 {2\u00020\u0001:\u0006vwxyz{B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0007H\u0007J\b\u0010!\u001a\u00020\u0007H\u0007J\u0006\u0010'\u001a\u00020\u001eJ\u0012\u0010(\u001a\u00020)2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010*\u001a\u00020\u00192\b\u0010+\u001a\u0004\u0018\u00010\u0001J\u000e\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020)J\u000e\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020)J\u000e\u0010-\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u00103\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u0012\u00104\u001a\u0004\u0018\u00010\n2\b\u0010+\u001a\u0004\u0018\u00010\u0001J\u0012\u00105\u001a\u0004\u0018\u00010\u00192\b\u0010+\u001a\u0004\u0018\u00010\u0001J\b\u00107\u001a\u00020\u0014H\u0002J\u001a\u00108\u001a\u00020\u00102\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\u00109\u001a\u0004\u0018\u00010:J\u0012\u0010;\u001a\u0004\u0018\u00010<2\b\u0010+\u001a\u0004\u0018\u00010\u0001J\u0012\u0010=\u001a\u0004\u0018\u00010<2\b\u0010+\u001a\u0004\u0018\u00010\u0001J\u001a\u0010>\u001a\u0004\u0018\u00010<2\b\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010?\u001a\u00020)J\u001a\u0010@\u001a\u0004\u0018\u00010A2\b\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010B\u001a\u00020CJ\u0018\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010F\u001a\u00020\u0014J\u001a\u0010G\u001a\u0004\u0018\u00010H2\b\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020\u0007J\u0006\u0010J\u001a\u00020KJ#\u0010J\u001a\u00020K2\u0016\u0010L\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010M\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010NJ\u0006\u0010O\u001a\u00020PJ#\u0010O\u001a\u00020P2\u0016\u0010L\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010M\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010QJ\u0006\u0010R\u001a\u00020HJ#\u0010R\u001a\u00020H2\u0016\u0010L\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010M\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010SJ\u0006\u0010T\u001a\u00020HJ#\u0010T\u001a\u00020H2\u0016\u0010L\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010M\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010SJ#\u0010U\u001a\u00020V2\u0016\u0010L\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010M\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010WJ#\u0010X\u001a\u00020Y2\u0016\u0010L\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010M\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010ZJ\u0006\u0010[\u001a\u00020\u001eJ\u0018\u0010\\\u001a\u00020\u001e2\b\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010]\u001a\u00020\u0001J\u0016\u0010^\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010_\u001a\u00020\u0014J)\u0010`\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0015j\n\u0012\u0004\u0012\u00020\u0014\u0018\u0001`a2\b\u0010_\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010bJ\u000e\u0010c\u001a\u00020\u001e2\u0006\u0010d\u001a\u00020eJ\u000e\u0010r\u001a\u00020\u001e2\u0006\u0010s\u001a\u00020\u0001J\u0010\u0010t\u001a\u00020\u00072\b\u0010u\u001a\u0004\u0018\u00010lR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR,\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00150\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR$\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u00106\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR \u0010k\u001a\b\u0012\u0004\u0012\u00020l0\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010h\"\u0004\bn\u0010jR\u001a\u0010o\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010$\"\u0004\bq\u0010&\u00a8\u0006|"}, d2={"Landroidx/constraintlayout/core/state/State;", "", "<init>", "()V", "mDpToPixel", "Landroidx/constraintlayout/core/state/CorePixelDp;", "mIsLtr", "", "mReferences", "Ljava/util/HashMap;", "Landroidx/constraintlayout/core/state/Reference;", "getMReferences", "()Ljava/util/HashMap;", "setMReferences", "(Ljava/util/HashMap;)V", "mHelperReferences", "Landroidx/constraintlayout/core/state/HelperReference;", "getMHelperReferences", "setMHelperReferences", "mTags", "", "Ljava/util/ArrayList;", "getMTags", "setMTags", "mParent", "Landroidx/constraintlayout/core/state/ConstraintReference;", "getMParent", "()Landroidx/constraintlayout/core/state/ConstraintReference;", "getDpToPixel", "setDpToPixel", "", "dpToPixel", "setLtr", "isLtr", "value", "isRtl", "()Z", "setRtl", "(Z)V", "reset", "convertDimension", "", "createConstraintReference", "key", "sameFixedWidth", "width", "sameFixedHeight", "height", "dimension", "Landroidx/constraintlayout/core/state/Dimension;", "setWidth", "setHeight", "reference", "constraints", "mNumHelpers", "createHelperKey", "helper", "type", "Landroidx/constraintlayout/core/state/State$Helper;", "horizontalGuideline", "Landroidx/constraintlayout/core/state/helpers/GuidelineReference;", "verticalGuideline", "guideline", "orientation", "barrier", "Landroidx/constraintlayout/core/state/helpers/BarrierReference;", "direction", "Landroidx/constraintlayout/core/state/State$Direction;", "getGrid", "Landroidx/constraintlayout/core/state/helpers/GridReference;", "gridType", "getFlow", "Landroidx/constraintlayout/core/state/helpers/FlowReference;", "vertical", "verticalChain", "Landroidx/constraintlayout/core/state/helpers/VerticalChainReference;", "references", "", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/VerticalChainReference;", "horizontalChain", "Landroidx/constraintlayout/core/state/helpers/HorizontalChainReference;", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/HorizontalChainReference;", "getVerticalFlow", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/FlowReference;", "getHorizontalFlow", "centerHorizontally", "Landroidx/constraintlayout/core/state/helpers/AlignHorizontallyReference;", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/AlignHorizontallyReference;", "centerVertically", "Landroidx/constraintlayout/core/state/helpers/AlignVerticallyReference;", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/AlignVerticallyReference;", "directMapping", "map", "view", "setTag", "tag", "getIdsForTag", "Lkotlin/collections/ArrayList;", "(Ljava/lang/String;)Ljava/util/ArrayList;", "apply", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "mBaselineNeeded", "getMBaselineNeeded", "()Ljava/util/ArrayList;", "setMBaselineNeeded", "(Ljava/util/ArrayList;)V", "mBaselineNeededWidgets", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "getMBaselineNeededWidgets", "setMBaselineNeededWidgets", "mDirtyBaselineNeededWidgets", "getMDirtyBaselineNeededWidgets", "setMDirtyBaselineNeededWidgets", "baselineNeededFor", "id", "isBaselineNeeded", "constraintWidget", "Constraint", "Direction", "Helper", "Chain", "Wrap", "Companion", "compose"})
@StabilityInferred(parameters=0)
public class State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CorePixelDp mDpToPixel;
    private boolean mIsLtr = true;
    @NotNull
    private HashMap<Object, Reference> mReferences = new HashMap();
    @NotNull
    private HashMap<Object, HelperReference> mHelperReferences = new HashMap();
    @NotNull
    private HashMap<String, ArrayList<String>> mTags = new HashMap();
    @NotNull
    private final ConstraintReference mParent = new ConstraintReference(this);
    private int mNumHelpers;
    @NotNull
    private ArrayList<Object> mBaselineNeeded = new ArrayList();
    @NotNull
    private ArrayList<ConstraintWidget> mBaselineNeededWidgets = new ArrayList();
    private boolean mDirtyBaselineNeededWidgets = true;
    public static final int $stable = 8;
    public static final int UNKNOWN = -1;
    public static final int CONSTRAINT_SPREAD = 0;
    public static final int CONSTRAINT_WRAP = 1;
    public static final int CONSTRAINT_RATIO = 2;
    public static final int PARENT = 0;

    @NotNull
    protected final HashMap<Object, Reference> getMReferences() {
        return this.mReferences;
    }

    protected final void setMReferences(@NotNull HashMap<Object, Reference> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.mReferences = hashMap;
    }

    @NotNull
    protected final HashMap<Object, HelperReference> getMHelperReferences() {
        return this.mHelperReferences;
    }

    protected final void setMHelperReferences(@NotNull HashMap<Object, HelperReference> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.mHelperReferences = hashMap;
    }

    @NotNull
    public final HashMap<String, ArrayList<String>> getMTags() {
        return this.mTags;
    }

    public final void setMTags(@NotNull HashMap<String, ArrayList<String>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.mTags = hashMap;
    }

    @NotNull
    public final ConstraintReference getMParent() {
        return this.mParent;
    }

    public State() {
        this.mParent.setKey(0);
        ((Map)this.mReferences).put(0, this.mParent);
    }

    @Nullable
    public final CorePixelDp getDpToPixel() {
        return this.mDpToPixel;
    }

    public final void setDpToPixel(@Nullable CorePixelDp dpToPixel) {
        this.mDpToPixel = dpToPixel;
    }

    @Deprecated(message="For consistency, use {@link #setRtl(boolean)} instead.")
    public final void setLtr(boolean isLtr) {
        this.mIsLtr = isLtr;
    }

    @Deprecated(message="For consistency, use {@link #isRtl()} instead.")
    public final boolean isLtr() {
        return this.mIsLtr;
    }

    public final boolean isRtl() {
        return !this.mIsLtr;
    }

    public final void setRtl(boolean value) {
        this.mIsLtr = !value;
    }

    public final void reset() {
        Iterator<Object> iterator = this.mReferences.keySet().iterator();
        while (iterator.hasNext()) {
            Object ref;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Reference reference = this.mReferences.get(ref);
            Intrinsics.checkNotNull((Object)reference);
            ConstraintWidget constraintWidget = reference.getConstraintWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            constraintWidget.reset();
        }
        this.mReferences.clear();
        ((Map)this.mReferences).put(0, this.mParent);
        this.mHelperReferences.clear();
        this.mTags.clear();
        this.mBaselineNeeded.clear();
        this.mDirtyBaselineNeededWidgets = true;
    }

    public int convertDimension(@Nullable Object value) {
        if (value instanceof Float) {
            return MathKt.roundToInt((float)((Number)value).floatValue());
        }
        return value instanceof Integer ? ((Number)value).intValue() : 0;
    }

    @NotNull
    public final ConstraintReference createConstraintReference(@Nullable Object key) {
        return new ConstraintReference(this);
    }

    public final boolean sameFixedWidth(int width) {
        return this.mParent.getWidth().equalsFixedValue(width);
    }

    public final boolean sameFixedHeight(int height) {
        return this.mParent.getHeight().equalsFixedValue(height);
    }

    @NotNull
    public final State width(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this.setWidth(dimension);
    }

    @NotNull
    public final State height(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this.setHeight(dimension);
    }

    @NotNull
    public final State setWidth(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.mParent.setWidth(dimension);
        return this;
    }

    @NotNull
    public final State setHeight(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.mParent.setHeight(dimension);
        return this;
    }

    @Nullable
    public final Reference reference(@Nullable Object key) {
        return (Reference)((Map)this.mReferences).get(key);
    }

    @Nullable
    public final ConstraintReference constraints(@Nullable Object key) {
        Reference reference = (Reference)((Map)this.mReferences).get(key);
        if (reference == null) {
            reference = this.createConstraintReference(key);
            Map map = this.mReferences;
            Object object = key;
            Intrinsics.checkNotNull((Object)object);
            map.put(object, reference);
            ((ConstraintReference)reference).setKey(key);
        }
        return reference instanceof ConstraintReference ? (ConstraintReference)reference : null;
    }

    private final String createHelperKey() {
        int n = this.mNumHelpers;
        this.mNumHelpers = n + 1;
        return "__HELPER_KEY_" + n + "__";
    }

    @NotNull
    public final HelperReference helper(@Nullable Object key, @Nullable Helper type) {
        HelperReference reference;
        Object key2 = key;
        if (key2 == null) {
            key2 = this.createHelperKey();
        }
        if ((reference = this.mHelperReferences.get(key2)) == null) {
            Helper helper = type;
            switch (helper == null ? -1 : WhenMappings.$EnumSwitchMapping$0[helper.ordinal()]) {
                case 1: {
                    reference = new HorizontalChainReference(this);
                    break;
                }
                case 2: {
                    reference = new VerticalChainReference(this);
                    break;
                }
                case 3: {
                    reference = new AlignHorizontallyReference(this);
                    break;
                }
                case 4: {
                    reference = new AlignVerticallyReference(this);
                    break;
                }
                case 5: {
                    reference = new BarrierReference(this);
                    break;
                }
                case 6: 
                case 7: {
                    reference = new FlowReference(this, type);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    reference = new GridReference(this, type);
                    break;
                }
                default: {
                    Helper helper2 = type;
                    Intrinsics.checkNotNull((Object)((Object)helper2));
                    reference = new HelperReference(this, helper2);
                }
            }
            reference.setKey(key2);
            ((Map)this.mHelperReferences).put(key2, reference);
        }
        return reference;
    }

    @Nullable
    public final GuidelineReference horizontalGuideline(@Nullable Object key) {
        return this.guideline(key, 0);
    }

    @Nullable
    public final GuidelineReference verticalGuideline(@Nullable Object key) {
        return this.guideline(key, 1);
    }

    @Nullable
    public final GuidelineReference guideline(@Nullable Object key, int orientation) {
        ConstraintReference reference;
        ConstraintReference constraintReference = reference = this.constraints(key);
        if ((constraintReference != null ? constraintReference.getFacade() : null) == null || !(reference.getFacade() instanceof GuidelineReference)) {
            GuidelineReference guidelineReference = new GuidelineReference(this);
            guidelineReference.setOrientation(orientation);
            guidelineReference.setKey(key);
            ConstraintReference constraintReference2 = reference;
            if (constraintReference2 != null) {
                constraintReference2.setFacade(guidelineReference);
            }
        }
        ConstraintReference constraintReference3 = reference;
        return (GuidelineReference)(constraintReference3 != null ? constraintReference3.getFacade() : null);
    }

    @Nullable
    public final BarrierReference barrier(@Nullable Object key, @NotNull Direction direction) {
        ConstraintReference reference;
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        ConstraintReference constraintReference = reference = this.constraints(key);
        if ((constraintReference != null ? constraintReference.getFacade() : null) == null || !(reference.getFacade() instanceof BarrierReference)) {
            BarrierReference barrierReference = new BarrierReference(this);
            barrierReference.setBarrierDirection(direction);
            ConstraintReference constraintReference2 = reference;
            if (constraintReference2 != null) {
                constraintReference2.setFacade(barrierReference);
            }
        }
        ConstraintReference constraintReference3 = reference;
        return (BarrierReference)(constraintReference3 != null ? constraintReference3.getFacade() : null);
    }

    @Nullable
    public final GridReference getGrid(@NotNull Object key, @NotNull String gridType) {
        ConstraintReference reference;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)gridType, (String)"gridType");
        ConstraintReference constraintReference = reference = this.constraints(key);
        if ((constraintReference != null ? constraintReference.getFacade() : null) == null || !(reference.getFacade() instanceof GridReference)) {
            Helper Type2 = Helper.GRID;
            if (gridType.charAt(0) == 'r') {
                Type2 = Helper.ROW;
            } else if (gridType.charAt(0) == 'c') {
                Type2 = Helper.COLUMN;
            }
            GridReference gridReference = new GridReference(this, Type2);
            ConstraintReference constraintReference2 = reference;
            if (constraintReference2 != null) {
                constraintReference2.setFacade(gridReference);
            }
        }
        ConstraintReference constraintReference3 = reference;
        return (GridReference)(constraintReference3 != null ? constraintReference3.getFacade() : null);
    }

    @Nullable
    public final FlowReference getFlow(@Nullable Object key, boolean vertical) {
        ConstraintReference reference;
        ConstraintReference constraintReference = reference = this.constraints(key);
        if ((constraintReference != null ? constraintReference.getFacade() : null) == null || !(reference.getFacade() instanceof FlowReference)) {
            FlowReference flowReference = vertical ? new FlowReference(this, Helper.VERTICAL_FLOW) : new FlowReference(this, Helper.HORIZONTAL_FLOW);
            ConstraintReference constraintReference2 = reference;
            if (constraintReference2 != null) {
                constraintReference2.setFacade(flowReference);
            }
        }
        ConstraintReference constraintReference3 = reference;
        return (FlowReference)(constraintReference3 != null ? constraintReference3.getFacade() : null);
    }

    @NotNull
    public final VerticalChainReference verticalChain() {
        HelperReference helperReference = this.helper(null, Helper.VERTICAL_CHAIN);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.VerticalChainReference");
        return (VerticalChainReference)helperReference;
    }

    @NotNull
    public final VerticalChainReference verticalChain(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.VERTICAL_CHAIN);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.VerticalChainReference");
        VerticalChainReference reference = (VerticalChainReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final HorizontalChainReference horizontalChain() {
        HelperReference helperReference = this.helper(null, Helper.HORIZONTAL_CHAIN);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.HorizontalChainReference");
        return (HorizontalChainReference)helperReference;
    }

    @NotNull
    public final HorizontalChainReference horizontalChain(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.HORIZONTAL_CHAIN);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.HorizontalChainReference");
        HorizontalChainReference reference = (HorizontalChainReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final FlowReference getVerticalFlow() {
        HelperReference helperReference = this.helper(null, Helper.VERTICAL_FLOW);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.FlowReference");
        return (FlowReference)helperReference;
    }

    @NotNull
    public final FlowReference getVerticalFlow(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.VERTICAL_FLOW);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.FlowReference");
        FlowReference reference = (FlowReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final FlowReference getHorizontalFlow() {
        HelperReference helperReference = this.helper(null, Helper.HORIZONTAL_FLOW);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.FlowReference");
        return (FlowReference)helperReference;
    }

    @NotNull
    public final FlowReference getHorizontalFlow(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.HORIZONTAL_FLOW);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.FlowReference");
        FlowReference reference = (FlowReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final AlignHorizontallyReference centerHorizontally(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.ALIGN_HORIZONTALLY);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.AlignHorizontallyReference");
        AlignHorizontallyReference reference = (AlignHorizontallyReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final AlignVerticallyReference centerVertically(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.ALIGN_VERTICALLY);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.AlignVerticallyReference");
        AlignVerticallyReference reference = (AlignVerticallyReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    public final void directMapping() {
        Iterator<Object> iterator = this.mReferences.keySet().iterator();
        while (iterator.hasNext()) {
            Object key;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            ConstraintReference constraintReference = this.constraints(key);
            if (constraintReference == null) continue;
            Reference ref = constraintReference;
            ConstraintReference reference = (ConstraintReference)ref;
            reference.setView(key);
        }
    }

    public final void map(@Nullable Object key, @NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ConstraintReference ref = this.constraints(key);
        if (ref != null) {
            ref.setView(view);
        }
    }

    public final void setTag(@NotNull String key, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Reference ref = this.constraints(key);
        if (ref instanceof ConstraintReference) {
            ConstraintReference reference = (ConstraintReference)ref;
            reference.setTag(tag);
            ArrayList<Object> list = null;
            if (!this.mTags.containsKey(tag)) {
                list = new ArrayList();
                ((Map)this.mTags).put(tag, list);
            } else {
                list = this.mTags.get(tag);
            }
            ArrayList<Object> arrayList = list;
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(key);
        }
    }

    @Nullable
    public final ArrayList<String> getIdsForTag(@Nullable String tag) {
        return ((Map)this.mTags).containsKey(tag) ? (ArrayList)((Map)this.mTags).get(tag) : null;
    }

    public final void apply(@NotNull ConstraintWidgetContainer container) {
        ConstraintWidget widget;
        Object constraintReference;
        HelperWidget helperWidget;
        Reference reference;
        Object key2;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        container.removeAllChildren();
        this.mParent.getWidth().apply(this, container, 0);
        this.mParent.getHeight().apply(this, container, 1);
        Iterator<Object> iterator = this.mHelperReferences.keySet().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            reference = this.mHelperReferences.get(key2);
            HelperReference helperReference = reference;
            helperWidget = helperReference != null ? helperReference.getHelperWidget() : null;
            if (helperWidget == null) continue;
            constraintReference = this.mReferences.get(key2);
            if (constraintReference == null) {
                constraintReference = this.constraints(key2);
            }
            Reference reference2 = constraintReference;
            Intrinsics.checkNotNull((Object)reference2);
            reference2.setConstraintWidget(helperWidget);
        }
        iterator = this.mReferences.keySet().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            reference = this.mReferences.get(key2);
            if (Intrinsics.areEqual((Object)reference, (Object)this.mParent)) continue;
            Reference reference3 = reference;
            Intrinsics.checkNotNull((Object)reference3);
            if (!(reference3.getFacade() instanceof HelperReference)) continue;
            HelperReference helperReference = (HelperReference)reference.getFacade();
            helperWidget = helperReference != null ? helperReference.getHelperWidget() : null;
            if (helperWidget == null) continue;
            constraintReference = this.mReferences.get(key2);
            if (constraintReference == null) {
                constraintReference = this.constraints(key2);
            }
            Reference reference4 = constraintReference;
            Intrinsics.checkNotNull((Object)reference4);
            reference4.setConstraintWidget(helperWidget);
        }
        iterator = this.mReferences.keySet().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            reference = this.mReferences.get(key2);
            if (!Intrinsics.areEqual((Object)reference, (Object)this.mParent)) {
                Reference reference5 = reference;
                Intrinsics.checkNotNull((Object)reference5);
                ConstraintWidget constraintWidget = widget = reference5.getConstraintWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                constraintWidget.setDebugName(String.valueOf(reference.getKey()));
                widget.setParent(null);
                if (reference.getFacade() instanceof GuidelineReference) {
                    reference.apply();
                }
                container.add(widget);
                continue;
            }
            reference.setConstraintWidget(container);
        }
        iterator = this.mHelperReferences.keySet().iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Reference reference6 = reference = this.mHelperReferences.get(key2);
            HelperWidget helperWidget2 = helperWidget = reference6 != null ? ((HelperReference)reference6).getHelperWidget() : null;
            if (helperWidget != null) {
                Intrinsics.checkNotNullExpressionValue(((HelperReference)reference).getMReferences().iterator(), (String)"iterator(...)");
                while (constraintReference.hasNext()) {
                    Object keyRef;
                    Intrinsics.checkNotNullExpressionValue(constraintReference.next(), (String)"next(...)");
                    Reference constraintReference2 = this.mReferences.get(keyRef);
                    HelperWidget helperWidget3 = ((HelperReference)reference).getHelperWidget();
                    Intrinsics.checkNotNull((Object)helperWidget3);
                    Reference reference7 = constraintReference2;
                    Intrinsics.checkNotNull((Object)reference7);
                    helperWidget3.add(reference7.getConstraintWidget());
                }
                ((HelperReference)reference).apply();
                continue;
            }
            Reference reference8 = reference;
            if (reference8 == null) continue;
            ((HelperReference)reference8).apply();
        }
        iterator = this.mReferences.keySet().iterator();
        while (iterator.hasNext()) {
            Iterator<Object> iterator2;
            HelperReference helperReference;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            reference = this.mReferences.get(key2);
            if (Intrinsics.areEqual((Object)reference, (Object)this.mParent)) continue;
            Reference reference9 = reference;
            Intrinsics.checkNotNull((Object)reference9);
            if (!(reference9.getFacade() instanceof HelperReference)) continue;
            HelperReference helperReference2 = helperReference = (HelperReference)reference.getFacade();
            HelperWidget helperWidget4 = helperReference2 != null ? helperReference2.getHelperWidget() : null;
            if (helperWidget4 == null) continue;
            Intrinsics.checkNotNullExpressionValue(helperReference.getMReferences().iterator(), (String)"iterator(...)");
            while (iterator2.hasNext()) {
                Object keyRef;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Reference constraintReference3 = this.mReferences.get(keyRef);
                if (constraintReference3 != null) {
                    helperWidget4.add(constraintReference3.getConstraintWidget());
                    continue;
                }
                if (keyRef instanceof Reference) {
                    helperWidget4.add(((Reference)keyRef).getConstraintWidget());
                    continue;
                }
                System.out.println((Object)("couldn't find reference for " + keyRef));
            }
            reference.apply();
        }
        for (Object key2 : this.mReferences.keySet()) {
            Reference reference10 = reference = (Reference)((Map)this.mReferences).get(key2);
            Intrinsics.checkNotNull((Object)reference10);
            reference10.apply();
            widget = reference.getConstraintWidget();
            if (widget == null || key2 == null) continue;
            widget.setStringId(key2.toString());
        }
    }

    @NotNull
    public final ArrayList<Object> getMBaselineNeeded() {
        return this.mBaselineNeeded;
    }

    public final void setMBaselineNeeded(@NotNull ArrayList<Object> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mBaselineNeeded = arrayList;
    }

    @NotNull
    public final ArrayList<ConstraintWidget> getMBaselineNeededWidgets() {
        return this.mBaselineNeededWidgets;
    }

    public final void setMBaselineNeededWidgets(@NotNull ArrayList<ConstraintWidget> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mBaselineNeededWidgets = arrayList;
    }

    public final boolean getMDirtyBaselineNeededWidgets() {
        return this.mDirtyBaselineNeededWidgets;
    }

    public final void setMDirtyBaselineNeededWidgets(boolean bl) {
        this.mDirtyBaselineNeededWidgets = bl;
    }

    public final void baselineNeededFor(@NotNull Object id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.mBaselineNeeded.add(id);
        this.mDirtyBaselineNeededWidgets = true;
    }

    public final boolean isBaselineNeeded(@Nullable ConstraintWidget constraintWidget) {
        if (this.mDirtyBaselineNeededWidgets) {
            this.mBaselineNeededWidgets.clear();
            Iterator<Object> iterator = this.mBaselineNeeded.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Object> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object id;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Reference reference = this.mReferences.get(id);
                Intrinsics.checkNotNull((Object)reference);
                ConstraintWidget widget = reference.getConstraintWidget();
                if (widget == null) continue;
                this.mBaselineNeededWidgets.add(widget);
            }
            this.mDirtyBaselineNeededWidgets = false;
        }
        return CollectionsKt.contains((Iterable)this.mBaselineNeededWidgets, (Object)constraintWidget);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Landroidx/constraintlayout/core/state/State$Chain;", "", "<init>", "(Ljava/lang/String;I)V", "SPREAD", "SPREAD_INSIDE", "PACKED", "Companion", "compose"})
    public static final class Chain
    extends Enum<Chain> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final Map<String, Chain> chainMap;
        @NotNull
        private static final Map<String, Integer> valueMap;
        public static final /* enum */ Chain SPREAD;
        public static final /* enum */ Chain SPREAD_INSIDE;
        public static final /* enum */ Chain PACKED;
        private static final /* synthetic */ Chain[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Chain[] values() {
            return (Chain[])$VALUES.clone();
        }

        public static Chain valueOf(String value) {
            return Enum.valueOf(Chain.class, value);
        }

        @NotNull
        public static EnumEntries<Chain> getEntries() {
            return $ENTRIES;
        }

        static {
            SPREAD = new Chain();
            SPREAD_INSIDE = new Chain();
            PACKED = new Chain();
            $VALUES = chainArray = new Chain[]{Chain.SPREAD, Chain.SPREAD_INSIDE, Chain.PACKED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"packed", (Object)((Object)PACKED)), TuplesKt.to((Object)"spread_inside", (Object)((Object)SPREAD_INSIDE)), TuplesKt.to((Object)"spread", (Object)((Object)SPREAD))};
            chainMap = MapsKt.hashMapOf((Pair[])pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"packed", (Object)2), TuplesKt.to((Object)"spread_inside", (Object)1), TuplesKt.to((Object)"spread", (Object)0)};
            valueMap = MapsKt.hashMapOf((Pair[])pairArray);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0010"}, d2={"Landroidx/constraintlayout/core/state/State$Chain$Companion;", "", "<init>", "()V", "chainMap", "", "", "Landroidx/constraintlayout/core/state/State$Chain;", "getChainMap", "()Ljava/util/Map;", "valueMap", "", "getValueMap", "getValueByString", "str", "getChainByString", "compose"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, Chain> getChainMap() {
                return chainMap;
            }

            @NotNull
            public final Map<String, Integer> getValueMap() {
                return valueMap;
            }

            public final int getValueByString(@Nullable String str) {
                int n;
                if (this.getValueMap().containsKey(str)) {
                    Integer n2 = this.getValueMap().get(str);
                    Intrinsics.checkNotNull((Object)n2);
                    n = ((Number)n2).intValue();
                } else {
                    n = -1;
                }
                return n;
            }

            @Nullable
            public final Chain getChainByString(@Nullable String str) {
                return this.getChainMap().containsKey(str) ? this.getChainMap().get(str) : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/constraintlayout/core/state/State$Companion;", "", "<init>", "()V", "UNKNOWN", "", "CONSTRAINT_SPREAD", "CONSTRAINT_WRAP", "CONSTRAINT_RATIO", "PARENT", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0017\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Landroidx/constraintlayout/core/state/State$Constraint;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT_TO_LEFT", "LEFT_TO_RIGHT", "RIGHT_TO_LEFT", "RIGHT_TO_RIGHT", "START_TO_START", "START_TO_END", "END_TO_START", "END_TO_END", "TOP_TO_TOP", "TOP_TO_BOTTOM", "TOP_TO_BASELINE", "BOTTOM_TO_TOP", "BOTTOM_TO_BOTTOM", "BOTTOM_TO_BASELINE", "BASELINE_TO_BASELINE", "BASELINE_TO_TOP", "BASELINE_TO_BOTTOM", "CENTER_HORIZONTALLY", "CENTER_VERTICALLY", "CIRCULAR_CONSTRAINT", "compose"})
    public static final class Constraint
    extends Enum<Constraint> {
        public static final /* enum */ Constraint LEFT_TO_LEFT = new Constraint();
        public static final /* enum */ Constraint LEFT_TO_RIGHT = new Constraint();
        public static final /* enum */ Constraint RIGHT_TO_LEFT = new Constraint();
        public static final /* enum */ Constraint RIGHT_TO_RIGHT = new Constraint();
        public static final /* enum */ Constraint START_TO_START = new Constraint();
        public static final /* enum */ Constraint START_TO_END = new Constraint();
        public static final /* enum */ Constraint END_TO_START = new Constraint();
        public static final /* enum */ Constraint END_TO_END = new Constraint();
        public static final /* enum */ Constraint TOP_TO_TOP = new Constraint();
        public static final /* enum */ Constraint TOP_TO_BOTTOM = new Constraint();
        public static final /* enum */ Constraint TOP_TO_BASELINE = new Constraint();
        public static final /* enum */ Constraint BOTTOM_TO_TOP = new Constraint();
        public static final /* enum */ Constraint BOTTOM_TO_BOTTOM = new Constraint();
        public static final /* enum */ Constraint BOTTOM_TO_BASELINE = new Constraint();
        public static final /* enum */ Constraint BASELINE_TO_BASELINE = new Constraint();
        public static final /* enum */ Constraint BASELINE_TO_TOP = new Constraint();
        public static final /* enum */ Constraint BASELINE_TO_BOTTOM = new Constraint();
        public static final /* enum */ Constraint CENTER_HORIZONTALLY = new Constraint();
        public static final /* enum */ Constraint CENTER_VERTICALLY = new Constraint();
        public static final /* enum */ Constraint CIRCULAR_CONSTRAINT = new Constraint();
        private static final /* synthetic */ Constraint[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Constraint[] values() {
            return (Constraint[])$VALUES.clone();
        }

        public static Constraint valueOf(String value) {
            return Enum.valueOf(Constraint.class, value);
        }

        @NotNull
        public static EnumEntries<Constraint> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constraintArray = new Constraint[]{Constraint.LEFT_TO_LEFT, Constraint.LEFT_TO_RIGHT, Constraint.RIGHT_TO_LEFT, Constraint.RIGHT_TO_RIGHT, Constraint.START_TO_START, Constraint.START_TO_END, Constraint.END_TO_START, Constraint.END_TO_END, Constraint.TOP_TO_TOP, Constraint.TOP_TO_BOTTOM, Constraint.TOP_TO_BASELINE, Constraint.BOTTOM_TO_TOP, Constraint.BOTTOM_TO_BOTTOM, Constraint.BOTTOM_TO_BASELINE, Constraint.BASELINE_TO_BASELINE, Constraint.BASELINE_TO_TOP, Constraint.BASELINE_TO_BOTTOM, Constraint.CENTER_HORIZONTALLY, Constraint.CENTER_VERTICALLY, Constraint.CIRCULAR_CONSTRAINT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/constraintlayout/core/state/State$Direction;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "START", "END", "TOP", "BOTTOM", "compose"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction LEFT = new Direction();
        public static final /* enum */ Direction RIGHT = new Direction();
        public static final /* enum */ Direction START = new Direction();
        public static final /* enum */ Direction END = new Direction();
        public static final /* enum */ Direction TOP = new Direction();
        public static final /* enum */ Direction BOTTOM = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.LEFT, Direction.RIGHT, Direction.START, Direction.END, Direction.TOP, Direction.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Landroidx/constraintlayout/core/state/State$Helper;", "", "<init>", "(Ljava/lang/String;I)V", "HORIZONTAL_CHAIN", "VERTICAL_CHAIN", "ALIGN_HORIZONTALLY", "ALIGN_VERTICALLY", "BARRIER", "LAYER", "HORIZONTAL_FLOW", "VERTICAL_FLOW", "GRID", "ROW", "COLUMN", "FLOW", "compose"})
    public static final class Helper
    extends Enum<Helper> {
        public static final /* enum */ Helper HORIZONTAL_CHAIN = new Helper();
        public static final /* enum */ Helper VERTICAL_CHAIN = new Helper();
        public static final /* enum */ Helper ALIGN_HORIZONTALLY = new Helper();
        public static final /* enum */ Helper ALIGN_VERTICALLY = new Helper();
        public static final /* enum */ Helper BARRIER = new Helper();
        public static final /* enum */ Helper LAYER = new Helper();
        public static final /* enum */ Helper HORIZONTAL_FLOW = new Helper();
        public static final /* enum */ Helper VERTICAL_FLOW = new Helper();
        public static final /* enum */ Helper GRID = new Helper();
        public static final /* enum */ Helper ROW = new Helper();
        public static final /* enum */ Helper COLUMN = new Helper();
        public static final /* enum */ Helper FLOW = new Helper();
        private static final /* synthetic */ Helper[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Helper[] values() {
            return (Helper[])$VALUES.clone();
        }

        public static Helper valueOf(String value) {
            return Enum.valueOf(Helper.class, value);
        }

        @NotNull
        public static EnumEntries<Helper> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = helperArray = new Helper[]{Helper.HORIZONTAL_CHAIN, Helper.VERTICAL_CHAIN, Helper.ALIGN_HORIZONTALLY, Helper.ALIGN_VERTICALLY, Helper.BARRIER, Helper.LAYER, Helper.HORIZONTAL_FLOW, Helper.VERTICAL_FLOW, Helper.GRID, Helper.ROW, Helper.COLUMN, Helper.FLOW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Helper.values().length];
            try {
                nArray[Helper.HORIZONTAL_CHAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.VERTICAL_CHAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.ALIGN_HORIZONTALLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.ALIGN_VERTICALLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.BARRIER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.VERTICAL_FLOW.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.HORIZONTAL_FLOW.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.GRID.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.ROW.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.COLUMN.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Landroidx/constraintlayout/core/state/State$Wrap;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "CHAIN", "ALIGNED", "Companion", "compose"})
    public static final class Wrap
    extends Enum<Wrap> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final Map<String, Wrap> wrapMap;
        @NotNull
        private static final Map<String, Integer> valueMap;
        public static final /* enum */ Wrap NONE;
        public static final /* enum */ Wrap CHAIN;
        public static final /* enum */ Wrap ALIGNED;
        private static final /* synthetic */ Wrap[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Wrap[] values() {
            return (Wrap[])$VALUES.clone();
        }

        public static Wrap valueOf(String value) {
            return Enum.valueOf(Wrap.class, value);
        }

        @NotNull
        public static EnumEntries<Wrap> getEntries() {
            return $ENTRIES;
        }

        static {
            NONE = new Wrap();
            CHAIN = new Wrap();
            ALIGNED = new Wrap();
            $VALUES = wrapArray = new Wrap[]{Wrap.NONE, Wrap.CHAIN, Wrap.ALIGNED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"none", (Object)((Object)NONE)), TuplesKt.to((Object)"chain", (Object)((Object)CHAIN)), TuplesKt.to((Object)"aligned", (Object)((Object)ALIGNED))};
            wrapMap = MapsKt.hashMapOf((Pair[])pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"none", (Object)0), TuplesKt.to((Object)"chain", (Object)3), TuplesKt.to((Object)"aligned", (Object)2)};
            valueMap = MapsKt.hashMapOf((Pair[])pairArray);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0010"}, d2={"Landroidx/constraintlayout/core/state/State$Wrap$Companion;", "", "<init>", "()V", "wrapMap", "", "", "Landroidx/constraintlayout/core/state/State$Wrap;", "getWrapMap", "()Ljava/util/Map;", "valueMap", "", "getValueMap", "getValueByString", "str", "getChainByString", "compose"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, Wrap> getWrapMap() {
                return wrapMap;
            }

            @NotNull
            public final Map<String, Integer> getValueMap() {
                return valueMap;
            }

            public final int getValueByString(@Nullable String str) {
                int n;
                if (this.getValueMap().containsKey(str)) {
                    Integer n2 = this.getValueMap().get(str);
                    Intrinsics.checkNotNull((Object)n2);
                    n = ((Number)n2).intValue();
                } else {
                    n = -1;
                }
                return n;
            }

            @Nullable
            public final Wrap getChainByString(@Nullable String str) {
                return this.getWrapMap().containsKey(str) ? this.getWrapMap().get(str) : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

