/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013J\u0010\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018J\u0016\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\rJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Landroidx/constraintlayout/core/motion/utils/Utils;", "", "<init>", "()V", "log", "", "tag", "", "value", "loge", "socketSend", "str", "clamp", "", "c", "getInterpolatedColor", "", "rgbaTocColor", "r", "", "g", "b", "a", "sOurHandle", "Landroidx/constraintlayout/core/motion/utils/Utils$DebugHandle;", "getSOurHandle", "()Landroidx/constraintlayout/core/motion/utils/Utils$DebugHandle;", "setSOurHandle", "(Landroidx/constraintlayout/core/motion/utils/Utils$DebugHandle;)V", "setDebugHandle", "handle", "logStack", "msg", "n", "DebugHandle", "compose"})
@StabilityInferred(parameters=0)
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @Nullable
    private static DebugHandle sOurHandle;
    public static final int $stable;

    private Utils() {
    }

    public final void log(@NotNull String tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        System.out.println((Object)(tag + " : " + value));
    }

    public final void loge(@NotNull String tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        System.out.println((Object)(tag + " : " + value));
    }

    public final void socketSend(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
    }

    private final int clamp(int c) {
        int c2 = c;
        int n = 255;
        c2 &= ~(c2 >> 31);
        c2 -= n;
        c2 &= c2 >> 31;
        return c2 += n;
    }

    public final int getInterpolatedColor(@NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int r = this.clamp((int)((float)Math.pow(value[0], 0.45454545454545453) * 255.0f));
        int g = this.clamp((int)((float)Math.pow(value[1], 0.45454545454545453) * 255.0f));
        int b = this.clamp((int)((float)Math.pow(value[2], 0.45454545454545453) * 255.0f));
        int a = this.clamp((int)(value[3] * 255.0f));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public final int rgbaTocColor(float r, float g, float b, float a) {
        int ir = this.clamp((int)(r * 255.0f));
        int ig = this.clamp((int)(g * 255.0f));
        int ib = this.clamp((int)(b * 255.0f));
        int ia = this.clamp((int)(a * 255.0f));
        return ia << 24 | ir << 16 | ig << 8 | ib;
    }

    @Nullable
    public final DebugHandle getSOurHandle() {
        return sOurHandle;
    }

    public final void setSOurHandle(@Nullable DebugHandle debugHandle) {
        sOurHandle = debugHandle;
    }

    public final void setDebugHandle(@Nullable DebugHandle handle) {
        sOurHandle = handle;
    }

    public final void logStack(@NotNull String msg, int n) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        int n2 = n;
        String st = ExceptionsKt.stackTraceToString((Throwable)new Throwable());
        String s = " ";
        System.out.println((Object)(msg + s + st + s));
    }

    public final void log(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String ss = ExceptionsKt.stackTraceToString((Throwable)new Throwable());
        System.out.println((Object)(ss + " " + str));
        if (sOurHandle != null) {
            DebugHandle debugHandle = sOurHandle;
            Intrinsics.checkNotNull((Object)debugHandle);
            debugHandle.message(ss + " " + str);
        }
    }

    static {
        $stable = 8;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Landroidx/constraintlayout/core/motion/utils/Utils$DebugHandle;", "", "message", "", "str", "", "compose"})
    public static interface DebugHandle {
        public void message(@Nullable String var1);
    }
}

