/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.utils.Schlick;
import androidx.constraintlayout.core.motion.utils.StepCurve;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Landroidx/constraintlayout/core/motion/utils/Easing;", "", "<init>", "()V", "mStr", "", "getMStr", "()Ljava/lang/String;", "setMStr", "(Ljava/lang/String;)V", "get", "", "x", "toString", "getDiff", "CubicEasing", "Companion", "compose"})
@StabilityInferred(parameters=0)
public class Easing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String mStr = "identity";
    public static final int $stable = 8;
    @NotNull
    private static Easing sDefault = new Easing();
    @NotNull
    private static final String STANDARD = "cubic(0.4, 0.0, 0.2, 1)";
    @NotNull
    private static final String ACCELERATE = "cubic(0.4, 0.05, 0.8, 0.7)";
    @NotNull
    private static final String DECELERATE = "cubic(0.0, 0.0, 0.2, 0.95)";
    @NotNull
    private static final String LINEAR = "cubic(1, 1, 0, 0)";
    @NotNull
    private static final String ANTICIPATE = "cubic(0.36, 0, 0.66, -0.56)";
    @NotNull
    private static final String OVERSHOOT = "cubic(0.34, 1.56, 0.64, 1)";
    @NotNull
    private static final String DECELERATE_NAME = "decelerate";
    @NotNull
    private static final String ACCELERATE_NAME = "accelerate";
    @NotNull
    private static final String STANDARD_NAME = "standard";
    @NotNull
    private static final String LINEAR_NAME = "linear";
    @NotNull
    private static final String ANTICIPATE_NAME = "anticipate";
    @NotNull
    private static final String OVERSHOOT_NAME = "overshoot";
    @NotNull
    private static String[] NAMED_EASING;

    @NotNull
    public final String getMStr() {
        return this.mStr;
    }

    public final void setMStr(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mStr = string;
    }

    public double get(double x) {
        return x;
    }

    @NotNull
    public String toString() {
        return this.mStr;
    }

    public double getDiff(double x) {
        return 1.0;
    }

    static {
        String[] stringArray = new String[]{STANDARD_NAME, ACCELERATE_NAME, DECELERATE_NAME, LINEAR_NAME};
        NAMED_EASING = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Landroidx/constraintlayout/core/motion/utils/Easing$Companion;", "", "<init>", "()V", "sDefault", "Landroidx/constraintlayout/core/motion/utils/Easing;", "getSDefault", "()Landroidx/constraintlayout/core/motion/utils/Easing;", "setSDefault", "(Landroidx/constraintlayout/core/motion/utils/Easing;)V", "STANDARD", "", "ACCELERATE", "DECELERATE", "LINEAR", "ANTICIPATE", "OVERSHOOT", "DECELERATE_NAME", "ACCELERATE_NAME", "STANDARD_NAME", "LINEAR_NAME", "ANTICIPATE_NAME", "OVERSHOOT_NAME", "NAMED_EASING", "", "getNAMED_EASING", "()[Ljava/lang/String;", "setNAMED_EASING", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "getInterpolator", "configString", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Easing getSDefault() {
            return sDefault;
        }

        public final void setSDefault(@NotNull Easing easing) {
            Intrinsics.checkNotNullParameter((Object)easing, (String)"<set-?>");
            sDefault = easing;
        }

        @NotNull
        public final String[] getNAMED_EASING() {
            return NAMED_EASING;
        }

        public final void setNAMED_EASING(@NotNull String[] stringArray) {
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
            NAMED_EASING = stringArray;
        }

        @Nullable
        public final Easing getInterpolator(@Nullable String configString) {
            if (configString == null) {
                return null;
            }
            if (StringsKt.startsWith$default((String)configString, (String)"cubic", (boolean)false, (int)2, null)) {
                return new CubicEasing(configString);
            }
            if (StringsKt.startsWith$default((String)configString, (String)"spline", (boolean)false, (int)2, null)) {
                return new StepCurve(configString);
            }
            if (StringsKt.startsWith$default((String)configString, (String)"Schlick", (boolean)false, (int)2, null)) {
                return new Schlick(configString);
            }
            switch (configString) {
                case "standard": {
                    return new CubicEasing(Easing.STANDARD);
                }
                case "accelerate": {
                    return new CubicEasing(Easing.ACCELERATE);
                }
                case "decelerate": {
                    return new CubicEasing(Easing.DECELERATE);
                }
                case "linear": {
                    return new CubicEasing(Easing.LINEAR);
                }
                case "anticipate": {
                    return new CubicEasing(Easing.ANTICIPATE);
                }
                case "overshoot": {
                    return new CubicEasing(Easing.OVERSHOOT);
                }
            }
            String string = Arrays.toString(this.getNAMED_EASING());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = "transitionEasing syntax error syntax:transitionEasing=\"cubic(1.0,0.5,0.0,0.6)\" or " + string;
            System.out.println((Object)string2);
            return this.getSDefault();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B)\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u000bJ&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0016R\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010\u00a8\u0006%"}, d2={"Landroidx/constraintlayout/core/motion/utils/Easing$CubicEasing;", "Landroidx/constraintlayout/core/motion/utils/Easing;", "configString", "", "<init>", "(Ljava/lang/String;)V", "x1", "", "y1", "x2", "y2", "(DDDD)V", "mX1", "getMX1", "()D", "setMX1", "(D)V", "mY1", "getMY1", "setMY1", "mX2", "getMX2", "setMX2", "mY2", "getMY2", "setMY2", "setup", "", "getX", "t", "getY", "getDiffX", "getDiffY", "getDiff", "x", "get", "Companion", "compose"})
    @StabilityInferred(parameters=0)
    public static final class CubicEasing
    extends Easing {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private double mX1;
        private double mY1;
        private double mX2;
        private double mY2;
        public static final int $stable = 8;
        private static final double S_ERROR = 0.01;
        private static final double SD_ERROR = 1.0E-4;

        public final double getMX1() {
            return this.mX1;
        }

        public final void setMX1(double d) {
            this.mX1 = d;
        }

        public final double getMY1() {
            return this.mY1;
        }

        public final void setMY1(double d) {
            this.mY1 = d;
        }

        public final double getMX2() {
            return this.mX2;
        }

        public final void setMX2(double d) {
            this.mX2 = d;
        }

        public final double getMY2() {
            return this.mY2;
        }

        public final void setMY2(double d) {
            this.mY2 = d;
        }

        public CubicEasing(@NotNull String configString) {
            Intrinsics.checkNotNullParameter((Object)configString, (String)"configString");
            this.setMStr(configString);
            int start = StringsKt.indexOf$default((CharSequence)configString, (char)'(', (int)0, (boolean)false, (int)6, null);
            int off1 = StringsKt.indexOf$default((CharSequence)configString, (char)',', (int)start, (boolean)false, (int)4, null);
            String string = configString.substring(start + 1, off1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.mX1 = Double.parseDouble(((Object)StringsKt.trim((CharSequence)string)).toString());
            int off2 = StringsKt.indexOf$default((CharSequence)configString, (char)',', (int)(off1 + 1), (boolean)false, (int)4, null);
            String string2 = configString.substring(off1 + 1, off2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.mY1 = Double.parseDouble(((Object)StringsKt.trim((CharSequence)string2)).toString());
            int off3 = StringsKt.indexOf$default((CharSequence)configString, (char)',', (int)(off2 + 1), (boolean)false, (int)4, null);
            String string3 = configString.substring(off2 + 1, off3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            this.mX2 = Double.parseDouble(((Object)StringsKt.trim((CharSequence)string3)).toString());
            int end = StringsKt.indexOf$default((CharSequence)configString, (char)')', (int)(off3 + 1), (boolean)false, (int)4, null);
            String string4 = configString.substring(off3 + 1, end);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            this.mY2 = Double.parseDouble(((Object)StringsKt.trim((CharSequence)string4)).toString());
        }

        public CubicEasing(double x1, double y1, double x2, double y2) {
            this.setup(x1, y1, x2, y2);
        }

        public final void setup(double x1, double y1, double x2, double y2) {
            this.mX1 = x1;
            this.mY1 = y1;
            this.mX2 = x2;
            this.mY2 = y2;
        }

        private final double getX(double t) {
            double t1 = 1.0 - t;
            double f1 = (double)3 * t1 * t1 * t;
            double f2 = (double)3 * t1 * t * t;
            double f3 = t * t * t;
            return this.mX1 * f1 + this.mX2 * f2 + f3;
        }

        private final double getY(double t) {
            double t1 = 1.0 - t;
            double f1 = (double)3 * t1 * t1 * t;
            double f2 = (double)3 * t1 * t * t;
            double f3 = t * t * t;
            return this.mY1 * f1 + this.mY2 * f2 + f3;
        }

        private final double getDiffX(double t) {
            double t1 = 1.0 - t;
            return (double)3 * t1 * t1 * this.mX1 + (double)6 * t1 * t * (this.mX2 - this.mX1) + (double)3 * t * t * (1.0 - this.mX2);
        }

        private final double getDiffY(double t) {
            double t1 = 1.0 - t;
            return (double)3 * t1 * t1 * this.mY1 + (double)6 * t1 * t * (this.mY2 - this.mY1) + (double)3 * t * t * (1.0 - this.mY2);
        }

        @Override
        public double getDiff(double x) {
            double range;
            double t = 0.5;
            for (range = 0.5; range > 1.0E-4; range *= 0.5) {
                double tx = this.getX(t);
                if (tx < x) {
                    t += range;
                    continue;
                }
                t -= range;
            }
            double x1 = this.getX(t - range);
            double x2 = this.getX(t + range);
            double y1 = this.getY(t - range);
            double y2 = this.getY(t + range);
            return (y2 - y1) / (x2 - x1);
        }

        @Override
        public double get(double x) {
            double range;
            if (x <= 0.0) {
                return 0.0;
            }
            if (x >= 1.0) {
                return 1.0;
            }
            double t = 0.5;
            for (range = 0.5; range > 0.01; range *= 0.5) {
                double tx = this.getX(t);
                if (tx < x) {
                    t += range;
                    continue;
                }
                t -= range;
            }
            double x1 = this.getX(t - range);
            double x2 = this.getX(t + range);
            double y1 = this.getY(t - range);
            double y2 = this.getY(t + range);
            return (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/motion/utils/Easing$CubicEasing$Companion;", "", "<init>", "()V", "S_ERROR", "", "SD_ERROR", "compose"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

