/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ext.ArrayKt;
import androidx.constraintlayout.core.ext.Math;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/constraintlayout/core/motion/utils/ArcCurveFit;", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "arcModes", "", "time", "", "y", "", "<init>", "([I[D[[D)V", "mTime", "mArcs", "Landroidx/constraintlayout/core/motion/utils/ArcCurveFit$Companion$Arc;", "[Landroidx/constraintlayout/core/motion/utils/ArcCurveFit$Companion$Arc;", "mExtrapolate", "", "getPos", "", "t", "", "v", "", "getSlope", "j", "", "getTimePoints", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class ArcCurveFit
extends CurveFit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] mTime;
    @NotNull
    private Companion.Arc[] mArcs;
    private final boolean mExtrapolate;
    public static final int $stable = 8;
    public static final int ARC_START_VERTICAL = 1;
    public static final int ARC_START_HORIZONTAL = 2;
    public static final int ARC_START_FLIP = 3;
    public static final int ARC_BELOW = 4;
    public static final int ARC_ABOVE = 5;
    public static final int ARC_START_LINEAR = 0;
    private static final int START_VERTICAL = 1;
    private static final int START_HORIZONTAL = 2;
    private static final int START_LINEAR = 3;
    private static final int DOWN_ARC = 4;
    private static final int UP_ARC = 5;

    @Override
    public void getPos(double t, @NotNull double[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double t2 = t;
        if (this.mExtrapolate) {
            if (t2 < this.mArcs[0].getMTime1()) {
                double t0 = this.mArcs[0].getMTime1();
                double dt = t2 - this.mArcs[0].getMTime1();
                int p = 0;
                if (this.mArcs[p].getMLinear()) {
                    v[0] = this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0);
                    v[1] = this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0);
                } else {
                    this.mArcs[p].setPoint(t0);
                    v[0] = this.mArcs[p].getX() + dt * this.mArcs[p].getDX();
                    v[1] = this.mArcs[p].getY() + dt * this.mArcs[p].getDY();
                }
                return;
            }
            if (t2 > this.mArcs[this.mArcs.length - 1].getMTime2()) {
                double t0 = this.mArcs[this.mArcs.length - 1].getMTime2();
                double dt = t2 - t0;
                int p = this.mArcs.length - 1;
                if (this.mArcs[p].getMLinear()) {
                    v[0] = this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0);
                    v[1] = this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0);
                } else {
                    this.mArcs[p].setPoint(t2);
                    v[0] = this.mArcs[p].getX() + dt * this.mArcs[p].getDX();
                    v[1] = this.mArcs[p].getY() + dt * this.mArcs[p].getDY();
                }
                return;
            }
        } else {
            if (t2 < this.mArcs[0].getMTime1()) {
                t2 = this.mArcs[0].getMTime1();
            }
            if (t2 > this.mArcs[this.mArcs.length - 1].getMTime2()) {
                t2 = this.mArcs[this.mArcs.length - 1].getMTime2();
            }
        }
        int n = this.mArcs.length;
        for (int i = 0; i < n; ++i) {
            if (!(t2 <= this.mArcs[i].getMTime2())) continue;
            if (this.mArcs[i].getMLinear()) {
                v[0] = this.mArcs[i].getLinearX(t2);
                v[1] = this.mArcs[i].getLinearY(t2);
                return;
            }
            this.mArcs[i].setPoint(t2);
            v[0] = this.mArcs[i].getX();
            v[1] = this.mArcs[i].getY();
            return;
        }
    }

    @Override
    public void getPos(double t, @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double t2 = t;
        if (this.mExtrapolate) {
            if (t2 < this.mArcs[0].getMTime1()) {
                double t0 = this.mArcs[0].getMTime1();
                double dt = t2 - this.mArcs[0].getMTime1();
                int p = 0;
                if (this.mArcs[p].getMLinear()) {
                    v[0] = ((Float)(this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0))).floatValue();
                    v[1] = ((Float)(this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0))).floatValue();
                } else {
                    this.mArcs[p].setPoint(t0);
                    v[0] = ((Float)(this.mArcs[p].getX() + dt * this.mArcs[p].getDX())).floatValue();
                    v[1] = ((Float)(this.mArcs[p].getY() + dt * this.mArcs[p].getDY())).floatValue();
                }
                return;
            }
            if (t2 > this.mArcs[this.mArcs.length - 1].getMTime2()) {
                double t0 = this.mArcs[this.mArcs.length - 1].getMTime2();
                double dt = t2 - t0;
                int p = this.mArcs.length - 1;
                if (this.mArcs[p].getMLinear()) {
                    v[0] = ((Float)(this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0))).floatValue();
                    v[1] = ((Float)(this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0))).floatValue();
                } else {
                    this.mArcs[p].setPoint(t2);
                    v[0] = ((Float)this.mArcs[p].getX()).floatValue();
                    v[1] = ((Float)this.mArcs[p].getY()).floatValue();
                }
                return;
            }
        } else if (t2 < this.mArcs[0].getMTime1()) {
            t2 = this.mArcs[0].getMTime1();
        } else if (t2 > this.mArcs[this.mArcs.length - 1].getMTime2()) {
            t2 = this.mArcs[this.mArcs.length - 1].getMTime2();
        }
        int n = this.mArcs.length;
        for (int i = 0; i < n; ++i) {
            if (!(t2 <= this.mArcs[i].getMTime2())) continue;
            if (this.mArcs[i].getMLinear()) {
                v[0] = ((Float)this.mArcs[i].getLinearX(t2)).floatValue();
                v[1] = ((Float)this.mArcs[i].getLinearY(t2)).floatValue();
                return;
            }
            this.mArcs[i].setPoint(t2);
            v[0] = ((Float)this.mArcs[i].getX()).floatValue();
            v[1] = ((Float)this.mArcs[i].getY()).floatValue();
            return;
        }
    }

    @Override
    public void getSlope(double t, @NotNull double[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double t2 = t;
        if (t2 < this.mArcs[0].getMTime1()) {
            t2 = this.mArcs[0].getMTime1();
        } else if (t2 > this.mArcs[this.mArcs.length - 1].getMTime2()) {
            t2 = this.mArcs[this.mArcs.length - 1].getMTime2();
        }
        int n = this.mArcs.length;
        for (int i = 0; i < n; ++i) {
            if (!(t2 <= this.mArcs[i].getMTime2())) continue;
            if (this.mArcs[i].getMLinear()) {
                v[0] = this.mArcs[i].getLinearDX(t2);
                v[1] = this.mArcs[i].getLinearDY(t2);
                return;
            }
            this.mArcs[i].setPoint(t2);
            v[0] = this.mArcs[i].getDX();
            v[1] = this.mArcs[i].getDY();
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        double t2 = t;
        if (this.mExtrapolate) {
            if (t2 < this.mArcs[0].getMTime1()) {
                double d;
                double t0 = this.mArcs[0].getMTime1();
                double dt = t2 - this.mArcs[0].getMTime1();
                int p = 0;
                if (this.mArcs[p].getMLinear()) {
                    d = j == 0 ? this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0) : this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0);
                } else {
                    this.mArcs[p].setPoint(t0);
                    d = j == 0 ? this.mArcs[p].getX() + dt * this.mArcs[p].getDX() : this.mArcs[p].getY() + dt * this.mArcs[p].getDY();
                }
                return d;
            }
            if (t2 > this.mArcs[this.mArcs.length - 1].getMTime2()) {
                double t0 = this.mArcs[this.mArcs.length - 1].getMTime2();
                double dt = t2 - t0;
                int p = this.mArcs.length - 1;
                return j == 0 ? this.mArcs[p].getLinearX(t0) + dt * this.mArcs[p].getLinearDX(t0) : this.mArcs[p].getLinearY(t0) + dt * this.mArcs[p].getLinearDY(t0);
            }
        } else if (t2 < this.mArcs[0].getMTime1()) {
            t2 = this.mArcs[0].getMTime1();
        } else if (t2 > this.mArcs[this.mArcs.length - 1].getMTime2()) {
            t2 = this.mArcs[this.mArcs.length - 1].getMTime2();
        }
        int n = this.mArcs.length;
        for (int i = 0; i < n; ++i) {
            if (!(t2 <= this.mArcs[i].getMTime2())) continue;
            if (this.mArcs[i].getMLinear()) {
                return j == 0 ? this.mArcs[i].getLinearX(t2) : this.mArcs[i].getLinearY(t2);
            }
            this.mArcs[i].setPoint(t2);
            return j == 0 ? this.mArcs[i].getX() : this.mArcs[i].getY();
        }
        return Double.NaN;
    }

    @Override
    public double getSlope(double t, int j) {
        double t2 = t;
        if (t2 < this.mArcs[0].getMTime1()) {
            t2 = this.mArcs[0].getMTime1();
        }
        if (t2 > this.mArcs[this.mArcs.length - 1].getMTime2()) {
            t2 = this.mArcs[this.mArcs.length - 1].getMTime2();
        }
        int n = this.mArcs.length;
        for (int i = 0; i < n; ++i) {
            if (!(t2 <= this.mArcs[i].getMTime2())) continue;
            if (this.mArcs[i].getMLinear()) {
                return j == 0 ? this.mArcs[i].getLinearDX(t2) : this.mArcs[i].getLinearDY(t2);
            }
            this.mArcs[i].setPoint(t2);
            return j == 0 ? this.mArcs[i].getDX() : this.mArcs[i].getDY();
        }
        return Double.NaN;
    }

    @Override
    @NotNull
    public double[] getTimePoints() {
        return this.mTime;
    }

    public ArcCurveFit(@NotNull int[] arcModes, @NotNull double[] time, @NotNull double[][] y) {
        Intrinsics.checkNotNullParameter((Object)arcModes, (String)"arcModes");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.mExtrapolate = true;
        this.mTime = time;
        int mode = 1;
        int last = 1;
        int n = time.length - 1;
        Companion.Arc[] arcArray = new Companion.Arc[n];
        ArcCurveFit arcCurveFit = this;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            switch (arcModes[n2]) {
                case 1: {
                    last = mode = 1;
                    break;
                }
                case 2: {
                    last = mode = 2;
                    break;
                }
                case 3: {
                    last = mode = last == 1 ? 2 : 1;
                    break;
                }
                case 0: {
                    mode = 3;
                    break;
                }
                case 5: {
                    mode = 5;
                    break;
                }
                case 4: {
                    mode = 4;
                }
            }
            arcArray[n2] = new Companion.Arc(mode, time[n2], time[n2 + 1], y[n2][0], y[n2][1], y[n2 + 1][0], y[n2 + 1][1]);
        }
        arcCurveFit.mArcs = arcArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/constraintlayout/core/motion/utils/ArcCurveFit$Companion;", "", "<init>", "()V", "ARC_START_VERTICAL", "", "ARC_START_HORIZONTAL", "ARC_START_FLIP", "ARC_BELOW", "ARC_ABOVE", "ARC_START_LINEAR", "START_VERTICAL", "START_HORIZONTAL", "START_LINEAR", "DOWN_ARC", "UP_ARC", "Arc", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0013\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 :2\u00020\u0001:\u0001:BA\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0005J\u0006\u0010.\u001a\u00020\u0005J\u0006\u0010/\u001a\u00020\u0005J\u0006\u00100\u001a\u00020\u0005J\u0006\u00101\u001a\u00020\u0005J\u000e\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005J\u000e\u00104\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005J\u000e\u00105\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005J\u000e\u00106\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005J(\u00109\u001a\u00020,2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006;"}, d2={"Landroidx/constraintlayout/core/motion/utils/ArcCurveFit$Companion$Arc;", "", "mode", "", "t1", "", "t2", "x1", "y1", "x2", "y2", "<init>", "(IDDDDDD)V", "mLut", "", "mArcDistance", "mTime1", "getMTime1", "()D", "setMTime1", "(D)V", "mTime2", "getMTime2", "setMTime2", "mX1", "mX2", "mY1", "mY2", "mOneOverDeltaTime", "mEllipseA", "mEllipseB", "mEllipseCenterX", "mEllipseCenterY", "mArcVelocity", "mTmpSinAngle", "mTmpCosAngle", "mVertical", "", "mLinear", "getMLinear", "()Z", "setMLinear", "(Z)V", "setPoint", "", "time", "getX", "getY", "getDX", "getDY", "getLinearX", "t", "getLinearY", "getLinearDX", "getLinearDY", "lookup", "v", "buildTable", "Companion", "compose"})
        @StabilityInferred(parameters=0)
        public static final class Arc {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @Nullable
            private double[] mLut;
            private double mArcDistance;
            private double mTime1;
            private double mTime2;
            private double mX1;
            private double mX2;
            private double mY1;
            private double mY2;
            private double mOneOverDeltaTime;
            private double mEllipseA;
            private double mEllipseB;
            private double mEllipseCenterX;
            private double mEllipseCenterY;
            private double mArcVelocity;
            private double mTmpSinAngle;
            private double mTmpCosAngle;
            private boolean mVertical;
            private boolean mLinear;
            public static final int $stable = 8;
            @NotNull
            private static final String TAG = "Arc";
            @NotNull
            private static final double[] sOurPercent = new double[91];
            private static final double EPSILON = 0.001;

            public final double getMTime1() {
                return this.mTime1;
            }

            public final void setMTime1(double d) {
                this.mTime1 = d;
            }

            public final double getMTime2() {
                return this.mTime2;
            }

            public final void setMTime2(double d) {
                this.mTime2 = d;
            }

            public final boolean getMLinear() {
                return this.mLinear;
            }

            public final void setMLinear(boolean bl) {
                this.mLinear = bl;
            }

            public Arc(int mode, double t1, double t2, double x1, double y1, double x2, double y2) {
                boolean bl;
                double dx = x2 - x1;
                double dy = y2 - y1;
                switch (mode) {
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 5: {
                        if (dy < 0.0) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 4: {
                        if (dy > 0.0) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                this.mVertical = bl;
                this.mTime1 = t1;
                this.mTime2 = t2;
                this.mOneOverDeltaTime = 1.0 / (this.mTime2 - this.mTime1);
                if (3 == mode) {
                    this.mLinear = true;
                }
                if (this.mLinear || java.lang.Math.abs(dx) < 0.001 || java.lang.Math.abs(dy) < 0.001) {
                    this.mLinear = true;
                    this.mX1 = x1;
                    this.mX2 = x2;
                    this.mY1 = y1;
                    this.mY2 = y2;
                    this.mArcDistance = java.lang.Math.hypot(dy, dx);
                    this.mArcVelocity = this.mArcDistance * this.mOneOverDeltaTime;
                    this.mEllipseCenterX = dx / (this.mTime2 - this.mTime1);
                    this.mEllipseCenterY = dy / (this.mTime2 - this.mTime1);
                    return;
                }
                this.mLut = new double[101];
                this.mEllipseA = dx * (double)(this.mVertical ? -1 : 1);
                this.mEllipseB = dy * (double)(this.mVertical ? 1 : -1);
                this.mEllipseCenterX = this.mVertical ? x2 : x1;
                this.mEllipseCenterY = this.mVertical ? y1 : y2;
                this.buildTable(x1, y1, x2, y2);
                this.mArcVelocity = this.mArcDistance * this.mOneOverDeltaTime;
            }

            public final void setPoint(double time) {
                double percent = (this.mVertical ? this.mTime2 - time : time - this.mTime1) * this.mOneOverDeltaTime;
                double angle = 1.5707963267948966 * this.lookup(percent);
                this.mTmpSinAngle = java.lang.Math.sin(angle);
                this.mTmpCosAngle = java.lang.Math.cos(angle);
            }

            public final double getX() {
                return this.mEllipseCenterX + this.mEllipseA * this.mTmpSinAngle;
            }

            public final double getY() {
                return this.mEllipseCenterY + this.mEllipseB * this.mTmpCosAngle;
            }

            public final double getDX() {
                double vx = this.mEllipseA * this.mTmpCosAngle;
                double vy = -this.mEllipseB * this.mTmpSinAngle;
                double norm = this.mArcVelocity / java.lang.Math.hypot(vx, vy);
                return this.mVertical ? -vx * norm : vx * norm;
            }

            public final double getDY() {
                double vx = this.mEllipseA * this.mTmpCosAngle;
                double vy = -this.mEllipseB * this.mTmpSinAngle;
                double norm = this.mArcVelocity / java.lang.Math.hypot(vx, vy);
                return this.mVertical ? -vy * norm : vy * norm;
            }

            public final double getLinearX(double t) {
                double t2 = t;
                t2 = (t2 - this.mTime1) * this.mOneOverDeltaTime;
                return this.mX1 + t2 * (this.mX2 - this.mX1);
            }

            public final double getLinearY(double t) {
                double t2 = t;
                t2 = (t2 - this.mTime1) * this.mOneOverDeltaTime;
                return this.mY1 + t2 * (this.mY2 - this.mY1);
            }

            public final double getLinearDX(double t) {
                return this.mEllipseCenterX;
            }

            public final double getLinearDY(double t) {
                return this.mEllipseCenterY;
            }

            public final double lookup(double v) {
                if (v <= 0.0) {
                    return 0.0;
                }
                if (v >= 1.0) {
                    return 1.0;
                }
                Intrinsics.checkNotNull((Object)this.mLut);
                double pos = v * (double)(this.mLut.length - 1);
                int iv = (int)pos;
                double off = pos - (double)((int)pos);
                Intrinsics.checkNotNull((Object)this.mLut);
                double d = this.mLut[iv];
                Intrinsics.checkNotNull((Object)this.mLut);
                double d2 = this.mLut[iv + 1];
                Intrinsics.checkNotNull((Object)this.mLut);
                return d + off * (d2 - this.mLut[iv]);
            }

            private final void buildTable(double x1, double y1, double x2, double y2) {
                int i;
                double a = x2 - x1;
                double b = y1 - y2;
                double lx = 0.0;
                double ly = 0.0;
                double dist = 0.0;
                int n = sOurPercent.length;
                for (i = 0; i < n; ++i) {
                    double angle = Math.INSTANCE.toRadians(90.0 * (double)i / (double)(sOurPercent.length - 1));
                    double s = java.lang.Math.sin(angle);
                    double c = java.lang.Math.cos(angle);
                    double px = a * s;
                    double py = b * c;
                    if (i > 0) {
                        Arc.sOurPercent[i] = dist += java.lang.Math.hypot(px - lx, py - ly);
                    }
                    lx = px;
                    ly = py;
                }
                this.mArcDistance = dist;
                i = 0;
                n = sOurPercent.length;
                while (i < n) {
                    double[] angle = sOurPercent;
                    int n2 = i++;
                    angle[n2] = angle[n2] / dist;
                }
                Intrinsics.checkNotNull((Object)this.mLut);
                n = this.mLut.length;
                for (i = 0; i < n; ++i) {
                    double d = i;
                    Intrinsics.checkNotNull((Object)this.mLut);
                    double pos = d / (double)(this.mLut.length - 1);
                    int index = ArrayKt.binarySearch$default(sOurPercent, pos, 0, 0, 6, null);
                    if (index >= 0) {
                        Intrinsics.checkNotNull((Object)this.mLut);
                        this.mLut[i] = (double)index / (double)(sOurPercent.length - 1);
                        continue;
                    }
                    if (index == -1) {
                        Intrinsics.checkNotNull((Object)this.mLut);
                        this.mLut[i] = 0.0;
                        continue;
                    }
                    int p1 = -index - 2;
                    int p2 = -index - 1;
                    double ans = ((double)p1 + (pos - sOurPercent[p1]) / (sOurPercent[p2] - sOurPercent[p1])) / (double)(sOurPercent.length - 1);
                    Intrinsics.checkNotNull((Object)this.mLut);
                    this.mLut[i] = ans;
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/constraintlayout/core/motion/utils/ArcCurveFit$Companion$Arc$Companion;", "", "<init>", "()V", "TAG", "", "sOurPercent", "", "EPSILON", "", "compose"})
            public static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

