/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.parse;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParser;
import androidx.constraintlayout.core.parser.CLParsingException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00062\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/motion/parse/KeyParser;", "", "<init>", "()V", "Ids", "DataType", "Companion", "compose"})
@StabilityInferred(parameters=1)
public final class KeyParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/core/motion/parse/KeyParser$Companion;", "", "<init>", "()V", "parse", "Landroidx/constraintlayout/core/motion/utils/TypedBundle;", "str", "", "table", "Landroidx/constraintlayout/core/motion/parse/KeyParser$Ids;", "dtype", "Landroidx/constraintlayout/core/motion/parse/KeyParser$DataType;", "parseAttributes", "main", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        private final TypedBundle parse(String str, Ids table, DataType dtype) {
            TypedBundle bundle = new TypedBundle();
            try {
                CLObject parsedContent = CLParser.Companion.parse(str);
                int n = parsedContent.size();
                block8: for (int i = 0; i < n; ++i) {
                    CLElement cLElement = parsedContent.get(i);
                    Intrinsics.checkNotNull((Object)cLElement, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.parser.CLKey");
                    CLKey clkey = (CLKey)cLElement;
                    String type = clkey.content();
                    CLElement value = clkey.getValue();
                    int id = table.get(type);
                    if (id == -1) {
                        System.out.println((Object)("unknown type " + type));
                        continue;
                    }
                    switch (dtype.get(id)) {
                        case 4: {
                            bundle.add(id, value.getFloat());
                            System.out.println((Object)("parse " + type + " FLOAT_MASK > " + value.getFloat()));
                            continue block8;
                        }
                        case 8: {
                            bundle.add(id, value.content());
                            System.out.println((Object)("parse " + type + " STRING_MASK > " + value.content()));
                            continue block8;
                        }
                        case 2: {
                            bundle.add(id, value.getInt());
                            System.out.println((Object)("parse " + type + " INT_MASK > " + value.getInt()));
                            continue block8;
                        }
                        case 1: {
                            bundle.add(id, parsedContent.getBoolean(i));
                        }
                    }
                }
            }
            catch (CLParsingException e) {
                String string = e + "\n" + StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)ExceptionsKt.stackTraceToString((Throwable)e), (String)"[", (String)"   at ", (boolean)false, (int)4, null), (String)",", (String)"\n   at", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null);
                System.out.println((Object)string);
            }
            return bundle;
        }

        @NotNull
        public final TypedBundle parseAttributes(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            return this.parse(str, Companion::parseAttributes$lambda$0, Companion::parseAttributes$lambda$1);
        }

        public final void main() {
            String str = "{frame:22,\ntarget:'widget1',\neasing:'easeIn',\ncurveFit:'spline',\nprogress:0.3,\nalpha:0.2,\nelevation:0.7,\nrotationZ:23,\nrotationX:25.0,\nrotationY:27.0,\npivotX:15,\npivotY:17,\npivotTarget:'32',\npathRotate:23,\nscaleX:0.5,\nscaleY:0.7,\ntranslationX:5,\ntranslationY:7,\ntranslationZ:11,\n}";
            this.parseAttributes(str);
        }

        private static final int parseAttributes$lambda$0(String str) {
            return TypedValues.AttributesType.Companion.getId(str);
        }

        private static final int parseAttributes$lambda$1(int str) {
            return TypedValues.AttributesType.Companion.getType(str);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u00a6\u0002\u00a8\u0006\u0005"}, d2={"Landroidx/constraintlayout/core/motion/parse/KeyParser$DataType;", "", "get", "", "str", "compose"})
    private static interface DataType {
        public int get(int var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\u0013\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00a6\u0002\u00a8\u0006\u0006"}, d2={"Landroidx/constraintlayout/core/motion/parse/KeyParser$Ids;", "", "get", "", "str", "", "compose"})
    private static interface Ids {
        public int get(@Nullable String var1);
    }
}

