/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ext.IntegerKt;
import androidx.constraintlayout.core.ext.Math;
import androidx.constraintlayout.core.motion.MotionWidget;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004B!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\nB!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0003\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\f\u00a2\u0006\u0004\b\u0003\u0010\rB!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0003\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0004\b\u0003\u0010\u0011B!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0012B\u0019\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0000\u0012\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0014J\u0006\u0010#\u001a\u00020\u0000J\b\u0010$\u001a\u00020\u0006H\u0016J\u0006\u0010%\u001a\u00020\bJ\u0006\u0010&\u001a\u00020\u000eJ\u0006\u0010'\u001a\u00020\fJ\u0006\u0010(\u001a\u00020\bJ\u0006\u0010)\u001a\u00020\bJ\b\u0010*\u001a\u0004\u0018\u00010\u0006J\u0006\u0010+\u001a\u00020\u000eJ\u000e\u0010,\u001a\u00020-2\u0006\u0010\t\u001a\u00020\fJ\u000e\u0010.\u001a\u00020-2\u0006\u0010\t\u001a\u00020\u000eJ\u000e\u0010/\u001a\u00020-2\u0006\u0010\t\u001a\u00020\bJ\u000e\u00100\u001a\u00020-2\u0006\u0010\t\u001a\u00020\u0006J\u0006\u00101\u001a\u00020\bJ\u0006\u00102\u001a\u00020\fJ\u000e\u00103\u001a\u00020-2\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020-2\u0006\u0010\t\u001a\u000205J\u0010\u00107\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u0000J\u000e\u00106\u001a\u00020-2\u0006\u0010\t\u001a\u00020\u0001J\u000e\u00109\u001a\u00020\b2\u0006\u0010\t\u001a\u000205J\u0016\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020<2\u0006\u0010\t\u001a\u000205J\u000e\u0010=\u001a\u00020-2\u0006\u0010;\u001a\u00020<J\u0006\u0010>\u001a\u00020\u0006R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006@"}, d2={"Landroidx/constraintlayout/core/motion/CustomVariable;", "", "c", "<init>", "(Landroidx/constraintlayout/core/motion/CustomVariable;)V", "name", "", "type", "", "value", "(Ljava/lang/String;ILjava/lang/String;)V", "(Ljava/lang/String;II)V", "", "(Ljava/lang/String;IF)V", "", "(Ljava/lang/String;IZ)V", "attributeType", "(Ljava/lang/String;I)V", "(Ljava/lang/String;ILjava/lang/Object;)V", "source", "(Landroidx/constraintlayout/core/motion/CustomVariable;Ljava/lang/Object;)V", "mName", "getMName", "()Ljava/lang/String;", "setMName", "(Ljava/lang/String;)V", "mType", "mIntegerValue", "mFloatValue", "mStringValue", "mBooleanValue", "getMBooleanValue", "()Z", "setMBooleanValue", "(Z)V", "copy", "toString", "getType", "getBooleanValue", "getFloatValue", "getColorValue", "getIntegerValue", "getStringValue", "isContinuous", "setFloatValue", "", "setBooleanValue", "setIntValue", "setStringValue", "numberOfInterpolatedValues", "getValueToInterpolate", "getValuesToInterpolate", "ret", "", "setValue", "diff", "customAttribute", "getInterpolatedColor", "setInterpolatedValue", "view", "Landroidx/constraintlayout/core/motion/MotionWidget;", "applyToWidget", "getName", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class CustomVariable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String mName;
    private int mType;
    private int mIntegerValue;
    private float mFloatValue;
    @Nullable
    private String mStringValue;
    private boolean mBooleanValue;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "TransitionLayout";

    @NotNull
    public final String getMName() {
        return this.mName;
    }

    public final void setMName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mName = string;
    }

    public final boolean getMBooleanValue() {
        return this.mBooleanValue;
    }

    public final void setMBooleanValue(boolean bl) {
        this.mBooleanValue = bl;
    }

    @NotNull
    public final CustomVariable copy() {
        return new CustomVariable(this);
    }

    public CustomVariable(@NotNull CustomVariable c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.mIntegerValue = Integer.MIN_VALUE;
        this.mFloatValue = Float.NaN;
        this.mName = c.mName;
        this.mType = c.mType;
        this.mIntegerValue = c.mIntegerValue;
        this.mFloatValue = c.mFloatValue;
        this.mStringValue = c.mStringValue;
        this.mBooleanValue = c.mBooleanValue;
    }

    public CustomVariable(@NotNull String name, int type, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mIntegerValue = Integer.MIN_VALUE;
        this.mFloatValue = Float.NaN;
        this.mName = name;
        this.mType = type;
        this.mStringValue = value;
    }

    public CustomVariable(@NotNull String name, int type, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.mIntegerValue = Integer.MIN_VALUE;
        this.mFloatValue = Float.NaN;
        this.mName = name;
        this.mType = type;
        if (type == 901) {
            this.mFloatValue = value;
        } else {
            this.mIntegerValue = value;
        }
    }

    public CustomVariable(@NotNull String name, int type, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.mIntegerValue = Integer.MIN_VALUE;
        this.mFloatValue = Float.NaN;
        this.mName = name;
        this.mType = type;
        this.mFloatValue = value;
    }

    public CustomVariable(@NotNull String name, int type, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.mIntegerValue = Integer.MIN_VALUE;
        this.mFloatValue = Float.NaN;
        this.mName = name;
        this.mType = type;
        this.mBooleanValue = value;
    }

    @NotNull
    public String toString() {
        String str = this.mName + ":";
        switch (this.mType) {
            case 900: {
                return str + this.mIntegerValue;
            }
            case 901: {
                return str + this.mFloatValue;
            }
            case 902: {
                return str + Companion.colorString(this.mIntegerValue);
            }
            case 903: {
                return str + this.mStringValue;
            }
            case 904: {
                return str + this.mBooleanValue;
            }
            case 905: {
                return str + this.mFloatValue;
            }
        }
        return str + "????";
    }

    public final int getType() {
        return this.mType;
    }

    public final boolean getBooleanValue() {
        return this.mBooleanValue;
    }

    public final float getFloatValue() {
        return this.mFloatValue;
    }

    public final int getColorValue() {
        return this.mIntegerValue;
    }

    public final int getIntegerValue() {
        return this.mIntegerValue;
    }

    @Nullable
    public final String getStringValue() {
        return this.mStringValue;
    }

    public final boolean isContinuous() {
        boolean bl;
        switch (this.mType) {
            case 903: 
            case 904: 
            case 906: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public final void setFloatValue(float value) {
        this.mFloatValue = value;
    }

    public final void setBooleanValue(boolean value) {
        this.mBooleanValue = value;
    }

    public final void setIntValue(int value) {
        this.mIntegerValue = value;
    }

    public final void setStringValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mStringValue = value;
    }

    public final int numberOfInterpolatedValues() {
        return this.mType == 902 ? 4 : 1;
    }

    public final float getValueToInterpolate() {
        switch (this.mType) {
            case 900: {
                return this.mIntegerValue;
            }
            case 901: {
                return this.mFloatValue;
            }
            case 902: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 904: {
                return this.mBooleanValue ? 1.0f : 0.0f;
            }
            case 905: {
                return this.mFloatValue;
            }
        }
        return Float.NaN;
    }

    public final void getValuesToInterpolate(@NotNull float[] ret) {
        Intrinsics.checkNotNullParameter((Object)ret, (String)"ret");
        switch (this.mType) {
            case 900: {
                ret[0] = this.mIntegerValue;
                break;
            }
            case 901: {
                ret[0] = this.mFloatValue;
                break;
            }
            case 902: {
                int a = 0xFF & this.mIntegerValue >> 24;
                int r = 0xFF & this.mIntegerValue >> 16;
                int g = 0xFF & this.mIntegerValue >> 8;
                int b = 0xFF & this.mIntegerValue;
                float f_r = (float)Math.INSTANCE.pow((float)r / 255.0f, 2.2);
                float f_g = (float)Math.INSTANCE.pow((float)g / 255.0f, 2.2);
                float f_b = (float)Math.INSTANCE.pow((float)b / 255.0f, 2.2);
                ret[0] = f_r;
                ret[1] = f_g;
                ret[2] = f_b;
                ret[3] = (float)a / 255.0f;
                break;
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 904: {
                ret[0] = this.mBooleanValue ? 1 : 0;
                break;
            }
            case 905: {
                ret[0] = this.mFloatValue;
            }
        }
    }

    public final void setValue(@NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (this.mType) {
            case 900: 
            case 906: {
                this.mIntegerValue = (int)value[0];
                break;
            }
            case 901: 
            case 905: {
                this.mFloatValue = value[0];
                break;
            }
            case 902: {
                float f_r = value[0];
                float f_g = value[1];
                float f_b = value[2];
                int r = 0xFF & IntegerKt.roundToIntOrZero((float)java.lang.Math.pow(f_r, 0.5) * 255.0f);
                int g = 0xFF & IntegerKt.roundToIntOrZero((float)java.lang.Math.pow(f_g, 0.5) * 255.0f);
                int b = 0xFF & IntegerKt.roundToIntOrZero((float)java.lang.Math.pow(f_b, 0.5) * 255.0f);
                int a = 0xFF & IntegerKt.roundToIntOrZero(value[3] * 255.0f);
                this.mIntegerValue = a << 24 | r << 16 | g << 8 | b;
                break;
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 904: {
                this.mBooleanValue = (double)value[0] > 0.5;
            }
        }
    }

    public final boolean diff(@Nullable CustomVariable customAttribute) {
        if (customAttribute == null || this.mType != customAttribute.mType) {
            return false;
        }
        switch (this.mType) {
            case 900: 
            case 906: {
                return this.mIntegerValue == customAttribute.mIntegerValue;
            }
            case 901: {
                return this.mFloatValue == customAttribute.mFloatValue;
            }
            case 902: {
                return this.mIntegerValue == customAttribute.mIntegerValue;
            }
            case 903: {
                return this.mIntegerValue == customAttribute.mIntegerValue;
            }
            case 904: {
                return this.mBooleanValue == customAttribute.mBooleanValue;
            }
            case 905: {
                return this.mFloatValue == customAttribute.mFloatValue;
            }
        }
        return false;
    }

    public CustomVariable(@NotNull String name, int attributeType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.mIntegerValue = Integer.MIN_VALUE;
        this.mFloatValue = Float.NaN;
        this.mName = name;
        this.mType = attributeType;
    }

    public CustomVariable(@NotNull String name, int attributeType, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mIntegerValue = Integer.MIN_VALUE;
        this.mFloatValue = Float.NaN;
        this.mName = name;
        this.mType = attributeType;
        this.setValue(value);
    }

    public CustomVariable(@NotNull CustomVariable source, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mIntegerValue = Integer.MIN_VALUE;
        this.mFloatValue = Float.NaN;
        this.mName = source.mName;
        this.mType = source.mType;
        this.setValue(value);
    }

    public final void setValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (this.mType) {
            case 900: 
            case 906: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case 901: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
            case 902: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case 903: {
                this.mStringValue = (String)value;
                break;
            }
            case 904: {
                this.mBooleanValue = (Boolean)value;
                break;
            }
            case 905: {
                this.mFloatValue = ((Float)value).floatValue();
            }
        }
    }

    public final int getInterpolatedColor(@NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int r = CustomVariable.Companion.clamp((int)((float)java.lang.Math.pow(value[0], 0.45454545454545453) * 255.0f));
        int g = CustomVariable.Companion.clamp((int)((float)java.lang.Math.pow(value[1], 0.45454545454545453) * 255.0f));
        int b = CustomVariable.Companion.clamp((int)((float)java.lang.Math.pow(value[2], 0.45454545454545453) * 255.0f));
        int a = CustomVariable.Companion.clamp((int)(value[3] * 255.0f));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public final void setInterpolatedValue(@NotNull MotionWidget view, @NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (this.mType) {
            case 900: {
                view.setCustomAttribute(this.mName, this.mType, (int)value[0]);
                break;
            }
            case 902: {
                int r = CustomVariable.Companion.clamp((int)((float)Math.INSTANCE.pow(value[0], 0.45454545454545453) * 255.0f));
                int g = CustomVariable.Companion.clamp((int)((float)Math.INSTANCE.pow(value[1], 0.45454545454545453) * 255.0f));
                int b = CustomVariable.Companion.clamp((int)((float)Math.INSTANCE.pow(value[2], 0.45454545454545453) * 255.0f));
                int a = CustomVariable.Companion.clamp((int)(value[3] * 255.0f));
                int color = a << 24 | r << 16 | g << 8 | b;
                view.setCustomAttribute(this.mName, this.mType, color);
                break;
            }
            case 903: 
            case 906: {
                throw new RuntimeException("unable to interpolate " + this.mName);
            }
            case 904: {
                view.setCustomAttribute(this.mName, this.mType, value[0] > 0.5f);
                break;
            }
            case 901: 
            case 905: {
                view.setCustomAttribute(this.mName, this.mType, value[0]);
            }
        }
    }

    public final void applyToWidget(@NotNull MotionWidget view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        switch (this.mType) {
            case 900: 
            case 902: 
            case 906: {
                view.setCustomAttribute(this.mName, this.mType, this.mIntegerValue);
                break;
            }
            case 903: {
                view.setCustomAttribute(this.mName, this.mType, String.valueOf(this.mStringValue));
                break;
            }
            case 904: {
                view.setCustomAttribute(this.mName, this.mType, this.mBooleanValue);
                break;
            }
            case 901: 
            case 905: {
                view.setCustomAttribute(this.mName, this.mType, this.mFloatValue);
            }
        }
    }

    @NotNull
    public final String getName() {
        return this.mName;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J&\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/constraintlayout/core/motion/CustomVariable$Companion;", "", "<init>", "()V", "TAG", "", "colorString", "v", "", "hsvToRgb", "hue", "", "saturation", "value", "clamp", "c", "rgbaTocColor", "r", "g", "b", "a", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String colorString(int v) {
            String str = "00000000" + HexExtensionsKt.toHexString$default((int)v, null, (int)1, null);
            String string = str.substring(str.length() - 8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return "#" + string;
        }

        public final int hsvToRgb(float hue, float saturation, float value) {
            int h = (int)(hue * (float)6);
            float f = hue * (float)6 - (float)h;
            int p = (int)(0.5f + (float)255 * value * (1.0f - saturation));
            int q = (int)(0.5f + (float)255 * value * (1.0f - f * saturation));
            int t = (int)(0.5f + (float)255 * value * (1.0f - (1.0f - f) * saturation));
            int v = (int)(0.5f + (float)255 * value);
            switch (h) {
                case 0: {
                    return 0xFF000000 | (v << 16) + (t << 8) + p;
                }
                case 1: {
                    return 0xFF000000 | (q << 16) + (v << 8) + p;
                }
                case 2: {
                    return 0xFF000000 | (p << 16) + (v << 8) + t;
                }
                case 3: {
                    return 0xFF000000 | (p << 16) + (q << 8) + v;
                }
                case 4: {
                    return 0xFF000000 | (t << 16) + (p << 8) + v;
                }
                case 5: {
                    return 0xFF000000 | (v << 16) + (p << 8) + q;
                }
            }
            return 0;
        }

        private final int clamp(int c) {
            int c2 = c;
            int n = 255;
            c2 &= ~(c2 >> 31);
            c2 -= n;
            c2 &= c2 >> 31;
            return c2 += n;
        }

        public final int rgbaTocColor(float r, float g, float b, float a) {
            int ir = this.clamp((int)(r * 255.0f));
            int ig = this.clamp((int)(g * 255.0f));
            int ib = this.clamp((int)(b * 255.0f));
            int ia = this.clamp((int)(a * 255.0f));
            return ia << 24 | ir << 16 | ig << 8 | ib;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

