/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.dsl.Chain;
import androidx.constraintlayout.core.dsl.Constraint;
import androidx.constraintlayout.core.dsl.Helper;
import androidx.constraintlayout.core.dsl.Ref;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0007J\n\u0010\r\u001a\u00060\tR\u00020\u0000J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0012J\u001c\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\n\u0010\u0016\u001a\u00060\tR\u00020\u0000J\u0014\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0012J\u001c\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\n\u0010\u0018\u001a\u00060\tR\u00020\u0000J\u0014\u0010\u0019\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0012J\u001c\u0010\u0019\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0019\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\n\u0010\u001a\u001a\u00060\tR\u00020\u0000J\u0014\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0012J\u001c\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/constraintlayout/core/dsl/HChain;", "Landroidx/constraintlayout/core/dsl/Chain;", "name", "", "<init>", "(Ljava/lang/String;)V", "config", "(Ljava/lang/String;Ljava/lang/String;)V", "mLeft", "Landroidx/constraintlayout/core/dsl/HChain$HAnchor;", "mRight", "mStart", "mEnd", "getLeft", "linkToLeft", "", "anchor", "Landroidx/constraintlayout/core/dsl/Constraint$HAnchor;", "Landroidx/constraintlayout/core/dsl/Constraint;", "margin", "", "goneMargin", "getRight", "linkToRight", "getStart", "linkToStart", "getEnd", "linkToEnd", "HAnchor", "compose"})
@StabilityInferred(parameters=1)
public final class HChain
extends Chain {
    @NotNull
    private final HAnchor mLeft;
    @NotNull
    private final HAnchor mRight;
    @NotNull
    private final HAnchor mStart;
    @NotNull
    private final HAnchor mEnd;
    public static final int $stable;

    public HChain(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.mLeft = new HAnchor(Constraint.HSide.LEFT);
        this.mRight = new HAnchor(Constraint.HSide.RIGHT);
        this.mStart = new HAnchor(Constraint.HSide.START);
        this.mEnd = new HAnchor(Constraint.HSide.END);
        String string = Helper.getTypeMap().get((Object)Helper.Type.HORIZONTAL_CHAIN);
        Intrinsics.checkNotNull((Object)string);
        this.setMType(new Helper.HelperType(string));
    }

    public HChain(@NotNull String name, @NotNull String config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(name);
        this.mLeft = new HAnchor(Constraint.HSide.LEFT);
        this.mRight = new HAnchor(Constraint.HSide.RIGHT);
        this.mStart = new HAnchor(Constraint.HSide.START);
        this.mEnd = new HAnchor(Constraint.HSide.END);
        this.setMConfig(config);
        String string = Helper.getTypeMap().get((Object)Helper.Type.HORIZONTAL_CHAIN);
        Intrinsics.checkNotNull((Object)string);
        this.setMType(new Helper.HelperType(string));
        Map<String, String> map = this.convertConfigToMap();
        Intrinsics.checkNotNull(map);
        this.setConfigMap(MapsKt.toMutableMap(map));
        Map<String, String> map2 = this.getConfigMap();
        Intrinsics.checkNotNull(map2);
        if (map2.containsKey("contains")) {
            Map<String, String> map3 = this.getConfigMap();
            Intrinsics.checkNotNull(map3);
            Ref.Companion.addStringToReferences(map3.get("contains"), this.getReferences());
        }
    }

    @NotNull
    public final HAnchor getLeft() {
        return this.mLeft;
    }

    public final void linkToLeft(@Nullable Constraint.HAnchor anchor) {
        this.linkToLeft(anchor, 0);
    }

    public final void linkToLeft(@Nullable Constraint.HAnchor anchor, int margin) {
        this.linkToLeft(anchor, margin, Integer.MIN_VALUE);
    }

    public final void linkToLeft(@Nullable Constraint.HAnchor anchor, int margin, int goneMargin) {
        this.mLeft.setMConnection(anchor);
        this.mLeft.setMMargin(margin);
        this.mLeft.setMGoneMargin(goneMargin);
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("left", this.mLeft.toString());
    }

    @NotNull
    public final HAnchor getRight() {
        return this.mRight;
    }

    public final void linkToRight(@Nullable Constraint.HAnchor anchor) {
        this.linkToRight(anchor, 0);
    }

    public final void linkToRight(@Nullable Constraint.HAnchor anchor, int margin) {
        this.linkToRight(anchor, margin, Integer.MIN_VALUE);
    }

    public final void linkToRight(@Nullable Constraint.HAnchor anchor, int margin, int goneMargin) {
        this.mRight.setMConnection(anchor);
        this.mRight.setMMargin(margin);
        this.mRight.setMGoneMargin(goneMargin);
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("right", this.mRight.toString());
    }

    @NotNull
    public final HAnchor getStart() {
        return this.mStart;
    }

    public final void linkToStart(@Nullable Constraint.HAnchor anchor) {
        this.linkToStart(anchor, 0);
    }

    public final void linkToStart(@Nullable Constraint.HAnchor anchor, int margin) {
        this.linkToStart(anchor, margin, Integer.MIN_VALUE);
    }

    public final void linkToStart(@Nullable Constraint.HAnchor anchor, int margin, int goneMargin) {
        this.mStart.setMConnection(anchor);
        this.mStart.setMMargin(margin);
        this.mStart.setMGoneMargin(goneMargin);
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("start", this.mStart.toString());
    }

    @NotNull
    public final HAnchor getEnd() {
        return this.mEnd;
    }

    public final void linkToEnd(@Nullable Constraint.HAnchor anchor) {
        this.linkToEnd(anchor, 0);
    }

    public final void linkToEnd(@Nullable Constraint.HAnchor anchor, int margin) {
        this.linkToEnd(anchor, margin, Integer.MIN_VALUE);
    }

    public final void linkToEnd(@Nullable Constraint.HAnchor anchor, int margin, int goneMargin) {
        this.mEnd.setMConnection(anchor);
        this.mEnd.setMMargin(margin);
        this.mEnd.setMGoneMargin(goneMargin);
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("end", this.mEnd.toString());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/dsl/HChain$HAnchor;", "Landroidx/constraintlayout/core/dsl/Chain$Anchor;", "Landroidx/constraintlayout/core/dsl/Chain;", "side", "Landroidx/constraintlayout/core/dsl/Constraint$HSide;", "<init>", "(Landroidx/constraintlayout/core/dsl/HChain;Landroidx/constraintlayout/core/dsl/Constraint$HSide;)V", "compose"})
    public final class HAnchor
    extends Chain.Anchor {
        public HAnchor(Constraint.HSide side) {
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            super(Constraint.Side.valueOf(side.name()));
        }
    }
}

