/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.dsl.Constraint;
import androidx.constraintlayout.core.dsl.Helper;
import androidx.constraintlayout.core.dsl.Ref;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0003J\u0010\u0010\u0016\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000bj\n\u0012\u0006\u0012\u0004\u0018\u00010\n`\tX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Landroidx/constraintlayout/core/dsl/Chain;", "Landroidx/constraintlayout/core/dsl/Helper;", "name", "", "<init>", "(Ljava/lang/String;)V", "mStyle", "Landroidx/constraintlayout/core/dsl/Chain$Style;", "references", "Lkotlin/collections/ArrayList;", "Landroidx/constraintlayout/core/dsl/Ref;", "Ljava/util/ArrayList;", "getReferences", "()Ljava/util/ArrayList;", "setReferences", "(Ljava/util/ArrayList;)V", "Ljava/util/ArrayList;", "getStyle", "setStyle", "", "style", "referencesToString", "addReference", "ref", "Style", "Anchor", "Companion", "compose"})
@StabilityInferred(parameters=0)
public class Chain
extends Helper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Style mStyle;
    @NotNull
    private ArrayList<Ref> references;
    public static final int $stable = 8;
    @NotNull
    private static final Map<Style, String> styleMap;

    public Chain(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, new Helper.HelperType(""));
        this.references = new ArrayList();
    }

    @NotNull
    protected final ArrayList<Ref> getReferences() {
        return this.references;
    }

    protected final void setReferences(@NotNull ArrayList<Ref> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.references = arrayList;
    }

    @Nullable
    public final Style getStyle() {
        return this.mStyle;
    }

    public final void setStyle(@NotNull Style style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        this.mStyle = style;
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        String string = styleMap.get((Object)style);
        Intrinsics.checkNotNull((Object)string);
        map.put("style", string);
    }

    @NotNull
    public final String referencesToString() {
        if (this.references.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("[");
        Iterator<Ref> iterator = this.references.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Ref> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Ref ref = iterator2.next();
            builder.append(String.valueOf(ref));
        }
        builder.append("]");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Chain addReference(@Nullable Ref ref) {
        this.references.add(ref);
        Map<String, String> map = this.getConfigMap();
        Intrinsics.checkNotNull(map);
        map.put("contains", this.referencesToString());
        return this;
    }

    @NotNull
    public final Chain addReference(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this.addReference(Ref.Companion.parseStringToRef(ref));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)Style.SPREAD), (Object)"'spread'"), TuplesKt.to((Object)((Object)Style.SPREAD_INSIDE), (Object)"'spread_inside'"), TuplesKt.to((Object)((Object)Style.PACKED), (Object)"'packed'")};
        styleMap = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0096\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0017\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001dj\u0002`\u001c\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u0006 "}, d2={"Landroidx/constraintlayout/core/dsl/Chain$Anchor;", "", "side", "Landroidx/constraintlayout/core/dsl/Constraint$Side;", "<init>", "(Landroidx/constraintlayout/core/dsl/Chain;Landroidx/constraintlayout/core/dsl/Constraint$Side;)V", "mSide", "mConnection", "Landroidx/constraintlayout/core/dsl/Constraint$Anchor;", "Landroidx/constraintlayout/core/dsl/Constraint;", "getMConnection", "()Landroidx/constraintlayout/core/dsl/Constraint$Anchor;", "setMConnection", "(Landroidx/constraintlayout/core/dsl/Constraint$Anchor;)V", "mMargin", "", "getMMargin", "()I", "setMMargin", "(I)V", "mGoneMargin", "getMGoneMargin", "setMGoneMargin", "getId", "", "build", "", "builder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/StringBuilder;)V", "toString", "compose"})
    public class Anchor {
        @NotNull
        private final Constraint.Side mSide;
        @Nullable
        private Constraint.Anchor mConnection;
        private int mMargin;
        private int mGoneMargin;

        public Anchor(Constraint.Side side) {
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            this.mSide = side;
            this.mGoneMargin = Integer.MIN_VALUE;
        }

        @Nullable
        public final Constraint.Anchor getMConnection() {
            return this.mConnection;
        }

        public final void setMConnection(@Nullable Constraint.Anchor anchor) {
            this.mConnection = anchor;
        }

        public final int getMMargin() {
            return this.mMargin;
        }

        public final void setMMargin(int n) {
            this.mMargin = n;
        }

        public final int getMGoneMargin() {
            return this.mGoneMargin;
        }

        public final void setMGoneMargin(int n) {
            this.mGoneMargin = n;
        }

        @NotNull
        public final String getId() {
            return Chain.this.getName();
        }

        public final void build(@NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (this.mConnection != null) {
                String string = this.mSide.toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                builder.append(string).append(":").append(this).append(",\n");
            }
        }

        @NotNull
        public String toString() {
            StringBuilder ret = new StringBuilder("[");
            if (this.mConnection != null) {
                StringBuilder stringBuilder = ret.append("'");
                Constraint.Anchor anchor = this.mConnection;
                Intrinsics.checkNotNull((Object)anchor);
                StringBuilder stringBuilder2 = stringBuilder.append(anchor.getId()).append("',").append("'");
                Constraint.Anchor anchor2 = this.mConnection;
                Intrinsics.checkNotNull((Object)anchor2);
                String string = anchor2.getMSide().toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                stringBuilder2.append(string).append("'");
            }
            if (this.mMargin != 0) {
                ret.append(",").append(this.mMargin);
            }
            if (this.mGoneMargin != Integer.MIN_VALUE) {
                StringBuilder stringBuilder = this.mMargin == 0 ? ret.append(",0,").append(this.mGoneMargin) : ret.append(",").append(this.mGoneMargin);
            }
            ret.append("]");
            String string = ret.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/constraintlayout/core/dsl/Chain$Companion;", "", "<init>", "()V", "styleMap", "", "Landroidx/constraintlayout/core/dsl/Chain$Style;", "", "getStyleMap", "()Ljava/util/Map;", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Map<Style, String> getStyleMap() {
            return styleMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/dsl/Chain$Style;", "", "<init>", "(Ljava/lang/String;I)V", "PACKED", "SPREAD", "SPREAD_INSIDE", "compose"})
    public static final class Style
    extends Enum<Style> {
        public static final /* enum */ Style PACKED = new Style();
        public static final /* enum */ Style SPREAD = new Style();
        public static final /* enum */ Style SPREAD_INSIDE = new Style();
        private static final /* synthetic */ Style[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Style[] values() {
            return (Style[])$VALUES.clone();
        }

        public static Style valueOf(String value) {
            return Enum.valueOf(Style.class, value);
        }

        @NotNull
        public static EnumEntries<Style> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = styleArray = new Style[]{Style.PACKED, Style.SPREAD, Style.SPREAD_INSIDE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

