/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00062\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/Pools;", "", "<init>", "()V", "Pool", "SimplePool", "Companion", "compose"})
@StabilityInferred(parameters=1)
public final class Pools {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final boolean DEBUG = false;

    private Pools() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/constraintlayout/core/Pools$Companion;", "", "<init>", "()V", "DEBUG", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u000f\u0010\u0003\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\bJ%\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\f2\u0006\u0010\r\u001a\u00020\u000eH&\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Landroidx/constraintlayout/core/Pools$Pool;", "T", "", "acquire", "()Ljava/lang/Object;", "release", "", "instance", "(Ljava/lang/Object;)Z", "releaseAll", "", "variables", "", "count", "", "([Ljava/lang/Object;I)V", "compose"})
    public static interface Pool<T> {
        @Nullable
        public T acquire();

        public boolean release(T var1);

        public void releaseAll(@NotNull T[] var1, int var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/constraintlayout/core/Pools$SimplePool;", "T", "Landroidx/constraintlayout/core/Pools$Pool;", "maxPoolSize", "", "<init>", "(I)V", "mPool", "", "", "[Ljava/lang/Object;", "mPoolSize", "acquire", "()Ljava/lang/Object;", "release", "", "instance", "(Ljava/lang/Object;)Z", "releaseAll", "", "variables", "count", "([Ljava/lang/Object;I)V", "isInPool", "compose"})
    @StabilityInferred(parameters=0)
    public static final class SimplePool<T>
    implements Pool<T> {
        @NotNull
        private Object[] mPool;
        private int mPoolSize;
        public static final int $stable = 8;

        public SimplePool(int maxPoolSize) {
            if (maxPoolSize <= 0) {
                throw new IllegalArgumentException("The max pool size must be > 0");
            }
            this.mPool = new Object[maxPoolSize];
        }

        @Override
        @Nullable
        public T acquire() {
            if (this.mPoolSize > 0) {
                int lastPooledIndex = this.mPoolSize - 1;
                Object instance = this.mPool[lastPooledIndex];
                this.mPool[lastPooledIndex] = null;
                int n = this.mPoolSize;
                this.mPoolSize = n + -1;
                return (T)instance;
            }
            return null;
        }

        @Override
        public boolean release(T instance) {
            if (this.mPoolSize < this.mPool.length) {
                this.mPool[this.mPoolSize] = instance;
                int n = this.mPoolSize;
                this.mPoolSize = n + 1;
                return true;
            }
            return false;
        }

        @Override
        public void releaseAll(@NotNull T[] variables, int count) {
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            int count2 = count;
            if (count2 > variables.length) {
                count2 = variables.length;
            }
            int n = count2;
            for (int i = 0; i < n; ++i) {
                T instance = variables[i];
                if (this.mPoolSize >= this.mPool.length) continue;
                this.mPool[this.mPoolSize] = instance;
                int n2 = this.mPoolSize;
                this.mPoolSize = n2 + 1;
            }
        }

        private final boolean isInPool(T instance) {
            int n = this.mPoolSize;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)this.mPool[i], instance)) continue;
                return true;
            }
            return false;
        }
    }
}

