/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Flow;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.WidgetGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/Grouping;", "", "()V", "Companion", "compose"})
@StabilityInferred(parameters=1)
public final class Grouping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_GROUPING = false;
    private static final boolean FORCE_USE = true;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\b0\u000ej\b\u0012\u0004\u0012\u00020\b`\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ*\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\b0\u000ej\b\u0012\u0004\u0012\u00020\b`\u000f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J&\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/Grouping$Companion;", "", "()V", "DEBUG", "", "DEBUG_GROUPING", "FORCE_USE", "findDependents", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup;", "constraintWidget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "orientation", "", "list", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "group", "findGroup", "horizontalDependencyLists", "groupId", "simpleSolvingPass", "layout", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "measurer", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measurer;", "validInGroup", "layoutHorizontal", "Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;", "layoutVertical", "widgetHorizontal", "widgetVertical", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean validInGroup(@NotNull ConstraintWidget.DimensionBehaviour layoutHorizontal, @NotNull ConstraintWidget.DimensionBehaviour layoutVertical, @NotNull ConstraintWidget.DimensionBehaviour widgetHorizontal, @NotNull ConstraintWidget.DimensionBehaviour widgetVertical) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutHorizontal), (String)"layoutHorizontal");
            Intrinsics.checkNotNullParameter((Object)((Object)layoutVertical), (String)"layoutVertical");
            Intrinsics.checkNotNullParameter((Object)((Object)widgetHorizontal), (String)"widgetHorizontal");
            Intrinsics.checkNotNullParameter((Object)((Object)widgetVertical), (String)"widgetVertical");
            boolean fixedHorizontal = widgetHorizontal == ConstraintWidget.DimensionBehaviour.FIXED || widgetHorizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || widgetHorizontal == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && layoutHorizontal != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            boolean fixedVertical = widgetVertical == ConstraintWidget.DimensionBehaviour.FIXED || widgetVertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || widgetVertical == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && layoutVertical != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            return fixedHorizontal || fixedVertical;
        }

        public final boolean simpleSolvingPass(@NotNull ConstraintWidgetContainer layout, @Nullable BasicMeasure.Measurer measurer) {
            WidgetGroup list;
            Iterator<WidgetGroup> iterator;
            WidgetGroup picked;
            ConstraintAnchor center;
            ConstraintAnchor bottom;
            ConstraintAnchor baseline;
            ConstraintAnchor top;
            Object first;
            ConstraintAnchor center2;
            ConstraintAnchor right;
            WidgetGroup group;
            Iterator<ConstraintAnchor> barrier;
            Guideline guideline;
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            ArrayList<ConstraintWidget> children = layout.getChildren();
            int count = children.size();
            ArrayList<Guideline> verticalGuidelines = null;
            ArrayList<Guideline> horizontalGuidelines = null;
            ArrayList<Object> horizontalBarriers = null;
            ArrayList<Barrier> verticalBarriers = null;
            ArrayList<ConstraintWidget> isolatedHorizontalChildren = null;
            ArrayList<ConstraintWidget> isolatedVerticalChildren = null;
            for (int i2 = 0; i2 < count; ++i2) {
                ConstraintWidget child;
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i2), (String)"get(...)");
                if (!this.validInGroup(layout.getHorizontalDimensionBehaviour(), layout.getVerticalDimensionBehaviour(), child.getHorizontalDimensionBehaviour(), child.getVerticalDimensionBehaviour())) {
                    return false;
                }
                if (!(child instanceof Flow)) continue;
                return false;
            }
            if (layout.getMMetrics() != null) {
                Metrics metrics = layout.getMMetrics();
                Intrinsics.checkNotNull((Object)metrics);
                Metrics i2 = metrics;
                long child = i2.getGrouping();
                i2.setGrouping(child + 1L);
            }
            for (int i = 0; i < count; ++i) {
                ConstraintWidget child;
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                if (!this.validInGroup(layout.getHorizontalDimensionBehaviour(), layout.getVerticalDimensionBehaviour(), child.getHorizontalDimensionBehaviour(), child.getVerticalDimensionBehaviour())) {
                    ConstraintWidgetContainer.Companion.measure(0, child, measurer, layout.getMMeasure(), BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                }
                if (child instanceof Guideline) {
                    Guideline guideline2 = (Guideline)child;
                    if (guideline2.getOrientation() == 0) {
                        if (horizontalGuidelines == null) {
                            horizontalGuidelines = new ArrayList<Guideline>();
                        }
                        horizontalGuidelines.add(guideline2);
                    }
                    if (guideline2.getOrientation() == 1) {
                        if (verticalGuidelines == null) {
                            verticalGuidelines = new ArrayList<Guideline>();
                        }
                        verticalGuidelines.add(guideline2);
                    }
                }
                if (child instanceof HelperWidget) {
                    if (child instanceof Barrier) {
                        Barrier barrier2 = (Barrier)child;
                        if (barrier2.getOrientation() == 0) {
                            if (horizontalBarriers == null) {
                                horizontalBarriers = new ArrayList();
                            }
                            horizontalBarriers.add(barrier2);
                        }
                        if (barrier2.getOrientation() == 1) {
                            if (verticalBarriers == null) {
                                verticalBarriers = new ArrayList();
                            }
                            verticalBarriers.add(barrier2);
                        }
                    } else {
                        ConstraintWidget helper = child;
                        if (horizontalBarriers == null) {
                            horizontalBarriers = new ArrayList<Object>();
                        }
                        horizontalBarriers.add(helper);
                        if (verticalBarriers == null) {
                            verticalBarriers = new ArrayList<Barrier>();
                        }
                        verticalBarriers.add((Barrier)helper);
                    }
                }
                if (child.getMLeft().getMTarget() == null && child.getMRight().getMTarget() == null && !(child instanceof Guideline) && !(child instanceof Barrier)) {
                    if (isolatedHorizontalChildren == null) {
                        isolatedHorizontalChildren = new ArrayList<ConstraintWidget>();
                    }
                    isolatedHorizontalChildren.add(child);
                }
                if (child.getMTop().getMTarget() != null || child.getMBottom().getMTarget() != null || child.getMBaseline().getMTarget() != null || child instanceof Guideline || child instanceof Barrier) continue;
                if (isolatedVerticalChildren == null) {
                    isolatedVerticalChildren = new ArrayList<ConstraintWidget>();
                }
                isolatedVerticalChildren.add(child);
            }
            ArrayList<WidgetGroup> allDependencyLists = new ArrayList<WidgetGroup>();
            ArrayList<WidgetGroup> dependencyLists = allDependencyLists;
            if (verticalGuidelines != null) {
                for (Object e : verticalGuidelines) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    guideline = (Guideline)e;
                    this.findDependents(guideline, 0, dependencyLists, null);
                }
            }
            if (horizontalBarriers != null) {
                for (Object e : horizontalBarriers) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    barrier = (HelperWidget)e;
                    group = this.findDependents((ConstraintWidget)((Object)barrier), 0, dependencyLists, null);
                    ((HelperWidget)((Object)barrier)).addDependents(dependencyLists, 0, group);
                    WidgetGroup widgetGroup = group;
                    Intrinsics.checkNotNull((Object)widgetGroup);
                    widgetGroup.cleanup(dependencyLists);
                }
            }
            Iterator left = layout.getAnchor(ConstraintAnchor.Type.LEFT);
            ConstraintAnchor constraintAnchor = left;
            Intrinsics.checkNotNull((Object)constraintAnchor);
            if (constraintAnchor.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = ((ConstraintAnchor)((Object)left)).getDependents();
                Intrinsics.checkNotNull(hashSet);
                for (Object e : hashSet) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintAnchor first3 = (ConstraintAnchor)e;
                    this.findDependents(first3.getMOwner(), 0, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor2 = right = layout.getAnchor(ConstraintAnchor.Type.RIGHT);
            Intrinsics.checkNotNull((Object)constraintAnchor2);
            if (constraintAnchor2.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = right.getDependents();
                Intrinsics.checkNotNull(hashSet);
                for (Object e : hashSet) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintAnchor first2 = (ConstraintAnchor)e;
                    this.findDependents(first2.getMOwner(), 0, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor3 = center2 = layout.getAnchor(ConstraintAnchor.Type.CENTER);
            Intrinsics.checkNotNull((Object)constraintAnchor3);
            if (constraintAnchor3.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = center2.getDependents();
                Intrinsics.checkNotNull(hashSet);
                for (Object e : hashSet) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    first = (ConstraintAnchor)e;
                    this.findDependents(((ConstraintAnchor)first).getMOwner(), 0, dependencyLists, null);
                }
            }
            if (isolatedHorizontalChildren != null) {
                for (Object e : isolatedHorizontalChildren) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintWidget widget = (ConstraintWidget)e;
                    this.findDependents(widget, 0, dependencyLists, null);
                }
            }
            dependencyLists = allDependencyLists;
            if (horizontalGuidelines != null) {
                left = horizontalGuidelines.iterator();
                while (left.hasNext()) {
                    Guideline guideline2 = guideline = (Guideline)left.next();
                    Intrinsics.checkNotNull((Object)guideline2);
                    this.findDependents(guideline2, 1, dependencyLists, null);
                }
            }
            if (verticalBarriers != null) {
                for (Object e : verticalBarriers) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    barrier = (HelperWidget)e;
                    group = this.findDependents((ConstraintWidget)((Object)barrier), 1, dependencyLists, null);
                    ((HelperWidget)((Object)barrier)).addDependents(dependencyLists, 1, group);
                    WidgetGroup widgetGroup = group;
                    Intrinsics.checkNotNull((Object)widgetGroup);
                    widgetGroup.cleanup(dependencyLists);
                }
            }
            ConstraintAnchor constraintAnchor4 = top = layout.getAnchor(ConstraintAnchor.Type.TOP);
            Intrinsics.checkNotNull((Object)constraintAnchor4);
            if (constraintAnchor4.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = top.getDependents();
                Intrinsics.checkNotNull(hashSet);
                barrier = hashSet.iterator();
                while (barrier.hasNext()) {
                    Object first2;
                    Intrinsics.checkNotNullExpressionValue((Object)barrier.next(), (String)"next(...)");
                    this.findDependents(((ConstraintAnchor)first2).getMOwner(), 1, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor5 = baseline = layout.getAnchor(ConstraintAnchor.Type.BASELINE);
            Intrinsics.checkNotNull((Object)constraintAnchor5);
            if (constraintAnchor5.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = baseline.getDependents();
                Intrinsics.checkNotNull(hashSet);
                for (Object e : hashSet) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintAnchor first3 = (ConstraintAnchor)e;
                    this.findDependents(first3.getMOwner(), 1, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor6 = bottom = layout.getAnchor(ConstraintAnchor.Type.BOTTOM);
            Intrinsics.checkNotNull((Object)constraintAnchor6);
            if (constraintAnchor6.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = bottom.getDependents();
                Intrinsics.checkNotNull(hashSet);
                for (Object e : hashSet) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    first = (ConstraintAnchor)e;
                    this.findDependents(((ConstraintAnchor)first).getMOwner(), 1, dependencyLists, null);
                }
            }
            ConstraintAnchor constraintAnchor7 = center = layout.getAnchor(ConstraintAnchor.Type.CENTER);
            Intrinsics.checkNotNull((Object)constraintAnchor7);
            if (constraintAnchor7.getDependents() != null) {
                HashSet<ConstraintAnchor> hashSet = center.getDependents();
                Intrinsics.checkNotNull(hashSet);
                for (Object e : hashSet) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintAnchor first4 = (ConstraintAnchor)e;
                    this.findDependents(first4.getMOwner(), 1, dependencyLists, null);
                }
            }
            if (isolatedVerticalChildren != null) {
                for (Object e : isolatedVerticalChildren) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    ConstraintWidget widget = (ConstraintWidget)e;
                    this.findDependents(widget, 1, dependencyLists, null);
                }
            }
            for (int i3 = 0; i3 < count; ++i3) {
                ConstraintWidget child;
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i3), (String)"get(...)");
                if (!child.oppositeDimensionsTied()) continue;
                WidgetGroup horizontalGroup = this.findGroup(allDependencyLists, child.getHorizontalGroup());
                WidgetGroup verticalGroup = this.findGroup(allDependencyLists, child.getVerticalGroup());
                if (horizontalGroup == null || verticalGroup == null) continue;
                horizontalGroup.moveTo(0, verticalGroup);
                verticalGroup.setOrientation(2);
                allDependencyLists.remove(horizontalGroup);
            }
            if (allDependencyLists.size() <= 1) {
                return false;
            }
            WidgetGroup horizontalPick = null;
            WidgetGroup verticalPick = null;
            if (layout.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                int maxWrap = 0;
                picked = null;
                iterator = allDependencyLists.iterator();
                while (iterator.hasNext()) {
                    WidgetGroup widgetGroup = list = iterator.next();
                    Intrinsics.checkNotNull((Object)widgetGroup);
                    if (widgetGroup.getOrientation() == 1) continue;
                    list.setAuthoritative(false);
                    int wrap = list.measureWrap(layout.getSystem(), 0);
                    if (wrap <= maxWrap) continue;
                    picked = list;
                    maxWrap = wrap;
                }
                if (picked != null) {
                    layout.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    layout.setWidth(maxWrap);
                    picked.setAuthoritative(true);
                    horizontalPick = picked;
                }
            }
            if (layout.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                int maxWrap = 0;
                picked = null;
                iterator = allDependencyLists.iterator();
                while (iterator.hasNext()) {
                    WidgetGroup widgetGroup = list = iterator.next();
                    Intrinsics.checkNotNull((Object)widgetGroup);
                    if (widgetGroup.getOrientation() == 0) continue;
                    list.setAuthoritative(false);
                    int wrap = list.measureWrap(layout.getSystem(), 1);
                    if (wrap <= maxWrap) continue;
                    picked = list;
                    maxWrap = wrap;
                }
                if (picked != null) {
                    layout.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    layout.setHeight(maxWrap);
                    picked.setAuthoritative(true);
                    verticalPick = picked;
                }
            }
            return horizontalPick != null || verticalPick != null;
        }

        private final WidgetGroup findGroup(ArrayList<WidgetGroup> horizontalDependencyLists, int groupId) {
            int count = horizontalDependencyLists.size();
            for (int i = 0; i < count; ++i) {
                WidgetGroup group;
                Intrinsics.checkNotNullExpressionValue((Object)horizontalDependencyLists.get(i), (String)"get(...)");
                if (groupId != group.getId()) continue;
                return group;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public final WidgetGroup findDependents(@NotNull ConstraintWidget constraintWidget, int orientation, @NotNull ArrayList<WidgetGroup> list, @Nullable WidgetGroup group) {
            WidgetGroup widgetGroup;
            int i;
            int n;
            int groupId;
            WidgetGroup group2;
            block14: {
                block13: {
                    block11: {
                        block12: {
                            Intrinsics.checkNotNullParameter((Object)constraintWidget, (String)"constraintWidget");
                            Intrinsics.checkNotNullParameter(list, (String)"list");
                            group2 = group;
                            groupId = orientation == 0 ? constraintWidget.getHorizontalGroup() : constraintWidget.getVerticalGroup();
                            if (groupId == -1) break block11;
                            if (group2 == null) break block12;
                            if (groupId == group2.getId()) break block11;
                        }
                        n = list.size();
                        break block13;
                    }
                    if (groupId != -1) {
                        return group2;
                    }
                    break block14;
                }
                for (i = 0; i < n; ++i) {
                    Intrinsics.checkNotNullExpressionValue((Object)list.get(i), (String)"get(...)");
                    if (widgetGroup.getId() != groupId) continue;
                    if (group2 != null) {
                        group2.moveTo(orientation, widgetGroup);
                        list.remove(group2);
                    }
                    group2 = widgetGroup;
                    break;
                }
            }
            if (group2 == null) {
                if (constraintWidget instanceof HelperWidget && (groupId = ((HelperWidget)constraintWidget).findGroupInDependents(orientation)) != -1) {
                    n = list.size();
                    for (i = 0; i < n; ++i) {
                        Intrinsics.checkNotNullExpressionValue((Object)list.get(i), (String)"get(...)");
                        if (widgetGroup.getId() != groupId) continue;
                        group2 = widgetGroup;
                        break;
                    }
                }
                if (group2 == null) {
                    group2 = new WidgetGroup(orientation);
                }
                list.add(group2);
            }
            if (group2.add(constraintWidget)) {
                if (constraintWidget instanceof Guideline) {
                    Guideline guideline = (Guideline)constraintWidget;
                    guideline.getAnchor().findDependents(guideline.getOrientation() == 0 ? 1 : 0, list, group2);
                }
                if (orientation == 0) {
                    constraintWidget.setHorizontalGroup(group2.getId());
                    constraintWidget.getMLeft().findDependents(orientation, list, group2);
                    constraintWidget.getMRight().findDependents(orientation, list, group2);
                } else {
                    constraintWidget.setVerticalGroup(group2.getId());
                    constraintWidget.getMTop().findDependents(orientation, list, group2);
                    constraintWidget.getMBaseline().findDependents(orientation, list, group2);
                    constraintWidget.getMBottom().findDependents(orientation, list, group2);
                }
                constraintWidget.getMCenter().findDependents(orientation, list, group2);
            }
            return group2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

