/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ChainHead;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/Direct;", "", "()V", "Companion", "compose"})
@StabilityInferred(parameters=1)
public final class Direct {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final boolean DEBUG = false;
    private static final boolean APPLY_MATCH_PARENT = false;
    @NotNull
    private static final BasicMeasure.Measure sMeasure;
    private static final boolean EARLY_TERMINATION = true;
    private static int sHcount;
    private static int sVcount;

    public static final /* synthetic */ int access$getSHcount$cp() {
        return sHcount;
    }

    public static final /* synthetic */ int access$getSVcount$cp() {
        return sVcount;
    }

    static {
        sMeasure = new BasicMeasure.Measure();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\bJ2\u0010\u0017\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002JH\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J*\u0010&\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J2\u0010(\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\"\u0010)\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010'\u001a\u00020\u000fH\u0002J*\u0010*\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0018\u0010+\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\"\u0010,\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/Direct$Companion;", "", "()V", "APPLY_MATCH_PARENT", "", "DEBUG", "EARLY_TERMINATION", "sHcount", "", "sMeasure", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measure;", "sVcount", "canMeasure", "level", "layout", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "horizontalSolvingPass", "", "measurer", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measurer;", "isRtl", "ls", "", "solveBarrier", "barrier", "Landroidx/constraintlayout/core/widgets/Barrier;", "orientation", "solveChain", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "system", "Landroidx/constraintlayout/core/LinearSystem;", "offset", "chainHead", "Landroidx/constraintlayout/core/widgets/ChainHead;", "isChainSpread", "isChainSpreadInside", "isChainPacked", "solveHorizontalCenterConstraints", "widget", "solveHorizontalMatchConstraint", "solveVerticalCenterConstraints", "solveVerticalMatchConstraint", "solvingPass", "verticalSolvingPass", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public final void solvingPass(@NotNull ConstraintWidgetContainer layout, @Nullable BasicMeasure.Measurer measurer) {
            ConstraintWidget barrier;
            int position;
            ConstraintWidget guideline;
            ConstraintWidget child;
            int i;
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            ConstraintWidget.DimensionBehaviour horizontal = layout.getHorizontalDimensionBehaviour();
            ConstraintWidget.DimensionBehaviour vertical = layout.getVerticalDimensionBehaviour();
            sHcount = 0;
            sVcount = 0;
            long time = 0L;
            layout.resetFinalResolution();
            ArrayList<ConstraintWidget> children = layout.getChildren();
            int count = children.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ConstraintWidget child2;
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i2), (String)"get(...)");
                child2.resetFinalResolution();
            }
            boolean isRtl = layout.isRtl();
            if (horizontal == ConstraintWidget.DimensionBehaviour.FIXED) {
                layout.setFinalHorizontal(0, layout.getWidth());
            } else {
                layout.setFinalLeft(0);
            }
            boolean hasGuideline = false;
            boolean hasBarrier = false;
            for (i = 0; i < count; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                if (child instanceof Guideline) {
                    guideline = child;
                    if (((Guideline)guideline).getOrientation() != 1) continue;
                    if (((Guideline)guideline).getRelativeBegin() != -1) {
                        ((Guideline)guideline).setFinalValue(((Guideline)guideline).getRelativeBegin());
                    } else if (((Guideline)guideline).getRelativeEnd() != -1 && layout.isResolvedHorizontally()) {
                        ((Guideline)guideline).setFinalValue(layout.getWidth() - ((Guideline)guideline).getRelativeEnd());
                    } else if (layout.isResolvedHorizontally()) {
                        position = (int)(0.5f + ((Guideline)guideline).getRelativePercent() * (float)layout.getWidth());
                        ((Guideline)guideline).setFinalValue(position);
                    }
                    hasGuideline = true;
                    continue;
                }
                if (!(child instanceof Barrier) || ((Barrier)child).getOrientation() != 0) continue;
                hasBarrier = true;
            }
            if (hasGuideline) {
                for (i = 0; i < count; ++i) {
                    Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                    if (!(child instanceof Guideline) || ((Guideline)(guideline = child)).getOrientation() != 1) continue;
                    this.horizontalSolvingPass(0, guideline, measurer, isRtl);
                }
            }
            this.horizontalSolvingPass(0, layout, measurer, isRtl);
            if (hasBarrier) {
                for (i = 0; i < count; ++i) {
                    Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                    if (!(child instanceof Barrier) || ((Barrier)(barrier = child)).getOrientation() != 0) continue;
                    this.solveBarrier(0, (Barrier)barrier, measurer, 0, isRtl);
                }
            }
            if (vertical == ConstraintWidget.DimensionBehaviour.FIXED) {
                layout.setFinalVertical(0, layout.getHeight());
            } else {
                layout.setFinalTop(0);
            }
            hasGuideline = false;
            hasBarrier = false;
            for (i = 0; i < count; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                if (child instanceof Guideline) {
                    guideline = child;
                    if (((Guideline)guideline).getOrientation() != 0) continue;
                    if (((Guideline)guideline).getRelativeBegin() != -1) {
                        ((Guideline)guideline).setFinalValue(((Guideline)guideline).getRelativeBegin());
                    } else if (((Guideline)guideline).getRelativeEnd() != -1 && layout.isResolvedVertically()) {
                        ((Guideline)guideline).setFinalValue(layout.getHeight() - ((Guideline)guideline).getRelativeEnd());
                    } else if (layout.isResolvedVertically()) {
                        position = (int)(0.5f + ((Guideline)guideline).getRelativePercent() * (float)layout.getHeight());
                        ((Guideline)guideline).setFinalValue(position);
                    }
                    hasGuideline = true;
                    continue;
                }
                if (!(child instanceof Barrier) || ((Barrier)child).getOrientation() != 1) continue;
                hasBarrier = true;
            }
            if (hasGuideline) {
                for (i = 0; i < count; ++i) {
                    Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                    if (!(child instanceof Guideline) || ((Guideline)(guideline = child)).getOrientation() != 0) continue;
                    this.verticalSolvingPass(1, guideline, measurer);
                }
            }
            this.verticalSolvingPass(0, layout, measurer);
            if (hasBarrier) {
                for (i = 0; i < count; ++i) {
                    Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                    if (!(child instanceof Barrier) || ((Barrier)(barrier = child)).getOrientation() != 1) continue;
                    this.solveBarrier(0, (Barrier)barrier, measurer, 1, isRtl);
                }
            }
            for (i = 0; i < count; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                if (!child.isMeasureRequested() || !this.canMeasure(0, child)) continue;
                ConstraintWidgetContainer.Companion.measure(0, child, measurer, sMeasure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                if (child instanceof Guideline) {
                    if (((Guideline)child).getOrientation() == 0) {
                        this.verticalSolvingPass(0, child, measurer);
                        continue;
                    }
                    this.horizontalSolvingPass(0, child, measurer, isRtl);
                    continue;
                }
                this.horizontalSolvingPass(0, child, measurer, isRtl);
                this.verticalSolvingPass(0, child, measurer);
            }
        }

        private final void solveBarrier(int level, Barrier barrier, BasicMeasure.Measurer measurer, int orientation, boolean isRtl) {
            if (barrier.allSolved()) {
                if (orientation == 0) {
                    this.horizontalSolvingPass(level + 1, barrier, measurer, isRtl);
                } else {
                    this.verticalSolvingPass(level + 1, barrier, measurer);
                }
            }
        }

        @NotNull
        public final String ls(int level) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                builder.append("  ");
            }
            builder.append("+-(" + level + ") ");
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * Unable to fully structure code
         */
        private final void horizontalSolvingPass(int level, ConstraintWidget layout, BasicMeasure.Measurer measurer, boolean isRtl) {
            block23: {
                block21: {
                    if (layout.isHorizontalSolvingPassDone()) {
                        return;
                    }
                    var5_5 = Direct.access$getSHcount$cp();
                    Direct.access$setSHcount$cp(var5_5 + 1);
                    if (!(layout instanceof ConstraintWidgetContainer) && layout.isMeasureRequested() && this.canMeasure(level + 1, layout)) {
                        measure = new BasicMeasure.Measure();
                        ConstraintWidgetContainer.Companion.measure(level + 1, layout, measurer, measure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                    }
                    left = layout.getAnchor(ConstraintAnchor.Type.LEFT);
                    right = layout.getAnchor(ConstraintAnchor.Type.RIGHT);
                    v0 = left;
                    Intrinsics.checkNotNull((Object)v0);
                    l = v0.getFinalValue();
                    v1 = right;
                    Intrinsics.checkNotNull((Object)v1);
                    r = v1.getFinalValue();
                    if (left.getDependents() == null || !left.hasFinalValue()) break block21;
                    v2 = left.getDependents();
                    Intrinsics.checkNotNull(v2);
                    var9_11 = v2.iterator();
                    while (var9_11.hasNext()) {
                        block22: {
                            Intrinsics.checkNotNullExpressionValue((Object)var9_11.next(), (String)"next(...)");
                            widget = first.getMOwner();
                            x1 = 0;
                            x2 = 0;
                            canMeasure = this.canMeasure(level + 1, widget);
                            if (widget.isMeasureRequested() && canMeasure) {
                                measure = new BasicMeasure.Measure();
                                ConstraintWidgetContainer.Companion.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                            }
                            if (!Intrinsics.areEqual((Object)first, (Object)widget.getMLeft()) || widget.getMRight().getMTarget() == null) break block22;
                            v3 = widget.getMRight().getMTarget();
                            Intrinsics.checkNotNull((Object)v3);
                            if (v3.hasFinalValue()) ** GOTO lbl-1000
                        }
                        if (Intrinsics.areEqual((Object)first, (Object)widget.getMRight()) && widget.getMLeft().getMTarget() != null) {
                            v4 = widget.getMLeft().getMTarget();
                            Intrinsics.checkNotNull((Object)v4);
                            ** if (!v4.hasFinalValue()) goto lbl-1000
                        }
                        ** GOTO lbl-1000
lbl-1000:
                        // 2 sources

                        {
                            v5 = true;
                            ** GOTO lbl46
                        }
lbl-1000:
                        // 2 sources

                        {
                            v5 = bothConnected = false;
                        }
lbl46:
                        // 2 sources

                        if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || canMeasure) {
                            if (widget.isMeasureRequested()) {
                                continue;
                            }
                            if (Intrinsics.areEqual((Object)first, (Object)widget.getMLeft()) && widget.getMRight().getMTarget() == null) {
                                x1 = l + widget.getMLeft().getMargin();
                                x2 = x1 + widget.getWidth();
                                widget.setFinalHorizontal(x1, x2);
                                this.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                                continue;
                            }
                            if (Intrinsics.areEqual((Object)first, (Object)widget.getMRight()) && widget.getMLeft().getMTarget() == null) {
                                x2 = l - widget.getMRight().getMargin();
                                x1 = x2 - widget.getWidth();
                                widget.setFinalHorizontal(x1, x2);
                                this.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                                continue;
                            }
                            if (!bothConnected || widget.isInHorizontalChain()) continue;
                            this.solveHorizontalCenterConstraints(level + 1, measurer, widget, isRtl);
                            continue;
                        }
                        if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getMMatchConstraintMaxWidth() < 0 || widget.getMMatchConstraintMinWidth() < 0 || widget.getVisibility() != 8 && (widget.getMMatchConstraintDefaultWidth() != 0 || !(widget.getDimensionRatio() == 0.0f)) || widget.isInHorizontalChain() || widget.isInVirtualLayout() || !bothConnected || widget.isInHorizontalChain()) continue;
                        this.solveHorizontalMatchConstraint(level + 1, layout, measurer, widget, isRtl);
                    }
                }
                if (layout instanceof Guideline) {
                    return;
                }
                if (right.getDependents() == null || !right.hasFinalValue()) break block23;
                v6 = right.getDependents();
                Intrinsics.checkNotNull(v6);
                var9_11 = v6.iterator();
                while (var9_11.hasNext()) {
                    block24: {
                        Intrinsics.checkNotNullExpressionValue((Object)var9_11.next(), (String)"next(...)");
                        widget = first.getMOwner();
                        canMeasure = this.canMeasure(level + 1, widget);
                        if (widget.isMeasureRequested() && canMeasure) {
                            measure = new BasicMeasure.Measure();
                            ConstraintWidgetContainer.Companion.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                        }
                        x1 = 0;
                        x2 = 0;
                        if (!Intrinsics.areEqual((Object)first, (Object)widget.getMLeft()) || widget.getMRight().getMTarget() == null) break block24;
                        v7 = widget.getMRight().getMTarget();
                        Intrinsics.checkNotNull((Object)v7);
                        if (v7.hasFinalValue()) ** GOTO lbl-1000
                    }
                    if (Intrinsics.areEqual((Object)first, (Object)widget.getMRight()) && widget.getMLeft().getMTarget() != null) {
                        v8 = widget.getMLeft().getMTarget();
                        Intrinsics.checkNotNull((Object)v8);
                        ** if (!v8.hasFinalValue()) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        v9 = true;
                        ** GOTO lbl98
                    }
lbl-1000:
                    // 2 sources

                    {
                        v9 = bothConnected = false;
                    }
lbl98:
                    // 2 sources

                    if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || canMeasure) {
                        if (widget.isMeasureRequested()) {
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)first, (Object)widget.getMLeft()) && widget.getMRight().getMTarget() == null) {
                            x1 = r + widget.getMLeft().getMargin();
                            x2 = x1 + widget.getWidth();
                            widget.setFinalHorizontal(x1, x2);
                            this.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)first, (Object)widget.getMRight()) && widget.getMLeft().getMTarget() == null) {
                            x2 = r - widget.getMRight().getMargin();
                            x1 = x2 - widget.getWidth();
                            widget.setFinalHorizontal(x1, x2);
                            this.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                            continue;
                        }
                        if (!bothConnected || widget.isInHorizontalChain()) continue;
                        this.solveHorizontalCenterConstraints(level + 1, measurer, widget, isRtl);
                        continue;
                    }
                    if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getMMatchConstraintMaxWidth() < 0 || widget.getMMatchConstraintMinWidth() < 0 || widget.getVisibility() != 8 && (widget.getMMatchConstraintDefaultWidth() != 0 || !(widget.getDimensionRatio() == 0.0f)) || widget.isInHorizontalChain() || widget.isInVirtualLayout() || !bothConnected || widget.isInHorizontalChain()) continue;
                    this.solveHorizontalMatchConstraint(level + 1, layout, measurer, widget, isRtl);
                }
            }
            layout.markHorizontalSolvingPassDone();
        }

        /*
         * Unable to fully structure code
         */
        private final void verticalSolvingPass(int level, ConstraintWidget layout, BasicMeasure.Measurer measurer) {
            block27: {
                block25: {
                    if (layout.isVerticalSolvingPassDone()) {
                        return;
                    }
                    var4_4 = Direct.access$getSVcount$cp();
                    Direct.access$setSVcount$cp(var4_4 + 1);
                    if (!(layout instanceof ConstraintWidgetContainer) && layout.isMeasureRequested() && this.canMeasure(level + 1, layout)) {
                        measure = new BasicMeasure.Measure();
                        ConstraintWidgetContainer.Companion.measure(level + 1, layout, measurer, measure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                    }
                    top = layout.getAnchor(ConstraintAnchor.Type.TOP);
                    bottom = layout.getAnchor(ConstraintAnchor.Type.BOTTOM);
                    v0 = top;
                    Intrinsics.checkNotNull((Object)v0);
                    t = v0.getFinalValue();
                    v1 = bottom;
                    Intrinsics.checkNotNull((Object)v1);
                    b = v1.getFinalValue();
                    if (top.getDependents() == null || !top.hasFinalValue()) break block25;
                    v2 = top.getDependents();
                    Intrinsics.checkNotNull(v2);
                    var8_10 = v2.iterator();
                    while (var8_10.hasNext()) {
                        block26: {
                            Intrinsics.checkNotNullExpressionValue((Object)var8_10.next(), (String)"next(...)");
                            widget = first.getMOwner();
                            y1 = 0;
                            y2 = 0;
                            canMeasure = this.canMeasure(level + 1, widget);
                            if (widget.isMeasureRequested() && canMeasure) {
                                measure = new BasicMeasure.Measure();
                                ConstraintWidgetContainer.Companion.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                            }
                            if (!Intrinsics.areEqual((Object)first, (Object)widget.getMTop()) || widget.getMBottom().getMTarget() == null) break block26;
                            v3 = widget.getMBottom().getMTarget();
                            Intrinsics.checkNotNull((Object)v3);
                            if (v3.hasFinalValue()) ** GOTO lbl-1000
                        }
                        if (Intrinsics.areEqual((Object)first, (Object)widget.getMBottom()) && widget.getMTop().getMTarget() != null) {
                            v4 = widget.getMTop().getMTarget();
                            Intrinsics.checkNotNull((Object)v4);
                            ** if (!v4.hasFinalValue()) goto lbl-1000
                        }
                        ** GOTO lbl-1000
lbl-1000:
                        // 2 sources

                        {
                            v5 = true;
                            ** GOTO lbl46
                        }
lbl-1000:
                        // 2 sources

                        {
                            v5 = bothConnected = false;
                        }
lbl46:
                        // 2 sources

                        if (widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || canMeasure) {
                            if (widget.isMeasureRequested()) {
                                continue;
                            }
                            if (Intrinsics.areEqual((Object)first, (Object)widget.getMTop()) && widget.getMBottom().getMTarget() == null) {
                                y1 = t + widget.getMTop().getMargin();
                                y2 = y1 + widget.getHeight();
                                widget.setFinalVertical(y1, y2);
                                this.verticalSolvingPass(level + 1, widget, measurer);
                                continue;
                            }
                            if (Intrinsics.areEqual((Object)first, (Object)widget.getMBottom()) && widget.getMTop().getMTarget() == null) {
                                y2 = t - widget.getMBottom().getMargin();
                                y1 = y2 - widget.getHeight();
                                widget.setFinalVertical(y1, y2);
                                this.verticalSolvingPass(level + 1, widget, measurer);
                                continue;
                            }
                            if (!bothConnected || widget.isInVerticalChain()) continue;
                            this.solveVerticalCenterConstraints(level + 1, measurer, widget);
                            continue;
                        }
                        if (widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getMMatchConstraintMaxHeight() < 0 || widget.getMMatchConstraintMinHeight() < 0 || widget.getVisibility() != 8 && (widget.getMMatchConstraintDefaultHeight() != 0 || !(widget.getDimensionRatio() == 0.0f)) || widget.isInVerticalChain() || widget.isInVirtualLayout() || !bothConnected || widget.isInVerticalChain()) continue;
                        this.solveVerticalMatchConstraint(level + 1, layout, measurer, widget);
                    }
                }
                if (layout instanceof Guideline) {
                    return;
                }
                if (bottom.getDependents() == null || !bottom.hasFinalValue()) break block27;
                v6 = bottom.getDependents();
                Intrinsics.checkNotNull(v6);
                var8_10 = v6.iterator();
                while (var8_10.hasNext()) {
                    block28: {
                        Intrinsics.checkNotNullExpressionValue((Object)var8_10.next(), (String)"next(...)");
                        widget = first.getMOwner();
                        canMeasure = this.canMeasure(level + 1, widget);
                        if (widget.isMeasureRequested() && canMeasure) {
                            measure = new BasicMeasure.Measure();
                            ConstraintWidgetContainer.Companion.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                        }
                        y1 = 0;
                        y2 = 0;
                        if (!Intrinsics.areEqual((Object)first, (Object)widget.getMTop()) || widget.getMBottom().getMTarget() == null) break block28;
                        v7 = widget.getMBottom().getMTarget();
                        Intrinsics.checkNotNull((Object)v7);
                        if (v7.hasFinalValue()) ** GOTO lbl-1000
                    }
                    if (Intrinsics.areEqual((Object)first, (Object)widget.getMBottom()) && widget.getMTop().getMTarget() != null) {
                        v8 = widget.getMTop().getMTarget();
                        Intrinsics.checkNotNull((Object)v8);
                        ** if (!v8.hasFinalValue()) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        v9 = true;
                        ** GOTO lbl98
                    }
lbl-1000:
                    // 2 sources

                    {
                        v9 = bothConnected = false;
                    }
lbl98:
                    // 2 sources

                    if (widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || canMeasure) {
                        if (widget.isMeasureRequested()) {
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)first, (Object)widget.getMTop()) && widget.getMBottom().getMTarget() == null) {
                            y1 = b + widget.getMTop().getMargin();
                            y2 = y1 + widget.getHeight();
                            widget.setFinalVertical(y1, y2);
                            this.verticalSolvingPass(level + 1, widget, measurer);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)first, (Object)widget.getMBottom()) && widget.getMTop().getMTarget() == null) {
                            y2 = b - widget.getMBottom().getMargin();
                            y1 = y2 - widget.getHeight();
                            widget.setFinalVertical(y1, y2);
                            this.verticalSolvingPass(level + 1, widget, measurer);
                            continue;
                        }
                        if (!bothConnected || widget.isInVerticalChain()) continue;
                        this.solveVerticalCenterConstraints(level + 1, measurer, widget);
                        continue;
                    }
                    if (widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getMMatchConstraintMaxHeight() < 0 || widget.getMMatchConstraintMinHeight() < 0 || widget.getVisibility() != 8 && (widget.getMMatchConstraintDefaultHeight() != 0 || !(widget.getDimensionRatio() == 0.0f)) || widget.isInVerticalChain() || widget.isInVirtualLayout() || !bothConnected || widget.isInVerticalChain()) continue;
                    this.solveVerticalMatchConstraint(level + 1, layout, measurer, widget);
                }
            }
            v10 = baseline = layout.getAnchor(ConstraintAnchor.Type.BASELINE);
            Intrinsics.checkNotNull((Object)v10);
            if (v10.getDependents() != null && baseline.hasFinalValue()) {
                baselineValue = baseline.getFinalValue();
                v11 = baseline.getDependents();
                Intrinsics.checkNotNull(v11);
                var10_13 = v11.iterator();
                while (var10_13.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)var10_13.next(), (String)"next(...)");
                    widget = first.getMOwner();
                    canMeasure = this.canMeasure(level + 1, widget);
                    if (widget.isMeasureRequested() && canMeasure) {
                        measure = new BasicMeasure.Measure();
                        ConstraintWidgetContainer.Companion.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                    }
                    if (widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && !canMeasure) continue;
                    if (widget.isMeasureRequested()) {
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)first, (Object)widget.getMBaseline())) continue;
                    widget.setFinalBaseline(baselineValue + first.getMargin());
                    this.verticalSolvingPass(level + 1, widget, measurer);
                }
            }
            layout.markVerticalSolvingPassDone();
        }

        private final void solveHorizontalCenterConstraints(int level, BasicMeasure.Measurer measurer, ConstraintWidget widget, boolean isRtl) {
            int x1 = 0;
            int x2 = 0;
            float bias = widget.getHorizontalBiasPercent();
            ConstraintAnchor constraintAnchor = widget.getMLeft().getMTarget();
            Intrinsics.checkNotNull((Object)constraintAnchor);
            int start = constraintAnchor.getFinalValue();
            ConstraintAnchor constraintAnchor2 = widget.getMRight().getMTarget();
            Intrinsics.checkNotNull((Object)constraintAnchor2);
            int end = constraintAnchor2.getFinalValue();
            int s1 = start + widget.getMLeft().getMargin();
            int s2 = end - widget.getMRight().getMargin();
            if (start == end) {
                bias = 0.5f;
                s1 = start;
                s2 = end;
            }
            int width = widget.getWidth();
            int distance = s2 - s1 - width;
            if (s1 > s2) {
                distance = s1 - s2 - width;
            }
            int d1 = 0;
            d1 = distance > 0 ? (int)(0.5f + bias * (float)distance) : (int)(bias * (float)distance);
            x1 = s1 + d1;
            x2 = x1 + width;
            if (s1 > s2) {
                x1 = s1 + d1;
                x2 = x1 - width;
            }
            widget.setFinalHorizontal(x1, x2);
            this.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
        }

        private final void solveVerticalCenterConstraints(int level, BasicMeasure.Measurer measurer, ConstraintWidget widget) {
            int y1 = 0;
            int y2 = 0;
            float bias = widget.getVerticalBiasPercent();
            ConstraintAnchor constraintAnchor = widget.getMTop().getMTarget();
            Intrinsics.checkNotNull((Object)constraintAnchor);
            int start = constraintAnchor.getFinalValue();
            ConstraintAnchor constraintAnchor2 = widget.getMBottom().getMTarget();
            Intrinsics.checkNotNull((Object)constraintAnchor2);
            int end = constraintAnchor2.getFinalValue();
            int s1 = start + widget.getMTop().getMargin();
            int s2 = end - widget.getMBottom().getMargin();
            if (start == end) {
                bias = 0.5f;
                s1 = start;
                s2 = end;
            }
            int height = widget.getHeight();
            int distance = s2 - s1 - height;
            if (s1 > s2) {
                distance = s1 - s2 - height;
            }
            int d1 = 0;
            d1 = distance > 0 ? (int)(0.5f + bias * (float)distance) : (int)(bias * (float)distance);
            y1 = s1 + d1;
            y2 = y1 + height;
            if (s1 > s2) {
                y1 = s1 - d1;
                y2 = y1 - height;
            }
            widget.setFinalVertical(y1, y2);
            this.verticalSolvingPass(level + 1, widget, measurer);
        }

        private final void solveHorizontalMatchConstraint(int level, ConstraintWidget layout, BasicMeasure.Measurer measurer, ConstraintWidget widget, boolean isRtl) {
            int x1 = 0;
            int x2 = 0;
            float bias = widget.getHorizontalBiasPercent();
            ConstraintAnchor constraintAnchor = widget.getMLeft().getMTarget();
            Intrinsics.checkNotNull((Object)constraintAnchor);
            int s1 = constraintAnchor.getFinalValue() + widget.getMLeft().getMargin();
            ConstraintAnchor constraintAnchor2 = widget.getMRight().getMTarget();
            Intrinsics.checkNotNull((Object)constraintAnchor2);
            int s2 = constraintAnchor2.getFinalValue() - widget.getMRight().getMargin();
            if (s2 >= s1) {
                int width = widget.getWidth();
                if (widget.getVisibility() != 8) {
                    if (widget.getMMatchConstraintDefaultWidth() == 2) {
                        int n;
                        ConstraintWidgetContainer constraintWidgetContainer = layout instanceof ConstraintWidgetContainer ? (ConstraintWidgetContainer)layout : null;
                        if (constraintWidgetContainer != null) {
                            n = constraintWidgetContainer.getWidth();
                        } else {
                            ConstraintWidget constraintWidget = layout.getParent();
                            Intrinsics.checkNotNull((Object)constraintWidget);
                            n = constraintWidget.getWidth();
                        }
                        int parentWidth = n;
                        width = (int)(0.5f * widget.getHorizontalBiasPercent() * (float)parentWidth);
                    } else if (widget.getMMatchConstraintDefaultWidth() == 0) {
                        width = s2 - s1;
                    }
                    width = Math.max(widget.getMMatchConstraintMinWidth(), width);
                    if (widget.getMMatchConstraintMaxWidth() > 0) {
                        width = Math.min(widget.getMMatchConstraintMaxWidth(), width);
                    }
                }
                int distance = s2 - s1 - width;
                int d1 = (int)(0.5f + bias * (float)distance);
                x1 = s1 + d1;
                x2 = x1 + width;
                widget.setFinalHorizontal(x1, x2);
                this.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
            }
        }

        private final void solveVerticalMatchConstraint(int level, ConstraintWidget layout, BasicMeasure.Measurer measurer, ConstraintWidget widget) {
            int y1 = 0;
            int y2 = 0;
            float bias = widget.getVerticalBiasPercent();
            ConstraintAnchor constraintAnchor = widget.getMTop().getMTarget();
            Intrinsics.checkNotNull((Object)constraintAnchor);
            int s1 = constraintAnchor.getFinalValue() + widget.getMTop().getMargin();
            ConstraintAnchor constraintAnchor2 = widget.getMBottom().getMTarget();
            Intrinsics.checkNotNull((Object)constraintAnchor2);
            int s2 = constraintAnchor2.getFinalValue() - widget.getMBottom().getMargin();
            if (s2 >= s1) {
                int height = widget.getHeight();
                if (widget.getVisibility() != 8) {
                    if (widget.getMMatchConstraintDefaultHeight() == 2) {
                        int n;
                        ConstraintWidgetContainer constraintWidgetContainer = layout instanceof ConstraintWidgetContainer ? (ConstraintWidgetContainer)layout : null;
                        if (constraintWidgetContainer != null) {
                            n = constraintWidgetContainer.getHeight();
                        } else {
                            ConstraintWidget constraintWidget = layout.getParent();
                            Intrinsics.checkNotNull((Object)constraintWidget);
                            n = constraintWidget.getHeight();
                        }
                        int parentHeight = n;
                        height = (int)(0.5f * bias * (float)parentHeight);
                    } else if (widget.getMMatchConstraintDefaultHeight() == 0) {
                        height = s2 - s1;
                    }
                    height = Math.max(widget.getMMatchConstraintMinHeight(), height);
                    if (widget.getMMatchConstraintMaxHeight() > 0) {
                        height = Math.min(widget.getMMatchConstraintMaxHeight(), height);
                    }
                }
                int distance = s2 - s1 - height;
                int d1 = (int)(0.5f + bias * (float)distance);
                y1 = s1 + d1;
                y2 = y1 + height;
                widget.setFinalVertical(y1, y2);
                this.verticalSolvingPass(level + 1, widget, measurer);
            }
        }

        private final boolean canMeasure(int level, ConstraintWidget layout) {
            boolean isVerticalFixed;
            boolean isHorizontalFixed;
            boolean isParentVerticalFixed;
            ConstraintWidget.DimensionBehaviour horizontalBehaviour = layout.getHorizontalDimensionBehaviour();
            ConstraintWidget.DimensionBehaviour verticalBehaviour = layout.getVerticalDimensionBehaviour();
            ConstraintWidgetContainer parent = layout.getParent() != null ? (ConstraintWidgetContainer)layout.getParent() : null;
            boolean isParentHorizontalFixed = parent != null && parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED;
            boolean bl = isParentVerticalFixed = parent != null && parent.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED;
            boolean bl2 = horizontalBehaviour == ConstraintWidget.DimensionBehaviour.FIXED || layout.isResolvedHorizontally() || horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horizontalBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && layout.getMMatchConstraintDefaultWidth() == 0 && layout.getMDimensionRatio() == 0.0f && layout.hasDanglingDimension(0) || horizontalBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && layout.getMMatchConstraintDefaultWidth() == 1 && layout.hasResolvedTargets(0, layout.getWidth()) ? true : (isHorizontalFixed = false);
            boolean bl3 = verticalBehaviour == ConstraintWidget.DimensionBehaviour.FIXED || layout.isResolvedVertically() || verticalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || verticalBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && layout.getMMatchConstraintDefaultHeight() == 0 && layout.getMDimensionRatio() == 0.0f && layout.hasDanglingDimension(1) || verticalBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && layout.getMMatchConstraintDefaultHeight() == 1 && layout.hasResolvedTargets(1, layout.getHeight()) ? true : (isVerticalFixed = false);
            if (layout.getMDimensionRatio() > 0.0f && (isHorizontalFixed || isVerticalFixed)) {
                return true;
            }
            return isHorizontalFixed && isVerticalFixed;
        }

        public final boolean solveChain(@NotNull ConstraintWidgetContainer container, @Nullable LinearSystem system, int orientation, int offset, @NotNull ChainHead chainHead, boolean isChainSpread, boolean isChainSpreadInside, boolean isChainPacked) {
            block51: {
                int numVisibleWidgets;
                int endPoint;
                int startPoint;
                ConstraintWidget lastVisibleWidget;
                ConstraintWidget firstVisibleWidget;
                boolean isRtl;
                int level;
                block47: {
                    ConstraintAnchor end;
                    ConstraintAnchor begin;
                    boolean done;
                    ConstraintWidget next;
                    ConstraintWidget widget;
                    ConstraintWidget head;
                    ConstraintWidget first;
                    block43: {
                        block42: {
                            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                            Intrinsics.checkNotNullParameter((Object)chainHead, (String)"chainHead");
                            if (isChainPacked) {
                                return false;
                            }
                            if (orientation == 0 ? !container.isResolvedHorizontally() : !container.isResolvedVertically()) {
                                return false;
                            }
                            level = 0;
                            isRtl = container.isRtl();
                            first = chainHead.getFirst();
                            ConstraintWidget last = chainHead.getLast();
                            firstVisibleWidget = chainHead.getFirstVisibleWidget();
                            lastVisibleWidget = chainHead.getLastVisibleWidget();
                            head = chainHead.getHead();
                            widget = first;
                            next = null;
                            done = false;
                            ConstraintWidget constraintWidget = first;
                            Intrinsics.checkNotNull((Object)constraintWidget);
                            begin = constraintWidget.getMListAnchors()[offset];
                            ConstraintWidget constraintWidget2 = last;
                            Intrinsics.checkNotNull((Object)constraintWidget2);
                            end = constraintWidget2.getMListAnchors()[offset + 1];
                            if (begin.getMTarget() == null || end.getMTarget() == null) {
                                return false;
                            }
                            ConstraintAnchor constraintAnchor = begin.getMTarget();
                            Intrinsics.checkNotNull((Object)constraintAnchor);
                            if (!constraintAnchor.hasFinalValue()) break block42;
                            ConstraintAnchor constraintAnchor2 = end.getMTarget();
                            Intrinsics.checkNotNull((Object)constraintAnchor2);
                            if (constraintAnchor2.hasFinalValue()) break block43;
                        }
                        return false;
                    }
                    if (firstVisibleWidget == null || lastVisibleWidget == null) {
                        return false;
                    }
                    ConstraintAnchor constraintAnchor = begin.getMTarget();
                    Intrinsics.checkNotNull((Object)constraintAnchor);
                    startPoint = constraintAnchor.getFinalValue() + firstVisibleWidget.getMListAnchors()[offset].getMargin();
                    ConstraintAnchor constraintAnchor3 = end.getMTarget();
                    Intrinsics.checkNotNull((Object)constraintAnchor3);
                    endPoint = constraintAnchor3.getFinalValue() - lastVisibleWidget.getMListAnchors()[offset + 1].getMargin();
                    int distance = endPoint - startPoint;
                    if (distance <= 0) {
                        return false;
                    }
                    int totalSize = 0;
                    BasicMeasure.Measure measure = new BasicMeasure.Measure();
                    int numWidgets = 0;
                    numVisibleWidgets = 0;
                    while (!done) {
                        block46: {
                            block44: {
                                block45: {
                                    ConstraintAnchor nextAnchor;
                                    ConstraintWidget constraintWidget = widget;
                                    Intrinsics.checkNotNull((Object)constraintWidget);
                                    boolean canMeasure = this.canMeasure(level + 1, constraintWidget);
                                    if (!canMeasure) {
                                        return false;
                                    }
                                    if (widget.getMListDimensionBehaviors()[orientation] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                                        return false;
                                    }
                                    if (widget.isMeasureRequested()) {
                                        ConstraintWidgetContainer.Companion.measure(level + 1, widget, container.getMeasurer(), measure, BasicMeasure.Measure.Companion.getSELF_DIMENSIONS());
                                    }
                                    totalSize += widget.getMListAnchors()[offset].getMargin();
                                    totalSize += orientation == 0 ? widget.getWidth() : widget.getHeight();
                                    totalSize += widget.getMListAnchors()[offset + 1].getMargin();
                                    ++numWidgets;
                                    if (widget.getVisibility() != 8) {
                                        ++numVisibleWidgets;
                                    }
                                    if ((nextAnchor = widget.getMListAnchors()[offset + 1].getMTarget()) == null) break block44;
                                    next = nextAnchor.getMOwner();
                                    if (next.getMListAnchors()[offset].getMTarget() == null) break block45;
                                    ConstraintAnchor constraintAnchor4 = next.getMListAnchors()[offset].getMTarget();
                                    Intrinsics.checkNotNull((Object)constraintAnchor4);
                                    if (Intrinsics.areEqual((Object)constraintAnchor4.getMOwner(), (Object)widget)) break block46;
                                }
                                next = null;
                                break block46;
                            }
                            next = null;
                        }
                        if (next != null) {
                            widget = next;
                            continue;
                        }
                        done = true;
                    }
                    if (numVisibleWidgets == 0) {
                        return false;
                    }
                    if (numVisibleWidgets != numWidgets) {
                        return false;
                    }
                    if (distance < totalSize) {
                        return false;
                    }
                    int gap = distance - totalSize;
                    if (isChainSpread) {
                        gap /= numVisibleWidgets + 1;
                    } else if (isChainSpreadInside && numVisibleWidgets > 2) {
                        gap = gap / numVisibleWidgets - 1;
                    }
                    if (numVisibleWidgets == 1) {
                        float f;
                        if (orientation == 0) {
                            ConstraintWidget constraintWidget = head;
                            Intrinsics.checkNotNull((Object)constraintWidget);
                            f = constraintWidget.getHorizontalBiasPercent();
                        } else {
                            ConstraintWidget constraintWidget = head;
                            Intrinsics.checkNotNull((Object)constraintWidget);
                            f = constraintWidget.getVerticalBiasPercent();
                        }
                        float bias = f;
                        int p1 = (int)(0.5f + (float)startPoint + (float)gap * bias);
                        if (orientation == 0) {
                            firstVisibleWidget.setFinalHorizontal(p1, p1 + firstVisibleWidget.getWidth());
                        } else {
                            firstVisibleWidget.setFinalVertical(p1, p1 + firstVisibleWidget.getHeight());
                        }
                        BasicMeasure.Measurer measurer = container.getMeasurer();
                        Intrinsics.checkNotNull((Object)measurer);
                        this.horizontalSolvingPass(level + 1, firstVisibleWidget, measurer, isRtl);
                        return true;
                    }
                    if (!isChainSpread) break block47;
                    done = false;
                    int current = startPoint + gap;
                    widget = first;
                    while (!done) {
                        block50: {
                            block48: {
                                block49: {
                                    if (widget.getVisibility() == 8) {
                                        if (orientation == 0) {
                                            widget.setFinalHorizontal(current, current);
                                            BasicMeasure.Measurer measurer = container.getMeasurer();
                                            Intrinsics.checkNotNull((Object)measurer);
                                            this.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                                        } else {
                                            widget.setFinalVertical(current, current);
                                            BasicMeasure.Measurer measurer = container.getMeasurer();
                                            Intrinsics.checkNotNull((Object)measurer);
                                            this.verticalSolvingPass(level + 1, widget, measurer);
                                        }
                                    } else {
                                        int n;
                                        current += widget.getMListAnchors()[offset].getMargin();
                                        if (orientation == 0) {
                                            widget.setFinalHorizontal(current, current + widget.getWidth());
                                            BasicMeasure.Measurer measurer = container.getMeasurer();
                                            Intrinsics.checkNotNull((Object)measurer);
                                            this.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                                            n = widget.getWidth();
                                        } else {
                                            widget.setFinalVertical(current, current + widget.getHeight());
                                            BasicMeasure.Measurer measurer = container.getMeasurer();
                                            Intrinsics.checkNotNull((Object)measurer);
                                            this.verticalSolvingPass(level + 1, widget, measurer);
                                            n = widget.getHeight();
                                        }
                                        current += n;
                                        current += widget.getMListAnchors()[offset + 1].getMargin();
                                        current += gap;
                                    }
                                    LinearSystem linearSystem = system;
                                    Intrinsics.checkNotNull((Object)linearSystem);
                                    widget.addToSolver(linearSystem, false);
                                    ConstraintAnchor nextAnchor = widget.getMListAnchors()[offset + 1].getMTarget();
                                    if (nextAnchor == null) break block48;
                                    next = nextAnchor.getMOwner();
                                    if (next.getMListAnchors()[offset].getMTarget() == null) break block49;
                                    ConstraintAnchor constraintAnchor5 = next.getMListAnchors()[offset].getMTarget();
                                    Intrinsics.checkNotNull((Object)constraintAnchor5);
                                    if (Intrinsics.areEqual((Object)constraintAnchor5.getMOwner(), (Object)widget)) break block50;
                                }
                                next = null;
                                break block50;
                            }
                            next = null;
                        }
                        if (next != null) {
                            widget = next;
                            continue;
                        }
                        done = true;
                    }
                    break block51;
                }
                if (isChainSpreadInside) {
                    if (numVisibleWidgets == 2) {
                        if (orientation == 0) {
                            firstVisibleWidget.setFinalHorizontal(startPoint, startPoint + firstVisibleWidget.getWidth());
                            lastVisibleWidget.setFinalHorizontal(endPoint - lastVisibleWidget.getWidth(), endPoint);
                            BasicMeasure.Measurer measurer = container.getMeasurer();
                            Intrinsics.checkNotNull((Object)measurer);
                            this.horizontalSolvingPass(level + 1, firstVisibleWidget, measurer, isRtl);
                            BasicMeasure.Measurer measurer2 = container.getMeasurer();
                            Intrinsics.checkNotNull((Object)measurer2);
                            this.horizontalSolvingPass(level + 1, lastVisibleWidget, measurer2, isRtl);
                        } else {
                            firstVisibleWidget.setFinalVertical(startPoint, startPoint + firstVisibleWidget.getHeight());
                            lastVisibleWidget.setFinalVertical(endPoint - lastVisibleWidget.getHeight(), endPoint);
                            BasicMeasure.Measurer measurer = container.getMeasurer();
                            Intrinsics.checkNotNull((Object)measurer);
                            this.verticalSolvingPass(level + 1, firstVisibleWidget, measurer);
                            BasicMeasure.Measurer measurer3 = container.getMeasurer();
                            Intrinsics.checkNotNull((Object)measurer3);
                            this.verticalSolvingPass(level + 1, lastVisibleWidget, measurer3);
                        }
                        return true;
                    }
                    return false;
                }
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

