/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.GuidelineReference;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.RunGroup;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 K2\u00020\u0001:\u0001KB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JL\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\b\u0010$\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0006\u0010'\u001a\u00020\u001cJ\u001e\u0010'\u001a\u00020\u001c2\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0007j\b\u0012\u0004\u0012\u00020\u0019`\tJ\u0018\u0010)\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J\u000e\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013J\u000e\u00100\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013J\u0016\u00101\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 J\b\u00102\u001a\u00020\u001cH\u0002J0\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tH\u0002J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000206H\u0002J\u0018\u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020\u00192\u0006\u00109\u001a\u000206H\u0002J \u0010<\u001a\u0002062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u00132\u0006\u00109\u001a\u000206H\u0002J\u0006\u0010>\u001a\u00020\u001cJ\u0006\u0010?\u001a\u00020\u001cJ\u0018\u0010@\u001a\u00020\u00132\u0006\u0010A\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0002J0\u0010B\u001a\u00020\u001c2\u0006\u0010C\u001a\u00020D2\u0006\u0010+\u001a\u00020,2\u0006\u0010E\u001a\u00020 2\u0006\u0010-\u001a\u00020,2\u0006\u0010F\u001a\u00020 H\u0002J\u0006\u0010G\u001a\u00020\u001cJ\u0010\u0010H\u001a\u0002062\u0006\u00104\u001a\u00020\u0019H\u0002J\u0010\u0010I\u001a\u00020\u001c2\b\u0010J\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0007j\b\u0012\u0004\u0012\u00020\u0019`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/DependencyGraph;", "", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "(Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;)V", "mContainer", "mGroups", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/widgets/analyzer/RunGroup;", "Lkotlin/collections/ArrayList;", "getMGroups", "()Ljava/util/ArrayList;", "setMGroups", "(Ljava/util/ArrayList;)V", "mMeasure", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measure;", "mMeasurer", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measurer;", "mNeedBuildGraph", "", "mNeedRedoMeasures", "mRunGroups", "getMRunGroups$annotations", "()V", "mRuns", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "mWidgetcontainer", "applyGroup", "", "node", "Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "orientation", "", "direction", "end", "groups", "group", "basicMeasureWidgets", "constraintWidgetContainer", "buildGraph", "runs", "computeWrap", "defineTerminalWidgets", "horizontalBehavior", "Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;", "verticalBehavior", "directMeasure", "optimizeWrap", "directMeasureSetup", "directMeasureWithOrientation", "displayGraph", "findGroup", "run", "generateChainDisplayGraph", "", "chain", "Landroidx/constraintlayout/core/widgets/analyzer/ChainRun;", "content", "generateDisplayGraph", "root", "generateDisplayNode", "centeredConnection", "invalidateGraph", "invalidateMeasures", "isCenteredConnection", "start", "measure", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "horizontalDimension", "verticalDimension", "measureWidgets", "nodeDefinition", "setMeasurer", "measurer", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class DependencyGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConstraintWidgetContainer mWidgetcontainer;
    private boolean mNeedBuildGraph;
    private boolean mNeedRedoMeasures;
    @NotNull
    private final ConstraintWidgetContainer mContainer;
    @NotNull
    private final ArrayList<WidgetRun> mRuns;
    @NotNull
    private final ArrayList<RunGroup> mRunGroups;
    @Nullable
    private BasicMeasure.Measurer mMeasurer;
    @NotNull
    private final BasicMeasure.Measure mMeasure;
    @NotNull
    private ArrayList<RunGroup> mGroups;
    public static final int $stable = 8;
    private static final boolean USE_GROUPS = true;
    private static final boolean DEBUG = false;

    public DependencyGraph(@NotNull ConstraintWidgetContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.mWidgetcontainer = container;
        this.mNeedBuildGraph = true;
        this.mNeedRedoMeasures = true;
        this.mContainer = container;
        this.mRuns = new ArrayList();
        this.mRunGroups = new ArrayList();
        this.mMeasure = new BasicMeasure.Measure();
        this.mGroups = new ArrayList();
    }

    private static /* synthetic */ void getMRunGroups$annotations() {
    }

    public final void setMeasurer(@Nullable BasicMeasure.Measurer measurer) {
        this.mMeasurer = measurer;
    }

    private final int computeWrap(ConstraintWidgetContainer container, int orientation) {
        int count = this.mGroups.size();
        long wrapSize = 0L;
        for (int i = 0; i < count; ++i) {
            RunGroup run;
            Intrinsics.checkNotNullExpressionValue((Object)this.mGroups.get(i), (String)"get(...)");
            long size = run.computeWrapSize(container, orientation);
            wrapSize = Math.max(wrapSize, size);
        }
        return (int)wrapSize;
    }

    public final void defineTerminalWidgets(@NotNull ConstraintWidget.DimensionBehaviour horizontalBehavior, @NotNull ConstraintWidget.DimensionBehaviour verticalBehavior) {
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalBehavior), (String)"horizontalBehavior");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalBehavior), (String)"verticalBehavior");
        if (this.mNeedBuildGraph) {
            this.buildGraph();
            boolean hasBarrier = false;
            for (ConstraintWidget widget : this.mWidgetcontainer.getMChildren()) {
                widget.isTerminalWidget()[0] = true;
                widget.isTerminalWidget()[1] = true;
                if (!(widget instanceof Barrier)) continue;
                hasBarrier = true;
            }
            if (!hasBarrier) {
                for (RunGroup group : this.mGroups) {
                    group.defineTerminalWidgets(horizontalBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, verticalBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
        }
    }

    public final boolean directMeasure(boolean optimizeWrap) {
        boolean avoid;
        boolean optimizeWrap2 = optimizeWrap;
        optimizeWrap2 &= true;
        if (this.mNeedBuildGraph || this.mNeedRedoMeasures) {
            for (ConstraintWidget widget : this.mWidgetcontainer.getMChildren()) {
                widget.ensureWidgetRuns();
                widget.setMeasured(false);
                HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                horizontalWidgetRun.reset();
                VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                verticalWidgetRun.reset();
            }
            this.mWidgetcontainer.ensureWidgetRuns();
            this.mWidgetcontainer.setMeasured(false);
            HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            horizontalWidgetRun.reset();
            VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            verticalWidgetRun.reset();
            this.mNeedRedoMeasures = false;
        }
        if (avoid = this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.mWidgetcontainer.setX(0);
        this.mWidgetcontainer.setY(0);
        ConstraintWidget.DimensionBehaviour originalHorizontalDimension = this.mWidgetcontainer.getDimensionBehaviour(0);
        ConstraintWidget.DimensionBehaviour originalVerticalDimension = this.mWidgetcontainer.getDimensionBehaviour(1);
        if (this.mNeedBuildGraph) {
            this.buildGraph();
        }
        int x1 = this.mWidgetcontainer.getX();
        int y1 = this.mWidgetcontainer.getY();
        HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        horizontalWidgetRun.getStart().resolve(x1);
        VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun);
        verticalWidgetRun.getStart().resolve(y1);
        this.measureWidgets();
        if (originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            if (optimizeWrap2) {
                for (WidgetRun run : this.mRuns) {
                    if (run.supportsWrapComputation()) continue;
                    optimizeWrap2 = false;
                    break;
                }
            }
            if (optimizeWrap2 && originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setWidth(this.computeWrap(this.mWidgetcontainer, 0));
                HorizontalWidgetRun horizontalWidgetRun2 = this.mWidgetcontainer.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                horizontalWidgetRun2.getMDimension().resolve(this.mWidgetcontainer.getWidth());
            }
            if (optimizeWrap2 && originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setHeight(this.computeWrap(this.mWidgetcontainer, 1));
                VerticalWidgetRun verticalWidgetRun2 = this.mWidgetcontainer.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                verticalWidgetRun2.getMDimension().resolve(this.mWidgetcontainer.getHeight());
            }
        }
        boolean checkRoot = false;
        if (this.mWidgetcontainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int x2 = x1 + this.mWidgetcontainer.getWidth();
            HorizontalWidgetRun horizontalWidgetRun3 = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
            horizontalWidgetRun3.getEnd().resolve(x2);
            HorizontalWidgetRun horizontalWidgetRun4 = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
            horizontalWidgetRun4.getMDimension().resolve(x2 - x1);
            this.measureWidgets();
            if (this.mWidgetcontainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int y2 = y1 + this.mWidgetcontainer.getHeight();
                VerticalWidgetRun verticalWidgetRun3 = this.mWidgetcontainer.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                verticalWidgetRun3.getEnd().resolve(y2);
                VerticalWidgetRun verticalWidgetRun4 = this.mWidgetcontainer.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun4);
                verticalWidgetRun4.getMDimension().resolve(y2 - y1);
            }
            this.measureWidgets();
            checkRoot = true;
        }
        for (WidgetRun run : this.mRuns) {
            if (Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mWidgetcontainer) && !run.getMResolved()) continue;
            run.applyToWidget();
        }
        boolean allResolved = true;
        for (WidgetRun run : this.mRuns) {
            if (!checkRoot && Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mWidgetcontainer)) continue;
            if (!run.getStart().getResolved()) {
                allResolved = false;
                break;
            }
            if (!run.getEnd().getResolved() && !(run instanceof GuidelineReference)) {
                allResolved = false;
                break;
            }
            if (run.getMDimension().getResolved() || run instanceof ChainRun || run instanceof GuidelineReference) continue;
            allResolved = false;
            break;
        }
        ConstraintWidget.DimensionBehaviour dimensionBehaviour = originalHorizontalDimension;
        Intrinsics.checkNotNull((Object)((Object)dimensionBehaviour));
        this.mWidgetcontainer.setHorizontalDimensionBehaviour(dimensionBehaviour);
        ConstraintWidget.DimensionBehaviour dimensionBehaviour2 = originalVerticalDimension;
        Intrinsics.checkNotNull((Object)((Object)dimensionBehaviour2));
        this.mWidgetcontainer.setVerticalDimensionBehaviour(dimensionBehaviour2);
        return allResolved;
    }

    public final boolean directMeasureSetup(boolean optimizeWrap) {
        boolean avoid;
        if (this.mNeedBuildGraph) {
            for (ConstraintWidget widget : this.mWidgetcontainer.getMChildren()) {
                widget.ensureWidgetRuns();
                widget.setMeasured(false);
                HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                horizontalWidgetRun.getMDimension().setResolved(false);
                HorizontalWidgetRun horizontalWidgetRun2 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                horizontalWidgetRun2.setMResolved(false);
                HorizontalWidgetRun horizontalWidgetRun3 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                horizontalWidgetRun3.reset();
                VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                verticalWidgetRun.getMDimension().setResolved(false);
                VerticalWidgetRun verticalWidgetRun2 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                verticalWidgetRun2.setMResolved(false);
                VerticalWidgetRun verticalWidgetRun3 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                verticalWidgetRun3.reset();
            }
            this.mWidgetcontainer.ensureWidgetRuns();
            this.mWidgetcontainer.setMeasured(false);
            HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            horizontalWidgetRun.getMDimension().setResolved(false);
            HorizontalWidgetRun horizontalWidgetRun4 = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
            horizontalWidgetRun4.setMResolved(false);
            HorizontalWidgetRun horizontalWidgetRun5 = this.mWidgetcontainer.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun5);
            horizontalWidgetRun5.reset();
            VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            verticalWidgetRun.getMDimension().setResolved(false);
            VerticalWidgetRun verticalWidgetRun4 = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun4);
            verticalWidgetRun4.setMResolved(false);
            VerticalWidgetRun verticalWidgetRun5 = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun5);
            verticalWidgetRun5.reset();
            this.buildGraph();
        }
        if (avoid = this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.mWidgetcontainer.setX(0);
        this.mWidgetcontainer.setY(0);
        HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        horizontalWidgetRun.getStart().resolve(0);
        VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun);
        verticalWidgetRun.getStart().resolve(0);
        return true;
    }

    public final boolean directMeasureWithOrientation(boolean optimizeWrap, int orientation) {
        boolean optimizeWrap2 = optimizeWrap;
        ConstraintWidget.DimensionBehaviour originalHorizontalDimension = this.mWidgetcontainer.getDimensionBehaviour(0);
        ConstraintWidget.DimensionBehaviour originalVerticalDimension = this.mWidgetcontainer.getDimensionBehaviour(1);
        int x1 = this.mWidgetcontainer.getX();
        int y1 = this.mWidgetcontainer.getY();
        if ((optimizeWrap2 &= true) && (originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
            for (WidgetRun run : this.mRuns) {
                if (run.getOrientation() != orientation || run.supportsWrapComputation()) continue;
                optimizeWrap2 = false;
                break;
            }
            if (orientation == 0) {
                if (optimizeWrap2 && originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    this.mWidgetcontainer.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    this.mWidgetcontainer.setWidth(this.computeWrap(this.mWidgetcontainer, 0));
                    HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                    horizontalWidgetRun.getMDimension().resolve(this.mWidgetcontainer.getWidth());
                }
            } else if (optimizeWrap2 && originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.mWidgetcontainer.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.mWidgetcontainer.setHeight(this.computeWrap(this.mWidgetcontainer, 1));
                VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                verticalWidgetRun.getMDimension().resolve(this.mWidgetcontainer.getHeight());
            }
        }
        boolean checkRoot = false;
        if (orientation == 0) {
            if (this.mWidgetcontainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int x2 = x1 + this.mWidgetcontainer.getWidth();
                HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                horizontalWidgetRun.getEnd().resolve(x2);
                HorizontalWidgetRun horizontalWidgetRun2 = this.mWidgetcontainer.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                horizontalWidgetRun2.getMDimension().resolve(x2 - x1);
                checkRoot = true;
            }
        } else if (this.mWidgetcontainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.mWidgetcontainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int y2 = y1 + this.mWidgetcontainer.getHeight();
            VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            verticalWidgetRun.getEnd().resolve(y2);
            VerticalWidgetRun verticalWidgetRun2 = this.mWidgetcontainer.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun2);
            verticalWidgetRun2.getMDimension().resolve(y2 - y1);
            checkRoot = true;
        }
        this.measureWidgets();
        for (WidgetRun run : this.mRuns) {
            if (run.getOrientation() != orientation || Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mWidgetcontainer) && !run.getMResolved()) continue;
            run.applyToWidget();
        }
        boolean allResolved = true;
        for (WidgetRun run : this.mRuns) {
            if (run.getOrientation() != orientation || !checkRoot && Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mWidgetcontainer)) continue;
            if (!run.getStart().getResolved()) {
                allResolved = false;
                break;
            }
            if (!run.getEnd().getResolved()) {
                allResolved = false;
                break;
            }
            if (run instanceof ChainRun || run.getMDimension().getResolved()) continue;
            allResolved = false;
            break;
        }
        ConstraintWidget.DimensionBehaviour dimensionBehaviour = originalHorizontalDimension;
        Intrinsics.checkNotNull((Object)((Object)dimensionBehaviour));
        this.mWidgetcontainer.setHorizontalDimensionBehaviour(dimensionBehaviour);
        ConstraintWidget.DimensionBehaviour dimensionBehaviour2 = originalVerticalDimension;
        Intrinsics.checkNotNull((Object)((Object)dimensionBehaviour2));
        this.mWidgetcontainer.setVerticalDimensionBehaviour(dimensionBehaviour2);
        return allResolved;
    }

    private final void measure(ConstraintWidget widget, ConstraintWidget.DimensionBehaviour horizontalBehavior, int horizontalDimension, ConstraintWidget.DimensionBehaviour verticalBehavior, int verticalDimension) {
        this.mMeasure.setHorizontalBehavior(horizontalBehavior);
        this.mMeasure.setVerticalBehavior(verticalBehavior);
        this.mMeasure.setHorizontalDimension(horizontalDimension);
        this.mMeasure.setVerticalDimension(verticalDimension);
        BasicMeasure.Measurer measurer = this.mMeasurer;
        Intrinsics.checkNotNull((Object)measurer);
        measurer.measure(widget, this.mMeasure);
        widget.setWidth(this.mMeasure.getMeasuredWidth());
        widget.setHeight(this.mMeasure.getMeasuredHeight());
        widget.setHasBaseline(this.mMeasure.getMeasuredHasBaseline());
        widget.setBaselineDistance(this.mMeasure.getMeasuredBaseline());
    }

    private final boolean basicMeasureWidgets(ConstraintWidgetContainer constraintWidgetContainer) {
        for (ConstraintWidget widget : constraintWidgetContainer.getMChildren()) {
            int height;
            ConstraintWidget.DimensionBehaviour horizontal = widget.getMListDimensionBehaviors()[0];
            ConstraintWidget.DimensionBehaviour vertical = widget.getMListDimensionBehaviors()[1];
            if (widget.getVisibility() == 8) {
                widget.setMeasured(true);
                continue;
            }
            if (widget.getMMatchConstraintPercentWidth() < 1.0f && horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widget.setMMatchConstraintDefaultWidth(2);
            }
            if (widget.getMMatchConstraintPercentHeight() < 1.0f && vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widget.setMMatchConstraintDefaultHeight(2);
            }
            if (widget.getDimensionRatio() > 0.0f) {
                if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    widget.setMMatchConstraintDefaultWidth(3);
                } else if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horizontal == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    widget.setMMatchConstraintDefaultHeight(3);
                } else if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (widget.getMMatchConstraintDefaultWidth() == 0) {
                        widget.setMMatchConstraintDefaultWidth(3);
                    }
                    if (widget.getMMatchConstraintDefaultHeight() == 0) {
                        widget.setMMatchConstraintDefaultHeight(3);
                    }
                }
            }
            if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getMMatchConstraintDefaultWidth() == 1 && (widget.getMLeft().getMTarget() == null || widget.getMRight().getMTarget() == null)) {
                horizontal = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getMMatchConstraintDefaultHeight() == 1 && (widget.getMTop().getMTarget() == null || widget.getMBottom().getMTarget() == null)) {
                vertical = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            horizontalWidgetRun.setMDimensionBehavior(horizontal);
            HorizontalWidgetRun horizontalWidgetRun2 = widget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
            horizontalWidgetRun2.setMatchConstraintsType(widget.getMMatchConstraintDefaultWidth());
            VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            verticalWidgetRun.setMDimensionBehavior(vertical);
            VerticalWidgetRun verticalWidgetRun2 = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun2);
            verticalWidgetRun2.setMatchConstraintsType(widget.getMMatchConstraintDefaultHeight());
            if (!(horizontal != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && horizontal != ConstraintWidget.DimensionBehaviour.FIXED && horizontal != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && vertical != ConstraintWidget.DimensionBehaviour.FIXED && vertical != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
                int width = widget.getWidth();
                if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    width = constraintWidgetContainer.getWidth() - widget.getMLeft().getMMargin() - widget.getMRight().getMMargin();
                    horizontal = ConstraintWidget.DimensionBehaviour.FIXED;
                }
                int height2 = widget.getHeight();
                if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    height2 = constraintWidgetContainer.getHeight() - widget.getMTop().getMMargin() - widget.getMBottom().getMMargin();
                    vertical = ConstraintWidget.DimensionBehaviour.FIXED;
                }
                Intrinsics.checkNotNull((Object)widget);
                this.measure(widget, horizontal, width, vertical, height2);
                HorizontalWidgetRun horizontalWidgetRun3 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                horizontalWidgetRun3.getMDimension().resolve(widget.getWidth());
                VerticalWidgetRun verticalWidgetRun3 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                verticalWidgetRun3.getMDimension().resolve(widget.getHeight());
                widget.setMeasured(true);
                continue;
            }
            if (horizontal == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vertical == ConstraintWidget.DimensionBehaviour.FIXED)) {
                if (widget.getMMatchConstraintDefaultWidth() == 3) {
                    if (vertical == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        Intrinsics.checkNotNull((Object)widget);
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    }
                    int height3 = widget.getHeight();
                    int width = (int)((float)height3 * widget.getMDimensionRatio() + 0.5f);
                    Intrinsics.checkNotNull((Object)widget);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height3);
                    HorizontalWidgetRun horizontalWidgetRun4 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
                    horizontalWidgetRun4.getMDimension().resolve(widget.getWidth());
                    VerticalWidgetRun verticalWidgetRun4 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun4);
                    verticalWidgetRun4.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                    continue;
                }
                if (widget.getMMatchConstraintDefaultWidth() == 1) {
                    Intrinsics.checkNotNull((Object)widget);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    HorizontalWidgetRun horizontalWidgetRun5 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun5);
                    horizontalWidgetRun5.getMDimension().setWrapValue(widget.getWidth());
                    continue;
                }
                if (widget.getMMatchConstraintDefaultWidth() == 2) {
                    if (constraintWidgetContainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.getMListDimensionBehaviors()[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        float percent = widget.getMMatchConstraintPercentWidth();
                        int width = (int)(0.5f + percent * (float)constraintWidgetContainer.getWidth());
                        height = widget.getHeight();
                        Intrinsics.checkNotNull((Object)widget);
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, vertical, height);
                        HorizontalWidgetRun horizontalWidgetRun6 = widget.getMHorizontalRun();
                        Intrinsics.checkNotNull((Object)horizontalWidgetRun6);
                        horizontalWidgetRun6.getMDimension().resolve(widget.getWidth());
                        VerticalWidgetRun verticalWidgetRun5 = widget.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun5);
                        verticalWidgetRun5.getMDimension().resolve(widget.getHeight());
                        widget.setMeasured(true);
                        continue;
                    }
                } else if (widget.getMListAnchors()[0].getMTarget() == null || widget.getMListAnchors()[1].getMTarget() == null) {
                    Intrinsics.checkNotNull((Object)widget);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    HorizontalWidgetRun horizontalWidgetRun7 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun7);
                    horizontalWidgetRun7.getMDimension().resolve(widget.getWidth());
                    VerticalWidgetRun verticalWidgetRun6 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun6);
                    verticalWidgetRun6.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                    continue;
                }
            }
            if (vertical == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horizontal == ConstraintWidget.DimensionBehaviour.FIXED)) {
                if (widget.getMMatchConstraintDefaultHeight() == 3) {
                    if (horizontal == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        Intrinsics.checkNotNull((Object)widget);
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    }
                    int width = widget.getWidth();
                    float ratio = widget.getMDimensionRatio();
                    if (widget.getDimensionRatioSide() == -1) {
                        ratio = 1.0f / ratio;
                    }
                    height = (int)((float)width * ratio + 0.5f);
                    Intrinsics.checkNotNull((Object)widget);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height);
                    HorizontalWidgetRun horizontalWidgetRun8 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun8);
                    horizontalWidgetRun8.getMDimension().resolve(widget.getWidth());
                    VerticalWidgetRun verticalWidgetRun7 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun7);
                    verticalWidgetRun7.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                    continue;
                }
                if (widget.getMMatchConstraintDefaultHeight() == 1) {
                    Intrinsics.checkNotNull((Object)widget);
                    this.measure(widget, horizontal, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    VerticalWidgetRun verticalWidgetRun8 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun8);
                    verticalWidgetRun8.getMDimension().setWrapValue(widget.getHeight());
                    continue;
                }
                if (widget.getMMatchConstraintDefaultHeight() == 2) {
                    if (constraintWidgetContainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.getMListDimensionBehaviors()[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        float percent = widget.getMMatchConstraintPercentHeight();
                        int width = widget.getWidth();
                        height = (int)(0.5f + percent * (float)constraintWidgetContainer.getHeight());
                        Intrinsics.checkNotNull((Object)widget);
                        this.measure(widget, horizontal, width, ConstraintWidget.DimensionBehaviour.FIXED, height);
                        HorizontalWidgetRun horizontalWidgetRun9 = widget.getMHorizontalRun();
                        Intrinsics.checkNotNull((Object)horizontalWidgetRun9);
                        horizontalWidgetRun9.getMDimension().resolve(widget.getWidth());
                        VerticalWidgetRun verticalWidgetRun9 = widget.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun9);
                        verticalWidgetRun9.getMDimension().resolve(widget.getHeight());
                        widget.setMeasured(true);
                        continue;
                    }
                } else if (widget.getMListAnchors()[2].getMTarget() == null || widget.getMListAnchors()[3].getMTarget() == null) {
                    Intrinsics.checkNotNull((Object)widget);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vertical, 0);
                    HorizontalWidgetRun horizontalWidgetRun10 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun10);
                    horizontalWidgetRun10.getMDimension().resolve(widget.getWidth());
                    VerticalWidgetRun verticalWidgetRun10 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun10);
                    verticalWidgetRun10.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                    continue;
                }
            }
            if (horizontal != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || vertical != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            if (widget.getMMatchConstraintDefaultWidth() == 1 || widget.getMMatchConstraintDefaultHeight() == 1) {
                Intrinsics.checkNotNull((Object)widget);
                this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                HorizontalWidgetRun horizontalWidgetRun11 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun11);
                horizontalWidgetRun11.getMDimension().setWrapValue(widget.getWidth());
                VerticalWidgetRun verticalWidgetRun11 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun11);
                verticalWidgetRun11.getMDimension().setWrapValue(widget.getHeight());
                continue;
            }
            if (widget.getMMatchConstraintDefaultHeight() != 2 || widget.getMMatchConstraintDefaultWidth() != 2 || constraintWidgetContainer.getMListDimensionBehaviors()[0] != ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.getMListDimensionBehaviors()[1] != ConstraintWidget.DimensionBehaviour.FIXED) continue;
            float horizPercent = widget.getMMatchConstraintPercentWidth();
            float vertPercent = widget.getMMatchConstraintPercentHeight();
            int width = (int)(0.5f + horizPercent * (float)constraintWidgetContainer.getWidth());
            int height4 = (int)(0.5f + vertPercent * (float)constraintWidgetContainer.getHeight());
            Intrinsics.checkNotNull((Object)widget);
            this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height4);
            HorizontalWidgetRun horizontalWidgetRun12 = widget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun12);
            horizontalWidgetRun12.getMDimension().resolve(widget.getWidth());
            VerticalWidgetRun verticalWidgetRun12 = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun12);
            verticalWidgetRun12.getMDimension().resolve(widget.getHeight());
            widget.setMeasured(true);
        }
        return false;
    }

    public final void measureWidgets() {
        for (ConstraintWidget widget : this.mWidgetcontainer.getMChildren()) {
            if (widget.getMeasured()) continue;
            ConstraintWidget.DimensionBehaviour horiz = widget.getMListDimensionBehaviors()[0];
            ConstraintWidget.DimensionBehaviour vert = widget.getMListDimensionBehaviors()[1];
            int horizMatchConstraintsType = widget.getMMatchConstraintDefaultWidth();
            int vertMatchConstraintsType = widget.getMMatchConstraintDefaultHeight();
            boolean horizWrap = horiz == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && horizMatchConstraintsType == 1;
            boolean vertWrap = vert == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && vertMatchConstraintsType == 1;
            HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
            boolean horizResolved = horizontalWidgetRun.getMDimension().getResolved();
            VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun);
            boolean vertResolved = verticalWidgetRun.getMDimension().getResolved();
            if (horizResolved && vertResolved) {
                Intrinsics.checkNotNull((Object)widget);
                HorizontalWidgetRun horizontalWidgetRun2 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                int n = horizontalWidgetRun2.getMDimension().getValue();
                VerticalWidgetRun verticalWidgetRun2 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, n, ConstraintWidget.DimensionBehaviour.FIXED, verticalWidgetRun2.getMDimension().getValue());
                widget.setMeasured(true);
            } else if (horizResolved && vertWrap) {
                Intrinsics.checkNotNull((Object)widget);
                HorizontalWidgetRun horizontalWidgetRun3 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                int n = horizontalWidgetRun3.getMDimension().getValue();
                VerticalWidgetRun verticalWidgetRun3 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, n, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, verticalWidgetRun3.getMDimension().getValue());
                if (vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    VerticalWidgetRun verticalWidgetRun4 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun4);
                    verticalWidgetRun4.getMDimension().setWrapValue(widget.getHeight());
                } else {
                    VerticalWidgetRun verticalWidgetRun5 = widget.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun5);
                    verticalWidgetRun5.getMDimension().resolve(widget.getHeight());
                    widget.setMeasured(true);
                }
            } else if (vertResolved && horizWrap) {
                Intrinsics.checkNotNull((Object)widget);
                HorizontalWidgetRun horizontalWidgetRun4 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun4);
                int n = horizontalWidgetRun4.getMDimension().getValue();
                VerticalWidgetRun verticalWidgetRun6 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun6);
                this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, n, ConstraintWidget.DimensionBehaviour.FIXED, verticalWidgetRun6.getMDimension().getValue());
                if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    HorizontalWidgetRun horizontalWidgetRun5 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun5);
                    horizontalWidgetRun5.getMDimension().setWrapValue(widget.getWidth());
                } else {
                    HorizontalWidgetRun horizontalWidgetRun6 = widget.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun6);
                    horizontalWidgetRun6.getMDimension().resolve(widget.getWidth());
                    widget.setMeasured(true);
                }
            }
            if (!widget.getMeasured()) continue;
            VerticalWidgetRun verticalWidgetRun7 = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun7);
            if (verticalWidgetRun7.getMBaselineDimension() == null) continue;
            VerticalWidgetRun verticalWidgetRun8 = widget.getMVerticalRun();
            Intrinsics.checkNotNull((Object)verticalWidgetRun8);
            DimensionDependency dimensionDependency = verticalWidgetRun8.getMBaselineDimension();
            Intrinsics.checkNotNull((Object)dimensionDependency);
            dimensionDependency.resolve(widget.getBaselineDistance());
        }
    }

    public final void invalidateGraph() {
        this.mNeedBuildGraph = true;
    }

    public final void invalidateMeasures() {
        this.mNeedRedoMeasures = true;
    }

    @NotNull
    public final ArrayList<RunGroup> getMGroups() {
        return this.mGroups;
    }

    public final void setMGroups(@NotNull ArrayList<RunGroup> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mGroups = arrayList;
    }

    public final void buildGraph() {
        this.buildGraph(this.mRuns);
        this.mGroups.clear();
        RunGroup.Companion.setIndex(0);
        HorizontalWidgetRun horizontalWidgetRun = this.mWidgetcontainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        this.findGroup(horizontalWidgetRun, 0, this.mGroups);
        VerticalWidgetRun verticalWidgetRun = this.mWidgetcontainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun);
        this.findGroup(verticalWidgetRun, 1, this.mGroups);
        this.mNeedBuildGraph = false;
    }

    public final void buildGraph(@NotNull ArrayList<WidgetRun> runs) {
        Intrinsics.checkNotNullParameter(runs, (String)"runs");
        runs.clear();
        HorizontalWidgetRun horizontalWidgetRun = this.mContainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
        horizontalWidgetRun.clear();
        VerticalWidgetRun verticalWidgetRun = this.mContainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun);
        verticalWidgetRun.clear();
        HorizontalWidgetRun horizontalWidgetRun2 = this.mContainer.getMHorizontalRun();
        Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
        runs.add(horizontalWidgetRun2);
        VerticalWidgetRun verticalWidgetRun2 = this.mContainer.getMVerticalRun();
        Intrinsics.checkNotNull((Object)verticalWidgetRun2);
        runs.add(verticalWidgetRun2);
        HashSet<ChainRun> chainRuns = null;
        for (ConstraintWidget widget : this.mContainer.getMChildren()) {
            if (widget instanceof Guideline) {
                runs.add(new GuidelineReference(widget));
                continue;
            }
            if (widget.isInHorizontalChain()) {
                if (widget.getHorizontalChainRun() == null) {
                    Intrinsics.checkNotNull((Object)widget);
                    widget.setHorizontalChainRun(new ChainRun(widget, 0));
                }
                if (chainRuns == null) {
                    chainRuns = new HashSet<ChainRun>();
                }
                ChainRun chainRun = widget.getHorizontalChainRun();
                Intrinsics.checkNotNull((Object)chainRun);
                chainRuns.add(chainRun);
            } else {
                HorizontalWidgetRun horizontalWidgetRun3 = widget.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                runs.add(horizontalWidgetRun3);
            }
            if (widget.isInVerticalChain()) {
                if (widget.getVerticalChainRun() == null) {
                    Intrinsics.checkNotNull((Object)widget);
                    widget.setVerticalChainRun(new ChainRun(widget, 1));
                }
                if (chainRuns == null) {
                    chainRuns = new HashSet();
                }
                ChainRun chainRun = widget.getVerticalChainRun();
                Intrinsics.checkNotNull((Object)chainRun);
                chainRuns.add(chainRun);
            } else {
                VerticalWidgetRun verticalWidgetRun3 = widget.getMVerticalRun();
                Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                runs.add(verticalWidgetRun3);
            }
            if (!(widget instanceof HelperWidget)) continue;
            runs.add(new HelperReferences(widget));
        }
        if (chainRuns != null) {
            runs.addAll((Collection<WidgetRun>)chainRuns);
        }
        for (WidgetRun run : runs) {
            run.clear();
        }
        for (WidgetRun run : runs) {
            if (Intrinsics.areEqual((Object)run.getMWidget(), (Object)this.mContainer)) continue;
            run.apply();
        }
    }

    private final void displayGraph() {
        Object content = "digraph {\n";
        for (WidgetRun run : this.mRuns) {
            Intrinsics.checkNotNull((Object)run);
            content = this.generateDisplayGraph(run, (String)content);
        }
        content = (String)content + "\n}\n";
        System.out.println((Object)("content:<<\n" + (String)content + "\n>>"));
    }

    private final void applyGroup(DependencyNode node, int orientation, int direction, DependencyNode end, ArrayList<RunGroup> groups, RunGroup group) {
        RunGroup group2 = group;
        WidgetRun run = node.getMRun();
        if (run.getMRunGroup() != null || Intrinsics.areEqual((Object)run, (Object)this.mWidgetcontainer.getMHorizontalRun()) || Intrinsics.areEqual((Object)run, (Object)this.mWidgetcontainer.getMVerticalRun())) {
            return;
        }
        if (group2 == null) {
            group2 = new RunGroup(run, direction);
            groups.add(group2);
        }
        run.setMRunGroup(group2);
        group2.add(run);
        for (Dependency dependent : run.getStart().getMDependencies()) {
            if (!(dependent instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependent, orientation, 0, end, groups, group2);
        }
        for (Dependency dependent : run.getEnd().getMDependencies()) {
            if (!(dependent instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependent, orientation, 1, end, groups, group2);
        }
        if (orientation == 1 && run instanceof VerticalWidgetRun) {
            for (Dependency dependent : ((VerticalWidgetRun)run).getBaseline().getMDependencies()) {
                if (!(dependent instanceof DependencyNode)) continue;
                this.applyGroup((DependencyNode)dependent, orientation, 2, end, groups, group2);
            }
        }
        for (DependencyNode target : run.getStart().getMTargets()) {
            if (Intrinsics.areEqual((Object)target, (Object)end)) {
                group2.setDual(true);
            }
            Intrinsics.checkNotNull((Object)target);
            this.applyGroup(target, orientation, 0, end, groups, group2);
        }
        for (DependencyNode target : run.getEnd().getMTargets()) {
            if (Intrinsics.areEqual((Object)target, (Object)end)) {
                group2.setDual(true);
            }
            Intrinsics.checkNotNull((Object)target);
            this.applyGroup(target, orientation, 1, end, groups, group2);
        }
        if (orientation == 1 && run instanceof VerticalWidgetRun) {
            for (DependencyNode target : ((VerticalWidgetRun)run).getBaseline().getMTargets()) {
                Intrinsics.checkNotNull((Object)target);
                this.applyGroup(target, orientation, 2, end, groups, group2);
            }
        }
    }

    private final void findGroup(WidgetRun run, int orientation, ArrayList<RunGroup> groups) {
        for (Dependency dependent : run.getStart().getMDependencies()) {
            if (dependent instanceof DependencyNode) {
                this.applyGroup((DependencyNode)dependent, orientation, 0, run.getEnd(), groups, null);
                continue;
            }
            if (!(dependent instanceof WidgetRun)) continue;
            this.applyGroup(((WidgetRun)dependent).getStart(), orientation, 0, run.getEnd(), groups, null);
        }
        for (Dependency dependent : run.getEnd().getMDependencies()) {
            if (dependent instanceof DependencyNode) {
                this.applyGroup((DependencyNode)dependent, orientation, 1, run.getStart(), groups, null);
                continue;
            }
            if (!(dependent instanceof WidgetRun)) continue;
            this.applyGroup(((WidgetRun)dependent).getEnd(), orientation, 1, run.getStart(), groups, null);
        }
        if (orientation == 1) {
            Intrinsics.checkNotNull((Object)run, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun");
            for (Dependency dependent : ((VerticalWidgetRun)run).getBaseline().getMDependencies()) {
                if (!(dependent instanceof DependencyNode)) continue;
                this.applyGroup((DependencyNode)dependent, orientation, 2, null, groups, null);
            }
        }
    }

    private final String generateDisplayNode(DependencyNode node, boolean centeredConnection, String content) {
        String content2 = content;
        StringBuilder contentBuilder = new StringBuilder(content2);
        for (DependencyNode target : node.getMTargets()) {
            Object constraint = StringsKt.trimIndent((String)("\n            \n            " + node.name() + "\n            "));
            constraint = (String)constraint + " -> " + target.name();
            if (node.getMMargin() > 0 || centeredConnection || node.getMRun() instanceof HelperReferences) {
                constraint = (String)constraint + "[";
                if (node.getMMargin() > 0) {
                    constraint = (String)constraint + "label=\"" + node.getMMargin() + "\"";
                    if (centeredConnection) {
                        constraint = (String)constraint + ",";
                    }
                }
                if (centeredConnection) {
                    constraint = (String)constraint + " style=dashed ";
                }
                if (node.getMRun() instanceof HelperReferences) {
                    constraint = (String)constraint + " style=bold,color=gray ";
                }
                constraint = (String)constraint + "]";
            }
            constraint = (String)constraint + "\n";
            contentBuilder.append((String)constraint);
        }
        String string = contentBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        content2 = string;
        return content2;
    }

    /*
     * Unable to fully structure code
     */
    private final String nodeDefinition(WidgetRun run) {
        orientation = run instanceof VerticalWidgetRun != false;
        v0 = run.getMWidget();
        Intrinsics.checkNotNull((Object)v0);
        v1 = v0.getDebugName();
        Intrinsics.checkNotNull((Object)v1);
        name = v1;
        definition = new StringBuilder(name);
        if (!orientation) {
            v2 = run.getMWidget();
            Intrinsics.checkNotNull((Object)v2);
            v3 = v2.getHorizontalDimensionBehaviour();
        } else {
            v4 = run.getMWidget();
            Intrinsics.checkNotNull((Object)v4);
            v3 = v4.getVerticalDimensionBehaviour();
        }
        behaviour = v3;
        runGroup = run.getMRunGroup();
        if (!orientation) {
            definition.append("_HORIZONTAL");
        } else {
            definition.append("_VERTICAL");
        }
        definition.append(" [shape=none, label=<");
        definition.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\">");
        definition.append("  <TR>");
        if (!orientation) {
            definition.append("    <TD ");
            if (run.getStart().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"LEFT\" BORDER=\"1\">L</TD>");
        } else {
            definition.append("    <TD ");
            if (run.getStart().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"TOP\" BORDER=\"1\">T</TD>");
        }
        definition.append("    <TD BORDER=\"1\" ");
        if (!run.getMDimension().getResolved()) ** GOTO lbl-1000
        v5 = run.getMWidget();
        Intrinsics.checkNotNull((Object)v5);
        if (!v5.getMeasured()) {
            definition.append(" BGCOLOR=\"green\" ");
        } else if (run.getMDimension().getResolved()) {
            definition.append(" BGCOLOR=\"lightgray\" ");
        } else {
            v6 = run.getMWidget();
            Intrinsics.checkNotNull((Object)v6);
            if (v6.getMeasured()) {
                definition.append(" BGCOLOR=\"yellow\" ");
            }
        }
        if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            definition.append("style=\"dashed\"");
        }
        definition.append(">");
        definition.append(name);
        if (runGroup != null) {
            definition.append(" [");
            definition.append(runGroup.getMGroupIndex() + 1);
            definition.append("/");
            definition.append(RunGroup.Companion.getIndex());
            definition.append("]");
        }
        definition.append(" </TD>");
        if (!orientation) {
            definition.append("    <TD ");
            if (run.getEnd().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"RIGHT\" BORDER=\"1\">R</TD>");
        } else {
            definition.append("    <TD ");
            Intrinsics.checkNotNull((Object)run, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun");
            if (((VerticalWidgetRun)run).getBaseline().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"BASELINE\" BORDER=\"1\">b</TD>");
            definition.append("    <TD ");
            if (run.getEnd().getResolved()) {
                definition.append(" BGCOLOR=\"green\"");
            }
            definition.append(" PORT=\"BOTTOM\" BORDER=\"1\">B</TD>");
        }
        definition.append("  </TR></TABLE>");
        definition.append(">];\n");
        v7 = definition.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"toString(...)");
        return v7;
    }

    private final String generateChainDisplayGraph(ChainRun chain, String content) {
        int orientation = chain.getOrientation();
        StringBuilder subgroup = new StringBuilder("subgraph ");
        subgroup.append("cluster_");
        ConstraintWidget constraintWidget = chain.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        subgroup.append(constraintWidget.getDebugName());
        if (orientation == 0) {
            subgroup.append("_h");
        } else {
            subgroup.append("_v");
        }
        subgroup.append(" {\n");
        String definitions = "";
        for (WidgetRun run : chain.getMWidgets()) {
            ConstraintWidget constraintWidget2 = run.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget2);
            subgroup.append(constraintWidget2.getDebugName());
            if (orientation == 0) {
                subgroup.append("_HORIZONTAL");
            } else {
                subgroup.append("_VERTICAL");
            }
            subgroup.append(";\n");
            Intrinsics.checkNotNull((Object)run);
            definitions = this.generateDisplayGraph(run, definitions);
        }
        subgroup.append("}\n");
        return content + definitions + subgroup;
    }

    private final boolean isCenteredConnection(DependencyNode start, DependencyNode end) {
        int startTargets = 0;
        int endTargets = 0;
        for (DependencyNode s : start.getMTargets()) {
            if (Intrinsics.areEqual((Object)s, (Object)end)) continue;
            ++startTargets;
        }
        for (DependencyNode e : end.getMTargets()) {
            if (Intrinsics.areEqual((Object)e, (Object)start)) continue;
            ++endTargets;
        }
        return startTargets > 0 && endTargets > 0;
    }

    private final String generateDisplayGraph(WidgetRun root, String content) {
        String string;
        ConstraintWidget.DimensionBehaviour behaviour;
        String content2 = content;
        DependencyNode start = root.getStart();
        DependencyNode end = root.getEnd();
        StringBuilder sb = new StringBuilder(content2);
        if (!(root instanceof HelperReferences) && start.getMDependencies().isEmpty() && end.getMDependencies().isEmpty() && start.getMTargets().isEmpty() && end.getMTargets().isEmpty()) {
            return content2;
        }
        sb.append(this.nodeDefinition(root));
        boolean centeredConnection = this.isCenteredConnection(start, end);
        content2 = this.generateDisplayNode(start, centeredConnection, content2);
        content2 = this.generateDisplayNode(end, centeredConnection, content2);
        if (root instanceof VerticalWidgetRun) {
            DependencyNode baseline = ((VerticalWidgetRun)root).getBaseline();
            content2 = this.generateDisplayNode(baseline, centeredConnection, content2);
        }
        if (root instanceof HorizontalWidgetRun || root instanceof ChainRun && root.getOrientation() == 0) {
            ConstraintWidget constraintWidget = root.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            behaviour = constraintWidget.getHorizontalDimensionBehaviour();
            if (behaviour == ConstraintWidget.DimensionBehaviour.FIXED || behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (!start.getMTargets().isEmpty() && end.getMTargets().isEmpty()) {
                    sb.append("\n");
                    sb.append(end.name());
                    sb.append(" -> ");
                    sb.append(start.name());
                    sb.append("\n");
                } else if (start.getMTargets().isEmpty() && !end.getMTargets().isEmpty()) {
                    sb.append("\n");
                    sb.append(start.name());
                    sb.append(" -> ");
                    sb.append(end.name());
                    sb.append("\n");
                }
            } else if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                ConstraintWidget constraintWidget2 = root.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget2);
                if (constraintWidget2.getDimensionRatio() > 0.0f) {
                    sb.append("\n");
                    ConstraintWidget constraintWidget3 = root.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget3);
                    sb.append(constraintWidget3.getDebugName());
                    sb.append("_HORIZONTAL -> ");
                    ConstraintWidget constraintWidget4 = root.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget4);
                    sb.append(constraintWidget4.getDebugName());
                    sb.append("_VERTICAL;\n");
                }
            }
        } else if (root instanceof VerticalWidgetRun || root instanceof ChainRun && root.getOrientation() == 1) {
            ConstraintWidget constraintWidget = root.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            behaviour = constraintWidget.getVerticalDimensionBehaviour();
            if (behaviour == ConstraintWidget.DimensionBehaviour.FIXED || behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (!start.getMTargets().isEmpty() && end.getMTargets().isEmpty()) {
                    sb.append("\n");
                    sb.append(end.name());
                    sb.append(" -> ");
                    sb.append(start.name());
                    sb.append("\n");
                } else if (start.getMTargets().isEmpty() && !end.getMTargets().isEmpty()) {
                    sb.append("\n");
                    sb.append(start.name());
                    sb.append(" -> ");
                    sb.append(end.name());
                    sb.append("\n");
                }
            } else if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                ConstraintWidget constraintWidget5 = root.getMWidget();
                Intrinsics.checkNotNull((Object)constraintWidget5);
                if (constraintWidget5.getDimensionRatio() > 0.0f) {
                    sb.append("\n");
                    ConstraintWidget constraintWidget6 = root.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget6);
                    sb.append(constraintWidget6.getDebugName());
                    sb.append("_VERTICAL -> ");
                    ConstraintWidget constraintWidget7 = root.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget7);
                    sb.append(constraintWidget7.getDebugName());
                    sb.append("_HORIZONTAL;\n");
                }
            }
        }
        if (root instanceof ChainRun) {
            string = this.generateChainDisplayGraph((ChainRun)root, content2);
        } else {
            String string2 = sb.toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/DependencyGraph$Companion;", "", "()V", "DEBUG", "", "USE_GROUPS", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

