/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.platform.System;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.Optimizer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000e\b\u0007\u0018\u0000 (2\u00020\u0001:\u0003()*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J0\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002JV\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure;", "", "constraintWidgetContainer", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "(Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;)V", "mConstraintWidgetContainer", "mMeasure", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measure;", "mVariableDimensionsWidgets", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "Lkotlin/collections/ArrayList;", "measure", "", "measurer", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measurer;", "widget", "measureStrategy", "", "measureChildren", "", "layout", "solveLinearSystem", "reason", "", "pass", "w", "h", "solverMeasure", "", "optimizationLevel", "paddingX", "paddingY", "widthMode", "widthSize", "heightMode", "heightSize", "lastMeasureWidth", "lastMeasureHeight", "updateHierarchy", "Companion", "Measure", "Measurer", "compose"})
@StabilityInferred(parameters=0)
public final class BasicMeasure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<ConstraintWidget> mVariableDimensionsWidgets;
    @NotNull
    private final Measure mMeasure;
    @NotNull
    private ConstraintWidgetContainer mConstraintWidgetContainer;
    public static final int $stable = 8;
    private static final boolean DEBUG = false;
    private static final boolean DO_NOT_USE = false;
    private static final int MODE_SHIFT = 30;
    public static final int UNSPECIFIED = 0;
    public static final int EXACTLY = 0x40000000;
    public static final int AT_MOST = Integer.MIN_VALUE;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    public static final int FIXED = -3;

    public BasicMeasure(@NotNull ConstraintWidgetContainer constraintWidgetContainer) {
        Intrinsics.checkNotNullParameter((Object)constraintWidgetContainer, (String)"constraintWidgetContainer");
        this.mVariableDimensionsWidgets = new ArrayList();
        this.mMeasure = new Measure();
        this.mConstraintWidgetContainer = constraintWidgetContainer;
    }

    public final void updateHierarchy(@NotNull ConstraintWidgetContainer layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.mVariableDimensionsWidgets.clear();
        int childCount = layout.getMChildren().size();
        for (int i = 0; i < childCount; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)layout.getMChildren().get(i), (String)"get(...)");
            if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            this.mVariableDimensionsWidgets.add(widget);
        }
        layout.invalidateGraph();
    }

    private final void measureChildren(ConstraintWidgetContainer layout) {
        int childCount = layout.getMChildren().size();
        boolean optimize = layout.optimizeFor(64);
        Measurer measurer = layout.getMeasurer();
        for (int i = 0; i < childCount; ++i) {
            Metrics metrics;
            boolean skip;
            ConstraintWidget child;
            Intrinsics.checkNotNullExpressionValue((Object)layout.getMChildren().get(i), (String)"get(...)");
            if (child instanceof Guideline || child instanceof Barrier || child.isInVirtualLayout()) continue;
            if (optimize && child.getMHorizontalRun() != null && child.getMVerticalRun() != null) {
                HorizontalWidgetRun horizontalWidgetRun = child.getMHorizontalRun();
                Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                if (horizontalWidgetRun.getMDimension().getResolved()) {
                    VerticalWidgetRun verticalWidgetRun = child.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    if (verticalWidgetRun.getMDimension().getResolved()) continue;
                }
            }
            ConstraintWidget.DimensionBehaviour widthBehavior = child.getDimensionBehaviour(0);
            ConstraintWidget.DimensionBehaviour heightBehavior = child.getDimensionBehaviour(1);
            boolean bl = skip = widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.getMMatchConstraintDefaultWidth() != 1 && heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.getMMatchConstraintDefaultHeight() != 1;
            if (!skip && layout.optimizeFor(1) && !(child instanceof VirtualLayout)) {
                if (widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.getMMatchConstraintDefaultWidth() == 0 && heightBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && !child.isInHorizontalChain()) {
                    skip = true;
                }
                if (heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.getMMatchConstraintDefaultHeight() == 0 && widthBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && !child.isInHorizontalChain()) {
                    skip = true;
                }
                if ((widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) && child.getMDimensionRatio() > 0.0f) {
                    skip = true;
                }
            }
            if (skip) continue;
            Measurer measurer2 = measurer;
            Intrinsics.checkNotNull((Object)measurer2);
            this.measure(measurer2, child, Measure.Companion.getSELF_DIMENSIONS());
            if (layout.getMMetrics() == null) continue;
            Intrinsics.checkNotNull((Object)layout.getMMetrics());
            long l = metrics.getMeasuredWidgets();
            metrics.setMeasuredWidgets(l + 1L);
        }
        Measurer measurer3 = measurer;
        Intrinsics.checkNotNull((Object)measurer3);
        measurer3.didMeasures();
    }

    private final void solveLinearSystem(ConstraintWidgetContainer layout, String reason, int pass, int w, int h) {
        long startLayout = 0L;
        if (layout.getMMetrics() != null) {
            startLayout = System.INSTANCE.nanoTime();
        }
        int minWidth = layout.getMinWidth();
        int minHeight = layout.getMinHeight();
        layout.setMinWidth(0);
        layout.setMinHeight(0);
        layout.setWidth(w);
        layout.setHeight(h);
        layout.setMinWidth(minWidth);
        layout.setMinHeight(minHeight);
        this.mConstraintWidgetContainer.setPass(pass);
        this.mConstraintWidgetContainer.layout();
        if (layout.getMMetrics() != null) {
            long endLayout = System.INSTANCE.nanoTime();
            Metrics metrics = layout.getMMetrics();
            Intrinsics.checkNotNull((Object)metrics);
            Metrics metrics2 = metrics;
            long l = metrics2.getMSolverPasses();
            metrics2.setMSolverPasses(l + 1L);
            Metrics metrics3 = layout.getMMetrics();
            Intrinsics.checkNotNull((Object)metrics3);
            metrics2 = metrics3;
            metrics2.setMeasuresLayoutDuration(metrics2.getMeasuresLayoutDuration() + (endLayout - startLayout));
        }
    }

    public final long solverMeasure(@NotNull ConstraintWidgetContainer layout, int optimizationLevel, int paddingX, int paddingY, int widthMode, int widthSize, int heightMode, int heightSize, int lastMeasureWidth, int lastMeasureHeight) {
        boolean optimize;
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        int widthSize2 = widthSize;
        int heightSize2 = heightSize;
        Measurer measurer = layout.getMeasurer();
        long layoutTime = 0L;
        int childCount = layout.getMChildren().size();
        int startingWidth = layout.getWidth();
        int startingHeight = layout.getHeight();
        boolean optimizeWrap = Optimizer.Companion.enabled(optimizationLevel, 128);
        boolean bl = optimize = optimizeWrap || Optimizer.Companion.enabled(optimizationLevel, 64);
        if (optimize) {
            for (int i = 0; i < childCount; ++i) {
                boolean ratio;
                ConstraintWidget child;
                Intrinsics.checkNotNullExpressionValue((Object)layout.getMChildren().get(i), (String)"get(...)");
                boolean matchWidth = child.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                boolean matchHeight = child.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                boolean bl2 = ratio = matchWidth && matchHeight && child.getDimensionRatio() > 0.0f;
                if (child.isInHorizontalChain() && ratio) {
                    optimize = false;
                    break;
                }
                if (child.isInVerticalChain() && ratio) {
                    optimize = false;
                    break;
                }
                if (child instanceof VirtualLayout) {
                    optimize = false;
                    break;
                }
                if (!child.isInHorizontalChain() && !child.isInVerticalChain()) continue;
                optimize = false;
                break;
            }
        }
        if (optimize && LinearSystem.Companion.getSMetrics() != null) {
            Metrics metrics = LinearSystem.Companion.getSMetrics();
            Intrinsics.checkNotNull((Object)metrics);
            Metrics i = metrics;
            long child = i.getMeasures();
            i.setMeasures(child + 1L);
        }
        boolean allSolved = false;
        boolean bl3 = widthMode == 0x40000000 && heightMode == 0x40000000 || optimizeWrap;
        int computations = 0;
        if (optimize &= bl3) {
            widthSize2 = Math.min(layout.getMaxWidth(), widthSize2);
            heightSize2 = Math.min(layout.getMaxHeight(), heightSize2);
            if (widthMode == 0x40000000 && layout.getWidth() != widthSize2) {
                layout.setWidth(widthSize2);
                layout.invalidateGraph();
            }
            if (heightMode == 0x40000000 && layout.getHeight() != heightSize2) {
                layout.setHeight(heightSize2);
                layout.invalidateGraph();
            }
            if (widthMode == 0x40000000 && heightMode == 0x40000000) {
                allSolved = layout.directMeasure(optimizeWrap);
                computations = 2;
            } else {
                allSolved = layout.directMeasureSetup(optimizeWrap);
                if (widthMode == 0x40000000) {
                    allSolved &= layout.directMeasureWithOrientation(optimizeWrap, 0);
                    ++computations;
                }
                if (heightMode == 0x40000000) {
                    allSolved &= layout.directMeasureWithOrientation(optimizeWrap, 1);
                    ++computations;
                }
            }
            if (allSolved) {
                layout.updateFromRuns(widthMode == 0x40000000, heightMode == 0x40000000);
            }
        }
        if (!allSolved || computations != 2) {
            int optimizations = layout.getOptimizationLevel();
            if (childCount > 0) {
                this.measureChildren(layout);
            }
            if (layout.getMMetrics() != null) {
                layoutTime = System.INSTANCE.nanoTime();
            }
            this.updateHierarchy(layout);
            int sizeDependentWidgetsCount = this.mVariableDimensionsWidgets.size();
            if (childCount > 0) {
                this.solveLinearSystem(layout, "First pass", 0, startingWidth, startingHeight);
            }
            if (sizeDependentWidgetsCount > 0) {
                boolean needSolverPass = false;
                boolean containerWrapWidth = layout.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                boolean containerWrapHeight = layout.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                int minWidth = Math.max(layout.getWidth(), this.mConstraintWidgetContainer.getMinWidth());
                int minHeight = Math.max(layout.getHeight(), this.mConstraintWidgetContainer.getMinHeight());
                for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                    ConstraintWidget widget;
                    Intrinsics.checkNotNullExpressionValue((Object)this.mVariableDimensionsWidgets.get(i), (String)"get(...)");
                    if (!(widget instanceof VirtualLayout)) continue;
                    int preWidth = widget.getWidth();
                    int preHeight = widget.getHeight();
                    Measurer measurer2 = measurer;
                    Intrinsics.checkNotNull((Object)measurer2);
                    needSolverPass |= this.measure(measurer2, widget, Measure.Companion.getTRY_GIVEN_DIMENSIONS());
                    if (layout.getMMetrics() != null) {
                        Metrics metrics;
                        Intrinsics.checkNotNull((Object)layout.getMMetrics());
                        long l = metrics.getMeasuredMatchWidgets();
                        metrics.setMeasuredMatchWidgets(l + 1L);
                    }
                    int measuredWidth = widget.getWidth();
                    int measuredHeight = widget.getHeight();
                    if (measuredWidth != preWidth) {
                        widget.setWidth(measuredWidth);
                        if (containerWrapWidth && widget.getRight() > minWidth) {
                            int n = widget.getRight();
                            ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
                            Intrinsics.checkNotNull((Object)constraintAnchor);
                            int w = n + constraintAnchor.getMargin();
                            minWidth = Math.max(minWidth, w);
                        }
                        needSolverPass = true;
                    }
                    if (measuredHeight != preHeight) {
                        widget.setHeight(measuredHeight);
                        if (containerWrapHeight && widget.getBottom() > minHeight) {
                            int n = widget.getBottom();
                            ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
                            Intrinsics.checkNotNull((Object)constraintAnchor);
                            int h = n + constraintAnchor.getMargin();
                            minHeight = Math.max(minHeight, h);
                        }
                        needSolverPass = true;
                    }
                    needSolverPass |= ((VirtualLayout)widget).needSolverPass();
                }
                int maxIterations = 2;
                for (int j = 0; j < maxIterations; ++j) {
                    for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                        ConstraintWidget widget;
                        Intrinsics.checkNotNullExpressionValue((Object)this.mVariableDimensionsWidgets.get(i), (String)"get(...)");
                        if (widget instanceof Helper && !(widget instanceof VirtualLayout) || widget instanceof Guideline || widget.getVisibility() == 8) continue;
                        if (optimize) {
                            HorizontalWidgetRun horizontalWidgetRun = widget.getMHorizontalRun();
                            Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                            if (horizontalWidgetRun.getMDimension().getResolved()) {
                                VerticalWidgetRun verticalWidgetRun = widget.getMVerticalRun();
                                Intrinsics.checkNotNull((Object)verticalWidgetRun);
                                if (verticalWidgetRun.getMDimension().getResolved()) continue;
                            }
                        }
                        if (widget instanceof VirtualLayout) continue;
                        int preWidth = widget.getWidth();
                        int preHeight = widget.getHeight();
                        int preBaselineDistance = widget.getBaselineDistance();
                        int measureStrategy = Measure.Companion.getTRY_GIVEN_DIMENSIONS();
                        if (j == maxIterations - 1) {
                            measureStrategy = Measure.Companion.getUSE_GIVEN_DIMENSIONS();
                        }
                        Measurer measurer3 = measurer;
                        Intrinsics.checkNotNull((Object)measurer3);
                        boolean hasMeasure = this.measure(measurer3, widget, measureStrategy);
                        needSolverPass |= hasMeasure;
                        if (layout.getMMetrics() != null) {
                            Metrics metrics;
                            Intrinsics.checkNotNull((Object)layout.getMMetrics());
                            long l = metrics.getMeasuredMatchWidgets();
                            metrics.setMeasuredMatchWidgets(l + 1L);
                        }
                        int measuredWidth = widget.getWidth();
                        int measuredHeight = widget.getHeight();
                        if (measuredWidth != preWidth) {
                            widget.setWidth(measuredWidth);
                            if (containerWrapWidth && widget.getRight() > minWidth) {
                                int n = widget.getRight();
                                ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
                                Intrinsics.checkNotNull((Object)constraintAnchor);
                                int w = n + constraintAnchor.getMargin();
                                minWidth = Math.max(minWidth, w);
                            }
                            needSolverPass = true;
                        }
                        if (measuredHeight != preHeight) {
                            widget.setHeight(measuredHeight);
                            if (containerWrapHeight && widget.getBottom() > minHeight) {
                                int n = widget.getBottom();
                                ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
                                Intrinsics.checkNotNull((Object)constraintAnchor);
                                int h = n + constraintAnchor.getMargin();
                                minHeight = Math.max(minHeight, h);
                            }
                            needSolverPass = true;
                        }
                        if (!widget.getHasBaseline() || preBaselineDistance == widget.getBaselineDistance()) continue;
                        needSolverPass = true;
                    }
                    if (!needSolverPass) break;
                    this.solveLinearSystem(layout, "intermediate pass", 1 + j, startingWidth, startingHeight);
                    needSolverPass = false;
                }
            }
            layout.setOptimizationLevel(optimizations);
        }
        if (layout.getMMetrics() != null) {
            layoutTime = System.INSTANCE.nanoTime() - layoutTime;
        }
        return layoutTime;
    }

    private final boolean measure(Measurer measurer, ConstraintWidget widget, int measureStrategy) {
        boolean verticalUseRatio;
        this.mMeasure.setHorizontalBehavior(widget.getHorizontalDimensionBehaviour());
        this.mMeasure.setVerticalBehavior(widget.getVerticalDimensionBehaviour());
        this.mMeasure.setHorizontalDimension(widget.getWidth());
        this.mMeasure.setVerticalDimension(widget.getHeight());
        this.mMeasure.setMeasuredNeedsSolverPass(false);
        this.mMeasure.setMeasureStrategy(measureStrategy);
        boolean horizontalMatchConstraints = this.mMeasure.getHorizontalBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        boolean verticalMatchConstraints = this.mMeasure.getVerticalBehavior() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        boolean horizontalUseRatio = horizontalMatchConstraints && widget.getMDimensionRatio() > 0.0f;
        boolean bl = verticalUseRatio = verticalMatchConstraints && widget.getMDimensionRatio() > 0.0f;
        if (horizontalUseRatio && widget.getMResolvedMatchConstraintDefault()[0] == 4) {
            this.mMeasure.setHorizontalBehavior(ConstraintWidget.DimensionBehaviour.FIXED);
        }
        if (verticalUseRatio && widget.getMResolvedMatchConstraintDefault()[1] == 4) {
            this.mMeasure.setVerticalBehavior(ConstraintWidget.DimensionBehaviour.FIXED);
        }
        measurer.measure(widget, this.mMeasure);
        widget.setWidth(this.mMeasure.getMeasuredWidth());
        widget.setHeight(this.mMeasure.getMeasuredHeight());
        widget.setHasBaseline(this.mMeasure.getMeasuredHasBaseline());
        widget.setBaselineDistance(this.mMeasure.getMeasuredBaseline());
        this.mMeasure.setMeasureStrategy(Measure.Companion.getSELF_DIMENSIONS());
        return this.mMeasure.getMeasuredNeedsSolverPass();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Companion;", "", "()V", "AT_MOST", "", "DEBUG", "", "DO_NOT_USE", "EXACTLY", "FIXED", "MATCH_PARENT", "MODE_SHIFT", "UNSPECIFIED", "WRAP_CONTENT", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u001a\u0010!\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010\u000eR\u001a\u0010$\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u001a\u0010'\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010\u000e\u00a8\u0006+"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measure;", "", "()V", "horizontalBehavior", "Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;", "getHorizontalBehavior", "()Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;", "setHorizontalBehavior", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget$DimensionBehaviour;)V", "horizontalDimension", "", "getHorizontalDimension", "()I", "setHorizontalDimension", "(I)V", "measureStrategy", "getMeasureStrategy", "setMeasureStrategy", "measuredBaseline", "getMeasuredBaseline", "setMeasuredBaseline", "measuredHasBaseline", "", "getMeasuredHasBaseline", "()Z", "setMeasuredHasBaseline", "(Z)V", "measuredHeight", "getMeasuredHeight", "setMeasuredHeight", "measuredNeedsSolverPass", "getMeasuredNeedsSolverPass", "setMeasuredNeedsSolverPass", "measuredWidth", "getMeasuredWidth", "setMeasuredWidth", "verticalBehavior", "getVerticalBehavior", "setVerticalBehavior", "verticalDimension", "getVerticalDimension", "setVerticalDimension", "Companion", "compose"})
    @StabilityInferred(parameters=0)
    public static final class Measure {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public ConstraintWidget.DimensionBehaviour horizontalBehavior;
        public ConstraintWidget.DimensionBehaviour verticalBehavior;
        private int horizontalDimension;
        private int verticalDimension;
        private int measuredWidth;
        private int measuredHeight;
        private int measuredBaseline;
        private boolean measuredHasBaseline;
        private boolean measuredNeedsSolverPass;
        private int measureStrategy;
        public static final int $stable = 8;
        private static int SELF_DIMENSIONS;
        private static int TRY_GIVEN_DIMENSIONS;
        private static int USE_GIVEN_DIMENSIONS;

        @NotNull
        public final ConstraintWidget.DimensionBehaviour getHorizontalBehavior() {
            ConstraintWidget.DimensionBehaviour dimensionBehaviour = this.horizontalBehavior;
            if (dimensionBehaviour != null) {
                return dimensionBehaviour;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"horizontalBehavior");
            return null;
        }

        public final void setHorizontalBehavior(@NotNull ConstraintWidget.DimensionBehaviour dimensionBehaviour) {
            Intrinsics.checkNotNullParameter((Object)((Object)dimensionBehaviour), (String)"<set-?>");
            this.horizontalBehavior = dimensionBehaviour;
        }

        @NotNull
        public final ConstraintWidget.DimensionBehaviour getVerticalBehavior() {
            ConstraintWidget.DimensionBehaviour dimensionBehaviour = this.verticalBehavior;
            if (dimensionBehaviour != null) {
                return dimensionBehaviour;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"verticalBehavior");
            return null;
        }

        public final void setVerticalBehavior(@NotNull ConstraintWidget.DimensionBehaviour dimensionBehaviour) {
            Intrinsics.checkNotNullParameter((Object)((Object)dimensionBehaviour), (String)"<set-?>");
            this.verticalBehavior = dimensionBehaviour;
        }

        public final int getHorizontalDimension() {
            return this.horizontalDimension;
        }

        public final void setHorizontalDimension(int n) {
            this.horizontalDimension = n;
        }

        public final int getVerticalDimension() {
            return this.verticalDimension;
        }

        public final void setVerticalDimension(int n) {
            this.verticalDimension = n;
        }

        public final int getMeasuredWidth() {
            return this.measuredWidth;
        }

        public final void setMeasuredWidth(int n) {
            this.measuredWidth = n;
        }

        public final int getMeasuredHeight() {
            return this.measuredHeight;
        }

        public final void setMeasuredHeight(int n) {
            this.measuredHeight = n;
        }

        public final int getMeasuredBaseline() {
            return this.measuredBaseline;
        }

        public final void setMeasuredBaseline(int n) {
            this.measuredBaseline = n;
        }

        public final boolean getMeasuredHasBaseline() {
            return this.measuredHasBaseline;
        }

        public final void setMeasuredHasBaseline(boolean bl) {
            this.measuredHasBaseline = bl;
        }

        public final boolean getMeasuredNeedsSolverPass() {
            return this.measuredNeedsSolverPass;
        }

        public final void setMeasuredNeedsSolverPass(boolean bl) {
            this.measuredNeedsSolverPass = bl;
        }

        public final int getMeasureStrategy() {
            return this.measureStrategy;
        }

        public final void setMeasureStrategy(int n) {
            this.measureStrategy = n;
        }

        static {
            TRY_GIVEN_DIMENSIONS = 1;
            USE_GIVEN_DIMENSIONS = 2;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measure$Companion;", "", "()V", "SELF_DIMENSIONS", "", "getSELF_DIMENSIONS", "()I", "setSELF_DIMENSIONS", "(I)V", "TRY_GIVEN_DIMENSIONS", "getTRY_GIVEN_DIMENSIONS", "setTRY_GIVEN_DIMENSIONS", "USE_GIVEN_DIMENSIONS", "getUSE_GIVEN_DIMENSIONS", "setUSE_GIVEN_DIMENSIONS", "compose"})
        public static final class Companion {
            private Companion() {
            }

            public final int getSELF_DIMENSIONS() {
                return SELF_DIMENSIONS;
            }

            public final void setSELF_DIMENSIONS(int n) {
                SELF_DIMENSIONS = n;
            }

            public final int getTRY_GIVEN_DIMENSIONS() {
                return TRY_GIVEN_DIMENSIONS;
            }

            public final void setTRY_GIVEN_DIMENSIONS(int n) {
                TRY_GIVEN_DIMENSIONS = n;
            }

            public final int getUSE_GIVEN_DIMENSIONS() {
                return USE_GIVEN_DIMENSIONS;
            }

            public final void setUSE_GIVEN_DIMENSIONS(int n) {
                USE_GIVEN_DIMENSIONS = n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measurer;", "", "didMeasures", "", "measure", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "Landroidx/constraintlayout/core/widgets/analyzer/BasicMeasure$Measure;", "compose"})
    public static interface Measurer {
        public void measure(@NotNull ConstraintWidget var1, @NotNull Measure var2);

        public void didMeasures();
    }
}

