/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\r\n\u0002\b\u0013\b\u0007\u0018\u0000 H2\u00020\u0001:\u0001HB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J0\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J\b\u0010)\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J\u001b\u0010+\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010-J\u001b\u0010.\u001a\u00020\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010-J\b\u00100\u001a\u00020\u001bH\u0002J(\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0012\u00104\u001a\u00020&2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u000e\u00107\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u001d\u00108\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u00105\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u00109J\u000e\u0010:\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u0010;\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u0004J\u000e\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u0018J\u000e\u0010C\u001a\u00020\u001b2\u0006\u0010D\u001a\u000206J\u0006\u0010E\u001a\u00020\u001bJ\u000e\u0010F\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\b\u0010G\u001a\u00020\u001bH\u0002R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Landroidx/constraintlayout/core/utils/GridEngine;", "", "()V", "rows", "", "columns", "(II)V", "numWidgets", "(III)V", "mColumns", "mColumnsSet", "mConstraintMatrix", "", "", "[[I", "mNextAvailableIndex", "mNumWidgets", "mOrientation", "mPositionMatrix", "", "[[Z", "mRows", "mRowsSet", "mStrSkips", "", "mStrSpans", "addAllConstraintPositions", "", "addConstraintPosition", "widgetId", "row", "column", "rowSpan", "columnSpan", "bottomOfWidget", "i", "fillConstraintMatrix", "isUpdate", "", "getColByIndex", "index", "getNextPosition", "getRowByIndex", "handleSkips", "skipsMatrix", "([[I)V", "handleSpans", "spansMatrix", "initVariables", "invalidatePositions", "startRow", "startColumn", "isSpansValid", "str", "", "leftOfWidget", "parseSpans", "(Ljava/lang/String;)[[I", "rightOfWidget", "setColumns", "setNumWidgets", "num", "setOrientation", "orientation", "setRows", "setSkips", "skips", "setSpans", "spans", "setup", "topOfWidget", "updateActualRowsAndColumns", "Companion", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGridEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridEngine.kt\nandroidx/constraintlayout/core/utils/GridEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,568:1\n731#2,9:569\n731#2,9:603\n731#2,9:614\n37#3,2:578\n37#3,2:612\n37#3,2:623\n107#4:580\n79#4,22:581\n107#4:625\n79#4,22:626\n107#4:649\n79#4,22:650\n1#5:648\n*S KotlinDebug\n*F\n+ 1 GridEngine.kt\nandroidx/constraintlayout/core/utils/GridEngine\n*L\n190#1:569,9\n201#1:603,9\n204#1:614,9\n191#1:578,2\n202#1:612,2\n204#1:623,2\n201#1:580\n201#1:581,22\n231#1:625\n231#1:626,22\n235#1:649\n235#1:650,22\n*E\n"})
public final class GridEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mRows;
    private int mRowsSet;
    private int mNumWidgets;
    private int mColumns;
    private int mColumnsSet;
    @Nullable
    private String mStrSpans;
    @Nullable
    private String mStrSkips;
    private int mOrientation;
    private int mNextAvailableIndex;
    @Nullable
    private boolean[][] mPositionMatrix;
    @Nullable
    private int[][] mConstraintMatrix;
    public static final int $stable = 8;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    private static final int MAX_ROWS = 50;
    private static final int MAX_COLUMNS = 50;
    private static final int DEFAULT_SIZE = 3;

    public GridEngine() {
    }

    public GridEngine(int rows, int columns) {
        this.mRowsSet = rows;
        this.mColumnsSet = columns;
        if (rows > 50) {
            this.mRowsSet = 3;
        }
        if (columns > 50) {
            this.mColumnsSet = 3;
        }
        this.updateActualRowsAndColumns();
        this.initVariables();
    }

    public GridEngine(int rows, int columns, int numWidgets) {
        this.mRowsSet = rows;
        this.mColumnsSet = columns;
        this.mNumWidgets = numWidgets;
        if (rows > 50) {
            this.mRowsSet = 3;
        }
        if (columns > 50) {
            this.mColumnsSet = 3;
        }
        this.updateActualRowsAndColumns();
        if (numWidgets > this.mRows * this.mColumns || numWidgets < 1) {
            this.mNumWidgets = this.mRows * this.mColumns;
        }
        this.initVariables();
        this.fillConstraintMatrix(false);
    }

    private final void initVariables() {
        int n = 0;
        int n2 = this.mRows;
        boolean[][] blArrayArray = new boolean[n2][];
        GridEngine gridEngine = this;
        while (n < n2) {
            int n3 = n++;
            blArrayArray[n3] = new boolean[this.mColumns];
        }
        gridEngine.mPositionMatrix = blArrayArray;
        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
        boolean[][] blArray = this.mPositionMatrix;
        int n4 = ((Object[])blArray).length;
        for (n2 = 0; n2 < n4; ++n2) {
            boolean[] row = blArray[n2];
            ArraysKt.fill$default((boolean[])row, (boolean)true, (int)0, (int)0, (int)6, null);
        }
        if (this.mNumWidgets > 0) {
            int n5 = 0;
            n2 = this.mNumWidgets;
            int[][] nArrayArray = new int[n2][];
            gridEngine = this;
            while (n5 < n2) {
                int row = n5++;
                nArrayArray[row] = new int[4];
            }
            gridEngine.mConstraintMatrix = nArrayArray;
            Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
            int[][] nArray = this.mConstraintMatrix;
            int n6 = ((Object[])nArray).length;
            for (n2 = 0; n2 < n6; ++n2) {
                int[] row = nArray[n2];
                ArraysKt.fill$default((int[])row, (int)-1, (int)0, (int)0, (int)6, null);
            }
        }
    }

    private final int getRowByIndex(int index) {
        return this.mOrientation == 1 ? index % this.mRows : index / this.mColumns;
    }

    private final int getColByIndex(int index) {
        return this.mOrientation == 1 ? index / this.mRows : index % this.mColumns;
    }

    private final boolean isSpansValid(CharSequence str) {
        return str != null;
    }

    private final int[][] parseSpans(String str) {
        List list;
        Object it;
        if (!this.isSpansValid(str)) {
            return null;
        }
        CharSequence charSequence = str;
        Regex regex = new Regex(",");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        int $i$f$toTypedArray = 0;
        Collection thisCollection$iv232 = $this$toTypedArray$iv;
        String[] spans = thisCollection$iv232.toArray(new String[0]);
        $i$f$toTypedArray = 0;
        int thisCollection$iv232 = spans.length;
        it = new int[thisCollection$iv232][];
        while ($i$f$toTypedArray < thisCollection$iv232) {
            int n2 = $i$f$toTypedArray++;
            it[n2] = new int[3];
        }
        Object spanMatrix = it;
        String[] indexAndSpan = null;
        String[] rowAndCol = null;
        for (String string : spans) {
            List list2;
            List list3;
            boolean bl;
            boolean $i$f$trim232 = false;
            CharSequence $this$trim$iv$iv232 = string;
            boolean $i$f$trim = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv232.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it2 = $this$trim$iv$iv232.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            CharSequence charSequence2 = ((Object)$this$trim$iv$iv232.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Regex $i$f$trim232 = new Regex(":");
            int $this$trim$iv$iv232 = 0;
            List list4 = $i$f$trim232.split(charSequence2, $this$trim$iv$iv232);
            boolean $i$f$dropLastWhile2 = false;
            if (!list4.isEmpty()) {
                ListIterator iterator$iv = list4.listIterator(list4.size());
                while (iterator$iv.hasPrevious()) {
                    String it3 = (String)iterator$iv.previous();
                    bl = false;
                    if (((CharSequence)it3).length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)list4, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            Collection collection = list3;
            boolean $i$f$toTypedArray232 = false;
            Collection thisCollection$iv332 = collection;
            indexAndSpan = thisCollection$iv332.toArray(new String[0]);
            CharSequence charSequence3 = indexAndSpan[1];
            Regex $i$f$toTypedArray232 = new Regex("x");
            int thisCollection$iv332 = 0;
            List list5 = $i$f$toTypedArray232.split(charSequence3, thisCollection$iv332);
            boolean $i$f$dropLastWhile3 = false;
            if (!list5.isEmpty()) {
                ListIterator iterator$iv = list5.listIterator(list5.size());
                while (iterator$iv.hasPrevious()) {
                    String it4 = (String)iterator$iv.previous();
                    bl = false;
                    if (((CharSequence)it4).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)list5, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Collection collection2 = list2;
            boolean $i$f$toTypedArray3 = false;
            Collection thisCollection$iv = collection2;
            rowAndCol = thisCollection$iv.toArray(new String[0]);
            spanMatrix[i][0] = Integer.parseInt(indexAndSpan[0]);
            spanMatrix[i][1] = Integer.parseInt(rowAndCol[0]);
            spanMatrix[i][2] = Integer.parseInt(rowAndCol[1]);
        }
        return spanMatrix;
    }

    private final void fillConstraintMatrix(boolean isUpdate) {
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        boolean startFound$iv$iv;
        int endIndex$iv$iv;
        int startIndex$iv$iv;
        boolean $i$f$trim;
        boolean $i$f$trim2;
        if (isUpdate) {
            int j;
            int n;
            int i;
            Intrinsics.checkNotNull((Object)this.mPositionMatrix);
            int n2 = ((Object[])this.mPositionMatrix).length;
            for (i = 0; i < n2; ++i) {
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                n = this.mPositionMatrix[0].length;
                for (j = 0; j < n; ++j) {
                    Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                    this.mPositionMatrix[i][j] = true;
                }
            }
            Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
            n2 = ((Object[])this.mConstraintMatrix).length;
            for (i = 0; i < n2; ++i) {
                Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
                n = this.mConstraintMatrix[0].length;
                for (j = 0; j < n; ++j) {
                    Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
                    this.mConstraintMatrix[i][j] = -1;
                }
            }
        }
        this.mNextAvailableIndex = 0;
        if (this.mStrSkips != null) {
            String string = this.mStrSkips;
            Intrinsics.checkNotNull((Object)string);
            String $this$trim$iv = string;
            $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) {
                int[][] mSkips;
                String string2 = this.mStrSkips;
                Intrinsics.checkNotNull((Object)string2);
                if (mSkips != null) {
                    int[][] it2 = mSkips = this.parseSpans(string2);
                    boolean bl = false;
                    this.handleSkips(it2);
                }
            }
        }
        if (this.mStrSpans != null) {
            String string = this.mStrSpans;
            Intrinsics.checkNotNull((Object)string);
            String $this$trim$iv = string;
            $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) {
                int[][] mSpans;
                String string3 = this.mStrSpans;
                Intrinsics.checkNotNull((Object)string3);
                if (mSpans != null) {
                    int[][] it3 = mSpans = this.parseSpans(string3);
                    boolean bl = false;
                    this.handleSpans(it3);
                }
            }
        }
        this.addAllConstraintPositions();
    }

    private final int getNextPosition() {
        int position = 0;
        boolean positionFound = false;
        while (!positionFound) {
            if (this.mNextAvailableIndex >= this.mRows * this.mColumns) {
                return -1;
            }
            position = this.mNextAvailableIndex;
            int row = this.getRowByIndex(this.mNextAvailableIndex);
            int col = this.getColByIndex(this.mNextAvailableIndex);
            Intrinsics.checkNotNull((Object)this.mPositionMatrix);
            if (this.mPositionMatrix[row][col]) {
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                this.mPositionMatrix[row][col] = false;
                positionFound = true;
            }
            int n = this.mNextAvailableIndex;
            this.mNextAvailableIndex = n + 1;
        }
        return position;
    }

    private final void addConstraintPosition(int widgetId, int row, int column, int rowSpan, int columnSpan) {
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        this.mConstraintMatrix[widgetId][0] = column;
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        this.mConstraintMatrix[widgetId][1] = row;
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        this.mConstraintMatrix[widgetId][2] = column + columnSpan - 1;
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        this.mConstraintMatrix[widgetId][3] = row + rowSpan - 1;
    }

    private final void handleSpans(int[][] spansMatrix) {
        int n = ((Object[])spansMatrix).length;
        for (int i = 0; i < n; ++i) {
            int col;
            int row = this.getRowByIndex(spansMatrix[i][0]);
            if (!this.invalidatePositions(row, col = this.getColByIndex(spansMatrix[i][0]), spansMatrix[i][1], spansMatrix[i][2])) {
                return;
            }
            this.addConstraintPosition(i, row, col, spansMatrix[i][1], spansMatrix[i][2]);
        }
    }

    private final void handleSkips(int[][] skipsMatrix) {
        int n = ((Object[])skipsMatrix).length;
        for (int i = 0; i < n; ++i) {
            int col;
            int row = this.getRowByIndex(skipsMatrix[i][0]);
            if (this.invalidatePositions(row, col = this.getColByIndex(skipsMatrix[i][0]), skipsMatrix[i][1], skipsMatrix[i][2])) continue;
            return;
        }
    }

    private final boolean invalidatePositions(int startRow, int startColumn, int rowSpan, int columnSpan) {
        int n = startRow + rowSpan;
        for (int i = startRow; i < n; ++i) {
            int n2 = startColumn + columnSpan;
            for (int j = startColumn; j < n2; ++j) {
                block5: {
                    block4: {
                        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                        if (i >= ((Object[])this.mPositionMatrix).length) break block4;
                        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                        if (j >= this.mPositionMatrix[0].length) break block4;
                        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                        if (this.mPositionMatrix[i][j]) break block5;
                    }
                    return false;
                }
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                this.mPositionMatrix[i][j] = false;
            }
        }
        return true;
    }

    private final void addAllConstraintPositions() {
        int position = 0;
        int n = this.mNumWidgets;
        for (int i = 0; i < n; ++i) {
            if (this.leftOfWidget(i) != -1) continue;
            position = this.getNextPosition();
            int row = this.getRowByIndex(position);
            int col = this.getColByIndex(position);
            if (position == -1) {
                return;
            }
            this.addConstraintPosition(i, row, col, 1, 1);
        }
    }

    private final void updateActualRowsAndColumns() {
        if (this.mRowsSet == 0 || this.mColumnsSet == 0) {
            if (this.mColumnsSet > 0) {
                this.mColumns = this.mColumnsSet;
                this.mRows = (this.mNumWidgets + this.mColumns - 1) / this.mColumnsSet;
            } else if (this.mRowsSet > 0) {
                this.mRows = this.mRowsSet;
                this.mColumns = (this.mNumWidgets + this.mRowsSet - 1) / this.mRowsSet;
            } else {
                this.mRows = (int)(1.5 + Math.sqrt(this.mNumWidgets));
                this.mColumns = (this.mNumWidgets + this.mRows - 1) / this.mRows;
            }
        } else {
            this.mRows = this.mRowsSet;
            this.mColumns = this.mColumnsSet;
        }
    }

    public final void setup() {
        boolean isUpdate;
        block5: {
            block4: {
                isUpdate = true;
                if (this.mConstraintMatrix == null) break block4;
                Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
                if (((Object[])this.mConstraintMatrix).length != this.mNumWidgets || this.mPositionMatrix == null) break block4;
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                if (((Object[])this.mPositionMatrix).length != this.mRows) break block4;
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                if (this.mPositionMatrix[0].length == this.mColumns) break block5;
            }
            isUpdate = false;
        }
        if (!isUpdate) {
            this.initVariables();
        }
        this.fillConstraintMatrix(isUpdate);
    }

    public final void setSpans(@NotNull CharSequence spans) {
        Intrinsics.checkNotNullParameter((Object)spans, (String)"spans");
        if (this.mStrSpans != null && Intrinsics.areEqual((Object)this.mStrSpans, (Object)((Object)spans).toString())) {
            return;
        }
        this.mStrSpans = ((Object)spans).toString();
    }

    public final void setSkips(@NotNull String skips) {
        Intrinsics.checkNotNullParameter((Object)skips, (String)"skips");
        if (this.mStrSkips != null && Intrinsics.areEqual((Object)this.mStrSkips, (Object)skips)) {
            return;
        }
        this.mStrSkips = skips;
    }

    public final void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            return;
        }
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
    }

    public final void setNumWidgets(int num) {
        if (num > this.mRows * this.mColumns) {
            return;
        }
        this.mNumWidgets = num;
    }

    public final void setRows(int rows) {
        if (rows > 50) {
            return;
        }
        if (this.mRowsSet == rows) {
            return;
        }
        this.mRowsSet = rows;
        this.updateActualRowsAndColumns();
    }

    public final void setColumns(int columns) {
        if (columns > 50) {
            return;
        }
        if (this.mColumnsSet == columns) {
            return;
        }
        this.mColumnsSet = columns;
        this.updateActualRowsAndColumns();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int leftOfWidget(int i) {
        if (this.mConstraintMatrix == null) return 0;
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        if (i >= ((Object[])this.mConstraintMatrix).length) {
            return 0;
        }
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        int n = this.mConstraintMatrix[i][0];
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int topOfWidget(int i) {
        if (this.mConstraintMatrix == null) return 0;
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        if (i >= ((Object[])this.mConstraintMatrix).length) {
            return 0;
        }
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        int n = this.mConstraintMatrix[i][1];
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int rightOfWidget(int i) {
        if (this.mConstraintMatrix == null) return 0;
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        if (i >= ((Object[])this.mConstraintMatrix).length) {
            return 0;
        }
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        int n = this.mConstraintMatrix[i][2];
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int bottomOfWidget(int i) {
        if (this.mConstraintMatrix == null) return 0;
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        if (i >= ((Object[])this.mConstraintMatrix).length) {
            return 0;
        }
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        int n = this.mConstraintMatrix[i][3];
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/constraintlayout/core/utils/GridEngine$Companion;", "", "()V", "DEFAULT_SIZE", "", "HORIZONTAL", "MAX_COLUMNS", "MAX_ROWS", "VERTICAL", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

