/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.state.Reference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.state.helpers.Facade;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.Guideline;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u0016J\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000eJ\u0012\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\u000bH\u0016J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Landroidx/constraintlayout/core/state/helpers/GuidelineReference;", "Landroidx/constraintlayout/core/state/helpers/Facade;", "Landroidx/constraintlayout/core/state/Reference;", "state", "Landroidx/constraintlayout/core/state/State;", "(Landroidx/constraintlayout/core/state/State;)V", "mEnd", "", "mGuidelineWidget", "Landroidx/constraintlayout/core/widgets/Guideline;", "mKey", "", "mOrientation", "mPercent", "", "mStart", "mState", "getMState", "()Landroidx/constraintlayout/core/state/State;", "apply", "", "end", "margin", "getConstraintWidget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "getFacade", "getKey", "getOrientation", "percent", "setConstraintWidget", "widget", "setKey", "key", "setOrientation", "orientation", "start", "compose"})
@StabilityInferred(parameters=0)
public final class GuidelineReference
implements Facade,
Reference {
    @NotNull
    private final State mState;
    private int mOrientation;
    @Nullable
    private Guideline mGuidelineWidget;
    private int mStart;
    private int mEnd;
    private float mPercent;
    @Nullable
    private Object mKey;
    public static final int $stable = 8;

    public GuidelineReference(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.mState = state;
        this.mStart = -1;
        this.mEnd = -1;
    }

    @NotNull
    public final State getMState() {
        return this.mState;
    }

    @Override
    public void setKey(@Nullable Object key) {
        this.mKey = key;
    }

    @Override
    @Nullable
    public Object getKey() {
        return this.mKey;
    }

    @NotNull
    public final GuidelineReference start(@Nullable Object margin) {
        Object object = margin;
        Intrinsics.checkNotNull((Object)object);
        this.mStart = this.mState.convertDimension(object);
        this.mEnd = -1;
        this.mPercent = 0.0f;
        return this;
    }

    @NotNull
    public final GuidelineReference end(@Nullable Object margin) {
        this.mStart = -1;
        Object object = margin;
        Intrinsics.checkNotNull((Object)object);
        this.mEnd = this.mState.convertDimension(object);
        this.mPercent = 0.0f;
        return this;
    }

    @NotNull
    public final GuidelineReference percent(float percent) {
        this.mStart = -1;
        this.mEnd = -1;
        this.mPercent = percent;
        return this;
    }

    public final void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public final int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public void apply() {
        Guideline guideline = this.mGuidelineWidget;
        Intrinsics.checkNotNull((Object)guideline);
        guideline.setOrientation(this.mOrientation);
        if (this.mStart != -1) {
            Guideline guideline2 = this.mGuidelineWidget;
            Intrinsics.checkNotNull((Object)guideline2);
            guideline2.setGuideBegin(this.mStart);
        } else if (this.mEnd != -1) {
            Guideline guideline3 = this.mGuidelineWidget;
            Intrinsics.checkNotNull((Object)guideline3);
            guideline3.setGuideEnd(this.mEnd);
        } else {
            Guideline guideline4 = this.mGuidelineWidget;
            Intrinsics.checkNotNull((Object)guideline4);
            guideline4.setGuidePercent(this.mPercent);
        }
    }

    @Override
    @Nullable
    public Facade getFacade() {
        return null;
    }

    @Override
    @NotNull
    public ConstraintWidget getConstraintWidget() {
        if (this.mGuidelineWidget == null) {
            this.mGuidelineWidget = new Guideline();
        }
        Guideline guideline = this.mGuidelineWidget;
        Intrinsics.checkNotNull((Object)guideline);
        return guideline;
    }

    @Override
    public void setConstraintWidget(@Nullable ConstraintWidget widget) {
        this.mGuidelineWidget = widget instanceof Guideline ? (Guideline)widget : null;
    }
}

