/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.state.Transition;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b6\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\t\b\u0007\u0018\u0000 \u0089\u00012\u00020\u0001:\u0002\u0089\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007J$\u0010\\\u001a\u00020]2\n\u0010^\u001a\u00060_j\u0002``2\u0006\u0010a\u001a\u00020\u00152\u0006\u0010b\u001a\u00020\tH\u0002J$\u0010\\\u001a\u00020]2\n\u0010^\u001a\u00060_j\u0002``2\u0006\u0010a\u001a\u00020\u00152\u0006\u0010b\u001a\u00020\u000fH\u0002J\u0016\u0010c\u001a\u00020]2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010d\u001a\u00020\u000fJ\u0016\u0010e\u001a\u00020]2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010b\u001a\u00020\tJ\u0006\u0010f\u001a\u00020\tJ\u0006\u0010g\u001a\u00020\tJ\u000e\u0010h\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u0015J\u0010\u0010i\u001a\u0004\u0018\u00010#2\u0006\u0010+\u001a\u00020\u0015J\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00150kJ\u0010\u0010l\u001a\u00020\u000f2\b\u0010+\u001a\u0004\u0018\u00010\u0015J\u0010\u0010m\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010\u0015J\b\u0010n\u001a\u0004\u0018\u00010&J\u0006\u0010o\u001a\u00020\u000fJ\u000e\u0010p\u001a\u00020]2\u0006\u0010q\u001a\u00020\u0015J\u000e\u0010r\u001a\u00020]2\u0006\u0010s\u001a\u00020tJ\u0006\u0010u\u001a\u00020]J\u0016\u0010v\u001a\u00060_j\u0002``2\n\u0010w\u001a\u00060_j\u0002``J\u001e\u0010v\u001a\u00060_j\u0002``2\n\u0010w\u001a\u00060_j\u0002``2\u0006\u0010x\u001a\u00020\u001cJ\u001c\u0010y\u001a\u00020]2\n\u0010w\u001a\u00060_j\u0002``2\u0006\u0010z\u001a\u00020{H\u0002J\u001e\u0010|\u001a\u00020]2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010z\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020\u001cJ\u001e\u0010|\u001a\u00020]2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010z\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020\tJ\u001e\u0010|\u001a\u00020]2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010z\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020\u000fJ \u0010|\u001a\u00020]2\b\u0010+\u001a\u0004\u0018\u00010\u00152\u0006\u0010z\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020\u0015J\u001c\u0010}\u001a\u00020]2\b\u0010~\u001a\u0004\u0018\u00010\u007f2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001J\u0012\u0010\u0082\u0001\u001a\u00020]2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010&J\u001a\u0010\u0084\u0001\u001a\u00020\u001c2\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u00152\u0006\u0010b\u001a\u00020tJ\u0007\u0010\u0086\u0001\u001a\u00020\u0000J\u0011\u0010\u0086\u0001\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0011\u0010\u0087\u0001\u001a\u00020]2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000J\u0007\u0010\u0088\u0001\u001a\u00020\u000fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\rR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0011\"\u0004\b \u0010\u0013R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#0\"j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000b\"\u0004\b1\u0010\rR\u001a\u00102\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u000b\"\u0004\b4\u0010\rR\u001a\u00105\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u000b\"\u0004\b7\u0010\rR\u001a\u00108\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0011\"\u0004\b:\u0010\u0013R\u001a\u0010;\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u000b\"\u0004\b=\u0010\rR\u001a\u0010>\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u000b\"\u0004\b@\u0010\rR\u001a\u0010A\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u000b\"\u0004\bC\u0010\rR\u001a\u0010D\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u000b\"\u0004\bF\u0010\rR\u001a\u0010G\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u000b\"\u0004\bI\u0010\rR\u001a\u0010J\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0011\"\u0004\bL\u0010\u0013R\u001a\u0010M\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u000b\"\u0004\bO\u0010\rR\u001a\u0010P\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\u000b\"\u0004\bR\u0010\rR\u001a\u0010S\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u000b\"\u0004\bU\u0010\rR\u001a\u0010V\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010\u0011\"\u0004\bX\u0010\u0013R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\u0005\u00a8\u0006\u008a\u0001"}, d2={"Landroidx/constraintlayout/core/state/WidgetFrame;", "", "()V", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;)V", "frame", "(Landroidx/constraintlayout/core/state/WidgetFrame;)V", "alpha", "", "getAlpha", "()F", "setAlpha", "(F)V", "bottom", "", "getBottom", "()I", "setBottom", "(I)V", "id", "", "getId", "()Ljava/lang/String;", "interpolatedPos", "getInterpolatedPos", "setInterpolatedPos", "isDefaultTransform", "", "()Z", "left", "getLeft", "setLeft", "mCustom", "Ljava/util/HashMap;", "Landroidx/constraintlayout/core/motion/CustomVariable;", "Lkotlin/collections/HashMap;", "mMotionProperties", "Landroidx/constraintlayout/core/motion/utils/TypedBundle;", "getMMotionProperties", "()Landroidx/constraintlayout/core/motion/utils/TypedBundle;", "setMMotionProperties", "(Landroidx/constraintlayout/core/motion/utils/TypedBundle;)V", "name", "getName", "setName", "(Ljava/lang/String;)V", "phone_orientation", "getPhone_orientation", "setPhone_orientation", "pivotX", "getPivotX", "setPivotX", "pivotY", "getPivotY", "setPivotY", "right", "getRight", "setRight", "rotationX", "getRotationX", "setRotationX", "rotationY", "getRotationY", "setRotationY", "rotationZ", "getRotationZ", "setRotationZ", "scaleX", "getScaleX", "setScaleX", "scaleY", "getScaleY", "setScaleY", "top", "getTop", "setTop", "translationX", "getTranslationX", "setTranslationX", "translationY", "getTranslationY", "setTranslationY", "translationZ", "getTranslationZ", "setTranslationZ", "visibility", "getVisibility", "setVisibility", "getWidget", "()Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "setWidget", "add", "", "s", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "title", "value", "addCustomColor", "color", "addCustomFloat", "centerX", "centerY", "containsCustom", "getCustomAttribute", "getCustomAttributeNames", "", "getCustomColor", "getCustomFloat", "getMotionProperties", "height", "logv", "str", "parseCustom", "custom", "Landroidx/constraintlayout/core/parser/CLElement;", "printCustomAttributes", "serialize", "ret", "sendPhoneOrientation", "serializeAnchor", "type", "Landroidx/constraintlayout/core/widgets/ConstraintAnchor$Type;", "setCustomAttribute", "setCustomValue", "valueAt", "Landroidx/constraintlayout/core/motion/CustomAttribute;", "mTempValues", "", "setMotionAttributes", "motionProperties", "setValue", "key", "update", "updateAttributes", "width", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class WidgetFrame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ConstraintWidget widget;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private float pivotX;
    private float pivotY;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private float translationX;
    private float translationY;
    private float translationZ;
    private float phone_orientation;
    private float scaleX;
    private float scaleY;
    private float alpha;
    private float interpolatedPos;
    private int visibility;
    @NotNull
    private final HashMap<String, CustomVariable> mCustom;
    @Nullable
    private String name;
    @Nullable
    private TypedBundle mMotionProperties;
    public static final int $stable = 8;

    @Nullable
    public final ConstraintWidget getWidget() {
        return this.widget;
    }

    public final void setWidget(@Nullable ConstraintWidget constraintWidget) {
        this.widget = constraintWidget;
    }

    public final int getLeft() {
        return this.left;
    }

    public final void setLeft(int n) {
        this.left = n;
    }

    public final int getTop() {
        return this.top;
    }

    public final void setTop(int n) {
        this.top = n;
    }

    public final int getRight() {
        return this.right;
    }

    public final void setRight(int n) {
        this.right = n;
    }

    public final int getBottom() {
        return this.bottom;
    }

    public final void setBottom(int n) {
        this.bottom = n;
    }

    public final float getPivotX() {
        return this.pivotX;
    }

    public final void setPivotX(float f) {
        this.pivotX = f;
    }

    public final float getPivotY() {
        return this.pivotY;
    }

    public final void setPivotY(float f) {
        this.pivotY = f;
    }

    public final float getRotationX() {
        return this.rotationX;
    }

    public final void setRotationX(float f) {
        this.rotationX = f;
    }

    public final float getRotationY() {
        return this.rotationY;
    }

    public final void setRotationY(float f) {
        this.rotationY = f;
    }

    public final float getRotationZ() {
        return this.rotationZ;
    }

    public final void setRotationZ(float f) {
        this.rotationZ = f;
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX(float f) {
        this.translationX = f;
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY(float f) {
        this.translationY = f;
    }

    public final float getTranslationZ() {
        return this.translationZ;
    }

    public final void setTranslationZ(float f) {
        this.translationZ = f;
    }

    public final float getPhone_orientation() {
        return this.phone_orientation;
    }

    public final void setPhone_orientation(float f) {
        this.phone_orientation = f;
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(float f) {
        this.scaleX = f;
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(float f) {
        this.scaleY = f;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(float f) {
        this.alpha = f;
    }

    public final float getInterpolatedPos() {
        return this.interpolatedPos;
    }

    public final void setInterpolatedPos(float f) {
        this.interpolatedPos = f;
    }

    public final int getVisibility() {
        return this.visibility;
    }

    public final void setVisibility(int n) {
        this.visibility = n;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @Nullable
    public final TypedBundle getMMotionProperties() {
        return this.mMotionProperties;
    }

    public final void setMMotionProperties(@Nullable TypedBundle typedBundle) {
        this.mMotionProperties = typedBundle;
    }

    public final int width() {
        return Math.max(0, this.right - this.left);
    }

    public final int height() {
        return Math.max(0, this.bottom - this.top);
    }

    public WidgetFrame() {
        this.pivotX = Float.NaN;
        this.pivotY = Float.NaN;
        this.rotationX = Float.NaN;
        this.rotationY = Float.NaN;
        this.rotationZ = Float.NaN;
        this.translationX = Float.NaN;
        this.translationY = Float.NaN;
        this.translationZ = Float.NaN;
        this.phone_orientation = Float.NaN;
        this.scaleX = Float.NaN;
        this.scaleY = Float.NaN;
        this.alpha = Float.NaN;
        this.interpolatedPos = Float.NaN;
        this.mCustom = new HashMap();
    }

    public WidgetFrame(@NotNull ConstraintWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.pivotX = Float.NaN;
        this.pivotY = Float.NaN;
        this.rotationX = Float.NaN;
        this.rotationY = Float.NaN;
        this.rotationZ = Float.NaN;
        this.translationX = Float.NaN;
        this.translationY = Float.NaN;
        this.translationZ = Float.NaN;
        this.phone_orientation = Float.NaN;
        this.scaleX = Float.NaN;
        this.scaleY = Float.NaN;
        this.alpha = Float.NaN;
        this.interpolatedPos = Float.NaN;
        this.mCustom = new HashMap();
        this.widget = widget;
    }

    public WidgetFrame(@NotNull WidgetFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.pivotX = Float.NaN;
        this.pivotY = Float.NaN;
        this.rotationX = Float.NaN;
        this.rotationY = Float.NaN;
        this.rotationZ = Float.NaN;
        this.translationX = Float.NaN;
        this.translationY = Float.NaN;
        this.translationZ = Float.NaN;
        this.phone_orientation = Float.NaN;
        this.scaleX = Float.NaN;
        this.scaleY = Float.NaN;
        this.alpha = Float.NaN;
        this.interpolatedPos = Float.NaN;
        this.mCustom = new HashMap();
        this.widget = frame.widget;
        this.left = frame.left;
        this.top = frame.top;
        this.right = frame.right;
        this.bottom = frame.bottom;
        this.updateAttributes(frame);
    }

    public final void updateAttributes(@Nullable WidgetFrame frame) {
        if (frame == null) {
            return;
        }
        this.pivotX = frame.pivotX;
        this.pivotY = frame.pivotY;
        this.rotationX = frame.rotationX;
        this.rotationY = frame.rotationY;
        this.rotationZ = frame.rotationZ;
        this.translationX = frame.translationX;
        this.translationY = frame.translationY;
        this.translationZ = frame.translationZ;
        this.scaleX = frame.scaleX;
        this.scaleY = frame.scaleY;
        this.alpha = frame.alpha;
        this.visibility = frame.visibility;
        this.setMotionAttributes(frame.mMotionProperties);
        this.mCustom.clear();
        for (CustomVariable c : frame.mCustom.values()) {
            ((Map)this.mCustom).put(c.getName(), c.copy());
        }
    }

    public final boolean isDefaultTransform() {
        return Float.isNaN(this.rotationX) && Float.isNaN(this.rotationY) && Float.isNaN(this.rotationZ) && Float.isNaN(this.translationX) && Float.isNaN(this.translationY) && Float.isNaN(this.translationZ) && Float.isNaN(this.scaleX) && Float.isNaN(this.scaleY) && Float.isNaN(this.alpha);
    }

    public final float centerX() {
        return (float)this.left + (float)(this.right - this.left) / 2.0f;
    }

    public final float centerY() {
        return (float)this.top + (float)(this.bottom - this.top) / 2.0f;
    }

    @NotNull
    public final WidgetFrame update() {
        block0: {
            ConstraintWidget constraintWidget = this.widget;
            if (constraintWidget == null) break block0;
            ConstraintWidget widget = constraintWidget;
            boolean bl = false;
            this.left = widget.getLeft();
            this.top = widget.getTop();
            this.right = widget.getRight();
            this.bottom = widget.getBottom();
            WidgetFrame frame = widget.getFrame();
            this.updateAttributes(frame);
        }
        return this;
    }

    @NotNull
    public final WidgetFrame update(@Nullable ConstraintWidget widget) {
        if (widget == null) {
            return this;
        }
        this.widget = widget;
        this.update();
        return this;
    }

    public final boolean containsCustom(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.mCustom.containsKey(name);
    }

    public final void addCustomColor(@NotNull String name, int color) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setCustomAttribute(name, 902, color);
    }

    public final int getCustomColor(@Nullable String name) {
        int n;
        if (((Map)this.mCustom).containsKey(name)) {
            Object v = ((Map)this.mCustom).get(name);
            Intrinsics.checkNotNull(v);
            n = ((CustomVariable)v).getColorValue();
        } else {
            n = -21880;
        }
        return n;
    }

    public final void addCustomFloat(@NotNull String name, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setCustomAttribute(name, 901, value);
    }

    public final float getCustomFloat(@Nullable String name) {
        float f;
        if (((Map)this.mCustom).containsKey(name)) {
            Object v = ((Map)this.mCustom).get(name);
            Intrinsics.checkNotNull(v);
            f = ((CustomVariable)v).getFloatValue();
        } else {
            f = Float.NaN;
        }
        return f;
    }

    public final void setCustomAttribute(@NotNull String name, int type, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.mCustom.containsKey(name)) {
            CustomVariable customVariable = this.mCustom.get(name);
            Intrinsics.checkNotNull((Object)customVariable);
            customVariable.setFloatValue(value);
        } else {
            ((Map)this.mCustom).put(name, new CustomVariable(name, type, value));
        }
    }

    public final void setCustomAttribute(@NotNull String name, int type, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.mCustom.containsKey(name)) {
            CustomVariable customVariable = this.mCustom.get(name);
            Intrinsics.checkNotNull((Object)customVariable);
            customVariable.setIntValue(value);
        } else {
            ((Map)this.mCustom).put(name, new CustomVariable(name, type, value));
        }
    }

    public final void setCustomAttribute(@NotNull String name, int type, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.mCustom.containsKey(name)) {
            CustomVariable customVariable = this.mCustom.get(name);
            Intrinsics.checkNotNull((Object)customVariable);
            customVariable.setBooleanValue(value);
        } else {
            ((Map)this.mCustom).put(name, new CustomVariable(name, type, value));
        }
    }

    public final void setCustomAttribute(@Nullable String name, int type, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((Map)this.mCustom).containsKey(name)) {
            Object v = ((Map)this.mCustom).get(name);
            Intrinsics.checkNotNull(v);
            ((CustomVariable)v).setStringValue(value);
        } else {
            Map map = this.mCustom;
            String string = name;
            Intrinsics.checkNotNull((Object)string);
            map.put(string, new CustomVariable(name, type, value));
        }
    }

    @Nullable
    public final CustomVariable getCustomAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.mCustom.get(name);
    }

    @NotNull
    public final Set<String> getCustomAttributeNames() {
        Set<String> set = this.mCustom.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean setValue(@Nullable String key, @NotNull CLElement value) throws CLParsingException {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = key;
        if (string == null) return false;
        int n = -1;
        switch (string.hashCode()) {
            case 642850769: {
                if (string.equals("interpolatedPos")) {
                    n = 1;
                }
                break;
            }
            case -1383228885: {
                if (string.equals("bottom")) {
                    n = 2;
                }
                break;
            }
            case -1349088399: {
                if (string.equals("custom")) {
                    n = 3;
                }
                break;
            }
            case -987906985: {
                if (string.equals("pivotY")) {
                    n = 4;
                }
                break;
            }
            case -987906986: {
                if (string.equals("pivotX")) {
                    n = 5;
                }
                break;
            }
            case 108511772: {
                if (string.equals("right")) {
                    n = 6;
                }
                break;
            }
            case -1881940865: {
                if (string.equals("phone_orientation")) {
                    n = 7;
                }
                break;
            }
            case -908189618: {
                if (string.equals("scaleX")) {
                    n = 8;
                }
                break;
            }
            case -908189617: {
                if (string.equals("scaleY")) {
                    n = 9;
                }
                break;
            }
            case -1249320806: {
                if (string.equals("rotationX")) {
                    n = 10;
                }
                break;
            }
            case -1249320805: {
                if (string.equals("rotationY")) {
                    n = 11;
                }
                break;
            }
            case -1225497657: {
                if (string.equals("translationX")) {
                    n = 12;
                }
                break;
            }
            case -1249320804: {
                if (string.equals("rotationZ")) {
                    n = 13;
                }
                break;
            }
            case 115029: {
                if (string.equals("top")) {
                    n = 14;
                }
                break;
            }
            case 3317767: {
                if (string.equals("left")) {
                    n = 15;
                }
                break;
            }
            case 92909918: {
                if (string.equals("alpha")) {
                    n = 16;
                }
                break;
            }
            case -1225497656: {
                if (string.equals("translationY")) {
                    n = 17;
                }
                break;
            }
            case -1225497655: {
                if (string.equals("translationZ")) {
                    n = 18;
                }
                break;
            }
        }
        switch (n) {
            case 5: {
                this.pivotX = value.getFloat();
                return true;
            }
            case 4: {
                this.pivotY = value.getFloat();
                return true;
            }
            case 10: {
                this.rotationX = value.getFloat();
                return true;
            }
            case 11: {
                this.rotationY = value.getFloat();
                return true;
            }
            case 13: {
                this.rotationZ = value.getFloat();
                return true;
            }
            case 12: {
                this.translationX = value.getFloat();
                return true;
            }
            case 17: {
                this.translationY = value.getFloat();
                return true;
            }
            case 18: {
                this.translationZ = value.getFloat();
                return true;
            }
            case 8: {
                this.scaleX = value.getFloat();
                return true;
            }
            case 9: {
                this.scaleY = value.getFloat();
                return true;
            }
            case 16: {
                this.alpha = value.getFloat();
                return true;
            }
            case 1: {
                this.interpolatedPos = value.getFloat();
                return true;
            }
            case 7: {
                this.phone_orientation = value.getFloat();
                return true;
            }
            case 14: {
                this.top = value.getInt();
                return true;
            }
            case 15: {
                this.left = value.getInt();
                return true;
            }
            case 6: {
                this.right = value.getInt();
                return true;
            }
            case 2: {
                this.bottom = value.getInt();
                return true;
            }
            case 3: {
                this.parseCustom(value);
                return true;
            }
            default: {
                return false;
            }
        }
    }

    @NotNull
    public final String getId() {
        String string;
        if (this.widget == null) {
            string = "unknown";
        } else {
            ConstraintWidget constraintWidget = this.widget;
            Intrinsics.checkNotNull((Object)constraintWidget);
            String string2 = constraintWidget.getStringId();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    public final void parseCustom(@NotNull CLElement custom) throws CLParsingException {
        Intrinsics.checkNotNullParameter((Object)custom, (String)"custom");
        CLObject obj = (CLObject)custom;
        int n = obj.size();
        for (int i = 0; i < n; ++i) {
            CLElement tmp = obj.get(i);
            Intrinsics.checkNotNull((Object)tmp, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.parser.CLKey");
            CLKey k = (CLKey)tmp;
            CLElement v = k.getValue();
            String vStr = v.content();
            CharSequence charSequence = vStr;
            if (new Regex("#[0-9a-fA-F]+").matches(charSequence)) {
                String string = vStr.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int color = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                String string2 = this.name;
                Intrinsics.checkNotNull((Object)string2);
                this.setCustomAttribute(string2, 902, color);
                continue;
            }
            if (v instanceof CLNumber) {
                String string = this.name;
                Intrinsics.checkNotNull((Object)string);
                this.setCustomAttribute(string, 901, v.getFloat());
                continue;
            }
            this.setCustomAttribute(this.name, 903, vStr);
        }
    }

    @NotNull
    public final StringBuilder serialize(@NotNull StringBuilder ret) {
        Intrinsics.checkNotNullParameter((Object)ret, (String)"ret");
        return this.serialize(ret, false);
    }

    @NotNull
    public final StringBuilder serialize(@NotNull StringBuilder ret, boolean sendPhoneOrientation) {
        Intrinsics.checkNotNullParameter((Object)ret, (String)"ret");
        WidgetFrame frame = this;
        ret.append("{\n");
        this.add(ret, "left", frame.left);
        this.add(ret, "top", frame.top);
        this.add(ret, "right", frame.right);
        this.add(ret, "bottom", frame.bottom);
        this.add(ret, "pivotX", frame.pivotX);
        this.add(ret, "pivotY", frame.pivotY);
        this.add(ret, "rotationX", frame.rotationX);
        this.add(ret, "rotationY", frame.rotationY);
        this.add(ret, "rotationZ", frame.rotationZ);
        this.add(ret, "translationX", frame.translationX);
        this.add(ret, "translationY", frame.translationY);
        this.add(ret, "translationZ", frame.translationZ);
        this.add(ret, "scaleX", frame.scaleX);
        this.add(ret, "scaleY", frame.scaleY);
        this.add(ret, "alpha", frame.alpha);
        this.add(ret, "visibility", frame.visibility);
        this.add(ret, "interpolatedPos", frame.interpolatedPos);
        if (this.widget != null) {
            for (ConstraintAnchor.Type side : ConstraintAnchor.Type.getEntries()) {
                this.serializeAnchor(ret, side);
            }
        }
        if (sendPhoneOrientation) {
            this.add(ret, "phone_orientation", this.phone_orientation);
        }
        if (sendPhoneOrientation) {
            this.add(ret, "phone_orientation", this.phone_orientation);
        }
        if (frame.mCustom.size() != 0) {
            ret.append("custom : {\n");
            for (String s : frame.mCustom.keySet()) {
                CustomVariable value;
                Intrinsics.checkNotNull((Object)frame.mCustom.get(s));
                ret.append(s);
                ret.append(": ");
                switch (value.getType()) {
                    case 900: {
                        ret.append(value.getIntegerValue());
                        ret.append(",\n");
                        break;
                    }
                    case 901: 
                    case 905: {
                        ret.append(value.getFloatValue());
                        ret.append(",\n");
                        break;
                    }
                    case 902: {
                        ret.append("'");
                        ret.append(CustomVariable.Companion.colorString(value.getIntegerValue()));
                        ret.append("',\n");
                        break;
                    }
                    case 903: {
                        ret.append("'");
                        ret.append(value.getStringValue());
                        ret.append("',\n");
                        break;
                    }
                    case 904: {
                        ret.append("'");
                        ret.append(value.getBooleanValue());
                        ret.append("',\n");
                    }
                }
            }
            ret.append("}\n");
        }
        ret.append("}\n");
        return ret;
    }

    private final void serializeAnchor(StringBuilder ret, ConstraintAnchor.Type type) {
        ConstraintAnchor anchor;
        ConstraintWidget constraintWidget = this.widget;
        ConstraintAnchor constraintAnchor = anchor = constraintWidget != null ? constraintWidget.getAnchor(type) : null;
        if ((constraintAnchor != null ? constraintAnchor.getMTarget() : null) == null) {
            return;
        }
        ret.append("Anchor");
        ret.append(type.name());
        ret.append(": ['");
        ConstraintAnchor constraintAnchor2 = anchor.getMTarget();
        Intrinsics.checkNotNull((Object)constraintAnchor2);
        String str = constraintAnchor2.getOwner().getStringId();
        String string = str;
        if (string == null) {
            string = "#PARENT";
        }
        ret.append(string);
        ret.append("', '");
        ConstraintAnchor constraintAnchor3 = anchor.getMTarget();
        Intrinsics.checkNotNull((Object)constraintAnchor3);
        ret.append(constraintAnchor3.getType().name());
        ret.append("', '");
        ret.append(anchor.getMMargin());
        ret.append("'],\n");
    }

    public final void printCustomAttributes() {
        Object object;
        Object ss = ExceptionsKt.stackTraceToString((Throwable)new Throwable());
        ss = (String)ss + " " + this.hashCode() % 1000;
        if (this.widget != null) {
            ConstraintWidget constraintWidget = this.widget;
            object = "/" + (constraintWidget != null ? constraintWidget.hashCode() : 0) % 1000 + " ";
        } else {
            object = "/NULL ";
        }
        ss = (String)ss + (String)object;
        if (this.mCustom != null) {
            for (String key : this.mCustom.keySet()) {
                System.out.println((Object)((String)ss + this.mCustom.get(key)));
            }
        }
    }

    public final void logv(@NotNull String str) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Object ss = ExceptionsKt.stackTraceToString((Throwable)new Throwable());
        ss = (String)ss + " " + this.hashCode() % 1000;
        if (this.widget != null) {
            ConstraintWidget constraintWidget = this.widget;
            object = "/" + (constraintWidget != null ? constraintWidget.hashCode() : 0) % 1000;
        } else {
            object = "/NULL";
        }
        ss = (String)ss + (String)object;
        System.out.println((Object)((String)ss + " " + str));
    }

    public final void setCustomValue(@Nullable CustomAttribute valueAt, @Nullable float[] mTempValues) {
    }

    public final void setMotionAttributes(@Nullable TypedBundle motionProperties) {
        this.mMotionProperties = motionProperties;
    }

    @Nullable
    public final TypedBundle getMotionProperties() {
        return this.mMotionProperties;
    }

    private final void add(StringBuilder s, String title, int value) {
        s.append(title);
        s.append(": ");
        s.append(value);
        s.append(",\n");
    }

    private final void add(StringBuilder s, String title, float value) {
        if (Float.isNaN(value)) {
            return;
        }
        s.append(title);
        s.append(": ");
        s.append(value);
        s.append(",\n");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J>\u0010\u0003\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Landroidx/constraintlayout/core/state/WidgetFrame$Companion;", "", "()V", "interpolate", "", "start", "end", "defaultValue", "progress", "", "parentWidth", "", "parentHeight", "frame", "Landroidx/constraintlayout/core/state/WidgetFrame;", "transition", "Landroidx/constraintlayout/core/state/Transition;", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public final void interpolate(int parentWidth, int parentHeight, @NotNull WidgetFrame frame, @NotNull WidgetFrame start, @NotNull WidgetFrame end, @NotNull Transition transition, float progress) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
            int frameNumber = (int)(progress * (float)100);
            int startX = start.getLeft();
            int startY = start.getTop();
            int endX = end.getLeft();
            int endY = end.getTop();
            int startWidth = start.getRight() - start.getLeft();
            int startHeight = start.getBottom() - start.getTop();
            int endWidth = end.getRight() - end.getLeft();
            int endHeight = end.getBottom() - end.getTop();
            float progressPosition = progress;
            float startAlpha = start.getAlpha();
            float endAlpha = end.getAlpha();
            if (start.getVisibility() == 8) {
                startX -= (int)((float)endWidth / 2.0f);
                startY -= (int)((float)endHeight / 2.0f);
                startWidth = endWidth;
                startHeight = endHeight;
                if (Float.isNaN(startAlpha)) {
                    startAlpha = 0.0f;
                }
            }
            if (end.getVisibility() == 8) {
                endX -= (int)((float)startWidth / 2.0f);
                endY -= (int)((float)startHeight / 2.0f);
                endWidth = startWidth;
                endHeight = startHeight;
                if (Float.isNaN(endAlpha)) {
                    endAlpha = 0.0f;
                }
            }
            if (Float.isNaN(startAlpha) && !Float.isNaN(endAlpha)) {
                startAlpha = 1.0f;
            }
            if (!Float.isNaN(startAlpha) && Float.isNaN(endAlpha)) {
                endAlpha = 1.0f;
            }
            if (start.getVisibility() == 4) {
                startAlpha = 0.0f;
            }
            if (end.getVisibility() == 4) {
                endAlpha = 0.0f;
            }
            if (frame.getWidget() != null && transition.hasPositionKeyframes()) {
                ConstraintWidget constraintWidget = frame.getWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                String string = constraintWidget.getStringId();
                Intrinsics.checkNotNull((Object)string);
                Transition.KeyPosition firstPosition = transition.findPreviousPosition(string, frameNumber);
                ConstraintWidget constraintWidget2 = frame.getWidget();
                Intrinsics.checkNotNull((Object)constraintWidget2);
                String string2 = constraintWidget2.getStringId();
                Intrinsics.checkNotNull((Object)string2);
                Transition.KeyPosition lastPosition = transition.findNextPosition(string2, frameNumber);
                if (Intrinsics.areEqual((Object)firstPosition, (Object)lastPosition)) {
                    lastPosition = null;
                }
                int interpolateStartFrame = 0;
                int interpolateEndFrame = 100;
                if (firstPosition != null) {
                    startX = (int)(firstPosition.getMX() * (float)parentWidth);
                    startY = (int)(firstPosition.getMY() * (float)parentHeight);
                    interpolateStartFrame = firstPosition.getMFrame();
                }
                if (lastPosition != null) {
                    endX = (int)(lastPosition.getMX() * (float)parentWidth);
                    endY = (int)(lastPosition.getMY() * (float)parentHeight);
                    interpolateEndFrame = lastPosition.getMFrame();
                }
                progressPosition = (progress * 100.0f - (float)interpolateStartFrame) / (float)(interpolateEndFrame - interpolateStartFrame);
            }
            frame.setWidget(start.getWidget());
            frame.setLeft((int)((float)startX + progressPosition * (float)(endX - startX)));
            frame.setTop((int)((float)startY + progressPosition * (float)(endY - startY)));
            int width = (int)((1.0f - progress) * (float)startWidth + progress * (float)endWidth);
            int height = (int)((1.0f - progress) * (float)startHeight + progress * (float)endHeight);
            frame.setRight(frame.getLeft() + width);
            frame.setBottom(frame.getTop() + height);
            frame.setPivotX(this.interpolate(start.getPivotX(), end.getPivotX(), 0.5f, progress));
            frame.setPivotY(this.interpolate(start.getPivotY(), end.getPivotY(), 0.5f, progress));
            frame.setRotationX(this.interpolate(start.getRotationX(), end.getRotationX(), 0.0f, progress));
            frame.setRotationY(this.interpolate(start.getRotationY(), end.getRotationY(), 0.0f, progress));
            frame.setRotationZ(this.interpolate(start.getRotationZ(), end.getRotationZ(), 0.0f, progress));
            frame.setScaleX(this.interpolate(start.getScaleX(), end.getScaleX(), 1.0f, progress));
            frame.setScaleY(this.interpolate(start.getScaleY(), end.getScaleY(), 1.0f, progress));
            frame.setTranslationX(this.interpolate(start.getTranslationX(), end.getTranslationX(), 0.0f, progress));
            frame.setTranslationY(this.interpolate(start.getTranslationY(), end.getTranslationY(), 0.0f, progress));
            frame.setTranslationZ(this.interpolate(start.getTranslationZ(), end.getTranslationZ(), 0.0f, progress));
            frame.setAlpha(this.interpolate(startAlpha, endAlpha, 1.0f, progress));
            Set set = end.mCustom.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Set keys = set;
            frame.mCustom.clear();
            for (String key : keys) {
                if (!start.mCustom.containsKey(key)) continue;
                CustomVariable startVariable = (CustomVariable)start.mCustom.get(key);
                CustomVariable endVariable = (CustomVariable)end.mCustom.get(key);
                CustomVariable customVariable = startVariable;
                Intrinsics.checkNotNull((Object)customVariable);
                CustomVariable interpolated = new CustomVariable(customVariable);
                ((Map)frame.mCustom).put(key, interpolated);
                if (startVariable.numberOfInterpolatedValues() == 1) {
                    float f = startVariable.getValueToInterpolate();
                    CustomVariable customVariable2 = endVariable;
                    Intrinsics.checkNotNull((Object)customVariable2);
                    interpolated.setValue(Float.valueOf(this.interpolate(f, customVariable2.getValueToInterpolate(), 0.0f, progress)));
                    continue;
                }
                int n = startVariable.numberOfInterpolatedValues();
                float[] startValues = new float[n];
                float[] endValues = new float[n];
                startVariable.getValuesToInterpolate(startValues);
                CustomVariable customVariable3 = endVariable;
                Intrinsics.checkNotNull((Object)customVariable3);
                customVariable3.getValuesToInterpolate(endValues);
                for (int i = 0; i < n; ++i) {
                    startValues[i] = this.interpolate(startValues[i], endValues[i], 0.0f, progress);
                    interpolated.setValue(startValues);
                }
            }
        }

        private final float interpolate(float start, float end, float defaultValue, float progress) {
            float start2 = start;
            float end2 = end;
            boolean isStartUnset = Float.isNaN(start2);
            boolean isEndUnset = Float.isNaN(end2);
            if (isStartUnset && isEndUnset) {
                return Float.NaN;
            }
            if (isStartUnset) {
                start2 = defaultValue;
            }
            if (isEndUnset) {
                end2 = defaultValue;
            }
            return start2 + progress * (end2 - start2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

