/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 :2\u00020\u0001:\u0002:;B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J \u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0010J\u000e\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0010J\u000e\u00101\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0001J\u000e\u00101\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0010J\u0006\u00102\u001a\u00020\u0010J\u000e\u00103\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0001J\u000e\u00103\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0010J\u000e\u00104\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0001J\u000e\u00104\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0010J\u0018\u00105\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u00100\u001a\u00020\u0019J\u000e\u00107\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u001fJ\u000e\u00108\u001a\u00020)2\u0006\u00100\u001a\u00020\u0010J\u000e\u00109\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0001J\u000e\u00109\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0010R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0014R\u000e\u0010'\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Landroidx/constraintlayout/core/state/Dimension;", "", "()V", "type", "(Ljava/lang/Object;)V", "mInitialValue", "getMInitialValue", "()Ljava/lang/Object;", "setMInitialValue", "mIsSuggested", "", "getMIsSuggested", "()Z", "setMIsSuggested", "(Z)V", "mMax", "", "getMMax", "()I", "setMMax", "(I)V", "mMin", "getMMin", "setMMin", "mPercent", "", "getMPercent", "()F", "setMPercent", "(F)V", "mRatioString", "", "getMRatioString", "()Ljava/lang/String;", "setMRatioString", "(Ljava/lang/String;)V", "mValue", "getMValue", "setMValue", "mWrapContent", "apply", "", "state", "Landroidx/constraintlayout/core/state/State;", "constraintWidget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "orientation", "equalsFixedValue", "value", "fixed", "getValue", "max", "min", "percent", "key", "ratio", "setValue", "suggested", "Companion", "Type", "compose"})
@StabilityInferred(parameters=0)
public final class Dimension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int mWrapContent;
    private int mMin;
    private int mMax;
    private float mPercent;
    private int mValue;
    @Nullable
    private String mRatioString;
    @Nullable
    private Object mInitialValue;
    private boolean mIsSuggested;
    public static final int $stable = 8;
    @NotNull
    public static final String FIXED_DIMENSION = "FIXED_DIMENSION";
    @NotNull
    public static final String WRAP_DIMENSION = "WRAP_DIMENSION";
    @NotNull
    public static final String SPREAD_DIMENSION = "SPREAD_DIMENSION";
    @NotNull
    public static final String PARENT_DIMENSION = "PARENT_DIMENSION";
    @NotNull
    public static final String PERCENT_DIMENSION = "PERCENT_DIMENSION";
    @NotNull
    public static final String RATIO_DIMENSION = "RATIO_DIMENSION";

    public final int getMMin() {
        return this.mMin;
    }

    public final void setMMin(int n) {
        this.mMin = n;
    }

    public final int getMMax() {
        return this.mMax;
    }

    public final void setMMax(int n) {
        this.mMax = n;
    }

    public final float getMPercent() {
        return this.mPercent;
    }

    public final void setMPercent(float f) {
        this.mPercent = f;
    }

    public final int getMValue() {
        return this.mValue;
    }

    public final void setMValue(int n) {
        this.mValue = n;
    }

    @Nullable
    public final String getMRatioString() {
        return this.mRatioString;
    }

    public final void setMRatioString(@Nullable String string) {
        this.mRatioString = string;
    }

    @Nullable
    public final Object getMInitialValue() {
        return this.mInitialValue;
    }

    public final void setMInitialValue(@Nullable Object object) {
        this.mInitialValue = object;
    }

    public final boolean getMIsSuggested() {
        return this.mIsSuggested;
    }

    public final void setMIsSuggested(boolean bl) {
        this.mIsSuggested = bl;
    }

    public final boolean equalsFixedValue(int value) {
        return this.mInitialValue == null && this.mValue == value;
    }

    public Dimension() {
        this.mWrapContent = -2;
        this.mMax = Integer.MAX_VALUE;
        this.mPercent = 1.0f;
        this.mInitialValue = WRAP_DIMENSION;
    }

    public Dimension(@NotNull Object type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.mWrapContent = -2;
        this.mMax = Integer.MAX_VALUE;
        this.mPercent = 1.0f;
        this.mInitialValue = WRAP_DIMENSION;
        this.mInitialValue = type;
    }

    @NotNull
    public final Dimension percent(@Nullable Object key, float value) {
        this.mPercent = value;
        return this;
    }

    @NotNull
    public final Dimension min(int value) {
        if (value >= 0) {
            this.mMin = value;
        }
        return this;
    }

    @NotNull
    public final Dimension min(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)value, (Object)WRAP_DIMENSION)) {
            this.mMin = this.mWrapContent;
        }
        return this;
    }

    @NotNull
    public final Dimension max(int value) {
        if (this.mMax >= 0) {
            this.mMax = value;
        }
        return this;
    }

    @NotNull
    public final Dimension max(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)value, (Object)WRAP_DIMENSION) && this.mIsSuggested) {
            this.mInitialValue = WRAP_DIMENSION;
            this.mMax = Integer.MAX_VALUE;
        }
        return this;
    }

    @NotNull
    public final Dimension suggested(int value) {
        this.mIsSuggested = true;
        if (value >= 0) {
            this.mMax = value;
        }
        return this;
    }

    @NotNull
    public final Dimension suggested(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mInitialValue = value;
        this.mIsSuggested = true;
        return this;
    }

    @NotNull
    public final Dimension fixed(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mInitialValue = value;
        if (value instanceof Integer) {
            this.mValue = ((Number)value).intValue();
            this.mInitialValue = null;
        }
        return this;
    }

    @NotNull
    public final Dimension fixed(int value) {
        this.mInitialValue = null;
        this.mValue = value;
        return this;
    }

    @NotNull
    public final Dimension ratio(@NotNull String ratio) {
        Intrinsics.checkNotNullParameter((Object)ratio, (String)"ratio");
        this.mRatioString = ratio;
        return this;
    }

    public final void setValue(int value) {
        this.mIsSuggested = false;
        this.mInitialValue = null;
        this.mValue = value;
    }

    public final int getValue() {
        return this.mValue;
    }

    public final void apply(@Nullable State state, @NotNull ConstraintWidget constraintWidget, int orientation) {
        Intrinsics.checkNotNullParameter((Object)constraintWidget, (String)"constraintWidget");
        if (this.mRatioString != null) {
            constraintWidget.setDimensionRatio(this.mRatioString);
        }
        if (orientation == 0) {
            if (this.mIsSuggested) {
                constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                int type = 0;
                if (Intrinsics.areEqual((Object)this.mInitialValue, (Object)WRAP_DIMENSION)) {
                    type = 1;
                } else if (Intrinsics.areEqual((Object)this.mInitialValue, (Object)PERCENT_DIMENSION)) {
                    type = 2;
                }
                constraintWidget.setHorizontalMatchStyle(type, this.mMin, this.mMax, this.mPercent);
            } else {
                Object type;
                if (this.mMin > 0) {
                    constraintWidget.setMinWidth(this.mMin);
                }
                if (this.mMax < Integer.MAX_VALUE) {
                    constraintWidget.setMaxWidth(this.mMax);
                }
                if (Intrinsics.areEqual((Object)(type = this.mInitialValue), (Object)WRAP_DIMENSION)) {
                    constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                } else if (Intrinsics.areEqual((Object)type, (Object)PARENT_DIMENSION)) {
                    constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                } else if (type == null) {
                    constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    constraintWidget.setWidth(this.mValue);
                }
            }
        } else if (this.mIsSuggested) {
            constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
            int type = 0;
            if (Intrinsics.areEqual((Object)this.mInitialValue, (Object)WRAP_DIMENSION)) {
                type = 1;
            } else if (Intrinsics.areEqual((Object)this.mInitialValue, (Object)PERCENT_DIMENSION)) {
                type = 2;
            }
            constraintWidget.setVerticalMatchStyle(type, this.mMin, this.mMax, this.mPercent);
        } else {
            Object object;
            if (this.mMin > 0) {
                constraintWidget.setMinHeight(this.mMin);
            }
            if (this.mMax < Integer.MAX_VALUE) {
                constraintWidget.setMaxHeight(this.mMax);
            }
            if (Intrinsics.areEqual((Object)(object = this.mInitialValue), (Object)WRAP_DIMENSION)) {
                constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
            } else if (Intrinsics.areEqual((Object)object, (Object)PARENT_DIMENSION)) {
                constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
            } else if (object == null) {
                constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.setHeight(this.mValue);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/constraintlayout/core/state/Dimension$Companion;", "", "()V", "FIXED_DIMENSION", "", "PARENT_DIMENSION", "PERCENT_DIMENSION", "RATIO_DIMENSION", "SPREAD_DIMENSION", "WRAP_DIMENSION", "createFixed", "Landroidx/constraintlayout/core/state/Dimension;", "value", "", "createParent", "createPercent", "key", "", "createRatio", "ratio", "createSpread", "createSuggested", "startValue", "createWrap", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dimension createSuggested(int value) {
            Dimension dimension = new Dimension();
            dimension.suggested(value);
            return dimension;
        }

        @NotNull
        public final Dimension createSuggested(@NotNull Object startValue) {
            Intrinsics.checkNotNullParameter((Object)startValue, (String)"startValue");
            Dimension dimension = new Dimension();
            dimension.suggested(startValue);
            return dimension;
        }

        @NotNull
        public final Dimension createFixed(int value) {
            Dimension dimension = new Dimension(Dimension.FIXED_DIMENSION);
            dimension.fixed(value);
            return dimension;
        }

        @NotNull
        public final Dimension createFixed(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Dimension dimension = new Dimension(Dimension.FIXED_DIMENSION);
            dimension.fixed(value);
            return dimension;
        }

        @NotNull
        public final Dimension createPercent(@Nullable Object key, float value) {
            Dimension dimension = new Dimension(Dimension.PERCENT_DIMENSION);
            dimension.percent(key, value);
            return dimension;
        }

        @NotNull
        public final Dimension createParent() {
            return new Dimension(Dimension.PARENT_DIMENSION);
        }

        @NotNull
        public final Dimension createWrap() {
            return new Dimension(Dimension.WRAP_DIMENSION);
        }

        @NotNull
        public final Dimension createSpread() {
            return new Dimension(Dimension.SPREAD_DIMENSION);
        }

        @NotNull
        public final Dimension createRatio(@NotNull String ratio) {
            Intrinsics.checkNotNullParameter((Object)ratio, (String)"ratio");
            Dimension dimension = new Dimension(Dimension.RATIO_DIMENSION);
            dimension.ratio(ratio);
            return dimension;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/state/Dimension$Type;", "", "(Ljava/lang/String;I)V", "FIXED", "WRAP", "MATCH_PARENT", "MATCH_CONSTRAINT", "compose"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type FIXED = new Type();
        public static final /* enum */ Type WRAP = new Type();
        public static final /* enum */ Type MATCH_PARENT = new Type();
        public static final /* enum */ Type MATCH_CONSTRAINT = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.FIXED, Type.WRAP, Type.MATCH_PARENT, Type.MATCH_CONSTRAINT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

