/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.parser.CLArray;
import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.parser.CLString;
import androidx.constraintlayout.core.parser.CLToken;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/constraintlayout/core/parser/CLParser;", "", "mContent", "", "(Ljava/lang/String;)V", "mHasComment", "", "mLineNumber", "", "createElement", "Landroidx/constraintlayout/core/parser/CLElement;", "currentElement", "position", "type", "Landroidx/constraintlayout/core/parser/CLParser$TYPE;", "applyStart", "content", "", "getNextJsonElement", "c", "", "parse", "Landroidx/constraintlayout/core/parser/CLObject;", "Companion", "TYPE", "compose"})
@StabilityInferred(parameters=0)
public final class CLParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mContent;
    private boolean mHasComment;
    private int mLineNumber;
    public static final int $stable = 8;
    public static final boolean DEBUG = false;

    public CLParser(@NotNull String mContent) {
        Intrinsics.checkNotNullParameter((Object)mContent, (String)"mContent");
        this.mContent = mContent;
    }

    @NotNull
    public final CLObject parse() throws CLParsingException {
        char c;
        int i;
        CLObject root = null;
        char[] cArray = this.mContent.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] content = cArray;
        CLElement currentElement = null;
        int length = content.length;
        this.mLineNumber = 1;
        int startIndex = -1;
        for (i = 0; i < length; ++i) {
            c = content[i];
            if (c == '{') {
                startIndex = i;
                break;
            }
            if (c != '\n') continue;
            int n = this.mLineNumber;
            this.mLineNumber = n + 1;
        }
        if (startIndex == -1) {
            throw new CLParsingException("invalid json content", null);
        }
        root = CLObject.Companion.allocate(content);
        root.setLine(this.mLineNumber);
        root.setStart(startIndex);
        currentElement = root;
        for (i = startIndex + 1; i < length; ++i) {
            CLElement cLElement;
            c = content[i];
            if (c == '\n') {
                int n = this.mLineNumber;
                this.mLineNumber = n + 1;
            }
            if (this.mHasComment) {
                if (c != '\n') continue;
                this.mHasComment = false;
            }
            if (currentElement == null) break;
            if (currentElement.isDone()) {
                currentElement = this.getNextJsonElement(i, c, currentElement, content);
            } else if (currentElement instanceof CLObject) {
                if (c == '}') {
                    ((CLObject)currentElement).setEnd(i - 1);
                } else {
                    currentElement = this.getNextJsonElement(i, c, currentElement, content);
                }
            } else if (currentElement instanceof CLArray) {
                if (c == ']') {
                    ((CLArray)currentElement).setEnd(i - 1);
                } else {
                    currentElement = this.getNextJsonElement(i, c, currentElement, content);
                }
            } else if (currentElement instanceof CLString) {
                char ck = content[(int)((CLString)currentElement).getStart()];
                if (ck == c) {
                    cLElement = (CLString)currentElement;
                    cLElement.setStart(cLElement.getStart() + 1L);
                    ((CLString)currentElement).setEnd(i - 1);
                }
            } else {
                char ck;
                CLElement token;
                if (currentElement instanceof CLToken && !((CLToken)(token = currentElement)).validate(c, i)) {
                    throw new CLParsingException("parsing incorrect token " + ((CLToken)token).content() + " at line " + this.mLineNumber, token);
                }
                if ((currentElement instanceof CLKey || currentElement instanceof CLString) && ((ck = content[(int)currentElement.getStart()]) == '\'' || ck == '\"') && ck == c) {
                    cLElement = currentElement;
                    cLElement.setStart(cLElement.getStart() + 1L);
                    currentElement.setEnd(i - 1);
                }
                if (!(currentElement.isDone() || c != '}' && c != ']' && c != ',' && c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != ':')) {
                    currentElement.setEnd(i - 1);
                    if (c == '}' || c == ']') {
                        CLElement cLElement2 = currentElement = currentElement.getContainer();
                        Intrinsics.checkNotNull((Object)cLElement2);
                        cLElement2.setEnd(i - 1);
                        if (currentElement instanceof CLKey) {
                            CLElement cLElement3 = currentElement = ((CLKey)currentElement).getContainer();
                            Intrinsics.checkNotNull((Object)cLElement3);
                            cLElement3.setEnd(i - 1);
                        }
                    }
                }
            }
            if (!currentElement.isDone() || currentElement instanceof CLKey && ((CLKey)currentElement).getMElements().size() <= 0) continue;
            currentElement = currentElement.getContainer();
        }
        while (currentElement != null && !currentElement.isDone()) {
            CLElement cLElement = currentElement;
            CLString cLString = cLElement instanceof CLString ? (CLString)cLElement : null;
            if (cLString != null) {
                cLString.setStart((int)currentElement.getStart() + 1);
            }
            currentElement.setEnd(length - 1);
            currentElement = currentElement.getContainer();
        }
        return root;
    }

    private final CLElement getNextJsonElement(int position, char c, CLElement currentElement, char[] content) throws CLParsingException {
        CLElement currentElement2 = currentElement;
        char c2 = c;
        if (!(((((c2 == ' ' ? true : c2 == ':') ? true : c2 == ',') ? true : c2 == '\t') ? true : c2 == '\r') ? true : c2 == '\n')) {
            if (c2 == '{') {
                currentElement2 = this.createElement(currentElement2, position, TYPE.OBJECT, true, content);
            } else if (c2 == '[') {
                currentElement2 = this.createElement(currentElement2, position, TYPE.ARRAY, true, content);
            } else if (c2 == ']' ? true : c2 == '}') {
                CLElement cLElement = currentElement2;
                Intrinsics.checkNotNull((Object)cLElement);
                cLElement.setEnd(position - 1);
                CLElement cLElement2 = currentElement2 = currentElement2.getContainer();
                Intrinsics.checkNotNull((Object)cLElement2);
                cLElement2.setEnd(position);
            } else if (c2 == '\"' ? true : c2 == '\'') {
                currentElement2 = currentElement2 instanceof CLObject ? this.createElement(currentElement2, position, TYPE.KEY, true, content) : this.createElement(currentElement2, position, TYPE.STRING, true, content);
            } else if (c2 == '/') {
                if (position + 1 < content.length && content[position + 1] == '/') {
                    this.mHasComment = true;
                }
            } else if ((((((((((((c2 == '-' ? true : c2 == '+') ? true : c2 == '.') ? true : c2 == '0') ? true : c2 == '1') ? true : c2 == '2') ? true : c2 == '3') ? true : c2 == '4') ? true : c2 == '5') ? true : c2 == '6') ? true : c2 == '7') ? true : c2 == '8') ? true : c2 == '9') {
                currentElement2 = this.createElement(currentElement2, position, TYPE.NUMBER, true, content);
            } else if (currentElement2 instanceof CLContainer && !(currentElement2 instanceof CLObject)) {
                CLToken token;
                currentElement2 = this.createElement(currentElement2, position, TYPE.TOKEN, true, content);
                CLToken cLToken = token = (CLToken)currentElement2;
                Intrinsics.checkNotNull((Object)cLToken);
                if (!cLToken.validate(c, position)) {
                    throw new CLParsingException("incorrect token <" + c + "> at line " + this.mLineNumber, token);
                }
            } else {
                currentElement2 = this.createElement(currentElement2, position, TYPE.KEY, true, content);
            }
        }
        CLElement cLElement = currentElement2;
        Intrinsics.checkNotNull((Object)cLElement);
        return cLElement;
    }

    private final CLElement createElement(CLElement currentElement, int position, TYPE type, boolean applyStart, char[] content) {
        int position2 = position;
        CLElement newElement = null;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                newElement = CLObject.Companion.allocate(content);
                ++position2;
                break;
            }
            case 2: {
                newElement = CLArray.Companion.allocate(content);
                ++position2;
                break;
            }
            case 3: {
                newElement = CLString.Companion.allocate(content);
                break;
            }
            case 4: {
                newElement = CLNumber.Companion.allocate(content);
                break;
            }
            case 5: {
                newElement = CLKey.Companion.allocate(content);
                break;
            }
            case 6: {
                newElement = CLToken.Companion.allocate(content);
            }
        }
        if (newElement == null) {
            return null;
        }
        newElement.setLine(this.mLineNumber);
        if (applyStart) {
            newElement.setStart(position2);
        }
        if (currentElement instanceof CLContainer) {
            newElement.setContainer((CLContainer)currentElement);
        }
        return newElement;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/constraintlayout/core/parser/CLParser$Companion;", "", "()V", "DEBUG", "", "parse", "Landroidx/constraintlayout/core/parser/CLObject;", "string", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CLObject parse(@NotNull String string) throws CLParsingException {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return new CLParser(string).parse();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/constraintlayout/core/parser/CLParser$TYPE;", "", "(Ljava/lang/String;I)V", "UNKNOWN", "OBJECT", "ARRAY", "NUMBER", "STRING", "KEY", "TOKEN", "compose"})
    public static final class TYPE
    extends Enum<TYPE> {
        public static final /* enum */ TYPE UNKNOWN = new TYPE();
        public static final /* enum */ TYPE OBJECT = new TYPE();
        public static final /* enum */ TYPE ARRAY = new TYPE();
        public static final /* enum */ TYPE NUMBER = new TYPE();
        public static final /* enum */ TYPE STRING = new TYPE();
        public static final /* enum */ TYPE KEY = new TYPE();
        public static final /* enum */ TYPE TOKEN = new TYPE();
        private static final /* synthetic */ TYPE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TYPE[] values() {
            return (TYPE[])$VALUES.clone();
        }

        public static TYPE valueOf(String value) {
            return Enum.valueOf(TYPE.class, value);
        }

        @NotNull
        public static EnumEntries<TYPE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tYPEArray = new TYPE[]{TYPE.UNKNOWN, TYPE.OBJECT, TYPE.ARRAY, TYPE.NUMBER, TYPE.STRING, TYPE.KEY, TYPE.TOKEN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TYPE.values().length];
            try {
                nArray[TYPE.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TYPE.ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TYPE.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TYPE.NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TYPE.KEY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TYPE.TOKEN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

