/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.utils.StopEngine;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 .2\u00020\u0001:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nH\u0002J6\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nJ\u0018\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0016J0\u0010,\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00060"}, d2={"Landroidx/constraintlayout/core/motion/utils/StopLogicEngine;", "Landroidx/constraintlayout/core/motion/utils/StopEngine;", "()V", "isStopped", "", "()Z", "mBackwards", "mDone", "getMDone$annotations", "mLastPosition", "", "mLastTime", "mNumberOfStages", "", "mStage1Duration", "mStage1EndPosition", "mStage1Velocity", "mStage2Duration", "mStage2EndPosition", "mStage2Velocity", "mStage3Duration", "mStage3EndPosition", "mStage3Velocity", "mStartPosition", "mType", "", "velocity", "getVelocity", "()F", "calcY", "time", "config", "", "currentPos", "destination", "currentVelocity", "maxTime", "maxAcceleration", "maxVelocity", "debug", "desc", "getInterpolation", "v", "x", "setup", "distance", "Companion", "Decelerate", "compose"})
@StabilityInferred(parameters=0)
public final class StopLogicEngine
implements StopEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float mStage1Velocity;
    private float mStage2Velocity;
    private float mStage3Velocity;
    private float mStage1Duration;
    private float mStage2Duration;
    private float mStage3Duration;
    private float mStage1EndPosition;
    private float mStage2EndPosition;
    private float mStage3EndPosition;
    private int mNumberOfStages;
    @Nullable
    private String mType;
    private boolean mBackwards;
    private float mStartPosition;
    private float mLastPosition;
    private float mLastTime;
    private boolean mDone;
    public static final int $stable = 8;
    private static final float EPSILON = 1.0E-5f;

    private static /* synthetic */ void getMDone$annotations() {
    }

    @Override
    @NotNull
    public String debug(@NotNull String desc, float time) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        float time2 = time;
        String ret = desc + " ===== " + this.mType + "\n";
        ret = ret + desc + (this.mBackwards ? "backwards" : "forward ") + " time = " + time2 + "  stages " + this.mNumberOfStages + "\n";
        ret = ret + desc + " dur " + this.mStage1Duration + " vel " + this.mStage1Velocity + " pos " + this.mStage1EndPosition + "\n";
        if (this.mNumberOfStages > 1) {
            ret = ret + desc + " dur " + this.mStage2Duration + " vel " + this.mStage2Velocity + " pos " + this.mStage2EndPosition + "\n";
        }
        if (this.mNumberOfStages > 2) {
            ret = ret + desc + " dur " + this.mStage3Duration + " vel " + this.mStage3Velocity + " pos " + this.mStage3EndPosition + "\n";
        }
        if (time2 <= this.mStage1Duration) {
            ret = ret + desc + "stage 0\n";
            return ret;
        }
        if (this.mNumberOfStages == 1) {
            ret = ret + desc + "end stage 0\n";
            return ret;
        }
        if ((time2 -= this.mStage1Duration) < this.mStage2Duration) {
            ret = ret + desc + " stage 1\n";
            return ret;
        }
        if (this.mNumberOfStages == 2) {
            ret = ret + desc + "end stage 1\n";
            return ret;
        }
        if ((time2 -= this.mStage2Duration) < this.mStage3Duration) {
            ret = ret + desc + " stage 2\n";
            return ret;
        }
        ret = ret + desc + " end stage 2\n";
        return ret;
    }

    @Override
    public float getVelocity(float x) {
        float x2 = x;
        if (x2 <= this.mStage1Duration) {
            return this.mStage1Velocity + (this.mStage2Velocity - this.mStage1Velocity) * x2 / this.mStage1Duration;
        }
        if (this.mNumberOfStages == 1) {
            return 0.0f;
        }
        if ((x2 -= this.mStage1Duration) < this.mStage2Duration) {
            return this.mStage2Velocity + (this.mStage3Velocity - this.mStage2Velocity) * x2 / this.mStage2Duration;
        }
        if (this.mNumberOfStages == 2) {
            return 0.0f;
        }
        return (x2 -= this.mStage2Duration) < this.mStage3Duration ? this.mStage3Velocity - this.mStage3Velocity * x2 / this.mStage3Duration : 0.0f;
    }

    private final float calcY(float time) {
        float time2 = time;
        this.mDone = false;
        if (time2 <= this.mStage1Duration) {
            return this.mStage1Velocity * time2 + (this.mStage2Velocity - this.mStage1Velocity) * time2 * time2 / ((float)2 * this.mStage1Duration);
        }
        if (this.mNumberOfStages == 1) {
            return this.mStage1EndPosition;
        }
        if ((time2 -= this.mStage1Duration) < this.mStage2Duration) {
            return this.mStage1EndPosition + this.mStage2Velocity * time2 + (this.mStage3Velocity - this.mStage2Velocity) * time2 * time2 / ((float)2 * this.mStage2Duration);
        }
        if (this.mNumberOfStages == 2) {
            return this.mStage2EndPosition;
        }
        if ((time2 -= this.mStage2Duration) <= this.mStage3Duration) {
            return this.mStage2EndPosition + this.mStage3Velocity * time2 - this.mStage3Velocity * time2 * time2 / ((float)2 * this.mStage3Duration);
        }
        this.mDone = true;
        return this.mStage3EndPosition;
    }

    public final void config(float currentPos, float destination, float currentVelocity, float maxTime, float maxAcceleration, float maxVelocity) {
        this.mDone = false;
        this.mStartPosition = currentPos;
        boolean bl = this.mBackwards = currentPos > destination;
        if (this.mBackwards) {
            this.setup(-currentVelocity, currentPos - destination, maxAcceleration, maxVelocity, maxTime);
        } else {
            this.setup(currentVelocity, destination - currentPos, maxAcceleration, maxVelocity, maxTime);
        }
    }

    @Override
    public float getInterpolation(float v) {
        float y;
        this.mLastPosition = y = this.calcY(v);
        this.mLastTime = v;
        return this.mBackwards ? this.mStartPosition - y : this.mStartPosition + y;
    }

    @Override
    public float getVelocity() {
        return this.mBackwards ? -this.getVelocity(this.mLastTime) : this.getVelocity(this.mLastTime);
    }

    @Override
    public boolean isStopped() {
        return this.getVelocity() < 1.0E-5f && Math.abs((double)(this.mStage3EndPosition - this.mLastPosition)) < (double)1.0E-5f;
    }

    private final void setup(float velocity, float distance, float maxAcceleration, float maxVelocity, float maxTime) {
        float velocity2 = velocity;
        this.mDone = false;
        this.mStage3EndPosition = distance;
        if (velocity2 == 0.0f) {
            velocity2 = 1.0E-4f;
        }
        float min_time_to_stop = velocity2 / maxAcceleration;
        float stopDistance = min_time_to_stop * velocity2 / (float)2;
        if (velocity2 < 0.0f) {
            float timeToZeroVelocity = -velocity2 / maxAcceleration;
            float reversDistanceTraveled = timeToZeroVelocity * velocity2 / (float)2;
            float totalDistance = distance - reversDistanceTraveled;
            float peak_v = (float)Math.sqrt(maxAcceleration * totalDistance);
            if (peak_v < maxVelocity) {
                this.mType = "backward accelerate, decelerate";
                this.mNumberOfStages = 2;
                this.mStage1Velocity = velocity2;
                this.mStage2Velocity = peak_v;
                this.mStage3Velocity = 0.0f;
                this.mStage1Duration = (peak_v - velocity2) / maxAcceleration;
                this.mStage2Duration = peak_v / maxAcceleration;
                this.mStage1EndPosition = (velocity2 + peak_v) * this.mStage1Duration / (float)2;
                this.mStage2EndPosition = distance;
                this.mStage3EndPosition = distance;
                return;
            }
            this.mType = "backward accelerate cruse decelerate";
            this.mNumberOfStages = 3;
            this.mStage1Velocity = velocity2;
            this.mStage2Velocity = maxVelocity;
            this.mStage3Velocity = maxVelocity;
            this.mStage1Duration = (maxVelocity - velocity2) / maxAcceleration;
            this.mStage3Duration = maxVelocity / maxAcceleration;
            float accDist = (velocity2 + maxVelocity) * this.mStage1Duration / (float)2;
            float decDist = maxVelocity * this.mStage3Duration / (float)2;
            this.mStage2Duration = (distance - accDist - decDist) / maxVelocity;
            this.mStage1EndPosition = accDist;
            this.mStage2EndPosition = distance - decDist;
            this.mStage3EndPosition = distance;
            return;
        }
        if (stopDistance >= distance) {
            this.mType = "hard stop";
            float time = (float)2 * distance / velocity2;
            this.mNumberOfStages = 1;
            this.mStage1Velocity = velocity2;
            this.mStage2Velocity = 0.0f;
            this.mStage1EndPosition = distance;
            this.mStage1Duration = time;
            return;
        }
        float distance_before_break = distance - stopDistance;
        float cruseTime = distance_before_break / velocity2;
        if (cruseTime + min_time_to_stop < maxTime) {
            this.mType = "cruse decelerate";
            this.mNumberOfStages = 2;
            this.mStage1Velocity = velocity2;
            this.mStage2Velocity = velocity2;
            this.mStage3Velocity = 0.0f;
            this.mStage1EndPosition = distance_before_break;
            this.mStage2EndPosition = distance;
            this.mStage1Duration = cruseTime;
            this.mStage2Duration = velocity2 / maxAcceleration;
            return;
        }
        float peak_v = (float)Math.sqrt(maxAcceleration * distance + velocity2 * velocity2 / (float)2);
        this.mStage1Duration = (peak_v - velocity2) / maxAcceleration;
        this.mStage2Duration = peak_v / maxAcceleration;
        if (peak_v < maxVelocity) {
            this.mType = "accelerate decelerate";
            this.mNumberOfStages = 2;
            this.mStage1Velocity = velocity2;
            this.mStage2Velocity = peak_v;
            this.mStage3Velocity = 0.0f;
            this.mStage1Duration = (peak_v - velocity2) / maxAcceleration;
            this.mStage2Duration = peak_v / maxAcceleration;
            this.mStage1EndPosition = (velocity2 + peak_v) * this.mStage1Duration / (float)2;
            this.mStage2EndPosition = distance;
            return;
        }
        this.mType = "accelerate cruse decelerate";
        this.mNumberOfStages = 3;
        this.mStage1Velocity = velocity2;
        this.mStage2Velocity = maxVelocity;
        this.mStage3Velocity = maxVelocity;
        this.mStage1Duration = (maxVelocity - velocity2) / maxAcceleration;
        this.mStage3Duration = maxVelocity / maxAcceleration;
        float accDist = (velocity2 + maxVelocity) * this.mStage1Duration / (float)2;
        float decDist = maxVelocity * this.mStage3Duration / (float)2;
        this.mStage2Duration = (distance - accDist - decDist) / maxVelocity;
        this.mStage1EndPosition = accDist;
        this.mStage2EndPosition = distance - decDist;
        this.mStage3EndPosition = distance;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/constraintlayout/core/motion/utils/StopLogicEngine$Companion;", "", "()V", "EPSILON", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Landroidx/constraintlayout/core/motion/utils/StopLogicEngine$Decelerate;", "Landroidx/constraintlayout/core/motion/utils/StopEngine;", "()V", "isStopped", "", "()Z", "mAcceleration", "", "mDestination", "mDone", "mDuration", "mInitialPos", "mInitialVelocity", "mLastVelocity", "velocity", "getVelocity", "()F", "config", "", "currentPos", "destination", "currentVelocity", "debug", "", "desc", "time", "getInterpolation", "compose"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nStopLogicEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StopLogicEngine.kt\nandroidx/constraintlayout/core/motion/utils/StopLogicEngine$Decelerate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n1#2:354\n*E\n"})
    public static final class Decelerate
    implements StopEngine {
        private float mDestination;
        private float mInitialVelocity;
        private float mAcceleration;
        private float mLastVelocity;
        private float mDuration;
        private float mInitialPos;
        private boolean mDone;
        public static final int $stable = 8;

        @Override
        @NotNull
        public String debug(@NotNull String desc, float time) {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            return this.mDuration + " " + this.mLastVelocity;
        }

        @Override
        public float getVelocity(float time) {
            float f;
            if (time > this.mDuration) {
                f = 0.0f;
            } else {
                float f2;
                float it = f2 = this.mInitialVelocity + this.mAcceleration * time;
                boolean bl = false;
                this.mLastVelocity = it;
                f = f2;
            }
            return f;
        }

        @Override
        public float getInterpolation(float time) {
            if (time > this.mDuration) {
                this.mDone = true;
                return this.mDestination;
            }
            this.getVelocity(time);
            return this.mInitialPos + (this.mInitialVelocity + this.mAcceleration * time / (float)2) * time;
        }

        @Override
        public float getVelocity() {
            return this.mLastVelocity;
        }

        @Override
        public boolean isStopped() {
            return this.mDone;
        }

        public final void config(float currentPos, float destination, float currentVelocity) {
            this.mDone = false;
            this.mDestination = destination;
            this.mInitialVelocity = currentVelocity;
            this.mInitialPos = currentPos;
            float distance = this.mDestination - currentPos;
            this.mDuration = distance / (currentVelocity / (float)2);
            this.mAcceleration = -currentVelocity / this.mDuration;
        }
    }
}

