/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001d"}, d2={"Landroidx/constraintlayout/core/motion/utils/MonotonicCurveFit;", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "time", "", "y", "", "([D[[D)V", "mExtrapolate", "", "mSlopeTemp", "getMSlopeTemp", "()[D", "setMSlopeTemp", "([D)V", "mT", "mTangent", "[[D", "mY", "getPos", "", "t", "", "v", "", "j", "", "getSlope", "getTimePoints", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class MonotonicCurveFit
extends CurveFit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] mT;
    @NotNull
    private final double[][] mY;
    @NotNull
    private final double[][] mTangent;
    private final boolean mExtrapolate;
    @NotNull
    private double[] mSlopeTemp;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "MonotonicCurveFit";

    @NotNull
    public final double[] getMSlopeTemp() {
        return this.mSlopeTemp;
    }

    public final void setMSlopeTemp(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.mSlopeTemp = dArray;
    }

    public MonotonicCurveFit(@NotNull double[] time, @NotNull double[][] y) {
        int n;
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.mExtrapolate = true;
        int n2 = time.length;
        int dim = y[0].length;
        this.mSlopeTemp = new double[dim];
        int n3 = 0;
        int n4 = n2 - 1;
        double[][] dArrayArray = new double[n4][];
        while (n3 < n4) {
            n = n3++;
            dArrayArray[n] = new double[dim];
        }
        double[][] slope = dArrayArray;
        n4 = 0;
        dArrayArray = new double[n2][];
        while (n4 < n2) {
            n = n4++;
            dArrayArray[n] = new double[dim];
        }
        double[][] tangent = dArrayArray;
        for (int j = 0; j < dim; ++j) {
            n = n2 - 1;
            for (int i = 0; i < n; ++i) {
                double dt = time[i + 1] - time[i];
                slope[i][j] = (y[i + 1][j] - y[i][j]) / dt;
                tangent[i][j] = i == 0 ? slope[i][j] : (slope[i - 1][j] + slope[i][j]) * (double)0.5f;
            }
            tangent[n2 - 1][j] = slope[n2 - 2][j];
        }
        int n5 = n2 - 1;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < dim; ++j) {
                if (slope[i][j] == 0.0) {
                    tangent[i][j] = 0.0;
                    tangent[i + 1][j] = 0.0;
                    continue;
                }
                double a = tangent[i][j] / slope[i][j];
                double b = tangent[i + 1][j] / slope[i][j];
                double h = Math.hypot(a, b);
                if (!(h > 9.0)) continue;
                double t = 3.0 / h;
                tangent[i][j] = t * a * slope[i][j];
                tangent[i + 1][j] = t * b * slope[i][j];
            }
        }
        this.mT = time;
        this.mY = y;
        this.mTangent = tangent;
    }

    @Override
    public void getPos(double t, @NotNull double[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                this.getSlope(this.mT[0], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[0][j] + (t - this.mT[0]) * this.mSlopeTemp[j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                this.getSlope(this.mT[n - 1], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.mSlopeTemp[j];
                }
                return;
            }
        } else {
            if (t <= this.mT[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[0][j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[n - 1][j];
                }
                return;
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = MonotonicCurveFit.Companion.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    @Override
    public void getPos(double t, @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                this.getSlope(this.mT[0], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)(this.mY[0][j] + (t - this.mT[0]) * this.mSlopeTemp[j]);
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                this.getSlope(this.mT[n - 1], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)(this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.mSlopeTemp[j]);
                }
                return;
            }
        } else {
            if (t <= this.mT[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[0][j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[n - 1][j];
                }
                return;
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = (float)MonotonicCurveFit.Companion.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        int n = this.mT.length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                return this.mY[0][j] + (t - this.mT[0]) * this.getSlope(this.mT[0], j);
            }
            if (t >= this.mT[n - 1]) {
                return this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.getSlope(this.mT[n - 1], j);
            }
        } else {
            if (t <= this.mT[0]) {
                return this.mY[0][j];
            }
            if (t >= this.mT[n - 1]) {
                return this.mY[n - 1][j];
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.mT[i]) {
                return this.mY[i][j];
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            double t1 = this.mTangent[i][j];
            double t2 = this.mTangent[i + 1][j];
            return MonotonicCurveFit.Companion.interpolate(h, x, y1, y2, t1, t2);
        }
        return 0.0;
    }

    @Override
    public void getSlope(double t, @NotNull double[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double t2 = t;
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t2 <= this.mT[0]) {
            t2 = this.mT[0];
        } else if (t2 >= this.mT[n - 1]) {
            t2 = this.mT[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t2 <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t2 - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t22 = this.mTangent[i + 1][j];
                v[j] = MonotonicCurveFit.Companion.diff(h, x, y1, y2, t1, t22) / h;
            }
            break;
        }
    }

    @Override
    public double getSlope(double t, int j) {
        double t2 = t;
        int n = this.mT.length;
        if (t2 < this.mT[0]) {
            t2 = this.mT[0];
        } else if (t2 >= this.mT[n - 1]) {
            t2 = this.mT[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t2 <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t2 - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            double t1 = this.mTangent[i][j];
            double t22 = this.mTangent[i + 1][j];
            return MonotonicCurveFit.Companion.diff(h, x, y1, y2, t1, t22) / h;
        }
        return 0.0;
    }

    @Override
    @NotNull
    public double[] getTimePoints() {
        return this.mT;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J8\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/constraintlayout/core/motion/utils/MonotonicCurveFit$Companion;", "", "()V", "TAG", "", "buildWave", "Landroidx/constraintlayout/core/motion/utils/MonotonicCurveFit;", "values", "", "configString", "diff", "", "h", "x", "y1", "y2", "t1", "t2", "interpolate", "compose"})
    @SourceDebugExtension(value={"SMAP\nMonotonicCurveFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonotonicCurveFit.kt\nandroidx/constraintlayout/core/motion/utils/MonotonicCurveFit$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,332:1\n107#2:333\n79#2,22:334\n107#2:357\n79#2,22:358\n1#3:356\n*S KotlinDebug\n*F\n+ 1 MonotonicCurveFit.kt\nandroidx/constraintlayout/core/motion/utils/MonotonicCurveFit$Companion\n*L\n301#1:333\n301#1:334,22\n306#1:357\n306#1:358,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final double interpolate(double h, double x, double y1, double y2, double t1, double t2) {
            double x2 = x * x;
            double x3 = x2 * x;
            return (double)-2 * x3 * y2 + (double)3 * x2 * y2 + (double)2 * x3 * y1 - (double)3 * x2 * y1 + y1 + h * t2 * x3 + h * t1 * x3 - h * t2 * x2 - (double)2 * h * t1 * x2 + h * t1 * x;
        }

        private final double diff(double h, double x, double y1, double y2, double t1, double t2) {
            double x2 = x * x;
            return (double)-6 * x2 * y2 + (double)6 * x * y2 + (double)6 * x2 * y1 - (double)6 * x * y1 + (double)3 * h * t2 * x2 + (double)3 * h * t1 * x2 - (double)2 * h * t2 * x - (double)4 * h * t1 * x + h * t1;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MonotonicCurveFit buildWave(@NotNull String configString) {
            String tmp;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            int $i$f$trim2;
            Intrinsics.checkNotNullParameter((Object)configString, (String)"configString");
            double[] values = new double[configString.length() / 2];
            int start = 0;
            start = StringsKt.indexOf$default((CharSequence)configString, (char)'(', (int)0, (boolean)false, (int)6, null) + 1;
            int off1 = StringsKt.indexOf$default((CharSequence)configString, (char)',', (int)start, (boolean)false, (int)4, null);
            int count = 0;
            while (off1 != -1) {
                void it2;
                void $this$trim$iv;
                Intrinsics.checkNotNullExpressionValue((Object)configString.substring(start, off1), (String)"substring(...)");
                $i$f$trim2 = 0;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                tmp = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                values[count++] = Double.parseDouble(tmp);
                $i$f$trim2 = $this$trim$iv = off1 + 1;
                char c = ',';
                CharSequence charSequence = configString;
                boolean bl = false;
                start = it2;
                Unit unit = Unit.INSTANCE;
                off1 = StringsKt.indexOf$default((CharSequence)charSequence, (char)c, (int)$this$trim$iv, (boolean)false, (int)4, null);
            }
            off1 = StringsKt.indexOf$default((CharSequence)configString, (char)')', (int)start, (boolean)false, (int)4, null);
            String string = configString.substring(start, off1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String $this$trim$iv = string;
            $i$f$trim2 = 0;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            tmp = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            values[count++] = Double.parseDouble(tmp);
            double[] dArray = Arrays.copyOf(values, count);
            Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
            return this.buildWave(dArray);
        }

        private final MonotonicCurveFit buildWave(double[] values) {
            int n;
            int length = values.length * 3 - 2;
            int len = values.length - 1;
            double gap = 1.0 / (double)len;
            int n2 = 0;
            double[][] dArrayArray = new double[length][];
            while (n2 < length) {
                n = n2++;
                dArrayArray[n] = new double[1];
            }
            double[][] points = dArrayArray;
            double[] time = new double[length];
            n = values.length;
            for (int i = 0; i < n; ++i) {
                double v;
                points[i + len][0] = v = values[i];
                time[i + len] = (double)i * gap;
                if (i <= 0) continue;
                points[i + len * 2][0] = v + 1.0;
                time[i + len * 2] = (double)i * gap + 1.0;
                points[i - 1][0] = v - 1.0 - gap;
                time[i - 1] = (double)i * gap + (double)-1 - gap;
            }
            return new MonotonicCurveFit(time, points);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

