/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ext.DecimalKt;
import androidx.constraintlayout.core.ext.Math;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.core.motion.utils.Oscillator;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b'\u0018\u0000 52\u00020\u0001:\u000556789B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0086\u0002J\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001H\u0004JP\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u0001JH\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001aJ\u0018\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u000e\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020\bJ\u000e\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\u001aJ\b\u00102\u001a\u00020\bH\u0016J\u0006\u00103\u001a\u000204R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR*\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator;", "", "()V", "mCurveFit", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "mCycleOscillator", "Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator$CycleOscillator;", "mType", "", "mVariesBy", "", "getMVariesBy", "()I", "setMVariesBy", "(I)V", "mWavePoints", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator$WavePoint;", "Lkotlin/collections/ArrayList;", "getMWavePoints", "()Ljava/util/ArrayList;", "setMWavePoints", "(Ljava/util/ArrayList;)V", "mWaveShape", "mWaveString", "get", "", "t", "getCurveFit", "getSlope", "position", "setCustom", "", "custom", "setPoint", "framePosition", "shape", "waveString", "variesBy", "period", "offset", "phase", "value", "setProperty", "widget", "Landroidx/constraintlayout/core/motion/MotionWidget;", "setType", "type", "setup", "pathLength", "toString", "variesByPath", "", "Companion", "CoreSpline", "CycleOscillator", "PathRotateSet", "WavePoint", "compose"})
@StabilityInferred(parameters=0)
public abstract class KeyCycleOscillator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CurveFit mCurveFit;
    @Nullable
    private CycleOscillator mCycleOscillator;
    @Nullable
    private String mType;
    private int mWaveShape;
    @Nullable
    private String mWaveString;
    private int mVariesBy;
    @NotNull
    private ArrayList<WavePoint> mWavePoints = new ArrayList();
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "KeyCycleOscillator";

    public final int getMVariesBy() {
        return this.mVariesBy;
    }

    public final void setMVariesBy(int n) {
        this.mVariesBy = n;
    }

    @NotNull
    public final ArrayList<WavePoint> getMWavePoints() {
        return this.mWavePoints;
    }

    public final void setMWavePoints(@NotNull ArrayList<WavePoint> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mWavePoints = arrayList;
    }

    public final boolean variesByPath() {
        return this.mVariesBy == 1;
    }

    @NotNull
    public String toString() {
        String string = this.mType;
        Intrinsics.checkNotNull((Object)string);
        Object str = string;
        for (WavePoint wp : this.mWavePoints) {
            str = (String)str + "[" + wp.getMPosition() + " , " + DecimalKt.limitDecimals(Double.valueOf(wp.getMValue()), 2) + "] ";
        }
        return str;
    }

    public final void setType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.mType = type;
    }

    public final float get(float t) {
        CycleOscillator cycleOscillator = this.mCycleOscillator;
        Intrinsics.checkNotNull((Object)cycleOscillator);
        return (float)cycleOscillator.getValues(t);
    }

    public final float getSlope(float position) {
        CycleOscillator cycleOscillator = this.mCycleOscillator;
        Intrinsics.checkNotNull((Object)cycleOscillator);
        return (float)cycleOscillator.getSlope(position);
    }

    @NotNull
    public final CurveFit getCurveFit() {
        CurveFit curveFit = this.mCurveFit;
        Intrinsics.checkNotNull((Object)curveFit);
        return curveFit;
    }

    protected final void setCustom(@NotNull Object custom) {
        Intrinsics.checkNotNullParameter((Object)custom, (String)"custom");
    }

    public final void setPoint(int framePosition, int shape, @NotNull String waveString, int variesBy, float period, float offset, float phase, float value, @Nullable Object custom) {
        Intrinsics.checkNotNullParameter((Object)waveString, (String)"waveString");
        this.mWavePoints.add(new WavePoint(framePosition, period, offset, phase, value));
        if (variesBy != -1) {
            this.mVariesBy = variesBy;
        }
        this.mWaveShape = shape;
        Object object = custom;
        Intrinsics.checkNotNull((Object)object);
        this.setCustom(object);
        this.mWaveString = waveString;
    }

    public final void setPoint(int framePosition, int shape, @Nullable String waveString, int variesBy, float period, float offset, float phase, float value) {
        this.mWavePoints.add(new WavePoint(framePosition, period, offset, phase, value));
        if (variesBy != -1) {
            this.mVariesBy = variesBy;
        }
        this.mWaveShape = shape;
        this.mWaveString = waveString;
    }

    public final void setup(float pathLength) {
        int count = this.mWavePoints.size();
        if (count == 0) {
            return;
        }
        CollectionsKt.sortWith((List)this.mWavePoints, (arg_0, arg_1) -> KeyCycleOscillator.setup$lambda$0(setup.1.INSTANCE, arg_0, arg_1));
        double[] time = new double[count];
        int n = 0;
        Object object = new double[count][];
        while (n < count) {
            int n2 = n++;
            object[n2] = new double[3];
        }
        double[][] values = object;
        this.mCycleOscillator = new CycleOscillator(this.mWaveShape, this.mWaveString, this.mVariesBy, count);
        int i = 0;
        object = this.mWavePoints.iterator();
        while (object.hasNext()) {
            WavePoint wp = (WavePoint)object.next();
            time[i] = (double)wp.getMPeriod() * 0.01;
            values[i][0] = wp.getMValue();
            values[i][1] = wp.getMOffset();
            values[i][2] = wp.getMPhase();
            CycleOscillator cycleOscillator = this.mCycleOscillator;
            Intrinsics.checkNotNull((Object)cycleOscillator);
            cycleOscillator.setPoint(i, wp.getMPosition(), wp.getMPeriod(), wp.getMOffset(), wp.getMPhase(), wp.getMValue());
            ++i;
        }
        CycleOscillator cycleOscillator = this.mCycleOscillator;
        Intrinsics.checkNotNull((Object)cycleOscillator);
        cycleOscillator.setup(pathLength);
        this.mCurveFit = CurveFit.Companion.get(0, time, values);
    }

    public void setProperty(@NotNull MotionWidget widget, float t) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
    }

    private static final int setup$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator$Companion;", "", "()V", "TAG", "", "makeWidgetCycle", "Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator;", "attribute", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeyCycleOscillator makeWidgetCycle(@NotNull String attribute) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            return Intrinsics.areEqual((Object)attribute, (Object)"pathRotate") ? (KeyCycleOscillator)new PathRotateSet(attribute) : (KeyCycleOscillator)new CoreSpline(attribute);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator$CoreSpline;", "Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator;", "str", "", "(Ljava/lang/String;)V", "mType", "getMType", "()Ljava/lang/String;", "setMType", "mTypeId", "", "getMTypeId", "()I", "setMTypeId", "(I)V", "setProperty", "", "widget", "Landroidx/constraintlayout/core/motion/MotionWidget;", "t", "", "compose"})
    private static final class CoreSpline
    extends KeyCycleOscillator {
        @NotNull
        private String mType;
        private int mTypeId;

        @NotNull
        public final String getMType() {
            return this.mType;
        }

        public final void setMType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.mType = string;
        }

        public final int getMTypeId() {
            return this.mTypeId;
        }

        public final void setMTypeId(int n) {
            this.mTypeId = n;
        }

        public CoreSpline(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.mType = str;
            this.mTypeId = TypedValues.CycleType.Companion.getId(this.mType);
        }

        @Override
        public void setProperty(@NotNull MotionWidget widget, float t) {
            Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
            widget.setValue(this.mTypeId, this.get(t));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u0013\n\u0002\b\u001a\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 S2\u00020\u0001:\u0001SB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020E2\u0006\u0010G\u001a\u00020\u001dJ\u000e\u0010H\u001a\u00020E2\u0006\u0010G\u001a\u00020\u001dJ6\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u001d2\u0006\u0010N\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020\u001d2\u0006\u0010P\u001a\u00020\u001dJ\u000e\u0010Q\u001a\u00020J2\u0006\u0010R\u001a\u00020\u001dR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010\u0014R\u000e\u0010%\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0012\"\u0004\b(\u0010\u0014R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u0010\u0014R\u001a\u00102\u001a\u00020*X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010,\"\u0004\b4\u0010.R\u001a\u00105\u001a\u00020*X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010,\"\u0004\b7\u0010.R\u000e\u00108\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0012\"\u0004\b;\u0010\u0014R\u0014\u0010<\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006T"}, d2={"Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator$CycleOscillator;", "", "waveShape", "", "customShape", "", "variesBy", "steps", "(ILjava/lang/String;II)V", "mCurveFit", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "getMCurveFit", "()Landroidx/constraintlayout/core/motion/utils/CurveFit;", "setMCurveFit", "(Landroidx/constraintlayout/core/motion/utils/CurveFit;)V", "mOffsetArr", "", "getMOffsetArr", "()[F", "setMOffsetArr", "([F)V", "mOffst", "mOscillator", "Landroidx/constraintlayout/core/motion/utils/Oscillator;", "getMOscillator", "()Landroidx/constraintlayout/core/motion/utils/Oscillator;", "setMOscillator", "(Landroidx/constraintlayout/core/motion/utils/Oscillator;)V", "mPathLength", "", "getMPathLength", "()F", "setMPathLength", "(F)V", "mPeriod", "getMPeriod", "setMPeriod", "mPhase", "mPhaseArr", "getMPhaseArr", "setMPhaseArr", "mPosition", "", "getMPosition", "()[D", "setMPosition", "([D)V", "mScale", "getMScale", "setMScale", "mSplineSlopeCache", "getMSplineSlopeCache", "setMSplineSlopeCache", "mSplineValueCache", "getMSplineValueCache", "setMSplineValueCache", "mValue", "mValues", "getMValues", "setMValues", "mVariesBy", "getMVariesBy$annotations", "()V", "mWaveShape", "getMWaveShape", "()I", "setMWaveShape", "(I)V", "getLastPhase", "", "getSlope", "time", "getValues", "setPoint", "", "index", "framePosition", "wavePeriod", "offset", "phase", "values", "setup", "pathLength", "Companion", "compose"})
    @StabilityInferred(parameters=0)
    public static final class CycleOscillator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int mVariesBy;
        @NotNull
        private Oscillator mOscillator = new Oscillator();
        private final int mOffst;
        private final int mPhase;
        private final int mValue;
        @NotNull
        private float[] mValues;
        @NotNull
        private double[] mPosition;
        @NotNull
        private float[] mPeriod;
        @NotNull
        private float[] mOffsetArr;
        @NotNull
        private float[] mPhaseArr;
        @NotNull
        private float[] mScale;
        private int mWaveShape;
        @Nullable
        private CurveFit mCurveFit;
        public double[] mSplineValueCache;
        public double[] mSplineSlopeCache;
        private float mPathLength;
        public static final int $stable = 8;
        public static final int UNSET = -1;
        @NotNull
        private static final String TAG = "CycleOscillator";

        private static /* synthetic */ void getMVariesBy$annotations() {
        }

        @NotNull
        public final Oscillator getMOscillator() {
            return this.mOscillator;
        }

        public final void setMOscillator(@NotNull Oscillator oscillator) {
            Intrinsics.checkNotNullParameter((Object)oscillator, (String)"<set-?>");
            this.mOscillator = oscillator;
        }

        @NotNull
        public final float[] getMValues() {
            return this.mValues;
        }

        public final void setMValues(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.mValues = fArray;
        }

        @NotNull
        public final double[] getMPosition() {
            return this.mPosition;
        }

        public final void setMPosition(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.mPosition = dArray;
        }

        @NotNull
        public final float[] getMPeriod() {
            return this.mPeriod;
        }

        public final void setMPeriod(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.mPeriod = fArray;
        }

        @NotNull
        public final float[] getMOffsetArr() {
            return this.mOffsetArr;
        }

        public final void setMOffsetArr(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.mOffsetArr = fArray;
        }

        @NotNull
        public final float[] getMPhaseArr() {
            return this.mPhaseArr;
        }

        public final void setMPhaseArr(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.mPhaseArr = fArray;
        }

        @NotNull
        public final float[] getMScale() {
            return this.mScale;
        }

        public final void setMScale(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.mScale = fArray;
        }

        public final int getMWaveShape() {
            return this.mWaveShape;
        }

        public final void setMWaveShape(int n) {
            this.mWaveShape = n;
        }

        @Nullable
        public final CurveFit getMCurveFit() {
            return this.mCurveFit;
        }

        public final void setMCurveFit(@Nullable CurveFit curveFit) {
            this.mCurveFit = curveFit;
        }

        @NotNull
        public final double[] getMSplineValueCache() {
            if (this.mSplineValueCache != null) {
                return this.mSplineValueCache;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"mSplineValueCache");
            return null;
        }

        public final void setMSplineValueCache(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.mSplineValueCache = dArray;
        }

        @NotNull
        public final double[] getMSplineSlopeCache() {
            if (this.mSplineSlopeCache != null) {
                return this.mSplineSlopeCache;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"mSplineSlopeCache");
            return null;
        }

        public final void setMSplineSlopeCache(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.mSplineSlopeCache = dArray;
        }

        public final float getMPathLength() {
            return this.mPathLength;
        }

        public final void setMPathLength(float f) {
            this.mPathLength = f;
        }

        public CycleOscillator(int waveShape, @Nullable String customShape, int variesBy, int steps) {
            this.mPhase = 1;
            this.mValue = 2;
            this.mWaveShape = waveShape;
            this.mVariesBy = variesBy;
            this.mOscillator.setType(waveShape, customShape);
            this.mValues = new float[steps];
            this.mPosition = new double[steps];
            this.mPeriod = new float[steps];
            this.mOffsetArr = new float[steps];
            this.mPhaseArr = new float[steps];
            this.mScale = new float[steps];
        }

        public final double getValues(float time) {
            if (this.mCurveFit != null) {
                CurveFit curveFit = this.mCurveFit;
                Intrinsics.checkNotNull((Object)curveFit);
                curveFit.getPos((double)time, this.getMSplineValueCache());
            } else {
                this.getMSplineValueCache()[this.mOffst] = this.mOffsetArr[0];
                this.getMSplineValueCache()[this.mPhase] = this.mPhaseArr[0];
                this.getMSplineValueCache()[this.mValue] = this.mValues[0];
            }
            double offset = this.getMSplineValueCache()[this.mOffst];
            double phase = this.getMSplineValueCache()[this.mPhase];
            double waveValue = this.mOscillator.getValue(time, phase);
            return offset + waveValue * this.getMSplineValueCache()[this.mValue];
        }

        public final double getLastPhase() {
            return this.getMSplineValueCache()[1];
        }

        public final double getSlope(float time) {
            if (this.mCurveFit != null) {
                CurveFit curveFit = this.mCurveFit;
                Intrinsics.checkNotNull((Object)curveFit);
                curveFit.getSlope((double)time, this.getMSplineSlopeCache());
                CurveFit curveFit2 = this.mCurveFit;
                Intrinsics.checkNotNull((Object)curveFit2);
                curveFit2.getPos((double)time, this.getMSplineValueCache());
            } else {
                this.getMSplineSlopeCache()[this.mOffst] = 0.0;
                this.getMSplineSlopeCache()[this.mPhase] = 0.0;
                this.getMSplineSlopeCache()[this.mValue] = 0.0;
            }
            double waveValue = this.mOscillator.getValue(time, this.getMSplineValueCache()[this.mPhase]);
            double waveSlope = this.mOscillator.getSlope(time, this.getMSplineValueCache()[this.mPhase], this.getMSplineSlopeCache()[this.mPhase]);
            return this.getMSplineSlopeCache()[this.mOffst] + waveValue * this.getMSplineSlopeCache()[this.mValue] + waveSlope * this.getMSplineValueCache()[this.mValue];
        }

        public final void setPoint(int index, int framePosition, float wavePeriod, float offset, float phase, float values) {
            this.mPosition[index] = (double)framePosition / 100.0;
            this.mPeriod[index] = wavePeriod;
            this.mOffsetArr[index] = offset;
            this.mPhaseArr[index] = phase;
            this.mValues[index] = values;
        }

        public final void setup(float pathLength) {
            int last;
            this.mPathLength = pathLength;
            int n = 0;
            int n2 = this.mPosition.length;
            double[][] dArrayArray = new double[n2][];
            while (n < n2) {
                int n3 = n++;
                dArrayArray[n3] = new double[3];
            }
            double[][] splineValues = dArrayArray;
            this.setMSplineValueCache(new double[2 + this.mValues.length]);
            this.setMSplineSlopeCache(new double[2 + this.mValues.length]);
            if (this.mPosition[0] > 0.0) {
                this.mOscillator.addPoint(0.0, this.mPeriod[0]);
            }
            if (this.mPosition[last = this.mPosition.length - 1] < 1.0) {
                this.mOscillator.addPoint(1.0, this.mPeriod[last]);
            }
            int n4 = ((Object[])splineValues).length;
            for (int i = 0; i < n4; ++i) {
                splineValues[i][this.mOffst] = this.mOffsetArr[i];
                splineValues[i][this.mPhase] = this.mPhaseArr[i];
                splineValues[i][this.mValue] = this.mValues[i];
                this.mOscillator.addPoint(this.mPosition[i], this.mPeriod[i]);
            }
            this.mOscillator.normalize();
            this.mCurveFit = this.mPosition.length > 1 ? CurveFit.Companion.get(0, this.mPosition, splineValues) : null;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator$CycleOscillator$Companion;", "", "()V", "TAG", "", "UNSET", "", "compose"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator$PathRotateSet;", "Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator;", "str", "", "(Ljava/lang/String;)V", "mType", "getMType", "()Ljava/lang/String;", "setMType", "mTypeId", "", "getMTypeId", "()I", "setMTypeId", "(I)V", "setPathRotate", "", "view", "Landroidx/constraintlayout/core/motion/MotionWidget;", "t", "", "dx", "", "dy", "setProperty", "widget", "compose"})
    @StabilityInferred(parameters=0)
    public static final class PathRotateSet
    extends KeyCycleOscillator {
        @NotNull
        private String mType;
        private int mTypeId;
        public static final int $stable = 8;

        @NotNull
        public final String getMType() {
            return this.mType;
        }

        public final void setMType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.mType = string;
        }

        public final int getMTypeId() {
            return this.mTypeId;
        }

        public final void setMTypeId(int n) {
            this.mTypeId = n;
        }

        public PathRotateSet(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.mType = str;
            this.mTypeId = TypedValues.CycleType.Companion.getId(this.mType);
        }

        @Override
        public void setProperty(@NotNull MotionWidget widget, float t) {
            Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
            widget.setValue(this.mTypeId, this.get(t));
        }

        public final void setPathRotate(@NotNull MotionWidget view, float t, double dx, double dy) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            view.setRotationZ(this.get(t) + (float)Math.INSTANCE.toDegrees(java.lang.Math.atan2(dy, dx)));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0018\b\u0007\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\f\"\u0004\b\u001c\u0010\u000e\u00a8\u0006\u001d"}, d2={"Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator$WavePoint;", "", "position", "", "period", "", "offset", "phase", "value", "(IFFFF)V", "mOffset", "getMOffset", "()F", "setMOffset", "(F)V", "mPeriod", "getMPeriod", "setMPeriod", "mPhase", "getMPhase", "setMPhase", "mPosition", "getMPosition", "()I", "setMPosition", "(I)V", "mValue", "getMValue", "setMValue", "compose"})
    @StabilityInferred(parameters=0)
    public static final class WavePoint {
        private int mPosition;
        private float mValue;
        private float mOffset;
        private float mPeriod;
        private float mPhase;
        public static final int $stable = 8;

        public final int getMPosition() {
            return this.mPosition;
        }

        public final void setMPosition(int n) {
            this.mPosition = n;
        }

        public final float getMValue() {
            return this.mValue;
        }

        public final void setMValue(float f) {
            this.mValue = f;
        }

        public final float getMOffset() {
            return this.mOffset;
        }

        public final void setMOffset(float f) {
            this.mOffset = f;
        }

        public final float getMPeriod() {
            return this.mPeriod;
        }

        public final void setMPeriod(float f) {
            this.mPeriod = f;
        }

        public final float getMPhase() {
            return this.mPhase;
        }

        public final void setMPhase(float f) {
            this.mPhase = f;
        }

        public WavePoint(int position, float period, float offset, float phase, float value) {
            this.mPosition = position;
            this.mValue = value;
            this.mOffset = offset;
            this.mPeriod = period;
            this.mPhase = phase;
        }
    }
}

