/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.FloatRect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import java.util.HashMap;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0014\n\u0002\b\t\b\u0017\u0018\u0000 _2\u00020\u0001:\u0001_B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010/\u001a\u0002002\"\u00101\u001a\u001e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020302j\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u000203`4H\u0016J(\u00105\u001a\u0002002\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004H\u0002J(\u0010:\u001a\u0002002\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004H\u0002J6\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004J\u0018\u0010>\u001a\u0002002\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u000fH\u0002J\b\u0010?\u001a\u00020\u0001H\u0016J\u0010\u0010@\u001a\u00020\u00012\u0006\u0010A\u001a\u00020\u0001H\u0016J \u0010B\u001a\u0002002\u0016\u0010C\u001a\u0012\u0012\u0004\u0012\u00020*0Dj\b\u0012\u0004\u0012\u00020*`EH\u0016J\u0012\u0010F\u001a\u00020\u000f2\b\u0010G\u001a\u0004\u0018\u00010*H\u0016J\u0006\u0010H\u001a\u00020\u0004J\u0006\u0010I\u001a\u00020\u0004J6\u0010J\u001a\u00020K2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u0004JK\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020S2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u000e\u0010T\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0U2\u0006\u0010V\u001a\u00020W\u00a2\u0006\u0002\u0010XJC\u0010Y\u001a\u0002002\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u000e\u0010T\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0U2\u0006\u0010V\u001a\u00020W\u00a2\u0006\u0002\u0010ZJC\u0010[\u001a\u0002002\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u000e\u0010T\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0U2\u0006\u0010V\u001a\u00020W\u00a2\u0006\u0002\u0010ZJK\u0010\\\u001a\u0002002\u0006\u0010R\u001a\u00020S2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u000e\u0010T\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0U2\u0006\u0010V\u001a\u00020W\u00a2\u0006\u0002\u0010XJ\u0018\u0010]\u001a\u00020K2\u0006\u0010^\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020\u0004H\u0016J\u0018\u0010]\u001a\u00020K2\u0006\u0010^\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020\u000fH\u0016J\u0018\u0010]\u001a\u00020K2\u0006\u0010^\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020*H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\bR\u001a\u0010#\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010\bR\u001a\u0010&\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006`"}, d2={"Landroidx/constraintlayout/core/motion/key/MotionKeyPosition;", "Landroidx/constraintlayout/core/motion/key/MotionKey;", "()V", "mAltPercentX", "", "getMAltPercentX", "()F", "setMAltPercentX", "(F)V", "mAltPercentY", "getMAltPercentY", "setMAltPercentY", "mCalculatedPositionX", "mCalculatedPositionY", "mCurveFit", "", "getMCurveFit", "()I", "setMCurveFit", "(I)V", "mDrawPath", "getMDrawPath", "setMDrawPath", "mPathMotionArc", "getMPathMotionArc", "setMPathMotionArc", "mPercentHeight", "getMPercentHeight", "setMPercentHeight", "mPercentWidth", "getMPercentWidth", "setMPercentWidth", "mPercentX", "getMPercentX", "setMPercentX", "mPercentY", "getMPercentY", "setMPercentY", "mPositionType", "getMPositionType", "setMPositionType", "mTransitionEasing", "", "getMTransitionEasing", "()Ljava/lang/String;", "setMTransitionEasing", "(Ljava/lang/String;)V", "addValues", "", "splines", "Ljava/util/HashMap;", "Landroidx/constraintlayout/core/motion/utils/SplineSet;", "Lkotlin/collections/HashMap;", "calcCartesianPosition", "startX", "startY", "endX", "endY", "calcPathPosition", "calcPosition", "layoutWidth", "layoutHeight", "calcScreenPosition", "clone", "copy", "src", "getAttributeNames", "attributes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getId", "name", "getPositionX", "getPositionY", "intersects", "", "start", "Landroidx/constraintlayout/core/motion/utils/FloatRect;", "end", "x", "y", "positionAttributes", "view", "Landroidx/constraintlayout/core/motion/MotionWidget;", "attribute", "", "value", "", "(Landroidx/constraintlayout/core/motion/MotionWidget;Landroidx/constraintlayout/core/motion/utils/FloatRect;Landroidx/constraintlayout/core/motion/utils/FloatRect;FF[Ljava/lang/String;[F)V", "positionCartAttributes", "(Landroidx/constraintlayout/core/motion/utils/FloatRect;Landroidx/constraintlayout/core/motion/utils/FloatRect;FF[Ljava/lang/String;[F)V", "positionPathAttributes", "positionScreenAttributes", "setValue", "type", "Companion", "compose"})
@StabilityInferred(parameters=0)
public class MotionKeyPosition
extends MotionKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mCurveFit = -1;
    @Nullable
    private String mTransitionEasing;
    private int mPathMotionArc = -1;
    private int mDrawPath;
    private float mPercentWidth = Float.NaN;
    private float mPercentHeight = Float.NaN;
    private float mPercentX = Float.NaN;
    private float mPercentY = Float.NaN;
    private float mAltPercentX = Float.NaN;
    private float mAltPercentY = Float.NaN;
    private int mPositionType;
    private float mCalculatedPositionX = Float.NaN;
    private float mCalculatedPositionY = Float.NaN;
    public static final int $stable = 8;
    @NotNull
    public static final String NAME = "KeyPosition";
    protected static final float SELECTION_SLOPE = 20.0f;
    public static final int TYPE_SCREEN = 2;
    public static final int TYPE_PATH = 1;
    public static final int TYPE_CARTESIAN = 0;
    public static final int KEY_TYPE = 2;

    public MotionKeyPosition() {
        this.setMType(2);
    }

    public final int getMCurveFit() {
        return this.mCurveFit;
    }

    public final void setMCurveFit(int n) {
        this.mCurveFit = n;
    }

    @Nullable
    public final String getMTransitionEasing() {
        return this.mTransitionEasing;
    }

    public final void setMTransitionEasing(@Nullable String string) {
        this.mTransitionEasing = string;
    }

    public final int getMPathMotionArc() {
        return this.mPathMotionArc;
    }

    public final void setMPathMotionArc(int n) {
        this.mPathMotionArc = n;
    }

    public final int getMDrawPath() {
        return this.mDrawPath;
    }

    public final void setMDrawPath(int n) {
        this.mDrawPath = n;
    }

    public final float getMPercentWidth() {
        return this.mPercentWidth;
    }

    public final void setMPercentWidth(float f) {
        this.mPercentWidth = f;
    }

    public final float getMPercentHeight() {
        return this.mPercentHeight;
    }

    public final void setMPercentHeight(float f) {
        this.mPercentHeight = f;
    }

    public final float getMPercentX() {
        return this.mPercentX;
    }

    public final void setMPercentX(float f) {
        this.mPercentX = f;
    }

    public final float getMPercentY() {
        return this.mPercentY;
    }

    public final void setMPercentY(float f) {
        this.mPercentY = f;
    }

    public final float getMAltPercentX() {
        return this.mAltPercentX;
    }

    public final void setMAltPercentX(float f) {
        this.mAltPercentX = f;
    }

    public final float getMAltPercentY() {
        return this.mAltPercentY;
    }

    public final void setMAltPercentY(float f) {
        this.mAltPercentY = f;
    }

    public final int getMPositionType() {
        return this.mPositionType;
    }

    public final void setMPositionType(int n) {
        this.mPositionType = n;
    }

    private final void calcScreenPosition(int layoutWidth, int layoutHeight) {
        int viewWidth = 0;
        int viewHeight = 0;
        this.mCalculatedPositionX = (float)(layoutWidth - viewWidth) * this.mPercentX + (float)(viewWidth / 2);
        this.mCalculatedPositionY = (float)(layoutHeight - viewHeight) * this.mPercentX + (float)(viewHeight / 2);
    }

    private final void calcPathPosition(float startX, float startY, float endX, float endY) {
        float pathVectorX = endX - startX;
        float pathVectorY = endY - startY;
        float perpendicularY = -pathVectorY;
        float perpendicularX = pathVectorX;
        this.mCalculatedPositionX = startX + pathVectorX * this.mPercentX + perpendicularX * this.mPercentY;
        this.mCalculatedPositionY = startY + pathVectorY * this.mPercentX + perpendicularY * this.mPercentY;
    }

    private final void calcCartesianPosition(float startX, float startY, float endX, float endY) {
        float pathVectorX = endX - startX;
        float pathVectorY = endY - startY;
        float dxdx = Float.isNaN(this.mPercentX) ? 0.0f : this.mPercentX;
        float dydx = Float.isNaN(this.mAltPercentY) ? 0.0f : this.mAltPercentY;
        float dydy = Float.isNaN(this.mPercentY) ? 0.0f : this.mPercentY;
        float dxdy = Float.isNaN(this.mAltPercentX) ? 0.0f : this.mAltPercentX;
        this.mCalculatedPositionX = (int)(startX + pathVectorX * dxdx + pathVectorY * dxdy);
        this.mCalculatedPositionY = (int)(startY + pathVectorX * dydx + pathVectorY * dydy);
    }

    public final float getPositionX() {
        return this.mCalculatedPositionX;
    }

    public final float getPositionY() {
        return this.mCalculatedPositionY;
    }

    public final void positionAttributes(@NotNull MotionWidget view, @NotNull FloatRect start, @NotNull FloatRect end, float x, float y, @NotNull String[] attribute, @NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (this.mPositionType) {
            case 1: {
                this.positionPathAttributes(start, end, x, y, attribute, value);
                return;
            }
            case 2: {
                this.positionScreenAttributes(view, start, end, x, y, attribute, value);
                return;
            }
            case 0: {
                this.positionCartAttributes(start, end, x, y, attribute, value);
                return;
            }
        }
        this.positionCartAttributes(start, end, x, y, attribute, value);
    }

    public final void positionPathAttributes(@NotNull FloatRect start, @NotNull FloatRect end, float x, float y, @NotNull String[] attribute, @NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float endCenterY = end.centerY();
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        float distance = (float)Math.hypot(pathVectorX, pathVectorY);
        if ((double)distance < 1.0E-4) {
            System.out.println((Object)"distance ~ 0");
            value[0] = 0.0f;
            value[1] = 0.0f;
            return;
        }
        float dx = pathVectorX / distance;
        float dy = pathVectorY / distance;
        float perpendicular = (dx * (y - startCenterY) - (x - startCenterX) * dy) / distance;
        float dist = (dx * (x - startCenterX) + dy * (y - startCenterY)) / distance;
        if (attribute[0] != null) {
            if (Intrinsics.areEqual((Object)"percentX", (Object)attribute[0])) {
                value[0] = dist;
                value[1] = perpendicular;
            }
        } else {
            attribute[0] = "percentX";
            attribute[1] = "percentY";
            value[0] = dist;
            value[1] = perpendicular;
        }
    }

    public final void positionScreenAttributes(@NotNull MotionWidget view, @NotNull FloatRect start, @NotNull FloatRect end, float x, float y, @NotNull String[] attribute, @NotNull float[] value) {
        MotionWidget viewGroup;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float endCenterY = end.centerY();
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        MotionWidget motionWidget = viewGroup = view.getParent();
        Intrinsics.checkNotNull((Object)motionWidget);
        int width = motionWidget.getWidth();
        int height = viewGroup.getHeight();
        if (attribute[0] != null) {
            if (Intrinsics.areEqual((Object)"percentX", (Object)attribute[0])) {
                value[0] = x / (float)width;
                value[1] = y / (float)height;
            } else {
                value[1] = x / (float)width;
                value[0] = y / (float)height;
            }
        } else {
            attribute[0] = "percentX";
            value[0] = x / (float)width;
            attribute[1] = "percentY";
            value[1] = y / (float)height;
        }
    }

    public final void positionCartAttributes(@NotNull FloatRect start, @NotNull FloatRect end, float x, float y, @NotNull String[] attribute, @NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float endCenterY = end.centerY();
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        if (attribute[0] != null) {
            if (Intrinsics.areEqual((Object)"percentX", (Object)attribute[0])) {
                value[0] = (x - startCenterX) / pathVectorX;
                value[1] = (y - startCenterY) / pathVectorY;
            } else {
                value[1] = (x - startCenterX) / pathVectorX;
                value[0] = (y - startCenterY) / pathVectorY;
            }
        } else {
            attribute[0] = "percentX";
            value[0] = (x - startCenterX) / pathVectorX;
            attribute[1] = "percentY";
            value[1] = (y - startCenterY) / pathVectorY;
        }
    }

    public final boolean intersects(int layoutWidth, int layoutHeight, @NotNull FloatRect start, @NotNull FloatRect end, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.calcPosition(layoutWidth, layoutHeight, start.centerX(), start.centerY(), end.centerX(), end.centerY());
        return Math.abs((double)(x - this.mCalculatedPositionX)) < 20.0 && Math.abs((double)(y - this.mCalculatedPositionY)) < 20.0;
    }

    @Override
    @NotNull
    public MotionKey copy(@NotNull MotionKey src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        super.copy(src);
        MotionKeyPosition k = (MotionKeyPosition)src;
        this.mTransitionEasing = k.mTransitionEasing;
        this.mPathMotionArc = k.mPathMotionArc;
        this.mDrawPath = k.mDrawPath;
        this.mPercentWidth = k.mPercentWidth;
        this.mPercentHeight = Float.NaN;
        this.mPercentX = k.mPercentX;
        this.mPercentY = k.mPercentY;
        this.mAltPercentX = k.mAltPercentX;
        this.mAltPercentY = k.mAltPercentY;
        this.mCalculatedPositionX = k.mCalculatedPositionX;
        this.mCalculatedPositionY = k.mCalculatedPositionY;
        return this;
    }

    @Override
    @NotNull
    public MotionKey clone() {
        return new MotionKeyPosition().copy(this);
    }

    public final void calcPosition(int layoutWidth, int layoutHeight, float startX, float startY, float endX, float endY) {
        switch (this.mPositionType) {
            case 2: {
                this.calcScreenPosition(layoutWidth, layoutHeight);
                return;
            }
            case 1: {
                this.calcPathPosition(startX, startY, endX, endY);
                return;
            }
            case 0: {
                this.calcCartesianPosition(startX, startY, endX, endY);
                return;
            }
        }
        this.calcCartesianPosition(startX, startY, endX, endY);
    }

    @Override
    public void getAttributeNames(@NotNull HashSet<String> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
    }

    @Override
    public void addValues(@NotNull HashMap<String, SplineSet> splines) {
        Intrinsics.checkNotNullParameter(splines, (String)"splines");
    }

    @Override
    public boolean setValue(int type, int value) {
        switch (type) {
            case 510: {
                this.mPositionType = value;
                break;
            }
            case 100: {
                this.setMFramePosition(value);
                break;
            }
            case 508: {
                this.mCurveFit = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, float value) {
        switch (type) {
            case 503: {
                this.mPercentWidth = value;
                break;
            }
            case 504: {
                this.mPercentHeight = value;
                break;
            }
            case 505: {
                this.mPercentHeight = this.mPercentWidth = value;
                break;
            }
            case 506: {
                this.mPercentX = value;
                break;
            }
            case 507: {
                this.mPercentY = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (type != 501) {
            return super.setValue(type, value);
        }
        this.mTransitionEasing = value;
        return true;
    }

    @Override
    public int getId(@Nullable String name) {
        return TypedValues.PositionType.Companion.getId(name);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/constraintlayout/core/motion/key/MotionKeyPosition$Companion;", "", "()V", "KEY_TYPE", "", "NAME", "", "SELECTION_SLOPE", "", "TYPE_CARTESIAN", "TYPE_PATH", "TYPE_SCREEN", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

