/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u001b\u001a\u00020\u001c2\"\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f0\u001ej\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f` J,\u0010!\u001a\u00020\u001c2\"\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020#0\u001ej\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020#` H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0001H\u0016J\u0006\u0010%\u001a\u00020\u001cJ \u0010&\u001a\u00020\u001c2\u0016\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\t0(j\b\u0012\u0004\u0012\u00020\t`)H\u0016J\u0012\u0010*\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010,\u001a\u00020\u00042\b\u0010-\u001a\u0004\u0018\u00010\tJ\u0006\u0010.\u001a\u00020\u001cJ\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0004H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0006H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0002R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Landroidx/constraintlayout/core/motion/key/MotionKeyCycle;", "Landroidx/constraintlayout/core/motion/key/MotionKey;", "()V", "mAlpha", "", "mCurveFit", "", "getMCurveFit$annotations", "mCustomWaveShape", "", "mElevation", "mProgress", "mRotation", "mRotationX", "mRotationY", "mScaleX", "mScaleY", "mTransitionEasing", "getMTransitionEasing$annotations", "mTransitionPathRotate", "mTranslationX", "mTranslationY", "mTranslationZ", "mWaveOffset", "mWavePeriod", "mWavePhase", "mWaveShape", "addCycleValues", "", "oscSet", "Ljava/util/HashMap;", "Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator;", "Lkotlin/collections/HashMap;", "addValues", "splines", "Landroidx/constraintlayout/core/motion/utils/SplineSet;", "clone", "dump", "getAttributeNames", "attributes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getId", "name", "getValue", "key", "printAttributes", "setValue", "", "type", "value", "Companion", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMotionKeyCycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MotionKeyCycle.kt\nandroidx/constraintlayout/core/motion/key/MotionKeyCycle\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,298:1\n37#2,2:299\n*S KotlinDebug\n*F\n+ 1 MotionKeyCycle.kt\nandroidx/constraintlayout/core/motion/key/MotionKeyCycle\n*L\n274#1:299,2\n*E\n"})
public final class MotionKeyCycle
extends MotionKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String mTransitionEasing;
    private int mCurveFit;
    private int mWaveShape = -1;
    @Nullable
    private String mCustomWaveShape;
    private float mWavePeriod = Float.NaN;
    private float mWaveOffset;
    private float mWavePhase;
    private float mProgress = Float.NaN;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "KeyCycle";
    @NotNull
    public static final String NAME = "KeyCycle";
    @NotNull
    public static final String WAVE_PERIOD = "wavePeriod";
    @NotNull
    public static final String WAVE_OFFSET = "waveOffset";
    @NotNull
    public static final String WAVE_PHASE = "wavePhase";
    @NotNull
    public static final String WAVE_SHAPE = "waveShape";
    public static final int SHAPE_SIN_WAVE = 0;
    public static final int SHAPE_SQUARE_WAVE = 1;
    public static final int SHAPE_TRIANGLE_WAVE = 2;
    public static final int SHAPE_SAW_WAVE = 3;
    public static final int SHAPE_REVERSE_SAW_WAVE = 4;
    public static final int SHAPE_COS_WAVE = 5;
    public static final int SHAPE_BOUNCE = 6;
    public static final int KEY_TYPE = 4;

    public MotionKeyCycle() {
        this.setMType(4);
        this.setMCustom(new HashMap<String, CustomVariable>());
    }

    private static /* synthetic */ void getMTransitionEasing$annotations() {
    }

    private static /* synthetic */ void getMCurveFit$annotations() {
    }

    @Override
    public void getAttributeNames(@NotNull HashSet<String> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotationZ");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("pathRotate");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        HashMap<String, CustomVariable> hashMap = this.getMCustom();
        Intrinsics.checkNotNull(hashMap);
        if (hashMap.size() > 0) {
            HashMap<String, CustomVariable> hashMap2 = this.getMCustom();
            Intrinsics.checkNotNull(hashMap2);
            for (String s : hashMap2.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    @Override
    public void addValues(@NotNull HashMap<String, SplineSet> splines) {
        Intrinsics.checkNotNullParameter(splines, (String)"splines");
    }

    @Override
    public boolean setValue(int type, int value) {
        boolean bl;
        switch (type) {
            case 401: {
                this.mCurveFit = value;
                bl = true;
                break;
            }
            case 421: {
                this.mWaveShape = value;
                bl = true;
                break;
            }
            default: {
                boolean ret = this.setValue(type, (float)value);
                bl = ret ? true : super.setValue(type, value);
            }
        }
        return bl;
    }

    @Override
    public boolean setValue(int type, @NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (type) {
            case 420: {
                this.mTransitionEasing = value;
                bl = true;
                break;
            }
            case 422: {
                this.mCustomWaveShape = value;
                bl = true;
                break;
            }
            default: {
                bl = super.setValue(type, value);
            }
        }
        return bl;
    }

    @Override
    public boolean setValue(int type, float value) {
        switch (type) {
            case 403: {
                this.mAlpha = value;
                break;
            }
            case 304: {
                this.mTranslationX = value;
                break;
            }
            case 305: {
                this.mTranslationY = value;
                break;
            }
            case 306: {
                this.mTranslationZ = value;
                break;
            }
            case 307: {
                this.mElevation = value;
                break;
            }
            case 308: {
                this.mRotationX = value;
                break;
            }
            case 309: {
                this.mRotationY = value;
                break;
            }
            case 310: {
                this.mRotation = value;
                break;
            }
            case 311: {
                this.mScaleX = value;
                break;
            }
            case 312: {
                this.mScaleY = value;
                break;
            }
            case 315: {
                this.mProgress = value;
                break;
            }
            case 416: {
                this.mTransitionPathRotate = value;
                break;
            }
            case 423: {
                this.mWavePeriod = value;
                break;
            }
            case 424: {
                this.mWaveOffset = value;
                break;
            }
            case 425: {
                this.mWavePhase = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final float getValue(@Nullable String key) {
        String string = key;
        if (string == null) return Float.NaN;
        int n = -1;
        switch (string.hashCode()) {
            case -4379043: {
                if (string.equals("elevation")) {
                    n = 1;
                }
                break;
            }
            case 106629499: {
                if (string.equals("phase")) {
                    n = 2;
                }
                break;
            }
            case -1019779949: {
                if (string.equals("offset")) {
                    n = 3;
                }
                break;
            }
            case -908189618: {
                if (string.equals("scaleX")) {
                    n = 4;
                }
                break;
            }
            case -908189617: {
                if (string.equals("scaleY")) {
                    n = 5;
                }
                break;
            }
            case -1249320806: {
                if (string.equals("rotationX")) {
                    n = 6;
                }
                break;
            }
            case -1249320805: {
                if (string.equals("rotationY")) {
                    n = 7;
                }
                break;
            }
            case -1225497657: {
                if (string.equals("translationX")) {
                    n = 8;
                }
                break;
            }
            case -1249320804: {
                if (string.equals("rotationZ")) {
                    n = 9;
                }
                break;
            }
            case 92909918: {
                if (string.equals("alpha")) {
                    n = 10;
                }
                break;
            }
            case -1001078227: {
                if (string.equals("progress")) {
                    n = 11;
                }
                break;
            }
            case -1225497656: {
                if (string.equals("translationY")) {
                    n = 12;
                }
                break;
            }
            case -1225497655: {
                if (string.equals("translationZ")) {
                    n = 13;
                }
                break;
            }
            case 803192288: {
                if (string.equals("pathRotate")) {
                    n = 14;
                }
                break;
            }
        }
        switch (n) {
            case 10: {
                float f = this.mAlpha;
                return f;
            }
            case 1: {
                float f = this.mElevation;
                return f;
            }
            case 9: {
                float f = this.mRotation;
                return f;
            }
            case 6: {
                float f = this.mRotationX;
                return f;
            }
            case 7: {
                float f = this.mRotationY;
                return f;
            }
            case 14: {
                float f = this.mTransitionPathRotate;
                return f;
            }
            case 4: {
                float f = this.mScaleX;
                return f;
            }
            case 5: {
                float f = this.mScaleY;
                return f;
            }
            case 8: {
                float f = this.mTranslationX;
                return f;
            }
            case 12: {
                float f = this.mTranslationY;
                return f;
            }
            case 13: {
                float f = this.mTranslationZ;
                return f;
            }
            case 3: {
                float f = this.mWaveOffset;
                return f;
            }
            case 2: {
                float f = this.mWavePhase;
                return f;
            }
            case 11: {
                float f = this.mProgress;
                return f;
            }
            default: {
                return Float.NaN;
            }
        }
    }

    @Override
    @Nullable
    public MotionKey clone() {
        return null;
    }

    @Override
    public int getId(@Nullable String name) {
        block67: {
            String string = name;
            if (string == null) break block67;
            int n = -1;
            switch (string.hashCode()) {
                case 106629499: {
                    if (string.equals("phase")) {
                        n = 1;
                    }
                    break;
                }
                case 579057826: {
                    if (string.equals("curveFit")) {
                        n = 2;
                    }
                    break;
                }
                case -991726143: {
                    if (string.equals("period")) {
                        n = 3;
                    }
                    break;
                }
                case 1941332754: {
                    if (string.equals("visibility")) {
                        n = 4;
                    }
                    break;
                }
                case -1019779949: {
                    if (string.equals("offset")) {
                        n = 5;
                    }
                    break;
                }
                case -987906985: {
                    if (string.equals("pivotY")) {
                        n = 6;
                    }
                    break;
                }
                case -987906986: {
                    if (string.equals("pivotX")) {
                        n = 7;
                    }
                    break;
                }
                case -1310311125: {
                    if (string.equals("easing")) {
                        n = 8;
                    }
                    break;
                }
                case -908189618: {
                    if (string.equals("scaleX")) {
                        n = 9;
                    }
                    break;
                }
                case -1581616630: {
                    if (string.equals("customWave")) {
                        n = 10;
                    }
                    break;
                }
                case -908189617: {
                    if (string.equals("scaleY")) {
                        n = 11;
                    }
                    break;
                }
                case -1249320806: {
                    if (string.equals("rotationX")) {
                        n = 12;
                    }
                    break;
                }
                case -1225497657: {
                    if (string.equals("translationX")) {
                        n = 13;
                    }
                    break;
                }
                case -1249320805: {
                    if (string.equals("rotationY")) {
                        n = 14;
                    }
                    break;
                }
                case -1249320804: {
                    if (string.equals("rotationZ")) {
                        n = 15;
                    }
                    break;
                }
                case 1532805160: {
                    if (string.equals(WAVE_SHAPE)) {
                        n = 16;
                    }
                    break;
                }
                case 92909918: {
                    if (string.equals("alpha")) {
                        n = 17;
                    }
                    break;
                }
                case -1001078227: {
                    if (string.equals("progress")) {
                        n = 18;
                    }
                    break;
                }
                case -1225497656: {
                    if (string.equals("translationY")) {
                        n = 19;
                    }
                    break;
                }
                case -1225497655: {
                    if (string.equals("translationZ")) {
                        n = 20;
                    }
                    break;
                }
                case 803192288: {
                    if (string.equals("pathRotate")) {
                        n = 21;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return 401;
                }
                case 4: {
                    return 402;
                }
                case 17: {
                    return 403;
                }
                case 13: {
                    return 304;
                }
                case 19: {
                    return 305;
                }
                case 20: {
                    return 306;
                }
                case 12: {
                    return 308;
                }
                case 14: {
                    return 309;
                }
                case 15: {
                    return 310;
                }
                case 9: {
                    return 311;
                }
                case 11: {
                    return 312;
                }
                case 7: {
                    return 313;
                }
                case 6: {
                    return 314;
                }
                case 18: {
                    return 315;
                }
                case 21: {
                    return 416;
                }
                case 8: {
                    return 420;
                }
                case 3: {
                    return 423;
                }
                case 16: {
                    return 421;
                }
                case 1: {
                    return 425;
                }
                case 5: {
                    return 424;
                }
                case 10: {
                    return 422;
                }
            }
        }
        return -1;
    }

    public final void addCycleValues(@NotNull HashMap<String, KeyCycleOscillator> oscSet) {
        Intrinsics.checkNotNullParameter(oscSet, (String)"oscSet");
        for (String key : oscSet.keySet()) {
            KeyCycleOscillator osc;
            Intrinsics.checkNotNull((Object)key);
            if (StringsKt.startsWith$default((String)key, (String)"CUSTOM", (boolean)false, (int)2, null)) {
                KeyCycleOscillator osc2;
                String customKey;
                Intrinsics.checkNotNullExpressionValue((Object)key.substring(7), (String)"substring(...)");
                HashMap<String, CustomVariable> hashMap = this.getMCustom();
                Intrinsics.checkNotNull(hashMap);
                CustomVariable cValue = hashMap.get(customKey);
                if (cValue == null || cValue.getType() != 901 || oscSet.get(key) == null) continue;
                int n = this.getMFramePosition();
                String string = this.mCustomWaveShape;
                Intrinsics.checkNotNull((Object)string);
                osc2.setPoint(n, this.mWaveShape, string, -1, this.mWavePeriod, this.mWaveOffset, this.mWavePhase / (float)360, cValue.getValueToInterpolate(), cValue);
                continue;
            }
            float value = this.getValue(key);
            if (Float.isNaN(value) || oscSet.get(key) == null) continue;
            osc.setPoint(this.getMFramePosition(), this.mWaveShape, this.mCustomWaveShape, -1, this.mWavePeriod, this.mWaveOffset, this.mWavePhase / (float)360, value);
        }
    }

    public final void dump() {
        String string = "MotionKeyCycle{mWaveShape=" + this.mWaveShape + ", mWavePeriod=" + this.mWavePeriod + ", mWaveOffset=" + this.mWaveOffset + ", mWavePhase=" + this.mWavePhase + ", mRotation=" + this.mRotation + "}";
        System.out.println((Object)string);
    }

    public final void printAttributes() {
        HashSet<String> nameSet = new HashSet<String>();
        this.getAttributeNames(nameSet);
        Utils.INSTANCE.log(" ------------- " + this.getMFramePosition() + " -------------");
        Utils.INSTANCE.log("MotionKeyCycle{Shape=" + this.mWaveShape + ", Period=" + this.mWavePeriod + ", Offset=" + this.mWaveOffset + ", Phase=" + this.mWavePhase + "}");
        Collection $this$toTypedArray$iv = nameSet;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] names = thisCollection$iv.toArray(new String[0]);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            Utils.INSTANCE.log(names[i] + ":" + this.getValue(names[i]));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/constraintlayout/core/motion/key/MotionKeyCycle$Companion;", "", "()V", "KEY_TYPE", "", "NAME", "", "SHAPE_BOUNCE", "SHAPE_COS_WAVE", "SHAPE_REVERSE_SAW_WAVE", "SHAPE_SAW_WAVE", "SHAPE_SIN_WAVE", "SHAPE_SQUARE_WAVE", "SHAPE_TRIANGLE_WAVE", "TAG", "WAVE_OFFSET", "WAVE_PERIOD", "WAVE_PHASE", "WAVE_SHAPE", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

