/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ext.ComparatorKt;
import androidx.constraintlayout.core.ext.Math;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.Motion;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKeyPosition;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b$\b\u0007\u0018\u0000 \u009d\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u009d\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0000\u0012\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\nJ\u000e\u0010]\u001a\u00020^2\u0006\u0010\u0006\u001a\u00020_J\u0011\u0010`\u001a\u00020\u00042\u0006\u0010a\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010b\u001a\u00020^2\u0006\u0010c\u001a\u00020CJ\u0018\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\"2\u0006\u0010g\u001a\u00020\"H\u0002J1\u0010h\u001a\u00020^2\u0006\u0010i\u001a\u00020\u00002\u0006\u0010j\u001a\u00020k2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00110m2\u0006\u0010n\u001a\u00020e\u00a2\u0006\u0002\u0010oJ\u0016\u0010p\u001a\u00020^2\u0006\u0010q\u001a\u00020I2\u0006\u0010r\u001a\u00020sJ&\u0010t\u001a\u00020^2\u0006\u0010r\u001a\u00020s2\u0006\u0010q\u001a\u00020I2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u0004J6\u0010x\u001a\u00020^2\u0006\u0010y\u001a\u00020z2\u0006\u0010r\u001a\u00020s2\u0006\u0010q\u001a\u00020I2\u0006\u0010u\u001a\u00020v2\u0006\u0010{\u001a\u00020I2\u0006\u0010|\u001a\u00020vJ.\u0010x\u001a\u00020^2\u0006\u0010y\u001a\u00020z2\u0006\u0010r\u001a\u00020s2\u0006\u0010q\u001a\u00020I2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u0004J.\u0010}\u001a\u00020^2\u0006\u0010y\u001a\u00020z2\u0006\u0010r\u001a\u00020s2\u0006\u0010q\u001a\u00020I2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020\u0004J!\u0010~\u001a\u00020\u00042\b\u0010\u007f\u001a\u0004\u0018\u00010\u00112\u0007\u0010\u0080\u0001\u001a\u00020I2\u0006\u0010w\u001a\u00020\u0004J\u000f\u0010\u0081\u0001\u001a\u00020\u00042\u0006\u0010\u007f\u001a\u00020\u0011J(\u0010\u0082\u0001\u001a\u00020^2\u0006\u0010r\u001a\u00020s2\u0006\u0010q\u001a\u00020I2\u0007\u0010\u0083\u0001\u001a\u00020v2\u0006\u0010w\u001a\u00020\u0004J\u000f\u0010\u0084\u0001\u001a\u00020e2\u0006\u0010\u007f\u001a\u00020\u0011J\u001f\u0010\u0085\u0001\u001a\u00020^2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000J\u001f\u0010\u0086\u0001\u001a\u00020^2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000J1\u0010\u0087\u0001\u001a\u00020^2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0007\u0010\u0088\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u00020\u0000J/\u0010\u008a\u0001\u001a\u00020^2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000J+\u0010\u008b\u0001\u001a\u00020^2\u0007\u0010\u008c\u0001\u001a\u00020\"2\u0007\u0010\u008d\u0001\u001a\u00020\"2\u0007\u0010\u008e\u0001\u001a\u00020\"2\u0007\u0010\u008f\u0001\u001a\u00020\"J=\u0010\u0090\u0001\u001a\u00020^2\u0007\u0010\u0091\u0001\u001a\u00020\"2\u0007\u0010\u0092\u0001\u001a\u00020\"2\u0007\u0010\u0093\u0001\u001a\u00020v2\u0006\u0010r\u001a\u00020s2\u0007\u0010\u0094\u0001\u001a\u00020I2\b\u0010q\u001a\u0004\u0018\u00010IJ=\u0010\u0095\u0001\u001a\u00020^2\u0007\u0010\u0096\u0001\u001a\u00020\"2\u0007\u0010\u0097\u0001\u001a\u00020_2\u0006\u0010r\u001a\u00020s2\u0006\u0010q\u001a\u00020I2\u0007\u0010\u0098\u0001\u001a\u00020I2\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010IJ\u0019\u0010\u009a\u0001\u001a\u00020^2\u0007\u0010\u009b\u0001\u001a\u00020C2\u0007\u0010\u009c\u0001\u001a\u00020\u0000R\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R6\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0017j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0018`\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\r\"\u0004\b \u0010\u000fR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0013\"\u0004\b)\u0010\u0015R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\r\"\u0004\b2\u0010\u000fR\u001a\u00103\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\r\"\u0004\b5\u0010\u000fR\u001a\u00106\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010$\"\u0004\b8\u0010&R\u001a\u00109\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010$\"\u0004\b;\u0010&R\u001a\u0010<\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010$\"\u0004\b>\u0010&R\u001a\u0010?\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010$\"\u0004\bA\u0010&R\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010H\u001a\u00020IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001a\u0010N\u001a\u00020IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010K\"\u0004\bP\u0010MR\u001a\u0010Q\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010$\"\u0004\bS\u0010&R\u001a\u0010T\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010$\"\u0004\bV\u0010&R\u001a\u0010W\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010$\"\u0004\bY\u0010&R\u001a\u0010Z\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010$\"\u0004\b\\\u0010&\u00a8\u0006\u009e\u0001"}, d2={"Landroidx/constraintlayout/core/motion/MotionPaths;", "", "()V", "parentWidth", "", "parentHeight", "c", "Landroidx/constraintlayout/core/motion/key/MotionKeyPosition;", "startTimePoint", "endTimePoint", "(IILandroidx/constraintlayout/core/motion/key/MotionKeyPosition;Landroidx/constraintlayout/core/motion/MotionPaths;Landroidx/constraintlayout/core/motion/MotionPaths;)V", "mAnimateCircleAngleTo", "getMAnimateCircleAngleTo", "()I", "setMAnimateCircleAngleTo", "(I)V", "mAnimateRelativeTo", "", "getMAnimateRelativeTo", "()Ljava/lang/String;", "setMAnimateRelativeTo", "(Ljava/lang/String;)V", "mCustomAttributes", "Ljava/util/HashMap;", "Landroidx/constraintlayout/core/motion/CustomVariable;", "Lkotlin/collections/HashMap;", "getMCustomAttributes", "()Ljava/util/HashMap;", "setMCustomAttributes", "(Ljava/util/HashMap;)V", "mDrawPath", "getMDrawPath", "setMDrawPath", "mHeight", "", "getMHeight", "()F", "setMHeight", "(F)V", "mId", "getMId", "setMId", "mKeyFrameEasing", "Landroidx/constraintlayout/core/motion/utils/Easing;", "getMKeyFrameEasing", "()Landroidx/constraintlayout/core/motion/utils/Easing;", "setMKeyFrameEasing", "(Landroidx/constraintlayout/core/motion/utils/Easing;)V", "mMode", "getMMode", "setMMode", "mPathMotionArc", "getMPathMotionArc", "setMPathMotionArc", "mPathRotate", "getMPathRotate", "setMPathRotate", "mPosition", "getMPosition", "setMPosition", "mProgress", "getMProgress", "setMProgress", "mRelativeAngle", "getMRelativeAngle", "setMRelativeAngle", "mRelativeToController", "Landroidx/constraintlayout/core/motion/Motion;", "getMRelativeToController", "()Landroidx/constraintlayout/core/motion/Motion;", "setMRelativeToController", "(Landroidx/constraintlayout/core/motion/Motion;)V", "mTempDelta", "", "getMTempDelta", "()[D", "setMTempDelta", "([D)V", "mTempValue", "getMTempValue", "setMTempValue", "mTime", "getMTime", "setMTime", "mWidth", "getMWidth", "setMWidth", "mX", "getMX", "setMX", "mY", "getMY", "setMY", "applyParameters", "", "Landroidx/constraintlayout/core/motion/MotionWidget;", "compareTo", "o", "configureRelativeTo", "toOrbit", "diff", "", "a", "b", "different", "points", "mask", "", "custom", "", "arcMode", "(Landroidx/constraintlayout/core/motion/MotionPaths;[Z[Ljava/lang/String;Z)V", "fillStandard", "data", "toUse", "", "getBounds", "point", "", "offset", "getCenter", "p", "", "vdata", "velocity", "getCenterVelocity", "getCustomData", "name", "value", "getCustomDataCount", "getRect", "path", "hasCustomData", "initCartesian", "initPath", "initPolar", "s", "e", "initScreen", "setBounds", "x", "y", "w", "h", "setDpDt", "locationX", "locationY", "mAnchorDpDt", "deltaData", "setView", "position", "view", "slope", "cycle", "setupRelative", "mc", "relative", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class MotionPaths
implements Comparable<MotionPaths> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String mId;
    @Nullable
    private Easing mKeyFrameEasing;
    private int mDrawPath;
    private float mTime;
    private float mPosition;
    private float mX;
    private float mY;
    private float mWidth;
    private float mHeight;
    private float mPathRotate;
    private float mProgress;
    private int mPathMotionArc;
    @Nullable
    private String mAnimateRelativeTo;
    private float mRelativeAngle;
    @Nullable
    private Motion mRelativeToController;
    @NotNull
    private HashMap<String, CustomVariable> mCustomAttributes;
    private int mMode;
    private int mAnimateCircleAngleTo;
    @NotNull
    private double[] mTempValue;
    @NotNull
    private double[] mTempDelta;
    public static final int $stable = 8;
    @NotNull
    public static final String TAG = "MotionPaths";
    public static final boolean DEBUG = false;
    public static final boolean OLD_WAY = false;
    public static final int OFF_POSITION = 0;
    public static final int OFF_X = 1;
    public static final int OFF_Y = 2;
    public static final int OFF_WIDTH = 3;
    public static final int OFF_HEIGHT = 4;
    public static final int OFF_PATH_ROTATE = 5;
    public static final int PERPENDICULAR = 1;
    public static final int CARTESIAN = 0;
    public static final int SCREEN = 2;
    @NotNull
    private static String[] sNames;

    @Nullable
    public final String getMId() {
        return this.mId;
    }

    public final void setMId(@Nullable String string) {
        this.mId = string;
    }

    @Nullable
    public final Easing getMKeyFrameEasing() {
        return this.mKeyFrameEasing;
    }

    public final void setMKeyFrameEasing(@Nullable Easing easing) {
        this.mKeyFrameEasing = easing;
    }

    public final int getMDrawPath() {
        return this.mDrawPath;
    }

    public final void setMDrawPath(int n) {
        this.mDrawPath = n;
    }

    public final float getMTime() {
        return this.mTime;
    }

    public final void setMTime(float f) {
        this.mTime = f;
    }

    public final float getMPosition() {
        return this.mPosition;
    }

    public final void setMPosition(float f) {
        this.mPosition = f;
    }

    public final float getMX() {
        return this.mX;
    }

    public final void setMX(float f) {
        this.mX = f;
    }

    public final float getMY() {
        return this.mY;
    }

    public final void setMY(float f) {
        this.mY = f;
    }

    public final float getMWidth() {
        return this.mWidth;
    }

    public final void setMWidth(float f) {
        this.mWidth = f;
    }

    public final float getMHeight() {
        return this.mHeight;
    }

    public final void setMHeight(float f) {
        this.mHeight = f;
    }

    public final float getMPathRotate() {
        return this.mPathRotate;
    }

    public final void setMPathRotate(float f) {
        this.mPathRotate = f;
    }

    public final float getMProgress() {
        return this.mProgress;
    }

    public final void setMProgress(float f) {
        this.mProgress = f;
    }

    public final int getMPathMotionArc() {
        return this.mPathMotionArc;
    }

    public final void setMPathMotionArc(int n) {
        this.mPathMotionArc = n;
    }

    @Nullable
    public final String getMAnimateRelativeTo() {
        return this.mAnimateRelativeTo;
    }

    public final void setMAnimateRelativeTo(@Nullable String string) {
        this.mAnimateRelativeTo = string;
    }

    public final float getMRelativeAngle() {
        return this.mRelativeAngle;
    }

    public final void setMRelativeAngle(float f) {
        this.mRelativeAngle = f;
    }

    @Nullable
    public final Motion getMRelativeToController() {
        return this.mRelativeToController;
    }

    public final void setMRelativeToController(@Nullable Motion motion) {
        this.mRelativeToController = motion;
    }

    @NotNull
    public final HashMap<String, CustomVariable> getMCustomAttributes() {
        return this.mCustomAttributes;
    }

    public final void setMCustomAttributes(@NotNull HashMap<String, CustomVariable> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.mCustomAttributes = hashMap;
    }

    public final int getMMode() {
        return this.mMode;
    }

    public final void setMMode(int n) {
        this.mMode = n;
    }

    public final int getMAnimateCircleAngleTo() {
        return this.mAnimateCircleAngleTo;
    }

    public final void setMAnimateCircleAngleTo(int n) {
        this.mAnimateCircleAngleTo = n;
    }

    public MotionPaths() {
        this.mPathRotate = Float.NaN;
        this.mProgress = Float.NaN;
        this.mPathMotionArc = -1;
        this.mRelativeAngle = Float.NaN;
        this.mCustomAttributes = new HashMap();
        this.mTempValue = new double[18];
        this.mTempDelta = new double[18];
    }

    public final void initCartesian(@NotNull MotionKeyPosition c, @NotNull MotionPaths startTimePoint, @NotNull MotionPaths endTimePoint) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)startTimePoint, (String)"startTimePoint");
        Intrinsics.checkNotNullParameter((Object)endTimePoint, (String)"endTimePoint");
        float position = (float)c.getMFramePosition() / 100.0f;
        MotionPaths point = this;
        point.mTime = position;
        this.mDrawPath = c.getMDrawPath();
        float scaleWidth = Float.isNaN(c.getMPercentWidth()) ? position : c.getMPercentWidth();
        float scaleHeight = Float.isNaN(c.getMPercentHeight()) ? position : c.getMPercentHeight();
        float scaleX = endTimePoint.mWidth - startTimePoint.mWidth;
        float scaleY = endTimePoint.mHeight - startTimePoint.mHeight;
        point.mPosition = point.mTime;
        float startCenterX = startTimePoint.mX + startTimePoint.mWidth / (float)2;
        float startCenterY = startTimePoint.mY + startTimePoint.mHeight / (float)2;
        float endCenterX = endTimePoint.mX + endTimePoint.mWidth / (float)2;
        float endCenterY = endTimePoint.mY + endTimePoint.mHeight / (float)2;
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        point.mX = (int)(startTimePoint.mX + pathVectorX * position - scaleX * scaleWidth / (float)2);
        point.mY = (int)(startTimePoint.mY + pathVectorY * position - scaleY * scaleHeight / (float)2);
        point.mWidth = (int)(startTimePoint.mWidth + scaleX * scaleWidth);
        point.mHeight = (int)(startTimePoint.mHeight + scaleY * scaleHeight);
        float dxdx = Float.isNaN(c.getMPercentX()) ? position : c.getMPercentX();
        float dydx = Float.isNaN(c.getMAltPercentY()) ? 0.0f : c.getMAltPercentY();
        float dydy = Float.isNaN(c.getMPercentY()) ? position : c.getMPercentY();
        float dxdy = Float.isNaN(c.getMAltPercentX()) ? 0.0f : c.getMAltPercentX();
        point.mMode = 0;
        point.mX = (int)(startTimePoint.mX + pathVectorX * dxdx + pathVectorY * dxdy - scaleX * scaleWidth / (float)2);
        point.mY = (int)(startTimePoint.mY + pathVectorX * dydx + pathVectorY * dydy - scaleY * scaleHeight / (float)2);
        point.mKeyFrameEasing = Easing.Companion.getInterpolator(c.getMTransitionEasing());
        point.mPathMotionArc = c.getMPathMotionArc();
    }

    public MotionPaths(int parentWidth, int parentHeight, @NotNull MotionKeyPosition c, @NotNull MotionPaths startTimePoint, @NotNull MotionPaths endTimePoint) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)startTimePoint, (String)"startTimePoint");
        Intrinsics.checkNotNullParameter((Object)endTimePoint, (String)"endTimePoint");
        this.mPathRotate = Float.NaN;
        this.mProgress = Float.NaN;
        this.mPathMotionArc = -1;
        this.mRelativeAngle = Float.NaN;
        this.mCustomAttributes = new HashMap();
        this.mTempValue = new double[18];
        this.mTempDelta = new double[18];
        if (startTimePoint.mAnimateRelativeTo != null) {
            this.initPolar(parentWidth, parentHeight, c, startTimePoint, endTimePoint);
            return;
        }
        switch (c.getMPositionType()) {
            case 2: {
                this.initScreen(parentWidth, parentHeight, c, startTimePoint, endTimePoint);
                return;
            }
            case 1: {
                this.initPath(c, startTimePoint, endTimePoint);
                return;
            }
            case 0: {
                this.initCartesian(c, startTimePoint, endTimePoint);
                return;
            }
        }
        this.initCartesian(c, startTimePoint, endTimePoint);
    }

    public final void initPolar(int parentWidth, int parentHeight, @NotNull MotionKeyPosition c, @NotNull MotionPaths s, @NotNull MotionPaths e) {
        float position;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.mTime = position = (float)c.getMFramePosition() / 100.0f;
        this.mDrawPath = c.getMDrawPath();
        this.mMode = c.getMPositionType();
        float scaleWidth = Float.isNaN(c.getMPercentWidth()) ? position : c.getMPercentWidth();
        float scaleHeight = Float.isNaN(c.getMPercentHeight()) ? position : c.getMPercentHeight();
        float scaleX = e.mWidth - s.mWidth;
        float scaleY = e.mHeight - s.mHeight;
        this.mPosition = this.mTime;
        this.mWidth = (int)(s.mWidth + scaleX * scaleWidth);
        this.mHeight = (int)(s.mHeight + scaleY * scaleHeight);
        float startfactor = 1.0f - position;
        float endfactor = position;
        switch (c.getMPositionType()) {
            case 2: {
                this.mX = Float.isNaN(c.getMPercentX()) ? position * (e.mX - s.mX) + s.mX : (float)((double)c.getMPercentX() * java.lang.Math.min((double)scaleHeight, (double)scaleWidth));
                this.mY = Float.isNaN(c.getMPercentY()) ? position * (e.mY - s.mY) + s.mY : c.getMPercentY();
                break;
            }
            case 1: {
                this.mX = (Float.isNaN(c.getMPercentX()) ? position : c.getMPercentX()) * (e.mX - s.mX) + s.mX;
                this.mY = (Float.isNaN(c.getMPercentY()) ? position : c.getMPercentY()) * (e.mY - s.mY) + s.mY;
                break;
            }
            case 0: {
                this.mX = (Float.isNaN(c.getMPercentX()) ? position : c.getMPercentX()) * (e.mX - s.mX) + s.mX;
                this.mY = (Float.isNaN(c.getMPercentY()) ? position : c.getMPercentY()) * (e.mY - s.mY) + s.mY;
                break;
            }
            default: {
                this.mX = (Float.isNaN(c.getMPercentX()) ? position : c.getMPercentX()) * (e.mX - s.mX) + s.mX;
                this.mY = (Float.isNaN(c.getMPercentY()) ? position : c.getMPercentY()) * (e.mY - s.mY) + s.mY;
            }
        }
        this.mAnimateRelativeTo = s.mAnimateRelativeTo;
        this.mKeyFrameEasing = Easing.Companion.getInterpolator(c.getMTransitionEasing());
        this.mPathMotionArc = c.getMPathMotionArc();
    }

    public final void setupRelative(@NotNull Motion mc, @NotNull MotionPaths relative) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        double dx = this.mX + this.mWidth / (float)2 - relative.mX - relative.mWidth / (float)2;
        double dy = this.mY + this.mHeight / (float)2 - relative.mY - relative.mHeight / (float)2;
        this.mRelativeToController = mc;
        this.mX = (float)java.lang.Math.hypot(dy, dx);
        this.mY = Float.isNaN(this.mRelativeAngle) ? (float)(java.lang.Math.atan2(dy, dx) + 1.5707963267948966) : (float)Math.INSTANCE.toRadians(this.mRelativeAngle);
    }

    public final void initScreen(int parentWidth, int parentHeight, @NotNull MotionKeyPosition c, @NotNull MotionPaths startTimePoint, @NotNull MotionPaths endTimePoint) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)startTimePoint, (String)"startTimePoint");
        Intrinsics.checkNotNullParameter((Object)endTimePoint, (String)"endTimePoint");
        int parentWidth2 = parentWidth;
        int parentHeight2 = parentHeight;
        float position = (float)c.getMFramePosition() / 100.0f;
        MotionPaths point = this;
        point.mTime = position;
        this.mDrawPath = c.getMDrawPath();
        float scaleWidth = Float.isNaN(c.getMPercentWidth()) ? position : c.getMPercentWidth();
        float scaleHeight = Float.isNaN(c.getMPercentHeight()) ? position : c.getMPercentHeight();
        float scaleX = endTimePoint.mWidth - startTimePoint.mWidth;
        float scaleY = endTimePoint.mHeight - startTimePoint.mHeight;
        point.mPosition = point.mTime;
        float startCenterX = startTimePoint.mX + startTimePoint.mWidth / (float)2;
        float startCenterY = startTimePoint.mY + startTimePoint.mHeight / (float)2;
        float endCenterX = endTimePoint.mX + endTimePoint.mWidth / (float)2;
        float endCenterY = endTimePoint.mY + endTimePoint.mHeight / (float)2;
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        point.mX = (int)(startTimePoint.mX + pathVectorX * position - scaleX * scaleWidth / (float)2);
        point.mY = (int)(startTimePoint.mY + pathVectorY * position - scaleY * scaleHeight / (float)2);
        point.mWidth = (int)(startTimePoint.mWidth + scaleX * scaleWidth);
        point.mHeight = (int)(startTimePoint.mHeight + scaleY * scaleHeight);
        point.mMode = 2;
        if (!Float.isNaN(c.getMPercentX())) {
            point.mX = (int)(c.getMPercentX() * (float)(parentWidth2 -= (int)point.mWidth));
        }
        if (!Float.isNaN(c.getMPercentY())) {
            point.mY = (int)(c.getMPercentY() * (float)(parentHeight2 -= (int)point.mHeight));
        }
        point.mAnimateRelativeTo = this.mAnimateRelativeTo;
        point.mKeyFrameEasing = Easing.Companion.getInterpolator(c.getMTransitionEasing());
        point.mPathMotionArc = c.getMPathMotionArc();
    }

    public final void initPath(@NotNull MotionKeyPosition c, @NotNull MotionPaths startTimePoint, @NotNull MotionPaths endTimePoint) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)startTimePoint, (String)"startTimePoint");
        Intrinsics.checkNotNullParameter((Object)endTimePoint, (String)"endTimePoint");
        float position = (float)c.getMFramePosition() / 100.0f;
        MotionPaths point = this;
        point.mTime = position;
        this.mDrawPath = c.getMDrawPath();
        float scaleWidth = Float.isNaN(c.getMPercentWidth()) ? position : c.getMPercentWidth();
        float scaleHeight = Float.isNaN(c.getMPercentHeight()) ? position : c.getMPercentHeight();
        float scaleX = endTimePoint.mWidth - startTimePoint.mWidth;
        float scaleY = endTimePoint.mHeight - startTimePoint.mHeight;
        point.mPosition = point.mTime;
        float path = Float.isNaN(c.getMPercentX()) ? position : c.getMPercentX();
        float startCenterX = startTimePoint.mX + startTimePoint.mWidth / (float)2;
        float startCenterY = startTimePoint.mY + startTimePoint.mHeight / (float)2;
        float endCenterX = endTimePoint.mX + endTimePoint.mWidth / (float)2;
        float endCenterY = endTimePoint.mY + endTimePoint.mHeight / (float)2;
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        point.mX = (int)(startTimePoint.mX + pathVectorX * path - scaleX * scaleWidth / (float)2);
        point.mY = (int)(startTimePoint.mY + pathVectorY * path - scaleY * scaleHeight / (float)2);
        point.mWidth = (int)(startTimePoint.mWidth + scaleX * scaleWidth);
        point.mHeight = (int)(startTimePoint.mHeight + scaleY * scaleHeight);
        float perpendicular = Float.isNaN(c.getMPercentY()) ? 0.0f : c.getMPercentY();
        float perpendicularX = -pathVectorY;
        float normalX = perpendicularX * perpendicular;
        float normalY = pathVectorX * perpendicular;
        point.mMode = 1;
        point.mX = (int)(startTimePoint.mX + pathVectorX * path - scaleX * scaleWidth / (float)2);
        point.mY = (int)(startTimePoint.mY + pathVectorY * path - scaleY * scaleHeight / (float)2);
        point.mX += normalX;
        point.mY += normalY;
        point.mAnimateRelativeTo = this.mAnimateRelativeTo;
        point.mKeyFrameEasing = Easing.Companion.getInterpolator(c.getMTransitionEasing());
        point.mPathMotionArc = c.getMPathMotionArc();
    }

    private final boolean diff(float a, float b) {
        return Float.isNaN(a) || Float.isNaN(b) ? Float.isNaN(a) != Float.isNaN(b) : java.lang.Math.abs((double)(a - b)) > (double)1.0E-6f;
    }

    public final void different(@NotNull MotionPaths points, @NotNull boolean[] mask, @NotNull String[] custom, boolean arcMode) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        Intrinsics.checkNotNullParameter((Object)custom, (String)"custom");
        int c = 0;
        boolean diffx = this.diff(this.mX, points.mX);
        boolean diffy = this.diff(this.mY, points.mY);
        mask[c++] = mask[c] | this.diff(this.mPosition, points.mPosition);
        mask[c++] = mask[c] | (diffx || diffy || arcMode);
        mask[c++] = mask[c] | (diffx || diffy || arcMode);
        mask[c++] = mask[c] | this.diff(this.mWidth, points.mWidth);
        mask[c++] = mask[c] | this.diff(this.mHeight, points.mHeight);
    }

    public final void getCenter(double p, @NotNull int[] toUse, @NotNull double[] data, @NotNull float[] point, int offset) {
        Intrinsics.checkNotNullParameter((Object)toUse, (String)"toUse");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float translationX = 0.0f;
        float translationY = 0.0f;
        int n = toUse.length;
        block6: for (int i = 0; i < n; ++i) {
            float value = (float)data[i];
            switch (toUse[i]) {
                case 1: {
                    v_x = value;
                    continue block6;
                }
                case 2: {
                    v_y = value;
                    continue block6;
                }
                case 3: {
                    v_width = value;
                    continue block6;
                }
                case 4: {
                    v_height = value;
                }
            }
        }
        if (this.mRelativeToController != null) {
            float[] pos = new float[2];
            float[] vel = new float[2];
            Motion motion = this.mRelativeToController;
            Intrinsics.checkNotNull((Object)motion);
            motion.getCenter(p, pos, vel);
            float rx = pos[0];
            float ry = pos[1];
            float radius = v_x;
            float angle = v_y;
            v_x = (float)((double)rx + (double)radius * java.lang.Math.sin(angle) - (double)(v_width / (float)2));
            v_y = (float)((double)ry - (double)radius * java.lang.Math.cos(angle) - (double)(v_height / (float)2));
        }
        point[offset] = v_x + v_width / (float)2 + translationX;
        point[offset + 1] = v_y + v_height / (float)2 + translationY;
    }

    public final void getCenter(double p, @NotNull int[] toUse, @NotNull double[] data, @NotNull float[] point, @NotNull double[] vdata, @NotNull float[] velocity) {
        Intrinsics.checkNotNullParameter((Object)toUse, (String)"toUse");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)vdata, (String)"vdata");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float dv_x = 0.0f;
        float dv_y = 0.0f;
        float dv_width = 0.0f;
        float dv_height = 0.0f;
        float translationX = 0.0f;
        float translationY = 0.0f;
        int n = toUse.length;
        block6: for (int i = 0; i < n; ++i) {
            float value = (float)data[i];
            float dvalue = (float)vdata[i];
            switch (toUse[i]) {
                case 1: {
                    v_x = value;
                    dv_x = dvalue;
                    continue block6;
                }
                case 2: {
                    v_y = value;
                    dv_y = dvalue;
                    continue block6;
                }
                case 3: {
                    v_width = value;
                    dv_width = dvalue;
                    continue block6;
                }
                case 4: {
                    v_height = value;
                    dv_height = dvalue;
                }
            }
        }
        float dpos_x = dv_x + dv_width / (float)2;
        float dpos_y = dv_y + dv_height / (float)2;
        if (this.mRelativeToController != null) {
            float[] pos = new float[2];
            float[] vel = new float[2];
            Motion motion = this.mRelativeToController;
            Intrinsics.checkNotNull((Object)motion);
            motion.getCenter(p, pos, vel);
            float rx = pos[0];
            float ry = pos[1];
            float radius = v_x;
            float angle = v_y;
            float dradius = dv_x;
            float dangle = dv_y;
            float drx = vel[0];
            float dry = vel[1];
            v_x = (float)((double)rx + (double)radius * java.lang.Math.sin(angle) - (double)(v_width / (float)2));
            v_y = (float)((double)ry - (double)radius * java.lang.Math.cos(angle) - (double)(v_height / (float)2));
            dpos_x = (float)((double)drx + (double)dradius * java.lang.Math.sin(angle) + java.lang.Math.cos(angle) * (double)dangle);
            dpos_y = (float)((double)dry - (double)dradius * java.lang.Math.cos(angle) + java.lang.Math.sin(angle) * (double)dangle);
        }
        point[0] = v_x + v_width / (float)2 + translationX;
        point[1] = v_y + v_height / (float)2 + translationY;
        velocity[0] = dpos_x;
        velocity[1] = dpos_y;
    }

    public final void getCenterVelocity(double p, @NotNull int[] toUse, @NotNull double[] data, @NotNull float[] point, int offset) {
        Intrinsics.checkNotNullParameter((Object)toUse, (String)"toUse");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float translationX = 0.0f;
        float translationY = 0.0f;
        int n = toUse.length;
        block6: for (int i = 0; i < n; ++i) {
            float value = (float)data[i];
            switch (toUse[i]) {
                case 1: {
                    v_x = value;
                    continue block6;
                }
                case 2: {
                    v_y = value;
                    continue block6;
                }
                case 3: {
                    v_width = value;
                    continue block6;
                }
                case 4: {
                    v_height = value;
                }
            }
        }
        if (this.mRelativeToController != null) {
            float[] pos = new float[2];
            float[] vel = new float[2];
            Motion motion = this.mRelativeToController;
            Intrinsics.checkNotNull((Object)motion);
            motion.getCenter(p, pos, vel);
            float rx = pos[0];
            float ry = pos[1];
            float radius = v_x;
            float angle = v_y;
            v_x = (float)((double)rx + (double)radius * java.lang.Math.sin(angle) - (double)(v_width / (float)2));
            v_y = (float)((double)ry - (double)radius * java.lang.Math.cos(angle) - (double)(v_height / (float)2));
        }
        point[offset] = v_x + v_width / (float)2 + translationX;
        point[offset + 1] = v_y + v_height / (float)2 + translationY;
    }

    public final void getBounds(@NotNull int[] toUse, @NotNull double[] data, @NotNull float[] point, int offset) {
        Intrinsics.checkNotNullParameter((Object)toUse, (String)"toUse");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        int n = toUse.length;
        block6: for (int i = 0; i < n; ++i) {
            float value = (float)data[i];
            switch (toUse[i]) {
                case 1: {
                    v_x = value;
                    continue block6;
                }
                case 2: {
                    v_y = value;
                    continue block6;
                }
                case 3: {
                    v_width = value;
                    continue block6;
                }
                case 4: {
                    v_height = value;
                }
            }
        }
        point[offset] = v_width;
        point[offset + 1] = v_height;
    }

    @NotNull
    public final double[] getMTempValue() {
        return this.mTempValue;
    }

    public final void setMTempValue(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.mTempValue = dArray;
    }

    @NotNull
    public final double[] getMTempDelta() {
        return this.mTempDelta;
    }

    public final void setMTempDelta(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.mTempDelta = dArray;
    }

    public final void setView(float position, @NotNull MotionWidget view, @NotNull int[] toUse, @NotNull double[] data, @NotNull double[] slope, @Nullable double[] cycle) {
        int i;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)toUse, (String)"toUse");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)slope, (String)"slope");
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float dv_x = 0.0f;
        float dv_y = 0.0f;
        float dv_width = 0.0f;
        float dv_height = 0.0f;
        float delta_path = 0.0f;
        float path_rotate = Float.NaN;
        Object mod = null;
        if (!(toUse.length == 0) && this.mTempValue.length <= toUse[toUse.length - 1]) {
            int scratch_data_length = toUse[toUse.length - 1] + 1;
            this.mTempValue = new double[scratch_data_length];
            this.mTempDelta = new double[scratch_data_length];
        }
        ArraysKt.fill$default((double[])this.mTempValue, (double)Double.NaN, (int)0, (int)0, (int)6, null);
        int n = toUse.length;
        for (i = 0; i < n; ++i) {
            this.mTempValue[toUse[i]] = data[i];
            this.mTempDelta[toUse[i]] = slope[i];
        }
        n = this.mTempValue.length;
        block9: for (i = 0; i < n; ++i) {
            if (Double.isNaN(this.mTempValue[i]) && (cycle == null || cycle[i] == 0.0)) continue;
            double deltaCycle = cycle != null ? cycle[i] : 0.0;
            float value = (float)(Double.isNaN(this.mTempValue[i]) ? deltaCycle : this.mTempValue[i] + deltaCycle);
            float dvalue = (float)this.mTempDelta[i];
            switch (i) {
                case 0: {
                    delta_path = value;
                    continue block9;
                }
                case 1: {
                    v_x = value;
                    dv_x = dvalue;
                    continue block9;
                }
                case 2: {
                    v_y = value;
                    dv_y = dvalue;
                    continue block9;
                }
                case 3: {
                    v_width = value;
                    dv_width = dvalue;
                    continue block9;
                }
                case 4: {
                    v_height = value;
                    dv_height = dvalue;
                    continue block9;
                }
                case 5: {
                    path_rotate = value;
                }
            }
        }
        if (this.mRelativeToController != null) {
            float[] pos = new float[2];
            float[] vel = new float[2];
            Motion motion = this.mRelativeToController;
            Intrinsics.checkNotNull((Object)motion);
            motion.getCenter(position, pos, vel);
            float rx = pos[0];
            float ry = pos[1];
            float radius = v_x;
            float angle = v_y;
            float dradius = dv_x;
            float dangle = dv_y;
            float drx = vel[0];
            float dry = vel[1];
            float pos_x = (float)((double)rx + (double)radius * java.lang.Math.sin(angle) - (double)(v_width / (float)2));
            float pos_y = (float)((double)ry - (double)radius * java.lang.Math.cos(angle) - (double)(v_height / (float)2));
            float dpos_x = (float)((double)drx + (double)dradius * java.lang.Math.sin(angle) + (double)radius * java.lang.Math.cos(angle) * (double)dangle);
            float dpos_y = (float)((double)dry - (double)dradius * java.lang.Math.cos(angle) + (double)radius * java.lang.Math.sin(angle) * (double)dangle);
            dv_x = dpos_x;
            dv_y = dpos_y;
            v_x = pos_x;
            v_y = pos_y;
            if (slope.length >= 2) {
                slope[0] = dpos_x;
                slope[1] = dpos_y;
            }
            if (!Float.isNaN(path_rotate)) {
                float rot = (float)((double)path_rotate + Math.INSTANCE.toDegrees(java.lang.Math.atan2(dv_y, dv_x)));
                view.setRotationZ(rot);
            }
        } else if (!Float.isNaN(path_rotate)) {
            float rot = 0.0f;
            float dx = dv_x + dv_width / (float)2;
            float dy = dv_y + dv_height / (float)2;
            view.setRotationZ(rot += (float)((double)path_rotate + Math.INSTANCE.toDegrees(java.lang.Math.atan2(dy, dx))));
        }
        int l = (int)(0.5f + v_x);
        int t = (int)(0.5f + v_y);
        int r = (int)(0.5f + v_x + v_width);
        int b = (int)(0.5f + v_y + v_height);
        int i_width = r - l;
        int i_height = b - t;
        view.layout(l, t, r, b);
    }

    public final void getRect(@NotNull int[] toUse, @NotNull double[] data, @NotNull float[] path, int offset) {
        Intrinsics.checkNotNullParameter((Object)toUse, (String)"toUse");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int offset2 = offset;
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float delta_path = 0.0f;
        float rotation = 0.0f;
        float alpha = 0.0f;
        float rotationX = 0.0f;
        float rotationY = 0.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float pivotX = Float.NaN;
        float pivotY = Float.NaN;
        float translationX = 0.0f;
        float translationY = 0.0f;
        Object mod = null;
        int n = toUse.length;
        block7: for (int i = 0; i < n; ++i) {
            float value = (float)data[i];
            switch (toUse[i]) {
                case 0: {
                    delta_path = value;
                    continue block7;
                }
                case 1: {
                    v_x = value;
                    continue block7;
                }
                case 2: {
                    v_y = value;
                    continue block7;
                }
                case 3: {
                    v_width = value;
                    continue block7;
                }
                case 4: {
                    v_height = value;
                }
            }
        }
        if (this.mRelativeToController != null) {
            Motion motion = this.mRelativeToController;
            Intrinsics.checkNotNull((Object)motion);
            float rx = motion.getCenterX();
            Motion motion2 = this.mRelativeToController;
            Intrinsics.checkNotNull((Object)motion2);
            float ry = motion2.getCenterY();
            float radius = v_x;
            float angle = v_y;
            v_x = (float)((double)rx + (double)radius * java.lang.Math.sin(angle) - (double)(v_width / (float)2));
            v_y = (float)((double)ry - (double)radius * java.lang.Math.cos(angle) - (double)(v_height / (float)2));
        }
        float x1 = v_x;
        float y1 = v_y;
        float x2 = v_x + v_width;
        float y2 = y1;
        float x3 = x2;
        float y3 = v_y + v_height;
        float x4 = x1;
        float y4 = y3;
        float cx = x1 + v_width / (float)2;
        float cy = y1 + v_height / (float)2;
        if (!Float.isNaN(pivotX)) {
            cx = x1 + (x2 - x1) * pivotX;
        }
        if (!Float.isNaN(pivotY)) {
            cy = y1 + (y3 - y1) * pivotY;
        }
        if (!(scaleX == 1.0f)) {
            float midx = (x1 + x2) / (float)2;
            x1 = (x1 - midx) * scaleX + midx;
            x2 = (x2 - midx) * scaleX + midx;
            x3 = (x3 - midx) * scaleX + midx;
            x4 = (x4 - midx) * scaleX + midx;
        }
        if (!(scaleY == 1.0f)) {
            float midy = (y1 + y3) / (float)2;
            y1 = (y1 - midy) * scaleY + midy;
            y2 = (y2 - midy) * scaleY + midy;
            y3 = (y3 - midy) * scaleY + midy;
            y4 = (y4 - midy) * scaleY + midy;
        }
        if (!(rotation == 0.0f)) {
            float sin = (float)java.lang.Math.sin(Math.INSTANCE.toRadians(rotation));
            float cos = (float)java.lang.Math.cos(Math.INSTANCE.toRadians(rotation));
            float tx1 = MotionPaths.Companion.xRotate(sin, cos, cx, cy, x1, y1);
            float ty1 = MotionPaths.Companion.yRotate(sin, cos, cx, cy, x1, y1);
            float tx2 = MotionPaths.Companion.xRotate(sin, cos, cx, cy, x2, y2);
            float ty2 = MotionPaths.Companion.yRotate(sin, cos, cx, cy, x2, y2);
            float tx3 = MotionPaths.Companion.xRotate(sin, cos, cx, cy, x3, y3);
            float ty3 = MotionPaths.Companion.yRotate(sin, cos, cx, cy, x3, y3);
            float tx4 = MotionPaths.Companion.xRotate(sin, cos, cx, cy, x4, y4);
            float ty4 = MotionPaths.Companion.yRotate(sin, cos, cx, cy, x4, y4);
            x1 = tx1;
            y1 = ty1;
            x2 = tx2;
            y2 = ty2;
            x3 = tx3;
            y3 = ty3;
            x4 = tx4;
            y4 = ty4;
        }
        x1 += translationX;
        y1 += translationY;
        x2 += translationX;
        y2 += translationY;
        x3 += translationX;
        y3 += translationY;
        x4 += translationX;
        y4 += translationY;
        path[offset2++] = x1;
        path[offset2++] = y1;
        path[offset2++] = x2;
        path[offset2++] = y2;
        path[offset2++] = x3;
        path[offset2++] = y3;
        path[offset2++] = x4;
        path[offset2++] = y4;
    }

    public final void setDpDt(float locationX, float locationY, @NotNull float[] mAnchorDpDt, @NotNull int[] toUse, @NotNull double[] deltaData, @Nullable double[] data) {
        Intrinsics.checkNotNullParameter((Object)mAnchorDpDt, (String)"mAnchorDpDt");
        Intrinsics.checkNotNullParameter((Object)toUse, (String)"toUse");
        Intrinsics.checkNotNullParameter((Object)deltaData, (String)"deltaData");
        float d_x = 0.0f;
        float d_y = 0.0f;
        float d_width = 0.0f;
        float d_height = 0.0f;
        float deltaScaleX = 0.0f;
        float deltaScaleY = 0.0f;
        float mPathRotate = Float.NaN;
        float deltaTranslationX = 0.0f;
        float deltaTranslationY = 0.0f;
        String mod = " dd = ";
        int n = toUse.length;
        block7: for (int i = 0; i < n; ++i) {
            float deltaV = (float)deltaData[i];
            switch (toUse[i]) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    d_x = deltaV;
                    continue block7;
                }
                case 2: {
                    d_y = deltaV;
                    continue block7;
                }
                case 3: {
                    d_width = deltaV;
                    continue block7;
                }
                case 4: {
                    d_height = deltaV;
                }
            }
        }
        float deltaX = d_x - deltaScaleX * d_width / (float)2;
        float deltaY = d_y - deltaScaleY * d_height / (float)2;
        float deltaWidth = d_width * (1.0f + deltaScaleX);
        float deltaHeight = d_height * (1.0f + deltaScaleY);
        float deltaRight = deltaX + deltaWidth;
        float deltaBottom = deltaY + deltaHeight;
        mAnchorDpDt[0] = deltaX * (1.0f - locationX) + deltaRight * locationX + deltaTranslationX;
        mAnchorDpDt[1] = deltaY * (1.0f - locationY) + deltaBottom * locationY + deltaTranslationY;
    }

    public final void fillStandard(@NotNull double[] data, @NotNull int[] toUse) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)toUse, (String)"toUse");
        float[] fArray = new float[]{this.mPosition, this.mX, this.mY, this.mWidth, this.mHeight, this.mPathRotate};
        float[] set = fArray;
        int c = 0;
        int n = toUse.length;
        for (int i = 0; i < n; ++i) {
            if (toUse[i] >= set.length) continue;
            data[c++] = set[toUse[i]];
        }
    }

    public final boolean hasCustomData(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.mCustomAttributes.containsKey(name);
    }

    public final int getCustomDataCount(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CustomVariable customVariable = this.mCustomAttributes.get(name);
        if (customVariable == null) {
            return 0;
        }
        CustomVariable a = customVariable;
        return a.numberOfInterpolatedValues();
    }

    public final int getCustomData(@Nullable String name, @NotNull double[] value, int offset) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int offset2 = offset;
        CustomVariable a = (CustomVariable)((Map)this.mCustomAttributes).get(name);
        if (a == null) {
            n = 0;
        } else if (a.numberOfInterpolatedValues() == 1) {
            value[offset2] = a.getValueToInterpolate();
            n = 1;
        } else {
            int n2 = a.numberOfInterpolatedValues();
            float[] f = new float[n2];
            a.getValuesToInterpolate(f);
            for (int i = 0; i < n2; ++i) {
                value[offset2++] = f[i];
            }
            n = n2;
        }
        return n;
    }

    public final void setBounds(float x, float y, float w, float h) {
        this.mX = x;
        this.mY = y;
        this.mWidth = w;
        this.mHeight = h;
    }

    @Override
    public int compareTo(@NotNull MotionPaths o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return ComparatorKt.compare(this.mPosition, o.mPosition);
    }

    public final void applyParameters(@NotNull MotionWidget c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        MotionPaths point = this;
        point.mKeyFrameEasing = Easing.Companion.getInterpolator(c.getMMotion().getMTransitionEasing());
        point.mPathMotionArc = c.getMMotion().getMPathMotionArc();
        point.mAnimateRelativeTo = c.getMMotion().getMAnimateRelativeTo();
        point.mPathRotate = c.getMMotion().getMPathRotate();
        point.mDrawPath = c.getMMotion().getMDrawPath();
        point.mAnimateCircleAngleTo = c.getMMotion().getMAnimateCircleAngleTo();
        point.mProgress = c.getMPropertySet().getMProgress();
        if (c.getMWidgetFrame() != null && c.getMWidgetFrame().getWidget() != null) {
            ConstraintWidget constraintWidget = c.getMWidgetFrame().getWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            point.mRelativeAngle = constraintWidget.getMCircleConstraintAngle();
        }
        Set<String> at = c.getCustomAttributeNames();
        for (String s : at) {
            CustomVariable attr = c.getCustomAttribute(s);
            if (attr == null || !attr.isContinuous()) continue;
            ((Map)this.mCustomAttributes).put(s, attr);
        }
    }

    public final void configureRelativeTo(@NotNull Motion toOrbit) {
        Intrinsics.checkNotNullParameter((Object)toOrbit, (String)"toOrbit");
        double[] p = toOrbit.getPos(this.mProgress);
    }

    static {
        String[] stringArray = new String[]{"position", "x", "y", "width", "height", "pathRotate"};
        sNames = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0002J8\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Landroidx/constraintlayout/core/motion/MotionPaths$Companion;", "", "()V", "CARTESIAN", "", "DEBUG", "", "OFF_HEIGHT", "OFF_PATH_ROTATE", "OFF_POSITION", "OFF_WIDTH", "OFF_X", "OFF_Y", "OLD_WAY", "PERPENDICULAR", "SCREEN", "TAG", "", "sNames", "", "getSNames", "()[Ljava/lang/String;", "setSNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "xRotate", "", "sin", "cos", "cx", "cy", "x", "y", "yRotate", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getSNames() {
            return sNames;
        }

        public final void setSNames(@NotNull String[] stringArray) {
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
            sNames = stringArray;
        }

        private final float xRotate(float sin, float cos, float cx, float cy, float x, float y) {
            float x2 = x;
            float y2 = y;
            return (x2 -= cx) * cos - (y2 -= cy) * sin + cx;
        }

        private final float yRotate(float sin, float cos, float cx, float cy, float x, float y) {
            float x2 = x;
            float y2 = y;
            return (x2 -= cx) * sin + (y2 -= cy) * cos + cy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

