/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionConstrainedPoint;
import androidx.constraintlayout.core.motion.MotionPaths;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.key.MotionKeyAttributes;
import androidx.constraintlayout.core.motion.key.MotionKeyCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyPosition;
import androidx.constraintlayout.core.motion.key.MotionKeyTimeCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyTrigger;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.DifferentialInterpolator;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.FloatRect;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.core.motion.utils.KeyFrameArray;
import androidx.constraintlayout.core.motion.utils.Rect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TimeCycleSplineSet;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.motion.utils.Utils;
import androidx.constraintlayout.core.motion.utils.VelocityMatrix;
import androidx.constraintlayout.core.motion.utils.ViewState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u001c\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 \u00e1\u00012\u00020\u0001:\u0002\u00e1\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020;J\u001e\u0010q\u001a\u00020o2\u0016\u0010r\u001a\u0012\u0012\u0004\u0012\u00020;0:j\b\u0012\u0004\u0012\u00020;`<J\u0016\u0010s\u001a\u00020o2\u0006\u0010t\u001a\u00020f2\u0006\u0010u\u001a\u00020\u0006J\u001a\u0010v\u001a\u00020\u00062\b\u0010w\u001a\u0004\u0018\u00010f2\b\u0010x\u001a\u0004\u0018\u00010\u000fJ$\u0010y\u001a\u00020\u00062\b\u0010z\u001a\u0004\u0018\u00010f2\b\u0010x\u001a\u0004\u0018\u00010\u000f2\b\u0010{\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010|\u001a\u00020o2\u0006\u0010}\u001a\u00020f2\u0006\u0010u\u001a\u00020\u0006J \u0010~\u001a\u00020o2\u0006\u0010\u007f\u001a\u00020#2\u0007\u0010\u0080\u0001\u001a\u00020f2\u0007\u0010\u0081\u0001\u001a\u00020\u0006J\u0018\u0010\u0082\u0001\u001a\u00020o2\u0007\u0010\u0080\u0001\u001a\u00020f2\u0006\u0010u\u001a\u00020\u0006J\u0010\u0010\u0083\u0001\u001a\u00020o2\u0007\u0010\u0084\u0001\u001a\u00020FJ\u001d\u0010\u0085\u0001\u001a\u00020#2\u0007\u0010\u0086\u0001\u001a\u00020#2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010fH\u0002J\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u0012J \u0010\u0089\u0001\u001a\u00020\u00062\u0007\u0010\u008a\u0001\u001a\u00020\u00122\u0006\u0010}\u001a\u00020f2\u0006\u0010u\u001a\u00020\u0006J!\u0010\u008b\u0001\u001a\u00020o2\u0007\u0010\u007f\u001a\u00030\u008c\u00012\u0006\u0010{\u001a\u00020f2\u0007\u0010\u008d\u0001\u001a\u00020fJ\u0007\u0010\u008e\u0001\u001a\u00020#J\u0007\u0010\u008f\u0001\u001a\u00020#J+\u0010\u0090\u0001\u001a\u00020o2\u0007\u0010\u0086\u0001\u001a\u00020#2\u0007\u0010\u0091\u0001\u001a\u00020#2\u0007\u0010\u0092\u0001\u001a\u00020#2\u0007\u0010\u0093\u0001\u001a\u00020fJ\u0007\u0010\u0094\u0001\u001a\u00020#J\u0007\u0010\u0095\u0001\u001a\u00020#J\u0007\u0010\u0096\u0001\u001a\u00020#J\u0007\u0010\u0097\u0001\u001a\u00020#J\u0014\u0010\u0098\u0001\u001a\u00020\u00062\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u009a\u0001\u001a\u00020/2\u0007\u0010\u009b\u0001\u001a\u00020\u0006J\u0019\u0010\u009c\u0001\u001a\u00020\u00062\u0007\u0010\u009d\u0001\u001a\u00020\u00062\u0007\u0010\u009e\u0001\u001a\u00020\u000fJ\"\u0010\u009f\u0001\u001a\u00020#2\u0007\u0010\u009d\u0001\u001a\u00020\u00062\u0007\u0010\u00a0\u0001\u001a\u00020#2\u0007\u0010\u00a1\u0001\u001a\u00020#J\u0018\u0010\u00a2\u0001\u001a\u00020\u00062\u0007\u0010\u009d\u0001\u001a\u00020\u000f2\u0006\u0010{\u001a\u00020fJ\u0007\u0010\u00a3\u0001\u001a\u00020#J\u0011\u0010\u00a4\u0001\u001a\u0002062\b\u0010\u0086\u0001\u001a\u00030\u008c\u0001J.\u0010\u00a5\u0001\u001a\u0005\u0018\u00010\u00a6\u00012\u0007\u0010\u00a7\u0001\u001a\u00020\u00062\u0007\u0010\u00a8\u0001\u001a\u00020\u00062\u0007\u0010\u00a0\u0001\u001a\u00020#2\u0007\u0010\u00a1\u0001\u001a\u00020#J=\u0010\u00a9\u0001\u001a\u00020o2\u0007\u0010\u0086\u0001\u001a\u00020#2\u0007\u0010\u00aa\u0001\u001a\u00020\u00062\u0007\u0010\u00ab\u0001\u001a\u00020\u00062\u0007\u0010\u0091\u0001\u001a\u00020#2\u0007\u0010\u0092\u0001\u001a\u00020#2\u0007\u0010\u0093\u0001\u001a\u00020fJ\t\u0010\u00ac\u0001\u001a\u00020#H\u0002J\u0007\u0010\u00ad\u0001\u001a\u00020#J\u0007\u0010\u00ae\u0001\u001a\u00020#J\u0007\u0010\u00af\u0001\u001a\u00020#J\u0007\u0010\u00b0\u0001\u001a\u00020#J\u0007\u0010\u00b1\u0001\u001a\u00020\u0006J\u0012\u0010\u00b2\u0001\u001a\u00020o2\u0007\u0010\u00b3\u0001\u001a\u00020/H\u0002J/\u0010\u00b4\u0001\u001a\u00020F2\u0007\u0010\u00b5\u0001\u001a\u00020\u00032\u0007\u0010\u00b6\u0001\u001a\u00020#2\b\u0010\u00b7\u0001\u001a\u00030\u00b8\u00012\n\u0010\u00b9\u0001\u001a\u0005\u0018\u00010\u00ba\u0001J\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u0012JO\u0010\u00bb\u0001\u001a\u00020o2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0007\u0010p\u001a\u00030\u00a6\u00012\u0007\u0010\u00a0\u0001\u001a\u00020#2\u0007\u0010\u00a1\u0001\u001a\u00020#2\u0011\u0010\u00bc\u0001\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010f\u00a2\u0006\u0003\u0010\u00bd\u0001J\u0012\u0010\u00be\u0001\u001a\u00020o2\u0007\u0010\u00bf\u0001\u001a\u00020/H\u0002J4\u0010\u00c0\u0001\u001a\u00020o2\u0007\u0010\u00c1\u0001\u001a\u00020\\2\u0007\u0010\u00c2\u0001\u001a\u00020\\2\u0007\u0010\u00c3\u0001\u001a\u00020\u00062\u0007\u0010\u00c4\u0001\u001a\u00020\u00062\u0007\u0010\u00c5\u0001\u001a\u00020\u0006J\u0010\u0010\u00c6\u0001\u001a\u00020o2\u0007\u0010\u00c7\u0001\u001a\u00020\u0003J\u0010\u0010\u00c8\u0001\u001a\u00020o2\u0007\u0010\u00c9\u0001\u001a\u00020\u0003J\u0010\u0010\u00ca\u0001\u001a\u00020o2\u0007\u0010\u00cb\u0001\u001a\u00020\u0012J\u0010\u0010\u00cc\u0001\u001a\u00020o2\u0007\u0010\u00cd\u0001\u001a\u00020\u0006J\u0010\u0010\u00ce\u0001\u001a\u00020o2\u0007\u0010\u00cf\u0001\u001a\u00020#J\u0010\u0010\u00d0\u0001\u001a\u00020o2\u0007\u0010\u00d1\u0001\u001a\u00020#J\u0010\u0010\u00d2\u0001\u001a\u00020o2\u0007\u0010\u00c9\u0001\u001a\u00020\u0003J7\u0010\u00d3\u0001\u001a\u00020o2\b\u0010\u00c1\u0001\u001a\u00030\u00d4\u00012\t\u0010\u00c7\u0001\u001a\u0004\u0018\u00010\u00032\u0007\u0010\u00c3\u0001\u001a\u00020\u00062\u0007\u0010\u00c5\u0001\u001a\u00020\u00062\u0007\u0010\u00c4\u0001\u001a\u00020\u0006J\u0010\u0010\u00d5\u0001\u001a\u00020o2\u0007\u0010\u00d6\u0001\u001a\u00020\u0006J\u001a\u0010\u00d7\u0001\u001a\u00020F2\u0007\u0010\u00d8\u0001\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020FH\u0016J\u001a\u0010\u00d7\u0001\u001a\u00020F2\u0007\u0010\u00d8\u0001\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0016J\u001a\u0010\u00d7\u0001\u001a\u00020F2\u0007\u0010\u00d8\u0001\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u00d7\u0001\u001a\u00020F2\u0007\u0010\u00d8\u0001\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0016J,\u0010\u00d9\u0001\u001a\u00020o2\u0007\u0010\u00da\u0001\u001a\u00020\u00062\u0007\u0010\u00db\u0001\u001a\u00020\u00062\u0007\u0010\u00dc\u0001\u001a\u00020#2\b\u0010\u00dd\u0001\u001a\u00030\u00b8\u0001J\t\u0010\u00de\u0001\u001a\u00020oH\u0002J\u0010\u0010\u00de\u0001\u001a\u00020o2\u0007\u0010\u00df\u0001\u001a\u00020\u0000J\t\u0010\u00e0\u0001\u001a\u00020\u0012H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R$\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R.\u0010\u0019\u001a\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aj\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001b\u0018\u0001`\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u000e\u0010+\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010,\u001a\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020-\u0018\u00010\u001aj\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020-\u0018\u0001`\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00102\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001f\"\u0004\b4\u0010!R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00109\u001a\u0012\u0012\u0004\u0012\u00020;0:j\b\u0012\u0004\u0012\u00020;`<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010=\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010?R\u000e\u0010@\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010A\u001a\u0012\u0012\u0004\u0012\u00020/0:j\b\u0012\u0004\u0012\u00020/`<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010B\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010%\"\u0004\bD\u0010'R\u000e\u0010E\u001a\u00020FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u0004\u0018\u00010IX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010L\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010RR\u001a\u0010S\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010%\"\u0004\bU\u0010'R\u001a\u0010V\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010%\"\u0004\bX\u0010'R\u000e\u0010Y\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010[\u001a\u00020\\X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R.\u0010a\u001a\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020b\u0018\u00010\u001aj\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020b\u0018\u0001`\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010d\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010e\u001a\u00020fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010h\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010\u0004R(\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bl\u0010j\"\u0004\bm\u0010\u0004\u00a8\u0006\u00e2\u0001"}, d2={"Landroidx/constraintlayout/core/motion/Motion;", "Landroidx/constraintlayout/core/motion/utils/TypedValues;", "view", "Landroidx/constraintlayout/core/motion/MotionWidget;", "(Landroidx/constraintlayout/core/motion/MotionWidget;)V", "value", "", "drawPath", "getDrawPath", "()I", "setDrawPath", "(I)V", "mArcSpline", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "mAttributeInterpolatorCount", "", "mAttributeNames", "", "", "[Ljava/lang/String;", "mAttributeTable", "getMAttributeTable", "()[Ljava/lang/String;", "setMAttributeTable", "([Ljava/lang/String;)V", "mAttributesMap", "Ljava/util/HashMap;", "Landroidx/constraintlayout/core/motion/utils/SplineSet;", "Lkotlin/collections/HashMap;", "mConstraintTag", "getMConstraintTag", "()Ljava/lang/String;", "setMConstraintTag", "(Ljava/lang/String;)V", "mCurrentCenterX", "", "getMCurrentCenterX", "()F", "setMCurrentCenterX", "(F)V", "mCurrentCenterY", "getMCurrentCenterY", "setMCurrentCenterY", "mCurveFitType", "mCycleMap", "Landroidx/constraintlayout/core/motion/utils/KeyCycleOscillator;", "mEndMotionPath", "Landroidx/constraintlayout/core/motion/MotionPaths;", "mEndPoint", "Landroidx/constraintlayout/core/motion/MotionConstrainedPoint;", "mId", "getMId", "setMId", "mInterpolateData", "", "mInterpolateVariables", "mInterpolateVelocity", "mKeyList", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/motion/key/MotionKey;", "Lkotlin/collections/ArrayList;", "mKeyTriggers", "Landroidx/constraintlayout/core/motion/key/MotionKeyTrigger;", "[Landroidx/constraintlayout/core/motion/key/MotionKeyTrigger;", "mMaxDimension", "mMotionPaths", "mMotionStagger", "getMMotionStagger", "setMMotionStagger", "mNoMovement", "", "mPathMotionArc", "mQuantizeMotionInterpolator", "Landroidx/constraintlayout/core/motion/utils/DifferentialInterpolator;", "mQuantizeMotionPhase", "mQuantizeMotionSteps", "mRelativeMotion", "getMRelativeMotion", "()Landroidx/constraintlayout/core/motion/Motion;", "setMRelativeMotion", "(Landroidx/constraintlayout/core/motion/Motion;)V", "mSpline", "[Landroidx/constraintlayout/core/motion/utils/CurveFit;", "mStaggerOffset", "getMStaggerOffset", "setMStaggerOffset", "mStaggerScale", "getMStaggerScale", "setMStaggerScale", "mStartMotionPath", "mStartPoint", "mTempRect", "Landroidx/constraintlayout/core/motion/utils/Rect;", "getMTempRect", "()Landroidx/constraintlayout/core/motion/utils/Rect;", "setMTempRect", "(Landroidx/constraintlayout/core/motion/utils/Rect;)V", "mTimeCycleAttributesMap", "Landroidx/constraintlayout/core/motion/utils/TimeCycleSplineSet;", "mTransformPivotTarget", "mTransformPivotView", "mValuesBuff", "", "mVelocity", "mView", "getMView", "()Landroidx/constraintlayout/core/motion/MotionWidget;", "setMView", "getView", "setView", "addKey", "", "key", "addKeys", "list", "buildBounds", "bounds", "pointCount", "buildKeyBounds", "keyBounds", "mode", "buildKeyFrames", "keyFrames", "pos", "buildPath", "points", "buildRect", "p", "path", "offset", "buildRectangles", "endTrigger", "start", "getAdjustedPosition", "position", "velocity", "getAnimateRelativeTo", "getAttributeValues", "attributeType", "getCenter", "", "vel", "getCenterX", "getCenterY", "getDpDt", "locationX", "locationY", "mAnchorDpDt", "getFinalHeight", "getFinalWidth", "getFinalX", "getFinalY", "getId", "name", "getKeyFrame", "i", "getKeyFrameInfo", "type", "info", "getKeyFrameParameter", "x", "y", "getKeyFramePositions", "getMotionStagger", "getPos", "getPositionKeyframe", "Landroidx/constraintlayout/core/motion/key/MotionKeyPosition;", "layoutWidth", "layoutHeight", "getPostLayoutDvDp", "width", "height", "getPreCycleDistance", "getStartHeight", "getStartWidth", "getStartX", "getStartY", "getTransformPivotTarget", "insertKey", "point", "interpolate", "child", "globalPosition", "time", "", "keyCache", "Landroidx/constraintlayout/core/motion/utils/KeyCache;", "positionKeyframe", "attribute", "(Landroidx/constraintlayout/core/motion/MotionWidget;Landroidx/constraintlayout/core/motion/key/MotionKeyPosition;FF[Ljava/lang/String;[F)V", "readView", "motionPaths", "rotate", "rect", "out", "rotation", "preHeight", "preWidth", "setBothStates", "v", "setEnd", "mw", "setIdString", "stringId", "setPathMotionArc", "arc", "setStaggerOffset", "staggerOffset", "setStaggerScale", "staggerScale", "setStart", "setStartState", "Landroidx/constraintlayout/core/motion/utils/ViewState;", "setTransformPivotTarget", "transformPivotTarget", "setValue", "id", "setup", "parentWidth", "parentHeight", "transitionDuration", "currentTime", "setupRelative", "motionController", "toString", "Companion", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMotion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Motion.kt\nandroidx/constraintlayout/core/motion/Motion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1798:1\n37#2,2:1799\n37#2,2:1810\n37#2,2:1821\n37#2,2:1823\n37#2,2:1825\n731#3,9:1801\n731#3,9:1812\n*S KotlinDebug\n*F\n+ 1 Motion.kt\nandroidx/constraintlayout/core/motion/Motion\n*L\n707#1:1799,2\n717#1:1810,2\n770#1:1821,2\n828#1:1823,2\n908#1:1825,2\n716#1:1801,9\n769#1:1812,9\n*E\n"})
public final class Motion
implements TypedValues {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Rect mTempRect;
    @Nullable
    private MotionWidget mView;
    @Nullable
    private String mId;
    @Nullable
    private String mConstraintTag;
    private int mCurveFitType;
    @NotNull
    private final MotionPaths mStartMotionPath;
    @NotNull
    private final MotionPaths mEndMotionPath;
    @NotNull
    private final MotionConstrainedPoint mStartPoint;
    @NotNull
    private final MotionConstrainedPoint mEndPoint;
    @Nullable
    private CurveFit[] mSpline;
    @Nullable
    private CurveFit mArcSpline;
    private float mMotionStagger;
    private float mStaggerOffset;
    private float mStaggerScale;
    private float mCurrentCenterX;
    private float mCurrentCenterY;
    @Nullable
    private int[] mInterpolateVariables;
    @Nullable
    private double[] mInterpolateData;
    @Nullable
    private double[] mInterpolateVelocity;
    @Nullable
    private String[] mAttributeNames;
    @Nullable
    private int[] mAttributeInterpolatorCount;
    private final int mMaxDimension;
    @NotNull
    private final float[] mValuesBuff;
    @NotNull
    private final ArrayList<MotionPaths> mMotionPaths;
    @NotNull
    private final float[] mVelocity;
    @NotNull
    private final ArrayList<MotionKey> mKeyList;
    @Nullable
    private HashMap<String, TimeCycleSplineSet> mTimeCycleAttributesMap;
    @Nullable
    private HashMap<String, SplineSet> mAttributesMap;
    @Nullable
    private HashMap<String, KeyCycleOscillator> mCycleMap;
    @Nullable
    private MotionKeyTrigger[] mKeyTriggers;
    private int mPathMotionArc;
    private int mTransformPivotTarget;
    @Nullable
    private MotionWidget mTransformPivotView;
    private int mQuantizeMotionSteps;
    private float mQuantizeMotionPhase;
    @Nullable
    private DifferentialInterpolator mQuantizeMotionInterpolator;
    private boolean mNoMovement;
    @Nullable
    private Motion mRelativeMotion;
    @Nullable
    private String[] mAttributeTable;
    public static final int $stable = 8;
    public static final int PATH_PERCENT = 0;
    public static final int PATH_PERPENDICULAR = 1;
    public static final int HORIZONTAL_PATH_X = 2;
    public static final int HORIZONTAL_PATH_Y = 3;
    public static final int VERTICAL_PATH_X = 4;
    public static final int VERTICAL_PATH_Y = 5;
    public static final int DRAW_PATH_NONE = 0;
    public static final int DRAW_PATH_BASIC = 1;
    public static final int DRAW_PATH_RELATIVE = 2;
    public static final int DRAW_PATH_CARTESIAN = 3;
    public static final int DRAW_PATH_AS_CONFIGURED = 4;
    public static final int DRAW_PATH_RECTANGLE = 5;
    public static final int DRAW_PATH_SCREEN = 6;
    public static final int ROTATION_RIGHT = 1;
    public static final int ROTATION_LEFT = 2;
    @NotNull
    private static final String TAG = "MotionController";
    private static final boolean DEBUG = false;
    private static final boolean FAVOR_FIXED_SIZE_VIEWS = false;
    public static final int EASE_IN_OUT = 0;
    public static final int EASE_IN = 1;
    public static final int EASE_OUT = 2;
    public static final int LINEAR = 3;
    public static final int BOUNCE = 4;
    public static final int OVERSHOOT = 5;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    private static final int INTERPOLATOR_UNDEFINED = -3;

    @NotNull
    public final Rect getMTempRect() {
        return this.mTempRect;
    }

    public final void setMTempRect(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"<set-?>");
        this.mTempRect = rect;
    }

    @Nullable
    public final MotionWidget getMView() {
        return this.mView;
    }

    public final void setMView(@Nullable MotionWidget motionWidget) {
        this.mView = motionWidget;
    }

    @Nullable
    public final String getMId() {
        return this.mId;
    }

    public final void setMId(@Nullable String string) {
        this.mId = string;
    }

    @Nullable
    public final String getMConstraintTag() {
        return this.mConstraintTag;
    }

    public final void setMConstraintTag(@Nullable String string) {
        this.mConstraintTag = string;
    }

    public final float getMMotionStagger() {
        return this.mMotionStagger;
    }

    public final void setMMotionStagger(float f) {
        this.mMotionStagger = f;
    }

    public final float getMStaggerOffset() {
        return this.mStaggerOffset;
    }

    public final void setMStaggerOffset(float f) {
        this.mStaggerOffset = f;
    }

    public final float getMStaggerScale() {
        return this.mStaggerScale;
    }

    public final void setMStaggerScale(float f) {
        this.mStaggerScale = f;
    }

    public final float getMCurrentCenterX() {
        return this.mCurrentCenterX;
    }

    public final void setMCurrentCenterX(float f) {
        this.mCurrentCenterX = f;
    }

    public final float getMCurrentCenterY() {
        return this.mCurrentCenterY;
    }

    public final void setMCurrentCenterY(float f) {
        this.mCurrentCenterY = f;
    }

    @Nullable
    public final Motion getMRelativeMotion() {
        return this.mRelativeMotion;
    }

    public final void setMRelativeMotion(@Nullable Motion motion) {
        this.mRelativeMotion = motion;
    }

    public final int getTransformPivotTarget() {
        return this.mTransformPivotTarget;
    }

    public final void setTransformPivotTarget(int transformPivotTarget) {
        this.mTransformPivotTarget = transformPivotTarget;
        this.mTransformPivotView = null;
    }

    @NotNull
    public final MotionPaths getKeyFrame(int i) {
        MotionPaths motionPaths = this.mMotionPaths.get(i);
        Intrinsics.checkNotNullExpressionValue((Object)motionPaths, (String)"get(...)");
        return motionPaths;
    }

    public Motion(@NotNull MotionWidget view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.mTempRect = new Rect();
        this.mStartMotionPath = new MotionPaths();
        this.mEndMotionPath = new MotionPaths();
        this.mStartPoint = new MotionConstrainedPoint();
        this.mEndPoint = new MotionConstrainedPoint();
        this.mMotionStagger = Float.NaN;
        this.mStaggerScale = 1.0f;
        this.mMaxDimension = 4;
        this.mValuesBuff = new float[this.mMaxDimension];
        this.mMotionPaths = new ArrayList();
        this.mVelocity = new float[1];
        this.mKeyList = new ArrayList();
        this.mPathMotionArc = -1;
        this.mTransformPivotTarget = -1;
        this.mQuantizeMotionSteps = -1;
        this.mQuantizeMotionPhase = Float.NaN;
        this.setView(view);
    }

    public final float getStartX() {
        return this.mStartMotionPath.getMX();
    }

    public final float getStartY() {
        return this.mStartMotionPath.getMY();
    }

    public final float getFinalX() {
        return this.mEndMotionPath.getMX();
    }

    public final float getFinalY() {
        return this.mEndMotionPath.getMY();
    }

    public final float getStartWidth() {
        return this.mStartMotionPath.getMWidth();
    }

    public final float getStartHeight() {
        return this.mStartMotionPath.getMHeight();
    }

    public final float getFinalWidth() {
        return this.mEndMotionPath.getMWidth();
    }

    public final float getFinalHeight() {
        return this.mEndMotionPath.getMHeight();
    }

    @Nullable
    public final String getAnimateRelativeTo() {
        return this.mStartMotionPath.getMAnimateRelativeTo();
    }

    public final void setupRelative(@NotNull Motion motionController) {
        Intrinsics.checkNotNullParameter((Object)motionController, (String)"motionController");
        this.mRelativeMotion = motionController;
    }

    private final void setupRelative() {
        if (this.mRelativeMotion == null) {
            return;
        }
        Motion motion = this.mRelativeMotion;
        Intrinsics.checkNotNull((Object)motion);
        Motion motion2 = this.mRelativeMotion;
        Intrinsics.checkNotNull((Object)motion2);
        this.mStartMotionPath.setupRelative(motion, motion2.mStartMotionPath);
        Motion motion3 = this.mRelativeMotion;
        Intrinsics.checkNotNull((Object)motion3);
        Motion motion4 = this.mRelativeMotion;
        Intrinsics.checkNotNull((Object)motion4);
        this.mEndMotionPath.setupRelative(motion3, motion4.mEndMotionPath);
    }

    public final float getCenterX() {
        return this.mCurrentCenterX;
    }

    public final float getCenterY() {
        return this.mCurrentCenterY;
    }

    public final void getCenter(double p, @NotNull float[] pos, @NotNull float[] vel) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        double[] position = new double[4];
        double[] velocity = new double[4];
        Intrinsics.checkNotNull((Object)this.mSpline);
        CurveFit curveFit = this.mSpline[0];
        Intrinsics.checkNotNull((Object)curveFit);
        curveFit.getPos(p, position);
        Intrinsics.checkNotNull((Object)this.mSpline);
        CurveFit curveFit2 = this.mSpline[0];
        Intrinsics.checkNotNull((Object)curveFit2);
        curveFit2.getSlope(p, velocity);
        ArraysKt.fill$default((float[])vel, (float)0.0f, (int)0, (int)0, (int)6, null);
        Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
        this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, position, pos, velocity, vel);
    }

    public final void buildPath(@NotNull float[] points, int pointCount) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        float mils = 1.0f / (float)(pointCount - 1);
        HashMap<String, SplineSet> hashMap = this.mAttributesMap;
        SplineSet trans_x = hashMap != null ? hashMap.get("translationX") : null;
        HashMap<String, SplineSet> hashMap2 = this.mAttributesMap;
        SplineSet trans_y = hashMap2 != null ? hashMap2.get("translationY") : null;
        HashMap<String, KeyCycleOscillator> hashMap3 = this.mCycleMap;
        KeyCycleOscillator osc_x = hashMap3 != null ? hashMap3.get("translationX") : null;
        HashMap<String, KeyCycleOscillator> hashMap4 = this.mCycleMap;
        KeyCycleOscillator osc_y = hashMap4 != null ? hashMap4.get("translationY") : null;
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            if (!(this.mStaggerScale == 1.0f)) {
                if (position < this.mStaggerOffset) {
                    position = 0.0f;
                }
                if (position > this.mStaggerOffset && (double)position < 1.0) {
                    position -= this.mStaggerOffset;
                    position *= this.mStaggerScale;
                    position = (float)Math.min((double)position, 1.0);
                }
            }
            double p = position;
            Easing easing = this.mStartMotionPath.getMKeyFrameEasing();
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.getMKeyFrameEasing() == null) continue;
                if (frame.getMTime() < position) {
                    easing = frame.getMKeyFrameEasing();
                    start = frame.getMTime();
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.getMTime();
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit.getPos(p, this.mInterpolateData);
            if (this.mArcSpline != null) {
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                if (this.mInterpolateData.length > 0) {
                    CurveFit curveFit2 = this.mArcSpline;
                    Intrinsics.checkNotNull((Object)curveFit2);
                    Intrinsics.checkNotNull((Object)this.mInterpolateData);
                    curveFit2.getPos(p, this.mInterpolateData);
                }
            }
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, this.mInterpolateData, points, i * 2);
            if (osc_x != null) {
                int n = i * 2;
                points[n] = points[n] + osc_x.get(position);
            } else if (trans_x != null) {
                int n = i * 2;
                points[n] = points[n] + trans_x.get(position);
            }
            if (osc_y != null) {
                int n = i * 2 + 1;
                points[n] = points[n] + osc_y.get(position);
                continue;
            }
            if (trans_y == null) continue;
            int n = i * 2 + 1;
            points[n] = points[n] + trans_y.get(position);
        }
    }

    @NotNull
    public final double[] getPos(double position) {
        Intrinsics.checkNotNull((Object)this.mSpline);
        CurveFit curveFit = this.mSpline[0];
        Intrinsics.checkNotNull((Object)curveFit);
        Intrinsics.checkNotNull((Object)this.mInterpolateData);
        curveFit.getPos(position, this.mInterpolateData);
        if (this.mArcSpline != null) {
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            if (this.mInterpolateData.length > 0) {
                CurveFit curveFit2 = this.mArcSpline;
                Intrinsics.checkNotNull((Object)curveFit2);
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                curveFit2.getPos(position, this.mInterpolateData);
            }
        }
        Intrinsics.checkNotNull((Object)this.mInterpolateData);
        return this.mInterpolateData;
    }

    public final void buildBounds(@NotNull float[] bounds, int pointCount) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        float mils = 1.0f / (float)(pointCount - 1);
        HashMap<String, SplineSet> hashMap = this.mAttributesMap;
        Intrinsics.checkNotNull(hashMap);
        SplineSet trans_x = hashMap.get("translationX");
        HashMap<String, SplineSet> hashMap2 = this.mAttributesMap;
        Intrinsics.checkNotNull(hashMap2);
        SplineSet trans_y = hashMap2.get("translationY");
        HashMap<String, KeyCycleOscillator> hashMap3 = this.mCycleMap;
        Intrinsics.checkNotNull(hashMap3);
        KeyCycleOscillator osc_x = hashMap3.get("translationX");
        HashMap<String, KeyCycleOscillator> hashMap4 = this.mCycleMap;
        Intrinsics.checkNotNull(hashMap4);
        KeyCycleOscillator osc_y = hashMap4.get("translationY");
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            if (!(this.mStaggerScale == 1.0f)) {
                if (position < this.mStaggerOffset) {
                    position = 0.0f;
                }
                if (position > this.mStaggerOffset && (double)position < 1.0) {
                    position -= this.mStaggerOffset;
                    position *= this.mStaggerScale;
                    position = (float)Math.min((double)position, 1.0);
                }
            }
            double p = position;
            Easing easing = this.mStartMotionPath.getMKeyFrameEasing();
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.getMKeyFrameEasing() == null) continue;
                if (frame.getMTime() < position) {
                    easing = frame.getMKeyFrameEasing();
                    start = frame.getMTime();
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.getMTime();
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit.getPos(p, this.mInterpolateData);
            if (this.mArcSpline != null) {
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                if (this.mInterpolateData.length > 0) {
                    CurveFit curveFit2 = this.mArcSpline;
                    Intrinsics.checkNotNull((Object)curveFit2);
                    Intrinsics.checkNotNull((Object)this.mInterpolateData);
                    curveFit2.getPos(p, this.mInterpolateData);
                }
            }
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, bounds, i * 2);
        }
    }

    private final float getPreCycleDistance() {
        int pointCount = 100;
        float[] points = new float[2];
        float sum = 0.0f;
        float mils = 1.0f / (float)(pointCount - 1);
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            double p = position;
            Easing easing = this.mStartMotionPath.getMKeyFrameEasing();
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.getMKeyFrameEasing() == null) continue;
                if (frame.getMTime() < position) {
                    easing = frame.getMKeyFrameEasing();
                    start = frame.getMTime();
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.getMTime();
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit.getPos(p, this.mInterpolateData);
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, this.mInterpolateData, points, 0);
            if (i > 0) {
                sum += (float)Math.hypot(y - (double)points[1], x - (double)points[0]);
            }
            x = points[0];
            y = points[1];
        }
        return sum;
    }

    @Nullable
    public final MotionKeyPosition getPositionKeyframe(int layoutWidth, int layoutHeight, float x, float y) {
        FloatRect start = new FloatRect();
        start.setLeft(this.mStartMotionPath.getMX());
        start.setTop(this.mStartMotionPath.getMY());
        start.setRight(start.getLeft() + this.mStartMotionPath.getMWidth());
        start.setBottom(start.getTop() + this.mStartMotionPath.getMHeight());
        FloatRect end = new FloatRect();
        end.setLeft(this.mEndMotionPath.getMX());
        end.setTop(this.mEndMotionPath.getMY());
        end.setRight(end.getLeft() + this.mEndMotionPath.getMWidth());
        end.setBottom(end.getTop() + this.mEndMotionPath.getMHeight());
        for (MotionKey key : this.mKeyList) {
            if (!(key instanceof MotionKeyPosition) || !((MotionKeyPosition)key).intersects(layoutWidth, layoutHeight, start, end, x, y)) continue;
            return (MotionKeyPosition)key;
        }
        return null;
    }

    public final int buildKeyFrames(@Nullable float[] keyFrames, @Nullable int[] mode, @Nullable int[] pos) {
        if (keyFrames != null) {
            int count = 0;
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            double[] time = curveFit.getTimePoints();
            if (mode != null) {
                for (MotionPaths keyFrame : this.mMotionPaths) {
                    mode[count++] = keyFrame.getMMode();
                }
                count = 0;
            }
            if (pos != null) {
                for (MotionPaths keyFrame : this.mMotionPaths) {
                    pos[count++] = (int)((float)100 * keyFrame.getMPosition());
                }
                count = 0;
            }
            int n = time.length;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.mSpline);
                CurveFit curveFit2 = this.mSpline[0];
                Intrinsics.checkNotNull((Object)curveFit2);
                double d = time[i];
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                curveFit2.getPos(d, this.mInterpolateData);
                double d2 = time[i];
                Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                this.mStartMotionPath.getCenter(d2, this.mInterpolateVariables, this.mInterpolateData, keyFrames, count);
                count += 2;
            }
            return count / 2;
        }
        return 0;
    }

    public final int buildKeyBounds(@Nullable float[] keyBounds, @Nullable int[] mode) {
        if (keyBounds != null) {
            int count = 0;
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            double[] time = curveFit.getTimePoints();
            if (mode != null) {
                for (MotionPaths keyFrame : this.mMotionPaths) {
                    mode[count++] = keyFrame.getMMode();
                }
                count = 0;
            }
            int n = time.length;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.mSpline);
                CurveFit curveFit2 = this.mSpline[0];
                Intrinsics.checkNotNull((Object)curveFit2);
                double d = time[i];
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                curveFit2.getPos(d, this.mInterpolateData);
                Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, keyBounds, count);
                count += 2;
            }
            return count / 2;
        }
        return 0;
    }

    @Nullable
    public final String[] getMAttributeTable() {
        return this.mAttributeTable;
    }

    public final void setMAttributeTable(@Nullable String[] stringArray) {
        this.mAttributeTable = stringArray;
    }

    public final int getAttributeValues(@NotNull String attributeType, @NotNull float[] points, int pointCount) {
        Intrinsics.checkNotNullParameter((Object)attributeType, (String)"attributeType");
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        float mils = 1.0f / (float)(pointCount - 1);
        HashMap<String, SplineSet> hashMap = this.mAttributesMap;
        Intrinsics.checkNotNull(hashMap);
        SplineSet splineSet = hashMap.get(attributeType);
        if (splineSet == null) {
            return -1;
        }
        SplineSet spline = splineSet;
        int n = points.length;
        for (int j = 0; j < n; ++j) {
            points[j] = spline.get(j / (points.length - 1));
        }
        return points.length;
    }

    public final void buildRect(float p, @NotNull float[] path, int offset) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        float p2 = p;
        p2 = this.getAdjustedPosition(p2, null);
        Intrinsics.checkNotNull((Object)this.mSpline);
        CurveFit curveFit = this.mSpline[0];
        Intrinsics.checkNotNull((Object)curveFit);
        double d = p2;
        Intrinsics.checkNotNull((Object)this.mInterpolateData);
        curveFit.getPos(d, this.mInterpolateData);
        Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
        Intrinsics.checkNotNull((Object)this.mInterpolateData);
        this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, path, offset);
    }

    public final void buildRectangles(@NotNull float[] path, int pointCount) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        float mils = 1.0f / (float)(pointCount - 1);
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            position = this.getAdjustedPosition(position, null);
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            double d = position;
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit.getPos(d, this.mInterpolateData);
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, path, i * 8);
        }
    }

    public final float getKeyFrameParameter(int type, float x, float y) {
        float dx = this.mEndMotionPath.getMX() - this.mStartMotionPath.getMX();
        float dy = this.mEndMotionPath.getMY() - this.mStartMotionPath.getMY();
        float startCenterX = this.mStartMotionPath.getMX() + this.mStartMotionPath.getMWidth() / (float)2;
        float startCenterY = this.mStartMotionPath.getMY() + this.mStartMotionPath.getMHeight() / (float)2;
        float hypotenuse = (float)Math.hypot(dx, dy);
        if ((double)hypotenuse < 1.0E-7) {
            return Float.NaN;
        }
        float vx = x - startCenterX;
        float vy = y - startCenterY;
        float distFromStart = (float)Math.hypot(vx, vy);
        if (distFromStart == 0.0f) {
            return 0.0f;
        }
        float pathDistance = vx * dx + vy * dy;
        switch (type) {
            case 0: {
                return pathDistance / hypotenuse;
            }
            case 1: {
                return (float)Math.sqrt(hypotenuse * hypotenuse - pathDistance * pathDistance);
            }
            case 2: {
                return vx / dx;
            }
            case 3: {
                return vy / dx;
            }
            case 4: {
                return vx / dy;
            }
            case 5: {
                return vy / dy;
            }
        }
        return 0.0f;
    }

    private final void insertKey(MotionPaths point) {
        int pos;
        MotionPaths redundant = null;
        for (MotionPaths p : this.mMotionPaths) {
            if (!(point.getMPosition() == p.getMPosition())) continue;
            redundant = p;
        }
        if (redundant != null) {
            this.mMotionPaths.remove(redundant);
        }
        if ((pos = CollectionsKt.binarySearch$default((List)this.mMotionPaths, (Comparable)point, (int)0, (int)0, (int)6, null)) == 0) {
            Utils.INSTANCE.loge(TAG, " KeyPath position \"" + point.getMPosition() + "\" outside of range");
        }
        this.mMotionPaths.add(-pos - 1, point);
    }

    public final void addKeys(@NotNull ArrayList<MotionKey> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.mKeyList.addAll((Collection<MotionKey>)list);
    }

    public final void addKey(@NotNull MotionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.mKeyList.add(key);
    }

    public final void setPathMotionArc(int arc) {
        this.mPathMotionArc = arc;
    }

    public final void setup(int parentWidth, int parentHeight, float transitionDuration, long currentTime) {
        int i;
        int i2;
        int n;
        Object object;
        CustomVariable customAttribute2;
        Object customAttributeName;
        Iterator<MotionKey> thisCollection$iv;
        Iterator<MotionKey> $this$toTypedArray$iv;
        String it;
        Collection $this$dropLastWhile$iv;
        KeyFrameArray.CustomVar attrList;
        HashSet springAttributes = new HashSet();
        HashSet<String> timeCycleAttributes = new HashSet<String>();
        HashSet<String> splineAttributes = new HashSet<String>();
        HashSet<String> cycleAttributes = new HashSet<String>();
        HashMap<String, Integer> interpolation = new HashMap<String, Integer>();
        ArrayList<MotionKey> triggerList = null;
        this.setupRelative();
        if (this.mPathMotionArc != -1 && this.mStartMotionPath.getMPathMotionArc() == -1) {
            this.mStartMotionPath.setMPathMotionArc(this.mPathMotionArc);
        }
        this.mStartPoint.different(this.mEndPoint, splineAttributes);
        if (this.mKeyList != null) {
            for (MotionKey key : this.mKeyList) {
                Unit unit;
                if (key instanceof MotionKeyPosition) {
                    MotionKey keyPath = key;
                    this.insertKey(new MotionPaths(parentWidth, parentHeight, (MotionKeyPosition)keyPath, this.mStartMotionPath, this.mEndMotionPath));
                    if (((MotionKeyPosition)keyPath).getMCurveFit() == -1) continue;
                    this.mCurveFitType = ((MotionKeyPosition)keyPath).getMCurveFit();
                    continue;
                }
                MotionKeyCycle motionKeyCycle = key instanceof MotionKeyCycle ? (MotionKeyCycle)key : null;
                if (motionKeyCycle != null) {
                    motionKeyCycle.getAttributeNames(cycleAttributes);
                    unit = Unit.INSTANCE;
                    continue;
                }
                MotionKeyTimeCycle motionKeyTimeCycle = key instanceof MotionKeyTimeCycle ? (MotionKeyTimeCycle)key : null;
                if (motionKeyTimeCycle != null) {
                    motionKeyTimeCycle.getAttributeNames(timeCycleAttributes);
                    unit = Unit.INSTANCE;
                    continue;
                }
                if (key instanceof MotionKeyTrigger) {
                    if (triggerList == null) {
                        triggerList = new ArrayList<MotionKey>();
                    }
                    triggerList.add(key);
                    unit = Unit.INSTANCE;
                    continue;
                }
                key.setInterpolation(interpolation);
                key.getAttributeNames(splineAttributes);
                unit = Unit.INSTANCE;
            }
        }
        if (triggerList != null) {
            Iterator<Object> $this$toTypedArray$iv2 = triggerList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            this.mKeyTriggers = thisCollection$iv2.toArray(new MotionKeyTrigger[0]);
        }
        if (!splineAttributes.isEmpty()) {
            this.mAttributesMap = new HashMap();
            for (String attribute : splineAttributes) {
                SplineSet splineSets;
                SplineSet splineSet;
                Intrinsics.checkNotNull((Object)attribute);
                if (StringsKt.startsWith$default((String)attribute, (String)"CUSTOM,", (boolean)false, (int)2, null)) {
                    List list;
                    attrList = new KeyFrameArray.CustomVar();
                    Object object2 = attribute;
                    Regex regex = new Regex(",");
                    int n2 = 0;
                    object2 = regex.split((CharSequence)object2, n2);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    customAttributeName = thisCollection$iv.toArray(new String[0])[1];
                    $this$toTypedArray$iv = this.mKeyList.iterator();
                    while ($this$toTypedArray$iv.hasNext()) {
                        MotionKey key = $this$toTypedArray$iv.next();
                        if (key.getMCustom() == null) continue;
                        HashMap<String, CustomVariable> hashMap = key.getMCustom();
                        Intrinsics.checkNotNull(hashMap);
                        customAttribute2 = hashMap.get(customAttributeName);
                        if (customAttribute2 == null) continue;
                        attrList.append(key.getMFramePosition(), customAttribute2);
                    }
                    splineSet = SplineSet.Companion.makeCustomSplineSet(attribute, attrList);
                } else {
                    splineSet = splineSets = SplineSet.Companion.makeSpline(attribute, currentTime);
                }
                if (splineSets == null) continue;
                splineSets.setType(attribute);
                HashMap<String, SplineSet> hashMap = this.mAttributesMap;
                Intrinsics.checkNotNull(hashMap);
                ((Map)hashMap).put(attribute, splineSets);
            }
            if (this.mKeyList != null) {
                for (MotionKey key : this.mKeyList) {
                    Unit unit;
                    MotionKeyAttributes motionKeyAttributes = key instanceof MotionKeyAttributes ? (MotionKeyAttributes)key : null;
                    if (motionKeyAttributes != null) {
                        HashMap<String, SplineSet> hashMap = this.mAttributesMap;
                        Intrinsics.checkNotNull(hashMap);
                        motionKeyAttributes.addValues(hashMap);
                        unit = Unit.INSTANCE;
                        continue;
                    }
                    unit = null;
                }
            }
            HashMap<String, SplineSet> hashMap = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap);
            this.mStartPoint.addValues(hashMap, 0);
            HashMap<String, SplineSet> hashMap2 = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap2);
            this.mEndPoint.addValues(hashMap2, 100);
            HashMap<String, SplineSet> hashMap3 = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap3);
            for (String spline : hashMap3.keySet()) {
                Unit unit;
                SplineSet splineSet;
                Integer boxedCurve;
                int curve = 0;
                if (interpolation.containsKey(spline) && (boxedCurve = interpolation.get(spline)) != null) {
                    curve = boxedCurve;
                }
                HashMap<String, SplineSet> hashMap4 = this.mAttributesMap;
                Intrinsics.checkNotNull(hashMap4);
                SplineSet splineSet2 = splineSet = hashMap4.get(spline);
                if (splineSet2 != null) {
                    splineSet2.setup(curve);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
        }
        if (!timeCycleAttributes.isEmpty()) {
            if (this.mTimeCycleAttributesMap == null) {
                this.mTimeCycleAttributesMap = new HashMap();
            }
            for (String attribute : timeCycleAttributes) {
                SplineSet splineSet;
                HashMap<String, TimeCycleSplineSet> hashMap = this.mTimeCycleAttributesMap;
                Intrinsics.checkNotNull(hashMap);
                if (hashMap.containsKey(attribute)) continue;
                SplineSet splineSets = null;
                Intrinsics.checkNotNull((Object)attribute);
                if (StringsKt.startsWith$default((String)attribute, (String)"CUSTOM,", (boolean)false, (int)2, null)) {
                    List list;
                    attrList = new KeyFrameArray.CustomVar();
                    $this$toTypedArray$iv = attribute;
                    Regex key = new Regex(",");
                    int customAttribute2 = 0;
                    $this$toTypedArray$iv = key.split((CharSequence)((Object)$this$toTypedArray$iv), customAttribute2);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    customAttributeName = thisCollection$iv.toArray((String[])new String[0])[1];
                    for (MotionKey key2 : this.mKeyList) {
                        if (key2.getMCustom() == null) continue;
                        HashMap<String, CustomVariable> hashMap5 = key2.getMCustom();
                        Intrinsics.checkNotNull(hashMap5);
                        customAttribute2 = hashMap5.get(customAttributeName);
                        if (customAttribute2 == null) continue;
                        attrList.append(key2.getMFramePosition(), customAttribute2);
                    }
                    splineSet = SplineSet.Companion.makeCustomSplineSet(attribute, attrList);
                } else {
                    splineSet = splineSets = SplineSet.Companion.makeSpline(attribute, currentTime);
                }
                if (splineSets == null) continue;
                splineSets.setType(attribute);
            }
            if (this.mKeyList != null) {
                for (MotionKey key : this.mKeyList) {
                    if (!(key instanceof MotionKeyTimeCycle)) continue;
                    MotionKeyTimeCycle motionKeyTimeCycle = (MotionKeyTimeCycle)key;
                    HashMap<String, TimeCycleSplineSet> hashMap = this.mTimeCycleAttributesMap;
                    Intrinsics.checkNotNull(hashMap);
                    motionKeyTimeCycle.addTimeValues(hashMap);
                }
            }
            HashMap<String, TimeCycleSplineSet> hashMap = this.mTimeCycleAttributesMap;
            Intrinsics.checkNotNull(hashMap);
            for (String spline : hashMap.keySet()) {
                int curve = 0;
                if (interpolation.containsKey(spline)) {
                    Integer n3 = interpolation.get(spline);
                    Intrinsics.checkNotNull((Object)n3);
                    curve = ((Number)n3).intValue();
                }
                HashMap<String, TimeCycleSplineSet> hashMap6 = this.mTimeCycleAttributesMap;
                Intrinsics.checkNotNull(hashMap6);
                TimeCycleSplineSet timeCycleSplineSet = hashMap6.get(spline);
                Intrinsics.checkNotNull((Object)timeCycleSplineSet);
                timeCycleSplineSet.setup(curve);
            }
        }
        MotionPaths[] points = new MotionPaths[2 + this.mMotionPaths.size()];
        int count = 1;
        points[0] = this.mStartMotionPath;
        points[points.length - 1] = this.mEndMotionPath;
        if (this.mMotionPaths.size() > 0 && this.mCurveFitType == -1) {
            this.mCurveFitType = 0;
        }
        for (MotionPaths point : this.mMotionPaths) {
            points[count++] = point;
        }
        int variables = 18;
        HashSet<String> attributeNameSet = new HashSet<String>();
        for (String s : this.mEndMotionPath.getMCustomAttributes().keySet()) {
            if (!this.mStartMotionPath.getMCustomAttributes().containsKey(s) || splineAttributes.contains("CUSTOM," + s)) continue;
            attributeNameSet.add(s);
        }
        Collection $this$toTypedArray$iv3 = attributeNameSet;
        int $i$f$toTypedArray = 0;
        Collection thisCollection$iv3 = $this$toTypedArray$iv3;
        this.mAttributeNames = thisCollection$iv3.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)this.mAttributeNames);
        this.mAttributeInterpolatorCount = new int[this.mAttributeNames.length];
        Intrinsics.checkNotNull((Object)this.mAttributeNames);
        $i$f$toTypedArray = this.mAttributeNames.length;
        block13: for (int i3 = 0; i3 < $i$f$toTypedArray; ++i3) {
            Intrinsics.checkNotNull((Object)this.mAttributeNames);
            String attributeName = this.mAttributeNames[i3];
            Intrinsics.checkNotNull((Object)this.mAttributeInterpolatorCount);
            this.mAttributeInterpolatorCount[i3] = 0;
            int it2 = points.length;
            for (int j = 0; j < it2; ++j) {
                MotionPaths motionPaths = points[j];
                Intrinsics.checkNotNull((Object)motionPaths);
                if (!motionPaths.getMCustomAttributes().containsKey(attributeName)) continue;
                MotionPaths motionPaths2 = points[j];
                Intrinsics.checkNotNull((Object)motionPaths2);
                CustomVariable attribute = motionPaths2.getMCustomAttributes().get(attributeName);
                if (attribute == null) continue;
                Intrinsics.checkNotNull((Object)this.mAttributeInterpolatorCount);
                object = this.mAttributeInterpolatorCount;
                n = i3;
                object[n] = object[n] + attribute.numberOfInterpolatedValues();
                continue block13;
            }
        }
        MotionPaths motionPaths = points[0];
        Intrinsics.checkNotNull((Object)motionPaths);
        boolean arcMode = motionPaths.getMPathMotionArc() != -1;
        Intrinsics.checkNotNull((Object)this.mAttributeNames);
        boolean[] mask = new boolean[variables + this.mAttributeNames.length];
        int j = points.length;
        for (i2 = 1; i2 < j; ++i2) {
            MotionPaths motionPaths3 = points[i2];
            Intrinsics.checkNotNull((Object)motionPaths3);
            MotionPaths motionPaths4 = points[i2 - 1];
            Intrinsics.checkNotNull((Object)motionPaths4);
            Intrinsics.checkNotNull((Object)this.mAttributeNames);
            motionPaths3.different(motionPaths4, mask, this.mAttributeNames, arcMode);
        }
        count = 0;
        j = mask.length;
        for (i2 = 1; i2 < j; ++i2) {
            if (!mask[i2]) continue;
            ++count;
        }
        this.mInterpolateVariables = new int[count];
        int varLen = (int)Math.max(2.0, (double)count);
        this.mInterpolateData = new double[varLen];
        this.mInterpolateVelocity = new double[varLen];
        count = 0;
        int it2 = mask.length;
        for (int i4 = 1; i4 < it2; ++i4) {
            if (!mask[i4]) continue;
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            this.mInterpolateVariables[count++] = i4;
        }
        it2 = 0;
        int attribute = points.length;
        object = new double[attribute][];
        while (it2 < attribute) {
            n = it2++;
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            object[n] = (int)new double[this.mInterpolateVariables.length];
        }
        Object splineData = object;
        double[] timePoint = new double[points.length];
        int n4 = points.length;
        for (i = 0; i < n4; ++i) {
            MotionPaths motionPaths5 = points[i];
            Intrinsics.checkNotNull((Object)motionPaths5);
            int n5 = splineData[i];
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            motionPaths5.fillStandard((double[])n5, this.mInterpolateVariables);
            MotionPaths motionPaths6 = points[i];
            Intrinsics.checkNotNull((Object)motionPaths6);
            timePoint[i] = motionPaths6.getMTime();
        }
        Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
        n4 = this.mInterpolateVariables.length;
        for (int j2 = 0; j2 < n4; ++j2) {
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            int interpolateVariable = this.mInterpolateVariables[j2];
            if (interpolateVariable >= MotionPaths.Companion.getSNames().length) continue;
            String[] stringArray = MotionPaths.Companion.getSNames();
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            String s = stringArray[this.mInterpolateVariables[j2]] + " [";
            int n6 = points.length;
            for (int i5 = 0; i5 < n6; ++i5) {
                s = s + (double)splineData[i5][j2];
            }
        }
        Intrinsics.checkNotNull((Object)this.mAttributeNames);
        this.mSpline = new CurveFit[1 + this.mAttributeNames.length];
        Intrinsics.checkNotNull((Object)this.mAttributeNames);
        n4 = this.mAttributeNames.length;
        for (i = 0; i < n4; ++i) {
            int pointCount = 0;
            Object splinePoints = null;
            double[] timePoints = null;
            Intrinsics.checkNotNull((Object)this.mAttributeNames);
            String name = this.mAttributeNames[i];
            int n7 = points.length;
            for (int j3 = 0; j3 < n7; ++j3) {
                MotionPaths motionPaths7 = points[j3];
                Intrinsics.checkNotNull((Object)motionPaths7);
                if (!motionPaths7.hasCustomData(name)) continue;
                if (splinePoints == null) {
                    timePoints = new double[points.length];
                    int n8 = 0;
                    int n9 = points.length;
                    double[][] dArrayArray = new double[n9][];
                    while (n8 < n9) {
                        int n10 = n8++;
                        MotionPaths motionPaths8 = points[j3];
                        Intrinsics.checkNotNull((Object)motionPaths8);
                        dArrayArray[n10] = new double[motionPaths8.getCustomDataCount(name)];
                    }
                    splinePoints = dArrayArray;
                }
                Intrinsics.checkNotNull((Object)timePoints);
                MotionPaths motionPaths9 = points[j3];
                Intrinsics.checkNotNull((Object)motionPaths9);
                timePoints[pointCount] = motionPaths9.getMTime();
                MotionPaths motionPaths10 = points[j3];
                Intrinsics.checkNotNull((Object)motionPaths10);
                double[] dArray = splinePoints[pointCount];
                Intrinsics.checkNotNull((Object)dArray);
                motionPaths10.getCustomData(name, dArray, 0);
                ++pointCount;
            }
            Intrinsics.checkNotNull(timePoints);
            double[] dArray = Arrays.copyOf(timePoints, pointCount);
            Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
            timePoints = dArray;
            Intrinsics.checkNotNull(splinePoints);
            Object[] objectArray = Arrays.copyOf((Object[])splinePoints, pointCount);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            splinePoints = (double[][])objectArray;
            Intrinsics.checkNotNull((Object)this.mSpline);
            Collection $this$toTypedArray$iv4 = ArraysKt.filterNotNull((Object[])((Object[])splinePoints));
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv4 = $this$toTypedArray$iv4;
            this.mSpline[i + 1] = CurveFit.Companion.get(this.mCurveFitType, timePoints, (double[][])thisCollection$iv4.toArray((T[])new double[0][]));
        }
        Intrinsics.checkNotNull((Object)this.mSpline);
        this.mSpline[0] = CurveFit.Companion.get(this.mCurveFitType, timePoint, (double[][])splineData);
        MotionPaths motionPaths11 = points[0];
        Intrinsics.checkNotNull((Object)motionPaths11);
        if (motionPaths11.getMPathMotionArc() != -1) {
            int size = points.length;
            int[] mode = new int[size];
            double[] time = new double[size];
            int timePoints = 0;
            double[][] dArrayArray = new double[size][];
            while (timePoints < size) {
                int n11 = timePoints++;
                dArrayArray[n11] = new double[2];
            }
            double[][] values = dArrayArray;
            for (int i6 = 0; i6 < size; ++i6) {
                MotionPaths motionPaths12 = points[i6];
                Intrinsics.checkNotNull((Object)motionPaths12);
                mode[i6] = motionPaths12.getMPathMotionArc();
                MotionPaths motionPaths13 = points[i6];
                Intrinsics.checkNotNull((Object)motionPaths13);
                time[i6] = motionPaths13.getMTime();
                double[] dArray = values[i6];
                MotionPaths motionPaths14 = points[i6];
                Intrinsics.checkNotNull((Object)motionPaths14);
                dArray[0] = motionPaths14.getMX();
                double[] dArray2 = values[i6];
                MotionPaths motionPaths15 = points[i6];
                Intrinsics.checkNotNull((Object)motionPaths15);
                dArray2[1] = motionPaths15.getMY();
            }
            this.mArcSpline = CurveFit.Companion.getArc(mode, time, values);
        }
        float distance = Float.NaN;
        this.mCycleMap = new HashMap();
        if (this.mKeyList != null) {
            for (String attribute2 : cycleAttributes) {
                Intrinsics.checkNotNull((Object)attribute2);
                KeyCycleOscillator cycle = KeyCycleOscillator.Companion.makeWidgetCycle(attribute2);
                if (cycle.variesByPath() && Float.isNaN(distance)) {
                    distance = this.getPreCycleDistance();
                }
                cycle.setType(attribute2);
                HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
                Intrinsics.checkNotNull(hashMap);
                ((Map)hashMap).put(attribute2, cycle);
            }
            for (MotionKey key : this.mKeyList) {
                if (!(key instanceof MotionKeyCycle)) continue;
                MotionKeyCycle motionKeyCycle = (MotionKeyCycle)key;
                HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
                Intrinsics.checkNotNull(hashMap);
                motionKeyCycle.addCycleValues(hashMap);
            }
            HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
            Intrinsics.checkNotNull(hashMap);
            for (KeyCycleOscillator cycle : hashMap.values()) {
                cycle.setup(distance);
            }
        }
    }

    @NotNull
    public String toString() {
        return " start: x: " + this.mStartMotionPath.getMX() + " y: " + this.mStartMotionPath.getMY() + " end: x: " + this.mEndMotionPath.getMX() + " y: " + this.mEndMotionPath.getMY();
    }

    private final void readView(MotionPaths motionPaths) {
        MotionWidget motionWidget = this.mView;
        Intrinsics.checkNotNull((Object)motionWidget);
        float f = motionWidget.getX();
        MotionWidget motionWidget2 = this.mView;
        Intrinsics.checkNotNull((Object)motionWidget2);
        float f2 = motionWidget2.getY();
        MotionWidget motionWidget3 = this.mView;
        Intrinsics.checkNotNull((Object)motionWidget3);
        float f3 = motionWidget3.getWidth();
        MotionWidget motionWidget4 = this.mView;
        Intrinsics.checkNotNull((Object)motionWidget4);
        motionPaths.setBounds(f, f2, f3, motionWidget4.getHeight());
    }

    @Nullable
    public final MotionWidget getView() {
        return this.mView;
    }

    public final void setView(@Nullable MotionWidget value) {
        this.mView = value;
    }

    public final void setStart(@NotNull MotionWidget mw) {
        block0: {
            TypedBundle p;
            Intrinsics.checkNotNullParameter((Object)mw, (String)"mw");
            this.mStartMotionPath.setMTime(0.0f);
            this.mStartMotionPath.setMPosition(0.0f);
            this.mStartMotionPath.setBounds(mw.getX(), mw.getY(), mw.getWidth(), mw.getHeight());
            this.mStartMotionPath.applyParameters(mw);
            this.mStartPoint.setState(mw);
            TypedBundle typedBundle = p = mw.getWidgetFrame().getMotionProperties();
            if (typedBundle == null) break block0;
            typedBundle.applyDelta(this);
        }
    }

    public final void setEnd(@NotNull MotionWidget mw) {
        Intrinsics.checkNotNullParameter((Object)mw, (String)"mw");
        this.mEndMotionPath.setMTime(1.0f);
        this.mEndMotionPath.setMPosition(1.0f);
        this.readView(this.mEndMotionPath);
        this.mEndMotionPath.setBounds(mw.getLeft(), mw.getTop(), mw.getWidth(), mw.getHeight());
        this.mEndMotionPath.applyParameters(mw);
        this.mEndPoint.setState(mw);
    }

    public final void setStartState(@NotNull ViewState rect, @Nullable MotionWidget v, int rotation, int preWidth, int preHeight) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.mStartMotionPath.setMTime(0.0f);
        this.mStartMotionPath.setMPosition(0.0f);
        int cx = 0;
        int cy = 0;
        Rect r = new Rect();
        switch (rotation) {
            case 2: {
                cx = rect.getLeft() + rect.getRight();
                cy = rect.getTop() + rect.getBottom();
                r.setLeft(preHeight - (cy + rect.width()) / 2);
                r.setTop((cx - rect.height()) / 2);
                r.setRight(r.getLeft() + rect.width());
                r.setBottom(r.getTop() + rect.height());
                break;
            }
            case 1: {
                cx = rect.getLeft() + rect.getRight();
                cy = rect.getTop() + rect.getBottom();
                r.setLeft((cy - rect.width()) / 2);
                r.setTop(preWidth - (cx + rect.height()) / 2);
                r.setRight(r.getLeft() + rect.width());
                r.setBottom(r.getTop() + rect.height());
            }
        }
        this.mStartMotionPath.setBounds(r.getLeft(), r.getTop(), r.width(), r.height());
        this.mStartPoint.setState(r, v, rotation, rect.getRotation());
    }

    public final void rotate(@NotNull Rect rect, @NotNull Rect out, int rotation, int preHeight, int preWidth) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int cx = 0;
        int cy = 0;
        switch (rotation) {
            case 2: {
                cx = rect.getLeft() + rect.getRight();
                cy = rect.getTop() + rect.getBottom();
                out.setLeft(preHeight - (cy + rect.width()) / 2);
                out.setTop((cx - rect.height()) / 2);
                out.setRight(out.getLeft() + rect.width());
                out.setBottom(out.getTop() + rect.height());
                break;
            }
            case 1: {
                cx = rect.getLeft() + rect.getRight();
                cy = rect.getTop() + rect.getBottom();
                out.setLeft((cy - rect.width()) / 2);
                out.setTop(preWidth - (cx + rect.height()) / 2);
                out.setRight(out.getLeft() + rect.width());
                out.setBottom(out.getTop() + rect.height());
                break;
            }
            case 4: {
                cx = rect.getLeft() + rect.getRight();
                cy = rect.getBottom() + rect.getTop();
                out.setLeft(preHeight - (cy + rect.width()) / 2);
                out.setTop((cx - rect.height()) / 2);
                out.setRight(out.getLeft() + rect.width());
                out.setBottom(out.getTop() + rect.height());
                break;
            }
            case 3: {
                cx = rect.getLeft() + rect.getRight();
                cy = rect.getTop() + rect.getBottom();
                out.setLeft(rect.height() / 2 + rect.getTop() - cx / 2);
                out.setTop(preWidth - (cx + rect.height()) / 2);
                out.setRight(out.getLeft() + rect.width());
                out.setBottom(out.getTop() + rect.height());
            }
        }
    }

    public final void setBothStates(@NotNull MotionWidget v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.mStartMotionPath.setMTime(0.0f);
        this.mStartMotionPath.setMPosition(0.0f);
        this.mNoMovement = true;
        this.mStartMotionPath.setBounds(v.getX(), v.getY(), v.getWidth(), v.getHeight());
        this.mEndMotionPath.setBounds(v.getX(), v.getY(), v.getWidth(), v.getHeight());
        this.mStartPoint.setState(v);
        this.mEndPoint.setState(v);
    }

    private final float getAdjustedPosition(float position, float[] velocity) {
        float position2 = position;
        if (velocity != null) {
            velocity[0] = 1.0f;
        } else if (!(this.mStaggerScale == 1.0f)) {
            if (position2 < this.mStaggerOffset) {
                position2 = 0.0f;
            }
            if (position2 > this.mStaggerOffset && (double)position2 < 1.0) {
                position2 -= this.mStaggerOffset;
                position2 *= this.mStaggerScale;
                position2 = Math.min(position2, 1.0f);
            }
        }
        float adjusted = position2;
        Easing easing = this.mStartMotionPath.getMKeyFrameEasing();
        float start = 0.0f;
        float end = Float.NaN;
        for (MotionPaths frame : this.mMotionPaths) {
            if (frame.getMKeyFrameEasing() == null) continue;
            if (frame.getMTime() < position2) {
                easing = frame.getMKeyFrameEasing();
                start = frame.getMTime();
                continue;
            }
            if (!Float.isNaN(end)) continue;
            end = frame.getMTime();
        }
        if (easing != null) {
            if (Float.isNaN(end)) {
                end = 1.0f;
            }
            float offset = (position2 - start) / (end - start);
            float new_offset = (float)easing.get(offset);
            adjusted = new_offset * (end - start) + start;
            if (velocity != null) {
                velocity[0] = (float)easing.getDiff(offset);
            }
        }
        return adjusted;
    }

    public final void endTrigger(boolean start) {
    }

    public final boolean interpolate(@NotNull MotionWidget child, float globalPosition, long time, @Nullable KeyCache keyCache) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean timeAnimation = false;
        float position = this.getAdjustedPosition(globalPosition, null);
        if (this.mQuantizeMotionSteps != -1) {
            float pin = position;
            float steps = 1.0f / (float)this.mQuantizeMotionSteps;
            float jump = (float)Math.floor(position / steps) * steps;
            float section = position % steps / steps;
            if (!Float.isNaN(this.mQuantizeMotionPhase)) {
                section = (section + this.mQuantizeMotionPhase) % 1.0f;
            }
            DifferentialInterpolator differentialInterpolator = this.mQuantizeMotionInterpolator;
            section = differentialInterpolator != null ? differentialInterpolator.getInterpolation(section) : (float)((double)section > 0.5 ? 1 : 0);
            position = section * steps + jump;
        }
        if (this.mAttributesMap != null) {
            HashMap<String, SplineSet> hashMap = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap);
            for (SplineSet aSpline : hashMap.values()) {
                aSpline.setProperty(child, position);
            }
        }
        if (this.mSpline != null) {
            int i;
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            double d = position;
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit.getPos(d, this.mInterpolateData);
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit2 = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit2);
            double d2 = position;
            Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
            curveFit2.getSlope(d2, this.mInterpolateVelocity);
            if (this.mArcSpline != null) {
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                if (!(this.mInterpolateData.length == 0)) {
                    CurveFit curveFit3 = this.mArcSpline;
                    Intrinsics.checkNotNull((Object)curveFit3);
                    double d3 = position;
                    Intrinsics.checkNotNull((Object)this.mInterpolateData);
                    curveFit3.getPos(d3, this.mInterpolateData);
                    CurveFit curveFit4 = this.mArcSpline;
                    Intrinsics.checkNotNull((Object)curveFit4);
                    double d4 = position;
                    Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                    curveFit4.getSlope(d4, this.mInterpolateVelocity);
                }
            }
            if (!this.mNoMovement) {
                Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                this.mStartMotionPath.setView(position, child, this.mInterpolateVariables, this.mInterpolateData, this.mInterpolateVelocity, null);
            }
            if (this.mTransformPivotTarget != -1) {
                if (this.mTransformPivotView == null) {
                    MotionWidget motionWidget = child.getParent();
                    Intrinsics.checkNotNull((Object)motionWidget);
                    this.mTransformPivotView = motionWidget.findViewById(this.mTransformPivotTarget);
                }
                if (this.mTransformPivotView != null) {
                    MotionWidget motionWidget = this.mTransformPivotView;
                    Intrinsics.checkNotNull((Object)motionWidget);
                    int n = motionWidget.getTop();
                    MotionWidget motionWidget2 = this.mTransformPivotView;
                    Intrinsics.checkNotNull((Object)motionWidget2);
                    float cy = (float)(n + motionWidget2.getBottom()) / 2.0f;
                    MotionWidget motionWidget3 = this.mTransformPivotView;
                    Intrinsics.checkNotNull((Object)motionWidget3);
                    int n2 = motionWidget3.getLeft();
                    MotionWidget motionWidget4 = this.mTransformPivotView;
                    Intrinsics.checkNotNull((Object)motionWidget4);
                    float cx = (float)(n2 + motionWidget4.getRight()) / 2.0f;
                    if (child.getRight() - child.getLeft() > 0 && child.getBottom() - child.getTop() > 0) {
                        float px = cx - (float)child.getLeft();
                        float py = cy - (float)child.getTop();
                        child.setPivotX(px);
                        child.setPivotY(py);
                    }
                }
            }
            Intrinsics.checkNotNull((Object)this.mSpline);
            int cx = this.mSpline.length;
            for (i = 1; i < cx; ++i) {
                CurveFit spline;
                Intrinsics.checkNotNull((Object)this.mSpline);
                Intrinsics.checkNotNull((Object)this.mSpline[i]);
                spline.getPos((double)position, this.mValuesBuff);
                HashMap<String, CustomVariable> hashMap = this.mStartMotionPath.getMCustomAttributes();
                Intrinsics.checkNotNull((Object)this.mAttributeNames);
                CustomVariable customVariable = hashMap.get(this.mAttributeNames[i - 1]);
                Intrinsics.checkNotNull((Object)customVariable);
                customVariable.setInterpolatedValue(child, this.mValuesBuff);
            }
            if (this.mStartPoint.getMVisibilityMode() == 0) {
                if (position <= 0.0f) {
                    child.setVisibility(this.mStartPoint.getMVisibility());
                } else if (position >= 1.0f) {
                    child.setVisibility(this.mEndPoint.getMVisibility());
                } else if (this.mEndPoint.getMVisibility() != this.mStartPoint.getMVisibility()) {
                    child.setVisibility(4);
                }
            }
            if (this.mKeyTriggers != null) {
                Intrinsics.checkNotNull((Object)this.mKeyTriggers);
                cx = this.mKeyTriggers.length;
                for (i = 0; i < cx; ++i) {
                    Intrinsics.checkNotNull((Object)this.mKeyTriggers);
                    this.mKeyTriggers[i].conditionallyFire(position, child);
                }
            }
        } else {
            float float_l = this.mStartMotionPath.getMX() + (this.mEndMotionPath.getMX() - this.mStartMotionPath.getMX()) * position;
            float float_t = this.mStartMotionPath.getMY() + (this.mEndMotionPath.getMY() - this.mStartMotionPath.getMY()) * position;
            float float_width = this.mStartMotionPath.getMWidth() + (this.mEndMotionPath.getMWidth() - this.mStartMotionPath.getMWidth()) * position;
            float float_height = this.mStartMotionPath.getMHeight() + (this.mEndMotionPath.getMHeight() - this.mStartMotionPath.getMHeight()) * position;
            int l = (int)(0.5f + float_l);
            int t = (int)(0.5f + float_t);
            int r = (int)(0.5f + float_l + float_width);
            int b = (int)(0.5f + float_t + float_height);
            int width = r - l;
            int height = b - t;
            child.layout(l, t, r, b);
        }
        if (this.mCycleMap != null) {
            HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
            Intrinsics.checkNotNull(hashMap);
            for (KeyCycleOscillator osc : hashMap.values()) {
                if (osc instanceof KeyCycleOscillator.PathRotateSet) {
                    KeyCycleOscillator.PathRotateSet pathRotateSet = (KeyCycleOscillator.PathRotateSet)osc;
                    Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                    double d = this.mInterpolateVelocity[0];
                    Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                    pathRotateSet.setPathRotate(child, position, d, this.mInterpolateVelocity[1]);
                    continue;
                }
                osc.setProperty(child, position);
            }
        }
        return false;
    }

    public final void getDpDt(float position, float locationX, float locationY, @NotNull float[] mAnchorDpDt) {
        Intrinsics.checkNotNullParameter((Object)mAnchorDpDt, (String)"mAnchorDpDt");
        float position2 = position;
        position2 = this.getAdjustedPosition(position2, this.mVelocity);
        if (this.mSpline != null) {
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            double d = position2;
            Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
            curveFit.getSlope(d, this.mInterpolateVelocity);
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit2 = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit2);
            double d2 = position2;
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit2.getPos(d2, this.mInterpolateData);
            float v = this.mVelocity[0];
            Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
            int n = this.mInterpolateVelocity.length;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                this.mInterpolateVelocity[i] = this.mInterpolateVelocity[i] * (double)v;
            }
            if (this.mArcSpline != null) {
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                if (this.mInterpolateData.length > 0) {
                    CurveFit curveFit3 = this.mArcSpline;
                    Intrinsics.checkNotNull((Object)curveFit3);
                    double d3 = position2;
                    Intrinsics.checkNotNull((Object)this.mInterpolateData);
                    curveFit3.getPos(d3, this.mInterpolateData);
                    CurveFit curveFit4 = this.mArcSpline;
                    Intrinsics.checkNotNull((Object)curveFit4);
                    double d4 = position2;
                    Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                    curveFit4.getSlope(d4, this.mInterpolateVelocity);
                    Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
                    Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                    this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
                }
                return;
            }
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
            this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            return;
        }
        float dleft = this.mEndMotionPath.getMX() - this.mStartMotionPath.getMX();
        float dTop = this.mEndMotionPath.getMY() - this.mStartMotionPath.getMY();
        float dWidth = this.mEndMotionPath.getMWidth() - this.mStartMotionPath.getMWidth();
        float dHeight = this.mEndMotionPath.getMHeight() - this.mStartMotionPath.getMHeight();
        float dRight = dleft + dWidth;
        float dBottom = dTop + dHeight;
        mAnchorDpDt[0] = dleft * (1.0f - locationX) + dRight * locationX;
        mAnchorDpDt[1] = dTop * (1.0f - locationY) + dBottom * locationY;
    }

    public final void getPostLayoutDvDp(float position, int width, int height, float locationX, float locationY, @NotNull float[] mAnchorDpDt) {
        KeyCycleOscillator keyCycleOscillator;
        KeyCycleOscillator osc_sx;
        KeyCycleOscillator keyCycleOscillator2;
        KeyCycleOscillator osc_r;
        KeyCycleOscillator keyCycleOscillator3;
        KeyCycleOscillator osc_y;
        KeyCycleOscillator keyCycleOscillator4;
        KeyCycleOscillator osc_x;
        KeyCycleOscillator keyCycleOscillator5;
        SplineSet scale_y;
        SplineSet splineSet;
        SplineSet scale_x;
        SplineSet splineSet2;
        SplineSet rotation;
        SplineSet splineSet3;
        SplineSet trans_y;
        SplineSet splineSet4;
        SplineSet trans_x;
        SplineSet splineSet5;
        Intrinsics.checkNotNullParameter((Object)mAnchorDpDt, (String)"mAnchorDpDt");
        float position2 = position;
        position2 = this.getAdjustedPosition(position2, this.mVelocity);
        if (this.mAttributesMap == null) {
            splineSet5 = null;
        } else {
            HashMap<String, SplineSet> hashMap = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap);
            splineSet5 = trans_x = hashMap.get("translationX");
        }
        if (this.mAttributesMap == null) {
            splineSet4 = null;
        } else {
            HashMap<String, SplineSet> hashMap = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap);
            splineSet4 = trans_y = hashMap.get("translationY");
        }
        if (this.mAttributesMap == null) {
            splineSet3 = null;
        } else {
            HashMap<String, SplineSet> hashMap = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap);
            splineSet3 = rotation = hashMap.get("rotationZ");
        }
        if (this.mAttributesMap == null) {
            splineSet2 = null;
        } else {
            HashMap<String, SplineSet> hashMap = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap);
            splineSet2 = scale_x = hashMap.get("scaleX");
        }
        if (this.mAttributesMap == null) {
            splineSet = null;
        } else {
            HashMap<String, SplineSet> hashMap = this.mAttributesMap;
            Intrinsics.checkNotNull(hashMap);
            splineSet = scale_y = hashMap.get("scaleY");
        }
        if (this.mCycleMap == null) {
            keyCycleOscillator5 = null;
        } else {
            HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
            Intrinsics.checkNotNull(hashMap);
            keyCycleOscillator5 = osc_x = hashMap.get("translationX");
        }
        if (this.mCycleMap == null) {
            keyCycleOscillator4 = null;
        } else {
            HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
            Intrinsics.checkNotNull(hashMap);
            keyCycleOscillator4 = osc_y = hashMap.get("translationY");
        }
        if (this.mCycleMap == null) {
            keyCycleOscillator3 = null;
        } else {
            HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
            Intrinsics.checkNotNull(hashMap);
            keyCycleOscillator3 = osc_r = hashMap.get("rotationZ");
        }
        if (this.mCycleMap == null) {
            keyCycleOscillator2 = null;
        } else {
            HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
            Intrinsics.checkNotNull(hashMap);
            keyCycleOscillator2 = osc_sx = hashMap.get("scaleX");
        }
        if (this.mCycleMap == null) {
            keyCycleOscillator = null;
        } else {
            HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
            Intrinsics.checkNotNull(hashMap);
            keyCycleOscillator = hashMap.get("scaleY");
        }
        KeyCycleOscillator osc_sy = keyCycleOscillator;
        VelocityMatrix vmat = new VelocityMatrix();
        vmat.clear();
        vmat.setRotationVelocity(rotation, position2);
        vmat.setTranslationVelocity(trans_x, trans_y, position2);
        vmat.setScaleVelocity(scale_x, scale_y, position2);
        vmat.setRotationVelocity(osc_r, position2);
        vmat.setTranslationVelocity(osc_x, osc_y, position2);
        vmat.setScaleVelocity(osc_sx, osc_sy, position2);
        if (this.mArcSpline != null) {
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            if (this.mInterpolateData.length > 0) {
                CurveFit curveFit = this.mArcSpline;
                Intrinsics.checkNotNull((Object)curveFit);
                double d = position2;
                Intrinsics.checkNotNull((Object)this.mInterpolateData);
                curveFit.getPos(d, this.mInterpolateData);
                CurveFit curveFit2 = this.mArcSpline;
                Intrinsics.checkNotNull((Object)curveFit2);
                double d2 = position2;
                Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                curveFit2.getSlope(d2, this.mInterpolateVelocity);
                Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
                Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            }
            vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
            return;
        }
        if (this.mSpline != null) {
            position2 = this.getAdjustedPosition(position2, this.mVelocity);
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            double d = position2;
            Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
            curveFit.getSlope(d, this.mInterpolateVelocity);
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit3 = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit3);
            double d3 = position2;
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit3.getPos(d3, this.mInterpolateData);
            float v = this.mVelocity[0];
            Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
            int n = this.mInterpolateVelocity.length;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
                this.mInterpolateVelocity[i] = this.mInterpolateVelocity[i] * (double)v;
            }
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            Intrinsics.checkNotNull((Object)this.mInterpolateVelocity);
            this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
            return;
        }
        float dleft = this.mEndMotionPath.getMX() - this.mStartMotionPath.getMX();
        float dTop = this.mEndMotionPath.getMY() - this.mStartMotionPath.getMY();
        float dWidth = this.mEndMotionPath.getMWidth() - this.mStartMotionPath.getMWidth();
        float dHeight = this.mEndMotionPath.getMHeight() - this.mStartMotionPath.getMHeight();
        float dRight = dleft + dWidth;
        float dBottom = dTop + dHeight;
        mAnchorDpDt[0] = dleft * (1.0f - locationX) + dRight * locationX;
        mAnchorDpDt[1] = dTop * (1.0f - locationY) + dBottom * locationY;
        vmat.clear();
        vmat.setRotationVelocity(rotation, position2);
        vmat.setTranslationVelocity(trans_x, trans_y, position2);
        vmat.setScaleVelocity(scale_x, scale_y, position2);
        vmat.setRotationVelocity(osc_r, position2);
        vmat.setTranslationVelocity(osc_x, osc_y, position2);
        vmat.setScaleVelocity(osc_sx, osc_sy, position2);
        vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
    }

    public final int getDrawPath() {
        int mode = this.mStartMotionPath.getMDrawPath();
        for (MotionPaths keyFrame : this.mMotionPaths) {
            mode = Math.max(mode, keyFrame.getMDrawPath());
        }
        mode = Math.max(mode, this.mEndMotionPath.getMDrawPath());
        return mode;
    }

    public final void setDrawPath(int value) {
        this.mStartMotionPath.setMDrawPath(value);
    }

    @Nullable
    public final String name() {
        MotionWidget motionWidget = this.mView;
        Intrinsics.checkNotNull((Object)motionWidget);
        return motionWidget.getName();
    }

    public final void positionKeyframe(@Nullable MotionWidget view, @NotNull MotionKeyPosition key, float x, float y, @Nullable String[] attribute, @Nullable float[] value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        FloatRect start = new FloatRect();
        start.setLeft(this.mStartMotionPath.getMX());
        start.setTop(this.mStartMotionPath.getMY());
        start.setRight(start.getLeft() + this.mStartMotionPath.getMWidth());
        start.setBottom(start.getTop() + this.mStartMotionPath.getMHeight());
        FloatRect end = new FloatRect();
        end.setLeft(this.mEndMotionPath.getMX());
        end.setTop(this.mEndMotionPath.getMY());
        end.setRight(end.getLeft() + this.mEndMotionPath.getMWidth());
        end.setBottom(end.getTop() + this.mEndMotionPath.getMHeight());
        MotionWidget motionWidget = view;
        Intrinsics.checkNotNull((Object)motionWidget);
        Intrinsics.checkNotNull((Object)attribute);
        Intrinsics.checkNotNull((Object)value);
        key.positionAttributes(motionWidget, start, end, x, y, attribute, value);
    }

    public final int getKeyFramePositions(@NotNull int[] type, @NotNull float[] pos) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int i = 0;
        int count = 0;
        for (MotionKey key : this.mKeyList) {
            type[i++] = key.getMFramePosition() + 1000 * key.getMType();
            float time = (float)key.getMFramePosition() / 100.0f;
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            double d = time;
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit.getPos(d, this.mInterpolateData);
            double d2 = time;
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            this.mStartMotionPath.getCenter(d2, this.mInterpolateVariables, this.mInterpolateData, pos, count);
            count += 2;
        }
        return i;
    }

    public final int getKeyFrameInfo(int type, @NotNull int[] info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        int count = 0;
        int cursor = 0;
        float[] pos = new float[2];
        int len = 0;
        for (MotionKey key : this.mKeyList) {
            if (key.getMType() != type && type == -1) continue;
            len = cursor;
            info[cursor] = 0;
            info[++cursor] = key.getMType();
            info[++cursor] = key.getMFramePosition();
            float time = (float)key.getMFramePosition() / 100.0f;
            Intrinsics.checkNotNull((Object)this.mSpline);
            CurveFit curveFit = this.mSpline[0];
            Intrinsics.checkNotNull((Object)curveFit);
            double d = time;
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            curveFit.getPos(d, this.mInterpolateData);
            double d2 = time;
            Intrinsics.checkNotNull((Object)this.mInterpolateVariables);
            Intrinsics.checkNotNull((Object)this.mInterpolateData);
            this.mStartMotionPath.getCenter(d2, this.mInterpolateVariables, this.mInterpolateData, pos, 0);
            info[++cursor] = Float.floatToIntBits(pos[0]);
            info[++cursor] = Float.floatToIntBits(pos[1]);
            if (key instanceof MotionKeyPosition) {
                MotionKey kp = key;
                info[++cursor] = ((MotionKeyPosition)kp).getMPositionType();
                info[++cursor] = Float.floatToIntBits(((MotionKeyPosition)kp).getMPercentX());
                info[++cursor] = Float.floatToIntBits(((MotionKeyPosition)kp).getMPercentY());
            }
            info[len] = ++cursor - len;
            ++count;
        }
        return count;
    }

    @Override
    public boolean setValue(int id, int value) {
        switch (id) {
            case 509: {
                this.setPathMotionArc(value);
                return true;
            }
            case 610: {
                this.mQuantizeMotionSteps = value;
                return true;
            }
            case 704: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setValue(int id, float value) {
        if (602 == id) {
            this.mQuantizeMotionPhase = value;
            return true;
        }
        if (600 == id) {
            this.mMotionStagger = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean setValue(int id, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (705 == id || 611 == id) {
            this.mQuantizeMotionInterpolator = Motion.Companion.getInterpolator(-1, value, 0);
            return true;
        }
        if (605 == id) {
            this.mStartMotionPath.setMAnimateRelativeTo(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setValue(int id, boolean value) {
        return false;
    }

    @Override
    public int getId(@Nullable String name) {
        return 0;
    }

    public final void setStaggerScale(float staggerScale) {
        this.mStaggerScale = staggerScale;
    }

    public final void setStaggerOffset(float staggerOffset) {
        this.mStaggerOffset = staggerOffset;
    }

    public final float getMotionStagger() {
        return this.mMotionStagger;
    }

    public final void setIdString(@NotNull String stringId) {
        Intrinsics.checkNotNullParameter((Object)stringId, (String)"stringId");
        this.mId = stringId;
        this.mStartMotionPath.setMId(this.mId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0002R\u0014\u0010\u0016\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0002R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Landroidx/constraintlayout/core/motion/Motion$Companion;", "", "()V", "BOUNCE", "", "DEBUG", "", "DRAW_PATH_AS_CONFIGURED", "DRAW_PATH_BASIC", "DRAW_PATH_CARTESIAN", "DRAW_PATH_NONE", "DRAW_PATH_RECTANGLE", "DRAW_PATH_RELATIVE", "DRAW_PATH_SCREEN", "EASE_IN", "EASE_IN_OUT", "EASE_OUT", "FAVOR_FIXED_SIZE_VIEWS", "HORIZONTAL_PATH_X", "HORIZONTAL_PATH_Y", "INTERPOLATOR_REFERENCE_ID", "getINTERPOLATOR_REFERENCE_ID$annotations", "INTERPOLATOR_UNDEFINED", "getINTERPOLATOR_UNDEFINED$annotations", "LINEAR", "OVERSHOOT", "PATH_PERCENT", "PATH_PERPENDICULAR", "ROTATION_LEFT", "ROTATION_RIGHT", "SPLINE_STRING", "TAG", "", "VERTICAL_PATH_X", "VERTICAL_PATH_Y", "getInterpolator", "Landroidx/constraintlayout/core/motion/utils/DifferentialInterpolator;", "type", "interpolatorString", "id", "compose"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getINTERPOLATOR_REFERENCE_ID$annotations() {
        }

        private static /* synthetic */ void getINTERPOLATOR_UNDEFINED$annotations() {
        }

        private final DifferentialInterpolator getInterpolator(int type, String interpolatorString, int id) {
            if (type == -1) {
                Easing easing = Easing.Companion.getInterpolator(interpolatorString);
                return new DifferentialInterpolator(easing){
                    private float mX;
                    final /* synthetic */ Easing $easing;
                    {
                        this.$easing = $easing;
                    }

                    public final float getMX() {
                        return this.mX;
                    }

                    public final void setMX(float f) {
                        this.mX = f;
                    }

                    public float getInterpolation(float x) {
                        this.mX = x;
                        Easing easing = this.$easing;
                        Intrinsics.checkNotNull((Object)easing);
                        return (float)easing.get(x);
                    }

                    public float getVelocity() {
                        Easing easing = this.$easing;
                        Intrinsics.checkNotNull((Object)easing);
                        return (float)easing.getDiff(this.mX);
                    }
                };
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

