/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.Chain;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 92\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010\"\u001a\u00020#J\u001e\u0010$\u001a\u00020#2\u0016\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u0014j\b\u0012\u0004\u0012\u00020\u0000`\u0016J\u0006\u0010&\u001a\u00020#J\u0011\u0010'\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u001cH\u0082\u0002J\u0006\u0010(\u001a\u00020\u0003J\b\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0006J\u0016\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u0002002\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010.\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0016\u00101\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0000J\u000e\u00103\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0006J\u000e\u00104\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u00105\u001a\u00020\u0003J0\u00106\u001a\u00020\u00032\u0006\u0010/\u001a\u0002002\u0016\u00107\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u0014j\b\u0012\u0004\u0012\u00020\u001c`\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u00108\u001a\u00020*H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u0004R.\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014j\n\u0012\u0004\u0012\u00020\u0015\u0018\u0001`\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR*\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u0014j\b\u0012\u0004\u0012\u00020\u001c`\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\r\u00a8\u0006;"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup;", "", "orientation", "", "(I)V", "mAuthoritative", "", "getMAuthoritative", "()Z", "setMAuthoritative", "(Z)V", "mId", "getMId", "()I", "setMId", "mMoveTo", "mOrientation", "getMOrientation", "setMOrientation", "mResults", "Ljava/util/ArrayList;", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup$MeasureResult;", "Lkotlin/collections/ArrayList;", "getMResults", "()Ljava/util/ArrayList;", "setMResults", "(Ljava/util/ArrayList;)V", "mWidgets", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "getMWidgets", "setMWidgets", "getOrientation", "add", "widget", "apply", "", "cleanup", "dependencyLists", "clear", "contains", "getId", "getOrientationString", "", "intersectWith", "group", "isAuthoritative", "measureWrap", "system", "Landroidx/constraintlayout/core/LinearSystem;", "moveTo", "widgetGroup", "setAuthoritative", "setOrientation", "size", "solverMeasure", "widgets", "toString", "Companion", "MeasureResult", "compose"})
@StabilityInferred(parameters=0)
public final class WidgetGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<ConstraintWidget> mWidgets = new ArrayList();
    private int mId = -1;
    private boolean mAuthoritative;
    private int mOrientation;
    @Nullable
    private ArrayList<MeasureResult> mResults;
    private int mMoveTo;
    public static final int $stable = 8;
    private static final boolean DEBUG = false;
    private static int sCount;

    public WidgetGroup(int orientation) {
        this.mOrientation = orientation;
        this.mMoveTo = -1;
        int n = sCount;
        sCount = n + 1;
        this.mId = n;
    }

    @NotNull
    public final ArrayList<ConstraintWidget> getMWidgets() {
        return this.mWidgets;
    }

    public final void setMWidgets(@NotNull ArrayList<ConstraintWidget> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mWidgets = arrayList;
    }

    public final int getMId() {
        return this.mId;
    }

    public final void setMId(int n) {
        this.mId = n;
    }

    public final boolean getMAuthoritative() {
        return this.mAuthoritative;
    }

    public final void setMAuthoritative(boolean bl) {
        this.mAuthoritative = bl;
    }

    public final int getMOrientation() {
        return this.mOrientation;
    }

    public final void setMOrientation(int n) {
        this.mOrientation = n;
    }

    @Nullable
    public final ArrayList<MeasureResult> getMResults() {
        return this.mResults;
    }

    public final void setMResults(@Nullable ArrayList<MeasureResult> arrayList) {
        this.mResults = arrayList;
    }

    public final int getOrientation() {
        return this.mOrientation;
    }

    public final int getId() {
        return this.mId;
    }

    public final boolean add(@Nullable ConstraintWidget widget) {
        if (CollectionsKt.contains((Iterable)this.mWidgets, (Object)widget)) {
            return false;
        }
        ConstraintWidget constraintWidget = widget;
        Intrinsics.checkNotNull((Object)constraintWidget);
        this.mWidgets.add(constraintWidget);
        return true;
    }

    public final void setAuthoritative(boolean isAuthoritative) {
        this.mAuthoritative = isAuthoritative;
    }

    public final boolean isAuthoritative() {
        return this.mAuthoritative;
    }

    private final String getOrientationString() {
        String string2;
        switch (this.mOrientation) {
            case 0: {
                string2 = "Horizontal";
                break;
            }
            case 1: {
                string2 = "Vertical";
                break;
            }
            case 2: {
                string2 = "Both";
                break;
            }
            default: {
                string2 = "Unknown";
            }
        }
        return string2;
    }

    @NotNull
    public String toString() {
        String ret = this.getOrientationString() + " [" + this.mId + "] <";
        for (ConstraintWidget widget : this.mWidgets) {
            ret = ret + " " + widget.getDebugName();
        }
        ret = ret + " >";
        return ret;
    }

    public final void moveTo(int orientation, @NotNull WidgetGroup widgetGroup) {
        Intrinsics.checkNotNullParameter((Object)widgetGroup, (String)"widgetGroup");
        Iterator<ConstraintWidget> iterator = this.mWidgets.iterator();
        while (iterator.hasNext()) {
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            widgetGroup.add(widget);
            if (orientation == 0) {
                widget.setHorizontalGroup(widgetGroup.getId());
                continue;
            }
            widget.setVerticalGroup(widgetGroup.getId());
        }
        this.mMoveTo = widgetGroup.mId;
    }

    public final void clear() {
        this.mWidgets.clear();
    }

    private final int measureWrap(int orientation, ConstraintWidget widget) {
        ConstraintWidget.DimensionBehaviour behaviour = widget.getDimensionBehaviour(orientation);
        if (behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || behaviour == ConstraintWidget.DimensionBehaviour.MATCH_PARENT || behaviour == ConstraintWidget.DimensionBehaviour.FIXED) {
            int dimension = orientation == 0 ? widget.getWidth() : widget.getHeight();
            return dimension;
        }
        return -1;
    }

    public final int measureWrap(@NotNull LinearSystem system, int orientation) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        int count = this.mWidgets.size();
        return count == 0 ? 0 : this.solverMeasure(system, this.mWidgets, orientation);
    }

    private final int solverMeasure(LinearSystem system, ArrayList<ConstraintWidget> widgets, int orientation) {
        int n;
        ConstraintWidget widget;
        ConstraintWidgetContainer container = (ConstraintWidgetContainer)widgets.get(0).getParent();
        system.reset();
        boolean prevDebug = false;
        ConstraintWidgetContainer constraintWidgetContainer = container;
        Intrinsics.checkNotNull((Object)constraintWidgetContainer);
        constraintWidgetContainer.addToSolver(system, false);
        int n2 = widgets.size();
        for (int i = 0; i < n2; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)widgets.get(i), (String)"get(...)");
            widget.addToSolver(system, false);
        }
        if (orientation == 0 && container.getMHorizontalChainsSize() > 0) {
            Chain.Companion.applyChainConstraints(container, system, widgets, 0);
        }
        if (orientation == 1 && container.getMVerticalChainsSize() > 0) {
            Chain.Companion.applyChainConstraints(container, system, widgets, 1);
        }
        try {
            system.minimize();
        }
        catch (Exception e) {
            String string2 = e + "\n" + StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)ExceptionsKt.stackTraceToString((Throwable)e), (String)"[", (String)"   at ", (boolean)false, (int)4, null), (String)",", (String)"\n   at", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null);
            System.out.println((Object)string2);
        }
        this.mResults = new ArrayList();
        int n3 = widgets.size();
        for (int i = 0; i < n3; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)widgets.get(i), (String)"get(...)");
            MeasureResult result = new MeasureResult(widget, system, orientation);
            ArrayList<MeasureResult> arrayList = this.mResults;
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(result);
        }
        if (orientation == 0) {
            int left = system.getObjectVariableValue(container.getMLeft());
            int right = system.getObjectVariableValue(container.getMRight());
            system.reset();
            n = right - left;
        } else {
            int top = system.getObjectVariableValue(container.getMTop());
            int bottom = system.getObjectVariableValue(container.getMBottom());
            system.reset();
            n = bottom - top;
        }
        return n;
    }

    public final void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public final void apply() {
        if (this.mResults == null) {
            return;
        }
        if (!this.mAuthoritative) {
            return;
        }
        ArrayList<MeasureResult> arrayList = this.mResults;
        Intrinsics.checkNotNull(arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            MeasureResult result;
            ArrayList<MeasureResult> arrayList2 = this.mResults;
            Intrinsics.checkNotNull(arrayList2);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList2.get(i), (String)"get(...)");
            result.apply();
        }
    }

    public final boolean intersectWith(@NotNull WidgetGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        int n = this.mWidgets.size();
        for (int i = 0; i < n; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNullExpressionValue((Object)this.mWidgets.get(i), (String)"get(...)");
            if (!group.contains(widget)) continue;
            return true;
        }
        return false;
    }

    private final boolean contains(ConstraintWidget widget) {
        return this.mWidgets.contains(widget);
    }

    public final int size() {
        return this.mWidgets.size();
    }

    public final void cleanup(@NotNull ArrayList<WidgetGroup> dependencyLists) {
        Intrinsics.checkNotNullParameter(dependencyLists, (String)"dependencyLists");
        int count = this.mWidgets.size();
        if (this.mMoveTo != -1 && count > 0) {
            int n = dependencyLists.size();
            for (int i = 0; i < n; ++i) {
                WidgetGroup group;
                Intrinsics.checkNotNullExpressionValue((Object)dependencyLists.get(i), (String)"get(...)");
                if (this.mMoveTo != group.mId) continue;
                this.moveTo(this.mOrientation, group);
            }
        }
        if (count == 0) {
            dependencyLists.remove(this);
            return;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup$Companion;", "", "()V", "DEBUG", "", "sCount", "", "getSCount", "()I", "setSCount", "(I)V", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSCount() {
            return sCount;
        }

        public final void setSCount(int n) {
            sCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010$\u001a\u00020%R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u001a\u0010\u0017\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\rR\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000b\"\u0004\b\u001c\u0010\rR.\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001ej\n\u0012\u0004\u0012\u00020\u0003\u0018\u0001`\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/WidgetGroup$MeasureResult;", "", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "system", "Landroidx/constraintlayout/core/LinearSystem;", "orientation", "", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;Landroidx/constraintlayout/core/LinearSystem;I)V", "mBaseline", "getMBaseline", "()I", "setMBaseline", "(I)V", "mBottom", "getMBottom", "setMBottom", "mLeft", "getMLeft", "setMLeft", "mOrientation", "getMOrientation", "setMOrientation", "mRight", "getMRight", "setMRight", "mTop", "getMTop", "setMTop", "mWidgetRef", "Ljava/lang/ref/WeakReference;", "Landroidx/constraintlayout/core/platform/WeakReference;", "getMWidgetRef", "()Ljava/lang/ref/WeakReference;", "setMWidgetRef", "(Ljava/lang/ref/WeakReference;)V", "apply", "", "compose"})
    @StabilityInferred(parameters=0)
    public static final class MeasureResult {
        @Nullable
        private WeakReference<ConstraintWidget> mWidgetRef;
        private int mLeft;
        private int mTop;
        private int mRight;
        private int mBottom;
        private int mBaseline;
        private int mOrientation;
        public static final int $stable = 8;

        public MeasureResult(@NotNull ConstraintWidget widget, @NotNull LinearSystem system, int orientation) {
            Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            this.mOrientation = orientation;
            this.mWidgetRef = new WeakReference<ConstraintWidget>(widget);
            this.mLeft = system.getObjectVariableValue(widget.getMLeft());
            this.mTop = system.getObjectVariableValue(widget.getMTop());
            this.mRight = system.getObjectVariableValue(widget.getMRight());
            this.mBottom = system.getObjectVariableValue(widget.getMBottom());
            this.mBaseline = system.getObjectVariableValue(widget.getMBaseline());
        }

        @Nullable
        public final WeakReference<ConstraintWidget> getMWidgetRef() {
            return this.mWidgetRef;
        }

        public final void setMWidgetRef(@Nullable WeakReference<ConstraintWidget> weakReference) {
            this.mWidgetRef = weakReference;
        }

        public final int getMLeft() {
            return this.mLeft;
        }

        public final void setMLeft(int n) {
            this.mLeft = n;
        }

        public final int getMTop() {
            return this.mTop;
        }

        public final void setMTop(int n) {
            this.mTop = n;
        }

        public final int getMRight() {
            return this.mRight;
        }

        public final void setMRight(int n) {
            this.mRight = n;
        }

        public final int getMBottom() {
            return this.mBottom;
        }

        public final void setMBottom(int n) {
            this.mBottom = n;
        }

        public final int getMBaseline() {
            return this.mBaseline;
        }

        public final void setMBaseline(int n) {
            this.mBaseline = n;
        }

        public final int getMOrientation() {
            return this.mOrientation;
        }

        public final void setMOrientation(int n) {
            this.mOrientation = n;
        }

        public final void apply() {
            block0: {
                ConstraintWidget widget;
                WeakReference<ConstraintWidget> weakReference = this.mWidgetRef;
                Intrinsics.checkNotNull(weakReference);
                ConstraintWidget constraintWidget = widget = (ConstraintWidget)weakReference.get();
                if (constraintWidget == null) break block0;
                constraintWidget.setFinalFrame(this.mLeft, this.mTop, this.mRight, this.mBottom, this.mBaseline, this.mOrientation);
            }
        }
    }
}

