/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/HelperReferences;", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "widget", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "(Landroidx/constraintlayout/core/widgets/ConstraintWidget;)V", "addDependency", "", "node", "Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "apply", "applyToWidget", "clear", "reset", "supportsWrapComputation", "", "update", "Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "compose"})
@StabilityInferred(parameters=1)
public final class HelperReferences
extends WidgetRun {
    public static final int $stable;

    public HelperReferences(@NotNull ConstraintWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        super(widget);
    }

    @Override
    public void clear() {
        this.setMRunGroup(null);
        this.getStart().clear();
    }

    @Override
    public void reset() {
        this.getStart().setResolved(false);
    }

    @Override
    public boolean supportsWrapComputation() {
        return false;
    }

    private final void addDependency(DependencyNode node) {
        this.getStart().getMDependencies().add(node);
        node.getMTargets().add(this.getStart());
    }

    @Override
    public void apply() {
        if (this.getMWidget() instanceof Barrier) {
            this.getStart().setDelegateToWidgetRun(true);
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.Barrier");
            Barrier barrier = (Barrier)constraintWidget;
            int type = barrier.getBarrierType();
            boolean allowsGoneWidget = barrier.getAllowsGoneWidget();
            switch (type) {
                case 0: {
                    this.getStart().setMType(DependencyNode.Type.LEFT);
                    int i = 0;
                    while (i < barrier.getMWidgetsCount()) {
                        ConstraintWidget refWidget;
                        Intrinsics.checkNotNull((Object)barrier.getMWidgets()[i]);
                        if (!allowsGoneWidget && refWidget.getVisibility() == 8) {
                            ++i;
                            continue;
                        }
                        HorizontalWidgetRun horizontalWidgetRun = refWidget.getMHorizontalRun();
                        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                        DependencyNode target = horizontalWidgetRun.getStart();
                        target.getMDependencies().add(this.getStart());
                        this.getStart().getMTargets().add(target);
                        ++i;
                    }
                    ConstraintWidget constraintWidget2 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget2);
                    HorizontalWidgetRun horizontalWidgetRun = constraintWidget2.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                    this.addDependency(horizontalWidgetRun.getStart());
                    ConstraintWidget constraintWidget3 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget3);
                    HorizontalWidgetRun horizontalWidgetRun2 = constraintWidget3.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun2);
                    this.addDependency(horizontalWidgetRun2.getEnd());
                    break;
                }
                case 1: {
                    this.getStart().setMType(DependencyNode.Type.RIGHT);
                    int i = 0;
                    while (i < barrier.getMWidgetsCount()) {
                        ConstraintWidget refWidget;
                        Intrinsics.checkNotNull((Object)barrier.getMWidgets()[i]);
                        if (!allowsGoneWidget && refWidget.getVisibility() == 8) {
                            ++i;
                            continue;
                        }
                        HorizontalWidgetRun horizontalWidgetRun = refWidget.getMHorizontalRun();
                        Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                        DependencyNode target = horizontalWidgetRun.getEnd();
                        target.getMDependencies().add(this.getStart());
                        this.getStart().getMTargets().add(target);
                        ++i;
                    }
                    ConstraintWidget constraintWidget4 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget4);
                    HorizontalWidgetRun horizontalWidgetRun = constraintWidget4.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun);
                    this.addDependency(horizontalWidgetRun.getStart());
                    ConstraintWidget constraintWidget5 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget5);
                    HorizontalWidgetRun horizontalWidgetRun3 = constraintWidget5.getMHorizontalRun();
                    Intrinsics.checkNotNull((Object)horizontalWidgetRun3);
                    this.addDependency(horizontalWidgetRun3.getEnd());
                    break;
                }
                case 2: {
                    this.getStart().setMType(DependencyNode.Type.TOP);
                    int i = 0;
                    while (i < barrier.getMWidgetsCount()) {
                        ConstraintWidget refwidget;
                        Intrinsics.checkNotNull((Object)barrier.getMWidgets()[i]);
                        if (!allowsGoneWidget && refwidget.getVisibility() == 8) {
                            ++i;
                            continue;
                        }
                        VerticalWidgetRun verticalWidgetRun = refwidget.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun);
                        DependencyNode target = verticalWidgetRun.getStart();
                        target.getMDependencies().add(this.getStart());
                        this.getStart().getMTargets().add(target);
                        ++i;
                    }
                    ConstraintWidget constraintWidget6 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget6);
                    VerticalWidgetRun verticalWidgetRun = constraintWidget6.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    this.addDependency(verticalWidgetRun.getStart());
                    ConstraintWidget constraintWidget7 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget7);
                    VerticalWidgetRun verticalWidgetRun2 = constraintWidget7.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun2);
                    this.addDependency(verticalWidgetRun2.getEnd());
                    break;
                }
                case 3: {
                    this.getStart().setMType(DependencyNode.Type.BOTTOM);
                    int i = 0;
                    while (i < barrier.getMWidgetsCount()) {
                        ConstraintWidget refwidget;
                        Intrinsics.checkNotNull((Object)barrier.getMWidgets()[i]);
                        if (!allowsGoneWidget && refwidget.getVisibility() == 8) {
                            ++i;
                            continue;
                        }
                        VerticalWidgetRun verticalWidgetRun = refwidget.getMVerticalRun();
                        Intrinsics.checkNotNull((Object)verticalWidgetRun);
                        DependencyNode target = verticalWidgetRun.getEnd();
                        target.getMDependencies().add(this.getStart());
                        this.getStart().getMTargets().add(target);
                        ++i;
                    }
                    ConstraintWidget constraintWidget8 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget8);
                    VerticalWidgetRun verticalWidgetRun = constraintWidget8.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun);
                    this.addDependency(verticalWidgetRun.getStart());
                    ConstraintWidget constraintWidget9 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget9);
                    VerticalWidgetRun verticalWidgetRun3 = constraintWidget9.getMVerticalRun();
                    Intrinsics.checkNotNull((Object)verticalWidgetRun3);
                    this.addDependency(verticalWidgetRun3.getEnd());
                }
            }
        }
    }

    @Override
    public void update(@NotNull Dependency node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ConstraintWidget constraintWidget = this.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.Barrier");
        Barrier barrier = (Barrier)constraintWidget;
        int type = barrier.getBarrierType();
        int min = -1;
        int max = 0;
        for (DependencyNode target : this.getStart().getMTargets()) {
            int value = target.getValue();
            if (min == -1 || value < min) {
                min = value;
            }
            if (max >= value) continue;
            max = value;
        }
        switch (type) {
            case 0: 
            case 2: {
                this.getStart().resolve(min + barrier.getMargin());
                break;
            }
            default: {
                this.getStart().resolve(max + barrier.getMargin());
            }
        }
    }

    @Override
    public void applyToWidget() {
        if (this.getMWidget() instanceof Barrier) {
            ConstraintWidget constraintWidget = this.getMWidget();
            Intrinsics.checkNotNull((Object)constraintWidget, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.widgets.Barrier");
            Barrier barrier = (Barrier)constraintWidget;
            int type = barrier.getBarrierType();
            switch (type) {
                case 0: 
                case 1: {
                    ConstraintWidget constraintWidget2 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget2);
                    constraintWidget2.setX(this.getStart().getValue());
                    break;
                }
                default: {
                    ConstraintWidget constraintWidget3 = this.getMWidget();
                    Intrinsics.checkNotNull((Object)constraintWidget3);
                    constraintWidget3.setY(this.getStart().getValue());
                }
            }
        }
    }
}

