/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001BB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0001J\u0006\u0010;\u001a\u000209J\u0006\u0010<\u001a\u00020=J\u0010\u0010>\u001a\u0002092\u0006\u00105\u001a\u00020\u0011H\u0016J\b\u0010?\u001a\u00020=H\u0016J\u0010\u0010@\u001a\u0002092\u0006\u0010A\u001a\u00020\u0001H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00010\fj\b\u0012\u0004\u0012\u00020\u0001`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u0004R!\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00000\fj\b\u0012\u0004\u0012\u00020\u0000`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\b\"\u0004\b,\u0010\nR\u001a\u0010-\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\b\"\u0004\b/\u0010\nR\u001c\u00100\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0013\"\u0004\b7\u0010\u0015\u00a8\u0006C"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode;", "Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "mRun", "Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "(Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;)V", "delegateToWidgetRun", "", "getDelegateToWidgetRun", "()Z", "setDelegateToWidgetRun", "(Z)V", "mDependencies", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getMDependencies", "()Ljava/util/ArrayList;", "mMargin", "", "getMMargin", "()I", "setMMargin", "(I)V", "mMarginDependency", "Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;", "getMMarginDependency", "()Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;", "setMMarginDependency", "(Landroidx/constraintlayout/core/widgets/analyzer/DimensionDependency;)V", "mMarginFactor", "getMMarginFactor", "setMMarginFactor", "getMRun", "()Landroidx/constraintlayout/core/widgets/analyzer/WidgetRun;", "setMRun", "mTargets", "getMTargets", "mType", "Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode$Type;", "getMType", "()Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode$Type;", "setMType", "(Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode$Type;)V", "readyToSolve", "getReadyToSolve", "setReadyToSolve", "resolved", "getResolved", "setResolved", "updateDelegate", "getUpdateDelegate", "()Landroidx/constraintlayout/core/widgets/analyzer/Dependency;", "setUpdateDelegate", "(Landroidx/constraintlayout/core/widgets/analyzer/Dependency;)V", "value", "getValue", "setValue", "addDependency", "", "dependency", "clear", "name", "", "resolve", "toString", "update", "node", "Type", "compose"})
@StabilityInferred(parameters=0)
public class DependencyNode
implements Dependency {
    @NotNull
    private WidgetRun mRun;
    @Nullable
    private Dependency updateDelegate;
    private boolean delegateToWidgetRun;
    private boolean readyToSolve;
    @NotNull
    private Type mType;
    private int mMargin;
    private int value;
    private int mMarginFactor;
    @Nullable
    private DimensionDependency mMarginDependency;
    private boolean resolved;
    @NotNull
    private final ArrayList<Dependency> mDependencies;
    @NotNull
    private final ArrayList<DependencyNode> mTargets;
    public static final int $stable = 8;

    public DependencyNode(@NotNull WidgetRun mRun) {
        Intrinsics.checkNotNullParameter((Object)mRun, (String)"mRun");
        this.mRun = mRun;
        this.mType = Type.UNKNOWN;
        this.mMarginFactor = 1;
        this.mDependencies = new ArrayList();
        this.mTargets = new ArrayList();
    }

    @NotNull
    public final WidgetRun getMRun() {
        return this.mRun;
    }

    public final void setMRun(@NotNull WidgetRun widgetRun) {
        Intrinsics.checkNotNullParameter((Object)widgetRun, (String)"<set-?>");
        this.mRun = widgetRun;
    }

    @Nullable
    public final Dependency getUpdateDelegate() {
        return this.updateDelegate;
    }

    public final void setUpdateDelegate(@Nullable Dependency dependency) {
        this.updateDelegate = dependency;
    }

    public final boolean getDelegateToWidgetRun() {
        return this.delegateToWidgetRun;
    }

    public final void setDelegateToWidgetRun(boolean bl) {
        this.delegateToWidgetRun = bl;
    }

    public final boolean getReadyToSolve() {
        return this.readyToSolve;
    }

    public final void setReadyToSolve(boolean bl) {
        this.readyToSolve = bl;
    }

    @NotNull
    public final Type getMType() {
        return this.mType;
    }

    public final void setMType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.mType = type;
    }

    public final int getMMargin() {
        return this.mMargin;
    }

    public final void setMMargin(int n) {
        this.mMargin = n;
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int n) {
        this.value = n;
    }

    public final int getMMarginFactor() {
        return this.mMarginFactor;
    }

    public final void setMMarginFactor(int n) {
        this.mMarginFactor = n;
    }

    @Nullable
    public final DimensionDependency getMMarginDependency() {
        return this.mMarginDependency;
    }

    public final void setMMarginDependency(@Nullable DimensionDependency dimensionDependency) {
        this.mMarginDependency = dimensionDependency;
    }

    public final boolean getResolved() {
        return this.resolved;
    }

    public final void setResolved(boolean bl) {
        this.resolved = bl;
    }

    @NotNull
    public final ArrayList<Dependency> getMDependencies() {
        return this.mDependencies;
    }

    @NotNull
    public final ArrayList<DependencyNode> getMTargets() {
        return this.mTargets;
    }

    @NotNull
    public String toString() {
        ConstraintWidget constraintWidget = this.mRun.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        return constraintWidget.getDebugName() + ":" + this.mType + "(" + (this.resolved ? Integer.valueOf(this.value) : "unresolved") + ") <t=" + this.mTargets.size() + ":d=" + this.mDependencies.size() + ">";
    }

    public void resolve(int value) {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.value = value;
        for (Dependency node : this.mDependencies) {
            Intrinsics.checkNotNull((Object)node);
            node.update(node);
        }
    }

    @Override
    public void update(@NotNull Dependency node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (DependencyNode target : this.mTargets) {
            if (target.resolved) continue;
            return;
        }
        this.readyToSolve = true;
        if (this.updateDelegate != null) {
            Dependency dependency = this.updateDelegate;
            Intrinsics.checkNotNull((Object)dependency);
            dependency.update(this);
        }
        if (this.delegateToWidgetRun) {
            this.mRun.update(this);
            return;
        }
        DependencyNode target = null;
        int numTargets = 0;
        for (DependencyNode t : this.mTargets) {
            if (t instanceof DimensionDependency) continue;
            target = t;
            ++numTargets;
        }
        if (target != null && numTargets == 1 && target.resolved) {
            if (this.mMarginDependency != null) {
                DimensionDependency dimensionDependency = this.mMarginDependency;
                Intrinsics.checkNotNull((Object)dimensionDependency);
                if (dimensionDependency.getResolved()) {
                    DimensionDependency dimensionDependency2 = this.mMarginDependency;
                    Intrinsics.checkNotNull((Object)dimensionDependency2);
                    this.mMargin = this.mMarginFactor * dimensionDependency2.getValue();
                } else {
                    return;
                }
            }
            this.resolve(target.value + this.mMargin);
        }
        if (this.updateDelegate != null) {
            Dependency dependency = this.updateDelegate;
            Intrinsics.checkNotNull((Object)dependency);
            dependency.update(this);
        }
    }

    public final void addDependency(@NotNull Dependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.mDependencies.add(dependency);
        if (this.resolved) {
            dependency.update(dependency);
        }
    }

    @NotNull
    public final String name() {
        ConstraintWidget constraintWidget = this.mRun.getMWidget();
        Intrinsics.checkNotNull((Object)constraintWidget);
        Object definition = String.valueOf(constraintWidget.getDebugName());
        definition = (String)definition + (this.mType == Type.LEFT || this.mType == Type.RIGHT ? "_HORIZONTAL" : "_VERTICAL");
        definition = (String)definition + ":" + this.mType.name();
        return definition;
    }

    public final void clear() {
        this.mTargets.clear();
        this.mDependencies.clear();
        this.resolved = false;
        this.value = 0;
        this.readyToSolve = false;
        this.delegateToWidgetRun = false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Landroidx/constraintlayout/core/widgets/analyzer/DependencyNode$Type;", "", "(Ljava/lang/String;I)V", "UNKNOWN", "HORIZONTAL_DIMENSION", "VERTICAL_DIMENSION", "LEFT", "RIGHT", "TOP", "BOTTOM", "BASELINE", "compose"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNKNOWN = new Type();
        public static final /* enum */ Type HORIZONTAL_DIMENSION = new Type();
        public static final /* enum */ Type VERTICAL_DIMENSION = new Type();
        public static final /* enum */ Type LEFT = new Type();
        public static final /* enum */ Type RIGHT = new Type();
        public static final /* enum */ Type TOP = new Type();
        public static final /* enum */ Type BOTTOM = new Type();
        public static final /* enum */ Type BASELINE = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.UNKNOWN, Type.HORIZONTAL_DIMENSION, Type.VERTICAL_DIMENSION, Type.LEFT, Type.RIGHT, Type.TOP, Type.BOTTOM, Type.BASELINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

