/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/core/widgets/Placeholder;", "Landroidx/constraintlayout/core/widgets/VirtualLayout;", "()V", "addToSolver", "", "system", "Landroidx/constraintlayout/core/LinearSystem;", "optimize", "", "measure", "widthMode", "", "widthSize", "heightMode", "heightSize", "compose"})
@StabilityInferred(parameters=1)
public final class Placeholder
extends VirtualLayout {
    public static final int $stable;

    @Override
    public void measure(int widthMode, int widthSize, int heightMode, int heightSize) {
        int width = 0;
        int height = 0;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        width += paddingLeft + paddingRight;
        height += paddingTop + paddingBottom;
        if (this.getMWidgetsCount() > 0) {
            ConstraintWidget constraintWidget = this.getMWidgets()[0];
            Intrinsics.checkNotNull((Object)constraintWidget);
            width += constraintWidget.getWidth();
            ConstraintWidget constraintWidget2 = this.getMWidgets()[0];
            Intrinsics.checkNotNull((Object)constraintWidget2);
            height += constraintWidget2.getHeight();
        }
        width = Math.max(this.getMinWidth(), width);
        height = Math.max(this.getMinHeight(), height);
        int measuredWidth = 0;
        int measuredHeight = 0;
        switch (widthMode) {
            case 0x40000000: {
                measuredWidth = widthSize;
                break;
            }
            case -2147483648: {
                measuredWidth = Math.min(width, widthSize);
                break;
            }
            case 0: {
                measuredWidth = width;
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                measuredHeight = heightSize;
                break;
            }
            case -2147483648: {
                measuredHeight = Math.min(height, heightSize);
                break;
            }
            case 0: {
                measuredHeight = height;
            }
        }
        this.setMeasure(measuredWidth, measuredHeight);
        this.setWidth(measuredWidth);
        this.setHeight(measuredHeight);
        this.needsCallbackFromSolver(this.getMWidgetsCount() > 0);
    }

    @Override
    public void addToSolver(@NotNull LinearSystem system, boolean optimize) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        super.addToSolver(system, optimize);
        if (this.getMWidgetsCount() > 0) {
            ConstraintWidget constraintWidget = this.getMWidgets()[0];
            Intrinsics.checkNotNull((Object)constraintWidget);
            ConstraintWidget widget = constraintWidget;
            widget.resetAllConstraints();
            widget.connect(ConstraintAnchor.Type.LEFT, this, ConstraintAnchor.Type.LEFT);
            widget.connect(ConstraintAnchor.Type.RIGHT, this, ConstraintAnchor.Type.RIGHT);
            widget.connect(ConstraintAnchor.Type.TOP, this, ConstraintAnchor.Type.TOP);
            widget.connect(ConstraintAnchor.Type.BOTTOM, this, ConstraintAnchor.Type.BOTTOM);
        }
    }
}

