/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.HelperWidget;
import java.util.HashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0006\u0010\u0017\u001a\u00020\u0007J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0007J<\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2*\u0010\u001d\u001a&\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001ej\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c`\u001fH\u0016J\u0006\u0010 \u001a\u00020\u0007J\u0006\u0010!\u001a\u00020\fJ\u0006\u0010\"\u001a\u00020\fJ\r\u0010#\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\fJ\u000e\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\fJ\b\u0010*\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006,"}, d2={"Landroidx/constraintlayout/core/widgets/Barrier;", "Landroidx/constraintlayout/core/widgets/HelperWidget;", "debugName", "", "(Ljava/lang/String;)V", "()V", "isResolvedHorizontally", "", "()Z", "isResolvedVertically", "mAllowsGoneWidget", "mBarrierType", "", "mMargin", "mResolved", "orientation", "getOrientation", "()I", "addToSolver", "", "system", "Landroidx/constraintlayout/core/LinearSystem;", "optimize", "allSolved", "allowedInBarrier", "allowsGoneWidget", "copy", "src", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAllowsGoneWidget", "getBarrierType", "getMargin", "markWidgets", "markWidgets$compose", "setAllowsGoneWidget", "setBarrierType", "barrierType", "setMargin", "margin", "toString", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class Barrier
extends HelperWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mBarrierType;
    private boolean mAllowsGoneWidget;
    private int mMargin;
    private boolean mResolved;
    public static final int $stable = 8;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private static final boolean USE_RESOLUTION = true;
    private static final boolean USE_RELAX_GONE = false;

    public Barrier() {
        this.mAllowsGoneWidget = true;
    }

    public Barrier(@NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        this();
        this.setDebugName(debugName);
    }

    @Override
    public boolean allowedInBarrier() {
        return true;
    }

    public final int getBarrierType() {
        return this.mBarrierType;
    }

    public final void setBarrierType(int barrierType) {
        this.mBarrierType = barrierType;
    }

    public final void setAllowsGoneWidget(boolean allowsGoneWidget) {
        this.mAllowsGoneWidget = allowsGoneWidget;
    }

    @Deprecated(message="This method should be called {@code getAllowsGoneWidget}\n      such that {@code allowsGoneWidget}\n      can be accessed as a property from Kotlin; {@see https://android.github\n     * .io/kotlin-guides/interop.html#property-prefixes}.\n      Use {@link #getAllowsGoneWidget()} instead.")
    public final boolean allowsGoneWidget() {
        return this.mAllowsGoneWidget;
    }

    public final boolean getAllowsGoneWidget() {
        return this.mAllowsGoneWidget;
    }

    @Override
    public boolean isResolvedHorizontally() {
        return this.mResolved;
    }

    @Override
    public boolean isResolvedVertically() {
        return this.mResolved;
    }

    @Override
    public void copy(@NotNull ConstraintWidget src, @NotNull HashMap<ConstraintWidget, ConstraintWidget> map) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        super.copy(src, map);
        Barrier srcBarrier = (Barrier)src;
        this.mBarrierType = srcBarrier.mBarrierType;
        this.mAllowsGoneWidget = srcBarrier.mAllowsGoneWidget;
        this.mMargin = srcBarrier.mMargin;
    }

    @Override
    @NotNull
    public String toString() {
        String debug = "[Barrier] " + this.getDebugName() + " {";
        int n = this.getMWidgetsCount();
        for (int i = 0; i < n; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNull((Object)this.getMWidgets()[i]);
            if (i > 0) {
                debug = debug + ", ";
            }
            debug = debug + widget.getDebugName();
        }
        debug = debug + "}";
        return debug;
    }

    public final void markWidgets$compose() {
        int n = this.getMWidgetsCount();
        for (int i = 0; i < n; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNull((Object)this.getMWidgets()[i]);
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            if (this.mBarrierType == 0 || this.mBarrierType == 1) {
                widget.setInBarrier(0, true);
                continue;
            }
            if (this.mBarrierType != 2 && this.mBarrierType != 3) continue;
            widget.setInBarrier(1, true);
        }
    }

    @Override
    public void addToSolver(@NotNull LinearSystem system, boolean optimize) {
        int i;
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        ConstraintAnchor position = null;
        this.getMListAnchors()[0] = this.getMLeft();
        this.getMListAnchors()[2] = this.getMTop();
        this.getMListAnchors()[1] = this.getMRight();
        this.getMListAnchors()[3] = this.getMBottom();
        int n = this.getMListAnchors().length;
        for (i = 0; i < n; ++i) {
            this.getMListAnchors()[i].setMSolverVariable(system.createObjectVariable(this.getMListAnchors()[i]));
        }
        i = this.mBarrierType;
        if (!(0 <= i ? i < 4 : false)) {
            return;
        }
        position = this.getMListAnchors()[this.mBarrierType];
        if (!this.mResolved) {
            this.allSolved();
        }
        if (this.mResolved) {
            this.mResolved = false;
            if (this.mBarrierType == 0 || this.mBarrierType == 1) {
                SolverVariable solverVariable = this.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                system.addEquality(solverVariable, this.getMX());
                SolverVariable solverVariable2 = this.getMRight().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable2);
                system.addEquality(solverVariable2, this.getMX());
            } else if (this.mBarrierType == 2 || this.mBarrierType == 3) {
                SolverVariable solverVariable = this.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                system.addEquality(solverVariable, this.getMY());
                SolverVariable solverVariable3 = this.getMBottom().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable3);
                system.addEquality(solverVariable3, this.getMY());
            }
            return;
        }
        boolean hasMatchConstraintWidgets = false;
        int n2 = this.getMWidgetsCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ConstraintWidget widget;
            Intrinsics.checkNotNull((Object)this.getMWidgets()[i2]);
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            if ((this.mBarrierType == 0 || this.mBarrierType == 1) && widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getMLeft().getMTarget() != null && widget.getMRight().getMTarget() != null) {
                hasMatchConstraintWidgets = true;
                break;
            }
            if (this.mBarrierType != 2 && this.mBarrierType != 3 || widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getMTop().getMTarget() == null || widget.getMBottom().getMTarget() == null) continue;
            hasMatchConstraintWidgets = true;
            break;
        }
        boolean mHasHorizontalCenteredDependents = this.getMLeft().hasCenteredDependents() || this.getMRight().hasCenteredDependents();
        boolean mHasVerticalCenteredDependents = this.getMTop().hasCenteredDependents() || this.getMBottom().hasCenteredDependents();
        boolean applyEqualityOnReferences = !hasMatchConstraintWidgets && (this.mBarrierType == 0 && mHasHorizontalCenteredDependents || this.mBarrierType == 2 && mHasVerticalCenteredDependents || this.mBarrierType == 1 && mHasHorizontalCenteredDependents || this.mBarrierType == 3 && mHasVerticalCenteredDependents);
        int equalityOnReferencesStrength = 5;
        if (!applyEqualityOnReferences) {
            equalityOnReferencesStrength = 4;
        }
        int n3 = this.getMWidgetsCount();
        for (int i3 = 0; i3 < n3; ++i3) {
            ConstraintWidget widget;
            Intrinsics.checkNotNull((Object)this.getMWidgets()[i3]);
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            SolverVariable target = system.createObjectVariable(widget.getMListAnchors()[this.mBarrierType]);
            widget.getMListAnchors()[this.mBarrierType].setMSolverVariable(target);
            int margin = 0;
            if (widget.getMListAnchors()[this.mBarrierType].getMTarget() != null) {
                ConstraintAnchor constraintAnchor = widget.getMListAnchors()[this.mBarrierType].getMTarget();
                Intrinsics.checkNotNull((Object)constraintAnchor);
                if (Intrinsics.areEqual((Object)constraintAnchor.getMOwner(), (Object)this)) {
                    margin += widget.getMListAnchors()[this.mBarrierType].getMMargin();
                }
            }
            if (this.mBarrierType == 0 || this.mBarrierType == 2) {
                SolverVariable solverVariable = position.getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                SolverVariable solverVariable4 = target;
                Intrinsics.checkNotNull((Object)solverVariable4);
                system.addLowerBarrier(solverVariable, solverVariable4, this.mMargin - margin, hasMatchConstraintWidgets);
            } else {
                SolverVariable solverVariable = position.getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                SolverVariable solverVariable5 = target;
                Intrinsics.checkNotNull((Object)solverVariable5);
                system.addGreaterBarrier(solverVariable, solverVariable5, this.mMargin + margin, hasMatchConstraintWidgets);
            }
            SolverVariable solverVariable = position.getMSolverVariable();
            Intrinsics.checkNotNull((Object)solverVariable);
            system.addEquality(solverVariable, target, this.mMargin + margin, equalityOnReferencesStrength);
        }
        int barrierParentStrength = 4;
        int barrierParentStrengthOpposite = 0;
        switch (this.mBarrierType) {
            case 0: {
                SolverVariable solverVariable = this.getMRight().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                SolverVariable solverVariable6 = this.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable6);
                system.addEquality(solverVariable, solverVariable6, 0, 8);
                SolverVariable solverVariable7 = this.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable7);
                ConstraintWidget constraintWidget = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget);
                SolverVariable solverVariable8 = constraintWidget.getMRight().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable8);
                system.addEquality(solverVariable7, solverVariable8, 0, barrierParentStrength);
                SolverVariable solverVariable9 = this.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable9);
                ConstraintWidget constraintWidget2 = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget2);
                SolverVariable solverVariable10 = constraintWidget2.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable10);
                system.addEquality(solverVariable9, solverVariable10, 0, barrierParentStrengthOpposite);
                break;
            }
            case 1: {
                SolverVariable solverVariable = this.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                SolverVariable solverVariable11 = this.getMRight().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable11);
                system.addEquality(solverVariable, solverVariable11, 0, 8);
                SolverVariable solverVariable12 = this.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable12);
                ConstraintWidget constraintWidget = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget);
                SolverVariable solverVariable13 = constraintWidget.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable13);
                system.addEquality(solverVariable12, solverVariable13, 0, barrierParentStrength);
                SolverVariable solverVariable14 = this.getMLeft().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable14);
                ConstraintWidget constraintWidget3 = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget3);
                SolverVariable solverVariable15 = constraintWidget3.getMRight().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable15);
                system.addEquality(solverVariable14, solverVariable15, 0, barrierParentStrengthOpposite);
                break;
            }
            case 2: {
                SolverVariable solverVariable = this.getMBottom().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                SolverVariable solverVariable16 = this.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable16);
                system.addEquality(solverVariable, solverVariable16, 0, 8);
                SolverVariable solverVariable17 = this.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable17);
                ConstraintWidget constraintWidget = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget);
                SolverVariable solverVariable18 = constraintWidget.getMBottom().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable18);
                system.addEquality(solverVariable17, solverVariable18, 0, barrierParentStrength);
                SolverVariable solverVariable19 = this.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable19);
                ConstraintWidget constraintWidget4 = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget4);
                SolverVariable solverVariable20 = constraintWidget4.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable20);
                system.addEquality(solverVariable19, solverVariable20, 0, barrierParentStrengthOpposite);
                break;
            }
            case 3: {
                SolverVariable solverVariable = this.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable);
                SolverVariable solverVariable21 = this.getMBottom().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable21);
                system.addEquality(solverVariable, solverVariable21, 0, 8);
                SolverVariable solverVariable22 = this.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable22);
                ConstraintWidget constraintWidget = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget);
                SolverVariable solverVariable23 = constraintWidget.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable23);
                system.addEquality(solverVariable22, solverVariable23, 0, barrierParentStrength);
                SolverVariable solverVariable24 = this.getMTop().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable24);
                ConstraintWidget constraintWidget5 = this.getParent();
                Intrinsics.checkNotNull((Object)constraintWidget5);
                SolverVariable solverVariable25 = constraintWidget5.getMBottom().getMSolverVariable();
                Intrinsics.checkNotNull((Object)solverVariable25);
                system.addEquality(solverVariable24, solverVariable25, 0, barrierParentStrengthOpposite);
            }
        }
    }

    public final void setMargin(int margin) {
        this.mMargin = margin;
    }

    public final int getMargin() {
        return this.mMargin;
    }

    public final int getOrientation() {
        switch (this.mBarrierType) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public final boolean allSolved() {
        boolean hasAllWidgetsResolved = true;
        int n = this.getMWidgetsCount();
        for (int i = 0; i < n; ++i) {
            ConstraintWidget widget;
            Intrinsics.checkNotNull((Object)this.getMWidgets()[i]);
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            if (!(this.mBarrierType != 0 && this.mBarrierType != 1 || widget.isResolvedHorizontally())) {
                hasAllWidgetsResolved = false;
                continue;
            }
            if (this.mBarrierType != 2 && this.mBarrierType != 3 || widget.isResolvedVertically()) continue;
            hasAllWidgetsResolved = false;
        }
        if (hasAllWidgetsResolved && this.getMWidgetsCount() > 0) {
            int barrierPosition = 0;
            boolean initialized = false;
            int n2 = this.getMWidgetsCount();
            block13: for (int i = 0; i < n2; ++i) {
                ConstraintWidget widget;
                Intrinsics.checkNotNull((Object)this.getMWidgets()[i]);
                if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
                if (!initialized) {
                    switch (this.mBarrierType) {
                        case 0: {
                            ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.LEFT);
                            Intrinsics.checkNotNull((Object)constraintAnchor);
                            barrierPosition = constraintAnchor.getFinalValue();
                            break;
                        }
                        case 1: {
                            ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
                            Intrinsics.checkNotNull((Object)constraintAnchor);
                            barrierPosition = constraintAnchor.getFinalValue();
                            break;
                        }
                        case 2: {
                            ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.TOP);
                            Intrinsics.checkNotNull((Object)constraintAnchor);
                            barrierPosition = constraintAnchor.getFinalValue();
                            break;
                        }
                        case 3: {
                            ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
                            Intrinsics.checkNotNull((Object)constraintAnchor);
                            barrierPosition = constraintAnchor.getFinalValue();
                        }
                    }
                    initialized = true;
                }
                switch (this.mBarrierType) {
                    case 0: {
                        ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.LEFT);
                        Intrinsics.checkNotNull((Object)constraintAnchor);
                        barrierPosition = Math.min(barrierPosition, constraintAnchor.getFinalValue());
                        continue block13;
                    }
                    case 1: {
                        ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
                        Intrinsics.checkNotNull((Object)constraintAnchor);
                        barrierPosition = Math.max(barrierPosition, constraintAnchor.getFinalValue());
                        continue block13;
                    }
                    case 2: {
                        ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.TOP);
                        Intrinsics.checkNotNull((Object)constraintAnchor);
                        barrierPosition = Math.min(barrierPosition, constraintAnchor.getFinalValue());
                        continue block13;
                    }
                    case 3: {
                        ConstraintAnchor constraintAnchor = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
                        Intrinsics.checkNotNull((Object)constraintAnchor);
                        barrierPosition = Math.max(barrierPosition, constraintAnchor.getFinalValue());
                    }
                }
            }
            barrierPosition += this.mMargin;
            if (this.mBarrierType == 0 || this.mBarrierType == 1) {
                this.setFinalHorizontal(barrierPosition, barrierPosition);
            } else {
                this.setFinalVertical(barrierPosition, barrierPosition);
            }
            this.mResolved = true;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/constraintlayout/core/widgets/Barrier$Companion;", "", "()V", "BOTTOM", "", "LEFT", "RIGHT", "TOP", "USE_RELAX_GONE", "", "USE_RESOLUTION", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

