/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.utils.GridCore;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b.\n\u0002\u0010\u0014\n\u0002\b\u0015\n\u0002\u0010\r\n\u0002\b\u0006\b\u0007\u0018\u0000 x2\u00020\u0001:\u0001xB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0015H\u0016J\b\u00100\u001a\u00020+H\u0002J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\tH\u0002J\u0010\u00103\u001a\u00020+2\u0006\u00102\u001a\u00020\tH\u0002J0\u00104\u001a\u00020+2\u0006\u00102\u001a\u00020\t2\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0002J\b\u00109\u001a\u00020+H\u0002J\u0010\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020\u0015H\u0002J\u0010\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0002J\b\u0010>\u001a\u0004\u0018\u00010\fJ\b\u0010?\u001a\u0004\u0018\u00010\u0013J\b\u0010@\u001a\u0004\u0018\u00010\u0010J\u0006\u0010A\u001a\u00020\u0018J\b\u0010B\u001a\u00020\u0003H\u0002J\u0006\u0010C\u001a\u00020\u0003J\u0010\u0010D\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0002J\b\u0010E\u001a\u0004\u0018\u00010\fJ\u0006\u0010F\u001a\u00020\u0018J\b\u0010G\u001a\u00020+H\u0002J\u001b\u0010H\u001a\u00020+2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0002\u00a2\u0006\u0002\u0010JJ\u001b\u0010K\u001a\u00020+2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0002\u00a2\u0006\u0002\u0010JJ\b\u0010M\u001a\u00020+H\u0002J\b\u0010N\u001a\u00020+H\u0002J(\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u00032\u0006\u0010Q\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0002J\b\u0010R\u001a\u00020\tH\u0002J(\u0010S\u001a\u00020+2\u0006\u0010T\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u00032\u0006\u0010W\u001a\u00020\u0003H\u0016J%\u0010X\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\b2\u0006\u0010Y\u001a\u00020\f2\u0006\u0010Z\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010[J\u001c\u0010\\\u001a\u0004\u0018\u00010]2\u0006\u0010^\u001a\u00020\u00032\b\u0010Y\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010_\u001a\u00020+H\u0002J\b\u0010`\u001a\u00020+H\u0002J\u000e\u0010a\u001a\u00020+2\u0006\u0010b\u001a\u00020\fJ\u000e\u0010c\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010d\u001a\u00020+2\u0006\u0010e\u001a\u00020\u0013J\u000e\u0010f\u001a\u00020+2\u0006\u0010g\u001a\u00020\u0010J\u000e\u0010h\u001a\u00020+2\u0006\u0010i\u001a\u00020\u0018J\u000e\u0010j\u001a\u00020+2\u0006\u0010k\u001a\u00020\u0003J\u000e\u0010l\u001a\u00020+2\u0006\u0010m\u001a\u00020\fJ\u000e\u0010n\u001a\u00020+2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010o\u001a\u00020+2\u0006\u0010p\u001a\u00020\fJ\u000e\u0010q\u001a\u00020+2\u0006\u0010r\u001a\u00020sJ\u000e\u0010t\u001a\u00020+2\u0006\u0010u\u001a\u00020\u0018J\u0010\u0010v\u001a\u00020+2\u0006\u0010;\u001a\u00020\u0015H\u0002J\b\u0010w\u001a\u00020+H\u0002R\u001a\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010&\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Landroidx/constraintlayout/core/utils/GridCore;", "Landroidx/constraintlayout/core/widgets/VirtualLayout;", "rows", "", "columns", "(II)V", "()V", "mBoxWidgets", "", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "[Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "mColumnWeights", "", "mColumns", "mColumnsSet", "mConstraintMatrix", "", "[[I", "mContainer", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "mExtraSpaceHandled", "", "mFlags", "mHorizontalGaps", "", "mNextAvailableIndex", "mOrientation", "mPositionMatrix", "", "[[Z", "mRowWeights", "mRows", "mRowsSet", "mSkips", "mSpanIds", "", "mSpanIndex", "mSpanMatrix", "mSpans", "mSpansRespectWidgetOrder", "mSubGridByColRow", "mVerticalGaps", "addConstraints", "", "addToSolver", "system", "Landroidx/constraintlayout/core/LinearSystem;", "optimize", "arrangeWidgets", "clearHorizontalAttributes", "widget", "clearVerticalAttributes", "connectWidget", "row", "column", "rowSpan", "columnSpan", "createBoxes", "fillConstraintMatrix", "isUpdate", "getColByIndex", "index", "getColumnWeights", "getContainer", "getFlags", "getHorizontalGaps", "getNextPosition", "getOrientation", "getRowByIndex", "getRowWeights", "getVerticalGaps", "handleFlags", "handleSkips", "skipsMatrix", "([[I)V", "handleSpans", "spansMatrix", "initMatrices", "initVariables", "invalidatePositions", "startRow", "startColumn", "makeNewWidget", "measure", "widthMode", "widthSize", "heightMode", "heightSize", "parseSpans", "str", "isSpans", "(Ljava/lang/String;Z)[[I", "parseWeights", "", "size", "setBoxWidgetHorizontalChains", "setBoxWidgetVerticalChains", "setColumnWeights", "columnWeights", "setColumns", "setContainer", "container", "setFlags", "flags", "setHorizontalGaps", "horizontalGaps", "setOrientation", "orientation", "setRowWeights", "rowWeights", "setRows", "setSkips", "skips", "setSpans", "spans", "", "setVerticalGaps", "verticalGaps", "setupGrid", "updateActualRowsAndColumns", "Companion", "compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGridCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridCore.kt\nandroidx/constraintlayout/core/utils/GridCore\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1007:1\n107#2:1008\n79#2,22:1009\n107#2:1031\n79#2,22:1032\n107#2:1054\n79#2,22:1055\n107#2:1088\n79#2,22:1089\n107#2:1122\n79#2,22:1123\n107#2:1156\n79#2,22:1157\n107#2:1201\n79#2,22:1202\n107#2:1225\n79#2,22:1226\n731#3,9:1077\n731#3,9:1111\n731#3,9:1145\n731#3,9:1179\n731#3,9:1190\n37#4,2:1086\n37#4,2:1120\n37#4,2:1154\n37#4,2:1188\n37#4,2:1199\n37#4,2:1248\n1#5:1224\n*S KotlinDebug\n*F\n+ 1 GridCore.kt\nandroidx/constraintlayout/core/utils/GridCore\n*L\n472#1:1008\n472#1:1009,22\n478#1:1031\n478#1:1032,22\n575#1:1054\n575#1:1055,22\n585#1:1088\n585#1:1089,22\n871#1:1122\n871#1:1123,22\n902#1:1156\n902#1:1157,22\n942#1:1201\n942#1:1202,22\n946#1:1225\n946#1:1226,22\n578#1:1077,9\n854#1:1111,9\n872#1:1145,9\n903#1:1179,9\n905#1:1190,9\n579#1:1086,2\n855#1:1120,2\n873#1:1154,2\n904#1:1188,2\n906#1:1199,2\n987#1:1248,2\n*E\n"})
public final class GridCore
extends VirtualLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ConstraintWidgetContainer mContainer;
    @Nullable
    private ConstraintWidget[] mBoxWidgets;
    private boolean mExtraSpaceHandled;
    private int mRows;
    private int mRowsSet;
    private int mColumns;
    private int mColumnsSet;
    private float mHorizontalGaps;
    private float mVerticalGaps;
    @Nullable
    private String mRowWeights;
    @Nullable
    private String mColumnWeights;
    @Nullable
    private String mSpans;
    @Nullable
    private String mSkips;
    private int mOrientation;
    private int mNextAvailableIndex;
    @Nullable
    private boolean[][] mPositionMatrix;
    @NotNull
    private Set<String> mSpanIds = new HashSet();
    @Nullable
    private int[][] mConstraintMatrix;
    @Nullable
    private int[] mFlags;
    @Nullable
    private int[][] mSpanMatrix;
    private int mSpanIndex;
    private boolean mSpansRespectWidgetOrder;
    private boolean mSubGridByColRow;
    public static final int $stable = 8;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SUB_GRID_BY_COL_ROW = 0;
    public static final int SPANS_RESPECT_WIDGET_ORDER = 1;
    private static final int DEFAULT_SIZE = 3;
    private static final int MAX_ROWS = 50;
    private static final int MAX_COLUMNS = 50;

    public GridCore() {
        this.updateActualRowsAndColumns();
        this.initMatrices();
    }

    public GridCore(int rows, int columns) {
        this();
        this.mRowsSet = rows;
        this.mColumnsSet = columns;
        if (rows > 50) {
            this.mRowsSet = 3;
        }
        if (columns > 50) {
            this.mColumnsSet = 3;
        }
    }

    @Nullable
    public final ConstraintWidgetContainer getContainer() {
        return this.mContainer;
    }

    public final void setContainer(@NotNull ConstraintWidgetContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.mContainer = container;
    }

    public final void setSpans(@NotNull CharSequence spans) {
        Intrinsics.checkNotNullParameter((Object)spans, (String)"spans");
        if (this.mSpans != null && Intrinsics.areEqual((Object)this.mSpans, (Object)((Object)spans).toString())) {
            return;
        }
        this.mExtraSpaceHandled = false;
        this.mSpans = ((Object)spans).toString();
    }

    public final void setSkips(@NotNull String skips) {
        Intrinsics.checkNotNullParameter((Object)skips, (String)"skips");
        if (this.mSkips != null && Intrinsics.areEqual((Object)this.mSkips, (Object)skips)) {
            return;
        }
        this.mExtraSpaceHandled = false;
        this.mSkips = skips;
    }

    public final float getHorizontalGaps() {
        return this.mHorizontalGaps;
    }

    public final void setHorizontalGaps(float horizontalGaps) {
        if (horizontalGaps < 0.0f) {
            return;
        }
        if (this.mHorizontalGaps == horizontalGaps) {
            return;
        }
        this.mHorizontalGaps = horizontalGaps;
    }

    public final float getVerticalGaps() {
        return this.mVerticalGaps;
    }

    public final void setVerticalGaps(float verticalGaps) {
        if (verticalGaps < 0.0f) {
            return;
        }
        if (this.mVerticalGaps == verticalGaps) {
            return;
        }
        this.mVerticalGaps = verticalGaps;
    }

    @Nullable
    public final String getRowWeights() {
        return this.mRowWeights;
    }

    public final void setRowWeights(@NotNull String rowWeights) {
        Intrinsics.checkNotNullParameter((Object)rowWeights, (String)"rowWeights");
        if (this.mRowWeights != null && Intrinsics.areEqual((Object)this.mRowWeights, (Object)rowWeights)) {
            return;
        }
        this.mRowWeights = rowWeights;
    }

    @Nullable
    public final String getColumnWeights() {
        return this.mColumnWeights;
    }

    public final void setColumnWeights(@NotNull String columnWeights) {
        Intrinsics.checkNotNullParameter((Object)columnWeights, (String)"columnWeights");
        if (this.mColumnWeights != null && Intrinsics.areEqual((Object)this.mColumnWeights, (Object)columnWeights)) {
            return;
        }
        this.mColumnWeights = columnWeights;
    }

    public final int getOrientation() {
        return this.mOrientation;
    }

    public final void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            return;
        }
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
    }

    public final void setRows(int rows) {
        if (rows > 50) {
            return;
        }
        if (this.mRowsSet == rows) {
            return;
        }
        this.mRowsSet = rows;
        this.updateActualRowsAndColumns();
        this.initVariables();
    }

    public final void setColumns(int columns) {
        if (columns > 50) {
            return;
        }
        if (this.mColumnsSet == columns) {
            return;
        }
        this.mColumnsSet = columns;
        this.updateActualRowsAndColumns();
        this.initVariables();
    }

    @Nullable
    public final int[] getFlags() {
        return this.mFlags;
    }

    public final void setFlags(@NotNull int[] flags) {
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        this.mFlags = flags;
    }

    private final void handleSpans(int[][] spansMatrix) {
        if (this.mSpansRespectWidgetOrder) {
            return;
        }
        int n = ((Object[])spansMatrix).length;
        for (int i = 0; i < n; ++i) {
            int col;
            int row = this.getRowByIndex(spansMatrix[i][0]);
            if (!this.invalidatePositions(row, col = this.getColByIndex(spansMatrix[i][0]), spansMatrix[i][1], spansMatrix[i][2])) {
                return;
            }
            ConstraintWidget constraintWidget = this.getMWidgets()[i];
            Intrinsics.checkNotNull((Object)constraintWidget);
            this.connectWidget(constraintWidget, row, col, spansMatrix[i][1], spansMatrix[i][2]);
            ConstraintWidget constraintWidget2 = this.getMWidgets()[i];
            Intrinsics.checkNotNull((Object)constraintWidget2);
            String string2 = constraintWidget2.getStringId();
            Intrinsics.checkNotNull((Object)string2);
            this.mSpanIds.add(string2);
        }
    }

    private final void arrangeWidgets() {
        int position = 0;
        int n = this.getMWidgetsCount();
        for (int i = 0; i < n; ++i) {
            Iterable iterable = this.mSpanIds;
            ConstraintWidget constraintWidget = this.getMWidgets()[i];
            Intrinsics.checkNotNull((Object)constraintWidget);
            if (CollectionsKt.contains((Iterable)iterable, (Object)constraintWidget.getStringId())) continue;
            position = this.getNextPosition();
            int row = this.getRowByIndex(position);
            int col = this.getColByIndex(position);
            if (position == -1) {
                return;
            }
            if (this.mSpansRespectWidgetOrder && this.mSpanMatrix != null) {
                Intrinsics.checkNotNull((Object)this.mSpanMatrix);
                if (this.mSpanIndex < ((Object[])this.mSpanMatrix).length) {
                    Intrinsics.checkNotNull((Object)this.mSpanMatrix);
                    if (this.mSpanMatrix[this.mSpanIndex][0] == position) {
                        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                        this.mPositionMatrix[row][col] = true;
                        Intrinsics.checkNotNull((Object)this.mSpanMatrix);
                        int n2 = this.mSpanMatrix[this.mSpanIndex][1];
                        Intrinsics.checkNotNull((Object)this.mSpanMatrix);
                        if (!this.invalidatePositions(row, col, n2, this.mSpanMatrix[this.mSpanIndex][2])) continue;
                        ConstraintWidget constraintWidget2 = this.getMWidgets()[i];
                        Intrinsics.checkNotNull((Object)constraintWidget2);
                        Intrinsics.checkNotNull((Object)this.mSpanMatrix);
                        int n3 = this.mSpanMatrix[this.mSpanIndex][1];
                        Intrinsics.checkNotNull((Object)this.mSpanMatrix);
                        this.connectWidget(constraintWidget2, row, col, n3, this.mSpanMatrix[this.mSpanIndex][2]);
                        int n4 = this.mSpanIndex;
                        this.mSpanIndex = n4 + 1;
                        continue;
                    }
                }
            }
            ConstraintWidget constraintWidget3 = this.getMWidgets()[i];
            Intrinsics.checkNotNull((Object)constraintWidget3);
            this.connectWidget(constraintWidget3, row, col, 1, 1);
        }
    }

    private final void setupGrid(boolean isUpdate) {
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        boolean startFound$iv$iv;
        int endIndex$iv$iv;
        int startIndex$iv$iv;
        boolean $i$f$trim;
        boolean $i$f$trim2;
        if (this.mRows < 1 || this.mColumns < 1) {
            return;
        }
        this.handleFlags();
        if (isUpdate) {
            Intrinsics.checkNotNull((Object)this.mPositionMatrix);
            int n = ((Object[])this.mPositionMatrix).length;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                int n2 = this.mPositionMatrix[0].length;
                for (int j = 0; j < n2; ++j) {
                    Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                    this.mPositionMatrix[i][j] = true;
                }
            }
            this.mSpanIds.clear();
        }
        this.mNextAvailableIndex = 0;
        if (this.mSkips != null) {
            String string2 = this.mSkips;
            Intrinsics.checkNotNull((Object)string2);
            String $this$trim$iv = string2;
            $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) {
                String string3 = this.mSkips;
                Intrinsics.checkNotNull((Object)string3);
                int[][] mSkips = this.parseSpans(string3, false);
                if (mSkips != null) {
                    this.handleSkips(mSkips);
                }
            }
        }
        if (this.mSpans != null) {
            String string4 = this.mSpans;
            Intrinsics.checkNotNull((Object)string4);
            String $this$trim$iv = string4;
            $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) {
                String string5 = this.mSpans;
                Intrinsics.checkNotNull((Object)string5);
                this.mSpanMatrix = this.parseSpans(string5, true);
            }
        }
        this.createBoxes();
        if (this.mSpanMatrix != null) {
            Intrinsics.checkNotNull((Object)this.mSpanMatrix);
            this.handleSpans(this.mSpanMatrix);
        }
    }

    private final int getRowByIndex(int index) {
        return this.mOrientation == 1 ? index % this.mRows : index / this.mColumns;
    }

    private final int getColByIndex(int index) {
        return this.mOrientation == 1 ? index / this.mRows : index % this.mColumns;
    }

    private final void handleSkips(int[][] skipsMatrix) {
        int n = ((Object[])skipsMatrix).length;
        for (int i = 0; i < n; ++i) {
            int col;
            int[] matrix = skipsMatrix[i];
            int row = this.getRowByIndex(matrix[0]);
            if (this.invalidatePositions(row, col = this.getColByIndex(matrix[0]), matrix[1], matrix[2])) continue;
            return;
        }
    }

    private final boolean invalidatePositions(int startRow, int startColumn, int rowSpan, int columnSpan) {
        int n = startRow + rowSpan;
        for (int i = startRow; i < n; ++i) {
            int n2 = startColumn + columnSpan;
            for (int j = startColumn; j < n2; ++j) {
                block5: {
                    block4: {
                        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                        if (i >= ((Object[])this.mPositionMatrix).length) break block4;
                        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                        if (j >= this.mPositionMatrix[0].length) break block4;
                        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                        if (this.mPositionMatrix[i][j]) break block5;
                    }
                    return false;
                }
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                this.mPositionMatrix[i][j] = false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final float[] parseWeights(int size, String str) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        int $i$f$trim;
        CharSequence $this$trim$iv$iv;
        block15: {
            block14: {
                if (str == null) break block14;
                String $this$trim$iv = str;
                boolean $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = 0;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block15;
            }
            return null;
        }
        Object $i$f$trim2 = str;
        $this$trim$iv$iv = new Regex(",");
        $i$f$trim = 0;
        $i$f$trim2 = $this$trim$iv$iv.split((CharSequence)$i$f$trim2, $i$f$trim);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] values = thisCollection$iv.toArray(new String[0]);
        if (values.length != size) {
            return null;
        }
        float[] arr = new float[size];
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            void $this$trim$iv;
            String it = values[i];
            int n2 = i;
            float[] fArray = arr;
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it2 = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            fArray[n2] = Float.parseFloat(string2);
        }
        return arr;
    }

    private final int getNextPosition() {
        int position = 0;
        boolean positionFound = false;
        while (!positionFound) {
            if (this.mNextAvailableIndex >= this.mRows * this.mColumns) {
                return -1;
            }
            position = this.mNextAvailableIndex;
            int row = this.getRowByIndex(this.mNextAvailableIndex);
            int col = this.getColByIndex(this.mNextAvailableIndex);
            Intrinsics.checkNotNull((Object)this.mPositionMatrix);
            if (this.mPositionMatrix[row][col]) {
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                this.mPositionMatrix[row][col] = false;
                positionFound = true;
            }
            int n = this.mNextAvailableIndex;
            this.mNextAvailableIndex = n + 1;
        }
        return position;
    }

    private final void updateActualRowsAndColumns() {
        if (this.mRowsSet == 0 || this.mColumnsSet == 0) {
            if (this.mColumnsSet > 0) {
                this.mColumns = this.mColumnsSet;
                this.mRows = (this.getMWidgetsCount() + this.mColumns - 1) / this.mColumnsSet;
            } else if (this.mRowsSet > 0) {
                this.mRows = this.mRowsSet;
                this.mColumns = (this.getMWidgetsCount() + this.mRowsSet - 1) / this.mRowsSet;
            } else {
                this.mRows = (int)(1.5 + Math.sqrt(this.getMWidgetsCount()));
                this.mColumns = (this.getMWidgetsCount() + this.mRows - 1) / this.mRows;
            }
        } else {
            this.mRows = this.mRowsSet;
            this.mColumns = this.mColumnsSet;
        }
    }

    private final ConstraintWidget makeNewWidget() {
        ConstraintWidget widget = new ConstraintWidget();
        widget.getMListDimensionBehaviors()[0] = ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        widget.getMListDimensionBehaviors()[1] = ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        widget.setStringId(String.valueOf(widget.hashCode()));
        return widget;
    }

    private final void connectWidget(ConstraintWidget widget, int row, int column, int rowSpan, int columnSpan) {
        ConstraintAnchor constraintAnchor = widget.getMLeft();
        Intrinsics.checkNotNull((Object)this.mBoxWidgets);
        ConstraintWidget constraintWidget = this.mBoxWidgets[column];
        Intrinsics.checkNotNull((Object)constraintWidget);
        constraintAnchor.connect(constraintWidget.getMLeft(), 0);
        ConstraintAnchor constraintAnchor2 = widget.getMTop();
        Intrinsics.checkNotNull((Object)this.mBoxWidgets);
        ConstraintWidget constraintWidget2 = this.mBoxWidgets[row];
        Intrinsics.checkNotNull((Object)constraintWidget2);
        constraintAnchor2.connect(constraintWidget2.getMTop(), 0);
        ConstraintAnchor constraintAnchor3 = widget.getMRight();
        Intrinsics.checkNotNull((Object)this.mBoxWidgets);
        ConstraintWidget constraintWidget3 = this.mBoxWidgets[column + columnSpan - 1];
        Intrinsics.checkNotNull((Object)constraintWidget3);
        constraintAnchor3.connect(constraintWidget3.getMRight(), 0);
        ConstraintAnchor constraintAnchor4 = widget.getMBottom();
        Intrinsics.checkNotNull((Object)this.mBoxWidgets);
        ConstraintWidget constraintWidget4 = this.mBoxWidgets[row + rowSpan - 1];
        Intrinsics.checkNotNull((Object)constraintWidget4);
        constraintAnchor4.connect(constraintWidget4.getMBottom(), 0);
    }

    private final void setBoxWidgetHorizontalChains() {
        int i;
        int maxVal = Math.max(this.mRows, this.mColumns);
        Intrinsics.checkNotNull((Object)this.mBoxWidgets);
        ConstraintWidget constraintWidget = this.mBoxWidgets[0];
        Intrinsics.checkNotNull((Object)constraintWidget);
        ConstraintWidget widget = constraintWidget;
        float[] columnWeights = this.parseWeights(this.mColumns, this.mColumnWeights);
        if (this.mColumns == 1) {
            this.clearHorizontalAttributes(widget);
            widget.getMLeft().connect(this.getMLeft(), 0);
            widget.getMRight().connect(this.getMRight(), 0);
            return;
        }
        int n = this.mColumns;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mBoxWidgets);
            Intrinsics.checkNotNull((Object)this.mBoxWidgets[i]);
            this.clearHorizontalAttributes(widget);
            if (columnWeights != null) {
                widget.setHorizontalWeight(columnWeights[i]);
            }
            if (i > 0) {
                ConstraintAnchor constraintAnchor = widget.getMLeft();
                Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                ConstraintWidget constraintWidget2 = this.mBoxWidgets[i - 1];
                Intrinsics.checkNotNull((Object)constraintWidget2);
                constraintAnchor.connect(constraintWidget2.getMRight(), 0);
            } else {
                widget.getMLeft().connect(this.getMLeft(), 0);
            }
            if (i < this.mColumns - 1) {
                ConstraintAnchor constraintAnchor = widget.getMRight();
                Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                ConstraintWidget constraintWidget3 = this.mBoxWidgets[i + 1];
                Intrinsics.checkNotNull((Object)constraintWidget3);
                constraintAnchor.connect(constraintWidget3.getMLeft(), 0);
            } else {
                widget.getMRight().connect(this.getMRight(), 0);
            }
            if (i <= 0) continue;
            widget.getMLeft().setMMargin((int)this.mHorizontalGaps);
        }
        for (i = this.mColumns; i < maxVal; ++i) {
            Intrinsics.checkNotNull((Object)this.mBoxWidgets);
            Intrinsics.checkNotNull((Object)this.mBoxWidgets[i]);
            this.clearHorizontalAttributes(widget);
            widget.getMLeft().connect(this.getMLeft(), 0);
            widget.getMRight().connect(this.getMRight(), 0);
        }
    }

    private final void setBoxWidgetVerticalChains() {
        int i;
        int maxVal = Math.max(this.mRows, this.mColumns);
        Intrinsics.checkNotNull((Object)this.mBoxWidgets);
        ConstraintWidget constraintWidget = this.mBoxWidgets[0];
        Intrinsics.checkNotNull((Object)constraintWidget);
        ConstraintWidget widget = constraintWidget;
        float[] rowWeights = this.parseWeights(this.mRows, this.mRowWeights);
        if (this.mRows == 1) {
            this.clearVerticalAttributes(widget);
            widget.getMTop().connect(this.getMTop(), 0);
            widget.getMBottom().connect(this.getMBottom(), 0);
            return;
        }
        int n = this.mRows;
        for (i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mBoxWidgets);
            Intrinsics.checkNotNull((Object)this.mBoxWidgets[i]);
            this.clearVerticalAttributes(widget);
            if (rowWeights != null) {
                widget.setVerticalWeight(rowWeights[i]);
            }
            if (i > 0) {
                ConstraintAnchor constraintAnchor = widget.getMTop();
                Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                ConstraintWidget constraintWidget2 = this.mBoxWidgets[i - 1];
                Intrinsics.checkNotNull((Object)constraintWidget2);
                constraintAnchor.connect(constraintWidget2.getMBottom(), 0);
            } else {
                widget.getMTop().connect(this.getMTop(), 0);
            }
            if (i < this.mRows - 1) {
                ConstraintAnchor constraintAnchor = widget.getMBottom();
                Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                ConstraintWidget constraintWidget3 = this.mBoxWidgets[i + 1];
                Intrinsics.checkNotNull((Object)constraintWidget3);
                constraintAnchor.connect(constraintWidget3.getMTop(), 0);
            } else {
                widget.getMBottom().connect(this.getMBottom(), 0);
            }
            if (i <= 0) continue;
            widget.getMTop().setMMargin((int)this.mVerticalGaps);
        }
        for (i = this.mRows; i < maxVal; ++i) {
            Intrinsics.checkNotNull((Object)this.mBoxWidgets);
            Intrinsics.checkNotNull((Object)this.mBoxWidgets[i]);
            this.clearVerticalAttributes(widget);
            widget.getMTop().connect(this.getMTop(), 0);
            widget.getMBottom().connect(this.getMBottom(), 0);
        }
    }

    private final void addConstraints() {
        this.setBoxWidgetVerticalChains();
        this.setBoxWidgetHorizontalChains();
        this.arrangeWidgets();
    }

    private final void createBoxes() {
        int boxCount = Math.max(this.mRows, this.mColumns);
        if (this.mBoxWidgets == null) {
            this.mBoxWidgets = new ConstraintWidget[boxCount];
            Intrinsics.checkNotNull((Object)this.mBoxWidgets);
            int n = this.mBoxWidgets.length;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                this.mBoxWidgets[i] = this.makeNewWidget();
            }
        } else {
            Intrinsics.checkNotNull((Object)this.mBoxWidgets);
            if (boxCount != this.mBoxWidgets.length) {
                ConstraintWidget[] temp = new ConstraintWidget[boxCount];
                for (int i = 0; i < boxCount; ++i) {
                    Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                    if (i < this.mBoxWidgets.length) {
                        Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                        temp[i] = this.mBoxWidgets[i];
                        continue;
                    }
                    temp[i] = this.makeNewWidget();
                }
                Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                int n = this.mBoxWidgets.length;
                for (int j = boxCount; j < n; ++j) {
                    Intrinsics.checkNotNull((Object)this.mBoxWidgets);
                    ConstraintWidget widget = this.mBoxWidgets[j];
                    ConstraintWidgetContainer constraintWidgetContainer = this.mContainer;
                    Intrinsics.checkNotNull((Object)constraintWidgetContainer);
                    ConstraintWidget constraintWidget = widget;
                    Intrinsics.checkNotNull((Object)constraintWidget);
                    constraintWidgetContainer.remove(constraintWidget);
                }
                this.mBoxWidgets = temp;
            }
        }
    }

    private final void clearVerticalAttributes(ConstraintWidget widget) {
        widget.setVerticalWeight(-1.0f);
        widget.getMTop().reset();
        widget.getMBottom().reset();
        widget.getMBaseline().reset();
    }

    private final void clearHorizontalAttributes(ConstraintWidget widget) {
        widget.setHorizontalWeight(-1.0f);
        widget.getMLeft().reset();
        widget.getMRight().reset();
    }

    private final void initVariables() {
        int n = 0;
        int n2 = this.mRows;
        boolean[][] blArrayArray = new boolean[n2][];
        GridCore gridCore = this;
        while (n < n2) {
            int n3 = n++;
            blArrayArray[n3] = new boolean[this.mColumns];
        }
        gridCore.mPositionMatrix = blArrayArray;
        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
        boolean[][] blArray = this.mPositionMatrix;
        int n4 = ((Object[])blArray).length;
        for (n2 = 0; n2 < n4; ++n2) {
            boolean[] row = blArray[n2];
            ArraysKt.fill$default((boolean[])row, (boolean)true, (int)0, (int)0, (int)6, null);
        }
        if (this.getMWidgetsCount() > 0) {
            int n5 = 0;
            n2 = this.getMWidgetsCount();
            int[][] nArrayArray = new int[n2][];
            gridCore = this;
            while (n5 < n2) {
                int row = n5++;
                nArrayArray[row] = new int[4];
            }
            gridCore.mConstraintMatrix = nArrayArray;
            Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
            int[][] nArray = this.mConstraintMatrix;
            int n6 = ((Object[])nArray).length;
            for (n2 = 0; n2 < n6; ++n2) {
                int[] row = nArray[n2];
                ArraysKt.fill$default((int[])row, (int)-1, (int)0, (int)0, (int)6, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int[][] parseSpans(String str, boolean isSpans) {
        Object object;
        try {
            void $this$toTypedArray$iv;
            List list;
            int n;
            Object it2;
            Collection $this$dropLastWhile$iv;
            int extraRows = 0;
            int extraColumns = 0;
            Object object2 = str;
            Regex regex = new Regex(",");
            int n2 = 0;
            object2 = regex.split((CharSequence)object2, n2);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it2 = (String)iterator$iv.previous();
                    n = 0;
                    if (((CharSequence)it2).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            int $i$f$toTypedArray = 0;
            void thisCollection$iv22 = $this$toTypedArray$iv;
            Object[] spans = thisCollection$iv22.toArray(new String[0]);
            ArraysKt.sortWith((Object[])spans, (arg_0, arg_1) -> GridCore.parseSpans$lambda$6(parseSpans.1.INSTANCE, arg_0, arg_1));
            $i$f$toTypedArray = 0;
            int thisCollection$iv22 = spans.length;
            it2 = new int[thisCollection$iv22][];
            while ($i$f$toTypedArray < thisCollection$iv22) {
                n = $i$f$toTypedArray++;
                it2[n] = new int[3];
            }
            Object spanMatrix = it2;
            String[] indexAndSpan = null;
            if (this.mRows == 1 || this.mColumns == 1) {
                int it2 = spans.length;
                for (int i = 0; i < it2; ++i) {
                    void $this$toTypedArray$iv2;
                    List list2;
                    Collection $this$dropLastWhile$iv2;
                    Object $this$trim$iv = spans[i];
                    boolean $i$f$trim22 = false;
                    CharSequence $this$trim$iv$iv22 = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv22.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it3 = $this$trim$iv$iv22.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it3, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $this$trim$iv = ((Object)$this$trim$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    Regex $i$f$trim22 = new Regex(":");
                    int $this$trim$iv$iv22 = 0;
                    $this$trim$iv = $i$f$trim22.split((CharSequence)$this$trim$iv, $this$trim$iv$iv22);
                    boolean $i$f$dropLastWhile2 = false;
                    if (!$this$dropLastWhile$iv2.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                        while (iterator$iv.hasPrevious()) {
                            String it4 = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it4).length() == 0) continue;
                            list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv2 = list2;
                    boolean $i$f$toTypedArray2 = false;
                    void thisCollection$iv = $this$toTypedArray$iv2;
                    indexAndSpan = thisCollection$iv.toArray(new String[0]);
                    spanMatrix[i][0] = Integer.parseInt(indexAndSpan[0]);
                    spanMatrix[i][1] = true;
                    spanMatrix[i][2] = true;
                    if (this.mColumns == 1) {
                        spanMatrix[i][1] = Integer.parseInt(indexAndSpan[1]);
                        extraRows += spanMatrix[i][1];
                        if (isSpans) {
                            --extraRows;
                        }
                    }
                    if (this.mRows != 1) continue;
                    spanMatrix[i][2] = Integer.parseInt(indexAndSpan[1]);
                    extraColumns += spanMatrix[i][2];
                    if (!isSpans) continue;
                    --extraColumns;
                }
                if (extraRows != 0 && !this.mExtraSpaceHandled) {
                    this.setRows(this.mRows + extraRows);
                }
                if (extraColumns != 0 && !this.mExtraSpaceHandled) {
                    this.setColumns(this.mColumns + extraColumns);
                }
                this.mExtraSpaceHandled = true;
            } else {
                String[] rowAndCol = null;
                for (Object $this$trim$iv : spans) {
                    List list3;
                    Object $this$toTypedArray$iv3;
                    List list4;
                    Collection $this$dropLastWhile$iv3;
                    boolean $i$f$trim32 = false;
                    CharSequence $this$trim$iv$iv32 = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv32.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it5 = $this$trim$iv$iv32.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it5, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $this$trim$iv = ((Object)$this$trim$iv$iv32.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    Regex $i$f$trim32 = new Regex(":");
                    int $this$trim$iv$iv32 = 0;
                    $this$trim$iv = $i$f$trim32.split((CharSequence)$this$trim$iv, $this$trim$iv$iv32);
                    boolean $i$f$dropLastWhile3 = false;
                    if (!$this$dropLastWhile$iv3.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv3.listIterator($this$dropLastWhile$iv3.size());
                        while (iterator$iv.hasPrevious()) {
                            String it6 = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it6).length() == 0) continue;
                            list4 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv3, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list4 = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv3 = list4;
                    boolean $i$f$toTypedArray22 = false;
                    void thisCollection$iv32 = $this$toTypedArray$iv3;
                    indexAndSpan = thisCollection$iv32.toArray(new String[0]);
                    $this$toTypedArray$iv3 = indexAndSpan[1];
                    Regex $i$f$toTypedArray22 = new Regex("x");
                    int thisCollection$iv32 = 0;
                    $this$toTypedArray$iv3 = $i$f$toTypedArray22.split((CharSequence)$this$toTypedArray$iv3, thisCollection$iv32);
                    $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv3.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv3.listIterator($this$dropLastWhile$iv3.size());
                        while (iterator$iv.hasPrevious()) {
                            String it7 = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it7).length() == 0) continue;
                            list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv3, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list3 = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv3 = list3;
                    boolean $i$f$toTypedArray3 = false;
                    Object thisCollection$iv = $this$toTypedArray$iv3;
                    rowAndCol = thisCollection$iv.toArray(new String[0]);
                    spanMatrix[i][0] = Integer.parseInt(indexAndSpan[0]);
                    if (this.mSubGridByColRow) {
                        spanMatrix[i][1] = Integer.parseInt(rowAndCol[1]);
                        spanMatrix[i][2] = Integer.parseInt(rowAndCol[0]);
                        continue;
                    }
                    spanMatrix[i][1] = Integer.parseInt(rowAndCol[0]);
                    spanMatrix[i][2] = Integer.parseInt(rowAndCol[1]);
                }
            }
            object = spanMatrix;
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    private final void fillConstraintMatrix(boolean isUpdate) {
        block16: {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            boolean $i$f$trim2;
            if (isUpdate) {
                int j;
                int n;
                int i;
                Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                int n2 = ((Object[])this.mPositionMatrix).length;
                for (i = 0; i < n2; ++i) {
                    Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                    n = this.mPositionMatrix[0].length;
                    for (j = 0; j < n; ++j) {
                        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
                        this.mPositionMatrix[i][j] = true;
                    }
                }
                Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
                n2 = ((Object[])this.mConstraintMatrix).length;
                for (i = 0; i < n2; ++i) {
                    Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
                    n = this.mConstraintMatrix[0].length;
                    for (j = 0; j < n; ++j) {
                        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
                        this.mConstraintMatrix[i][j] = -1;
                    }
                }
            }
            this.mNextAvailableIndex = 0;
            if (this.mSkips != null) {
                String string2 = this.mSkips;
                Intrinsics.checkNotNull((Object)string2);
                String $this$trim$iv = string2;
                $i$f$trim2 = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) {
                    int[][] mSkips;
                    String string3 = this.mSkips;
                    Intrinsics.checkNotNull((Object)string3);
                    if (mSkips != null) {
                        int[][] it2 = mSkips = this.parseSpans(string3, false);
                        boolean bl = false;
                        this.handleSkips(it2);
                    }
                }
            }
            if (this.mSpans == null) break block16;
            String string4 = this.mSpans;
            Intrinsics.checkNotNull((Object)string4);
            String $this$trim$iv = string4;
            $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0) {
                int[][] mSpans;
                String string5 = this.mSpans;
                Intrinsics.checkNotNull((Object)string5);
                if (mSpans != null) {
                    int[][] it3 = mSpans = this.parseSpans(string5, true);
                    boolean bl = false;
                    this.handleSpans(it3);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void initMatrices() {
        if (this.mConstraintMatrix == null) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.mConstraintMatrix);
        if (((Object[])this.mConstraintMatrix).length != this.getMWidgetsCount() || this.mPositionMatrix == null) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
        if (((Object[])this.mPositionMatrix).length != this.mRows) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.mPositionMatrix);
        if (this.mPositionMatrix[0].length == this.mColumns) {
            v0 = true;
        } else lbl-1000:
        // 4 sources

        {
            v0 = isUpdate = false;
        }
        if (!isUpdate) {
            this.initVariables();
        }
        this.fillConstraintMatrix(isUpdate);
    }

    private final void handleFlags() {
        if (this.mFlags == null) {
            return;
        }
        Intrinsics.checkNotNull((Object)this.mFlags);
        block4: for (int flag : this.mFlags) {
            switch (flag) {
                case 1: {
                    this.mSpansRespectWidgetOrder = true;
                    continue block4;
                }
                case 0: {
                    this.mSubGridByColRow = true;
                }
            }
        }
    }

    @Override
    public void measure(int widthMode, int widthSize, int heightMode, int heightSize) {
        super.measure(widthMode, widthSize, heightMode, heightSize);
        this.mContainer = (ConstraintWidgetContainer)this.getParent();
        this.setupGrid(false);
        ConstraintWidgetContainer constraintWidgetContainer = this.mContainer;
        Intrinsics.checkNotNull((Object)constraintWidgetContainer);
        Intrinsics.checkNotNull((Object)this.mBoxWidgets);
        Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])this.mBoxWidgets);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConstraintWidget[] constraintWidgetArray = thisCollection$iv.toArray(new ConstraintWidget[0]);
        constraintWidgetContainer.add(Arrays.copyOf(constraintWidgetArray, constraintWidgetArray.length));
    }

    @Override
    public void addToSolver(@NotNull LinearSystem system, boolean optimize) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        super.addToSolver(system, optimize);
        this.addConstraints();
    }

    private static final int parseSpans$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/constraintlayout/core/utils/GridCore$Companion;", "", "()V", "DEFAULT_SIZE", "", "HORIZONTAL", "MAX_COLUMNS", "MAX_ROWS", "SPANS_RESPECT_WIDGET_ORDER", "SUB_GRID_BY_COL_ROW", "VERTICAL", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

