/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.Dimension;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.Reference;
import androidx.constraintlayout.core.state.helpers.AlignHorizontallyReference;
import androidx.constraintlayout.core.state.helpers.AlignVerticallyReference;
import androidx.constraintlayout.core.state.helpers.BarrierReference;
import androidx.constraintlayout.core.state.helpers.FlowReference;
import androidx.constraintlayout.core.state.helpers.GridReference;
import androidx.constraintlayout.core.state.helpers.GuidelineReference;
import androidx.constraintlayout.core.state.helpers.HorizontalChainReference;
import androidx.constraintlayout.core.state.helpers.VerticalChainReference;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.HelperWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 v2\u00020\u0001:\u0006uvwxyzB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u001a\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020\u0001J#\u0010;\u001a\u00020<2\u0016\u0010=\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010>\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010?J#\u0010@\u001a\u00020A2\u0016\u0010=\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010>\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010BJ\u0012\u0010C\u001a\u0004\u0018\u00010%2\b\u00106\u001a\u0004\u0018\u00010\u0001J\u0012\u0010D\u001a\u00020#2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010E\u001a\u00020%2\b\u00106\u001a\u0004\u0018\u00010\u0001J\b\u0010F\u001a\u00020-H\u0002J\u0006\u0010G\u001a\u000201J\b\u0010H\u001a\u0004\u0018\u00010\u0018J\u001a\u0010I\u001a\u0004\u0018\u00010J2\b\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u0010K\u001a\u00020\u0004J\u0018\u0010L\u001a\u0004\u0018\u00010M2\u0006\u00106\u001a\u00020\u00012\u0006\u0010N\u001a\u00020-J\u0006\u0010O\u001a\u00020JJ#\u0010O\u001a\u00020J2\u0016\u0010=\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010>\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010PJ$\u0010Q\u001a\u0016\u0012\u0004\u0012\u00020-\u0018\u00010\nj\n\u0012\u0004\u0012\u00020-\u0018\u0001`\u000b2\b\u0010R\u001a\u0004\u0018\u00010-J\u0006\u0010S\u001a\u00020JJ#\u0010S\u001a\u00020J2\u0016\u0010=\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010>\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010PJ\u001a\u0010T\u001a\u0004\u0018\u00010U2\b\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u0010V\u001a\u00020#J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020YJ\u001a\u0010Z\u001a\u00020\u001b2\b\u00106\u001a\u0004\u0018\u00010\u00012\b\u0010[\u001a\u0004\u0018\u00010\\J\u0006\u0010]\u001a\u00020^J#\u0010]\u001a\u00020^2\u0016\u0010=\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010>\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010_J\u0012\u0010`\u001a\u0004\u0018\u00010U2\b\u00106\u001a\u0004\u0018\u00010\u0001J\u0010\u0010a\u001a\u00020\u00042\b\u0010b\u001a\u0004\u0018\u00010\u0011J\b\u0010c\u001a\u00020\u0004H\u0007J\u0018\u0010d\u001a\u0002012\b\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u0010e\u001a\u00020\u0001J\u0012\u0010f\u001a\u0004\u0018\u00010)2\b\u00106\u001a\u0004\u0018\u00010\u0001J\u0006\u0010g\u001a\u000201J\u000e\u0010h\u001a\u00020\u00042\u0006\u0010W\u001a\u00020#J\u000e\u0010i\u001a\u00020\u00042\u0006\u0010j\u001a\u00020#J\u0010\u0010k\u001a\u0002012\b\u0010l\u001a\u0004\u0018\u00010\u0018J\u000e\u0010m\u001a\u00020\u00002\u0006\u0010X\u001a\u00020YJ\u0010\u0010n\u001a\u0002012\u0006\u0010c\u001a\u00020\u0004H\u0007J\u0016\u0010o\u001a\u0002012\u0006\u00106\u001a\u00020-2\u0006\u0010R\u001a\u00020-J\u000e\u0010p\u001a\u00020\u00002\u0006\u0010X\u001a\u00020YJ\u0006\u0010q\u001a\u00020rJ#\u0010q\u001a\u00020r2\u0016\u0010=\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010>\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010sJ\u0012\u0010t\u001a\u0004\u0018\u00010U2\b\u00106\u001a\u0004\u0018\u00010\u0001J\u000e\u0010j\u001a\u00020\u00002\u0006\u0010X\u001a\u00020YR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00010\nj\b\u0012\u0004\u0012\u00020\u0001`\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00110\nj\b\u0012\u0004\u0012\u00020\u0011`\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0014\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\bR\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001b`\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R6\u0010(\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020)0\u001aj\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020)`\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001e\"\u0004\b+\u0010 RV\u0010,\u001a>\u0012\u0004\u0012\u00020-\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020-0\nj\b\u0012\u0004\u0012\u00020-`\u000b0\u001aj\u001e\u0012\u0004\u0012\u00020-\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020-0\nj\b\u0012\u0004\u0012\u00020-`\u000b`\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001e\"\u0004\b/\u0010 \u00a8\u0006{"}, d2={"Landroidx/constraintlayout/core/state/State;", "", "()V", "value", "", "isRtl", "()Z", "setRtl", "(Z)V", "mBaselineNeeded", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getMBaselineNeeded", "()Ljava/util/ArrayList;", "setMBaselineNeeded", "(Ljava/util/ArrayList;)V", "mBaselineNeededWidgets", "Landroidx/constraintlayout/core/widgets/ConstraintWidget;", "getMBaselineNeededWidgets", "setMBaselineNeededWidgets", "mDirtyBaselineNeededWidgets", "getMDirtyBaselineNeededWidgets", "setMDirtyBaselineNeededWidgets", "mDpToPixel", "Landroidx/constraintlayout/core/state/CorePixelDp;", "mHelperReferences", "Ljava/util/HashMap;", "Landroidx/constraintlayout/core/state/HelperReference;", "Lkotlin/collections/HashMap;", "getMHelperReferences", "()Ljava/util/HashMap;", "setMHelperReferences", "(Ljava/util/HashMap;)V", "mIsLtr", "mNumHelpers", "", "mParent", "Landroidx/constraintlayout/core/state/ConstraintReference;", "getMParent", "()Landroidx/constraintlayout/core/state/ConstraintReference;", "mReferences", "Landroidx/constraintlayout/core/state/Reference;", "getMReferences", "setMReferences", "mTags", "", "getMTags", "setMTags", "apply", "", "container", "Landroidx/constraintlayout/core/widgets/ConstraintWidgetContainer;", "barrier", "Landroidx/constraintlayout/core/state/helpers/BarrierReference;", "key", "direction", "Landroidx/constraintlayout/core/state/State$Direction;", "baselineNeededFor", "id", "centerHorizontally", "Landroidx/constraintlayout/core/state/helpers/AlignHorizontallyReference;", "references", "", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/AlignHorizontallyReference;", "centerVertically", "Landroidx/constraintlayout/core/state/helpers/AlignVerticallyReference;", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/AlignVerticallyReference;", "constraints", "convertDimension", "createConstraintReference", "createHelperKey", "directMapping", "getDpToPixel", "getFlow", "Landroidx/constraintlayout/core/state/helpers/FlowReference;", "vertical", "getGrid", "Landroidx/constraintlayout/core/state/helpers/GridReference;", "gridType", "getHorizontalFlow", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/FlowReference;", "getIdsForTag", "tag", "getVerticalFlow", "guideline", "Landroidx/constraintlayout/core/state/helpers/GuidelineReference;", "orientation", "height", "dimension", "Landroidx/constraintlayout/core/state/Dimension;", "helper", "type", "Landroidx/constraintlayout/core/state/State$Helper;", "horizontalChain", "Landroidx/constraintlayout/core/state/helpers/HorizontalChainReference;", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/HorizontalChainReference;", "horizontalGuideline", "isBaselineNeeded", "constraintWidget", "isLtr", "map", "view", "reference", "reset", "sameFixedHeight", "sameFixedWidth", "width", "setDpToPixel", "dpToPixel", "setHeight", "setLtr", "setTag", "setWidth", "verticalChain", "Landroidx/constraintlayout/core/state/helpers/VerticalChainReference;", "([Ljava/lang/Object;)Landroidx/constraintlayout/core/state/helpers/VerticalChainReference;", "verticalGuideline", "Chain", "Companion", "Constraint", "Direction", "Helper", "Wrap", "compose"})
@StabilityInferred(parameters=0)
public class State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CorePixelDp mDpToPixel;
    private boolean mIsLtr = true;
    @NotNull
    private HashMap<Object, Reference> mReferences = new HashMap();
    @NotNull
    private HashMap<Object, HelperReference> mHelperReferences = new HashMap();
    @NotNull
    private HashMap<String, ArrayList<String>> mTags = new HashMap();
    @NotNull
    private final ConstraintReference mParent = new ConstraintReference(this);
    private int mNumHelpers;
    @NotNull
    private ArrayList<Object> mBaselineNeeded = new ArrayList();
    @NotNull
    private ArrayList<ConstraintWidget> mBaselineNeededWidgets = new ArrayList();
    private boolean mDirtyBaselineNeededWidgets = true;
    public static final int $stable = 8;
    public static final int UNKNOWN = -1;
    public static final int CONSTRAINT_SPREAD = 0;
    public static final int CONSTRAINT_WRAP = 1;
    public static final int CONSTRAINT_RATIO = 2;
    public static final int PARENT = 0;

    @NotNull
    protected final HashMap<Object, Reference> getMReferences() {
        return this.mReferences;
    }

    protected final void setMReferences(@NotNull HashMap<Object, Reference> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.mReferences = hashMap;
    }

    @NotNull
    protected final HashMap<Object, HelperReference> getMHelperReferences() {
        return this.mHelperReferences;
    }

    protected final void setMHelperReferences(@NotNull HashMap<Object, HelperReference> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.mHelperReferences = hashMap;
    }

    @NotNull
    public final HashMap<String, ArrayList<String>> getMTags() {
        return this.mTags;
    }

    public final void setMTags(@NotNull HashMap<String, ArrayList<String>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.mTags = hashMap;
    }

    @NotNull
    public final ConstraintReference getMParent() {
        return this.mParent;
    }

    public State() {
        this.mParent.setKey(0);
        ((Map)this.mReferences).put(0, this.mParent);
    }

    @Nullable
    public final CorePixelDp getDpToPixel() {
        return this.mDpToPixel;
    }

    public final void setDpToPixel(@Nullable CorePixelDp dpToPixel) {
        this.mDpToPixel = dpToPixel;
    }

    @Deprecated(message="For consistency, use {@link #setRtl(boolean)} instead.")
    public final void setLtr(boolean isLtr) {
        this.mIsLtr = isLtr;
    }

    @Deprecated(message="For consistency, use {@link #isRtl()} instead.")
    public final boolean isLtr() {
        return this.mIsLtr;
    }

    public final boolean isRtl() {
        return !this.mIsLtr;
    }

    public final void setRtl(boolean value) {
        this.mIsLtr = !value;
    }

    public final void reset() {
        for (Object ref : this.mReferences.keySet()) {
            Reference reference = this.mReferences.get(ref);
            Intrinsics.checkNotNull((Object)reference);
            ConstraintWidget constraintWidget = reference.getConstraintWidget();
            Intrinsics.checkNotNull((Object)constraintWidget);
            constraintWidget.reset();
        }
        this.mReferences.clear();
        ((Map)this.mReferences).put(0, this.mParent);
        this.mHelperReferences.clear();
        this.mTags.clear();
        this.mBaselineNeeded.clear();
        this.mDirtyBaselineNeededWidgets = true;
    }

    public int convertDimension(@Nullable Object value) {
        if (value instanceof Float) {
            return MathKt.roundToInt((float)((Number)value).floatValue());
        }
        return value instanceof Integer ? ((Number)value).intValue() : 0;
    }

    @NotNull
    public final ConstraintReference createConstraintReference(@Nullable Object key) {
        return new ConstraintReference(this);
    }

    public final boolean sameFixedWidth(int width) {
        return this.mParent.getWidth().equalsFixedValue(width);
    }

    public final boolean sameFixedHeight(int height) {
        return this.mParent.getHeight().equalsFixedValue(height);
    }

    @NotNull
    public final State width(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this.setWidth(dimension);
    }

    @NotNull
    public final State height(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return this.setHeight(dimension);
    }

    @NotNull
    public final State setWidth(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.mParent.setWidth(dimension);
        return this;
    }

    @NotNull
    public final State setHeight(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.mParent.setHeight(dimension);
        return this;
    }

    @Nullable
    public final Reference reference(@Nullable Object key) {
        return (Reference)((Map)this.mReferences).get(key);
    }

    @Nullable
    public final ConstraintReference constraints(@Nullable Object key) {
        Reference reference = (Reference)((Map)this.mReferences).get(key);
        if (reference == null) {
            reference = this.createConstraintReference(key);
            Map map = this.mReferences;
            Object object = key;
            Intrinsics.checkNotNull((Object)object);
            map.put(object, reference);
            ((ConstraintReference)reference).setKey(key);
        }
        return reference instanceof ConstraintReference ? (ConstraintReference)reference : null;
    }

    private final String createHelperKey() {
        int n = this.mNumHelpers;
        this.mNumHelpers = n + 1;
        return "__HELPER_KEY_" + n + "__";
    }

    @NotNull
    public final HelperReference helper(@Nullable Object key, @Nullable Helper type) {
        HelperReference reference;
        Object key2 = key;
        if (key2 == null) {
            key2 = this.createHelperKey();
        }
        if ((reference = this.mHelperReferences.get(key2)) == null) {
            Helper helper = type;
            switch (helper == null ? -1 : WhenMappings.$EnumSwitchMapping$0[helper.ordinal()]) {
                case 1: {
                    reference = new HorizontalChainReference(this);
                    break;
                }
                case 2: {
                    reference = new VerticalChainReference(this);
                    break;
                }
                case 3: {
                    reference = new AlignHorizontallyReference(this);
                    break;
                }
                case 4: {
                    reference = new AlignVerticallyReference(this);
                    break;
                }
                case 5: {
                    reference = new BarrierReference(this);
                    break;
                }
                case 6: 
                case 7: {
                    reference = new FlowReference(this, type);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    reference = new GridReference(this, type);
                    break;
                }
                default: {
                    Helper helper2 = type;
                    Intrinsics.checkNotNull((Object)((Object)helper2));
                    reference = new HelperReference(this, helper2);
                }
            }
            reference.setKey(key2);
            ((Map)this.mHelperReferences).put(key2, reference);
        }
        return reference;
    }

    @Nullable
    public final GuidelineReference horizontalGuideline(@Nullable Object key) {
        return this.guideline(key, 0);
    }

    @Nullable
    public final GuidelineReference verticalGuideline(@Nullable Object key) {
        return this.guideline(key, 1);
    }

    @Nullable
    public final GuidelineReference guideline(@Nullable Object key, int orientation) {
        ConstraintReference reference;
        ConstraintReference constraintReference = reference = this.constraints(key);
        if ((constraintReference != null ? constraintReference.getFacade() : null) == null || !(reference.getFacade() instanceof GuidelineReference)) {
            GuidelineReference guidelineReference = new GuidelineReference(this);
            guidelineReference.setOrientation(orientation);
            guidelineReference.setKey(key);
            ConstraintReference constraintReference2 = reference;
            if (constraintReference2 != null) {
                constraintReference2.setFacade(guidelineReference);
            }
        }
        ConstraintReference constraintReference3 = reference;
        return (GuidelineReference)(constraintReference3 != null ? constraintReference3.getFacade() : null);
    }

    @Nullable
    public final BarrierReference barrier(@Nullable Object key, @NotNull Direction direction) {
        ConstraintReference reference;
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        ConstraintReference constraintReference = reference = this.constraints(key);
        if ((constraintReference != null ? constraintReference.getFacade() : null) == null || !(reference.getFacade() instanceof BarrierReference)) {
            BarrierReference barrierReference = new BarrierReference(this);
            barrierReference.setBarrierDirection(direction);
            ConstraintReference constraintReference2 = reference;
            if (constraintReference2 != null) {
                constraintReference2.setFacade(barrierReference);
            }
        }
        ConstraintReference constraintReference3 = reference;
        return (BarrierReference)(constraintReference3 != null ? constraintReference3.getFacade() : null);
    }

    @Nullable
    public final GridReference getGrid(@NotNull Object key, @NotNull String gridType) {
        ConstraintReference reference;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)gridType, (String)"gridType");
        ConstraintReference constraintReference = reference = this.constraints(key);
        if ((constraintReference != null ? constraintReference.getFacade() : null) == null || !(reference.getFacade() instanceof GridReference)) {
            Helper Type2 = Helper.GRID;
            if (gridType.charAt(0) == 'r') {
                Type2 = Helper.ROW;
            } else if (gridType.charAt(0) == 'c') {
                Type2 = Helper.COLUMN;
            }
            GridReference gridReference = new GridReference(this, Type2);
            ConstraintReference constraintReference2 = reference;
            if (constraintReference2 != null) {
                constraintReference2.setFacade(gridReference);
            }
        }
        ConstraintReference constraintReference3 = reference;
        return (GridReference)(constraintReference3 != null ? constraintReference3.getFacade() : null);
    }

    @Nullable
    public final FlowReference getFlow(@Nullable Object key, boolean vertical) {
        ConstraintReference reference;
        ConstraintReference constraintReference = reference = this.constraints(key);
        if ((constraintReference != null ? constraintReference.getFacade() : null) == null || !(reference.getFacade() instanceof FlowReference)) {
            FlowReference flowReference = vertical ? new FlowReference(this, Helper.VERTICAL_FLOW) : new FlowReference(this, Helper.HORIZONTAL_FLOW);
            ConstraintReference constraintReference2 = reference;
            if (constraintReference2 != null) {
                constraintReference2.setFacade(flowReference);
            }
        }
        ConstraintReference constraintReference3 = reference;
        return (FlowReference)(constraintReference3 != null ? constraintReference3.getFacade() : null);
    }

    @NotNull
    public final VerticalChainReference verticalChain() {
        HelperReference helperReference = this.helper(null, Helper.VERTICAL_CHAIN);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.VerticalChainReference");
        return (VerticalChainReference)helperReference;
    }

    @NotNull
    public final VerticalChainReference verticalChain(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.VERTICAL_CHAIN);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.VerticalChainReference");
        VerticalChainReference reference = (VerticalChainReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final HorizontalChainReference horizontalChain() {
        HelperReference helperReference = this.helper(null, Helper.HORIZONTAL_CHAIN);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.HorizontalChainReference");
        return (HorizontalChainReference)helperReference;
    }

    @NotNull
    public final HorizontalChainReference horizontalChain(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.HORIZONTAL_CHAIN);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.HorizontalChainReference");
        HorizontalChainReference reference = (HorizontalChainReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final FlowReference getVerticalFlow() {
        HelperReference helperReference = this.helper(null, Helper.VERTICAL_FLOW);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.FlowReference");
        return (FlowReference)helperReference;
    }

    @NotNull
    public final FlowReference getVerticalFlow(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.VERTICAL_FLOW);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.FlowReference");
        FlowReference reference = (FlowReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final FlowReference getHorizontalFlow() {
        HelperReference helperReference = this.helper(null, Helper.HORIZONTAL_FLOW);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.FlowReference");
        return (FlowReference)helperReference;
    }

    @NotNull
    public final FlowReference getHorizontalFlow(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.HORIZONTAL_FLOW);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.FlowReference");
        FlowReference reference = (FlowReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final AlignHorizontallyReference centerHorizontally(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.ALIGN_HORIZONTALLY);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.AlignHorizontallyReference");
        AlignHorizontallyReference reference = (AlignHorizontallyReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    @NotNull
    public final AlignVerticallyReference centerVertically(Object ... references) {
        Intrinsics.checkNotNullParameter((Object)references, (String)"references");
        HelperReference helperReference = this.helper(null, Helper.ALIGN_VERTICALLY);
        Intrinsics.checkNotNull((Object)helperReference, (String)"null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.AlignVerticallyReference");
        AlignVerticallyReference reference = (AlignVerticallyReference)helperReference;
        Object[] objectArray = new Object[]{references};
        reference.add(objectArray);
        return reference;
    }

    public final void directMapping() {
        for (Object key : this.mReferences.keySet()) {
            ConstraintReference constraintReference = this.constraints(key);
            if (constraintReference == null) {
                continue;
            }
            Reference ref = constraintReference;
            ConstraintReference reference = (ConstraintReference)ref;
            Intrinsics.checkNotNull((Object)key);
            reference.setView(key);
        }
    }

    public final void map(@Nullable Object key, @NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ConstraintReference ref = this.constraints(key);
        if (ref != null) {
            ref.setView(view);
        }
    }

    public final void setTag(@NotNull String key, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Reference ref = this.constraints(key);
        if (ref instanceof ConstraintReference) {
            ConstraintReference reference = (ConstraintReference)ref;
            reference.setTag(tag);
            ArrayList<Object> list = null;
            if (!this.mTags.containsKey(tag)) {
                list = new ArrayList();
                ((Map)this.mTags).put(tag, list);
            } else {
                list = this.mTags.get(tag);
            }
            ArrayList<Object> arrayList = list;
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(key);
        }
    }

    @Nullable
    public final ArrayList<String> getIdsForTag(@Nullable String tag) {
        return ((Map)this.mTags).containsKey(tag) ? (ArrayList)((Map)this.mTags).get(tag) : null;
    }

    public final void apply(@NotNull ConstraintWidgetContainer container) {
        ConstraintWidget widget;
        Object constraintReference;
        HelperWidget helperWidget;
        Reference reference;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        container.removeAllChildren();
        this.mParent.getWidth().apply(this, container, 0);
        this.mParent.getHeight().apply(this, container, 1);
        for (Object key : this.mHelperReferences.keySet()) {
            reference = this.mHelperReferences.get(key);
            HelperReference helperReference = reference;
            helperWidget = helperReference != null ? helperReference.getHelperWidget() : null;
            if (helperWidget == null) continue;
            constraintReference = this.mReferences.get(key);
            if (constraintReference == null) {
                constraintReference = this.constraints(key);
            }
            Reference reference2 = constraintReference;
            Intrinsics.checkNotNull((Object)reference2);
            reference2.setConstraintWidget(helperWidget);
        }
        for (Object key : this.mReferences.keySet()) {
            reference = this.mReferences.get(key);
            if (Intrinsics.areEqual((Object)reference, (Object)this.mParent)) continue;
            Reference reference3 = reference;
            Intrinsics.checkNotNull((Object)reference3);
            if (!(reference3.getFacade() instanceof HelperReference)) continue;
            HelperReference helperReference = (HelperReference)reference.getFacade();
            helperWidget = helperReference != null ? helperReference.getHelperWidget() : null;
            if (helperWidget == null) continue;
            constraintReference = this.mReferences.get(key);
            if (constraintReference == null) {
                constraintReference = this.constraints(key);
            }
            Object object = constraintReference;
            Intrinsics.checkNotNull((Object)object);
            object.setConstraintWidget(helperWidget);
        }
        for (Object key : this.mReferences.keySet()) {
            reference = this.mReferences.get(key);
            if (!Intrinsics.areEqual((Object)reference, (Object)this.mParent)) {
                Reference reference4 = reference;
                Intrinsics.checkNotNull((Object)reference4);
                ConstraintWidget constraintWidget = widget = reference4.getConstraintWidget();
                Intrinsics.checkNotNull((Object)constraintWidget);
                constraintWidget.setDebugName(String.valueOf(reference.getKey()));
                widget.setParent(null);
                if (reference.getFacade() instanceof GuidelineReference) {
                    reference.apply();
                }
                container.add(widget);
                continue;
            }
            reference.setConstraintWidget(container);
        }
        for (Object key : this.mHelperReferences.keySet()) {
            Reference reference5 = reference = this.mHelperReferences.get(key);
            HelperWidget helperWidget2 = helperWidget = reference5 != null ? ((HelperReference)reference5).getHelperWidget() : null;
            if (helperWidget != null) {
                for (Object e : ((HelperReference)reference).getMReferences()) {
                    Reference constraintReference2 = this.mReferences.get(e);
                    HelperWidget helperWidget3 = ((HelperReference)reference).getHelperWidget();
                    Intrinsics.checkNotNull((Object)helperWidget3);
                    Reference reference6 = constraintReference2;
                    Intrinsics.checkNotNull((Object)reference6);
                    helperWidget3.add(reference6.getConstraintWidget());
                }
                ((HelperReference)reference).apply();
                continue;
            }
            Reference reference7 = reference;
            if (reference7 == null) continue;
            ((HelperReference)reference7).apply();
        }
        for (Object key : this.mReferences.keySet()) {
            HelperReference helperReference;
            reference = this.mReferences.get(key);
            if (Intrinsics.areEqual((Object)reference, (Object)this.mParent)) continue;
            Reference reference8 = reference;
            Intrinsics.checkNotNull((Object)reference8);
            if (!(reference8.getFacade() instanceof HelperReference)) continue;
            HelperReference helperReference2 = helperReference = (HelperReference)reference.getFacade();
            HelperWidget helperWidget4 = helperReference2 != null ? helperReference2.getHelperWidget() : null;
            if (helperWidget4 == null) continue;
            for (Object keyRef : helperReference.getMReferences()) {
                Reference constraintReference3 = this.mReferences.get(keyRef);
                if (constraintReference3 != null) {
                    helperWidget4.add(constraintReference3.getConstraintWidget());
                    continue;
                }
                if (keyRef instanceof Reference) {
                    helperWidget4.add(((Reference)keyRef).getConstraintWidget());
                    continue;
                }
                System.out.println((Object)("couldn't find reference for " + keyRef));
            }
            reference.apply();
        }
        for (Object key : this.mReferences.keySet()) {
            Reference reference9 = reference = (Reference)((Map)this.mReferences).get(key);
            Intrinsics.checkNotNull((Object)reference9);
            reference9.apply();
            widget = reference.getConstraintWidget();
            if (widget == null || key == null) continue;
            widget.setStringId(key.toString());
        }
    }

    @NotNull
    public final ArrayList<Object> getMBaselineNeeded() {
        return this.mBaselineNeeded;
    }

    public final void setMBaselineNeeded(@NotNull ArrayList<Object> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mBaselineNeeded = arrayList;
    }

    @NotNull
    public final ArrayList<ConstraintWidget> getMBaselineNeededWidgets() {
        return this.mBaselineNeededWidgets;
    }

    public final void setMBaselineNeededWidgets(@NotNull ArrayList<ConstraintWidget> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.mBaselineNeededWidgets = arrayList;
    }

    public final boolean getMDirtyBaselineNeededWidgets() {
        return this.mDirtyBaselineNeededWidgets;
    }

    public final void setMDirtyBaselineNeededWidgets(boolean bl) {
        this.mDirtyBaselineNeededWidgets = bl;
    }

    public final void baselineNeededFor(@NotNull Object id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.mBaselineNeeded.add(id);
        this.mDirtyBaselineNeededWidgets = true;
    }

    public final boolean isBaselineNeeded(@Nullable ConstraintWidget constraintWidget) {
        if (this.mDirtyBaselineNeededWidgets) {
            this.mBaselineNeededWidgets.clear();
            for (Object id : this.mBaselineNeeded) {
                Reference reference = this.mReferences.get(id);
                Intrinsics.checkNotNull((Object)reference);
                ConstraintWidget widget = reference.getConstraintWidget();
                if (widget == null) continue;
                this.mBaselineNeededWidgets.add(widget);
            }
            this.mDirtyBaselineNeededWidgets = false;
        }
        return CollectionsKt.contains((Iterable)this.mBaselineNeededWidgets, (Object)constraintWidget);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/state/State$Chain;", "", "(Ljava/lang/String;I)V", "SPREAD", "SPREAD_INSIDE", "PACKED", "Companion", "compose"})
    public static final class Chain
    extends Enum<Chain> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final Map<String, Chain> chainMap;
        @NotNull
        private static final Map<String, Integer> valueMap;
        public static final /* enum */ Chain SPREAD;
        public static final /* enum */ Chain SPREAD_INSIDE;
        public static final /* enum */ Chain PACKED;
        private static final /* synthetic */ Chain[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Chain[] values() {
            return (Chain[])$VALUES.clone();
        }

        public static Chain valueOf(String value) {
            return Enum.valueOf(Chain.class, value);
        }

        @NotNull
        public static EnumEntries<Chain> getEntries() {
            return $ENTRIES;
        }

        static {
            SPREAD = new Chain();
            SPREAD_INSIDE = new Chain();
            PACKED = new Chain();
            $VALUES = chainArray = new Chain[]{Chain.SPREAD, Chain.SPREAD_INSIDE, Chain.PACKED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"packed", (Object)((Object)PACKED)), TuplesKt.to((Object)"spread_inside", (Object)((Object)SPREAD_INSIDE)), TuplesKt.to((Object)"spread", (Object)((Object)SPREAD))};
            chainMap = MapsKt.hashMapOf((Pair[])pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"packed", (Object)2), TuplesKt.to((Object)"spread_inside", (Object)1), TuplesKt.to((Object)"spread", (Object)0)};
            valueMap = MapsKt.hashMapOf((Pair[])pairArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000e\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/core/state/State$Chain$Companion;", "", "()V", "chainMap", "", "", "Landroidx/constraintlayout/core/state/State$Chain;", "getChainMap", "()Ljava/util/Map;", "valueMap", "", "getValueMap", "getChainByString", "str", "getValueByString", "compose"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, Chain> getChainMap() {
                return chainMap;
            }

            @NotNull
            public final Map<String, Integer> getValueMap() {
                return valueMap;
            }

            public final int getValueByString(@Nullable String str) {
                int n;
                if (this.getValueMap().containsKey(str)) {
                    Integer n2 = this.getValueMap().get(str);
                    Intrinsics.checkNotNull((Object)n2);
                    n = ((Number)n2).intValue();
                } else {
                    n = -1;
                }
                return n;
            }

            @Nullable
            public final Chain getChainByString(@Nullable String str) {
                return this.getChainMap().containsKey(str) ? this.getChainMap().get(str) : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/constraintlayout/core/state/State$Companion;", "", "()V", "CONSTRAINT_RATIO", "", "CONSTRAINT_SPREAD", "CONSTRAINT_WRAP", "PARENT", "UNKNOWN", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0016\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Landroidx/constraintlayout/core/state/State$Constraint;", "", "(Ljava/lang/String;I)V", "LEFT_TO_LEFT", "LEFT_TO_RIGHT", "RIGHT_TO_LEFT", "RIGHT_TO_RIGHT", "START_TO_START", "START_TO_END", "END_TO_START", "END_TO_END", "TOP_TO_TOP", "TOP_TO_BOTTOM", "TOP_TO_BASELINE", "BOTTOM_TO_TOP", "BOTTOM_TO_BOTTOM", "BOTTOM_TO_BASELINE", "BASELINE_TO_BASELINE", "BASELINE_TO_TOP", "BASELINE_TO_BOTTOM", "CENTER_HORIZONTALLY", "CENTER_VERTICALLY", "CIRCULAR_CONSTRAINT", "compose"})
    public static final class Constraint
    extends Enum<Constraint> {
        public static final /* enum */ Constraint LEFT_TO_LEFT = new Constraint();
        public static final /* enum */ Constraint LEFT_TO_RIGHT = new Constraint();
        public static final /* enum */ Constraint RIGHT_TO_LEFT = new Constraint();
        public static final /* enum */ Constraint RIGHT_TO_RIGHT = new Constraint();
        public static final /* enum */ Constraint START_TO_START = new Constraint();
        public static final /* enum */ Constraint START_TO_END = new Constraint();
        public static final /* enum */ Constraint END_TO_START = new Constraint();
        public static final /* enum */ Constraint END_TO_END = new Constraint();
        public static final /* enum */ Constraint TOP_TO_TOP = new Constraint();
        public static final /* enum */ Constraint TOP_TO_BOTTOM = new Constraint();
        public static final /* enum */ Constraint TOP_TO_BASELINE = new Constraint();
        public static final /* enum */ Constraint BOTTOM_TO_TOP = new Constraint();
        public static final /* enum */ Constraint BOTTOM_TO_BOTTOM = new Constraint();
        public static final /* enum */ Constraint BOTTOM_TO_BASELINE = new Constraint();
        public static final /* enum */ Constraint BASELINE_TO_BASELINE = new Constraint();
        public static final /* enum */ Constraint BASELINE_TO_TOP = new Constraint();
        public static final /* enum */ Constraint BASELINE_TO_BOTTOM = new Constraint();
        public static final /* enum */ Constraint CENTER_HORIZONTALLY = new Constraint();
        public static final /* enum */ Constraint CENTER_VERTICALLY = new Constraint();
        public static final /* enum */ Constraint CIRCULAR_CONSTRAINT = new Constraint();
        private static final /* synthetic */ Constraint[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Constraint[] values() {
            return (Constraint[])$VALUES.clone();
        }

        public static Constraint valueOf(String value) {
            return Enum.valueOf(Constraint.class, value);
        }

        @NotNull
        public static EnumEntries<Constraint> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constraintArray = new Constraint[]{Constraint.LEFT_TO_LEFT, Constraint.LEFT_TO_RIGHT, Constraint.RIGHT_TO_LEFT, Constraint.RIGHT_TO_RIGHT, Constraint.START_TO_START, Constraint.START_TO_END, Constraint.END_TO_START, Constraint.END_TO_END, Constraint.TOP_TO_TOP, Constraint.TOP_TO_BOTTOM, Constraint.TOP_TO_BASELINE, Constraint.BOTTOM_TO_TOP, Constraint.BOTTOM_TO_BOTTOM, Constraint.BOTTOM_TO_BASELINE, Constraint.BASELINE_TO_BASELINE, Constraint.BASELINE_TO_TOP, Constraint.BASELINE_TO_BOTTOM, Constraint.CENTER_HORIZONTALLY, Constraint.CENTER_VERTICALLY, Constraint.CIRCULAR_CONSTRAINT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Landroidx/constraintlayout/core/state/State$Direction;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "START", "END", "TOP", "BOTTOM", "compose"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction LEFT = new Direction();
        public static final /* enum */ Direction RIGHT = new Direction();
        public static final /* enum */ Direction START = new Direction();
        public static final /* enum */ Direction END = new Direction();
        public static final /* enum */ Direction TOP = new Direction();
        public static final /* enum */ Direction BOTTOM = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.LEFT, Direction.RIGHT, Direction.START, Direction.END, Direction.TOP, Direction.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/core/state/State$Helper;", "", "(Ljava/lang/String;I)V", "HORIZONTAL_CHAIN", "VERTICAL_CHAIN", "ALIGN_HORIZONTALLY", "ALIGN_VERTICALLY", "BARRIER", "LAYER", "HORIZONTAL_FLOW", "VERTICAL_FLOW", "GRID", "ROW", "COLUMN", "FLOW", "compose"})
    public static final class Helper
    extends Enum<Helper> {
        public static final /* enum */ Helper HORIZONTAL_CHAIN = new Helper();
        public static final /* enum */ Helper VERTICAL_CHAIN = new Helper();
        public static final /* enum */ Helper ALIGN_HORIZONTALLY = new Helper();
        public static final /* enum */ Helper ALIGN_VERTICALLY = new Helper();
        public static final /* enum */ Helper BARRIER = new Helper();
        public static final /* enum */ Helper LAYER = new Helper();
        public static final /* enum */ Helper HORIZONTAL_FLOW = new Helper();
        public static final /* enum */ Helper VERTICAL_FLOW = new Helper();
        public static final /* enum */ Helper GRID = new Helper();
        public static final /* enum */ Helper ROW = new Helper();
        public static final /* enum */ Helper COLUMN = new Helper();
        public static final /* enum */ Helper FLOW = new Helper();
        private static final /* synthetic */ Helper[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Helper[] values() {
            return (Helper[])$VALUES.clone();
        }

        public static Helper valueOf(String value) {
            return Enum.valueOf(Helper.class, value);
        }

        @NotNull
        public static EnumEntries<Helper> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = helperArray = new Helper[]{Helper.HORIZONTAL_CHAIN, Helper.VERTICAL_CHAIN, Helper.ALIGN_HORIZONTALLY, Helper.ALIGN_VERTICALLY, Helper.BARRIER, Helper.LAYER, Helper.HORIZONTAL_FLOW, Helper.VERTICAL_FLOW, Helper.GRID, Helper.ROW, Helper.COLUMN, Helper.FLOW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Helper.values().length];
            try {
                nArray[Helper.HORIZONTAL_CHAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.VERTICAL_CHAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.ALIGN_HORIZONTALLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.ALIGN_VERTICALLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.BARRIER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.VERTICAL_FLOW.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.HORIZONTAL_FLOW.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.GRID.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.ROW.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Helper.COLUMN.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Landroidx/constraintlayout/core/state/State$Wrap;", "", "(Ljava/lang/String;I)V", "NONE", "CHAIN", "ALIGNED", "Companion", "compose"})
    public static final class Wrap
    extends Enum<Wrap> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final Map<String, Wrap> wrapMap;
        @NotNull
        private static final Map<String, Integer> valueMap;
        public static final /* enum */ Wrap NONE;
        public static final /* enum */ Wrap CHAIN;
        public static final /* enum */ Wrap ALIGNED;
        private static final /* synthetic */ Wrap[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Wrap[] values() {
            return (Wrap[])$VALUES.clone();
        }

        public static Wrap valueOf(String value) {
            return Enum.valueOf(Wrap.class, value);
        }

        @NotNull
        public static EnumEntries<Wrap> getEntries() {
            return $ENTRIES;
        }

        static {
            NONE = new Wrap();
            CHAIN = new Wrap();
            ALIGNED = new Wrap();
            $VALUES = wrapArray = new Wrap[]{Wrap.NONE, Wrap.CHAIN, Wrap.ALIGNED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"none", (Object)((Object)NONE)), TuplesKt.to((Object)"chain", (Object)((Object)CHAIN)), TuplesKt.to((Object)"aligned", (Object)((Object)ALIGNED))};
            wrapMap = MapsKt.hashMapOf((Pair[])pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"none", (Object)0), TuplesKt.to((Object)"chain", (Object)3), TuplesKt.to((Object)"aligned", (Object)2)};
            valueMap = MapsKt.hashMapOf((Pair[])pairArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000e\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u000f"}, d2={"Landroidx/constraintlayout/core/state/State$Wrap$Companion;", "", "()V", "valueMap", "", "", "", "getValueMap", "()Ljava/util/Map;", "wrapMap", "Landroidx/constraintlayout/core/state/State$Wrap;", "getWrapMap", "getChainByString", "str", "getValueByString", "compose"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, Wrap> getWrapMap() {
                return wrapMap;
            }

            @NotNull
            public final Map<String, Integer> getValueMap() {
                return valueMap;
            }

            public final int getValueByString(@Nullable String str) {
                int n;
                if (this.getValueMap().containsKey(str)) {
                    Integer n2 = this.getValueMap().get(str);
                    Intrinsics.checkNotNull((Object)n2);
                    n = ((Number)n2).intValue();
                } else {
                    n = -1;
                }
                return n;
            }

            @Nullable
            public final Wrap getChainByString(@Nullable String str) {
                return this.getWrapMap().containsKey(str) ? this.getWrapMap().get(str) : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

