/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.state.RegistryCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0014J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005J\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014J\u0016\u0010\u001d\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fR.\u0010\u0003\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/constraintlayout/core/state/Registry;", "", "()V", "mCallbacks", "Ljava/util/HashMap;", "", "Landroidx/constraintlayout/core/state/RegistryCallback;", "Lkotlin/collections/HashMap;", "currentContent", "name", "currentLayoutInformation", "getLastModified", "", "getLayoutList", "", "register", "", "callback", "setDrawDebug", "debugMode", "", "setLayoutInformationMode", "mode", "unregister", "updateContent", "content", "updateDimensions", "width", "height", "updateProgress", "progress", "", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class Registry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, RegistryCallback> mCallbacks = new HashMap();
    public static final int $stable = 8;
    @NotNull
    private static final Registry sRegistry = new Registry();

    public final void register(@Nullable String name, @NotNull RegistryCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        ((Map)this.mCallbacks).put(name, callback2);
    }

    public final void unregister(@NotNull String name, @Nullable RegistryCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.mCallbacks.remove(name);
    }

    public final void updateContent(@NotNull String name, @Nullable String content) {
        block0: {
            RegistryCallback callback2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            RegistryCallback registryCallback = callback2 = this.mCallbacks.get(name);
            if (registryCallback == null) break block0;
            registryCallback.onNewMotionScene(content);
        }
    }

    public final void updateProgress(@NotNull String name, float progress) {
        block0: {
            RegistryCallback callback2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            RegistryCallback registryCallback = callback2 = this.mCallbacks.get(name);
            if (registryCallback == null) break block0;
            registryCallback.onProgress(progress);
        }
    }

    @Nullable
    public final String currentContent(@NotNull String name) {
        RegistryCallback callback2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RegistryCallback registryCallback = callback2 = this.mCallbacks.get(name);
        return registryCallback != null ? registryCallback.currentMotionScene() : null;
    }

    @Nullable
    public final String currentLayoutInformation(@NotNull String name) {
        RegistryCallback callback2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RegistryCallback registryCallback = callback2 = this.mCallbacks.get(name);
        return registryCallback != null ? registryCallback.currentLayoutInformation() : null;
    }

    public final void setDrawDebug(@NotNull String name, int debugMode) {
        block0: {
            RegistryCallback callback2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            RegistryCallback registryCallback = callback2 = this.mCallbacks.get(name);
            if (registryCallback == null) break block0;
            registryCallback.setDrawDebug(debugMode);
        }
    }

    public final void setLayoutInformationMode(@NotNull String name, int mode) {
        block0: {
            RegistryCallback callback2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            RegistryCallback registryCallback = callback2 = this.mCallbacks.get(name);
            if (registryCallback == null) break block0;
            registryCallback.setLayoutInformationMode(mode);
        }
    }

    @NotNull
    public final Set<String> getLayoutList() {
        Set<String> set = this.mCallbacks.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    public final long getLastModified(@NotNull String name) {
        RegistryCallback callback2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RegistryCallback registryCallback = callback2 = this.mCallbacks.get(name);
        return registryCallback != null ? registryCallback.getLastModified() : Long.MAX_VALUE;
    }

    public final void updateDimensions(@NotNull String name, int width, int height) {
        block0: {
            RegistryCallback callback2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            RegistryCallback registryCallback = callback2 = this.mCallbacks.get(name);
            if (registryCallback == null) break block0;
            registryCallback.onDimensions(width, height);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/constraintlayout/core/state/Registry$Companion;", "", "()V", "sRegistry", "Landroidx/constraintlayout/core/state/Registry;", "getInstance", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Registry getInstance() {
            return sRegistry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

