/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ext.DecimalKt;
import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.KeyFrameArray;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0010\b'\u0018\u0000 V2\u00020\u0001:\u0004VWXYB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020\"H\u0004J\u0006\u0010H\u001a\u00020\u001cJ0\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\"2\u0006\u0010G\u001a\u00020\"2\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\"H\u0016J\u0010\u0010O\u001a\u00020J2\u0006\u0010P\u001a\u00020(H\u0004J\u000e\u0010Q\u001a\u00020J2\u0006\u0010R\u001a\u000204J\u0010\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020\u0004H\u0016J\b\u0010U\u001a\u000204H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001c\u00103\u001a\u0004\u0018\u000104X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u00109\u001a\b\u0012\u0004\u0012\u00020\f0:X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010?\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010@\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0006\"\u0004\bB\u0010\u001aR\u001a\u0010C\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010$\"\u0004\bE\u0010&\u00a8\u0006Z"}, d2={"Landroidx/constraintlayout/core/motion/utils/TimeCycleSplineSet;", "", "()V", "CURVE_OFFSET", "", "getCURVE_OFFSET", "()I", "CURVE_PERIOD", "getCURVE_PERIOD", "CURVE_VALUE", "getCURVE_VALUE", "mCache", "", "getMCache", "()[F", "setMCache", "([F)V", "mContinue", "", "getMContinue", "()Z", "setMContinue", "(Z)V", "mCount", "getMCount", "setMCount", "(I)V", "mCurveFit", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "getMCurveFit", "()Landroidx/constraintlayout/core/motion/utils/CurveFit;", "setMCurveFit", "(Landroidx/constraintlayout/core/motion/utils/CurveFit;)V", "mLastCycle", "", "getMLastCycle", "()F", "setMLastCycle", "(F)V", "mLastTime", "", "getMLastTime", "()J", "setMLastTime", "(J)V", "mTimePoints", "", "getMTimePoints", "()[I", "setMTimePoints", "([I)V", "mType", "", "getMType", "()Ljava/lang/String;", "setMType", "(Ljava/lang/String;)V", "mValues", "", "getMValues", "()[[F", "setMValues", "([[F)V", "[[F", "mWaveShape", "getMWaveShape", "setMWaveShape", "sVal2PI", "getSVal2PI", "setSVal2PI", "calcWave", "period", "getCurveFit", "setPoint", "", "position", "value", "shape", "offset", "setStartTime", "currentTime", "setType", "type", "setup", "curveType", "toString", "Companion", "CustomSet", "CustomVarSet", "Sort", "compose"})
@StabilityInferred(parameters=0)
public abstract class TimeCycleSplineSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CurveFit mCurveFit;
    private int mWaveShape;
    @NotNull
    private int[] mTimePoints = new int[10];
    @NotNull
    private float[][] mValues;
    private int mCount;
    @Nullable
    private String mType;
    @NotNull
    private float[] mCache;
    private final int CURVE_VALUE;
    private final int CURVE_PERIOD;
    private final int CURVE_OFFSET;
    private float sVal2PI;
    private boolean mContinue;
    private long mLastTime;
    private float mLastCycle;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "SplineSet";

    public TimeCycleSplineSet() {
        int n = 0;
        float[][] fArrayArray = new float[10][];
        TimeCycleSplineSet timeCycleSplineSet = this;
        while (n < 10) {
            int n2 = n++;
            fArrayArray[n2] = new float[3];
        }
        timeCycleSplineSet.mValues = fArrayArray;
        this.mCache = new float[3];
        this.CURVE_PERIOD = 1;
        this.CURVE_OFFSET = 2;
        this.sVal2PI = (float)Math.PI * 2;
        this.mLastCycle = Float.NaN;
    }

    @Nullable
    protected final CurveFit getMCurveFit() {
        return this.mCurveFit;
    }

    protected final void setMCurveFit(@Nullable CurveFit curveFit) {
        this.mCurveFit = curveFit;
    }

    protected final int getMWaveShape() {
        return this.mWaveShape;
    }

    protected final void setMWaveShape(int n) {
        this.mWaveShape = n;
    }

    @NotNull
    protected final int[] getMTimePoints() {
        return this.mTimePoints;
    }

    protected final void setMTimePoints(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.mTimePoints = nArray;
    }

    @NotNull
    protected final float[][] getMValues() {
        return this.mValues;
    }

    protected final void setMValues(@NotNull float[][] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.mValues = fArray;
    }

    protected final int getMCount() {
        return this.mCount;
    }

    protected final void setMCount(int n) {
        this.mCount = n;
    }

    @Nullable
    protected final String getMType() {
        return this.mType;
    }

    protected final void setMType(@Nullable String string2) {
        this.mType = string2;
    }

    @NotNull
    protected final float[] getMCache() {
        return this.mCache;
    }

    protected final void setMCache(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.mCache = fArray;
    }

    protected final int getCURVE_VALUE() {
        return this.CURVE_VALUE;
    }

    protected final int getCURVE_PERIOD() {
        return this.CURVE_PERIOD;
    }

    protected final int getCURVE_OFFSET() {
        return this.CURVE_OFFSET;
    }

    protected final float getSVal2PI() {
        return this.sVal2PI;
    }

    protected final void setSVal2PI(float f) {
        this.sVal2PI = f;
    }

    protected final boolean getMContinue() {
        return this.mContinue;
    }

    protected final void setMContinue(boolean bl) {
        this.mContinue = bl;
    }

    protected final long getMLastTime() {
        return this.mLastTime;
    }

    protected final void setMLastTime(long l) {
        this.mLastTime = l;
    }

    protected final float getMLastCycle() {
        return this.mLastCycle;
    }

    protected final void setMLastCycle(float f) {
        this.mLastCycle = f;
    }

    @NotNull
    public String toString() {
        String string2 = this.mType;
        Intrinsics.checkNotNull((Object)string2);
        Object str = string2;
        int n = this.mCount;
        for (int i = 0; i < n; ++i) {
            str = (String)str + "[" + this.mTimePoints[i] + " , " + DecimalKt.limitDecimals(this.mValues[i], 2) + "] ";
        }
        return str;
    }

    public final void setType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.mType = type;
    }

    protected final float calcWave(float period) {
        float f;
        switch (this.mWaveShape) {
            case 0: {
                f = (float)Math.sin(period * this.sVal2PI);
                break;
            }
            case 1: {
                f = (float)Math.signum((double)(period * this.sVal2PI));
                break;
            }
            case 2: {
                f = (float)(1.0 - Math.abs((double)period));
                break;
            }
            case 3: {
                f = (period * (float)2 + 1.0f) % (float)2 - 1.0f;
                break;
            }
            case 4: {
                f = 1.0f - (period * (float)2 + 1.0f) % (float)2;
                break;
            }
            case 5: {
                f = (float)Math.cos(period * this.sVal2PI);
                break;
            }
            case 6: {
                float x = (float)(1.0 - Math.abs((double)(period * (float)4 % (float)4 - (float)2)));
                f = 1.0f - x * x;
                break;
            }
            default: {
                f = (float)Math.sin(period * this.sVal2PI);
            }
        }
        return f;
    }

    @NotNull
    public final CurveFit getCurveFit() {
        CurveFit curveFit = this.mCurveFit;
        Intrinsics.checkNotNull((Object)curveFit);
        return curveFit;
    }

    protected final void setStartTime(long currentTime) {
        this.mLastTime = currentTime;
    }

    public void setPoint(int position, float value, float period, int shape, float offset) {
        this.mTimePoints[this.mCount] = position;
        this.mValues[this.mCount][this.CURVE_VALUE] = value;
        this.mValues[this.mCount][this.CURVE_PERIOD] = period;
        this.mValues[this.mCount][this.CURVE_OFFSET] = offset;
        this.mWaveShape = (int)Math.max((double)this.mWaveShape, (double)shape);
        int n = this.mCount;
        this.mCount = n + 1;
    }

    public void setup(int curveType) {
        if (this.mCount == 0) {
            System.out.println((Object)("Error no points added to " + this.mType));
            return;
        }
        Sort.INSTANCE.doubleQuickSort(this.mTimePoints, this.mValues, 0, this.mCount - 1);
        int unique = 0;
        int n = this.mTimePoints.length;
        for (int i = 1; i < n; ++i) {
            if (this.mTimePoints[i] == this.mTimePoints[i - 1]) continue;
            ++unique;
        }
        if (unique == 0) {
            unique = 1;
        }
        double[] time = new double[unique];
        int n2 = 0;
        int n3 = unique;
        double[][] dArrayArray = new double[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            dArrayArray[n4] = new double[3];
        }
        double[][] values = dArrayArray;
        int k = 0;
        int n5 = this.mCount;
        for (int i = 0; i < n5; ++i) {
            if (i > 0 && this.mTimePoints[i] == this.mTimePoints[i - 1]) continue;
            time[k] = (double)this.mTimePoints[i] * 0.01;
            values[k][0] = this.mValues[i][0];
            values[k][1] = this.mValues[i][1];
            values[k][2] = this.mValues[i][2];
            ++k;
        }
        this.mCurveFit = CurveFit.Companion.get(curveType, time, values);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/constraintlayout/core/motion/utils/TimeCycleSplineSet$Companion;", "", "()V", "TAG", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020'J0\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020'H\u0016J&\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020#H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00065"}, d2={"Landroidx/constraintlayout/core/motion/utils/TimeCycleSplineSet$CustomSet;", "Landroidx/constraintlayout/core/motion/utils/TimeCycleSplineSet;", "attribute", "", "attrList", "Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;", "(Ljava/lang/String;Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;)V", "mAttributeName", "getMAttributeName", "()Ljava/lang/String;", "setMAttributeName", "(Ljava/lang/String;)V", "mConstraintAttributeList", "getMConstraintAttributeList", "()Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;", "setMConstraintAttributeList", "(Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomArray;)V", "mCustomCache", "", "getMCustomCache", "()[F", "setMCustomCache", "([F)V", "mTempValues", "getMTempValues", "setMTempValues", "mWaveProperties", "Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$FloatArray;", "getMWaveProperties", "()Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$FloatArray;", "setMWaveProperties", "(Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$FloatArray;)V", "setPoint", "", "position", "", "value", "Landroidx/constraintlayout/core/motion/CustomAttribute;", "period", "", "shape", "offset", "setProperty", "", "view", "Landroidx/constraintlayout/core/motion/MotionWidget;", "t", "time", "", "cache", "Landroidx/constraintlayout/core/motion/utils/KeyCache;", "setup", "curveType", "compose"})
    @StabilityInferred(parameters=0)
    public static final class CustomSet
    extends TimeCycleSplineSet {
        @NotNull
        private String mAttributeName;
        @NotNull
        private KeyFrameArray.CustomArray mConstraintAttributeList;
        @NotNull
        private KeyFrameArray.FloatArray mWaveProperties;
        @Nullable
        private float[] mTempValues;
        @Nullable
        private float[] mCustomCache;
        public static final int $stable = 8;

        @NotNull
        public final String getMAttributeName() {
            return this.mAttributeName;
        }

        public final void setMAttributeName(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.mAttributeName = string2;
        }

        @NotNull
        public final KeyFrameArray.CustomArray getMConstraintAttributeList() {
            return this.mConstraintAttributeList;
        }

        public final void setMConstraintAttributeList(@NotNull KeyFrameArray.CustomArray customArray) {
            Intrinsics.checkNotNullParameter((Object)customArray, (String)"<set-?>");
            this.mConstraintAttributeList = customArray;
        }

        @NotNull
        public final KeyFrameArray.FloatArray getMWaveProperties() {
            return this.mWaveProperties;
        }

        public final void setMWaveProperties(@NotNull KeyFrameArray.FloatArray floatArray) {
            Intrinsics.checkNotNullParameter((Object)floatArray, (String)"<set-?>");
            this.mWaveProperties = floatArray;
        }

        @Nullable
        public final float[] getMTempValues() {
            return this.mTempValues;
        }

        public final void setMTempValues(@Nullable float[] fArray) {
            this.mTempValues = fArray;
        }

        @Nullable
        public final float[] getMCustomCache() {
            return this.mCustomCache;
        }

        public final void setMCustomCache(@Nullable float[] fArray) {
            this.mCustomCache = fArray;
        }

        public CustomSet(@NotNull String attribute, @NotNull KeyFrameArray.CustomArray attrList) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)attrList, (String)"attrList");
            this.mWaveProperties = new KeyFrameArray.FloatArray();
            String[] stringArray = new String[]{","};
            this.mAttributeName = (String)StringsKt.split$default((CharSequence)attribute, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            this.mConstraintAttributeList = attrList;
        }

        @Override
        public void setup(int curveType) {
            int size = this.mConstraintAttributeList.size();
            CustomAttribute customAttribute = this.mConstraintAttributeList.valueAt(0);
            Intrinsics.checkNotNull((Object)customAttribute);
            int dimensionality = customAttribute.numberOfInterpolatedValues();
            double[] time = new double[size];
            this.mTempValues = new float[dimensionality + 2];
            this.mCustomCache = new float[dimensionality];
            int n = 0;
            double[][] dArrayArray = new double[size][];
            while (n < size) {
                int n2 = n++;
                dArrayArray[n2] = new double[dimensionality + 2];
            }
            double[][] values = dArrayArray;
            for (int i = 0; i < size; ++i) {
                CustomAttribute ca;
                int key = this.mConstraintAttributeList.keyAt(i);
                Intrinsics.checkNotNull((Object)this.mConstraintAttributeList.valueAt(i));
                float[] waveProp = this.mWaveProperties.valueAt(i);
                time[i] = (double)key * 0.01;
                Intrinsics.checkNotNull((Object)this.mTempValues);
                ca.getValuesToInterpolate(this.mTempValues);
                Intrinsics.checkNotNull((Object)this.mTempValues);
                int n3 = this.mTempValues.length;
                for (int k = 0; k < n3; ++k) {
                    double[] dArray = values[i];
                    Intrinsics.checkNotNull((Object)this.mTempValues);
                    dArray[k] = this.mTempValues[k];
                }
                values[i][dimensionality] = waveProp[0];
                values[i][dimensionality + 1] = waveProp[1];
            }
            this.setMCurveFit(CurveFit.Companion.get(curveType, time, values));
        }

        @Override
        public void setPoint(int position, float value, float period, int shape, float offset) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute,...)");
        }

        public final void setPoint(int position, @Nullable CustomAttribute value, float period, int shape, float offset) {
            this.mConstraintAttributeList.append(position, value);
            float[] fArray = new float[]{period, offset};
            this.mWaveProperties.append(position, fArray);
            this.setMWaveShape((int)Math.max((double)this.getMWaveShape(), (double)shape));
        }

        public final boolean setProperty(@NotNull MotionWidget view, float t, long time, @NotNull KeyCache cache) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            CurveFit curveFit = this.getMCurveFit();
            Intrinsics.checkNotNull((Object)curveFit);
            double d = t;
            Intrinsics.checkNotNull((Object)this.mTempValues);
            curveFit.getPos(d, this.mTempValues);
            Intrinsics.checkNotNull((Object)this.mTempValues);
            Intrinsics.checkNotNull((Object)this.mTempValues);
            float period = this.mTempValues[this.mTempValues.length - 2];
            Intrinsics.checkNotNull((Object)this.mTempValues);
            Intrinsics.checkNotNull((Object)this.mTempValues);
            float offset = this.mTempValues[this.mTempValues.length - 1];
            long delta_time = time - this.getMLastTime();
            if (Float.isNaN(this.getMLastCycle())) {
                this.setMLastCycle(cache.getFloatValue(view, this.mAttributeName, 0));
                if (Float.isNaN(this.getMLastCycle())) {
                    this.setMLastCycle(0.0f);
                }
            }
            this.setMLastCycle((float)(((double)this.getMLastCycle() + (double)delta_time * 1.0E-9 * (double)period) % 1.0));
            this.setMLastTime(time);
            float wave = this.calcWave(this.getMLastCycle());
            this.setMContinue(false);
            Intrinsics.checkNotNull((Object)this.mCustomCache);
            int n = this.mCustomCache.length;
            for (int i = 0; i < n; ++i) {
                boolean bl = this.getMContinue();
                Intrinsics.checkNotNull((Object)this.mTempValues);
                this.setMContinue(bl | !(this.mTempValues[i] == 0.0f));
                Intrinsics.checkNotNull((Object)this.mCustomCache);
                Intrinsics.checkNotNull((Object)this.mTempValues);
                this.mCustomCache[i] = this.mTempValues[i] * wave + offset;
            }
            CustomAttribute customAttribute = this.mConstraintAttributeList.valueAt(0);
            Intrinsics.checkNotNull((Object)customAttribute);
            Intrinsics.checkNotNull((Object)this.mCustomCache);
            view.setInterpolatedValue(customAttribute, this.mCustomCache);
            if (!(period == 0.0f)) {
                this.setMContinue(true);
            }
            return this.getMContinue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020'J0\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020'H\u0016J(\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020#H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00065"}, d2={"Landroidx/constraintlayout/core/motion/utils/TimeCycleSplineSet$CustomVarSet;", "Landroidx/constraintlayout/core/motion/utils/TimeCycleSplineSet;", "attribute", "", "attrList", "Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;", "(Ljava/lang/String;Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;)V", "mAttributeName", "getMAttributeName", "()Ljava/lang/String;", "setMAttributeName", "(Ljava/lang/String;)V", "mConstraintAttributeList", "getMConstraintAttributeList", "()Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;", "setMConstraintAttributeList", "(Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$CustomVar;)V", "mCustomCache", "", "getMCustomCache", "()[F", "setMCustomCache", "([F)V", "mTempValues", "getMTempValues", "setMTempValues", "mWaveProperties", "Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$FloatArray;", "getMWaveProperties", "()Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$FloatArray;", "setMWaveProperties", "(Landroidx/constraintlayout/core/motion/utils/KeyFrameArray$FloatArray;)V", "setPoint", "", "position", "", "value", "Landroidx/constraintlayout/core/motion/CustomVariable;", "period", "", "shape", "offset", "setProperty", "", "view", "Landroidx/constraintlayout/core/motion/MotionWidget;", "t", "time", "", "cache", "Landroidx/constraintlayout/core/motion/utils/KeyCache;", "setup", "curveType", "compose"})
    @StabilityInferred(parameters=0)
    public static final class CustomVarSet
    extends TimeCycleSplineSet {
        @NotNull
        private String mAttributeName;
        @NotNull
        private KeyFrameArray.CustomVar mConstraintAttributeList;
        @NotNull
        private KeyFrameArray.FloatArray mWaveProperties;
        @Nullable
        private float[] mTempValues;
        @Nullable
        private float[] mCustomCache;
        public static final int $stable = 8;

        @NotNull
        public final String getMAttributeName() {
            return this.mAttributeName;
        }

        public final void setMAttributeName(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.mAttributeName = string2;
        }

        @NotNull
        public final KeyFrameArray.CustomVar getMConstraintAttributeList() {
            return this.mConstraintAttributeList;
        }

        public final void setMConstraintAttributeList(@NotNull KeyFrameArray.CustomVar customVar) {
            Intrinsics.checkNotNullParameter((Object)customVar, (String)"<set-?>");
            this.mConstraintAttributeList = customVar;
        }

        @NotNull
        public final KeyFrameArray.FloatArray getMWaveProperties() {
            return this.mWaveProperties;
        }

        public final void setMWaveProperties(@NotNull KeyFrameArray.FloatArray floatArray) {
            Intrinsics.checkNotNullParameter((Object)floatArray, (String)"<set-?>");
            this.mWaveProperties = floatArray;
        }

        @Nullable
        public final float[] getMTempValues() {
            return this.mTempValues;
        }

        public final void setMTempValues(@Nullable float[] fArray) {
            this.mTempValues = fArray;
        }

        @Nullable
        public final float[] getMCustomCache() {
            return this.mCustomCache;
        }

        public final void setMCustomCache(@Nullable float[] fArray) {
            this.mCustomCache = fArray;
        }

        public CustomVarSet(@NotNull String attribute, @NotNull KeyFrameArray.CustomVar attrList) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)attrList, (String)"attrList");
            this.mWaveProperties = new KeyFrameArray.FloatArray();
            String[] stringArray = new String[]{","};
            this.mAttributeName = (String)StringsKt.split$default((CharSequence)attribute, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            this.mConstraintAttributeList = attrList;
        }

        @Override
        public void setup(int curveType) {
            int size = this.mConstraintAttributeList.size();
            int dimensionality = this.mConstraintAttributeList.valueAt(0).numberOfInterpolatedValues();
            double[] time = new double[size];
            this.mTempValues = new float[dimensionality + 2];
            this.mCustomCache = new float[dimensionality];
            int n = 0;
            double[][] dArrayArray = new double[size][];
            while (n < size) {
                int n2 = n++;
                dArrayArray[n2] = new double[dimensionality + 2];
            }
            double[][] values = dArrayArray;
            for (int i = 0; i < size; ++i) {
                int key = this.mConstraintAttributeList.keyAt(i);
                CustomVariable ca = this.mConstraintAttributeList.valueAt(i);
                float[] waveProp = this.mWaveProperties.valueAt(i);
                time[i] = (double)key * 0.01;
                Intrinsics.checkNotNull((Object)this.mTempValues);
                ca.getValuesToInterpolate(this.mTempValues);
                Intrinsics.checkNotNull((Object)this.mTempValues);
                int n3 = this.mTempValues.length;
                for (int k = 0; k < n3; ++k) {
                    double[] dArray = values[i];
                    Intrinsics.checkNotNull((Object)this.mTempValues);
                    dArray[k] = this.mTempValues[k];
                }
                values[i][dimensionality] = waveProp[0];
                values[i][dimensionality + 1] = waveProp[1];
            }
            this.setMCurveFit(CurveFit.Companion.get(curveType, time, values));
        }

        @Override
        public void setPoint(int position, float value, float period, int shape, float offset) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute,...)");
        }

        public final void setPoint(int position, @Nullable CustomVariable value, float period, int shape, float offset) {
            this.mConstraintAttributeList.append(position, value);
            float[] fArray = new float[]{period, offset};
            this.mWaveProperties.append(position, fArray);
            this.setMWaveShape((int)Math.max((double)this.getMWaveShape(), (double)shape));
        }

        public final boolean setProperty(@Nullable MotionWidget view, float t, long time, @NotNull KeyCache cache) {
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            CurveFit curveFit = this.getMCurveFit();
            Intrinsics.checkNotNull((Object)curveFit);
            double d = t;
            Intrinsics.checkNotNull((Object)this.mTempValues);
            curveFit.getPos(d, this.mTempValues);
            Intrinsics.checkNotNull((Object)this.mTempValues);
            Intrinsics.checkNotNull((Object)this.mTempValues);
            float period = this.mTempValues[this.mTempValues.length - 2];
            Intrinsics.checkNotNull((Object)this.mTempValues);
            Intrinsics.checkNotNull((Object)this.mTempValues);
            float offset = this.mTempValues[this.mTempValues.length - 1];
            long delta_time = time - this.getMLastTime();
            if (Float.isNaN(this.getMLastCycle())) {
                MotionWidget motionWidget = view;
                Intrinsics.checkNotNull((Object)motionWidget);
                this.setMLastCycle(cache.getFloatValue(motionWidget, this.mAttributeName, 0));
                if (Float.isNaN(this.getMLastCycle())) {
                    this.setMLastCycle(0.0f);
                }
            }
            this.setMLastCycle((float)(((double)this.getMLastCycle() + (double)delta_time * 1.0E-9 * (double)period) % 1.0));
            this.setMLastTime(time);
            float wave = this.calcWave(this.getMLastCycle());
            this.setMContinue(false);
            Intrinsics.checkNotNull((Object)this.mCustomCache);
            int n = this.mCustomCache.length;
            for (int i = 0; i < n; ++i) {
                boolean bl = this.getMContinue();
                Intrinsics.checkNotNull((Object)this.mTempValues);
                this.setMContinue(bl | !(this.mTempValues[i] == 0.0f));
                Intrinsics.checkNotNull((Object)this.mCustomCache);
                Intrinsics.checkNotNull((Object)this.mTempValues);
                this.mCustomCache[i] = this.mTempValues[i] * wave + offset;
            }
            CustomVariable customVariable = this.mConstraintAttributeList.valueAt(0);
            MotionWidget motionWidget = view;
            Intrinsics.checkNotNull((Object)motionWidget);
            Intrinsics.checkNotNull((Object)this.mCustomCache);
            customVariable.setInterpolatedValue(motionWidget, this.mCustomCache);
            if (!(period == 0.0f)) {
                this.setMContinue(true);
            }
            return this.getMContinue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u00c4\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ3\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010J3\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u0014"}, d2={"Landroidx/constraintlayout/core/motion/utils/TimeCycleSplineSet$Sort;", "", "()V", "doubleQuickSort", "", "key", "", "value", "", "", "low", "", "hi", "([I[[FII)V", "partition", "array", "([I[[FII)I", "swap", "a", "b", "compose"})
    protected static final class Sort {
        @NotNull
        public static final Sort INSTANCE = new Sort();

        private Sort() {
        }

        public final void doubleQuickSort(@NotNull int[] key, @NotNull float[][] value, int low, int hi) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int low2 = low;
            int hi2 = hi;
            int[] stack = new int[key.length + 10];
            int count = 0;
            stack[count++] = hi2;
            stack[count++] = low2;
            while (count > 0) {
                --count;
                low2 = stack[count];
                if (low2 >= (hi2 = stack[--count])) continue;
                int p = this.partition(key, value, low2, hi2);
                stack[count++] = p - 1;
                stack[count++] = low2;
                stack[count++] = hi2;
                stack[count++] = p + 1;
            }
        }

        private final int partition(int[] array, float[][] value, int low, int hi) {
            int pivot = array[hi];
            int i = low;
            for (int j = low; j < hi; ++j) {
                if (array[j] > pivot) continue;
                this.swap(array, value, i, j);
                ++i;
            }
            this.swap(array, value, i, hi);
            return i;
        }

        private final void swap(int[] array, float[][] value, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
            float[] tmpv = value[a];
            value[a] = value[b];
            value[b] = tmpv;
        }
    }
}

