/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.ext.ArrayKt;
import androidx.constraintlayout.core.motion.utils.MonotonicCurveFit;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000e\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0019J\u000e\u00104\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0019J\u001e\u00105\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0019J\u0016\u00108\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u0019J\u0006\u00109\u001a\u00020.J\u0018\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020(2\b\u0010<\u001a\u0004\u0018\u00010\u0010J\b\u0010=\u001a\u00020\u0010H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0002R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006?"}, d2={"Landroidx/constraintlayout/core/motion/utils/Oscillator;", "", "()V", "mArea", "", "getMArea", "()[D", "setMArea", "([D)V", "mCustomCurve", "Landroidx/constraintlayout/core/motion/utils/MonotonicCurveFit;", "getMCustomCurve", "()Landroidx/constraintlayout/core/motion/utils/MonotonicCurveFit;", "setMCustomCurve", "(Landroidx/constraintlayout/core/motion/utils/MonotonicCurveFit;)V", "mCustomType", "", "getMCustomType", "()Ljava/lang/String;", "setMCustomType", "(Ljava/lang/String;)V", "mNormalized", "", "getMNormalized$annotations", "mPI2", "", "getMPI2", "()D", "setMPI2", "(D)V", "mPeriod", "", "getMPeriod", "()[F", "setMPeriod", "([F)V", "mPosition", "getMPosition", "setMPosition", "mType", "", "getMType", "()I", "setMType", "(I)V", "addPoint", "", "position", "period", "", "getDP", "time", "getP", "getSlope", "phase", "dphase", "getValue", "normalize", "setType", "type", "customType", "toString", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class Oscillator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private float[] mPeriod = new float[0];
    @NotNull
    private double[] mPosition = new double[0];
    @Nullable
    private double[] mArea;
    @Nullable
    private String mCustomType;
    @Nullable
    private MonotonicCurveFit mCustomCurve;
    private int mType;
    private double mPI2 = Math.PI * 2;
    private boolean mNormalized;
    public static final int $stable = 8;
    @NotNull
    private static String TAG = "Oscillator";
    public static final int SIN_WAVE = 0;
    public static final int SQUARE_WAVE = 1;
    public static final int TRIANGLE_WAVE = 2;
    public static final int SAW_WAVE = 3;
    public static final int REVERSE_SAW_WAVE = 4;
    public static final int COS_WAVE = 5;
    public static final int BOUNCE = 6;
    public static final int CUSTOM = 7;

    @NotNull
    public final float[] getMPeriod() {
        return this.mPeriod;
    }

    public final void setMPeriod(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.mPeriod = fArray;
    }

    @NotNull
    public final double[] getMPosition() {
        return this.mPosition;
    }

    public final void setMPosition(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.mPosition = dArray;
    }

    @Nullable
    public final double[] getMArea() {
        return this.mArea;
    }

    public final void setMArea(@Nullable double[] dArray) {
        this.mArea = dArray;
    }

    @Nullable
    public final String getMCustomType() {
        return this.mCustomType;
    }

    public final void setMCustomType(@Nullable String string2) {
        this.mCustomType = string2;
    }

    @Nullable
    public final MonotonicCurveFit getMCustomCurve() {
        return this.mCustomCurve;
    }

    public final void setMCustomCurve(@Nullable MonotonicCurveFit monotonicCurveFit) {
        this.mCustomCurve = monotonicCurveFit;
    }

    public final int getMType() {
        return this.mType;
    }

    public final void setMType(int n) {
        this.mType = n;
    }

    public final double getMPI2() {
        return this.mPI2;
    }

    public final void setMPI2(double d) {
        this.mPI2 = d;
    }

    private static /* synthetic */ void getMNormalized$annotations() {
    }

    @NotNull
    public String toString() {
        String string2 = Arrays.toString(this.mPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = Arrays.toString(this.mPeriod);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return "pos =" + string2 + " period=" + string3;
    }

    public final void setType(int type, @Nullable String customType) {
        this.mType = type;
        this.mCustomType = customType;
        if (this.mCustomType != null) {
            String string2 = customType;
            Intrinsics.checkNotNull((Object)string2);
            this.mCustomCurve = MonotonicCurveFit.Companion.buildWave(string2);
        }
    }

    public final void addPoint(double position, float period) {
        int len = this.mPeriod.length + 1;
        int j = ArrayKt.binarySearch$default(this.mPosition, position, 0, 0, 6, null);
        if (j < 0) {
            j = -j - 1;
        }
        double[] dArray = Arrays.copyOf(this.mPosition, len);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
        this.mPosition = dArray;
        float[] fArray = Arrays.copyOf(this.mPeriod, len);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        this.mPeriod = fArray;
        this.mArea = new double[len];
        ArraysKt.copyInto((double[])this.mPosition, (double[])this.mPosition, (int)(j + 1), (int)j, (int)(len - 1));
        this.mPosition[j] = position;
        this.mPeriod[j] = period;
        this.mNormalized = false;
    }

    public final void normalize() {
        int i;
        double totalArea = 0.0;
        double totalCount = 0.0;
        int n = this.mPeriod.length;
        for (i = 0; i < n; ++i) {
            totalCount += (double)this.mPeriod[i];
        }
        n = this.mPeriod.length;
        for (i = 1; i < n; ++i) {
            float h = (this.mPeriod[i - 1] + this.mPeriod[i]) / (float)2;
            double w = this.mPosition[i] - this.mPosition[i - 1];
            totalArea += w * (double)h;
        }
        i = 0;
        n = this.mPeriod.length;
        while (i < n) {
            float[] h = this.mPeriod;
            int w = i++;
            h[w] = h[w] * (float)(totalCount / totalArea);
        }
        Intrinsics.checkNotNull((Object)this.mArea);
        this.mArea[0] = 0.0;
        n = this.mPeriod.length;
        for (i = 1; i < n; ++i) {
            float h = (this.mPeriod[i - 1] + this.mPeriod[i]) / (float)2;
            double w = this.mPosition[i] - this.mPosition[i - 1];
            Intrinsics.checkNotNull((Object)this.mArea);
            Intrinsics.checkNotNull((Object)this.mArea);
            this.mArea[i] = this.mArea[i - 1] + w * (double)h;
        }
        this.mNormalized = true;
    }

    public final double getP(double time) {
        double time2 = time;
        if (time2 < 0.0) {
            time2 = 0.0;
        } else if (time2 > 1.0) {
            time2 = 1.0;
        }
        int index = ArrayKt.binarySearch$default(this.mPosition, time2, 0, 0, 6, null);
        double p = 0.0;
        if (index > 0) {
            p = 1.0;
        } else if (index != 0) {
            index = -index - 1;
            double t = time2;
            double m = (double)(this.mPeriod[index] - this.mPeriod[index - 1]) / (this.mPosition[index] - this.mPosition[index - 1]);
            Intrinsics.checkNotNull((Object)this.mArea);
            p = this.mArea[index - 1] + ((double)this.mPeriod[index - 1] - m * this.mPosition[index - 1]) * (t - this.mPosition[index - 1]) + m * (t * t - this.mPosition[index - 1] * this.mPosition[index - 1]) / (double)2;
        }
        return p;
    }

    public final double getValue(double time, double phase) {
        double d;
        double angle = phase + this.getP(time);
        switch (this.mType) {
            case 0: {
                d = Math.sin(this.mPI2 * angle);
                break;
            }
            case 1: {
                d = Math.signum(0.5 - angle % 1.0);
                break;
            }
            case 2: {
                d = 1.0 - Math.abs((angle * (double)4 + 1.0) % (double)4 - (double)2);
                break;
            }
            case 3: {
                d = (angle * (double)2 + 1.0) % (double)2 - 1.0;
                break;
            }
            case 4: {
                d = 1.0 - (angle * (double)2 + 1.0) % (double)2;
                break;
            }
            case 5: {
                d = Math.cos(this.mPI2 * (phase + angle));
                break;
            }
            case 6: {
                double x = 1.0 - Math.abs(angle * (double)4 % (double)4 - (double)2);
                d = 1.0 - x * x;
                break;
            }
            case 7: {
                MonotonicCurveFit monotonicCurveFit = this.mCustomCurve;
                Intrinsics.checkNotNull((Object)monotonicCurveFit);
                d = monotonicCurveFit.getPos(angle % 1.0, 0);
                break;
            }
            default: {
                d = Math.sin(this.mPI2 * angle);
            }
        }
        return d;
    }

    public final double getDP(double time) {
        double time2 = time;
        if (time2 <= 0.0) {
            time2 = 1.0E-5;
        } else if (time2 >= 1.0) {
            time2 = 0.999999;
        }
        int index = ArrayKt.binarySearch$default(this.mPosition, time2, 0, 0, 6, null);
        double p = 0.0;
        if (index > 0) {
            return 0.0;
        }
        if (index != 0) {
            index = -index - 1;
            double t = time2;
            double m = (double)(this.mPeriod[index] - this.mPeriod[index - 1]) / (this.mPosition[index] - this.mPosition[index - 1]);
            p = m * t + ((double)this.mPeriod[index - 1] - m * this.mPosition[index - 1]);
        }
        return p;
    }

    public final double getSlope(double time, double phase, double dphase) {
        double d;
        double angle = phase + this.getP(time);
        double dangle_dtime = this.getDP(time) + dphase;
        switch (this.mType) {
            case 0: {
                d = this.mPI2 * dangle_dtime * Math.cos(this.mPI2 * angle);
                break;
            }
            case 1: {
                d = 0.0;
                break;
            }
            case 2: {
                d = (double)4 * dangle_dtime * Math.signum((angle * (double)4 + (double)3) % (double)4 - (double)2);
                break;
            }
            case 3: {
                d = dangle_dtime * (double)2;
                break;
            }
            case 4: {
                d = -dangle_dtime * (double)2;
                break;
            }
            case 5: {
                d = -this.mPI2 * dangle_dtime * Math.sin(this.mPI2 * angle);
                break;
            }
            case 6: {
                d = (double)4 * dangle_dtime * ((angle * (double)4 + (double)2) % (double)4 - (double)2);
                break;
            }
            case 7: {
                MonotonicCurveFit monotonicCurveFit = this.mCustomCurve;
                Intrinsics.checkNotNull((Object)monotonicCurveFit);
                d = monotonicCurveFit.getSlope(angle % 1.0, 0);
                break;
            }
            default: {
                d = this.mPI2 * dangle_dtime * Math.cos(this.mPI2 * angle);
            }
        }
        return d;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/constraintlayout/core/motion/utils/Oscillator$Companion;", "", "()V", "BOUNCE", "", "COS_WAVE", "CUSTOM", "REVERSE_SAW_WAVE", "SAW_WAVE", "SIN_WAVE", "SQUARE_WAVE", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "TRIANGLE_WAVE", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public final void setTAG(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            TAG = string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

