/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/constraintlayout/core/motion/utils/LinearCurveFit;", "Landroidx/constraintlayout/core/motion/utils/CurveFit;", "time", "", "y", "", "([D[[D)V", "mExtrapolate", "", "mSlopeTemp", "getMSlopeTemp", "()[D", "setMSlopeTemp", "([D)V", "mT", "mTotalLength", "", "mY", "[[D", "getLength2D", "t", "getPos", "", "v", "", "j", "", "getSlope", "getTimePoints", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class LinearCurveFit
extends CurveFit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] mT;
    @NotNull
    private final double[][] mY;
    private double mTotalLength;
    private final boolean mExtrapolate;
    @NotNull
    private double[] mSlopeTemp;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "LinearCurveFit";

    @NotNull
    public final double[] getMSlopeTemp() {
        return this.mSlopeTemp;
    }

    public final void setMSlopeTemp(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.mSlopeTemp = dArray;
    }

    public LinearCurveFit(@NotNull double[] time, @NotNull double[][] y) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.mTotalLength = Double.NaN;
        this.mExtrapolate = true;
        int dim = y[0].length;
        this.mSlopeTemp = new double[dim];
        this.mT = time;
        this.mY = y;
        if (dim > 2) {
            double sum = 0.0;
            double lastx = 0.0;
            double lasty = 0.0;
            int n = time.length;
            for (int i = 0; i < n; ++i) {
                double px = y[i][0];
                double py = y[i][0];
                if (i > 0) {
                    sum += Math.hypot(px - lastx, py - lasty);
                }
                lastx = px;
                lasty = py;
            }
            this.mTotalLength = 0.0;
        }
    }

    private final double getLength2D(double t) {
        if (Double.isNaN(this.mTotalLength)) {
            return 0.0;
        }
        int n = this.mT.length;
        if (t <= this.mT[0]) {
            return 0.0;
        }
        if (t >= this.mT[n - 1]) {
            return this.mTotalLength;
        }
        double sum = 0.0;
        double last_x = 0.0;
        double last_y = 0.0;
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            double px = this.mY[i][0];
            double py = this.mY[i][1];
            if (i > 0) {
                sum += Math.hypot(px - last_x, py - last_y);
            }
            last_x = px;
            last_y = py;
            if (t == this.mT[i]) {
                return sum;
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double x1 = this.mY[i][0];
            double x2 = this.mY[i + 1][0];
            double y1 = this.mY[i][1];
            double y2 = this.mY[i + 1][1];
            return sum += Math.hypot(py -= y1 * (1.0 - x) + y2 * x, px -= x1 * (1.0 - x) + x2 * x);
        }
        return 0.0;
    }

    @Override
    public void getPos(double t, @NotNull double[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                this.getSlope(this.mT[0], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[0][j] + (t - this.mT[0]) * this.mSlopeTemp[j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                this.getSlope(this.mT[n - 1], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.mSlopeTemp[j];
                }
                return;
            }
        } else {
            if (t <= this.mT[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[0][j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[n - 1][j];
                }
                return;
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                v[j] = y1 * (1.0 - x) + y2 * x;
            }
            return;
        }
    }

    @Override
    public void getPos(double t, @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                this.getSlope(this.mT[0], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)(this.mY[0][j] + (t - this.mT[0]) * this.mSlopeTemp[j]);
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                this.getSlope(this.mT[n - 1], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)(this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.mSlopeTemp[j]);
                }
                return;
            }
        } else {
            if (t <= this.mT[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[0][j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[n - 1][j];
                }
                return;
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                v[j] = (float)(y1 * (1.0 - x) + y2 * x);
            }
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        int n = this.mT.length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                return this.mY[0][j] + (t - this.mT[0]) * this.getSlope(this.mT[0], j);
            }
            if (t >= this.mT[n - 1]) {
                return this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.getSlope(this.mT[n - 1], j);
            }
        } else {
            if (t <= this.mT[0]) {
                return this.mY[0][j];
            }
            if (t >= this.mT[n - 1]) {
                return this.mY[n - 1][j];
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.mT[i]) {
                return this.mY[i][j];
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            return y1 * (1.0 - x) + y2 * x;
        }
        return 0.0;
    }

    @Override
    public void getSlope(double t, @NotNull double[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double t2 = t;
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t2 <= this.mT[0]) {
            t2 = this.mT[0];
        } else if (t2 >= this.mT[n - 1]) {
            t2 = this.mT[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t2 <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                v[j] = (y2 - y1) / h;
            }
            break;
        }
    }

    @Override
    public double getSlope(double t, int j) {
        double t2 = t;
        int n = this.mT.length;
        if (t2 < this.mT[0]) {
            t2 = this.mT[0];
        } else if (t2 >= this.mT[n - 1]) {
            t2 = this.mT[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t2 <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            return (y2 - y1) / h;
        }
        return 0.0;
    }

    @Override
    @NotNull
    public double[] getTimePoints() {
        return this.mT;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/constraintlayout/core/motion/utils/LinearCurveFit$Companion;", "", "()V", "TAG", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

