/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\rRn\u0010\u0003\u001aV\u0012\u0004\u0012\u00020\u0001\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u00070\u0004j*\u0012\u0004\u0012\u00020\u0001\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Landroidx/constraintlayout/core/motion/utils/KeyCache;", "", "()V", "mMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getMMap", "()Ljava/util/HashMap;", "setMMap", "(Ljava/util/HashMap;)V", "getFloatValue", "", "view", "type", "element", "", "setFloatValue", "", "value", "compose"})
@StabilityInferred(parameters=0)
public final class KeyCache {
    @NotNull
    private HashMap<Object, HashMap<String, float[]>> mMap = new HashMap();
    public static final int $stable = 8;

    @NotNull
    public final HashMap<Object, HashMap<String, float[]>> getMMap() {
        return this.mMap;
    }

    public final void setMMap(@NotNull HashMap<Object, HashMap<String, float[]>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.mMap = hashMap;
    }

    public final void setFloatValue(@NotNull Object view, @NotNull String type, int element, float value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!this.mMap.containsKey(view)) {
            HashMap array = new HashMap();
            float[] vArray = new float[element + 1];
            vArray[element] = value;
            ((Map)array).put(type, vArray);
            ((Map)this.mMap).put(view, array);
        } else {
            HashMap<String, Object> array = this.mMap.get(view);
            if (array == null) {
                array = new HashMap();
            }
            if (!array.containsKey(type)) {
                float[] vArray = new float[element + 1];
                vArray[element] = value;
                ((Map)array).put(type, vArray);
                ((Map)this.mMap).put(view, array);
            } else {
                float[] vArray = (float[])array.get(type);
                if (vArray == null) {
                    vArray = new float[]{};
                }
                if (vArray.length <= element) {
                    float[] fArray = Arrays.copyOf(vArray, element + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
                    vArray = fArray;
                }
                vArray[element] = value;
                ((Map)array).put(type, vArray);
            }
        }
    }

    public final float getFloatValue(@NotNull Object view, @NotNull String type, int element) {
        float f;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!this.mMap.containsKey(view)) {
            f = Float.NaN;
        } else {
            HashMap<String, float[]> array = this.mMap.get(view);
            if (array == null || !array.containsKey(type)) {
                return Float.NaN;
            }
            float[] fArray = array.get(type);
            if (fArray == null) {
                return Float.NaN;
            }
            float[] vArray = fArray;
            f = vArray.length > element ? vArray[element] : Float.NaN;
        }
        return f;
    }
}

