/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0006\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010'\u001a\u00020\"2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0004J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.J\u0016\u0010*\u001a\u00020\"2\u0006\u0010,\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u0019J\u0016\u00100\u001a\u00020+2\u0006\u0010,\u001a\u00020\"2\u0006\u00101\u001a\u00020\u0004J\u0019\u00102\u001a\u00020+2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R$\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0005R*\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0003\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00064"}, d2={"Landroidx/constraintlayout/core/motion/utils/HyperSpline;", "", "points", "", "", "([[D)V", "()V", "mCtl", "getMCtl", "()[[D", "setMCtl", "[[D", "mCurve", "Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion$Cubic;", "getMCurve", "()[[Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion$Cubic;", "setMCurve", "([[Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion$Cubic;)V", "[[Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion$Cubic;", "mCurveLength", "getMCurveLength", "()[D", "setMCurveLength", "([D)V", "mDimensionality", "", "getMDimensionality", "()I", "setMDimensionality", "(I)V", "mPoints", "getMPoints", "setMPoints", "mTotalLength", "", "getMTotalLength", "()D", "setMTotalLength", "(D)V", "approxLength", "curve", "([Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion$Cubic;)D", "getPos", "", "p", "x", "", "splineNumber", "getVelocity", "v", "setup", "Companion", "compose"})
@StabilityInferred(parameters=0)
public final class HyperSpline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mPoints;
    @Nullable
    private Companion.Cubic[][] mCurve;
    private int mDimensionality;
    @Nullable
    private double[] mCurveLength;
    private double mTotalLength;
    @Nullable
    private double[][] mCtl;
    public static final int $stable = 8;

    public final int getMPoints() {
        return this.mPoints;
    }

    public final void setMPoints(int n) {
        this.mPoints = n;
    }

    @Nullable
    public final Companion.Cubic[][] getMCurve() {
        return this.mCurve;
    }

    public final void setMCurve(@Nullable Companion.Cubic[][] cubicArray) {
        this.mCurve = cubicArray;
    }

    public final int getMDimensionality() {
        return this.mDimensionality;
    }

    public final void setMDimensionality(int n) {
        this.mDimensionality = n;
    }

    @Nullable
    public final double[] getMCurveLength() {
        return this.mCurveLength;
    }

    public final void setMCurveLength(@Nullable double[] dArray) {
        this.mCurveLength = dArray;
    }

    public final double getMTotalLength() {
        return this.mTotalLength;
    }

    public final void setMTotalLength(double d) {
        this.mTotalLength = d;
    }

    @Nullable
    public final double[][] getMCtl() {
        return this.mCtl;
    }

    public final void setMCtl(@Nullable double[][] dArray) {
        this.mCtl = dArray;
    }

    public HyperSpline(@NotNull double[][] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        this.setup(points);
    }

    public HyperSpline() {
    }

    public final void setup(@NotNull double[][] points) {
        int d;
        int n;
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        this.mDimensionality = points[0].length;
        this.mPoints = ((Object[])points).length;
        int n2 = 0;
        int n3 = this.mDimensionality;
        double[][] dArrayArray = new double[n3][];
        HyperSpline hyperSpline = this;
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[this.mPoints];
        }
        hyperSpline.mCtl = dArrayArray;
        n3 = this.mDimensionality;
        for (d = 0; d < n3; ++d) {
            n = this.mPoints;
            for (int p = 0; p < n; ++p) {
                Intrinsics.checkNotNull((Object)this.mCtl);
                this.mCtl[d][p] = points[p][d];
            }
        }
        d = 0;
        n3 = this.mDimensionality;
        Companion.Cubic[][] p = new Companion.Cubic[n3][];
        hyperSpline = this;
        while (d < n3) {
            n = d++;
            Intrinsics.checkNotNull((Object)this.mCtl);
            int n4 = this.mCtl[n].length;
            Intrinsics.checkNotNull((Object)this.mCtl);
            p[n] = Companion.calcNaturalCubic(n4, this.mCtl[n]);
        }
        hyperSpline.mCurve = p;
        this.mCurveLength = new double[this.mPoints - 1];
        this.mTotalLength = 0.0;
        Intrinsics.checkNotNull((Object)this.mCurveLength);
        n3 = this.mCurveLength.length;
        for (int p2 = 0; p2 < n3; ++p2) {
            n = 0;
            int n5 = this.mDimensionality;
            Companion.Cubic[] cubicArray = new Companion.Cubic[n5];
            while (n < n5) {
                int n6 = n++;
                Intrinsics.checkNotNull((Object)this.mCurve);
                cubicArray[n6] = this.mCurve[n6][p2];
            }
            Companion.Cubic[] temp = cubicArray;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            this.mCurveLength[p2] = this.approxLength(temp);
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            this.mTotalLength += this.mCurveLength[p2];
        }
    }

    public final void getVelocity(double p, @NotNull double[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double pos = p * this.mTotalLength;
        int k = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            if (k >= this.mCurveLength.length - 1) break;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            if (!(this.mCurveLength[k] < pos)) break;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            pos -= this.mCurveLength[k];
            ++k;
        }
        int n = v.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mCurve);
            Companion.Cubic cubic = this.mCurve[i][k];
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            v[i] = cubic.vel(pos / this.mCurveLength[k]);
        }
    }

    public final void getPos(double p, @NotNull double[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        double pos = p * this.mTotalLength;
        int k = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            if (k >= this.mCurveLength.length - 1) break;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            if (!(this.mCurveLength[k] < pos)) break;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            pos -= this.mCurveLength[k];
            ++k;
        }
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mCurve);
            Companion.Cubic cubic = this.mCurve[i][k];
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            x[i] = cubic.eval(pos / this.mCurveLength[k]);
        }
    }

    public final void getPos(double p, @NotNull float[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        double pos = p * this.mTotalLength;
        int k = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            if (k >= this.mCurveLength.length - 1) break;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            if (!(this.mCurveLength[k] < pos)) break;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            pos -= this.mCurveLength[k];
            ++k;
        }
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.mCurve);
            Companion.Cubic cubic = this.mCurve[i][k];
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            x[i] = (float)cubic.eval(pos / this.mCurveLength[k]);
        }
    }

    public final double getPos(double p, int splineNumber) {
        double pos = p * this.mTotalLength;
        int k = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            if (k >= this.mCurveLength.length - 1) break;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            if (!(this.mCurveLength[k] < pos)) break;
            Intrinsics.checkNotNull((Object)this.mCurveLength);
            pos -= this.mCurveLength[k];
            ++k;
        }
        Intrinsics.checkNotNull((Object)this.mCurve);
        Companion.Cubic cubic = this.mCurve[splineNumber][k];
        Intrinsics.checkNotNull((Object)this.mCurveLength);
        return cubic.eval(pos / this.mCurveLength[k]);
    }

    public final double approxLength(@NotNull Companion.Cubic[] curve) {
        double tmp;
        int j;
        double s;
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        double sum = 0.0;
        int n = curve.length;
        double[] old = new double[n];
        for (double i = 0.0; i < 1.0; i += 0.1) {
            s = 0.0;
            for (j = 0; j < n; ++j) {
                tmp = old[j];
                old[j] = curve[j].eval(i);
                s += (tmp -= old[j]) * tmp;
            }
            if (!(i > 0.0)) continue;
            sum += Math.sqrt(s);
        }
        s = 0.0;
        for (j = 0; j < n; ++j) {
            tmp = old[j];
            old[j] = curve[j].eval(1.0);
            s += (tmp -= old[j]) * tmp;
        }
        return sum += Math.sqrt(s);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion;", "", "()V", "calcNaturalCubic", "", "Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion$Cubic;", "n", "", "x", "", "(I[D)[Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion$Cubic;", "Cubic", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Cubic[] calcNaturalCubic(int n, @NotNull double[] x) {
            int i;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int n2 = n;
            double[] gamma = new double[n2];
            double[] delta = new double[n2];
            double[] d = new double[n2];
            gamma[0] = 0.5;
            int n3 = --n2;
            for (i = 1; i < n3; ++i) {
                gamma[i] = 1.0 / ((double)4 - gamma[i - 1]);
            }
            gamma[n2] = 1.0 / ((double)2 - gamma[n2 - 1]);
            delta[0] = (double)3 * (x[1] - x[0]) * gamma[0];
            n3 = n2;
            for (i = 1; i < n3; ++i) {
                delta[i] = ((double)3 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
            }
            delta[n2] = ((double)3 * (x[n2] - x[n2 - 1]) - delta[n2 - 1]) * gamma[n2];
            d[n2] = delta[n2];
            for (i = n2 - 1; -1 < i; --i) {
                d[i] = delta[i] - gamma[i] * d[i + 1];
            }
            n3 = 0;
            int n4 = n2;
            Cubic[] cubicArray = new Cubic[n4];
            while (n3 < n4) {
                int n5 = n3++;
                cubicArray[n5] = new Cubic((float)x[n5], d[n5], (double)3 * (x[n5 + 1] - x[n5]) - (double)2 * d[n5] - d[n5 + 1], (double)2 * (x[n5] - x[n5 + 1]) + d[n5] + d[n5 + 1]);
            }
            Cubic[] c = cubicArray;
            return c;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0017\b\u0007\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\f\u00a8\u0006\u001a"}, d2={"Landroidx/constraintlayout/core/motion/utils/HyperSpline$Companion$Cubic;", "", "a", "", "b", "c", "d", "(DDDD)V", "mA", "getMA", "()D", "setMA", "(D)V", "mB", "getMB", "setMB", "mC", "getMC", "setMC", "mD", "getMD", "setMD", "eval", "u", "vel", "v", "compose"})
        @StabilityInferred(parameters=0)
        public static final class Cubic {
            private double mA;
            private double mB;
            private double mC;
            private double mD;
            public static final int $stable = 8;

            public final double getMA() {
                return this.mA;
            }

            public final void setMA(double d) {
                this.mA = d;
            }

            public final double getMB() {
                return this.mB;
            }

            public final void setMB(double d) {
                this.mB = d;
            }

            public final double getMC() {
                return this.mC;
            }

            public final void setMC(double d) {
                this.mC = d;
            }

            public final double getMD() {
                return this.mD;
            }

            public final void setMD(double d) {
                this.mD = d;
            }

            public Cubic(double a, double b, double c, double d) {
                this.mA = a;
                this.mB = b;
                this.mC = c;
                this.mD = d;
            }

            public final double eval(double u) {
                return ((this.mD * u + this.mC) * u + this.mB) * u + this.mA;
            }

            public final double vel(double v) {
                return (this.mD * (double)3 * v + this.mC * (double)2) * v + this.mB;
            }
        }
    }
}

